/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.xmlrpc.internal;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.astrogrid.samp.httpd.HttpServer;
import org.astrogrid.samp.httpd.UtilServer;
import org.astrogrid.samp.xmlrpc.SampXmlRpcHandler;
import org.astrogrid.samp.xmlrpc.SampXmlRpcServer;
import org.astrogrid.samp.xmlrpc.internal.XmlRpcFormatException;
import org.astrogrid.samp.xmlrpc.internal.XmlUtils;
import org.astrogrid.samp.xmlrpc.internal.XmlWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class InternalServer
implements SampXmlRpcServer {
    private final HttpServer server_;
    private final URL endpoint_;
    private final List handlerList_;
    private static final HttpServer.Response GET_RESPONSE;
    private static final HttpServer.Response HEAD_RESPONSE;
    private static final Logger logger_;
    static final /* synthetic */ boolean $assertionsDisabled;

    public InternalServer(HttpServer httpServer, final String path) throws IOException {
        this.server_ = httpServer;
        this.endpoint_ = new URL(this.server_.getBaseUrl(), path);
        this.handlerList_ = Collections.synchronizedList(new ArrayList());
        this.server_.addHandler(new HttpServer.Handler(){

            public HttpServer.Response serveRequest(HttpServer.Request req) {
                if (req.getUrl().equals(path)) {
                    String method = req.getMethod();
                    if ("POST".equals(method)) {
                        return InternalServer.this.getXmlRpcResponse(req);
                    }
                    if ("GET".equals(method)) {
                        return GET_RESPONSE;
                    }
                    if ("HEAD".equals(method)) {
                        return HEAD_RESPONSE;
                    }
                    return HttpServer.create405Response(new String[]{"POST", "GET", "HEAD"});
                }
                return null;
            }
        });
    }

    public InternalServer() throws IOException {
        this(UtilServer.getInstance().getServer(), UtilServer.getInstance().getBasePath("/xmlrpc"));
    }

    public URL getEndpoint() {
        return this.endpoint_;
    }

    public HttpServer getHttpServer() {
        return this.server_;
    }

    public void addHandler(SampXmlRpcHandler handler) {
        this.handlerList_.add(handler);
    }

    public void removeHandler(SampXmlRpcHandler handler) {
        this.handlerList_.remove(handler);
    }

    protected HttpServer.Response getXmlRpcResponse(HttpServer.Request request) {
        byte[] rbuf;
        try {
            rbuf = this.getResultBytes(this.getXmlRpcResult(request));
        }
        catch (Throwable e) {
            boolean isSerious = e instanceof Error;
            logger_.log(isSerious ? Level.WARNING : Level.INFO, "XML-RPC fault return", e);
            try {
                rbuf = this.getFaultBytes(e);
            }
            catch (IOException e2) {
                return HttpServer.createErrorResponse(500, "Server error", e2);
            }
        }
        final byte[] replyBuf = rbuf;
        LinkedHashMap<String, String> hdrMap = new LinkedHashMap<String, String>();
        hdrMap.put("Content-Length", Integer.toString(replyBuf.length));
        hdrMap.put("Content-Type", "text/xml");
        return new HttpServer.Response(200, "OK", hdrMap){

            public void writeBody(OutputStream out) throws IOException {
                out.write(replyBuf);
            }
        };
    }

    private Object getXmlRpcResult(HttpServer.Request request) throws Exception {
        byte[] body = request.getBody();
        if (body == null || body.length == 0) {
            throw new XmlRpcFormatException("No body in POSTed request");
        }
        Document doc = XmlUtils.createDocumentBuilder().parse(new ByteArrayInputStream(body));
        Element call = XmlUtils.getChild(doc, "methodCall");
        String methodName = null;
        Element paramsEl = null;
        Element[] methodChildren = XmlUtils.getChildren(call);
        for (int i = 0; i < methodChildren.length; ++i) {
            Element el = methodChildren[i];
            String tagName = el.getTagName();
            if (tagName.equals("methodName")) {
                methodName = XmlUtils.getTextContent(el);
                continue;
            }
            if (!tagName.equals("params")) continue;
            paramsEl = el;
        }
        if (methodName == null) {
            throw new XmlRpcFormatException("No methodName element");
        }
        SampXmlRpcHandler handler = null;
        SampXmlRpcHandler[] handlers = this.handlerList_.toArray(new SampXmlRpcHandler[0]);
        for (int ih = 0; ih < handlers.length && handler == null; ++ih) {
            SampXmlRpcHandler h = handlers[ih];
            if (!h.canHandleCall(methodName)) continue;
            handler = h;
        }
        if (handler == null) {
            throw new XmlRpcFormatException("Unknown XML-RPC method " + methodName);
        }
        Element[] paramEls = paramsEl == null ? new Element[]{} : XmlUtils.getChildren(paramsEl);
        int np = paramEls.length;
        ArrayList<Object> paramList = new ArrayList<Object>(np);
        for (int i = 0; i < np; ++i) {
            Element paramEl = paramEls[i];
            if (!"param".equals(paramEl.getTagName())) {
                throw new XmlRpcFormatException("Non-param child of params");
            }
            Element valueEl = XmlUtils.getChild(paramEl, "value");
            paramList.add(XmlUtils.parseSampValue(valueEl));
        }
        return this.handleCall(handler, methodName, paramList, request);
    }

    protected Object handleCall(SampXmlRpcHandler handler, String methodName, List paramList, HttpServer.Request request) throws Exception {
        return handler.handleCall(methodName, paramList, request);
    }

    private byte[] getResultBytes(Object result) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BufferedOutputStream bout = new BufferedOutputStream(out);
        XmlWriter xout = new XmlWriter(bout, 2);
        xout.start("methodResponse");
        xout.start("params");
        xout.start("param");
        xout.sampValue(result);
        xout.end("param");
        xout.end("params");
        xout.end("methodResponse");
        xout.close();
        return out.toByteArray();
    }

    private byte[] getFaultBytes(Throwable error) throws IOException {
        int faultCode = 1;
        String faultString = error.toString();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BufferedOutputStream bout = new BufferedOutputStream(out);
        XmlWriter xout = new XmlWriter(bout, 2);
        xout.start("methodResponse");
        xout.start("fault");
        xout.start("value");
        xout.start("struct");
        xout.start("member");
        xout.inline("name", "faultCode");
        xout.start("value");
        xout.inline("int", Integer.toString(faultCode));
        xout.end("value");
        xout.end("member");
        xout.start("member");
        xout.inline("name", "faultString");
        xout.inline("value", faultString);
        xout.end("member");
        xout.end("struct");
        xout.end("value");
        xout.end("fault");
        xout.end("methodResponse");
        xout.close();
        return out.toByteArray();
    }

    private static HttpServer.Response createInfoResponse(final boolean withData) {
        byte[] buf1;
        String text = "<html>\n" + "<head><title>XML-RPC</title></head>\n" + "<body>\n" + "<h1>XML-RPC Server</h1>\n" + "<p>This is an " + "<a href='http://www.xmlrpc.com/'>XML-RPC</a> server.\n" + "</p>\n" + "<p>Try POSTing.</p>\n" + "</body>\n" + "</html>\n";
        try {
            buf1 = text.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)"no UTF-8??");
            }
            buf1 = new byte[]{};
        }
        final byte[] buf = buf1;
        LinkedHashMap<String, String> hdrMap = new LinkedHashMap<String, String>();
        hdrMap.put("Content-Type", "text/html");
        hdrMap.put("Content-Length", Integer.toString(buf.length));
        return new HttpServer.Response(200, "OK", hdrMap){

            public void writeBody(OutputStream out) throws IOException {
                if (withData) {
                    out.write(buf);
                }
            }
        };
    }

    static {
        $assertionsDisabled = !InternalServer.class.desiredAssertionStatus();
        GET_RESPONSE = InternalServer.createInfoResponse(true);
        HEAD_RESPONSE = InternalServer.createInfoResponse(false);
        logger_ = Logger.getLogger(InternalServer.class.getName());
    }
}

