/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.xmlrpc;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.astrogrid.samp.ErrInfo;
import org.astrogrid.samp.Message;
import org.astrogrid.samp.Response;
import org.astrogrid.samp.client.CallableClient;
import org.astrogrid.samp.client.HubConnection;
import org.astrogrid.samp.xmlrpc.ActorHandler;
import org.astrogrid.samp.xmlrpc.ClientActor;

class ClientXmlRpcHandler
extends ActorHandler {
    private final ClientActorImpl clientActor_ = (ClientActorImpl)this.getActor();
    private static final Logger logger_ = Logger.getLogger(ClientXmlRpcHandler.class.getName());

    public ClientXmlRpcHandler() {
        super("samp.client.", ClientActor.class, new ClientActorImpl());
    }

    public void addClient(HubConnection connection, CallableClient callable) {
        this.clientActor_.entryMap_.put(connection.getRegInfo().getPrivateKey(), new Entry(connection, callable));
    }

    public void removeClient(HubConnection connection) {
        this.clientActor_.entryMap_.remove(connection.getRegInfo().getPrivateKey());
    }

    protected Object invokeMethod(Method method, Object obj, Object[] args) throws IllegalAccessException, InvocationTargetException {
        return method.invoke(obj, args);
    }

    private static class Entry {
        final HubConnection connection_;
        final CallableClient callable_;

        Entry(HubConnection connection, CallableClient callable) {
            this.connection_ = connection;
            this.callable_ = callable;
        }
    }

    private static class ClientActorImpl
    implements ClientActor {
        private Map entryMap_ = new HashMap();

        private ClientActorImpl() {
        }

        public void receiveNotification(String privateKey, final String senderId, Map msg) {
            Entry entry = this.getEntry(privateKey);
            final CallableClient callable = entry.callable_;
            final Message message = Message.asMessage(msg);
            final String label = "Notify " + senderId + " " + message.getMType();
            new Thread(label){

                public void run() {
                    try {
                        callable.receiveNotification(senderId, message);
                    }
                    catch (Throwable e) {
                        logger_.log(Level.INFO, label + " error", e);
                    }
                }
            }.start();
        }

        public void receiveCall(String privateKey, final String senderId, final String msgId, Map msg) throws Exception {
            Entry entry = this.getEntry(privateKey);
            final CallableClient callable = entry.callable_;
            final HubConnection connection = entry.connection_;
            final Message message = Message.asMessage(msg);
            final String label = "Call " + senderId + " " + message.getMType();
            new Thread(label){

                public void run() {
                    try {
                        callable.receiveCall(senderId, msgId, message);
                    }
                    catch (Throwable e) {
                        try {
                            Response response = Response.createErrorResponse(new ErrInfo(e));
                            connection.reply(msgId, response);
                        }
                        catch (Throwable e2) {
                            logger_.log(Level.INFO, label + " error replying", e2);
                        }
                    }
                }
            }.start();
        }

        public void receiveResponse(String privateKey, final String responderId, final String msgTag, Map resp) throws Exception {
            Entry entry = this.getEntry(privateKey);
            final CallableClient callable = entry.callable_;
            final Response response = Response.asResponse(resp);
            final String label = "Reply " + responderId;
            new Thread(label){

                public void run() {
                    try {
                        callable.receiveResponse(responderId, msgTag, response);
                    }
                    catch (Throwable e) {
                        logger_.log(Level.INFO, label + " error replying", e);
                    }
                }
            }.start();
        }

        private Entry getEntry(String privateKey) {
            Object ent = this.entryMap_.get(privateKey);
            if (ent instanceof Entry) {
                return (Entry)ent;
            }
            throw new IllegalStateException("Client is not listening");
        }
    }
}

