/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.web;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.astrogrid.samp.RegInfo;
import org.astrogrid.samp.SampUtils;
import org.astrogrid.samp.Subscriptions;
import org.astrogrid.samp.client.ClientProfile;
import org.astrogrid.samp.client.HubConnection;
import org.astrogrid.samp.client.SampException;
import org.astrogrid.samp.httpd.HttpServer;
import org.astrogrid.samp.httpd.URLMapperHandler;
import org.astrogrid.samp.hub.KeyGenerator;
import org.astrogrid.samp.web.ClientAuthorizer;
import org.astrogrid.samp.web.CorsHttpServer;
import org.astrogrid.samp.web.UrlTracker;
import org.astrogrid.samp.web.UrlTrackerHubConnection;
import org.astrogrid.samp.web.WebCallableClient;
import org.astrogrid.samp.web.WebHubActor;
import org.astrogrid.samp.xmlrpc.ActorHandler;

class WebHubXmlRpcHandler
extends ActorHandler {
    private final WebHubActorImpl impl_ = (WebHubActorImpl)this.getActor();
    private static final Logger logger_;
    static final /* synthetic */ boolean $assertionsDisabled;

    public WebHubXmlRpcHandler(ClientProfile profile, ClientAuthorizer auth, KeyGenerator keyGen, URL baseUrl, UrlTracker urlTracker) {
        super("samp.webhub.", WebHubActor.class, new WebHubActorImpl(profile, auth, keyGen, baseUrl, urlTracker));
    }

    public Object handleCall(String fqName, List params, Object reqObj) throws Exception {
        String regMethod = "samp.webhub.register";
        if (regMethod.equals(fqName) && reqObj instanceof HttpServer.Request) {
            HashMap<String, String> securityMap;
            HttpServer.Request req = (HttpServer.Request)reqObj;
            if (params.size() == 1 && params.get(0) instanceof Map) {
                securityMap = (HashMap<String, String>)params.get(0);
            } else if (params.size() == 1 && params.get(0) instanceof String) {
                securityMap = new HashMap<String, String>();
                securityMap.put("samp.name", (String)params.get(0));
                logger_.info("Deprecated register call signature (arg is string appName not map security-info)");
            } else {
                throw new IllegalArgumentException("Bad args for " + regMethod + "(map)");
            }
            RegInfo result = this.impl_.register(req, securityMap);
            if (!$assertionsDisabled && result == null) {
                throw new AssertionError();
            }
            return result;
        }
        return super.handleCall(fqName, params, reqObj);
    }

    public HttpServer.Handler getUrlTranslationHandler() {
        return this.impl_.getUrlTranslationHandler();
    }

    protected Object invokeMethod(Method method, Object obj, Object[] args) throws IllegalAccessException, InvocationTargetException {
        return method.invoke(obj, args);
    }

    static {
        $assertionsDisabled = !WebHubXmlRpcHandler.class.desiredAssertionStatus();
        logger_ = Logger.getLogger(WebHubXmlRpcHandler.class.getName());
    }

    private static class Registration {
        final HubConnection connection_;
        WebCallableClient callable_;
        Subscriptions subs_;

        Registration(HubConnection connection) {
            this.connection_ = connection;
        }
    }

    private static class URLTranslationHandler
    implements HttpServer.Handler {
        private final String basePath_;
        private final Set keySet_;
        private final UrlTracker urlTracker_;
        static final /* synthetic */ boolean $assertionsDisabled;

        public URLTranslationHandler(String basePath, Set keySet, UrlTracker urlTracker) {
            if (!basePath.startsWith("/")) {
                basePath = "/" + basePath;
            }
            if (!basePath.endsWith("/")) {
                basePath = basePath + "/";
            }
            this.basePath_ = basePath;
            this.keySet_ = keySet;
            this.urlTracker_ = urlTracker;
        }

        public String getTranslationBasePath(String privateKey) {
            return this.basePath_ + privateKey + "?";
        }

        public HttpServer.Response serveRequest(HttpServer.Request request) {
            URL targetUrl;
            String targetString;
            String path = request.getUrl();
            if (!path.startsWith(this.basePath_)) {
                return null;
            }
            String relPath = path.substring(this.basePath_.length());
            int qIndex = relPath.indexOf(63);
            if (qIndex < 0) {
                return HttpServer.createErrorResponse(404, "Not Found");
            }
            String authKey = relPath.substring(0, qIndex);
            if (!this.keySet_.contains(authKey)) {
                return HttpServer.createErrorResponse(403, "Forbidden");
            }
            if (!$assertionsDisabled && !path.substring(0, path.indexOf(63) + 1).equals(this.getTranslationBasePath(authKey))) {
                throw new AssertionError();
            }
            try {
                targetString = SampUtils.uriDecode(relPath.substring(qIndex + 1));
            }
            catch (RuntimeException e) {
                return HttpServer.createErrorResponse(400, "Bad Request");
            }
            try {
                targetUrl = new URL(targetString);
            }
            catch (MalformedURLException e) {
                return HttpServer.createErrorResponse(400, "Bad Request");
            }
            if (this.urlTracker_ != null && !this.urlTracker_.isUrlPermitted(targetUrl)) {
                return HttpServer.createErrorResponse(403, "Forbidden");
            }
            return URLMapperHandler.mapUrlResponse(request.getMethod(), targetUrl);
        }

        static {
            $assertionsDisabled = !(class$org$astrogrid$samp$web$WebHubXmlRpcHandler == null ? (class$org$astrogrid$samp$web$WebHubXmlRpcHandler = WebHubXmlRpcHandler.class$("org.astrogrid.samp.web.WebHubXmlRpcHandler")) : class$org$astrogrid$samp$web$WebHubXmlRpcHandler).desiredAssertionStatus();
        }
    }

    private static class WebHubActorImpl
    implements WebHubActor {
        private final ClientProfile profile_;
        private final ClientAuthorizer auth_;
        private final KeyGenerator keyGen_;
        private final Map regMap_;
        private final URLTranslationHandler urlTranslator_;
        private final URL baseUrl_;
        private final UrlTracker urlTracker_;
        static final /* synthetic */ boolean $assertionsDisabled;

        public WebHubActorImpl(ClientProfile profile, ClientAuthorizer auth, KeyGenerator keyGen, URL baseUrl, UrlTracker urlTracker) {
            this.profile_ = profile;
            this.auth_ = auth;
            this.keyGen_ = keyGen;
            this.baseUrl_ = baseUrl;
            this.urlTracker_ = urlTracker;
            this.regMap_ = Collections.synchronizedMap(new HashMap());
            this.urlTranslator_ = new URLTranslationHandler("/proxied/", this.regMap_.keySet(), urlTracker);
        }

        public HttpServer.Handler getUrlTranslationHandler() {
            return this.urlTranslator_;
        }

        public RegInfo register(HttpServer.Request request, Map securityMap) throws SampException {
            if (this.profile_.isHubRunning()) {
                if (!CorsHttpServer.isLocalHost(request.getRemoteAddress())) {
                    String alert = "Registration attempt from non-local remote host - should have been blocked earlier by HTTP server";
                    logger_.severe(alert);
                    throw new SampException(alert);
                }
                Object appNameObj = securityMap.get("samp.name");
                if (!(appNameObj instanceof String)) {
                    throw new SampException("Wrong data type (not string) for samp.name securityInfo entry");
                }
                String appName = (String)appNameObj;
                boolean isAuth = this.auth_.authorize(request, appName);
                if (!isAuth) {
                    throw new SampException("Registration denied");
                }
                HubConnection connection = this.profile_.register();
                if (connection != null) {
                    if (this.urlTracker_ != null) {
                        connection = new UrlTrackerHubConnection(connection, this.urlTracker_);
                    }
                    String clientKey = this.keyGen_.next();
                    this.regMap_.put(clientKey, new Registration(connection));
                    String urlTrans = this.baseUrl_ + this.urlTranslator_.getTranslationBasePath(clientKey);
                    RegInfo regInfo = new RegInfo(connection.getRegInfo());
                    regInfo.put("samp.private-key", clientKey);
                    regInfo.put("samp.url-translator", urlTrans);
                    return regInfo;
                }
                throw new SampException("Hub is not running");
            }
            throw new SampException("Hub not running");
        }

        public void unregister(String clientKey) throws SampException {
            HubConnection connection = this.getConnection(clientKey);
            this.regMap_.remove(clientKey);
            connection.unregister();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void allowReverseCallbacks(String clientKey, String allow) throws SampException {
            Registration reg;
            boolean isAllowed = SampUtils.decodeBoolean(allow);
            Registration registration = reg = this.getRegistration(clientKey);
            synchronized (registration) {
                if (isAllowed == (reg.callable_ != null)) {
                    return;
                }
                if (isAllowed) {
                    WebCallableClient callable = new WebCallableClient();
                    reg.connection_.setCallable(callable);
                    reg.callable_ = callable;
                } else {
                    reg.connection_.setCallable(null);
                    reg.callable_.endCallbacks();
                    reg.callable_ = null;
                }
                if (!$assertionsDisabled && isAllowed != (reg.callable_ != null)) {
                    throw new AssertionError();
                }
            }
        }

        public List pullCallbacks(String clientKey, String timeout) throws SampException {
            WebCallableClient callable = this.getRegistration((String)clientKey).callable_;
            if (callable != null) {
                return callable.pullCallbacks(SampUtils.decodeInt(timeout));
            }
            throw new SampException("Client is not callable (first invoke allowReverseCallbacks)");
        }

        public void declareMetadata(String clientKey, Map meta) throws SampException {
            this.getConnection(clientKey).declareMetadata(meta);
        }

        public Map getMetadata(String clientKey, String clientId) throws SampException {
            return this.getConnection(clientKey).getMetadata(clientId);
        }

        public void declareSubscriptions(String clientKey, Map subs) throws SampException {
            this.getRegistration((String)clientKey).subs_ = new Subscriptions(subs == null ? new HashMap() : subs);
            this.getConnection(clientKey).declareSubscriptions(subs);
        }

        public Map getSubscriptions(String clientKey, String clientId) throws SampException {
            return this.getConnection(clientKey).getSubscriptions(clientId);
        }

        public List getRegisteredClients(String clientKey) throws SampException {
            return Arrays.asList(this.getConnection(clientKey).getRegisteredClients());
        }

        public Map getSubscribedClients(String clientKey, String mtype) throws SampException {
            return this.getConnection(clientKey).getSubscribedClients(mtype);
        }

        public void notify(String clientKey, String recipientId, Map msg) throws SampException {
            this.getConnection(clientKey).notify(recipientId, msg);
        }

        public List notifyAll(String clientKey, Map msg) throws SampException {
            return this.getConnection(clientKey).notifyAll(msg);
        }

        public String call(String clientKey, String recipientId, String msgTag, Map msg) throws SampException {
            return this.getConnection(clientKey).call(recipientId, msgTag, msg);
        }

        public Map callAll(String clientKey, String msgTag, Map msg) throws SampException {
            return this.getConnection(clientKey).callAll(msgTag, msg);
        }

        public Map callAndWait(String clientKey, String recipientId, Map msg, String timeout) throws SampException {
            return this.getConnection(clientKey).callAndWait(recipientId, msg, SampUtils.decodeInt(timeout));
        }

        public void reply(String clientKey, String msgId, Map response) throws SampException {
            this.getConnection(clientKey).reply(msgId, response);
        }

        public void ping() {
            if (!this.profile_.isHubRunning()) {
                throw new RuntimeException("No hub running");
            }
        }

        public void ping(String clientKey) {
            this.ping();
        }

        private Registration getRegistration(String privateKey) throws SampException {
            Registration reg = (Registration)this.regMap_.get(privateKey);
            if (reg == null) {
                throw new SampException("Unknown client key");
            }
            return reg;
        }

        private HubConnection getConnection(String privateKey) throws SampException {
            return this.getRegistration((String)privateKey).connection_;
        }

        static {
            $assertionsDisabled = !(class$org$astrogrid$samp$web$WebHubXmlRpcHandler == null ? (class$org$astrogrid$samp$web$WebHubXmlRpcHandler = WebHubXmlRpcHandler.class$("org.astrogrid.samp.web.WebHubXmlRpcHandler")) : class$org$astrogrid$samp$web$WebHubXmlRpcHandler).desiredAssertionStatus();
        }
    }
}

