/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.web;

import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Window;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.astrogrid.samp.httpd.HttpServer;
import org.astrogrid.samp.web.AuthResourceBundle;
import org.astrogrid.samp.web.ClientAuthorizer;

public class HubSwingClientAuthorizer
implements ClientAuthorizer {
    private final Component parent_;
    private static final Logger logger_ = Logger.getLogger(HubSwingClientAuthorizer.class.getName());

    public HubSwingClientAuthorizer(Component parent) {
        this.parent_ = parent;
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException("Client authorization dialogues impossible - no graphics");
        }
    }

    public boolean authorize(HttpServer.Request request, String appName) {
        AuthResourceBundle.Content authContent = AuthResourceBundle.getAuthContent(ResourceBundle.getBundle(AuthResourceBundle.class.getName()));
        String[] qmsg = this.getMessageLines(request, appName, authContent);
        String noOpt = authContent.noWord();
        String yesOpt = authContent.yesWord();
        JOptionPane jop = new JOptionPane(qmsg, 2, 0, null, new String[]{noOpt, yesOpt}, noOpt);
        JDialog dialog = jop.createDialog(this.parent_, authContent.windowTitle());
        HubSwingClientAuthorizer.attemptSetAlwaysOnTop(dialog, true);
        dialog.setModal(true);
        dialog.setDefaultCloseOperation(2);
        dialog.setVisible(true);
        dialog.dispose();
        return jop.getValue() == yesOpt;
    }

    private String[] getMessageLines(HttpServer.Request request, String appName, AuthResourceBundle.Content authContent) {
        Map headerMap = request.getHeaderMap();
        String origin = HttpServer.getHeader(headerMap, "Origin");
        String referer = HttpServer.getHeader(headerMap, "Referer");
        ArrayList<String> lineList = new ArrayList<String>();
        lineList.addAll(HubSwingClientAuthorizer.toLineList(authContent.appIntroductionLines()));
        lineList.add("\n");
        lineList.add("    " + authContent.nameWord() + ": " + appName);
        lineList.add("    " + authContent.originWord() + ": " + (origin == null ? authContent.undeclaredWord() : origin));
        lineList.add("    URL: " + (referer == null ? authContent.undeclaredWord() : referer));
        lineList.add("\n");
        if (referer != null && origin != null && !origin.equals(this.getOrigin(referer))) {
            logger_.warning("Origin/Referer header mismatch: \"" + origin + "\" != " + "\"" + this.getOrigin(referer) + "\"");
            lineList.add("WARNING: Origin/Referer header mismatch!");
            lineList.add("WARNING: This looks suspicious.");
            lineList.add("\n");
        }
        lineList.addAll(HubSwingClientAuthorizer.toLineList(authContent.privilegeWarningLines()));
        lineList.add("\n");
        lineList.addAll(HubSwingClientAuthorizer.toLineList(authContent.adviceLines()));
        lineList.add("\n");
        lineList.add(authContent.questionLine());
        return lineList.toArray(new String[0]);
    }

    private String getOrigin(String uri) {
        URL url;
        if (uri == null) {
            return null;
        }
        try {
            url = new URL(uri);
        }
        catch (MalformedURLException e) {
            return null;
        }
        String scheme = url.getProtocol();
        String host = url.getHost();
        int portnum = url.getPort();
        StringBuffer sbuf = new StringBuffer().append(scheme).append("://").append(host);
        if (portnum >= 0 && portnum != url.getDefaultPort()) {
            sbuf.append(":").append(Integer.toString(portnum));
        }
        return sbuf.toString().toLowerCase();
    }

    private static String[] toLines(String linesTxt) {
        return linesTxt.split("\\n");
    }

    private static List toLineList(String linesTxt) {
        return Arrays.asList(HubSwingClientAuthorizer.toLines(linesTxt));
    }

    private static void attemptSetAlwaysOnTop(Window win, boolean isOnTop) {
        try {
            Window.class.getMethod("setAlwaysOnTop", Boolean.TYPE).invoke((Object)win, isOnTop);
        }
        catch (Throwable e) {
            logger_.info("Can't set window on top, not J2SE5");
        }
    }
}

