/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.hub;

import java.awt.AWTException;
import java.awt.CheckboxMenuItem;
import java.awt.Image;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.astrogrid.samp.client.DefaultClientProfile;
import org.astrogrid.samp.gui.ErrorDialog;
import org.astrogrid.samp.gui.GuiHubService;
import org.astrogrid.samp.gui.MessageTrackerHubService;
import org.astrogrid.samp.gui.SysTray;
import org.astrogrid.samp.hub.BasicHubService;
import org.astrogrid.samp.hub.ConfigHubProfile;
import org.astrogrid.samp.hub.FacadeHubService;
import org.astrogrid.samp.hub.Hub;
import org.astrogrid.samp.hub.HubProfile;
import org.astrogrid.samp.hub.HubService;

public abstract class HubServiceMode {
    private final String name_;
    private final boolean isDaemon_;
    private static final Logger logger_ = Logger.getLogger(HubServiceMode.class.getName());
    public static final HubServiceMode NO_GUI = HubServiceMode.createBasicHubMode("no-gui");
    public static final HubServiceMode CLIENT_GUI;
    public static HubServiceMode MESSAGE_GUI;
    public static HubServiceMode FACADE;
    private static final HubServiceMode[] KNOWN_MODES;
    static /* synthetic */ Class class$org$astrogrid$samp$Client;

    HubServiceMode(String name, boolean isDaemon) {
        this.name_ = name;
        this.isDaemon_ = isDaemon;
    }

    abstract HubService createHubService(Random var1, HubProfile[] var2, Hub[] var3);

    boolean isDaemon() {
        return this.isDaemon_;
    }

    String getName() {
        return this.name_;
    }

    public String toString() {
        return this.name_;
    }

    public static HubServiceMode getModeFromName(String name) {
        HubServiceMode[] modes = KNOWN_MODES;
        for (int im = 0; im < modes.length; ++im) {
            HubServiceMode mode = modes[im];
            if (!mode.name_.equalsIgnoreCase(name)) continue;
            return mode;
        }
        return null;
    }

    public static HubServiceMode[] getAvailableModes() {
        ArrayList<HubServiceMode> modeList = new ArrayList<HubServiceMode>();
        for (int i = 0; i < KNOWN_MODES.length; ++i) {
            HubServiceMode mode = KNOWN_MODES[i];
            if (mode instanceof BrokenHubMode) continue;
            modeList.add(mode);
        }
        return modeList.toArray(new HubServiceMode[0]);
    }

    private static Tidier configureHubWindow(JFrame frame, HubProfile[] profiles, Hub[] runners, GuiHubService hubService) {
        SysTray sysTray = SysTray.getInstance();
        if (sysTray.isSupported()) {
            try {
                SysTrayWindowConfig winConfig = new SysTrayWindowConfig(frame, profiles, runners, hubService, sysTray);
                winConfig.configureWindow();
                winConfig.configureSysTray();
                logger_.info("Hub started in system tray");
                return winConfig;
            }
            catch (AWTException e) {
                logger_.warning("Failed to install in system tray: " + e);
                BasicWindowConfig winConfig = new BasicWindowConfig(frame, profiles, runners, hubService);
                winConfig.configureWindow();
                return winConfig;
            }
        }
        logger_.info("System tray not supported: displaying hub window");
        BasicWindowConfig winConfig = new BasicWindowConfig(frame, profiles, runners, hubService);
        winConfig.configureWindow();
        return winConfig;
    }

    private static HubServiceMode createBasicHubMode(String name) {
        try {
            return new HubServiceMode(name, true){

                HubService createHubService(Random random, HubProfile[] profiles, Hub[] runners) {
                    return new BasicHubService(random);
                }
            };
        }
        catch (Throwable e) {
            return new BrokenHubMode(name, e);
        }
    }

    private static HubServiceMode createGuiHubMode(String name) {
        try {
            GuiHubService.class.getName();
            return new HubServiceMode(name, false){

                HubService createHubService(Random random, final HubProfile[] profiles, final Hub[] runners) {
                    return new GuiHubService(random){
                        Tidier tidier;

                        public void start() {
                            final 1 service = this;
                            super.start();
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    tidier = HubServiceMode.configureHubWindow(this.createHubWindow(), profiles, runners, service);
                                }
                            });
                        }

                        public void shutdown() {
                            super.shutdown();
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    if (tidier != null) {
                                        tidier.tidyGui();
                                    }
                                }
                            });
                        }
                    };
                }
            };
        }
        catch (Throwable e) {
            return new BrokenHubMode(name, e);
        }
    }

    private static HubServiceMode createMessageTrackerHubMode(String name) {
        try {
            MessageTrackerHubService.class.getName();
            return new HubServiceMode(name, false){

                HubService createHubService(Random random, final HubProfile[] profiles, final Hub[] runners) {
                    return new MessageTrackerHubService(random){
                        Tidier tidier;

                        public void start() {
                            super.start();
                            final 1 service = this;
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    tidier = HubServiceMode.configureHubWindow(this.createHubWindow(), profiles, runners, service);
                                }
                            });
                        }

                        public void shutdown() {
                            super.shutdown();
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    if (tidier != null) {
                                        tidier.tidyGui();
                                    }
                                }
                            });
                        }
                    };
                }
            };
        }
        catch (Throwable e) {
            return new BrokenHubMode(name, e);
        }
    }

    private static HubServiceMode createFacadeHubMode(String name) {
        return new HubServiceMode(name, true){

            HubService createHubService(Random random, HubProfile[] profiles, Hub[] runners) {
                return new FacadeHubService(DefaultClientProfile.getProfile());
            }
        };
    }

    static {
        KNOWN_MODES = new HubServiceMode[]{NO_GUI, CLIENT_GUI = HubServiceMode.createGuiHubMode("client-gui"), MESSAGE_GUI = HubServiceMode.createMessageTrackerHubMode("msg-gui"), FACADE = HubServiceMode.createFacadeHubMode("facade")};
    }

    private static class ProfileToggler {
        final HubProfile profile_;
        final Hub[] runners_;
        final String title_;
        final JToggleButton.ToggleButtonModel toggleModel_;
        final List menuItemList_;

        ProfileToggler(HubProfile profile, Hub[] runners) {
            this.profile_ = profile;
            this.runners_ = runners;
            this.title_ = profile.getProfileName() + " Profile";
            this.menuItemList_ = new ArrayList();
            this.toggleModel_ = new JToggleButton.ToggleButtonModel(){

                public boolean isSelected() {
                    return ProfileToggler.this.profile_.isRunning();
                }

                public void setSelected(boolean on) {
                    Hub hub = ProfileToggler.this.runners_[0];
                    if (hub != null) {
                        if (on && !ProfileToggler.this.profile_.isRunning()) {
                            try {
                                hub.startProfile(ProfileToggler.this.profile_);
                                super.setSelected(on);
                            }
                            catch (IOException e) {
                                ErrorDialog.showError(null, ProfileToggler.this.title_ + " Start Error", "Error starting " + ProfileToggler.this.title_, e);
                                return;
                            }
                        } else if (!on && ProfileToggler.this.profile_.isRunning()) {
                            hub.stopProfile(ProfileToggler.this.profile_);
                        }
                    }
                    super.setSelected(on);
                }
            };
            this.toggleModel_.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent evt) {
                    ProfileToggler.this.updateMenuItems();
                }
            });
        }

        public JMenuItem createJMenuItem() {
            JCheckBoxMenuItem item = new JCheckBoxMenuItem(this.title_);
            item.setToolTipText("Start or stop the " + this.title_);
            char chr = Character.toUpperCase(this.profile_.getProfileName().charAt(0));
            if (chr >= 'A' && chr <= 'Z') {
                item.setMnemonic((int)chr);
            }
            item.setModel(this.toggleModel_);
            return item;
        }

        public MenuItem createMenuItem() {
            final CheckboxMenuItem item = new CheckboxMenuItem(this.title_);
            item.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent evt) {
                    boolean on = item.getState();
                    ProfileToggler.this.toggleModel_.setSelected(on);
                    if (ProfileToggler.this.toggleModel_.isSelected() != on) {
                        item.setState(ProfileToggler.this.toggleModel_.isSelected());
                    }
                }
            });
            item.setState(this.toggleModel_.isSelected());
            this.menuItemList_.add(item);
            return item;
        }

        private void updateMenuItems() {
            Iterator it = this.menuItemList_.iterator();
            while (it.hasNext()) {
                CheckboxMenuItem item = (CheckboxMenuItem)it.next();
                boolean on = this.toggleModel_.isSelected();
                if (item.getState() == on) continue;
                item.setState(on);
            }
        }
    }

    private static class SysTrayWindowConfig
    extends BasicWindowConfig {
        private final SysTray sysTray_;
        private final Action showAct_;
        private final Action hideAct_;
        private final MenuItem showItem_;
        private final MenuItem hideItem_;
        private final MenuItem exitItem_;
        private final ActionListener iconListener_;
        private Object trayIcon_;

        SysTrayWindowConfig(JFrame frame, HubProfile[] profiles, Hub[] runners, GuiHubService hubService, SysTray sysTray) {
            super(frame, profiles, runners, hubService);
            this.sysTray_ = sysTray;
            this.showAct_ = new AbstractAction("Show Hub Window"){

                public void actionPerformed(ActionEvent evt) {
                    SysTrayWindowConfig.this.setWindowVisible(true);
                }
            };
            this.hideAct_ = new AbstractAction("Hide Hub Window"){

                public void actionPerformed(ActionEvent evt) {
                    SysTrayWindowConfig.this.setWindowVisible(false);
                }
            };
            this.showItem_ = this.toMenuItem(this.showAct_);
            this.hideItem_ = this.toMenuItem(this.hideAct_);
            this.exitItem_ = this.toMenuItem(this.exitAct_);
            this.iconListener_ = this.showAct_;
        }

        protected void configureMenus() {
            super.configureMenus();
            this.frame_.getJMenuBar().getMenu(0).add(new JMenuItem(this.hideAct_));
        }

        public void configureWindow() {
            this.configureMenus();
            this.frame_.setDefaultCloseOperation(1);
            this.frame_.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent evt) {
                    SysTrayWindowConfig.this.showAct_.setEnabled(true);
                    SysTrayWindowConfig.this.hideAct_.setEnabled(false);
                }
            });
            this.hideAct_.actionPerformed(null);
        }

        public void configureSysTray() throws AWTException {
            Image im = Toolkit.getDefaultToolkit().createImage((class$org$astrogrid$samp$Client == null ? (class$org$astrogrid$samp$Client = HubServiceMode.class$("org.astrogrid.samp.Client")) : class$org$astrogrid$samp$Client).getResource("images/hub.png"));
            String tooltip = "SAMP Hub";
            PopupMenu popup = new PopupMenu();
            Menu profileMenu = new Menu("Profiles");
            for (int ip = 0; ip < this.profileTogglers_.length; ++ip) {
                profileMenu.add(this.profileTogglers_[ip].createMenuItem());
            }
            popup.add(profileMenu);
            popup.add(this.showItem_);
            popup.add(this.hideItem_);
            popup.add(this.exitItem_);
            this.trayIcon_ = this.sysTray_.addIcon(im, tooltip, popup, this.iconListener_);
        }

        public void tidyGui() {
            super.tidyGui();
            try {
                this.sysTray_.removeIcon(this.trayIcon_);
            }
            catch (AWTException e) {
                logger_.warning("Can't remove hub system tray icon: " + e);
            }
        }

        private void setWindowVisible(boolean isVis) {
            this.frame_.setVisible(isVis);
            this.showAct_.setEnabled(!isVis);
            this.hideAct_.setEnabled(isVis);
            this.showItem_.setEnabled(!isVis);
            this.hideItem_.setEnabled(isVis);
        }

        private MenuItem toMenuItem(Action act) {
            MenuItem item = new MenuItem((String)act.getValue("Name"));
            item.addActionListener(act);
            return item;
        }
    }

    private static class BasicWindowConfig
    extends Tidier {
        final JFrame frame_;
        final Hub[] runners_;
        final GuiHubService hubService_;
        final ProfileToggler[] profileTogglers_;
        final ConfigHubProfile[] configProfiles_;
        final Action exitAct_;

        BasicWindowConfig(JFrame frame, HubProfile[] profiles, final Hub[] runners, GuiHubService hubService) {
            this.frame_ = frame;
            this.runners_ = runners;
            this.hubService_ = hubService;
            this.profileTogglers_ = new ProfileToggler[profiles.length];
            ArrayList<ConfigHubProfile> configProfileList = new ArrayList<ConfigHubProfile>();
            for (int ip = 0; ip < profiles.length; ++ip) {
                HubProfile profile = profiles[ip];
                this.profileTogglers_[ip] = new ProfileToggler(profile, runners);
                if (!(profile instanceof ConfigHubProfile)) continue;
                configProfileList.add((ConfigHubProfile)profile);
            }
            this.configProfiles_ = configProfileList.toArray(new ConfigHubProfile[0]);
            this.exitAct_ = new AbstractAction("Stop Hub"){

                public void actionPerformed(ActionEvent evt) {
                    if (runners[0] != null) {
                        runners[0].shutdown();
                    }
                    BasicWindowConfig.this.tidyGui();
                }
            };
            this.exitAct_.putValue("ShortDescription", "Shut down SAMP hub");
            this.exitAct_.putValue("MnemonicKey", new Integer(84));
        }

        public void configureWindow() {
            this.configureMenus();
            this.frame_.setDefaultCloseOperation(2);
            this.frame_.setVisible(true);
            this.frame_.addWindowListener(new WindowAdapter(){

                public void windowClosed(WindowEvent evt) {
                    Hub runner = BasicWindowConfig.this.runners_[0];
                    if (runner != null) {
                        runner.shutdown();
                    }
                }
            });
        }

        protected void configureMenus() {
            JMenuBar mbar = new JMenuBar();
            JMenu fileMenu = new JMenu("File");
            fileMenu.setMnemonic(70);
            fileMenu.add(new JMenuItem(this.exitAct_));
            mbar.add(fileMenu);
            JMenu[] serviceMenus = this.hubService_.createMenus();
            for (int im = 0; im < serviceMenus.length; ++im) {
                mbar.add(serviceMenus[im]);
            }
            JMenu profileMenu = new JMenu("Profiles");
            profileMenu.setMnemonic(80);
            for (int ip = 0; ip < this.profileTogglers_.length; ++ip) {
                profileMenu.add(this.profileTogglers_[ip].createJMenuItem());
            }
            for (int ic = 0; ic < this.configProfiles_.length; ++ic) {
                ConfigHubProfile configProfile = this.configProfiles_[ic];
                JToggleButton.ToggleButtonModel[] configModels = configProfile.getConfigModels();
                JMenu configMenu = new JMenu(configProfile.getProfileName() + " Profile Configuration");
                for (int im = 0; im < configModels.length; ++im) {
                    JToggleButton.ToggleButtonModel model = configModels[im];
                    JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(model.toString());
                    menuItem.setModel(model);
                    configMenu.add(menuItem);
                }
                profileMenu.add(configMenu);
            }
            mbar.add(profileMenu);
            this.frame_.setJMenuBar(mbar);
        }

        public void tidyGui() {
            if (this.frame_.isDisplayable()) {
                this.frame_.dispose();
            }
        }
    }

    private static abstract class Tidier {
        private Tidier() {
        }

        public abstract void tidyGui();
    }

    private static class BrokenHubMode
    extends HubServiceMode {
        private final Throwable error_;

        BrokenHubMode(String name, Throwable error) {
            super(name, false);
            this.error_ = error;
        }

        HubService createHubService(Random random, HubProfile[] profiles, Hub[] runners) {
            throw new RuntimeException("Hub mode " + this.getName() + " unavailable", this.error_);
        }
    }
}

