/*
 * Decompiled with CFR 0.152.
 */
package healpix.essentials;

import healpix.essentials.FastMath;
import healpix.essentials.Pointing;
import healpix.essentials.Vec3;

public final class Zphi {
    public double z;
    public double phi;

    public Zphi() {
    }

    public Zphi(double z_, double phi_) {
        this.z = z_;
        this.phi = phi_;
    }

    public Zphi(Vec3 v) {
        this.z = v.z / v.length();
        this.phi = FastMath.atan2(v.y, v.x);
    }

    public Zphi(Pointing ptg) {
        this.z = FastMath.cos(ptg.theta);
        this.phi = ptg.phi;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("zphi(");
        s.append(this.z);
        s.append(",");
        s.append(this.phi);
        s.append(")");
        return s.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Zphi zphi = (Zphi)o;
        if (Double.compare(zphi.phi, this.phi) != 0) {
            return false;
        }
        return Double.compare(zphi.z, this.z) == 0;
    }

    public int hashCode() {
        long temp = this.z != 0.0 ? Double.doubleToLongBits(this.z) : 0L;
        int result = (int)(temp ^ temp >>> 32);
        temp = this.phi != 0.0 ? Double.doubleToLongBits(this.phi) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }
}

