/*
 * Decompiled with CFR 0.152.
 */
package cds.vizier;

import cds.aladin.Aladin;
import cds.tools.CDSConstants;
import cds.tools.CDSLabel;
import cds.vizier.VizieRTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class VizieRCatalogs
extends JFrame
implements CDSConstants,
WindowListener {
    protected VizieRTable vizierlist = null;
    protected CDSLabel title = null;
    protected JButton controlButton = null;

    public VizieRCatalogs(JTextField cat, final JButton getReadMe, JButton getMoc, Vector catalogs, JButton controlButton) {
        Aladin.setIcon(this);
        JPanel panelMain = new JPanel();
        panelMain.setFont(BOLD);
        BorderLayout mainLayout = new BorderLayout(0, 0);
        panelMain.setLayout(mainLayout);
        this.title = new CDSLabel("Catalogs", 0, PLAIN);
        panelMain.add((Component)this.title, "North");
        this.vizierlist = new VizieRTable(cat, getReadMe, getMoc, catalogs, 20, 1);
        JScrollPane scroll = new JScrollPane(this.vizierlist);
        scroll.setSize(580, 600);
        panelMain.add((Component)scroll, "Center");
        JPanel panelButtonLeft = new JPanel();
        panelButtonLeft.setFont(BOLD);
        if (getReadMe != null) {
            panelButtonLeft.add(getReadMe);
        }
        if (getMoc != null) {
            panelButtonLeft.add(getMoc);
        }
        JPanel panelButtonRight = new JPanel();
        panelButtonRight.setFont(BOLD);
        if (controlButton != null) {
            this.controlButton = controlButton;
            panelButtonRight.add(controlButton);
        }
        JButton reset = new JButton("Reset");
        JButton close = new JButton("Close");
        panelButtonRight.add(reset);
        panelButtonRight.add(close);
        JPanel panelBottom = new JPanel();
        panelBottom.setFont(BOLD);
        BorderLayout buttonlayout = new BorderLayout(5, 5);
        panelBottom.setLayout(buttonlayout);
        panelBottom.add((Component)panelButtonLeft, "West");
        panelBottom.add((Component)panelButtonRight, "East");
        panelMain.add((Component)panelBottom, "South");
        reset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (VizieRCatalogs.this.vizierlist != null) {
                    VizieRCatalogs.this.vizierlist.resetList();
                    if (VizieRCatalogs.this.vizierlist.getCatalogField() != null) {
                        VizieRCatalogs.this.vizierlist.getCatalogField().setText("");
                    }
                }
                if (getReadMe != null) {
                    getReadMe.setEnabled(false);
                }
            }
        });
        close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (getReadMe != null) {
                    getReadMe.setEnabled(false);
                }
                VizieRCatalogs.this.hide();
            }
        });
        this.addWindowListener(this);
        this.getContentPane().add(panelMain);
        this.pack();
        this.setLocation(300, 300);
        this.show();
    }

    public VizieRCatalogs(Vector catalogs, JButton controlButton) {
        this(null, null, null, catalogs, controlButton);
    }

    public VizieRCatalogs(Vector catalogs) {
        this(null, null, null, catalogs, null);
    }

    public void show(Vector v) {
        if (this.vizierlist != null) {
            this.vizierlist.resetList();
            this.vizierlist.preSelection(v);
        }
        this.show();
    }

    public void resetCatList() {
        if (this.vizierlist != null) {
            this.vizierlist.resetList();
        }
    }

    public void setLabel(String title) {
        this.title.setText(title);
    }

    public CDSLabel getLabel() {
        return this.title;
    }

    public VizieRTable getVizerList() {
        return this.vizierlist;
    }

    public void setVizerList(VizieRTable vizierlist) {
        this.vizierlist = vizierlist;
    }

    public JButton getControlButton() {
        return this.controlButton;
    }

    public void setControlButton(JButton controlButton) {
        this.controlButton = controlButton;
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.hide();
    }

    @Override
    public void windowClosed(WindowEvent e) {
        this.hide();
    }

    public void componentShown(ComponentEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }
}

