/*
 * Decompiled with CFR 0.152.
 */
package cds.savot.writer;

import cds.savot.model.CoosysSet;
import cds.savot.model.FieldRefSet;
import cds.savot.model.FieldSet;
import cds.savot.model.GroupSet;
import cds.savot.model.InfoSet;
import cds.savot.model.LinkSet;
import cds.savot.model.OptionSet;
import cds.savot.model.ParamRefSet;
import cds.savot.model.ParamSet;
import cds.savot.model.ResourceSet;
import cds.savot.model.SavotBinary;
import cds.savot.model.SavotCoosys;
import cds.savot.model.SavotData;
import cds.savot.model.SavotField;
import cds.savot.model.SavotFieldRef;
import cds.savot.model.SavotFits;
import cds.savot.model.SavotGroup;
import cds.savot.model.SavotInfo;
import cds.savot.model.SavotLink;
import cds.savot.model.SavotMax;
import cds.savot.model.SavotMin;
import cds.savot.model.SavotOption;
import cds.savot.model.SavotParam;
import cds.savot.model.SavotParamRef;
import cds.savot.model.SavotResource;
import cds.savot.model.SavotSet;
import cds.savot.model.SavotStream;
import cds.savot.model.SavotTD;
import cds.savot.model.SavotTR;
import cds.savot.model.SavotTable;
import cds.savot.model.SavotTableData;
import cds.savot.model.SavotVOTable;
import cds.savot.model.SavotValues;
import cds.savot.model.TDSet;
import cds.savot.model.TRSet;
import cds.savot.model.TableSet;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;

public class SavotWriter {
    private String top1 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private String top2 = "\n<VOTABLE xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\nxsi:noNamespaceSchemaLocation=\" xmlns:http://www.ivoa.net/xml/VOTable-1.2.xsd\" version=";
    private String styleSheet = "";
    private boolean attributeEntities = true;
    private boolean elementEntities = true;
    private OutputStream outStream = null;
    private DataOutputStream dataOutStream = null;
    private BufferedOutputStream dataBuffOutStream = null;
    static final byte[] tdbegin1 = "<TD".getBytes();
    static final byte[] tdbegin2 = ">".getBytes();
    static final byte[] tdend = "</TD>".getBytes();
    static final byte[] trbegin = "<TR>".getBytes();
    static final byte[] trend = "</TR>\n".getBytes();
    static final byte[] commentbegin = "<!-- ".getBytes();
    static final byte[] commentend = " -->\n".getBytes();
    static final byte[] tabledatabegin = "\n<TABLEDATA>\n".getBytes();
    static final byte[] tabledataend = "</TABLEDATA>".getBytes();
    static final byte[] databegin = "\n<DATA>".getBytes();
    static final byte[] dataend = "\n</DATA>".getBytes();
    static final byte[] tablebegin = "\n<TABLE>".getBytes();
    static final byte[] tableend = "\n</TABLE>".getBytes();
    static final byte[] resourcebegin = "\n<RESOURCE>".getBytes();
    static final byte[] resourceend = "\n</RESOURCE>".getBytes();
    static final byte[] infobegin = "<INFO>\n".getBytes();
    static final byte[] infoend = "</INFO>\n".getBytes();
    static final byte[] descriptionbegin = "\n<DESCRIPTION>".getBytes();
    static final byte[] descriptionend = "</DESCRIPTION>".getBytes();
    static final byte[] groupbegin = "\n<GROUP>".getBytes();
    static final byte[] groupend = "\n</GROUP>".getBytes();
    static final byte[] definitionsbegin = "\n<DEFINITIONS>".getBytes();
    static final byte[] definitionsend = "\n</DEFINITIONS>".getBytes();
    static final byte[] parambegin = "\n<PARAM>".getBytes();
    static final byte[] paramend = "\n</PARAM>".getBytes();
    static final byte[] fieldbegin = "\n<FIELD>".getBytes();
    static final byte[] fieldend = "\n</FIELD>".getBytes();
    static final byte[] linkbegin = "\n<LINK>".getBytes();
    static final byte[] linkend = "</LINK>".getBytes();
    static final byte[] valuesbegin = "\n<VALUES>".getBytes();
    static final byte[] valuesend = "\n</VALUES>".getBytes();
    static final byte[] fitsbegin = "\n<FITS>".getBytes();
    static final byte[] fitsend = "\n</FITS>".getBytes();
    static final byte[] binarybegin = "\n<BINARY>".getBytes();
    static final byte[] binaryend = "\n</BINARY>".getBytes();
    static final byte[] coosysbegin = "\n<COOSYS>".getBytes();
    static final byte[] coosysend = "</COOSYS>".getBytes();
    static final byte[] streambegin = "\n<STREAM>".getBytes();
    static final byte[] streamend = "\n</STREAM>".getBytes();
    static final byte[] minbegin = "\n<MIN>".getBytes();
    static final byte[] minend = "</MIN>".getBytes();
    static final byte[] maxbegin = "\n<MAX>".getBytes();
    static final byte[] maxend = "</MAX>".getBytes();
    static final byte[] optionbegin = "\n<OPTION>".getBytes();
    static final byte[] optionend = "\n</OPTION>".getBytes();

    public void setTop1(String top1) {
        this.top1 = top1;
    }

    public void setTop2(String top2) {
        this.top2 = top2;
    }

    public void setStyleSheet(String href) {
        this.styleSheet = href;
    }

    public void enableAttributeEntities(boolean entities) {
        this.attributeEntities = entities;
    }

    public void enableElementEntities(boolean entities) {
        this.elementEntities = entities;
    }

    public void enableEntities(boolean entities) {
        this.attributeEntities = entities;
        this.elementEntities = entities;
    }

    private String replace(String src, String oldPattern, String newPattern) {
        String dst = "";
        int last = 0;
        boolean done = false;
        while (!done) {
            int i = src.indexOf(oldPattern, last);
            if (i == -1) {
                done = true;
                if (last >= src.length()) continue;
                dst = dst.concat(src.substring(last, src.length()));
                continue;
            }
            if (i != last) {
                dst = dst.concat(src.substring(last, i));
            }
            last = i + oldPattern.length();
            dst = dst.concat(newPattern);
        }
        return dst;
    }

    public String encodeAttribute(String src) {
        if (this.attributeEntities) {
            src = this.replace(src, "&", "&amp;");
            src = this.replace(src, "\"", "&quot;");
            src = this.replace(src, "<", "&lt;");
            src = this.replace(src, ">", "&gt;");
        }
        return src;
    }

    public String encodeElement(String src) {
        if (this.elementEntities) {
            src = this.replace(src, "&", "&amp;");
            src = this.replace(src, "\"", "&quot;");
            src = this.replace(src, "<", "&lt;");
            src = this.replace(src, ">", "&gt;");
        }
        return src;
    }

    public void generateDocument(SavotVOTable votable) {
        this.generateDocument(votable, null, null);
    }

    public void generateDocument(SavotVOTable votable, OutputStream stream) {
        this.generateDocument(votable, null, stream);
    }

    public void generateDocument(SavotVOTable votable, String file) {
        this.generateDocument(votable, file, null);
    }

    public void generateDocument(SavotVOTable votable, String file, OutputStream stream) {
        try {
            String comment;
            if (file == null) {
                this.outStream = stream == null ? System.out : stream;
                this.dataOutStream = new DataOutputStream(this.outStream);
                this.dataBuffOutStream = new BufferedOutputStream(this.dataOutStream);
            } else {
                this.outStream = new FileOutputStream(new File(file));
                this.dataOutStream = new DataOutputStream(this.outStream);
                this.dataBuffOutStream = new BufferedOutputStream(this.dataOutStream);
            }
            this.dataBuffOutStream.write(this.top1.getBytes());
            if (votable.getAbove() != "") {
                comment = "<!-- " + votable.getAbove() + " -->";
                this.dataBuffOutStream.write(comment.getBytes());
            }
            if (this.styleSheet.compareTo("") != 0) {
                this.dataBuffOutStream.write(("\n<?xml-stylesheet type=\"text/xsl\" href=\"" + this.styleSheet + '\"' + "?>").getBytes());
            }
            if (votable.getXmlns().compareTo("") != 0 || votable.getXmlnsxsi().compareTo("") != 0 || votable.getXsischema().compareTo("") != 0 || votable.getXmlns().compareTo("") != 0) {
                this.top2 = "\n<VOTABLE";
                if (votable.getXmlns().compareTo("") != 0) {
                    this.top2 = String.valueOf(this.top2) + " xmlns=" + '\"' + votable.getXmlns() + '\"';
                }
                if (votable.getXmlnsxsi().compareTo("") != 0) {
                    this.top2 = String.valueOf(this.top2) + " xmlns:xsi=" + '\"' + votable.getXmlnsxsi() + '\"';
                }
                if (votable.getXsischema().compareTo("") != 0) {
                    this.top2 = String.valueOf(this.top2) + " xsi:schemaLocation=" + '\"' + votable.getXsischema() + '\"';
                }
                if (votable.getXsinoschema().compareTo("") != 0) {
                    this.top2 = String.valueOf(this.top2) + " xsi:noNamespaceSchemaLocation=" + '\"' + votable.getXsinoschema() + '\"';
                }
                this.top2 = String.valueOf(this.top2) + " version=";
            }
            if (votable.getVersion().compareTo("") != 0) {
                if (votable.getId().compareTo("") != 0) {
                    this.dataBuffOutStream.write((String.valueOf(this.top2) + '\"' + votable.getVersion() + '\"' + " ID=" + '\"' + votable.getId() + '\"' + '>').getBytes());
                } else {
                    this.dataBuffOutStream.write((String.valueOf(this.top2) + '\"' + votable.getVersion() + '\"' + '>').getBytes());
                }
            } else if (votable.getId().compareTo("") != 0) {
                this.dataBuffOutStream.write((String.valueOf(this.top2) + this.top2 + '\"' + "1.2" + '\"' + " ID=" + '\"' + votable.getId() + '\"' + '>').getBytes());
            } else {
                this.dataBuffOutStream.write((String.valueOf(this.top2) + '\"' + "1.2" + '\"' + '>').getBytes());
            }
            if (votable.getBelow() != "") {
                comment = "<!-- " + votable.getBelow() + " -->";
                this.dataBuffOutStream.write(comment.getBytes());
            }
            if (votable.getDescription() != null) {
                String description = "";
                if (votable.getDescription() != null && !votable.getDescription().equals("")) {
                    if (votable.getAbove() != "") {
                        description = "\n<!-- " + votable.getAbove() + " -->";
                    }
                    description = String.valueOf(description) + "\n<DESCRIPTION>";
                    if (votable.getBelow() != "") {
                        description = String.valueOf(description) + "\n" + "<!-- " + votable.getBelow() + " -->" + "\n";
                    }
                    description = String.valueOf(description) + this.encodeElement(votable.getDescription()) + "</DESCRIPTION>";
                    this.dataBuffOutStream.write(description.getBytes());
                }
            }
            if (votable.getDefinitions() != null) {
                this.dataBuffOutStream.write(definitionsbegin);
                CoosysSet coosysSet = votable.getDefinitions().getCoosys();
                this.writeCoosys(coosysSet);
                ParamSet paramSet = votable.getDefinitions().getParams();
                this.writeParam(paramSet);
                this.dataBuffOutStream.write(definitionsend);
            }
            CoosysSet coosyset = votable.getCoosys();
            this.writeCoosys(coosyset);
            InfoSet infoset = votable.getInfos();
            this.writeInfo(infoset);
            ParamSet paramset = votable.getParams();
            this.writeParam(paramset);
            GroupSet groupSet = votable.getGroups();
            this.writeGroup(groupSet);
            ResourceSet resourceset = votable.getResources();
            this.writeResource(resourceset);
            InfoSet infosAtEnd = votable.getInfosAtEnd();
            this.writeInfo(infosAtEnd);
            this.dataBuffOutStream.write("\n</VOTABLE>\n".getBytes());
            this.dataBuffOutStream.flush();
        }
        catch (Exception e) {
            System.err.println("generateDocument : " + e);
        }
    }

    public void writeDescription(String description) {
        try {
            String line = "";
            line = "<DESCRIPTION>" + this.encodeElement(description) + "</DESCRIPTION>";
            this.dataBuffOutStream.write(line.getBytes());
            this.dataBuffOutStream.flush();
        }
        catch (Exception e) {
            System.err.println("writeDescription : " + e);
        }
    }

    public void initStream(String file) {
        try {
            this.outStream = new FileOutputStream(new File(file));
            this.dataOutStream = new DataOutputStream(this.outStream);
            this.dataBuffOutStream = new BufferedOutputStream(this.dataOutStream);
        }
        catch (Exception e) {
            System.err.println("initStream : " + e);
        }
    }

    public void initStream(OutputStream stream) {
        try {
            this.outStream = stream == null ? System.out : stream;
            this.dataOutStream = new DataOutputStream(this.outStream);
            this.dataBuffOutStream = new BufferedOutputStream(this.dataOutStream);
        }
        catch (Exception e) {
            System.err.println("initStream : " + e);
        }
    }

    public void writeComment(String comment) {
        try {
            this.dataBuffOutStream.write(("<!--" + comment + "-->").getBytes());
        }
        catch (Exception e) {
            System.err.println("writeComment : " + e);
        }
    }

    public void writeDocumentHead(SavotVOTable votable) {
        try {
            this.dataBuffOutStream.write(this.top1.getBytes());
            if (this.styleSheet.compareTo("") != 0) {
                this.dataBuffOutStream.write(("\n<?xml-stylesheet type=\"text/xsl\" href=\"" + this.styleSheet + '\"' + "?>").getBytes());
            }
            if (votable.getXmlns().compareTo("") != 0 || votable.getXmlnsxsi().compareTo("") != 0 || votable.getXsischema().compareTo("") != 0 || votable.getXmlns().compareTo("") != 0) {
                this.top2 = "\n<VOTABLE";
                if (votable.getXmlns().compareTo("") != 0) {
                    this.top2 = String.valueOf(this.top2) + " xmlns=" + '\"' + votable.getXmlns() + '\"';
                }
                if (votable.getXmlnsxsi().compareTo("") != 0) {
                    this.top2 = String.valueOf(this.top2) + " xmlns:xsi=" + '\"' + votable.getXmlnsxsi() + '\"';
                }
                if (votable.getXsischema().compareTo("") != 0) {
                    this.top2 = String.valueOf(this.top2) + " xsi:schemaLocation=" + '\"' + votable.getXsischema() + '\"';
                }
                if (votable.getXsinoschema().compareTo("") != 0) {
                    this.top2 = String.valueOf(this.top2) + " xsi:noNamespaceSchemaLocation=" + '\"' + votable.getXsinoschema() + '\"';
                }
                this.top2 = String.valueOf(this.top2) + " version=";
            }
            if (votable.getVersion().compareTo("") != 0) {
                if (votable.getId().compareTo("") != 0) {
                    this.dataBuffOutStream.write((String.valueOf(this.top2) + '\"' + votable.getVersion() + '\"' + " ID=" + '\"' + votable.getId() + '\"' + '>').getBytes());
                } else {
                    this.dataBuffOutStream.write((String.valueOf(this.top2) + '\"' + votable.getVersion() + '\"' + '>').getBytes());
                }
            } else if (votable.getId().compareTo("") != 0) {
                this.dataBuffOutStream.write((String.valueOf(this.top2) + this.top2 + '\"' + "1.2" + '\"' + " ID=" + '\"' + votable.getId() + '\"' + '>').getBytes());
            } else {
                this.dataBuffOutStream.write((String.valueOf(this.top2) + '\"' + "1.2" + '\"' + '>').getBytes());
            }
            if (votable.getDefinitions() != null) {
                this.dataBuffOutStream.write(definitionsbegin);
                CoosysSet coosysSet = votable.getDefinitions().getCoosys();
                this.writeCoosys(coosysSet);
                ParamSet paramSet = votable.getDefinitions().getParams();
                this.writeParam(paramSet);
                this.dataBuffOutStream.write(definitionsend);
            }
            this.dataBuffOutStream.flush();
        }
        catch (Exception e) {
            System.err.println("writeDocumentHead : " + e);
        }
    }

    public void writeDocumentEnd() {
        try {
            this.dataBuffOutStream.write("\n</VOTABLE>\n".getBytes());
            this.dataBuffOutStream.flush();
        }
        catch (Exception e) {
            System.err.println("writeDocumentEnd : " + e);
        }
    }

    public void writeCoosys(CoosysSet coosysSet) {
        try {
            int i = 0;
            while (i < coosysSet.getItemCount()) {
                String coosysline = "";
                SavotCoosys coosys = (SavotCoosys)coosysSet.getItemAt(i);
                if (coosys.getAbove() != "") {
                    coosysline = String.valueOf(coosysline) + "\n<!-- " + coosys.getAbove() + " -->";
                }
                coosysline = String.valueOf(coosysline) + "\n<COOSYS";
                if (coosys.getId() != null && !coosys.getId().equals("")) {
                    coosysline = String.valueOf(coosysline) + " ID=" + '\"' + coosys.getId() + '\"';
                }
                if (coosys.getEquinox() != null && !coosys.getEquinox().equals("")) {
                    coosysline = String.valueOf(coosysline) + " equinox=" + '\"' + coosys.getEquinox() + '\"';
                }
                if (coosys.getEpoch() != null && !coosys.getEpoch().equals("")) {
                    coosysline = String.valueOf(coosysline) + " epoch=" + '\"' + coosys.getEpoch() + '\"';
                }
                if (coosys.getSystem() != null && !coosys.getSystem().equals("")) {
                    coosysline = String.valueOf(coosysline) + " system=" + '\"' + coosys.getSystem() + '\"';
                }
                if (coosys.getContent() != null && !coosys.getContent().equals("")) {
                    coosysline = String.valueOf(coosysline) + ">";
                    if (coosys.getBelow() != "") {
                        coosysline = String.valueOf(coosysline) + "\n<!-- " + coosys.getBelow() + " -->\n";
                    }
                    coosysline = String.valueOf(coosysline) + coosys.getContent();
                    this.dataBuffOutStream.write(coosysline.getBytes());
                    this.dataBuffOutStream.write(coosysend);
                } else {
                    coosysline = String.valueOf(coosysline) + "/>";
                    if (coosys.getBelow() != "") {
                        coosysline = String.valueOf(coosysline) + "\n<!-- " + coosys.getBelow() + " -->\n";
                    }
                    this.dataBuffOutStream.write(coosysline.getBytes());
                }
                ++i;
            }
        }
        catch (Exception e) {
            System.err.println("writeCoosys : " + e);
        }
    }

    public void writeParam(ParamSet params) {
        if (params == null) {
            return;
        }
        try {
            int i = 0;
            while (i < params.getItemCount()) {
                String paramline = "";
                SavotParam param = (SavotParam)params.getItemAt(i);
                if (param.getAbove() != "") {
                    paramline = String.valueOf(paramline) + "\n<!-- " + param.getAbove() + " -->";
                }
                paramline = String.valueOf(paramline) + "\n<PARAM";
                if (param.getId() != null && !param.getId().equals("")) {
                    paramline = String.valueOf(paramline) + " ID=" + '\"' + this.encodeAttribute(param.getId()) + '\"';
                }
                if (param.getUnit() != null && !param.getUnit().equals("")) {
                    paramline = String.valueOf(paramline) + " unit=" + '\"' + this.encodeAttribute(param.getUnit()) + '\"';
                }
                if (param.getDataType() != null && !param.getDataType().equals("")) {
                    paramline = String.valueOf(paramline) + " datatype=" + '\"' + this.encodeAttribute(param.getDataType()) + '\"';
                }
                if (param.getPrecision() != null && !param.getPrecision().equals("")) {
                    paramline = String.valueOf(paramline) + " precision=" + '\"' + this.encodeAttribute(param.getPrecision()) + '\"';
                }
                if (param.getWidth() != null && !param.getWidth().equals("")) {
                    paramline = String.valueOf(paramline) + " width=" + '\"' + this.encodeAttribute(param.getWidth()) + '\"';
                }
                if (param.getXtype() != null && !param.getXtype().equals("")) {
                    paramline = String.valueOf(paramline) + " width=" + '\"' + this.encodeAttribute(param.getXtype()) + '\"';
                }
                if (param.getRef() != null && !param.getRef().equals("")) {
                    paramline = String.valueOf(paramline) + " ref=" + '\"' + this.encodeAttribute(param.getRef()) + '\"';
                }
                if (param.getName() != null && !param.getName().equals("")) {
                    paramline = String.valueOf(paramline) + " name=" + '\"' + this.encodeAttribute(param.getName()) + '\"';
                }
                if (param.getUcd() != null && !param.getUcd().equals("")) {
                    paramline = String.valueOf(paramline) + " ucd=" + '\"' + this.encodeAttribute(param.getUcd()) + '\"';
                }
                if (param.getUtype() != null && !param.getUtype().equals("")) {
                    paramline = String.valueOf(paramline) + " utype=" + '\"' + this.encodeAttribute(param.getUtype()) + '\"';
                }
                if (param.getValue() != null && !param.getValue().equals("")) {
                    paramline = String.valueOf(paramline) + " value=" + '\"' + this.encodeAttribute(param.getValue()) + '\"';
                }
                if (param.getArraySize() != null && !param.getArraySize().equals("")) {
                    paramline = String.valueOf(paramline) + " arraysize=" + '\"' + this.encodeAttribute(param.getArraySize()) + '\"';
                }
                if (param.getValues() != null || param.getLinks().getItemCount() != 0 || param.getDescription() != null && !param.getDescription().equals("")) {
                    paramline = String.valueOf(paramline) + ">";
                    if (param.getBelow() != "") {
                        paramline = String.valueOf(paramline) + "\n<!-- " + param.getBelow() + " -->\n";
                    }
                    if (param.getDescription() != null && !param.getDescription().equals("")) {
                        paramline = String.valueOf(paramline) + "\n<DESCRIPTION>" + param.getDescription() + "</DESCRIPTION>";
                    }
                    this.dataBuffOutStream.write(paramline.getBytes());
                    this.writeValues(param.getValues());
                    this.writeLink(param.getLinks());
                    this.dataBuffOutStream.write(paramend);
                } else {
                    paramline = String.valueOf(paramline) + "/>";
                    if (param.getBelow() != "") {
                        paramline = String.valueOf(paramline) + "\n<!-- " + param.getBelow() + " -->\n";
                    }
                    this.dataBuffOutStream.write(paramline.getBytes());
                }
                ++i;
            }
        }
        catch (Exception e) {
            System.err.println("writeParam : " + e);
        }
    }

    public void writeParamRef(ParamRefSet refparams) {
        if (refparams == null) {
            return;
        }
        try {
            int i = 0;
            while (i < refparams.getItemCount()) {
                String paramline = "";
                SavotParamRef paramref = (SavotParamRef)refparams.getItemAt(i);
                if (paramref.getAbove() != "") {
                    paramline = String.valueOf(paramline) + "\n<!-- " + paramref.getAbove() + " -->";
                }
                paramline = String.valueOf(paramline) + "\n<PARAMref";
                if (paramref.getRef() != null && !paramref.getRef().equals("")) {
                    paramline = String.valueOf(paramline) + " ref=" + '\"' + this.encodeAttribute(paramref.getRef()) + '\"';
                }
                if (paramref.getUcd() != null && !paramref.getUcd().equals("")) {
                    paramline = String.valueOf(paramline) + " ucd=" + '\"' + this.encodeAttribute(paramref.getUcd()) + '\"';
                }
                if (paramref.getUtype() != null && !paramref.getUtype().equals("")) {
                    paramline = String.valueOf(paramline) + " utype=" + '\"' + this.encodeAttribute(paramref.getUtype()) + '\"';
                }
                paramline = String.valueOf(paramline) + "/>";
                if (paramref.getBelow() != "") {
                    paramline = String.valueOf(paramline) + "\n<!-- " + paramref.getBelow() + " -->\n";
                }
                this.dataBuffOutStream.write(paramline.getBytes());
                ++i;
            }
        }
        catch (Exception e) {
            System.err.println("writeParamRef : " + e);
        }
    }

    public void writeLink(LinkSet linkSet) {
        try {
            int k = 0;
            while (k < linkSet.getItemCount()) {
                String linkline = "";
                SavotLink link = (SavotLink)linkSet.getItemAt(k);
                if (((SavotLink)linkSet.getItemAt(k)).getAbove() != "") {
                    linkline = String.valueOf(linkline) + "\n<!-- " + ((SavotLink)linkSet.getItemAt(k)).getAbove() + " -->";
                }
                linkline = String.valueOf(linkline) + "\n<LINK";
                if (link.getID() != null && !link.getID().equals("")) {
                    linkline = String.valueOf(linkline) + " ID=" + '\"' + this.encodeAttribute(link.getID()) + '\"';
                }
                if (link.getContentRole() != null && !link.getContentRole().equals("")) {
                    linkline = String.valueOf(linkline) + " content-role=" + '\"' + this.encodeAttribute(link.getContentRole()) + '\"';
                }
                if (link.getContentType() != null && !link.getContentType().equals("")) {
                    linkline = String.valueOf(linkline) + " content-type=" + '\"' + this.encodeAttribute(link.getContentType()) + '\"';
                }
                if (link.getTitle() != null && !link.getTitle().equals("")) {
                    linkline = String.valueOf(linkline) + " title=" + '\"' + this.encodeAttribute(link.getTitle()) + '\"';
                }
                if (link.getValue() != null && !link.getValue().equals("")) {
                    linkline = String.valueOf(linkline) + " value=" + '\"' + this.encodeAttribute(link.getValue()) + '\"';
                }
                if (link.getHref() != null && !link.getHref().equals("")) {
                    linkline = String.valueOf(linkline) + " href=" + '\"' + this.encodeAttribute(link.getHref()) + '\"';
                }
                if (link.getGref() != null && !link.getGref().equals("")) {
                    linkline = String.valueOf(linkline) + " gref=" + '\"' + this.encodeAttribute(link.getGref()) + '\"';
                }
                if (link.getAction() != null && !link.getAction().equals("")) {
                    linkline = String.valueOf(linkline) + " action=" + '\"' + this.encodeAttribute(link.getAction()) + '\"';
                }
                if (link.getContent() != null && !link.getContent().equals("")) {
                    linkline = String.valueOf(linkline) + ">";
                    if (link.getBelow() != "") {
                        linkline = String.valueOf(linkline) + "\n<!-- " + link.getBelow() + " -->\n";
                    }
                    linkline = String.valueOf(linkline) + link.getContent();
                    this.dataBuffOutStream.write(linkline.getBytes());
                    this.dataBuffOutStream.write(linkend);
                } else {
                    linkline = String.valueOf(linkline) + "/>";
                    if (link.getBelow() != "") {
                        linkline = String.valueOf(linkline) + "\n<!-- " + link.getBelow() + " -->\n";
                    }
                    this.dataBuffOutStream.write(linkline.getBytes());
                }
                ++k;
            }
        }
        catch (Exception e) {
            System.err.println("writeLink : " + e);
        }
    }

    public void writeInfo(InfoSet infoSet) {
        try {
            if (infoSet != null) {
                int infocount = infoSet.getItemCount();
                int j = 0;
                while (j < infocount) {
                    String info = "";
                    if (((SavotInfo)infoSet.getItemAt(j)).getAbove() != "") {
                        info = String.valueOf(info) + "\n<!-- " + ((SavotInfo)infoSet.getItemAt(j)).getAbove() + " -->";
                    }
                    info = String.valueOf(info) + "\n<INFO";
                    if (!((SavotInfo)infoSet.getItemAt(j)).getId().equals("")) {
                        info = String.valueOf(info) + " ID=" + '\"' + this.encodeAttribute(((SavotInfo)infoSet.getItemAt(j)).getId()) + '\"';
                    }
                    if (!((SavotInfo)infoSet.getItemAt(j)).getName().equals("")) {
                        info = String.valueOf(info) + " name=" + '\"' + this.encodeAttribute(((SavotInfo)infoSet.getItemAt(j)).getName()) + '\"';
                    }
                    if (!((SavotInfo)infoSet.getItemAt(j)).getValue().equals("")) {
                        info = String.valueOf(info) + " value=" + '\"' + this.encodeAttribute(((SavotInfo)infoSet.getItemAt(j)).getValue()) + '\"';
                    }
                    if (!((SavotInfo)infoSet.getItemAt(j)).getXtype().equals("")) {
                        info = String.valueOf(info) + " xtype=" + '\"' + this.encodeAttribute(((SavotInfo)infoSet.getItemAt(j)).getXtype()) + '\"';
                    }
                    if (!((SavotInfo)infoSet.getItemAt(j)).getRef().equals("")) {
                        info = String.valueOf(info) + " ref=" + '\"' + this.encodeAttribute(((SavotInfo)infoSet.getItemAt(j)).getRef()) + '\"';
                    }
                    if (!((SavotInfo)infoSet.getItemAt(j)).getUnit().equals("")) {
                        info = String.valueOf(info) + " unit=" + '\"' + this.encodeAttribute(((SavotInfo)infoSet.getItemAt(j)).getUnit()) + '\"';
                    }
                    if (!((SavotInfo)infoSet.getItemAt(j)).getUcd().equals("")) {
                        info = String.valueOf(info) + " ucd=" + '\"' + this.encodeAttribute(((SavotInfo)infoSet.getItemAt(j)).getUcd()) + '\"';
                    }
                    if (!((SavotInfo)infoSet.getItemAt(j)).getUtype().equals("")) {
                        info = String.valueOf(info) + " utype=" + '\"' + this.encodeAttribute(((SavotInfo)infoSet.getItemAt(j)).getUtype()) + '\"';
                    }
                    if (((SavotInfo)infoSet.getItemAt(j)).getBelow() != "") {
                        info = String.valueOf(info) + "\n<!-- " + ((SavotInfo)infoSet.getItemAt(j)).getBelow() + " -->\n";
                    }
                    if (((SavotInfo)infoSet.getItemAt(j)).getContent() != null && ((SavotInfo)infoSet.getItemAt(j)).getContent().compareTo("") != 0) {
                        info = String.valueOf(info) + ">" + ((SavotInfo)infoSet.getItemAt(j)).getContent() + "</INFO>";
                    } else if (((SavotInfo)infoSet.getItemAt(j)).getDescription() != null && !((SavotInfo)infoSet.getItemAt(j)).getDescription().equals("") || ((SavotInfo)infoSet.getItemAt(j)).getValues() != null || ((SavotInfo)infoSet.getItemAt(j)).getLinks().getItemCount() != 0) {
                        info = String.valueOf(info) + ">";
                        if (((SavotInfo)infoSet.getItemAt(j)).getBelow() != "") {
                            info = String.valueOf(info) + "\n<!-- " + ((SavotInfo)infoSet.getItemAt(j)).getBelow() + " -->\n";
                        }
                        if (((SavotInfo)infoSet.getItemAt(j)).getDescription() != null && !((SavotInfo)infoSet.getItemAt(j)).getDescription().equals("")) {
                            if (((SavotInfo)infoSet.getItemAt(j)).getAbove() != "") {
                                info = "\n<!-- " + ((SavotInfo)infoSet.getItemAt(j)).getAbove() + " -->";
                            }
                            info = String.valueOf(info) + "\n<DESCRIPTION>";
                            if (((SavotInfo)infoSet.getItemAt(j)).getBelow() != "") {
                                info = String.valueOf(info) + "\n" + "<!-- " + ((SavotInfo)infoSet.getItemAt(j)).getBelow() + " -->" + "\n";
                            }
                            info = String.valueOf(info) + this.encodeElement(((SavotInfo)infoSet.getItemAt(j)).getDescription()) + "</DESCRIPTION>";
                        }
                        if (((SavotInfo)infoSet.getItemAt(j)).getValues() != null) {
                            this.writeValues(((SavotInfo)infoSet.getItemAt(j)).getValues());
                        }
                        if (((SavotInfo)infoSet.getItemAt(j)).getLinks().getItemCount() != 0) {
                            LinkSet links = ((SavotInfo)infoSet.getItemAt(j)).getLinks();
                            this.writeLink(links);
                        }
                        info = String.valueOf(info) + "</INFO>";
                    } else {
                        info = String.valueOf(info) + "/>";
                    }
                    this.dataBuffOutStream.write(info.getBytes());
                    ++j;
                }
            }
        }
        catch (Exception e) {
            System.err.println("writeInfo : " + e);
        }
    }

    public void writeField(FieldSet fieldSet) {
        try {
            int m = 0;
            while (m < fieldSet.getItemCount()) {
                SavotField field = (SavotField)fieldSet.getItemAt(m);
                String fieldline = "";
                if (field.getAbove() != "") {
                    fieldline = String.valueOf(fieldline) + "\n<!-- " + field.getAbove() + " -->";
                }
                fieldline = String.valueOf(fieldline) + "\n<FIELD";
                if (field.getId() != null && !field.getId().equals("")) {
                    fieldline = String.valueOf(fieldline) + " ID=" + '\"' + this.encodeAttribute(field.getId()) + '\"';
                }
                if (field.getName() != null && !field.getName().equals("")) {
                    fieldline = String.valueOf(fieldline) + " name=" + '\"' + this.encodeAttribute(field.getName()) + '\"';
                }
                if (field.getDataType() != null && !field.getDataType().equals("")) {
                    fieldline = String.valueOf(fieldline) + " datatype=" + '\"' + this.encodeAttribute(field.getDataType()) + '\"';
                }
                if (field.getPrecision() != null && !field.getPrecision().equals("")) {
                    fieldline = String.valueOf(fieldline) + " precision=" + '\"' + this.encodeAttribute(field.getPrecision()) + '\"';
                }
                if (field.getWidth() != null && !field.getWidth().equals("")) {
                    fieldline = String.valueOf(fieldline) + " width=" + '\"' + this.encodeAttribute(field.getWidth()) + '\"';
                }
                if (field.getXtype() != null && !field.getXtype().equals("")) {
                    fieldline = String.valueOf(fieldline) + " width=" + '\"' + this.encodeAttribute(field.getXtype()) + '\"';
                }
                if (field.getRef() != null && !field.getRef().equals("")) {
                    fieldline = String.valueOf(fieldline) + " ref=" + '\"' + this.encodeAttribute(field.getRef()) + '\"';
                }
                if (field.getUcd() != null && !field.getUcd().equals("")) {
                    fieldline = String.valueOf(fieldline) + " ucd=" + '\"' + this.encodeAttribute(field.getUcd()) + '\"';
                }
                if (field.getUtype() != null && !field.getUtype().equals("")) {
                    fieldline = String.valueOf(fieldline) + " utype=" + '\"' + this.encodeAttribute(field.getUtype()) + '\"';
                }
                if (field.getArraySize() != null && !field.getArraySize().equals("")) {
                    fieldline = String.valueOf(fieldline) + " arraysize=" + '\"' + this.encodeAttribute(field.getArraySize()) + '\"';
                }
                if (field.getType() != null && !field.getType().equals("")) {
                    fieldline = String.valueOf(fieldline) + " type=" + '\"' + this.encodeAttribute(field.getType()) + '\"';
                }
                if (field.getUnit() != null && !field.getUnit().equals("")) {
                    fieldline = String.valueOf(fieldline) + " unit=" + '\"' + this.encodeAttribute(field.getUnit()) + '\"';
                }
                if (field.getDescription() != null && !field.getDescription().equals("") || field.getValues() != null || field.getLinks().getItemCount() != 0) {
                    fieldline = String.valueOf(fieldline) + ">";
                    if (field.getBelow() != "") {
                        fieldline = String.valueOf(fieldline) + "\n<!-- " + field.getBelow() + " -->\n";
                    }
                    if (field.getDescription() != null && !field.getDescription().equals("")) {
                        if (field.getAbove() != "") {
                            fieldline = "\n<!-- " + field.getAbove() + " -->";
                        }
                        fieldline = String.valueOf(fieldline) + "\n<DESCRIPTION>";
                        if (field.getBelow() != "") {
                            fieldline = String.valueOf(fieldline) + "\n" + "<!-- " + field.getBelow() + " -->" + "\n";
                        }
                        fieldline = String.valueOf(fieldline) + this.encodeElement(field.getDescription()) + "</DESCRIPTION>";
                    }
                    this.dataBuffOutStream.write(fieldline.getBytes());
                    if (field.getValues() != null) {
                        this.writeValues(field.getValues());
                    }
                    if (field.getLinks().getItemCount() != 0) {
                        LinkSet links = field.getLinks();
                        this.writeLink(links);
                    }
                    this.dataBuffOutStream.write(fieldend);
                } else {
                    fieldline = String.valueOf(fieldline) + "/>";
                    this.dataBuffOutStream.write(fieldline.getBytes());
                }
                ++m;
            }
        }
        catch (Exception e) {
            System.err.println("writeField : " + e);
        }
    }

    public void writeFieldRef(FieldRefSet fieldRefSet) {
        try {
            int m = 0;
            while (m < fieldRefSet.getItemCount()) {
                SavotFieldRef fieldref = (SavotFieldRef)fieldRefSet.getItemAt(m);
                String fieldline = "";
                if (fieldref.getAbove() != "") {
                    fieldline = String.valueOf(fieldline) + "\n<!-- " + fieldref.getAbove() + " -->";
                }
                fieldline = String.valueOf(fieldline) + "\n<FIELDref";
                if (fieldref.getRef() != null && !fieldref.getRef().equals("")) {
                    fieldline = String.valueOf(fieldline) + " ref=" + '\"' + this.encodeAttribute(fieldref.getRef()) + '\"';
                }
                if (fieldref.getUcd() != null && !fieldref.getUcd().equals("")) {
                    fieldline = String.valueOf(fieldline) + " ucd=" + '\"' + this.encodeAttribute(fieldref.getUcd()) + '\"';
                }
                if (fieldref.getUtype() != null && !fieldref.getUtype().equals("")) {
                    fieldline = String.valueOf(fieldline) + " utype=" + '\"' + this.encodeAttribute(fieldref.getUtype()) + '\"';
                }
                fieldline = String.valueOf(fieldline) + "/>";
                this.dataBuffOutStream.write(fieldline.getBytes());
                ++m;
            }
        }
        catch (Exception e) {
            System.err.println("writeFieldref : " + e);
        }
    }

    public void writeStream(SavotStream stream) {
        try {
            String streamline = "";
            if (stream.getAbove() != "") {
                streamline = String.valueOf(streamline) + "\n<!-- " + stream.getAbove() + " -->";
            }
            streamline = String.valueOf(streamline) + "\n<STREAM";
            if (stream.getType() != null && !stream.getType().equals("")) {
                streamline = String.valueOf(streamline) + " type=" + '\"' + this.encodeAttribute(stream.getType()) + '\"';
            }
            if (stream.getHref() != null && !stream.getHref().equals("")) {
                streamline = String.valueOf(streamline) + " href=" + '\"' + this.encodeAttribute(stream.getHref()) + '\"';
            }
            if (stream.getActuate() != null && !stream.getActuate().equals("")) {
                streamline = String.valueOf(streamline) + " actuate=" + '\"' + this.encodeAttribute(stream.getActuate()) + '\"';
            }
            if (stream.getEncoding() != null && !stream.getEncoding().equals("")) {
                streamline = String.valueOf(streamline) + " encoding=" + '\"' + this.encodeAttribute(stream.getEncoding()) + '\"';
            }
            if (stream.getExpires() != null && !stream.getExpires().equals("")) {
                streamline = String.valueOf(streamline) + " expires=" + '\"' + this.encodeAttribute(stream.getExpires()) + '\"';
            }
            if (stream.getRights() != null && !stream.getRights().equals("")) {
                streamline = String.valueOf(streamline) + " rights=" + '\"' + this.encodeAttribute(stream.getRights()) + '\"';
            }
            streamline = String.valueOf(streamline) + ">";
            if (stream.getBelow() != "") {
                streamline = String.valueOf(streamline) + "\n<!-- " + stream.getBelow() + " -->\n";
            }
            this.dataBuffOutStream.write(streamline.getBytes());
            if (stream.getContent() != null && !stream.getContent().equals("")) {
                this.dataBuffOutStream.write(stream.getContent().getBytes());
            }
            this.dataBuffOutStream.write(streamend);
        }
        catch (Exception e) {
            System.err.println("writeStream : " + e);
        }
    }

    public void writeBinary(SavotBinary binary) {
        try {
            String binaryline = "";
            if (binary.getStream() != null) {
                if (binary.getAbove() != "") {
                    binaryline = "\n<!-- " + binary.getAbove() + " -->";
                    this.dataBuffOutStream.write(binaryline.getBytes());
                }
                this.dataBuffOutStream.write(binarybegin);
                if (binary.getBelow() != "") {
                    binaryline = "\n<!-- " + binary.getBelow() + " -->";
                    this.dataBuffOutStream.write(binaryline.getBytes());
                }
                this.writeStream(binary.getStream());
                this.dataBuffOutStream.write(binaryend);
            }
        }
        catch (Exception e) {
            System.err.println("writeBinary : " + e);
        }
    }

    public void writeValues(SavotValues values) {
        try {
            if (values == null) {
                return;
            }
            String valuesline = "";
            if (values.getAbove() != "") {
                valuesline = String.valueOf(valuesline) + "\n<!-- " + values.getAbove() + " -->";
            }
            valuesline = String.valueOf(valuesline) + "\n<VALUES";
            if (values.getId() != null && !values.getId().equals("")) {
                valuesline = String.valueOf(valuesline) + " ID=" + '\"' + this.encodeAttribute(values.getId()) + '\"';
            }
            if (values.getType() != null && !values.getType().equals("")) {
                valuesline = String.valueOf(valuesline) + " type=" + '\"' + this.encodeAttribute(values.getType()) + '\"';
            }
            if (values.getNull() != null && !values.getNull().equals("")) {
                valuesline = String.valueOf(valuesline) + " null=" + '\"' + this.encodeAttribute(values.getNull()) + '\"';
            }
            if (values.getRef() != null && !values.getRef().equals("")) {
                valuesline = String.valueOf(valuesline) + " ref=" + '\"' + this.encodeAttribute(values.getRef()) + '\"';
            }
            if (values.getInvalid() != null && !values.getInvalid().equals("")) {
                valuesline = String.valueOf(valuesline) + " invalid=" + '\"' + this.encodeAttribute(values.getInvalid()) + '\"';
            }
            valuesline = String.valueOf(valuesline) + ">";
            if (values.getBelow() != "") {
                valuesline = String.valueOf(valuesline) + "\n<!-- " + values.getBelow() + " -->\n";
            }
            this.dataBuffOutStream.write(valuesline.getBytes());
            valuesline = "";
            if (values.getMin() != null) {
                SavotMin min = values.getMin();
                this.writeMin(min);
            }
            if (values.getMax() != null) {
                SavotMax max = values.getMax();
                this.writeMax(max);
            }
            if (values.getOptions() != null) {
                OptionSet options = values.getOptions();
                this.writeOption(options);
            }
            this.dataBuffOutStream.write(valuesend);
        }
        catch (Exception e) {
            System.err.println("writeValues : " + e);
        }
    }

    public void writeFits(SavotFits fits) {
        try {
            String fitsline = "";
            if (fits.getAbove() != "") {
                fitsline = String.valueOf(fitsline) + "\n<!-- " + fits.getAbove() + " -->";
            }
            fitsline = String.valueOf(fitsline) + "\n<FITS";
            if (fits.getExtnum() != null && !fits.getExtnum().equals("")) {
                fitsline = String.valueOf(fitsline) + " extnum=" + '\"' + this.encodeAttribute(fits.getExtnum()) + '\"';
            }
            fitsline = String.valueOf(fitsline) + ">";
            if (fits.getBelow() != "") {
                fitsline = String.valueOf(fitsline) + "\n<!-- " + fits.getBelow() + " -->\n";
            }
            this.dataBuffOutStream.write(fitsline.getBytes());
            fitsline = "";
            if (fits.getStream() != null) {
                SavotStream stream = fits.getStream();
                this.writeStream(stream);
            }
            this.dataBuffOutStream.write(fitsend);
        }
        catch (Exception e) {
            System.err.println("writeFits : " + e);
        }
    }

    public void writeMin(SavotMin min) {
        try {
            String minline = "";
            if (min.getAbove() != "") {
                minline = String.valueOf(minline) + "\n<!-- " + min.getAbove() + " -->";
            }
            minline = String.valueOf(minline) + "\n<MIN";
            if (min.getValue() != null && !min.getValue().equals("")) {
                minline = String.valueOf(minline) + " value=" + '\"' + this.encodeAttribute(min.getValue()) + '\"';
            }
            if (min.getInclusive() != null && !min.getInclusive().equals("")) {
                minline = String.valueOf(minline) + " inclusive=" + '\"' + this.encodeAttribute(min.getInclusive()) + '\"';
            }
            if (min.getContent() != null && !min.getContent().equals("")) {
                minline = String.valueOf(minline) + ">";
                if (min.getBelow() != "") {
                    minline = String.valueOf(minline) + "\n<!-- " + min.getBelow() + " -->\n";
                }
                minline = String.valueOf(minline) + min.getContent();
                this.dataBuffOutStream.write(minline.getBytes());
                this.dataBuffOutStream.write(minend);
            } else {
                minline = String.valueOf(minline) + "/>";
                if (min.getBelow() != "") {
                    minline = String.valueOf(minline) + "\n<!-- " + min.getBelow() + " -->\n";
                }
                this.dataBuffOutStream.write(minline.getBytes());
            }
        }
        catch (Exception e) {
            System.err.println("writeMin : " + e);
        }
    }

    public void writeMax(SavotMax max) {
        try {
            String maxline = "";
            if (max.getAbove() != "") {
                maxline = String.valueOf(maxline) + "\n<!-- " + max.getAbove() + " -->";
            }
            maxline = String.valueOf(maxline) + "\n<MAX";
            if (max.getValue() != null && !max.getValue().equals("")) {
                maxline = String.valueOf(maxline) + " value=" + '\"' + this.encodeAttribute(max.getValue()) + '\"';
            }
            if (max.getInclusive() != null && !max.getInclusive().equals("")) {
                maxline = String.valueOf(maxline) + " inclusive=" + '\"' + this.encodeAttribute(max.getInclusive()) + '\"';
            }
            if (max.getContent() != null && !max.getContent().equals("")) {
                maxline = String.valueOf(maxline) + ">";
                if (max.getBelow() != "") {
                    maxline = String.valueOf(maxline) + "\n<!-- " + max.getBelow() + " -->\n";
                }
                maxline = String.valueOf(maxline) + max.getContent();
                this.dataBuffOutStream.write(maxline.getBytes());
                this.dataBuffOutStream.write(maxend);
            } else {
                maxline = String.valueOf(maxline) + "/>";
                if (max.getBelow() != "") {
                    maxline = String.valueOf(maxline) + "\n<!-- " + max.getBelow() + " -->\n";
                }
                this.dataBuffOutStream.write(maxline.getBytes());
            }
        }
        catch (Exception e) {
            System.err.println("writeMax : " + e);
        }
    }

    public void writeOption(OptionSet optionSet) {
        try {
            int m = 0;
            while (m < optionSet.getItemCount()) {
                String optionline = "";
                SavotOption option = (SavotOption)optionSet.getItemAt(m);
                if (option.getAbove() != "") {
                    optionline = String.valueOf(optionline) + "\n<!-- " + option.getAbove() + " -->";
                }
                optionline = String.valueOf(optionline) + "\n<OPTION";
                if (option.getName() != null && !option.getName().equals("")) {
                    optionline = String.valueOf(optionline) + " name=" + '\"' + this.encodeAttribute(option.getName()) + '\"';
                }
                if (option.getValue() != null && !option.getValue().equals("")) {
                    optionline = String.valueOf(optionline) + " value=" + '\"' + this.encodeAttribute(option.getValue()) + '\"';
                }
                if (option.getOptions().getItemCount() != 0) {
                    optionline = String.valueOf(optionline) + ">";
                    if (option.getBelow() != "") {
                        optionline = String.valueOf(optionline) + "\n<!-- " + option.getBelow() + " -->\n";
                    }
                    OptionSet options = option.getOptions();
                    this.dataBuffOutStream.write(optionline.getBytes());
                    this.writeOption(options);
                    this.dataBuffOutStream.write(optionend);
                } else {
                    optionline = String.valueOf(optionline) + "/>";
                    if (option.getBelow() != "") {
                        optionline = String.valueOf(optionline) + "\n<!-- " + option.getBelow() + " -->\n";
                    }
                    this.dataBuffOutStream.write(optionline.getBytes());
                }
                ++m;
            }
        }
        catch (Exception e) {
            System.err.println("writeOption : " + e);
        }
    }

    public void writeGroup(GroupSet groupSet) {
        try {
            int m = 0;
            while (m < groupSet.getItemCount()) {
                SavotSet groups;
                String groupline = "";
                SavotGroup group = (SavotGroup)groupSet.getItemAt(m);
                if (group.getAbove() != "") {
                    groupline = String.valueOf(groupline) + "\n<!-- " + group.getAbove() + " -->";
                }
                groupline = String.valueOf(groupline) + "\n<GROUP";
                if (group.getId() != null && !group.getId().equals("")) {
                    groupline = String.valueOf(groupline) + " ID=" + '\"' + this.encodeAttribute(group.getId()) + '\"';
                }
                if (group.getName() != null && !group.getName().equals("")) {
                    groupline = String.valueOf(groupline) + " name=" + '\"' + this.encodeAttribute(group.getName()) + '\"';
                }
                if (group.getRef() != null && !group.getRef().equals("")) {
                    groupline = String.valueOf(groupline) + " ref=" + '\"' + this.encodeAttribute(group.getRef()) + '\"';
                }
                if (group.getUcd() != null && !group.getUcd().equals("")) {
                    groupline = String.valueOf(groupline) + " ucd=" + '\"' + this.encodeAttribute(group.getUcd()) + '\"';
                }
                if (group.getUtype() != null && !group.getUtype().equals("")) {
                    groupline = String.valueOf(groupline) + " utype=" + '\"' + this.encodeAttribute(group.getUtype()) + '\"';
                }
                groupline = String.valueOf(groupline) + ">";
                if (group.getBelow() != "") {
                    groupline = String.valueOf(groupline) + "\n<!-- " + group.getBelow() + " -->\n";
                }
                if (group.getDescription() != null && !group.getDescription().equals("")) {
                    if (group.getAbove() != "") {
                        groupline = "\n<!-- " + group.getAbove() + " -->";
                    }
                    groupline = String.valueOf(groupline) + "\n<DESCRIPTION>";
                    if (group.getBelow() != "") {
                        groupline = String.valueOf(groupline) + "\n" + "<!-- " + group.getBelow() + " -->" + "\n";
                    }
                    groupline = String.valueOf(groupline) + this.encodeElement(group.getDescription()) + "</DESCRIPTION>";
                }
                this.dataBuffOutStream.write(groupline.getBytes());
                if (group.getFieldsRef().getItemCount() != 0) {
                    FieldRefSet reffields = group.getFieldsRef();
                    this.writeFieldRef(reffields);
                }
                if (group.getParamsRef().getItemCount() != 0) {
                    ParamRefSet refgroups = group.getParamsRef();
                    this.writeParamRef(refgroups);
                }
                if (group.getParams().getItemCount() != 0) {
                    groups = group.getParams();
                    this.writeParam((ParamSet)groups);
                }
                if (group.getGroups().getItemCount() != 0) {
                    groups = group.getGroups();
                    this.writeGroup((GroupSet)groups);
                }
                this.dataBuffOutStream.write(groupend);
                ++m;
            }
        }
        catch (Exception e) {
            System.err.println("writeGroup : " + e);
        }
    }

    public void writeTableBegin(SavotTable table) {
        try {
            String tableline = "";
            tableline = String.valueOf(tableline) + "\n<TABLE";
            if (table.getId() != null && !table.getId().equals("")) {
                tableline = String.valueOf(tableline) + " ID=" + '\"' + this.encodeAttribute(table.getId()) + '\"';
            }
            if (table.getName() != null && !table.getName().equals("")) {
                tableline = String.valueOf(tableline) + " name=" + '\"' + this.encodeAttribute(table.getName()) + '\"';
            }
            if (table.getRef() != null && !table.getRef().equals("")) {
                tableline = String.valueOf(tableline) + " ref=" + '\"' + this.encodeAttribute(table.getRef()) + '\"';
            }
            if (table.getUcd() != null && !table.getUcd().equals("")) {
                tableline = String.valueOf(tableline) + " ucd=" + '\"' + this.encodeAttribute(table.getUcd()) + '\"';
            }
            if (table.getUtype() != null && !table.getUtype().equals("")) {
                tableline = String.valueOf(tableline) + " utype=" + '\"' + this.encodeAttribute(table.getUtype()) + '\"';
            }
            if (table.getNrows() != null && !table.getNrows().equals("")) {
                tableline = String.valueOf(tableline) + " nrows=" + '\"' + this.encodeAttribute(table.getNrows()) + '\"';
            }
            tableline = String.valueOf(tableline) + ">";
            this.dataBuffOutStream.write(tableline.getBytes());
            if (table.getDescription() != null && !table.getDescription().equals("")) {
                this.writeDescription(table.getDescription());
            }
        }
        catch (Exception e) {
            System.err.println("writeResourceBegin : " + e);
            e.printStackTrace();
        }
    }

    public void writeTableEnd() {
        try {
            this.dataBuffOutStream.write(tableend);
        }
        catch (Exception e) {
            System.err.println("writeTableEnd : " + e);
            e.printStackTrace();
        }
    }

    public void writeResourceBegin(SavotResource resource) {
        try {
            String line = "";
            line = String.valueOf(line) + "\n<RESOURCE";
            if (!resource.getName().equals("")) {
                line = String.valueOf(line) + " name=" + '\"' + this.encodeAttribute(resource.getName()) + '\"';
            }
            if (!resource.getId().equals("")) {
                line = String.valueOf(line) + " ID=" + '\"' + this.encodeAttribute(resource.getId()) + '\"';
            }
            if (!resource.getUtype().equals("")) {
                line = String.valueOf(line) + " utype=" + '\"' + this.encodeAttribute(resource.getUtype()) + '\"';
            }
            if (!resource.getType().equals("")) {
                line = String.valueOf(line) + " type=" + '\"' + this.encodeAttribute(resource.getType()) + '\"';
            }
            line = String.valueOf(line) + ">";
            this.dataBuffOutStream.write(line.getBytes());
        }
        catch (Exception e) {
            System.err.println("writeResourceBegin : " + e);
            e.printStackTrace();
        }
    }

    public void writeResourceEnd() {
        try {
            this.dataBuffOutStream.write(resourceend);
        }
        catch (Exception e) {
            System.err.println("writeResourceEnd : " + e);
            e.printStackTrace();
        }
    }

    public void writeTableDataBegin() {
        try {
            this.dataBuffOutStream.write(tabledatabegin);
        }
        catch (Exception e) {
            System.err.println("writeTableDataBegin : " + e);
            e.printStackTrace();
        }
    }

    public void writeTableDataEnd() {
        try {
            this.dataBuffOutStream.write("\n".getBytes());
            this.dataBuffOutStream.write(tabledataend);
        }
        catch (Exception e) {
            System.err.println("writeTableDataEnd : " + e);
            e.printStackTrace();
        }
    }

    public void writeDataBegin() {
        try {
            this.dataBuffOutStream.write(databegin);
        }
        catch (Exception e) {
            System.err.println("writeDataBegin : " + e);
            e.printStackTrace();
        }
    }

    public void writeDataEnd() {
        try {
            this.dataBuffOutStream.write("\n".getBytes());
            this.dataBuffOutStream.write(dataend);
        }
        catch (Exception e) {
            System.err.println("writeDataEnd : " + e);
            e.printStackTrace();
        }
    }

    public void writeTR(SavotTR tr) {
        try {
            TDSet tds = tr.getTDSet();
            this.dataBuffOutStream.write(trbegin);
            int r = 0;
            while (r < tds.getItemCount()) {
                this.dataBuffOutStream.write(tdbegin1);
                if (((SavotTD)tds.getItemAt(r)).getEncoding() != null && !((SavotTD)tds.getItemAt(r)).getEncoding().equals("")) {
                    this.dataBuffOutStream.write((" encoding=\"" + ((SavotTD)tds.getItemAt(r)).getEncoding() + '\"').getBytes());
                }
                this.dataBuffOutStream.write(tdbegin2);
                if (this.elementEntities) {
                    this.dataBuffOutStream.write(this.encodeElement(tds.getContent(r)).getBytes());
                } else {
                    this.dataBuffOutStream.write(tds.getByteContent(r));
                }
                this.dataBuffOutStream.write(tdend);
                ++r;
            }
            this.dataBuffOutStream.write(trend);
        }
        catch (Exception e) {
            System.err.println("writeTREnd : " + e);
            e.printStackTrace();
        }
    }

    public void writeResource(ResourceSet resourceset) {
        try {
            if (resourceset != null) {
                int resourcecount = resourceset.getItemCount();
                int i = 0;
                while (i < resourcecount) {
                    String resource = "";
                    if (((SavotResource)resourceset.getItemAt(i)).getAbove() != "") {
                        resource = String.valueOf(resource) + "\n<!-- " + ((SavotResource)resourceset.getItemAt(i)).getAbove() + " -->";
                    }
                    resource = String.valueOf(resource) + "\n<RESOURCE";
                    if (!((SavotResource)resourceset.getItemAt(i)).getName().equals("")) {
                        resource = String.valueOf(resource) + " name=" + '\"' + this.encodeAttribute(((SavotResource)resourceset.getItemAt(i)).getName()) + '\"';
                    }
                    if (!((SavotResource)resourceset.getItemAt(i)).getId().equals("")) {
                        resource = String.valueOf(resource) + " ID=" + '\"' + this.encodeAttribute(((SavotResource)resourceset.getItemAt(i)).getId()) + '\"';
                    }
                    if (!((SavotResource)resourceset.getItemAt(i)).getUtype().equals("")) {
                        resource = String.valueOf(resource) + " utype=" + '\"' + this.encodeAttribute(((SavotResource)resourceset.getItemAt(i)).getUtype()) + '\"';
                    }
                    if (!((SavotResource)resourceset.getItemAt(i)).getType().equals("")) {
                        resource = String.valueOf(resource) + " type=" + '\"' + this.encodeAttribute(((SavotResource)resourceset.getItemAt(i)).getType()) + '\"';
                    }
                    resource = String.valueOf(resource) + ">";
                    if (((SavotResource)resourceset.getItemAt(i)).getBelow() != "") {
                        resource = String.valueOf(resource) + "\n<!-- " + ((SavotResource)resourceset.getItemAt(i)).getBelow() + " -->\n";
                    }
                    this.dataBuffOutStream.write(resource.getBytes());
                    if (!((SavotResource)resourceset.getItemAt(i)).getDescription().equals("")) {
                        String description = "";
                        description = "\n<DESCRIPTION>" + this.encodeElement(((SavotResource)resourceset.getItemAt(i)).getDescription()) + "</DESCRIPTION>";
                        this.dataBuffOutStream.write(description.getBytes());
                    }
                    InfoSet infoset = ((SavotResource)resourceset.getItemAt(i)).getInfos();
                    this.writeInfo(infoset);
                    CoosysSet coosysSet = ((SavotResource)resourceset.getItemAt(i)).getCoosys();
                    this.writeCoosys(coosysSet);
                    GroupSet groupSet = ((SavotResource)resourceset.getItemAt(i)).getGroups();
                    this.writeGroup(groupSet);
                    ParamSet params = ((SavotResource)resourceset.getItemAt(i)).getParams();
                    this.writeParam(params);
                    LinkSet linkSet = ((SavotResource)resourceset.getItemAt(i)).getLinks();
                    this.writeLink(linkSet);
                    TableSet tableSet = ((SavotResource)resourceset.getItemAt(i)).getTables();
                    String tableline = "";
                    int k = 0;
                    while (k < tableSet.getItemCount()) {
                        SavotTable table = (SavotTable)tableSet.getItemAt(k);
                        tableline = "";
                        if (table.getAbove() != "") {
                            tableline = String.valueOf(tableline) + "\n<!-- " + table.getAbove() + " -->";
                        }
                        tableline = String.valueOf(tableline) + "\n<TABLE";
                        if (table.getId() != null && !table.getId().equals("")) {
                            tableline = String.valueOf(tableline) + " ID=" + '\"' + this.encodeAttribute(table.getId()) + '\"';
                        }
                        if (table.getName() != null && !table.getName().equals("")) {
                            tableline = String.valueOf(tableline) + " name=" + '\"' + this.encodeAttribute(table.getName()) + '\"';
                        }
                        if (table.getRef() != null && !table.getRef().equals("")) {
                            tableline = String.valueOf(tableline) + " ref=" + '\"' + this.encodeAttribute(table.getRef()) + '\"';
                        }
                        if (table.getUcd() != null && !table.getUcd().equals("")) {
                            tableline = String.valueOf(tableline) + " ucd=" + '\"' + this.encodeAttribute(table.getUcd()) + '\"';
                        }
                        if (table.getUtype() != null && !table.getUtype().equals("")) {
                            tableline = String.valueOf(tableline) + " utype=" + '\"' + this.encodeAttribute(table.getUtype()) + '\"';
                        }
                        if (table.getNrows() != null && !table.getNrows().equals("")) {
                            tableline = String.valueOf(tableline) + " nrows=" + '\"' + this.encodeAttribute(table.getNrows()) + '\"';
                        }
                        tableline = String.valueOf(tableline) + ">";
                        if (table.getBelow() != "") {
                            tableline = String.valueOf(tableline) + "\n<!-- " + table.getBelow() + " -->\n";
                        }
                        if (!table.getDescription().equals("")) {
                            String description = "\n<DESCRIPTION>" + this.encodeElement(table.getDescription()) + "</DESCRIPTION>";
                            tableline = String.valueOf(tableline) + description;
                        }
                        this.dataBuffOutStream.write(tableline.getBytes());
                        tableline = "";
                        FieldSet fieldSet = table.getFields();
                        this.writeField(fieldSet);
                        ParamSet paramSet = table.getParams();
                        this.writeParam(paramSet);
                        GroupSet groupSet1 = table.getGroups();
                        this.writeGroup(groupSet1);
                        linkSet = table.getLinks();
                        this.writeLink(linkSet);
                        if (table.getData() != null) {
                            this.dataBuffOutStream.write(databegin);
                            SavotData data = table.getData();
                            if (data.getTableData() != null) {
                                this.dataBuffOutStream.write(tabledatabegin);
                                SavotTableData tableData = data.getTableData();
                                TRSet trs = tableData.getTRs();
                                int p = 0;
                                while (p < trs.getItemCount()) {
                                    TDSet tds = trs.getTDSet(p);
                                    this.dataBuffOutStream.write(trbegin);
                                    int r = 0;
                                    while (r < tds.getItemCount()) {
                                        if (((SavotTD)tds.getItemAt(r)).getAbove() != "") {
                                            this.dataBuffOutStream.write(("\n<!-- " + ((SavotTD)tds.getItemAt(r)).getAbove() + " -->\n").getBytes());
                                        }
                                        this.dataBuffOutStream.write(tdbegin1);
                                        if (((SavotTD)tds.getItemAt(r)).getEncoding() != null && !((SavotTD)tds.getItemAt(r)).getEncoding().equals("")) {
                                            this.dataBuffOutStream.write((" encoding=\"" + ((SavotTD)tds.getItemAt(r)).getEncoding() + '\"').getBytes());
                                        }
                                        this.dataBuffOutStream.write(tdbegin2);
                                        if (((SavotTD)tds.getItemAt(r)).getBelow() != "") {
                                            this.dataBuffOutStream.write(("\n<!-- " + ((SavotTD)tds.getItemAt(r)).getBelow() + " -->\n").getBytes());
                                        }
                                        if (this.elementEntities) {
                                            this.dataBuffOutStream.write(this.encodeElement(tds.getContent(r)).getBytes());
                                        } else {
                                            this.dataBuffOutStream.write(tds.getByteContent(r));
                                        }
                                        this.dataBuffOutStream.write(tdend);
                                        ++r;
                                    }
                                    this.dataBuffOutStream.write(trend);
                                    ++p;
                                }
                                this.dataBuffOutStream.write(tabledataend);
                            }
                            if (data.getBinary() != null) {
                                this.writeBinary(data.getBinary());
                            }
                            if (data.getFits() != null) {
                                this.writeFits(data.getFits());
                            }
                            this.dataBuffOutStream.write(dataend);
                        }
                        InfoSet infosAtEnd = table.getInfosAtEnd();
                        this.writeInfo(infosAtEnd);
                        this.dataBuffOutStream.write(tableend);
                        ++k;
                    }
                    if (((SavotResource)resourceset.getItemAt(i)).getResources().getItemCount() != 0) {
                        this.writeResource(((SavotResource)resourceset.getItemAt(i)).getResources());
                    }
                    InfoSet infosAtEnd = ((SavotResource)resourceset.getItemAt(i)).getInfosAtEnd();
                    this.writeInfo(infosAtEnd);
                    this.dataBuffOutStream.write(resourceend);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            System.err.println("writeResource : " + e);
            e.printStackTrace();
        }
    }
}

