/*
 * Decompiled with CFR 0.152.
 */
package cds.savot.sax;

import cds.savot.common.Markups;
import cds.savot.model.SavotResource;
import cds.savot.sax.SavotSAXConsumer;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Vector;
import org.xmlpull.v1.XmlPullParser;

public class SavotSAXEngine
implements Markups {
    private boolean trace = false;
    protected XmlPullParser parser = null;
    SavotSAXConsumer consumer;
    Vector<String> father = new Vector();

    public SavotSAXEngine() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public SavotSAXEngine(SavotSAXConsumer consumer, XmlPullParser parser, String file, boolean debug) {
        try {
            this.parser = parser;
            this.consumer = consumer;
            this.enableDebug(debug);
            FileInputStream inStream = new FileInputStream(new File(file));
            BufferedInputStream dataBuffInStream = new BufferedInputStream(inStream);
            parser.setInput(dataBuffInStream, "UTF-8");
            this.parse(parser);
        }
        catch (IOException e) {
            System.err.println("Exception SavotSAXEngine : " + e);
        }
        catch (Exception f) {
            System.err.println("Exception SavotSAXEngine : " + f);
        }
    }

    public SavotSAXEngine(SavotSAXConsumer consumer, XmlPullParser parser, URL url, String enc, boolean debug) {
        try {
            this.parser = parser;
            this.consumer = consumer;
            this.enableDebug(debug);
            parser.setInput(new DataInputStream(url.openStream()), enc);
            this.parse(parser);
        }
        catch (IOException e) {
            System.err.println("Exception SavotSAXEngine : " + e);
        }
        catch (Exception f) {
            System.err.println("Exception SavotSAXEngine : " + f);
        }
    }

    public SavotSAXEngine(SavotSAXConsumer consumer, XmlPullParser parser, InputStream instream, String enc, boolean debug) {
        try {
            this.parser = parser;
            this.consumer = consumer;
            this.enableDebug(debug);
            BufferedInputStream dataBuffInStream = new BufferedInputStream(instream);
            parser.setInput(dataBuffInStream, enc);
            this.parse(parser);
        }
        catch (IOException e) {
            System.err.println("Exception SavotSAXEngine : " + e);
        }
        catch (Exception f) {
            System.err.println("Exception SavotSAXEngine : " + f);
        }
    }

    public void parse(XmlPullParser parser) throws IOException {
        String currentMarkup = "XML";
        try {
            int eventType = parser.getEventType();
            this.father.addElement(parser.getName());
            while (eventType != 1) {
                switch (eventType) {
                    case 2: {
                        try {
                            Vector<SavotResource> attributes;
                            currentMarkup = parser.getName();
                            this.father.addElement(parser.getName());
                            if (this.trace) {
                                System.err.println("Name ---> " + parser.getName());
                            }
                            if (currentMarkup == null) break;
                            if (currentMarkup.equalsIgnoreCase("VOTABLE")) {
                                attributes = new Vector<SavotResource>();
                                if (parser.getAttributeCount() != 0) {
                                    if (parser.getAttributeValue(null, "version") != null) {
                                        attributes.addElement((SavotResource)((Object)"version"));
                                        attributes.addElement((SavotResource)((Object)parser.getAttributeValue(null, "version")));
                                    }
                                    if (parser.getAttributeValue(null, "id") != null) {
                                        attributes.addElement((SavotResource)((Object)"id"));
                                        attributes.addElement((SavotResource)((Object)parser.getAttributeValue(null, "id")));
                                    }
                                    this.consumer.startVotable(attributes);
                                }
                                if (!this.trace) break;
                                System.err.println("VOTABLE begin");
                                break;
                            }
                            if (currentMarkup.equalsIgnoreCase("DESCRIPTION")) {
                                this.consumer.startDescription();
                                if (!this.trace) break;
                                System.err.println("DESCRIPTION begin");
                                break;
                            }
                            if (currentMarkup.equalsIgnoreCase("RESOURCE")) {
                                attributes = new Vector();
                                if (parser.getAttributeCount() != 0) {
                                    if (parser.getAttributeValue(null, "name") != null) {
                                        attributes.addElement((SavotResource)((Object)"name"));
                                        attributes.addElement((SavotResource)((Object)parser.getAttributeValue(null, "name")));
                                    }
                                    if (parser.getAttributeValue(null, "type") != null) {
                                        attributes.addElement((SavotResource)((Object)"type"));
                                        attributes.addElement((SavotResource)((Object)parser.getAttributeValue(null, "type")));
                                    }
                                    if (parser.getAttributeValue(null, "utype") != null) {
                                        attributes.addElement((SavotResource)((Object)"utype"));
                                        attributes.addElement((SavotResource)((Object)parser.getAttributeValue(null, "utype")));
                                    }
                                    if (parser.getAttributeValue(null, "id") != null) {
                                        attributes.addElement((SavotResource)((Object)"id"));
                                        attributes.addElement((SavotResource)((Object)parser.getAttributeValue(null, "id")));
                                    }
                                }
                                this.consumer.startResource(attributes);
                                if (!this.trace) break;
                                System.err.println("RESOURCE");
                                break;
                            }
                            if (currentMarkup.equalsIgnoreCase("TABLE")) {
                                attributes = new Vector();
                                if (parser.getAttributeCount() != 0) {
                                    if (parser.getAttributeValue(null, "name") != null) {
                                        attributes.addElement((SavotResource)((Object)"name"));
                                        attributes.addElement((SavotResource)((Object)parser.getAttributeValue(null, "name")));
                                    }
                                    if (parser.getAttributeValue(null, "ucd") != null) {
                                        attributes.addElement((SavotResource)((Object)"ucd"));
                                        attributes.addElement((SavotResource)((Object)parser.getAttributeValue(null, "ucd")));
                                    }
                                    if (parser.getAttributeValue(null, "utype") != null) {
                                        attributes.addElement((SavotResource)((Object)"utype"));
                                        attributes.addElement((SavotResource)((Object)parser.getAttributeValue(null, "utype")));
                                    }
                                    if (parser.getAttributeValue(null, "ref") != null) {
                                        attributes.addElement((SavotResource)((Object)"ref"));
                                        attributes.addElement((SavotResource)((Object)parser.getAttributeValue(null, "ref")));
                                    }
                                    if (parser.getAttributeValue(null, "id") != null) {
                                        attributes.addElement((SavotResource)((Object)"id"));
                                        attributes.addElement((SavotResource)((Object)parser.getAttributeValue(null, "id")));
                                    }
                                    if (parser.getAttributeValue(null, "nrows") != null) {
                                        attributes.addElement((SavotResource)((Object)"nrows"));
                                        attributes.addElement((SavotResource)((Object)parser.getAttributeValue(null, "nrows")));
                                    }
                                }
                                this.consumer.startTable(attributes);
                                if (!this.trace) break;
                                System.err.println("TABLE begin");
                                break;
                            }
                            if (currentMarkup.equalsIgnoreCase("FIELD")) {
                                attributes = new Vector();
                                if (parser.getAttributeCount() != 0) {
                                    if (parser.getAttributeValue(null, "unit") != null) {
                                        attributes.addElement((SavotResource)((Object)"unit"));
                                        attributes.addElement((SavotResource)((Object)parser.getAttributeValue(null, "unit")));
                                    }
                                    if (parser.getAttributeValue(null, "datatype") != null) {
                                        attributes.addElement((SavotResource)((Object)"datatype"));
                                        attributes.addElement((SavotResource)((Object)parser.getAttributeValue(null, "datatype")));
                                    }
                                    if (parser.getAttributeValue(null, "precision") != null) {
                                        attributes.addElement((SavotResource)((Object)"precision"));
                                        attributes.addElement((SavotResource)((Object)parser.getAttributeValue(null, "precision")));
                                    }
                                    if (parser.getAttributeValue(null, "width") != null) {
                                        attributes.addElement((SavotResource)((Object)"width"));
                                        attributes.addElement((SavotResource)((Object)parser.getAttributeValue(null, "width")));
                                    }
                                    if (parser.getAttributeValue(null, "xtype") != null) {
                                        attributes.addElement((SavotResource)((Object)"xtype"));
                                        attributes.addElement((SavotResource)((Object)parser.getAttributeValue(null, "xtype")));
                                    }
                                    if (parser.getAttributeValue(null, "ref") != null) {
                                        attributes.addElement((SavotResource)((Object)"ref"));
                                        attributes.addElement((SavotResource)((Object)parser.getAttributeValue(null, "ref")));
                                    }
                                    if (parser.getAttributeValue(null, "name") != null) {
                                        attributes.addElement((SavotResource)((Object)"name"));
                                        attributes.addElement((SavotResource)((Object)parser.getAttributeValue(null, "name")));
                                    }
                                    if (parser.getAttributeValue(null, "ucd") != null) {
                                        attributes.addElement((SavotResource)((Object)"ucd"));
                                        attributes.addElement((SavotResource)((Object)parser.getAttributeValue(null, "ucd")));
                                    }
                                    if (parser.getAttributeValue(null, "arraysize") != null) {
                                        attributes.addElement((SavotResource)((Object)"arraysize"));
                                        attributes.addElement((SavotResource)((Object)parser.getAttributeValue(null, "arraysize")));
                                    }
                                    if (parser.getAttributeValue(null, "type") != null) {
                                        attributes.addElement((SavotResource)((Object)"type"));
                                        attributes.addElement((SavotResource)((Object)parser.getAttributeValue(null, "type")));
                                    }
                                    if (parser.getAttributeValue(null, "utype") != null) {
                                        attributes.addElement((SavotResource)((Object)"utype"));
                                        attributes.addElement((SavotResource)((Object)parser.getAttributeValue(null, "utype")));
                                    }
                                    if (parser.getAttributeValue(null, "id") != null) {
                                        attributes.addElement((SavotResource)((Object)"id"));
                                        attributes.addElement((SavotResource)((Object)parser.getAttributeValue(null, "id")));
                                    }
                                }
                                this.consumer.startField(attributes);
                                if (!this.trace) break;
                                System.err.println("FIELD begin");
                                break;
                            }
                            if (currentMarkup.equalsIgnoreCase("FIELDref")) {
                                attributes = new Vector();
                                if (parser.getAttributeCount() != 0) {
                                    if (parser.getAttributeValue(null, "ref") != null) {
                                        attributes.addElement((SavotResource)((Object)"ref"));
                                    }
                                    attributes.addElement((SavotResource)((Object)parser.getAttributeValue(null, "ref")));
                                }
                                this.consumer.startFieldref(attributes);
                                if (!this.trace) break;
                                System.err.println("FIELDREF begin");
                                break;
                            }
                            if (currentMarkup.equalsIgnoreCase("VALUES")) {
                                attributes = new Vector();
                                if (parser.getAttributeCount() != 0) {
                                    if (parser.getAttributeValue(null, "type") != null) {
                                        attributes.addElement((SavotResource)((Object)"type"));
                                        attributes.addElement((SavotResource)((Object)parser.getAttributeValue(null, "type")));
                                    }
                                    if (parser.getAttributeValue(null, "null") != null) {
                                        attributes.addElement((SavotResource)((Object)"null"));
                                        attributes.addElement((SavotResource)((Object)parser.getAttributeValue(null, "null")));
                                    }
                                    if (parser.getAttributeValue(null, "invalid") != null) {
                                        attributes.addElement((SavotResource)((Object)"invalid"));
                                        attributes.addElement((SavotResource)((Object)parser.getAttributeValue(null, "invalid")));
                                    }
                                    if (parser.getAttributeValue(null, "ref") != null) {
                                        attributes.addElement((SavotResource)((Object)"ref"));
                                        attributes.addElement((SavotResource)((Object)parser.getAttributeValue(null, "ref")));
                                    }
                                    if (parser.getAttributeValue(null, "id") != null) {
                                        attributes.addElement((SavotResource)((Object)"id"));
                                        attributes.addElement((SavotResource)((Object)parser.getAttributeValue(null, "id")));
                                    }
                                }
                                this.consumer.startValues(attributes);
                                if (!this.trace) break;
                                System.err.println("VALUES begin");
                                break;
                            }
                            if (currentMarkup.equalsIgnoreCase("STREAM")) {
                                attributes = new Vector();
                                if (parser.getAttributeCount() != 0) {
                                    if (parser.getAttributeValue(null, "type") != null) {
                                        attributes.addElement((SavotResource)((Object)"type"));
                                        attributes.addElement((SavotResource)((Object)parser.getAttributeValue(null, "type")));
                                    }
                                    if (parser.getAttributeValue(null, "href") != null) {
                                        attributes.addElement((SavotResource)((Object)"href"));
                                        attributes.addElement((SavotResource)((Object)parser.getAttributeValue(null, "href")));
                                    }
                                    if (parser.getAttributeValue(null, "actuate") != null) {
                                        attributes.addElement((SavotResource)((Object)"actuate"));
                                        attributes.addElement((SavotResource)((Object)parser.getAttributeValue(null, "actuate")));
                                    }
                                    if (parser.getAttributeValue(null, "encoding") != null) {
                                        attributes.addElement((SavotResource)((Object)"encoding"));
                                        attributes.addElement((SavotResource)((Object)parser.getAttributeValue(null, "encoding")));
                                    }
                                    if (parser.getAttributeValue(null, "expires") != null) {
                                        attributes.addElement((SavotResource)((Object)"expires"));
                                        attributes.addElement((SavotResource)((Object)parser.getAttributeValue(null, "expires")));
                                    }
                                    if (parser.getAttributeValue(null, "rights") != null) {
                                        attributes.addElement((SavotResource)((Object)"rights"));
                                        attributes.addElement((SavotResource)((Object)parser.getAttributeValue(null, "rights")));
                                    }
                                }
                                this.consumer.startStream(attributes);
                                if (!this.trace) break;
                                System.err.println("STREAM begin");
                                break;
                            }
                            if (currentMarkup.equalsIgnoreCase("TR")) {
                                this.consumer.startTR();
                                if (!this.trace) break;
                                System.err.println("TR begin");
                                break;
                            }
                            if (currentMarkup.equalsIgnoreCase("TD")) {
                                attributes = new Vector();
                                if (parser.getAttributeCount() != 0 && parser.getAttributeValue(null, "encoding") != null) {
                                    attributes.addElement((SavotResource)((Object)"encoding"));
                                    attributes.addElement((SavotResource)((Object)parser.getAttributeValue(null, "encoding")));
                                }
                                this.consumer.startTD(attributes);
                                if (!this.trace) break;
                                System.err.println("TD begin");
                                break;
                            }
                            if (currentMarkup.equalsIgnoreCase("DATA")) {
                                this.consumer.startData();
                                if (!this.trace) break;
                                System.err.println("DATA begin");
                                break;
                            }
                            if (currentMarkup.equalsIgnoreCase("BINARY")) {
                                this.consumer.startBinary();
                                if (!this.trace) break;
                                System.err.println("BINARY begin");
                                break;
                            }
                            if (currentMarkup.equalsIgnoreCase("FITS")) {
                                attributes = new Vector();
                                if (parser.getAttributeCount() != 0 && parser.getAttributeValue(null, "extnum") != null) {
                                    attributes.addElement((SavotResource)((Object)"extnum"));
                                    attributes.addElement((SavotResource)((Object)parser.getAttributeValue(null, "extnum")));
                                }
                                this.consumer.startFits(attributes);
                                if (!this.trace) break;
                                System.err.println("FITS begin");
                                break;
                            }
                            if (currentMarkup.equalsIgnoreCase("TABLEDATA")) {
                                this.consumer.startTableData();
                                if (!this.trace) break;
                                System.err.println("TABLEDATA begin");
                                break;
                            }
                            if (currentMarkup.equalsIgnoreCase("PARAM")) {
                                attributes = new Vector();
                                if (parser.getAttributeCount() != 0) {
                                    if (parser.getAttributeValue(null, "unit") != null) {
                                        attributes.addElement((SavotResource)((Object)"unit"));
                                        attributes.addElement((SavotResource)((Object)parser.getAttributeValue(null, "unit")));
                                    }
                                    if (parser.getAttributeValue(null, "datatype") != null) {
                                        attributes.addElement((SavotResource)((Object)"datatype"));
                                        attributes.addElement((SavotResource)((Object)parser.getAttributeValue(null, "datatype")));
                                    }
                                    if (parser.getAttributeValue(null, "precision") != null) {
                                        attributes.addElement((SavotResource)((Object)"precision"));
                                        attributes.addElement((SavotResource)((Object)parser.getAttributeValue(null, "precision")));
                                    }
                                    if (parser.getAttributeValue(null, "width") != null) {
                                        attributes.addElement((SavotResource)((Object)"width"));
                                        attributes.addElement((SavotResource)((Object)parser.getAttributeValue(null, "width")));
                                    }
                                    if (parser.getAttributeValue(null, "xtype") != null) {
                                        attributes.addElement((SavotResource)((Object)"xtype"));
                                        attributes.addElement((SavotResource)((Object)parser.getAttributeValue(null, "xtype")));
                                    }
                                    if (parser.getAttributeValue(null, "ref") != null) {
                                        attributes.addElement((SavotResource)((Object)"ref"));
                                        attributes.addElement((SavotResource)((Object)parser.getAttributeValue(null, "ref")));
                                    }
                                    if (parser.getAttributeValue(null, "name") != null) {
                                        attributes.addElement((SavotResource)((Object)"name"));
                                        attributes.addElement((SavotResource)((Object)parser.getAttributeValue(null, "name")));
                                    }
                                    if (parser.getAttributeValue(null, "ucd") != null) {
                                        attributes.addElement((SavotResource)((Object)"ucd"));
                                        attributes.addElement((SavotResource)((Object)parser.getAttributeValue(null, "ucd")));
                                    }
                                    if (parser.getAttributeValue(null, "utype") != null) {
                                        attributes.addElement((SavotResource)((Object)"utype"));
                                        attributes.addElement((SavotResource)((Object)parser.getAttributeValue(null, "utype")));
                                    }
                                    if (parser.getAttributeValue(null, "value") != null) {
                                        attributes.addElement((SavotResource)((Object)"value"));
                                        attributes.addElement((SavotResource)((Object)parser.getAttributeValue(null, "value")));
                                    }
                                    if (parser.getAttributeValue(null, "arraysize") != null) {
                                        attributes.addElement((SavotResource)((Object)"arraysize"));
                                        attributes.addElement((SavotResource)((Object)parser.getAttributeValue(null, "arraysize")));
                                    }
                                    if (parser.getAttributeValue(null, "id") != null) {
                                        attributes.addElement((SavotResource)((Object)"id"));
                                        attributes.addElement((SavotResource)((Object)parser.getAttributeValue(null, "id")));
                                    }
                                }
                                this.consumer.startParam(attributes);
                                if (!this.trace) break;
                                System.err.println("PARAM begin");
                                break;
                            }
                            if (currentMarkup.equalsIgnoreCase("PARAMref")) {
                                attributes = new Vector();
                                if (parser.getAttributeCount() != 0 && parser.getAttributeValue(null, "ref") != null) {
                                    attributes.addElement((SavotResource)((Object)"ref"));
                                    attributes.addElement((SavotResource)((Object)parser.getAttributeValue(null, "ref")));
                                }
                                this.consumer.startParamRef(attributes);
                                if (!this.trace) break;
                                System.err.println("PARAMref begin");
                                break;
                            }
                            if (currentMarkup.equalsIgnoreCase("LINK")) {
                                attributes = new Vector();
                                if (parser.getAttributeCount() != 0) {
                                    if (parser.getAttributeValue(null, "content-role") != null) {
                                        attributes.addElement((SavotResource)((Object)"content-role"));
                                        attributes.addElement((SavotResource)((Object)parser.getAttributeValue(null, "content-role")));
                                    }
                                    if (parser.getAttributeValue(null, "content-type") != null) {
                                        attributes.addElement((SavotResource)((Object)"content-type"));
                                        attributes.addElement((SavotResource)((Object)parser.getAttributeValue(null, "content-type")));
                                    }
                                    if (parser.getAttributeValue(null, "title") != null) {
                                        attributes.addElement((SavotResource)((Object)"title"));
                                        attributes.addElement((SavotResource)((Object)parser.getAttributeValue(null, "title")));
                                    }
                                    if (parser.getAttributeValue(null, "value") != null) {
                                        attributes.addElement((SavotResource)((Object)"value"));
                                        attributes.addElement((SavotResource)((Object)parser.getAttributeValue(null, "value")));
                                    }
                                    if (parser.getAttributeValue(null, "href") != null) {
                                        attributes.addElement((SavotResource)((Object)"href"));
                                        attributes.addElement((SavotResource)((Object)parser.getAttributeValue(null, "href")));
                                    }
                                    if (parser.getAttributeValue(null, "gref") != null) {
                                        attributes.addElement((SavotResource)((Object)"gref"));
                                        attributes.addElement((SavotResource)((Object)parser.getAttributeValue(null, "gref")));
                                    }
                                    if (parser.getAttributeValue(null, "action") != null) {
                                        attributes.addElement((SavotResource)((Object)"action"));
                                        attributes.addElement((SavotResource)((Object)parser.getAttributeValue(null, "action")));
                                    }
                                    if (parser.getAttributeValue(null, "id") != null) {
                                        attributes.addElement((SavotResource)((Object)"id"));
                                        attributes.addElement((SavotResource)((Object)parser.getAttributeValue(null, "id")));
                                    }
                                }
                                this.consumer.startLink(attributes);
                                if (!this.trace) break;
                                System.err.println("LINK begin");
                                break;
                            }
                            if (currentMarkup.equalsIgnoreCase("INFO")) {
                                attributes = new Vector();
                                if (parser.getAttributeCount() != 0) {
                                    if (parser.getAttributeValue(null, "name") != null) {
                                        attributes.addElement((SavotResource)((Object)"name"));
                                        attributes.addElement((SavotResource)((Object)parser.getAttributeValue(null, "name")));
                                    }
                                    if (parser.getAttributeValue(null, "value") != null) {
                                        attributes.addElement((SavotResource)((Object)"value"));
                                        attributes.addElement((SavotResource)((Object)parser.getAttributeValue(null, "value")));
                                    }
                                    if (parser.getAttributeValue(null, "id") != null) {
                                        attributes.addElement((SavotResource)((Object)"id"));
                                        attributes.addElement((SavotResource)((Object)parser.getAttributeValue(null, "id")));
                                    }
                                    if (parser.getAttributeValue(null, "xtype") != null) {
                                        attributes.addElement((SavotResource)((Object)"xtype"));
                                        attributes.addElement((SavotResource)((Object)parser.getAttributeValue(null, "xtype")));
                                    }
                                    if (parser.getAttributeValue(null, "ref") != null) {
                                        attributes.addElement((SavotResource)((Object)"ref"));
                                        attributes.addElement((SavotResource)((Object)parser.getAttributeValue(null, "ref")));
                                    }
                                    if (parser.getAttributeValue(null, "unit") != null) {
                                        attributes.addElement((SavotResource)((Object)"unit"));
                                        attributes.addElement((SavotResource)((Object)parser.getAttributeValue(null, "unit")));
                                    }
                                    if (parser.getAttributeValue(null, "ucd") != null) {
                                        attributes.addElement((SavotResource)((Object)"ucd"));
                                        attributes.addElement((SavotResource)((Object)parser.getAttributeValue(null, "ucd")));
                                    }
                                    if (parser.getAttributeValue(null, "utype") != null) {
                                        attributes.addElement((SavotResource)((Object)"utype"));
                                        attributes.addElement((SavotResource)((Object)parser.getAttributeValue(null, "utype")));
                                    }
                                }
                                this.consumer.startInfo(attributes);
                                if (!this.trace) break;
                                System.err.println("INFO begin");
                                break;
                            }
                            if (currentMarkup.equalsIgnoreCase("min")) {
                                attributes = new Vector();
                                if (parser.getAttributeCount() != 0) {
                                    if (parser.getAttributeValue(null, "value") != null) {
                                        attributes.addElement((SavotResource)((Object)"value"));
                                        attributes.addElement((SavotResource)((Object)parser.getAttributeValue(null, "value")));
                                    }
                                    if (parser.getAttributeValue(null, "inclusive") != null) {
                                        attributes.addElement((SavotResource)((Object)"inclusive"));
                                        attributes.addElement((SavotResource)((Object)parser.getAttributeValue(null, "inclusive")));
                                    }
                                }
                                this.consumer.startMin(attributes);
                                if (!this.trace) break;
                                System.err.println("MIN begin");
                                break;
                            }
                            if (currentMarkup.equalsIgnoreCase("max")) {
                                attributes = new Vector();
                                if (parser.getAttributeCount() != 0) {
                                    if (parser.getAttributeValue(null, "value") != null) {
                                        attributes.addElement((SavotResource)((Object)"value"));
                                        attributes.addElement((SavotResource)((Object)parser.getAttributeValue(null, "value")));
                                    }
                                    if (parser.getAttributeValue(null, "inclusive") != null) {
                                        attributes.addElement((SavotResource)((Object)"inclusive"));
                                        attributes.addElement((SavotResource)((Object)parser.getAttributeValue(null, "inclusive")));
                                    }
                                }
                                this.consumer.startMax(attributes);
                                if (!this.trace) break;
                                System.err.println("MAX begin ");
                                break;
                            }
                            if (currentMarkup.equalsIgnoreCase("OPTION")) {
                                attributes = new Vector();
                                if (parser.getAttributeCount() != 0) {
                                    if (parser.getAttributeValue(null, "name") != null) {
                                        attributes.addElement((SavotResource)((Object)"name"));
                                        attributes.addElement((SavotResource)((Object)parser.getAttributeValue(null, "name")));
                                    }
                                    if (parser.getAttributeValue(null, "value") != null) {
                                        attributes.addElement((SavotResource)((Object)"value"));
                                        attributes.addElement((SavotResource)((Object)parser.getAttributeValue(null, "value")));
                                    }
                                }
                                this.consumer.startOption(attributes);
                                if (!this.trace) break;
                                System.err.println("OPTION begin - not included");
                                break;
                            }
                            if (currentMarkup.equalsIgnoreCase("GROUP")) {
                                attributes = new Vector();
                                if (parser.getAttributeCount() != 0) {
                                    if (parser.getAttributeValue(null, "ref") != null) {
                                        attributes.addElement((SavotResource)((Object)"ref"));
                                        attributes.addElement((SavotResource)((Object)parser.getAttributeValue(null, "ref")));
                                    }
                                    if (parser.getAttributeValue(null, "name") != null) {
                                        attributes.addElement((SavotResource)((Object)"name"));
                                        attributes.addElement((SavotResource)((Object)parser.getAttributeValue(null, "name")));
                                    }
                                    if (parser.getAttributeValue(null, "ucd") != null) {
                                        attributes.addElement((SavotResource)((Object)"ucd"));
                                        attributes.addElement((SavotResource)((Object)parser.getAttributeValue(null, "ucd")));
                                    }
                                    if (parser.getAttributeValue(null, "utype") != null) {
                                        attributes.addElement((SavotResource)((Object)"utype"));
                                        attributes.addElement((SavotResource)((Object)parser.getAttributeValue(null, "utype")));
                                    }
                                    if (parser.getAttributeValue(null, "id") != null) {
                                        attributes.addElement((SavotResource)((Object)"id"));
                                        attributes.addElement((SavotResource)((Object)parser.getAttributeValue(null, "id")));
                                    }
                                }
                                this.consumer.startGroup(attributes);
                                if (!this.trace) break;
                                System.err.println("GROUP begin - not included");
                                break;
                            }
                            if (currentMarkup.equalsIgnoreCase("COOSYS")) {
                                attributes = new Vector();
                                if (parser.getAttributeCount() != 0) {
                                    if (parser.getAttributeValue(null, "equinox") != null) {
                                        attributes.addElement((SavotResource)((Object)"equinox"));
                                        attributes.addElement((SavotResource)((Object)parser.getAttributeValue(null, "equinox")));
                                    }
                                    if (parser.getAttributeValue(null, "epoch") != null) {
                                        attributes.addElement((SavotResource)((Object)"epoch"));
                                        attributes.addElement((SavotResource)((Object)parser.getAttributeValue(null, "epoch")));
                                    }
                                    if (parser.getAttributeValue(null, "SYSTEM") != null) {
                                        attributes.addElement((SavotResource)((Object)"SYSTEM"));
                                        attributes.addElement((SavotResource)((Object)parser.getAttributeValue(null, "SYSTEM")));
                                    }
                                    if (parser.getAttributeValue(null, "id") != null) {
                                        attributes.addElement((SavotResource)((Object)"id"));
                                        attributes.addElement((SavotResource)((Object)parser.getAttributeValue(null, "id")));
                                    }
                                }
                                this.consumer.startCoosys(attributes);
                                if (!this.trace) break;
                                System.err.println("COOSYS begin");
                                break;
                            }
                            if (currentMarkup.equalsIgnoreCase("DEFINITIONS")) {
                                this.consumer.startDefinitions();
                                if (!this.trace) break;
                                System.err.println("DEFINITIONS begin");
                                break;
                            }
                            System.err.println("VOTable markup error : " + currentMarkup + " at line " + parser.getLineNumber());
                        }
                        catch (Exception e) {
                            System.err.println("Exception START_TAG : " + e + " at line " + parser.getLineNumber());
                        }
                        break;
                    }
                    case 3: {
                        try {
                            if (this.trace) {
                                System.err.println("End ---> " + currentMarkup);
                            }
                            if (currentMarkup.equalsIgnoreCase("DESCRIPTION")) {
                                this.consumer.endDescription();
                                if (this.trace) {
                                    System.err.println("DESCRIPTION");
                                }
                            } else if (currentMarkup.equalsIgnoreCase("TABLE")) {
                                this.consumer.endTable();
                                if (this.trace) {
                                    System.err.println("TABLE");
                                }
                            } else if (currentMarkup.equalsIgnoreCase("FIELD")) {
                                this.consumer.endField();
                                if (this.trace) {
                                    System.err.println("FIELD");
                                }
                            } else if (currentMarkup.equalsIgnoreCase("FIELDref")) {
                                this.consumer.endFieldref();
                                if (this.trace) {
                                    System.err.println("FIELDRef");
                                }
                            } else if (currentMarkup.equalsIgnoreCase("TR")) {
                                this.consumer.endTR();
                                if (this.trace) {
                                    System.err.println("TR");
                                }
                            } else if (currentMarkup.equalsIgnoreCase("DATA")) {
                                this.consumer.endData();
                                if (this.trace) {
                                    System.err.println("DATA");
                                }
                            } else if (currentMarkup.equalsIgnoreCase("TD")) {
                                this.consumer.endTD();
                                if (this.trace) {
                                    System.err.println("TD");
                                }
                            } else if (currentMarkup.equalsIgnoreCase("RESOURCE")) {
                                this.consumer.endResource();
                                if (this.trace) {
                                    System.err.println("RESOURCE");
                                }
                            } else if (currentMarkup.equalsIgnoreCase("OPTION")) {
                                this.consumer.endOption();
                                if (this.trace) {
                                    System.err.println("OPTION");
                                }
                            } else if (currentMarkup.equalsIgnoreCase("GROUP")) {
                                this.consumer.endGroup();
                                if (this.trace) {
                                    System.err.println("GROUP");
                                }
                            } else if (currentMarkup.equalsIgnoreCase("TABLEDATA")) {
                                this.consumer.endTableData();
                                if (this.trace) {
                                    System.err.println("TABLEDATA");
                                }
                            } else if (currentMarkup.equalsIgnoreCase("COOSYS")) {
                                this.consumer.endCoosys();
                                if (this.trace) {
                                    System.err.println("COOSYS");
                                }
                            } else if (currentMarkup.equalsIgnoreCase("PARAM")) {
                                this.consumer.endParam();
                                if (this.trace) {
                                    System.err.println("PARAM");
                                }
                            } else if (currentMarkup.equalsIgnoreCase("PARAMref")) {
                                this.consumer.endParamRef();
                                if (this.trace) {
                                    System.err.println("PARAMRef");
                                }
                            } else if (currentMarkup.equalsIgnoreCase("LINK")) {
                                this.consumer.endLink();
                                if (this.trace) {
                                    System.err.println("LINK");
                                }
                            } else if (currentMarkup.equalsIgnoreCase("VALUES")) {
                                this.consumer.endValues();
                                if (this.trace) {
                                    System.err.println("VALUES");
                                }
                            } else if (currentMarkup.equalsIgnoreCase("min")) {
                                this.consumer.endMin();
                                if (this.trace) {
                                    System.err.println("MIN");
                                }
                            } else if (currentMarkup.equalsIgnoreCase("max")) {
                                this.consumer.endMax();
                                if (this.trace) {
                                    System.err.println("MAX");
                                }
                            } else if (currentMarkup.equalsIgnoreCase("STREAM")) {
                                this.consumer.endStream();
                                if (this.trace) {
                                    System.err.println("STREAM");
                                }
                            } else if (currentMarkup.equalsIgnoreCase("BINARY")) {
                                this.consumer.endBinary();
                                if (this.trace) {
                                    System.err.println("BINARY");
                                }
                            } else if (currentMarkup.equalsIgnoreCase("FITS")) {
                                this.consumer.endFits();
                                if (this.trace) {
                                    System.err.println("FITS");
                                }
                            } else if (currentMarkup.equalsIgnoreCase("INFO")) {
                                this.consumer.endInfo();
                                if (this.trace) {
                                    System.err.println("INFO");
                                }
                            } else if (currentMarkup.equalsIgnoreCase("DEFINITIONS")) {
                                this.consumer.endDefinitions();
                                if (this.trace) {
                                    System.err.println("DEFINITIONS");
                                }
                            } else if (currentMarkup.equalsIgnoreCase("VOTABLE")) {
                                this.consumer.endVotable();
                                if (this.trace) {
                                    System.err.println("VOTABLE");
                                }
                            } else {
                                System.err.println("VOTable markup error : " + currentMarkup + " at line " + parser.getLineNumber());
                            }
                            this.father.removeElementAt(this.father.size() - 1);
                            currentMarkup = this.father.elementAt(this.father.size() - 1);
                        }
                        catch (Exception e) {
                            System.err.println("Exception END_TAG : " + e + " at line " + parser.getLineNumber());
                        }
                        break;
                    }
                    case 1: {
                        try {
                            this.consumer.endDocument();
                            if (!this.trace) break;
                            System.err.println("Document end reached!");
                        }
                        catch (Exception e) {
                            System.err.println("Exception END_DOCUMENT : " + e + " at line " + parser.getLineNumber());
                        }
                        break;
                    }
                    case 4: {
                        try {
                            if (currentMarkup.equalsIgnoreCase("TD")) {
                                this.consumer.textTD(parser.getText().trim());
                                if (!this.trace) break;
                                System.err.println("TD : " + parser.getText().trim());
                                break;
                            }
                            if (currentMarkup.equalsIgnoreCase("STREAM")) {
                                this.consumer.textStream(parser.getText().trim());
                                if (!this.trace) break;
                                System.err.println("STREAM : " + parser.getText().trim());
                                break;
                            }
                            if (currentMarkup.equalsIgnoreCase("DESCRIPTION")) {
                                this.consumer.textDescription(parser.getText().trim());
                                if (!this.trace) break;
                                System.err.println("DESCRIPTION : " + parser.getText().trim());
                                break;
                            }
                            if (currentMarkup.equalsIgnoreCase("min")) {
                                this.consumer.textMin(parser.getText().trim());
                                if (!this.trace) break;
                                System.err.println("MIN : " + parser.getText().trim());
                                break;
                            }
                            if (currentMarkup.equalsIgnoreCase("max")) {
                                this.consumer.textMax(parser.getText().trim());
                                if (!this.trace) break;
                                System.err.println("MAX : " + parser.getText().trim());
                                break;
                            }
                            if (currentMarkup.equalsIgnoreCase("COOSYS")) {
                                this.consumer.textCoosys(parser.getText().trim());
                                if (!this.trace) break;
                                System.err.println("COOSYS : " + parser.getText().trim());
                                break;
                            }
                            if (currentMarkup.equalsIgnoreCase("LINK")) {
                                this.consumer.textLink(parser.getText().trim());
                                if (!this.trace) break;
                                System.err.println("LINK : " + parser.getText().trim());
                                break;
                            }
                            if (currentMarkup.equalsIgnoreCase("OPTION")) {
                                this.consumer.textOption(parser.getText().trim());
                                if (!this.trace) break;
                                System.err.println("OPTION : " + parser.getText().trim());
                                break;
                            }
                            if (currentMarkup.equalsIgnoreCase("GROUP")) {
                                this.consumer.textGroup(parser.getText().trim());
                                if (!this.trace) break;
                                System.err.println("GROUP : " + parser.getText().trim());
                                break;
                            }
                            if (!currentMarkup.equalsIgnoreCase("INFO")) break;
                            this.consumer.textInfo(parser.getText().trim());
                            if (!this.trace) break;
                            System.err.println("INFO : " + parser.getText().trim());
                        }
                        catch (Exception e) {
                            System.err.println("Exception TEXT : " + e + " at line " + parser.getLineNumber());
                        }
                        break;
                    }
                    case 0: {
                        try {
                            this.consumer.startDocument();
                            if (!this.trace) break;
                            System.err.println("Document start reached!");
                        }
                        catch (Exception e) {
                            System.err.println("Exception START_DOCUMENT : " + e + " at line " + parser.getLineNumber());
                        }
                        break;
                    }
                    default: {
                        if (!this.trace) break;
                        System.err.println(" ignoring some other (legacy) event at line : " + parser.getLineNumber());
                    }
                }
                eventType = parser.next();
            }
        }
        catch (Exception f) {
            System.err.println("Exception parse : " + f + " at line " + parser.getLineNumber());
        }
        try {
            this.consumer.endDocument();
            if (this.trace) {
                System.err.println("Document end reached!");
            }
        }
        catch (Exception e) {
            System.err.println("Exception END_DOCUMENT : " + e + " at line " + parser.getLineNumber());
        }
    }

    public void enableDebug(boolean debug) {
        this.trace = debug;
    }

    private void jbInit() throws Exception {
    }
}

