/*
 * Decompiled with CFR 0.152.
 */
package cds.fits;

import cds.aladin.Aladin;
import cds.aladin.FrameHeaderFits;
import cds.aladin.MyInputStream;
import cds.aladin.Save;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public final class HeaderFits {
    private StringBuffer memoHeaderFits = null;
    protected Hashtable header;
    protected Vector<String> keysOrder;
    private int sizeHeader = 0;

    public HeaderFits() {
        this.alloc();
    }

    public HeaderFits(MyInputStream dis) throws Exception {
        this.readHeader(dis);
    }

    public HeaderFits(String s) throws Exception {
        this.readFreeHeader(s);
    }

    public HeaderFits(String s, FrameHeaderFits frameHeaderFits) throws Exception {
        this.readFreeHeader(s, false, frameHeaderFits);
    }

    public HeaderFits(MyInputStream dis, FrameHeaderFits frameHeaderFits) throws Exception {
        this.readHeader(dis, frameHeaderFits);
    }

    public String getOriginalHeaderFits() {
        return this.memoHeaderFits.toString();
    }

    public void setOriginalHeaderFits(String s) {
        this.memoHeaderFits = new StringBuffer(s);
    }

    public void appendMHF(String s) {
        if (this.memoHeaderFits == null) {
            this.memoHeaderFits = new StringBuffer();
        }
        this.memoHeaderFits.append(s.trim() + "\n");
    }

    public int getSizeHeader() {
        return this.sizeHeader;
    }

    public Hashtable getHashHeader() {
        return this.header;
    }

    public static String getValue(String s) {
        int i;
        byte[] a = new byte[80];
        for (i = 0; i < s.length(); ++i) {
            a[i] = (byte)s.charAt(i);
        }
        while (i < 80) {
            a[i++] = 32;
        }
        return HeaderFits.getValue(a);
    }

    public static String getValue(byte[] buffer) {
        int offset;
        int i;
        boolean quote = false;
        boolean blanc = true;
        for (i = offset = 9; i < 80 && !(quote ? buffer[i] == 39 : buffer[i] == 47); ++i) {
            if (!blanc) continue;
            if (buffer[i] != 32) {
                blanc = false;
            }
            if (buffer[i] != 39) continue;
            quote = true;
            offset = i + 1;
        }
        return new String(buffer, 0, offset, i - offset).trim();
    }

    public static String getKey(byte[] buffer) {
        return new String(buffer, 0, 0, 8).trim();
    }

    public static String getKey(String s) {
        if (s.length() < 8) {
            return s;
        }
        return s.substring(0, 8).trim();
    }

    public boolean readHeaderPDS(MyInputStream dis, FrameHeaderFits frameHeaderFits) throws Exception {
        int linesRead = 0;
        this.alloc();
        try {
            while (true) {
                int i;
                String s = dis.readLine();
                ++linesRead;
                if (s.length() == 0) continue;
                if (s.trim().equals("END")) {
                    return true;
                }
                if (frameHeaderFits != null) {
                    frameHeaderFits.appendMHF(s);
                }
                if ((i = s.indexOf(61)) < 0) continue;
                String key = s.substring(0, i - 1).trim();
                String value = s.substring(i + 1).trim();
                this.header.put(key, value);
                this.keysOrder.addElement(key);
            }
        }
        catch (Exception e) {
            Aladin.error = "PDS header error (line " + (linesRead + 1) + ")";
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            throw new Exception();
        }
    }

    public boolean readHeader(MyInputStream dis) throws Exception {
        return this.readHeader(dis, null);
    }

    public boolean readHeader(MyInputStream dis, FrameHeaderFits frameHeaderFits) throws Exception {
        int blocksize = 2880;
        int fieldsize = 80;
        int linesRead = 0;
        this.sizeHeader = 0;
        boolean firstLine = true;
        byte[] buffer = new byte[fieldsize];
        this.alloc();
        try {
            while (true) {
                dis.readFully(buffer);
                String key = HeaderFits.getKey(buffer);
                if (linesRead == 0 && !key.equals("SIMPLE") && !key.equals("XTENSION")) {
                    throw new Exception("probably not a FITS file");
                }
                this.sizeHeader += fieldsize;
                ++linesRead;
                if (key.equals("END")) break;
                this.appendMHF(new String(buffer, 0));
                if (buffer[8] != 61) continue;
                String value = HeaderFits.getValue(buffer);
                this.header.put(key, value);
                this.keysOrder.addElement(key);
            }
            if (dis.isHCOMP()) {
                return true;
            }
            int bourrage = blocksize - this.sizeHeader % blocksize;
            if (bourrage != blocksize) {
                byte[] tmp = new byte[bourrage];
                dis.readFully(tmp);
                this.sizeHeader += bourrage;
            }
        }
        catch (Exception e) {
            Aladin.error = linesRead == 0 ? "Remote server message:\n" + new String(buffer, 0) : "Fits header error (line " + (linesRead + 1) + ")";
            throw e;
        }
        return true;
    }

    private int getPos(char[] buf, int from, int finLigne, char c) {
        int max = buf.length;
        boolean inQuote = from + 2 < buf.length && buf[from + 2] == '\'' && c == '/';
        int deb = from;
        while (from < max && from < finLigne && (buf[from] != c || buf[from] == c && inQuote) && buf[from] != '\n') {
            if (from > deb + 2 && buf[from] == '\'' && buf[from - 1] != '\'') {
                inQuote = false;
            }
            ++from;
        }
        return from;
    }

    public boolean readFreeHeader(String s) {
        return this.readFreeHeader(s, false, null);
    }

    public boolean readFreeHeader(String s, boolean specialDSS, FrameHeaderFits frameHeaderFits) {
        this.alloc();
        int len = 79;
        char[] buf = s.toCharArray();
        int i = 0;
        while (i < buf.length) {
            String com;
            int a;
            int c = this.getPos(buf, i, i + len, '\n');
            if (new String(buf, i, c - i).trim().length() == 0) {
                this.appendMHF("");
            } else if (buf.length > i + 7 && new String(buf, i, 7).equals("COMMENT")) {
                a = i + 7;
                c = this.getPos(buf, a, i + len, '\n');
                com = c - a > 0 ? new String(buf, a + 1, c - a - 1).trim() : "";
                this.appendMHF(new String(Save.getFitsLineComment(com)).trim());
            } else if (buf.length > i + 7 && new String(buf, i, 7).equals("HISTORY")) {
                a = i + 7;
                c = this.getPos(buf, a, i + len, '\n');
                com = c - a > 0 ? new String(buf, a + 1, c - a - 1).trim() : "";
                this.appendMHF(new String(Save.getFitsLineHistory(com)).trim());
            } else {
                a = this.getPos(buf, i, i + len, '=');
                int b = this.getPos(buf, a, i + len, '/');
                c = this.getPos(buf, b, i + len, '\n');
                if (i != a || i != b || i != c) {
                    String key = new String(buf, i, a - i).trim();
                    String value = b - a > 0 ? new String(buf, a + 1, b - a - 1).trim() : "";
                    String string = com = c - b > 0 ? new String(buf, b + 1, c - b - 1).trim() : "";
                    if (key.equals("END")) {
                        com = null;
                        value = null;
                        break;
                    }
                    this.header.put(key, value);
                    this.keysOrder.addElement(key);
                    this.appendMHF(new String(Save.getFitsLine(key, value, com)).trim());
                }
            }
            i = c + 1;
        }
        return true;
    }

    public boolean hasKey(String key) {
        return this.header.get(key.trim()) != null;
    }

    public int getIntFromHeader(String key) throws NumberFormatException, NullPointerException {
        String s = (String)this.header.get(key.trim());
        int result = (int)Double.parseDouble(s.trim());
        return result;
    }

    private String trimDouble(String s) {
        int j;
        char ch;
        int i;
        char[] a = s.toCharArray();
        for (i = 0; i < a.length && (ch = a[i]) != '+' && ch != '-' && ch != '.' && (ch < '0' || ch > '9'); ++i) {
        }
        for (j = a.length - 1; j >= i; --j) {
            ch = a[j];
            if ((ch < '0' || ch > '9') && ch != '.') continue;
            ++j;
            break;
        }
        return new String(a, i, j - i);
    }

    public void setKeyword(String key, String value) {
        this.header.put(key, value);
    }

    public double getDoubleFromHeader(String key) throws NumberFormatException, NullPointerException {
        String s = (String)this.header.get(key.trim());
        double result = Double.valueOf(this.trimDouble(s));
        return result;
    }

    public String getStringFromHeader(String key) throws NullPointerException {
        String s = (String)this.header.get(key.trim());
        if (s == null || s.length() == 0) {
            return s;
        }
        if (s.charAt(0) == '\'') {
            return s.substring(1, s.length() - 1).trim();
        }
        return s;
    }

    public void setToHeader(String key, String value) {
        if (value == null) {
            this.header.remove(key);
        } else {
            this.header.put(key.trim(), value);
        }
    }

    public void setKeyValue(String key, String value) {
        if (value == null) {
            if (!this.hasKey(key)) {
                return;
            }
            this.header.remove(key);
            this.keysOrder.remove(key);
            return;
        }
        if (!this.hasKey(key)) {
            this.keysOrder.addElement(key);
        }
        this.header.put(key, value);
    }

    public int writeHeader(OutputStream os) throws Exception {
        int n = this.keysOrder.size() * 80;
        byte[] b = HeaderFits.getEndBourrage(n);
        byte[] buf = new byte[n + b.length];
        int m = 0;
        Enumeration<String> e = this.keysOrder.elements();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            String value = (String)this.header.get(key);
            if (value == null) continue;
            System.arraycopy(HeaderFits.getFitsLine(key, value), 0, buf, m, 80);
            m += 80;
        }
        System.arraycopy(b, 0, buf, m, b.length);
        os.write(buf);
        return n += b.length;
    }

    public static byte[] getEndBourrage(int headSize) {
        int size = 2880 - headSize % 2880;
        if (size < 3) {
            size += 2880;
        }
        byte[] b = new byte[size];
        b[0] = 69;
        b[1] = 78;
        b[2] = 68;
        for (int i = 3; i < b.length; ++i) {
            b[i] = 32;
        }
        return b;
    }

    public static byte[] getFitsLine(String key, String value) {
        return HeaderFits.getFitsLine(key, value, null);
    }

    public static byte[] getFitsLine(String key, String value, String comment) {
        int i;
        byte[] b = new byte[80];
        char[] a = key.toCharArray();
        int j = 0;
        for (i = 0; i < 8; ++i) {
            b[i] = (byte)(j < a.length ? a[j] : 32);
            ++j;
        }
        if (value != null) {
            b[i++] = 61;
            b[i++] = 32;
            a = value.toCharArray();
            if (!HeaderFits.isFitsString(value)) {
                for (j = 0; j < 20 - a.length; ++j) {
                    b[i++] = 32;
                }
                for (j = 0; i < 80 && j < a.length; ++j, ++i) {
                    b[i] = (byte)a[j];
                }
            } else {
                a = HeaderFits.formatFitsString(a);
                for (j = 0; i < 80 && j < a.length; ++j, ++i) {
                    b[i] = (byte)a[j];
                }
                while (i < 30) {
                    b[i++] = 32;
                }
            }
        }
        if (comment != null && comment.length() > 0) {
            if (value != null) {
                b[i++] = 32;
                b[i++] = 47;
                b[i++] = 32;
            }
            a = comment.toCharArray();
            for (j = 0; i < 80 && j < a.length; ++j, ++i) {
                b[i] = (byte)a[j];
            }
        }
        while (i < 80) {
            b[i++] = 32;
        }
        return b;
    }

    private static boolean isFitsString(String s) {
        if (s.length() == 0) {
            return true;
        }
        char c = s.charAt(0);
        if (s.length() == 1 && (c == 'T' || c == 'F')) {
            return false;
        }
        if (!Character.isDigit(c) && c != '.' && c != '-' && c != '+') {
            return true;
        }
        try {
            Double.valueOf(s);
            return false;
        }
        catch (Exception e) {
            return true;
        }
    }

    private static char[] formatFitsString(char[] a) {
        int i;
        if (a.length == 0) {
            return a;
        }
        StringBuffer s = new StringBuffer();
        boolean flagQuote = a[0] == '\'';
        s.append('\'');
        for (i = flagQuote ? 1 : 0; i < a.length - (flagQuote ? 1 : 0); ++i) {
            if (!flagQuote && a[i] == '\'') {
                s.append('\'');
            }
            s.append(a[i]);
        }
        while (i < (flagQuote ? 9 : 8)) {
            s.append(' ');
            ++i;
        }
        s.append('\'');
        return s.toString().toCharArray();
    }

    protected void alloc() {
        this.header = new Hashtable(200);
        this.keysOrder = new Vector(200);
    }

    public long getMem() {
        return 16 + (this.keysOrder == null ? 0 : this.keysOrder.size() * 50);
    }
}

