/*
 * Decompiled with CFR 0.152.
 */
package cds.fits;

import cds.aladin.Aladin;
import cds.aladin.Calib;
import cds.aladin.Coord;
import cds.aladin.MyInputStream;
import cds.fits.HeaderFits;
import cds.image.Hdecomp;
import cds.tools.Util;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.ImageConsumer;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.GZIPOutputStream;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;

public final class Fits {
    public static final int PREVIEW_UNKOWN = 0;
    public static final int PREVIEW_JPEG = 1;
    public static final int PREVIEW_PNG = 2;
    public static final int PIX_ARGB = 0;
    public static final int PIX_RGB = 1;
    public static final int PIX_TRUE = 2;
    public static final int PIX_256 = 3;
    public static final int PIX_255 = 4;
    protected int pixMode;
    public static final double DEFAULT_BLANK = Double.NaN;
    public static final double DEFAULT_BSCALE = 1.0;
    public static final double DEFAULT_BZERO = 0.0;
    public HeaderFits headerFits;
    public HeaderFits headerFits0;
    public byte[] pixels;
    public int bitpix;
    public int width;
    public int height;
    public int depth = 1;
    public double bzero = 0.0;
    public double bscale = 1.0;
    public double blank = Double.NaN;
    public long bitmapOffset = -1L;
    public int xCell;
    public int yCell;
    public int zCell;
    public int widthCell;
    public int heightCell;
    public int depthCell;
    public int ext;
    public int[] rgb;
    public Calib calib;
    public static String FS = System.getProperty("file.separator");
    private boolean skipHDU0 = true;
    public static final int GZIP = 1;
    public static final int HHH = 2;
    public static final int COLOR = 4;
    public static final int XFITS = 8;
    public static final int HDU0SKIP = 16;
    private Vector extHeader = null;
    private Vector extPixels = null;
    public static final boolean JPEGORDERCALIB = false;
    public static final boolean JPEGFROMTOP = false;
    public static final boolean RGBASFITS = true;
    private RandomAccessFile fDirectAccess = null;
    private int users = 0;
    private boolean bitmapReleaseDone = false;
    private boolean releasable = true;
    private static int FINDMINMAXSIZE = 1500;
    private static int FINDMINMAXDEPTH = 100;
    private Coord cTmp = new Coord();
    public String filename;

    public long getMem() {
        long mem = 80L;
        if (this.calib != null) {
            mem += this.calib.getMem();
        }
        if (this.headerFits != null) {
            mem += this.headerFits.getMem();
        }
        if (this.headerFits0 != null) {
            mem += this.headerFits0.getMem();
        }
        if (this.pixels != null) {
            mem += (long)this.pixels.length;
        }
        if (this.rgb != null) {
            mem += (long)(4 * this.rgb.length);
        }
        return mem;
    }

    public Fits() {
    }

    public Fits(int width, int height, int bitpix) {
        this(width, height, 1, bitpix);
    }

    public Fits(int width, int height, int depth, int bitpix) {
        this.width = this.widthCell = width;
        this.height = this.heightCell = height;
        this.depth = this.depthCell = depth;
        this.bitpix = bitpix;
        this.zCell = 0;
        this.yCell = 0;
        this.xCell = 0;
        this.ext = 0;
        if (bitpix == 0) {
            this.pixMode = 0;
            this.rgb = new int[width * height * depth];
        } else {
            this.pixMode = 2;
            this.pixels = new byte[width * height * depth * Math.abs(bitpix) / 8];
            this.headerFits = new HeaderFits();
            this.headerFits.setKeyValue("SIMPLE", "T");
            this.headerFits.setKeyValue("BITPIX", bitpix + "");
            this.headerFits.setKeyValue("NAXIS", depth > 1 ? "3" : "2");
            this.headerFits.setKeyValue("NAXIS1", width + "");
            this.headerFits.setKeyValue("NAXIS2", height + "");
            if (depth > 1) {
                this.headerFits.setKeyValue("NAXIS3", depth + "");
            }
        }
    }

    public void setCalib(Calib c) {
        this.calib = c;
    }

    public Calib getCalib() {
        return this.calib;
    }

    public void loadPreview(MyInputStream dis) throws Exception {
        this.loadPreview(dis, false);
    }

    public void loadPreview(String filename, int x, int y, int w, int h) throws Exception {
        this.loadPreview(filename + "[" + x + "," + y + "-" + w + "x" + h + "]");
    }

    public void loadPreview(String filename) throws Exception {
        this.loadPreview(filename, false, true, 0);
    }

    private void bidouilleJPEGPNG(HeaderFits headerFits, String filename) {
        try {
            headerFits.getIntFromHeader("NAXIS1");
        }
        catch (Exception e) {
            try {
                Fits fits = new Fits();
                MyInputStream is1 = new MyInputStream(new FileInputStream(filename));
                fits.loadPreview(is1);
                headerFits.setKeyValue("NAXIS", "2");
                headerFits.setKeyValue("NAXIS1", fits.width + "");
                headerFits.setKeyValue("NAXIS2", fits.height + "");
                headerFits.setKeyValue("NAXIS3", null);
                fits.free();
            }
            catch (Exception e1) {
                // empty catch block
            }
        }
    }

    private Dimension getSizeJPEGPNG(String filename) {
        Dimension dim = null;
        try {
            Fits fits = new Fits();
            MyInputStream is1 = new MyInputStream(new FileInputStream(filename));
            fits.loadPreview(is1);
            dim = new Dimension(fits.width, fits.height);
            fits.free();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dim;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadPreview(String filename, boolean color, boolean scanCommentCalib, int format) throws Exception {
        filename = this.parseCell(filename);
        MyInputStream is = null;
        try {
            is = new MyInputStream(new FileInputStream(filename));
            if (scanCommentCalib) {
                is.getType();
                if (is.hasCommentCalib()) {
                    Dimension dim = new Dimension(0, 0);
                    if (is.hasCommentAVM()) {
                        dim = this.getSizeJPEGPNG(filename);
                    }
                    this.headerFits = is.createHeaderFitsFromCommentCalib(dim.width, dim.height);
                    this.bidouilleJPEGPNG(this.headerFits, filename);
                    try {
                        this.setCalib(new Calib(this.headerFits));
                    }
                    catch (Exception e) {
                        System.err.println("loadJpeg(" + filename + ") : no calib found !");
                        this.calib = null;
                    }
                }
            }
            this.loadPreview(is, this.xCell, this.yCell, this.widthCell, this.heightCell, color, format);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        this.setFilename(filename);
    }

    public void loadPreview(MyInputStream dis, boolean flagColor) throws Exception {
        this.loadPreview(dis, 0, 0, -1, -1, flagColor, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadPreview(MyInputStream dis, int x, int y, int w, int h, boolean flagColor, int format) throws Exception {
        int n = this.bitpix = flagColor ? 0 : 8;
        if ((long)this.width * (long)this.height > Integer.MAX_VALUE) {
            throw new Exception("Too large image for JAVA API");
        }
        if (format == 0) {
            int n2 = format = dis.getType() == 65536L ? 2 : 1;
        }
        if (w == -1 && flagColor) {
            this.widthCell = w;
            this.heightCell = h;
            this.xCell = x;
            this.yCell = y;
            this.pixMode = format == 2 ? 0 : 1;
            Image img = Toolkit.getDefaultToolkit().createImage(dis.readFully());
            MyImageLoader loader = new MyImageLoader();
            img.getSource().startProduction(loader);
            while (!loader.ready()) {
                Util.pause(5);
            }
            if (this.width == -1) {
                throw new Exception("MyLoader error");
            }
        } else {
            BufferedImage imgBuf;
            String coding = format == 2 ? "png" : "jpeg";
            Iterator<ImageReader> readers = ImageIO.getImageReadersByFormatName(coding);
            ImageReader reader = readers.next();
            ImageInputStream iis = null;
            try {
                iis = ImageIO.createImageInputStream(dis);
                reader.setInput(iis, true);
                this.width = reader.getWidth(0);
                this.height = reader.getHeight(0);
                if (w == -1) {
                    w = this.width;
                    h = this.height;
                    x = 0;
                    y = 0;
                }
                if (x < 0 || y < 0 || x + w > this.width || y + h > this.height) {
                    throw new Exception("Mosaic cell outside the image (" + this.width + "x" + this.height + ") cell=[" + x + "," + y + " " + w + "x" + h + "]");
                }
                this.widthCell = w;
                this.heightCell = h;
                this.xCell = x;
                this.yCell = y;
                ImageReadParam param = reader.getDefaultReadParam();
                if (this.widthCell != this.width || this.heightCell != this.height) {
                    int yJpegCell = this.height - this.yCell - this.heightCell;
                    Rectangle r = new Rectangle(this.xCell, yJpegCell, this.widthCell, this.heightCell);
                    param.setSourceRegion(r);
                }
                imgBuf = reader.read(0, param);
                reader.dispose();
            }
            finally {
                if (iis != null) {
                    iis.close();
                }
            }
            if (flagColor) {
                this.pixMode = format == 2 ? 0 : 1;
                int[] rgb1 = imgBuf.getRGB(0, 0, this.widthCell, this.heightCell, null, 0, this.widthCell);
                Fits.invImageLine(this.widthCell, this.heightCell, rgb1);
                this.rgb = rgb1;
                rgb1 = null;
            } else {
                this.pixMode = format == 2 ? 4 : 3;
                this.pixels = ((DataBufferByte)imgBuf.getRaster().getDataBuffer()).getData();
                Fits.invImageLine(this.widthCell, this.heightCell, this.pixels);
            }
            try {
                dis.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            imgBuf.flush();
            imgBuf = null;
        }
    }

    protected static void invImageLine(int width, int height, byte[] pixels) {
        byte[] tmp = new byte[width];
        for (int h = height / 2 - 1; h >= 0; --h) {
            int offset1 = h * width;
            int offset2 = (height - h - 1) * width;
            System.arraycopy(pixels, offset1, tmp, 0, width);
            System.arraycopy(pixels, offset2, pixels, offset1, width);
            System.arraycopy(tmp, 0, pixels, offset2, width);
        }
        tmp = null;
    }

    protected static void invImageLine(int width, int height, int[] pixels) {
        int[] tmp = new int[width];
        for (int h = height / 2 - 1; h >= 0; --h) {
            int offset1 = h * width;
            int offset2 = (height - h - 1) * width;
            System.arraycopy(pixels, offset1, tmp, 0, width);
            System.arraycopy(pixels, offset2, pixels, offset1, width);
            System.arraycopy(tmp, 0, pixels, offset2, width);
        }
        tmp = null;
    }

    public String parseCell(String filename) throws Exception {
        this.yCell = 0;
        this.yCell = 0;
        this.xCell = 0;
        this.ext = 0;
        this.heightCell = -1;
        this.heightCell = -1;
        this.widthCell = -1;
        int deb = filename.lastIndexOf(91);
        if (deb == -1) {
            return filename;
        }
        int fin = filename.indexOf(93, deb);
        if (fin == -1) {
            return filename;
        }
        int p = filename.indexOf(44, deb);
        boolean flagCell = p > 0;
        boolean flagZ = filename.indexOf(44, p + 1) > 0;
        boolean flagMef = !flagCell || filename.indexOf(58, deb) > 0;
        StringTokenizer st = new StringTokenizer(filename.substring(deb + 1, fin), ":,-x");
        try {
            if (flagMef) {
                this.ext = Integer.parseInt(st.nextToken());
            }
            if (flagCell) {
                this.xCell = Integer.parseInt(st.nextToken());
                this.yCell = Integer.parseInt(st.nextToken());
                this.zCell = flagZ ? Integer.parseInt(st.nextToken()) : 0;
                this.widthCell = Integer.parseInt(st.nextToken());
                this.heightCell = Integer.parseInt(st.nextToken());
                this.depthCell = flagZ ? Integer.parseInt(st.nextToken()) : 1;
            }
        }
        catch (Exception e) {
            throw new Exception("Bad cell mosaic FITS definition => " + filename);
        }
        return filename.substring(0, deb);
    }

    public void loadFITS(String filename, int ext, int x, int y, int w, int h) throws Exception {
        this.loadFITS(filename + "[" + ext + ":" + x + "," + y + "-" + w + "x" + h + "]");
    }

    public void loadFITS(String filename, int ext, int x, int y, int z, int w, int h, int d) throws Exception {
        this.loadFITS(filename + "[" + ext + ":" + x + "," + y + "," + z + "-" + w + "x" + h + "x" + d + "]");
    }

    public void loadFITS(String filename) throws Exception {
        this.loadFITS(filename, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFITS(String filename, boolean color, boolean flagLoad) throws Exception {
        filename = this.parseCell(filename);
        MyInputStream is = null;
        try {
            is = new MyInputStream(new FileInputStream(filename));
            is = is.startRead();
            if (color) {
                if (this.widthCell < 0) {
                    throw new Exception("Mosaic mode not supported yet for FITS color file");
                }
                this.loadFITSColor(is);
            } else {
                this.loadFITS(is, this.ext, this.xCell, this.yCell, this.zCell, this.widthCell, this.heightCell, this.depthCell, flagLoad);
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        this.setFilename(filename);
    }

    public void loadFITS(MyInputStream dis) throws Exception {
        this.loadFITS(dis, 0, 0, 0, 0, -1, -1, -1);
    }

    public void loadFITS(MyInputStream dis, int ext, int x, int y, int z, int w, int h, int d) throws Exception {
        this.loadFITS(dis, ext, x, y, z, w, h, d, true);
    }

    private void moveOnHUD(MyInputStream dis, int ext) throws Exception {
        boolean first = true;
        while (ext > 0) {
            HeaderFits h = new HeaderFits(dis);
            if (first) {
                this.headerFits0 = h;
                first = false;
            }
            int bitpix = h.getIntFromHeader("BITPIX");
            int naxis = h.getIntFromHeader("NAXIS");
            if (naxis != 0) {
                int gcount = 1;
                try {
                    gcount = h.getIntFromHeader("GCOUNT");
                }
                catch (Exception e) {
                    // empty catch block
                }
                int pcount = 0;
                try {
                    pcount = h.getIntFromHeader("PCOUNT");
                }
                catch (Exception e) {
                    // empty catch block
                }
                long taille = 1L;
                for (int i = 1; i <= naxis; ++i) {
                    int n = h.getIntFromHeader("NAXIS" + i);
                    taille *= (long)n;
                }
                taille += (long)pcount;
                dis.skip(taille *= (long)(gcount * Math.abs(bitpix) / 8));
                dis.skipOnNext2880();
            }
            --ext;
        }
    }

    public void setSkipHDU0(boolean flag) {
        this.skipHDU0 = flag;
    }

    public void loadFITS(MyInputStream dis, int ext, int x, int y, int z, int w, int h, int d, boolean flagLoad) throws Exception {
        boolean flagHComp = (dis = dis.startRead()).isHCOMP();
        if (flagHComp || dis.isGZ()) {
            this.releasable = false;
            flagLoad = true;
        }
        this.moveOnHUD(dis, ext);
        this.pixMode = 2;
        this.headerFits = new HeaderFits(dis);
        if (ext == 0 && this.headerFits.getIntFromHeader("NAXIS") == 0) {
            if (!this.skipHDU0) {
                return;
            }
            this.headerFits = new HeaderFits(dis);
        }
        this.bitpix = this.headerFits.getIntFromHeader("BITPIX");
        this.width = this.headerFits.getIntFromHeader("NAXIS1");
        this.height = this.headerFits.getIntFromHeader("NAXIS2");
        try {
            this.depth = this.headerFits.getIntFromHeader("NAXIS3");
        }
        catch (Exception e) {
            this.depth = 1;
        }
        if (w == -1) {
            this.widthCell = this.width;
            this.heightCell = this.height;
            this.depthCell = this.depth;
            this.zCell = 0;
            this.yCell = 0;
            this.xCell = 0;
        } else {
            if (x < 0 || y < 0 || x + w > this.width || y + h > this.height || z < 0 || z + d > this.depth) {
                throw new Exception("Mosaic cell outside the image (" + this.width + "x" + this.height + ") cell=[" + x + "," + y + "," + z + " " + w + "x" + h + "x" + d + "]");
            }
            this.widthCell = w;
            this.heightCell = h;
            this.depthCell = d;
            this.xCell = x;
            this.yCell = y;
            this.zCell = z;
        }
        try {
            this.blank = this.headerFits.getDoubleFromHeader("BLANK");
        }
        catch (Exception e) {
            this.blank = Double.NaN;
        }
        int n = Math.abs(this.bitpix) / 8;
        this.bitmapOffset = dis.getPos();
        int size = this.widthCell * this.heightCell * this.depthCell * n;
        if (flagHComp) {
            byte[] buf = Hdecomp.decomp(dis);
            if (w == -1) {
                this.pixels = buf;
            } else {
                this.pixels = new byte[size];
                for (int frame = 0; frame < this.depthCell; ++frame) {
                    for (int lig = 0; lig < this.heightCell; ++lig) {
                        System.arraycopy(buf, ((this.zCell + frame) * this.width * this.height + (this.yCell + lig) * this.width + this.xCell) * n, this.pixels, (frame * this.widthCell * this.heightCell + lig * this.widthCell) * n, this.widthCell * n);
                    }
                }
            }
        } else if (flagLoad || this.bitpix == 8) {
            this.pixels = new byte[size];
            if (w == -1) {
                dis.readFully(this.pixels);
            } else if (w == this.width && this.depth == 1) {
                dis.skip((long)this.yCell * (long)this.width * (long)n);
                dis.readFully(this.pixels);
            } else {
                dis.skip((long)this.zCell * (long)this.width * (long)this.height * (long)n);
                for (int frame = 0; frame < this.depthCell; ++frame) {
                    dis.skip((long)this.yCell * (long)this.width * (long)n);
                    byte[] buf = new byte[this.width * n];
                    for (int lig = 0; lig < this.heightCell; ++lig) {
                        dis.readFully(buf);
                        System.arraycopy(buf, this.xCell * n, this.pixels, frame * this.widthCell * this.heightCell + lig * this.widthCell * n, this.widthCell * n);
                    }
                    dis.skip((long)((this.height - (this.yCell + this.heightCell)) * this.width) * (long)n);
                }
                dis.skip((long)((this.depth - (this.zCell + this.depthCell)) * this.width * this.height) * (long)n);
            }
        } else {
            this.bitmapReleaseDone = true;
        }
        try {
            this.bscale = this.headerFits.getDoubleFromHeader("BSCALE");
        }
        catch (Exception e) {
            this.bscale = 1.0;
        }
        try {
            this.bzero = this.headerFits.getDoubleFromHeader("BZERO");
        }
        catch (Exception e) {
            this.bzero = 0.0;
        }
        try {
            this.setCalib(new Calib(this.headerFits));
        }
        catch (Exception e) {
            this.calib = null;
        }
    }

    public void loadFITSARGB(MyInputStream dis) throws Exception {
        this.headerFits = new HeaderFits(dis);
        this.width = this.widthCell = this.headerFits.getIntFromHeader("NAXIS1");
        this.height = this.heightCell = this.headerFits.getIntFromHeader("NAXIS2");
        this.yCell = 0;
        this.xCell = 0;
        this.pixMode = 0;
        this.pixels = new byte[this.widthCell * this.heightCell * 32];
        dis.readFully(this.pixels);
        this.setARGB();
        try {
            this.setCalib(new Calib(this.headerFits));
        }
        catch (Exception e) {
            this.calib = null;
        }
    }

    public void loadFITSColor(MyInputStream dis) throws Exception {
        this.headerFits = new HeaderFits(dis);
        this.bitpix = this.headerFits.getIntFromHeader("BITPIX");
        this.width = this.widthCell = this.headerFits.getIntFromHeader("NAXIS1");
        this.height = this.heightCell = this.headerFits.getIntFromHeader("NAXIS2");
        this.depthCell = 1;
        this.depth = 1;
        this.zCell = 0;
        this.yCell = 0;
        this.xCell = 0;
        this.pixMode = 1;
        this.pixels = new byte[this.widthCell * this.heightCell];
        dis.readFully(this.pixels);
        byte[] t2 = new byte[this.widthCell * this.heightCell];
        dis.readFully(t2);
        byte[] t3 = new byte[this.widthCell * this.heightCell];
        dis.readFully(t3);
        this.rgb = new int[this.widthCell * this.heightCell];
        for (int i = 0; i < this.heightCell * this.widthCell; ++i) {
            int val = 0;
            this.rgb[i] = val = 0 | (this.pixels[i] & 0xFF) << 16 | (t2[i] & 0xFF) << 8 | t3[i] & 0xFF;
        }
        try {
            this.bscale = this.headerFits.getIntFromHeader("BSCALE");
        }
        catch (Exception e) {
            this.bscale = 1.0;
        }
        try {
            this.bzero = this.headerFits.getIntFromHeader("BZERO");
        }
        catch (Exception e) {
            this.bzero = 0.0;
        }
        try {
            this.setCalib(new Calib(this.headerFits));
        }
        catch (Exception e) {
            this.calib = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int loadHeaderFITS(String filename) throws Exception {
        filename = this.parseCell(filename);
        int code = 0;
        MyInputStream is = null;
        try {
            long type;
            is = new MyInputStream(new FileInputStream(filename));
            if (is.isGZ()) {
                code |= 1;
                is = is.startRead();
            }
            if (((type = is.getType(10000)) & 0x10002L) != 0L && !is.hasCommentCalib()) {
                is.fastExploreCommentOrAvmCalib(filename);
            }
            if (filename.endsWith(".hhh")) {
                byte[] buf = is.readFully();
                this.headerFits = new HeaderFits();
                this.headerFits.readFreeHeader(new String(buf), true, null);
                code |= 2;
            } else if (is.hasCommentCalib()) {
                Dimension dim = new Dimension(0, 0);
                if (is.hasCommentAVM()) {
                    dim = this.getSizeJPEGPNG(filename);
                }
                this.headerFits = is.createHeaderFitsFromCommentCalib(dim.width, dim.height);
                this.bidouilleJPEGPNG(this.headerFits, filename);
            } else {
                this.moveOnHUD(is, this.ext);
                this.headerFits = new HeaderFits(is);
                if (this.ext == 0 && this.headerFits.getIntFromHeader("NAXIS") == 0) {
                    if (!this.skipHDU0) {
                        int dim = 0;
                        return dim;
                    }
                    this.headerFits0 = this.headerFits;
                    this.headerFits = new HeaderFits(is);
                }
                this.bitmapOffset = is.getPos();
                try {
                    this.bitpix = this.headerFits.getIntFromHeader("BITPIX");
                }
                catch (Exception e1) {
                    this.bitpix = 0;
                }
            }
            if (this.bitpix == 0) {
                code |= 4;
            }
            try {
                this.width = this.headerFits.getIntFromHeader("NAXIS1");
                this.height = this.headerFits.getIntFromHeader("NAXIS2");
                try {
                    this.depth = this.headerFits.getIntFromHeader("NAXIS3");
                }
                catch (Exception e) {
                    this.depth = 1;
                }
                if (!this.hasCell()) {
                    this.zCell = 0;
                    this.yCell = 0;
                    this.xCell = 0;
                    this.widthCell = this.width;
                    this.heightCell = this.height;
                    this.depthCell = this.depth;
                }
                try {
                    this.blank = this.headerFits.getDoubleFromHeader("BLANK");
                }
                catch (Exception e) {
                    this.blank = Double.NaN;
                }
                try {
                    this.bscale = this.headerFits.getDoubleFromHeader("BSCALE");
                }
                catch (Exception e) {
                    this.bscale = 1.0;
                }
                try {
                    this.bzero = this.headerFits.getDoubleFromHeader("BZERO");
                }
                catch (Exception e) {
                    this.bzero = 0.0;
                }
                try {
                    this.setCalib(new Calib(this.headerFits));
                }
                catch (Exception e) {
                    this.calib = null;
                    if (Aladin.levelTrace >= 3) {
                        e.printStackTrace();
                    }
                }
            }
            catch (Exception e) {
                if (Aladin.levelTrace >= 3) {
                    e.printStackTrace();
                }
                this.calib = null;
            }
            this.setFilename(filename);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        return code;
    }

    public double getBscale() {
        return this.bscale;
    }

    public double getBzero() {
        return this.bzero;
    }

    public double getBlank() {
        return this.blank;
    }

    public void setBscale(double bscale) {
        this.bscale = bscale;
        if (this.headerFits != null) {
            this.headerFits.setKeyValue("BSCALE", bscale == 1.0 ? (String)null : bscale + "");
        }
    }

    public void setBzero(double bzero) {
        this.bzero = bzero;
        if (this.headerFits != null) {
            this.headerFits.setKeyValue("BZERO", bzero == 0.0 ? (String)null : bzero + "");
        }
    }

    public void setBlank(double blank) {
        this.blank = blank;
        if (this.headerFits != null) {
            this.headerFits.setKeyValue("BLANK", Double.isNaN(blank) ? (String)null : (this.bitpix > 0 ? (double)((int)blank) : blank) + "");
        }
    }

    public void setARGB() {
        this.setARGB(true);
    }

    public void setARGB(boolean reverse) {
        this.pixMode = 0;
        this.bitpix = 0;
        if (this.headerFits != null) {
            this.headerFits.setKeyValue("COLORMOD", "ARGB");
        }
        this.rgb = new int[this.widthCell * this.heightCell];
        for (int y = 0; y < this.heightCell; ++y) {
            for (int x = 0; x < this.widthCell; ++x) {
                int i = y * this.widthCell + x;
                int offset = reverse ? (this.heightCell - y - 1) * this.widthCell + x : i;
                this.rgb[offset] = (this.pixels[i * 4] & 0xFF) << 24 | (this.pixels[i * 4 + 1] & 0xFF) << 16 | (this.pixels[i * 4 + 2] & 0xFF) << 8 | this.pixels[i * 4 + 3] & 0xFF;
            }
        }
    }

    private void createDir(String filename) throws Exception {
        Util.createPath(filename);
    }

    public static byte[] getBourrage(int currentPos) {
        int n = currentPos % 2880;
        int size = n == 0 ? 0 : 2880 - n;
        byte[] b = new byte[size];
        return b;
    }

    public void writeFITS(OutputStream os) throws Exception {
        int i;
        int size = this.headerFits.writeHeader(os);
        this.bitmapOffset = size;
        if (this.pixMode == 0 || this.pixMode == 1) {
            byte[] buf = new byte[this.rgb.length * 4];
            for (i = 0; i < this.rgb.length; ++i) {
                int pix = this.rgb[i];
                buf[i * 4] = (byte)(this.pixMode == 0 ? pix >> 24 & 0xFF : 255);
                buf[i * 4 + 1] = (byte)(pix >> 16 & 0xFF);
                buf[i * 4 + 2] = (byte)(pix >> 8 & 0xFF);
                buf[i * 4 + 3] = (byte)(pix & 0xFF);
            }
            os.write(buf);
            size += buf.length;
            buf = null;
        } else {
            os.write(this.pixels);
            size += this.pixels.length;
        }
        if (this.extHeader == null) {
            return;
        }
        int n = this.extHeader.size();
        for (i = 0; i < n; ++i) {
            byte[] b = Fits.getBourrage(size);
            size += b.length;
            os.write(b);
            HeaderFits h = (HeaderFits)this.extHeader.elementAt(i);
            h.writeHeader(os);
            byte[] p = (byte[])this.extPixels.elementAt(i);
            os.write(p);
            size += p.length;
        }
    }

    public void writeFITS(String filename) throws Exception {
        this.writeFITS(filename, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFITS(String filename, boolean zip) throws Exception {
        this.createDir(filename);
        OutputStream os = null;
        try {
            os = new FileOutputStream(filename);
            if (zip) {
                os = new GZIPOutputStream(os);
            }
            this.writeFITS(os);
        }
        finally {
            os.close();
        }
        this.setFilename(filename);
    }

    public void addFitsExtension(HeaderFits header, byte[] pixels) {
        if (this.extHeader == null) {
            this.extHeader = new Vector();
            this.extPixels = new Vector();
        }
        this.headerFits.setKeyValue("EXTEND", "T");
        this.extHeader.addElement(header);
        this.extPixels.addElement(pixels);
    }

    public void clearExtensions() {
        this.extPixels = null;
        this.extHeader = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeCompressed(String file, double pixelMin, double pixelMax, byte[] tcm, String format) throws Exception {
        this.createDir(file);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(new File(file));
            this.writePreview(fos, pixelMin, pixelMax, tcm, format);
            this.setReleasable(false);
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
        this.setFilename(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writePreview(OutputStream os, double pixelMin, double pixelMax, byte[] tcm, String format) throws Exception {
        BufferedImage imgTarget;
        Image imgSrc;
        int typeInt;
        int[] rgb = this.rgb;
        int n = typeInt = format.equals("png") ? 2 : 1;
        if (this.bitpix == 0 || this.pixMode == 1 || this.pixMode == 0) {
            rgb = new int[this.rgb.length];
            System.arraycopy(this.rgb, 0, rgb, 0, rgb.length);
            Fits.invImageLine(this.widthCell, this.heightCell, rgb);
            imgSrc = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(this.widthCell, this.heightCell, rgb, 0, this.widthCell));
            imgTarget = new BufferedImage(this.width, this.height, typeInt);
        } else {
            int targetPixMode = format.equals("png") ? 4 : 3;
            byte[] pix8 = this.toPix8(pixelMin, pixelMax, tcm, targetPixMode);
            imgSrc = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(this.widthCell, this.heightCell, this.getCM(targetPixMode), pix8, 0, this.widthCell));
            imgTarget = new BufferedImage(this.width, this.height, typeInt);
        }
        Graphics2D g = imgTarget.createGraphics();
        int yJpegCell = this.height - this.yCell - this.heightCell;
        g.drawImage(imgSrc, this.xCell, yJpegCell, null);
        g.dispose();
        ImageWriter writer = ImageIO.getImageWritersByFormatName(format).next();
        ImageWriteParam iwp = writer.getDefaultWriteParam();
        if (format.equals("jpeg")) {
            iwp.setCompressionMode(2);
            iwp.setCompressionQuality(0.95f);
        }
        ImageOutputStream out = null;
        try {
            out = ImageIO.createImageOutputStream(os);
            writer.setOutput(out);
            writer.write(null, new IIOImage(imgTarget, null, null), iwp);
            writer.dispose();
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeRGBPreview(String file, String format) throws Exception {
        this.createDir(file);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(new File(file));
            this.writeRGBPreview(fos, format);
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
        this.setFilename(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeRGBPreview(OutputStream os, String format) throws Exception {
        int typeInt = format.equals("png") ? 2 : 1;
        Image img = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(this.widthCell, this.heightCell, this.rgb, 0, this.widthCell));
        BufferedImage bufferedImage = new BufferedImage(this.width, this.height, typeInt);
        Graphics2D g = bufferedImage.createGraphics();
        g.drawImage(img, this.xCell, this.yCell, null);
        g.dispose();
        ImageWriter writer = ImageIO.getImageWritersByFormatName(format).next();
        ImageWriteParam iwp = writer.getDefaultWriteParam();
        if (format.equals("jpeg")) {
            iwp.setCompressionMode(2);
            iwp.setCompressionQuality(0.95f);
        }
        ImageOutputStream out = null;
        try {
            out = ImageIO.createImageOutputStream(os);
            writer.setOutput(out);
            writer.write(null, new IIOImage(bufferedImage, null, null), iwp);
            writer.dispose();
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    protected boolean isTransparent() {
        return Fits.isTransparent(this.pixMode);
    }

    protected static boolean isTransparent(int pixMode) {
        return pixMode == 4 || pixMode == 2 || pixMode == 0;
    }

    private ColorModel getCM(int pixMode) {
        byte[] r = new byte[256];
        boolean transp = Fits.isTransparent(pixMode);
        int gap = transp ? 1 : 0;
        for (int i = 1; i < r.length; ++i) {
            r[i] = (byte)(i - gap);
        }
        return transp ? new IndexColorModel(8, 256, r, r, r, 0) : new IndexColorModel(8, 256, r, r, r);
    }

    public int getPixelRGB(int x, int y) {
        return this.rgb[(y - this.yCell) * this.widthCell + (x - this.xCell)];
    }

    public int getPixelRGBJPG(int x, int y) {
        return this.rgb[(y - this.yCell) * this.widthCell + (x - this.xCell)];
    }

    public String getCellSuffix() {
        if (!this.hasCell()) {
            return this.ext == 0 ? "" : "[" + this.ext + "]";
        }
        return "[" + (this.ext == 0 ? "" : this.ext + ":") + this.xCell + "," + this.yCell + (this.depth > 1 ? "," + this.zCell : "") + "-" + this.widthCell + "x" + this.heightCell + (this.depth > 1 ? "x" + this.depthCell : "") + "]";
    }

    public String getMefSuffix() {
        if (this.ext == 0) {
            return "";
        }
        return "[" + this.ext + "]";
    }

    public boolean hasCell() {
        return this.widthCell != -1 && this.heightCell != -1 && this.depthCell != -1 && (this.widthCell != this.width || this.heightCell != this.height || this.depthCell != this.depth);
    }

    public boolean isInCell(int x, int y, int z) {
        return x >= this.xCell && x < this.xCell + this.widthCell && y >= this.yCell && y < this.yCell + this.heightCell && z >= this.zCell && z < this.zCell + this.depthCell;
    }

    public double getPixelDirectAccess(int x, int y) throws Exception {
        return this.getPixelDirectAccess(x, y, 0);
    }

    public double getPixelDirectAccess(int x, int y, int z) throws Exception {
        if (this.filename == null || this.bitmapOffset == -1L) {
            throw new Exception("FITS stream not compatible (not a true file [" + this.filename + "])");
        }
        if (this.fDirectAccess == null) {
            this.fDirectAccess = new RandomAccessFile(this.filename, "r");
        }
        int n = Math.abs(this.bitpix) / 8;
        byte[] pixels = new byte[n];
        long offset = this.bitmapOffset + ((long)z * (long)this.width * (long)this.height + (long)y * (long)this.width + (long)x) * (long)n;
        this.fDirectAccess.seek(offset);
        this.fDirectAccess.readFully(pixels);
        return this.getPixValDouble(pixels, this.bitpix, 0);
    }

    public double getPixelFull(int x, int y) {
        double pix = this.getPixValDouble(this.pixels, this.bitpix, (y - this.yCell) * this.widthCell + (x - this.xCell));
        if (this.isBlankPixel(pix)) {
            return pix;
        }
        return this.bscale * pix + this.bzero;
    }

    public double getPixelFull(int x, int y, int z) {
        double pix = this.getPixValDouble(this.pixels, this.bitpix, (z - this.zCell) * this.widthCell * this.heightCell + (y - this.yCell) * this.widthCell + (x - this.xCell));
        if (this.isBlankPixel(pix)) {
            return pix;
        }
        return this.bscale * pix + this.bzero;
    }

    public double getPixelDouble(int x, int y) {
        return this.getPixValDouble(this.pixels, this.bitpix, (y - this.yCell) * this.widthCell + (x - this.xCell));
    }

    public double getPixelDouble(int x, int y, int z) {
        return this.getPixValDouble(this.pixels, this.bitpix, (z - this.zCell) * this.widthCell * this.heightCell + (y - this.yCell) * this.widthCell + (x - this.xCell));
    }

    public int getPixelInt(int x, int y) {
        return this.getPixValInt(this.pixels, this.bitpix, (y - this.yCell) * this.widthCell + (x - this.xCell));
    }

    public int getPixelInt(int x, int y, int z) {
        return this.getPixValInt(this.pixels, this.bitpix, (z - this.zCell) * this.widthCell * this.heightCell + (y - this.yCell) * this.widthCell + (x - this.xCell));
    }

    public void setPixelRGB(int x, int y, int val) {
        this.rgb[(y - this.yCell) * this.widthCell + (x - this.xCell)] = val;
    }

    public void setPixelRGBJPG(int x, int y, int val) {
        this.rgb[(y - this.yCell) * this.widthCell + (x - this.xCell)] = val;
    }

    public void setPixelDouble(int x, int y, double val) {
        this.setPixValDouble(this.pixels, this.bitpix, (y - this.yCell) * this.widthCell + (x - this.xCell), val);
    }

    public void setPixelDouble(int x, int y, int z, double val) {
        this.setPixValDouble(this.pixels, this.bitpix, z * this.widthCell * this.heightCell + (y - this.yCell) * this.widthCell + (x - this.xCell), val);
    }

    public void setPixelInt(int x, int y, int val) {
        this.setPixValInt(this.pixels, this.bitpix, (y - this.yCell) * this.widthCell + (x - this.xCell), val);
    }

    public void setPixelInt(int x, int y, int z, int val) {
        this.setPixValInt(this.pixels, this.bitpix, (z - this.zCell) * this.widthCell * this.heightCell + (y - this.yCell) * this.widthCell + (x - this.xCell), val);
    }

    protected double[] getRaDec(double[] c, double x, double y) throws Exception {
        if (c == null) {
            c = new double[2];
        }
        this.cTmp.x = x;
        this.cTmp.y = y;
        this.calib.GetCoord(this.cTmp);
        c[0] = this.cTmp.al;
        c[1] = this.cTmp.del;
        return c;
    }

    protected double[] getXY(double[] c, double ra, double dec) throws Exception {
        if (c == null) {
            c = new double[2];
        }
        this.cTmp.al = ra;
        this.cTmp.del = dec;
        this.calib.GetXY(this.cTmp);
        c[0] = this.cTmp.x;
        c[1] = this.cTmp.y;
        return c;
    }

    public byte[] toPix8(double min, double max, byte[] tcm, int pixMode) {
        int range = 256;
        int gap = 0;
        if (Fits.isTransparent(pixMode)) {
            range = 254;
            gap = 2;
        }
        byte[] pix8 = new byte[this.widthCell * this.heightCell];
        double r = (double)range / (max - min);
        --range;
        for (int y = 0; y < this.heightCell; ++y) {
            for (int x = 0; x < this.widthCell; ++x) {
                byte pixOut;
                double pixIn = this.getPixelDouble(x + this.xCell, y + this.yCell);
                if (this.isBlankPixel(pixIn)) {
                    pixOut = 0;
                } else {
                    int pix = gap + (pixIn <= min ? 0 : (pixIn >= max ? range : (int)((pixIn - min) * r))) & 0xFF;
                    pixOut = tcm == null ? (byte)pix : tcm[pix];
                }
                this.setPixValInt(pix8, 8, (this.height - y - 1) * this.widthCell + (x + this.xCell), pixOut);
            }
        }
        return pix8;
    }

    public byte[] toPix4(double min, double max, byte[] tcm) {
        int range = 15;
        int gap = 1;
        byte[] pix4 = new byte[this.widthCell * this.heightCell];
        double r = (double)range / (max - min);
        --range;
        for (int y = 0; y < this.heightCell; ++y) {
            for (int x = 0; x < this.widthCell; ++x) {
                byte pixOut;
                double pixIn = this.getPixelDouble(x + this.xCell, y + this.yCell);
                if (this.isBlankPixel(pixIn)) {
                    pixOut = 0;
                } else {
                    int pix = gap + (pixIn <= min ? 0 : (pixIn >= max ? range : (int)((pixIn - min) * r))) & 0xFF;
                    pixOut = tcm == null ? (byte)pix : tcm[pix];
                }
                this.setPixValInt(pix4, 8, (this.height - y - 1) * this.widthCell + (x + this.xCell), pixOut);
            }
        }
        return pix4;
    }

    public double[] findData() throws Exception {
        double[] shape = new double[4];
        try {
            int y;
            int x;
            double c;
            int x2;
            int y2;
            if (this.isReleased()) {
                this.reloadBitmap();
            }
            double pixBord = this.getPixValDouble(this.pixels, this.bitpix, 0);
            int gauche = -1;
            int droite = -1;
            int bas = -1;
            int haut = -1;
            block2: for (y2 = 0; y2 < this.height; ++y2) {
                for (x2 = 0; x2 < this.width; ++x2) {
                    c = this.getPixValDouble(this.pixels, this.bitpix, y2 * this.width + x2);
                    if (c == pixBord) continue;
                    haut = y2;
                    break block2;
                }
            }
            block4: for (y2 = this.height - 1; y2 >= 0; --y2) {
                for (x2 = 0; x2 < this.width; ++x2) {
                    c = this.getPixValDouble(this.pixels, this.bitpix, y2 * this.width + x2);
                    if (c == pixBord) continue;
                    bas = y2;
                    break block4;
                }
            }
            block6: for (x = 0; x < this.width; ++x) {
                for (y = 0; y < this.height; ++y) {
                    c = this.getPixValDouble(this.pixels, this.bitpix, y * this.width + x);
                    if (c == pixBord) continue;
                    gauche = x;
                    break block6;
                }
            }
            block8: for (x = this.height - 1; x >= 0; --x) {
                for (y = 0; y < this.height; ++y) {
                    c = this.getPixValDouble(this.pixels, this.bitpix, y * this.width + x);
                    if (c == pixBord) continue;
                    droite = x;
                    break block8;
                }
            }
            shape[0] = (droite + gauche) / 2;
            shape[1] = (haut + bas) / 2;
            shape[2] = (droite - gauche) / 2;
            shape[3] = (bas - haut) / 2;
            if (droite == -1 || gauche == -1) {
                shape[0] = this.width / 2;
                shape[2] = this.width / 2;
            }
            if (haut == -1 || bas == -1) {
                shape[1] = this.height / 2;
                shape[3] = this.height / 2;
            }
        }
        catch (Exception e) {
            shape = null;
        }
        return shape;
    }

    public double[] findAutocutRange() throws Exception {
        return this.findAutocutRange(0.0, 0.0, false);
    }

    public double[] findAutocutRange(double min, double max, boolean full) throws Exception {
        double[] range = new double[5];
        try {
            if (this.isReleased()) {
                this.reloadBitmap();
            }
            this.findMinMax(range, this.pixels, this.bitpix, this.widthCell, this.heightCell, this.depthCell, min, max, true, full, 0);
        }
        catch (Exception e) {
            range[0] = range[2] = min;
            range[1] = range[3] = max;
            range[4] = 0.0;
        }
        return range;
    }

    public boolean isBlankPixel(double pix) {
        return Double.isNaN(pix) || pix == this.blank;
    }

    public boolean hasUsers() {
        return this.users > 0;
    }

    public synchronized void addUser() {
        ++this.users;
    }

    public synchronized void rmUser() {
        --this.users;
    }

    public boolean isReleased() {
        return this.bitmapReleaseDone;
    }

    public void setReleasable(boolean flag) {
        this.releasable = flag;
    }

    public boolean isReleasable() {
        return this.releasable;
    }

    public void releaseBitmap() throws Exception {
        if (this.bitpix == 0) {
            return;
        }
        if (this.hasUsers()) {
            return;
        }
        if (this.filename == null) {
            return;
        }
        this.testBitmapReleaseFeature();
        this.pixels = null;
        this.bitmapReleaseDone = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadBitmap() throws Exception {
        if (this.bitpix == 0) {
            return;
        }
        if (this.pixels != null) {
            return;
        }
        if (this.filename == null) {
            return;
        }
        if (!this.bitmapReleaseDone) {
            throw new Exception("no releaseBitmap done before");
        }
        this.testBitmapReleaseFeature();
        RandomAccessFile f = null;
        try {
            f = new RandomAccessFile(this.filename, "r");
            int n = Math.abs(this.bitpix) / 8;
            this.pixels = new byte[this.widthCell * this.heightCell * this.depth * n];
            if (!this.hasCell()) {
                f.seek(this.bitmapOffset);
                f.readFully(this.pixels);
            } else {
                for (int z = 0; z < this.depth; ++z) {
                    long offset = this.bitmapOffset + (long)z * (long)this.width * (long)this.height + (long)this.yCell * (long)this.width * (long)n;
                    f.seek(offset);
                    byte[] buf = new byte[this.width * n];
                    for (int lig = 0; lig < this.heightCell; ++lig) {
                        f.readFully(buf);
                        System.arraycopy(buf, this.xCell * n, this.pixels, z * this.widthCell * this.heightCell + lig * this.widthCell * n, this.widthCell * n);
                    }
                }
            }
        }
        finally {
            if (f != null) {
                f.close();
            }
        }
        this.bitmapReleaseDone = false;
    }

    private void testBitmapReleaseFeature() throws Exception {
        if (this.filename == null || this.bitmapOffset == -1L) {
            throw new Exception("FITS stream not compatible (not a true file [" + this.filename + "])");
        }
        if (!this.releasable) {
            throw new Exception("FITS not compatible (compressed or reserved by user)");
        }
        if (!new File(this.filename).canRead()) {
            throw new Exception("FITS does not exist on disk [" + this.filename + "]");
        }
    }

    public void finalize() throws Throwable {
        this.free();
    }

    public void free() {
        this.pixels = null;
        this.rgb = null;
        this.calib = null;
        this.headerFits0 = null;
        this.headerFits = null;
        this.bitpix = 0;
        this.height = 0;
        this.width = 0;
        this.depth = 0;
        this.ext = 0;
        this.zCell = 0;
        this.yCell = 0;
        this.xCell = 0;
        this.depthCell = 0;
        this.heightCell = 0;
        this.widthCell = 0;
        if (this.fDirectAccess != null) {
            try {
                this.fDirectAccess.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.fDirectAccess = null;
        }
    }

    public void freeHeader() {
        this.headerFits0 = null;
        this.headerFits = null;
    }

    public String toString() {
        if (this.depth > 1) {
            return "Fits file: " + this.width + "x" + this.height + "x" + this.depth + " bitpix=" + this.bitpix + " [" + this.xCell + "," + this.yCell + "," + this.zCell + " " + this.widthCell + "x" + this.heightCell + "x" + this.depthCell + "]";
        }
        return "Fits file: " + this.width + "x" + this.height + " bitpix=" + this.bitpix + " [" + this.xCell + "," + this.yCell + " " + this.widthCell + "x" + this.heightCell + "]";
    }

    private void findMinMax(double[] range, byte[] pIn, int bitpix, int width, int height, int depth, double minCut, double maxCut, boolean autocut, boolean full, int ntest) throws Exception {
        double c;
        int j;
        int i;
        boolean flagCut = ntest > 0 || minCut != 0.0 && maxCut != 0.0;
        double max = 0.0;
        double max1 = 0.0;
        double min = 0.0;
        double min1 = 0.0;
        int margeW = 0;
        int margeH = 0;
        int margeZ = 0;
        if (!full) {
            margeW = (int)((double)width * 0.05);
            margeH = (int)((double)height * 0.05);
            margeZ = (int)((double)depth * 0.05);
            if (width - 2 * margeW > FINDMINMAXSIZE) {
                margeW = (width - FINDMINMAXSIZE) / 2;
            }
            if (height - 2 * margeH > FINDMINMAXSIZE) {
                margeH = (height - FINDMINMAXSIZE) / 2;
            }
            if (depth - 2 * margeZ > FINDMINMAXDEPTH) {
                margeZ = (depth - FINDMINMAXDEPTH) / 2;
            }
            if (depth - 2 * margeZ < 1) {
                margeZ = 0;
            }
        }
        if (!(autocut || minCut == 0.0 && maxCut == 0.0)) {
            range[2] = min = minCut;
            range[3] = max = maxCut;
        } else {
            int nblank = 0;
            boolean first = true;
            long nmin = 0L;
            long nmax = 0L;
            for (i = margeH; i < height - margeH; ++i) {
                for (j = margeW; j < width - margeW; ++j) {
                    for (int z = margeZ; z < depth - margeZ; ++z) {
                        c = this.getPixValDouble(pIn, bitpix, z * height * width + i * width + j);
                        if (this.isBlankPixel(c)) {
                            ++nblank;
                            continue;
                        }
                        if (flagCut && (c < minCut || c > maxCut)) continue;
                        if (first) {
                            min = min1 = c;
                            max1 = min1;
                            max = min1;
                            first = false;
                        }
                        if (min > c) {
                            min = c;
                            nmin = 1L;
                        } else if (max < c) {
                            max = c;
                            nmax = 1L;
                        } else {
                            if (c == min) {
                                ++nmin;
                            }
                            if (c == max) {
                                ++nmax;
                            }
                        }
                        if (c < min1 && c > min || min1 == min && c < max1) {
                            min1 = c;
                            continue;
                        }
                        if (!(c > max1 && c < max) && (max1 != max || !(c > min1))) continue;
                        max1 = c;
                    }
                }
            }
            if (autocut && max - min > 256.0) {
                if (min1 - min > max1 - min1 && min1 != Double.MAX_VALUE && min1 != max) {
                    min = min1;
                }
                if (max - max1 > max1 - min1 && max1 != Double.MIN_VALUE && max1 != min) {
                    max = max1;
                }
            }
            range[2] = min;
            range[3] = max;
            try {
                range[4] = (double)nblank / (double)((height - 2 * margeH) * (width - 2 * margeW));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (autocut) {
            int nbean = 10000;
            double l = (max - min) / (double)nbean;
            int[] bean = new int[nbean];
            for (i = margeH; i < height - margeH; ++i) {
                for (int k = margeW; k < width - margeW; ++k) {
                    c = this.getPixValDouble(pIn, bitpix, i * width + k);
                    if (this.isBlankPixel(c)) continue;
                    j = (int)((c - min) / l);
                    if (j == bean.length) {
                        --j;
                    }
                    if (j >= bean.length || j < 0) continue;
                    int n = j;
                    bean[n] = bean[n] + 1;
                }
            }
            int[] mmBean = this.getMinMaxBean(bean);
            if (mmBean[0] == -1 || mmBean[1] == -1) {
                throw new Exception("beaning error");
            }
            min1 = min;
            max1 = (double)mmBean[1] * l + min1;
            min1 += (double)mmBean[0] * l;
            if (mmBean[0] != -1 && mmBean[0] > mmBean[1] - 5 && ntest < 3) {
                if (min1 > min) {
                    min = min1;
                }
                if (max1 < max) {
                    max = max1;
                }
                this.findMinMax(range, pIn, bitpix, width, height, depth, min, max, autocut, full, ntest + 1);
                return;
            }
            min = min1;
            max = max1;
        }
        range[0] = min;
        range[1] = max;
    }

    private int[] getMinMaxBean(int[] bean) {
        int i;
        double minLimit = 0.003;
        double maxLimit = 0.9995;
        int[] mmBean = new int[2];
        int totInfo = 0;
        for (i = 0; i < bean.length; ++i) {
            totInfo += bean[i];
        }
        mmBean[1] = -1;
        mmBean[0] = -1;
        int curInfo = 0;
        for (i = 0; i < bean.length; ++i) {
            double p = (double)(curInfo += bean[i]) / (double)totInfo;
            if (mmBean[0] == -1) {
                if (!(p > minLimit)) continue;
                mmBean[0] = i;
                continue;
            }
            if (!(p > maxLimit)) continue;
            mmBean[1] = i;
            break;
        }
        return mmBean;
    }

    private void setPixValInt(byte[] t, int bitpix, int i, int val) {
        switch (bitpix) {
            case 8: {
                t[i] = (byte)(0xFF & val);
                break;
            }
            case 16: {
                int c = val;
                t[i *= 2] = (byte)(0xFF & c >> 8);
                t[i + 1] = (byte)(0xFF & c);
                break;
            }
            case 32: {
                this.setInt(t, i *= 4, val);
                break;
            }
            case -32: {
                int c = Float.floatToIntBits(val);
                this.setInt(t, i *= 4, c);
                break;
            }
            case -64: {
                long c1 = Double.doubleToLongBits(val);
                int c = (int)(0xFFFFFFFFL & c1 >>> 32);
                this.setInt(t, i *= 8, c);
                c = (int)(0xFFFFFFFFL & c1);
                this.setInt(t, i + 4, c);
            }
        }
    }

    public void setPixValDouble(byte[] t, int bitpix, int i, double val) {
        switch (bitpix) {
            case -32: {
                this.setInt(t, i << 2, Float.floatToIntBits((float)val));
                break;
            }
            case 16: {
                int c = (int)val;
                t[i *= 2] = (byte)(0xFF & c >> 8);
                t[i + 1] = (byte)(0xFF & c);
                break;
            }
            case 32: {
                this.setInt(t, i *= 4, (int)val);
                break;
            }
            case 8: {
                t[i] = (byte)(0xFF & (int)val);
                break;
            }
            case -64: {
                long c1 = Double.doubleToLongBits(val);
                int c = (int)(0xFFFFFFFFL & c1 >>> 32);
                this.setInt(t, i *= 8, c);
                c = (int)(0xFFFFFFFFL & c1);
                this.setInt(t, i + 4, c);
            }
        }
    }

    private int getPixValInt(byte[] t, int bitpix, int i) {
        try {
            switch (bitpix) {
                case 8: {
                    return t[i] & 0xFF;
                }
                case 16: {
                    return t[i *= 2] << 8 | t[i + 1] & 0xFF;
                }
                case 32: {
                    return this.getInt(t, i * 4);
                }
                case -32: {
                    return (int)Float.intBitsToFloat(this.getInt(t, i * 4));
                }
                case -64: {
                    long a = (long)this.getInt(t, i *= 8) << 32 | (long)this.getInt(t, i + 4) & 0xFFFFFFFFL;
                    return (int)Double.longBitsToDouble(a);
                }
            }
            return 0;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public double getPixValDouble(byte[] t, int bitpix, int i) {
        try {
            switch (bitpix) {
                case -32: {
                    return Float.intBitsToFloat(this.getInt(t, i << 2));
                }
                case 16: {
                    return t[i *= 2] << 8 | t[i + 1] & 0xFF;
                }
                case 32: {
                    return this.getInt(t, i * 4);
                }
                case 8: {
                    return t[i] & 0xFF;
                }
                case -64: {
                    long a = (long)this.getInt(t, i *= 8) << 32 | (long)this.getInt(t, i + 4) & 0xFFFFFFFFL;
                    return Double.longBitsToDouble(a);
                }
            }
            return 0.0;
        }
        catch (Exception e) {
            return Double.NaN;
        }
    }

    private void setInt(byte[] t, int i, int val) {
        t[i] = (byte)(0xFF & val >>> 24);
        t[i + 1] = (byte)(0xFF & val >>> 16);
        t[i + 2] = (byte)(0xFF & val >>> 8);
        t[i + 3] = (byte)(0xFF & val);
    }

    private int getInt(byte[] t, int i) {
        return t[i] << 24 | (t[i + 1] & 0xFF) << 16 | (t[i + 2] & 0xFF) << 8 | t[i + 3] & 0xFF;
    }

    public static double getMax(int bitpixOrig) {
        return bitpixOrig == -64 ? Double.MAX_VALUE : (bitpixOrig == -32 ? 3.4028234663852886E38 : (bitpixOrig == 64 ? 9.223372036854776E18 : (bitpixOrig == 32 ? 2.147483647E9 : (bitpixOrig == 16 ? 32767.0 : 255.0))));
    }

    public void coadd(Fits a, boolean average) throws Exception {
        int taille = this.widthCell * this.heightCell * this.depthCell;
        if (a.pixels != null && this.pixels != null) {
            double max = Fits.getMax(this.bitpix);
            for (int i = 0; i < taille; ++i) {
                double v1 = this.getPixValDouble(this.pixels, this.bitpix, i);
                double v2 = a.getPixValDouble(a.pixels, a.bitpix, i);
                double v = average ? (this.isBlankPixel(v1) ? v2 : (a.isBlankPixel(v2) ? v1 : (v1 + v2) / 2.0)) : (this.isBlankPixel(v1) ? v2 : (a.isBlankPixel(v2) ? v1 : (v1 / 2.0 + v2 / 2.0 > max / 2.0 ? max : v1 + v2)));
                this.setPixValDouble(this.pixels, this.bitpix, i, v);
            }
        }
        if (a.rgb != null && this.rgb != null) {
            for (int i = 0; i < taille; ++i) {
                int b;
                int g;
                int r;
                if ((a.rgb[i] & 0xFF000000) == 0) continue;
                if ((this.rgb[i] & 0xFF000000) == 0) {
                    this.rgb[i] = a.rgb[i];
                    continue;
                }
                if (average) {
                    r = ((this.rgb[i] >> 16 & 0xFF) + (a.rgb[i] >> 16 & 0xFF)) / 2 << 16;
                    g = ((this.rgb[i] >> 8 & 0xFF) + (a.rgb[i] >> 8 & 0xFF)) / 2 << 8;
                    b = ((this.rgb[i] & 0xFF) + (a.rgb[i] & 0xFF)) / 2;
                } else {
                    r = (this.rgb[i] >> 16 & 0xFF) + (a.rgb[i] >> 16 & 0xFF);
                    g = (this.rgb[i] >> 8 & 0xFF) + (a.rgb[i] >> 8 & 0xFF);
                    b = (this.rgb[i] & 0xFF) + (a.rgb[i] & 0xFF);
                    if (r > 255) {
                        r = 255;
                    }
                    if (g > 255) {
                        g = 255;
                    }
                    if (b > 255) {
                        b = 255;
                    }
                    r <<= 16;
                    g <<= 8;
                }
                this.rgb[i] = 0xFF000000 | r | g | b;
            }
        }
    }

    public void coadd(Fits a, double[] weight1, double[] weight2) throws Exception {
        int i;
        int taille = this.widthCell * this.heightCell * this.depthCell;
        if (a.pixels != null && this.pixels != null) {
            for (i = 0; i < taille; ++i) {
                double v1 = this.getPixValDouble(this.pixels, this.bitpix, i);
                double v2 = a.getPixValDouble(a.pixels, a.bitpix, i);
                double fct1 = weight1[i] / (weight1[i] + weight2[i]);
                double fct2 = weight2[i] / (weight1[i] + weight2[i]);
                int n = i;
                weight1[n] = weight1[n] + weight2[i];
                weight2[i] = 0.0;
                double v = this.isBlankPixel(v1) ? v2 : (a.isBlankPixel(v2) ? v1 : v1 * fct1 + v2 * fct2);
                this.setPixValDouble(this.pixels, this.bitpix, i, v);
            }
        }
        if (a.rgb != null && this.rgb != null) {
            for (i = 0; i < taille; ++i) {
                double fct1 = weight1[i] / (weight1[i] + weight2[i]);
                double fct2 = weight2[i] / (weight1[i] + weight2[i]);
                int n = i;
                weight1[n] = weight1[n] + weight2[i];
                weight2[i] = 0.0;
                if ((a.rgb[i] & 0xFF000000) == 0) continue;
                if ((this.rgb[i] & 0xFF000000) == 0) {
                    this.rgb[i] = a.rgb[i];
                    continue;
                }
                int r = (int)((double)(this.rgb[i] >> 16 & 0xFF) * fct1 + (double)(a.rgb[i] >> 16 & 0xFF) * fct2) << 16;
                int g = (int)((double)(this.rgb[i] >> 8 & 0xFF) * fct1 + (double)(a.rgb[i] >> 8 & 0xFF) * fct2) << 8;
                int b = (int)((double)(this.rgb[i] & 0xFF) * fct1 + (double)(a.rgb[i] & 0xFF) * fct2);
                this.rgb[i] = 0xFF000000 | r | g | b;
            }
        }
    }

    public void mergeOnNaN(Fits a) throws Exception {
        int i;
        int taille = this.widthCell * this.heightCell;
        if (a.pixels != null && this.pixels != null) {
            for (i = 0; i < taille; ++i) {
                double v = this.getPixValDouble(this.pixels, this.bitpix, i);
                boolean vblank = this.isBlankPixel(v);
                double va = a.getPixValDouble(a.pixels, a.bitpix, i);
                boolean vablank = a.isBlankPixel(va);
                if (!vblank || vablank) continue;
                this.setPixValDouble(this.pixels, this.bitpix, i, va);
            }
        }
        if (a.rgb != null && this.rgb != null) {
            for (i = 0; i < taille; ++i) {
                if ((this.rgb[i] & 0xFF000000) != 0 || (a.rgb[i] & 0xFF000000) == 0) continue;
                this.rgb[i] = a.rgb[i];
            }
        }
    }

    public void setFilename(String filename) {
        if (filename == null) {
            this.filename = null;
            return;
        }
        int p = filename.lastIndexOf(91);
        if (p >= 0) {
            filename = filename.substring(0, p);
        }
        this.filename = filename;
    }

    public String getFileNameExtended() {
        return this.getFilename() + this.getCellSuffix();
    }

    public String getFilename() {
        return this.filename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String file, double pixelMin, double pixelMax, byte[] tcm, String format) throws Exception {
        this.createDir(file);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(new File(file));
            this.write(fos, pixelMin, pixelMax, tcm, format);
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
        this.setFilename(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(OutputStream os, double pixelMin, double pixelMax, byte[] tcm, String format) throws Exception {
        byte[] r = new byte[16];
        for (int i = 0; i < r.length; ++i) {
            r[i] = (byte)(i * 16);
        }
        IndexColorModel cm = new IndexColorModel(4, 16, r, r, r);
        byte[] pix8 = this.toPix4(pixelMin, pixelMax, null);
        WritableRaster raster = Raster.createPackedRaster(0, this.width, this.height, 1, 4, null);
        raster.setDataElements(0, 0, this.width, this.height, pix8);
        BufferedImage imgTarget = new BufferedImage(this.width, this.height, 13, cm);
        imgTarget.setData(raster);
        ImageWriter writer = ImageIO.getImageWritersByFormatName(format).next();
        ImageWriteParam iwp = writer.getDefaultWriteParam();
        if (format.equals("jpeg")) {
            iwp.setCompressionMode(2);
            iwp.setCompressionQuality(0.95f);
        }
        ImageOutputStream out = null;
        try {
            out = ImageIO.createImageOutputStream(os);
            writer.setOutput(out);
            writer.write(null, new IIOImage(imgTarget, null, null), iwp);
            writer.dispose();
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public static void main(String[] args) {
        try {
            Fits f = new Fits();
            f.loadFITS("C:\\Users\\Pierre\\Desktop\\Data\\Herschell\\hspire1342239942browse_18217979027709026.fits[2]");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    final class MyImageLoader
    implements ImageConsumer {
        boolean ready = false;
        boolean hasAlpha = true;

        MyImageLoader() {
        }

        @Override
        public void setDimensions(int w, int h) {
            Fits.this.width = w;
            Fits.this.height = h;
            if (Fits.this.widthCell == -1) {
                Fits.this.widthCell = w;
                Fits.this.heightCell = h;
                Fits.this.depthCell = 1;
                Fits.this.zCell = 0;
                Fits.this.yCell = 0;
                Fits.this.xCell = 0;
            }
            Fits.this.rgb = new int[Fits.this.widthCell * Fits.this.heightCell];
        }

        @Override
        public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int off, int scansize) {
            if ((y = Fits.this.height - y - 1) + h < Fits.this.yCell || y >= Fits.this.yCell + Fits.this.heightCell) {
                return;
            }
            for (int j = 0; j < h; ++j) {
                int y1 = j + y;
                int yc = y1 - Fits.this.yCell;
                if (yc < 0 || yc >= Fits.this.heightCell) continue;
                if (this.hasAlpha && w >= Fits.this.widthCell) {
                    int destPos = yc * Fits.this.widthCell + x - Fits.this.xCell;
                    System.arraycopy(pixels, off + scansize * j, Fits.this.rgb, destPos, Fits.this.widthCell);
                    continue;
                }
                for (int i = 0; i < w; ++i) {
                    int x1 = i + x;
                    int xc = x1 - Fits.this.xCell;
                    if (xc < 0 || xc >= Fits.this.widthCell) continue;
                    int pix = pixels[off + scansize * j + i];
                    if (!this.hasAlpha) {
                        pix |= 0xFF000000;
                    }
                    Fits.this.rgb[yc * Fits.this.widthCell + xc] = pix;
                }
            }
        }

        @Override
        public void imageComplete(int status) {
            this.ready = true;
        }

        public boolean ready() {
            return this.ready;
        }

        @Override
        public void setProperties(Hashtable<?, ?> props) {
        }

        @Override
        public void setColorModel(ColorModel model) {
            this.hasAlpha = model.hasAlpha();
        }

        @Override
        public void setHints(int hintflags) {
        }

        @Override
        public void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixel, int off, int scansize) {
            if ((y = Fits.this.height - y - 1) + h < Fits.this.yCell || y >= Fits.this.yCell + Fits.this.heightCell) {
                return;
            }
            for (int j = 0; j < h; ++j) {
                int y1 = j + y;
                int yc = y1 - Fits.this.yCell;
                if (yc < 0 || yc >= Fits.this.heightCell) continue;
                for (int i = 0; i < w; ++i) {
                    int x1 = i + x;
                    int xc = x1 - Fits.this.xCell;
                    if (xc < 0 || xc >= Fits.this.widthCell) continue;
                    int pix = 0xFF & pixel[off + scansize * j + i];
                    pix = pix << 16 | pix << 8 | pix;
                    if (!this.hasAlpha) {
                        pix |= 0xFF000000;
                    }
                    Fits.this.rgb[yc * Fits.this.widthCell + xc] = pix;
                }
            }
        }
    }
}

