/*
 * Decompiled with CFR 0.152.
 */
package cds.astro;

import cds.astro.Coo;
import cds.astro.Coocube;
import java.io.Serializable;
import java.text.ParseException;

public class QboxNumber
implements Serializable {
    public final int level;
    private static final double PIO2 = 1.5707963267948966;
    static final boolean DEBUG = true;
    static final int ANY = Integer.MIN_VALUE;
    static final int BOX = Integer.MAX_VALUE;
    private static final int MAXLEVEL = 12;
    public static int default_level = 9;
    private static final char[] oct = "01234567".toCharArray();
    private static final double DEG = 57.29577951308232;
    static final double[] MAXRAD = new double[]{54.735610317, 30.361193405, 16.403086517, 8.639594386, 4.449359566, 2.259674852, 1.138910823, 0.571763982, 0.286464128, 0.14337822, 0.071725727, 0.035872027, 0.017938306};
    static final double[] SINRAD = new double[]{0.816496580927726, 0.5054494651244236, 0.2823931345695149, 0.1502185901567493, 0.0775779474805375, 0.0394285430318791, 0.0198764347423619, 0.0099789983974146, 0.0049997213877594, 0.0025024194021835, 0.0012518497600656, 6.260849416742E-4, 3.130824920569E-4};
    static final double[] MINRAD = new double[]{45.0, 21.793189128656, 9.612900642866, 4.557754524215, 2.213411995038, 1.089949904684, 0.540737084594, 0.269302913463, 0.134384274203, 0.067125244187, 0.03354588668, 0.016768757962, 0.008383332446};
    private static final boolean[] move_x = new boolean[]{true, false, false, true};
    private static final byte[][] adj_face = new byte[][]{{0, 2, 14, 10, 6, 3, 11, 0}, {0, 12, 4, 1, 13, 9, 5, 0}, {0, 3, 11, 14, 2, 6, 10, 0}, {0, 13, 1, 5, 9, 12, 4, 0}};
    private static final byte[][] adj_move = new byte[][]{{2, 3, 4, 5}, {1, 4, 3, 6}, {5, 0, 7, 2}, {6, 7, 0, 1}};
    private static final byte[] nearby_xy = new byte[]{21, 35, 33, 5, 19, 17, 1, 3};

    public static final int setLevel(int n) {
        int n2 = default_level;
        if (n >= 0 && n <= 12) {
            default_level = n;
        }
        return n2;
    }

    static double dist2(double[] dArray, double[] dArray2) {
        double d = dArray[0] - dArray2[0];
        d *= d;
        double d2 = dArray[1] - dArray2[1];
        d2 *= d2;
        d += d2;
        d2 = dArray[2] - dArray2[2];
        d2 *= d2;
        return d += d2;
    }

    static double dotprod(double[] dArray, double[] dArray2) {
        return dArray[0] * dArray2[0] + dArray[1] * dArray2[1] + dArray[2] * dArray2[2];
    }

    static double norm2(double[] dArray) {
        return QboxNumber.dotprod(dArray, dArray);
    }

    static void vecprod(double[] dArray, double[] dArray2, double[] dArray3) {
        dArray3[0] = dArray[1] * dArray2[2] - dArray[2] * dArray2[1];
        dArray3[1] = dArray[2] * dArray2[0] - dArray[0] * dArray2[2];
        dArray3[2] = dArray[0] * dArray2[1] - dArray[1] * dArray2[0];
    }

    static double det(double[] dArray, double[] dArray2, double[] dArray3) {
        double[] dArray4 = new double[3];
        QboxNumber.vecprod(dArray, dArray2, dArray4);
        return QboxNumber.dotprod(dArray4, dArray3);
    }

    private static final int center_(int n, double[] dArray) {
        int n2 = n & Integer.MAX_VALUE;
        int n3 = 0;
        int n4 = 0;
        if (n2 < 9) {
            dArray[0] = 0.0;
            dArray[1] = 0.0;
            return 0;
        }
        int n5 = 0;
        while ((n2 & 0xFFFFFFF0) != 0) {
            n4 |= (n2 & 1) << n5;
            n3 |= ((n2 >>>= 1) & 1) << n5;
            n2 >>>= 1;
            ++n5;
        }
        double d = 1 << n5;
        dArray[0] = Math.tan((((double)n3 + 0.5) / d - 0.5) * 1.5707963267948966);
        dArray[1] = Math.tan((((double)n4 + 0.5) / d - 0.5) * 1.5707963267948966);
        return n2 & 7;
    }

    static final int corners(int n, double[] dArray) {
        int n2 = n & Integer.MAX_VALUE;
        int n3 = 0;
        int n4 = 0;
        if (n2 == 0) {
            return 0;
        }
        int n5 = 0;
        while ((n2 & 0xFFFFFFF0) != 0) {
            n4 |= (n2 & 1) << n5;
            n3 |= ((n2 >>= 1) & 1) << n5;
            n2 >>= 1;
            ++n5;
        }
        double d = 1 << n5;
        dArray[0] = Math.tan(((double)n3 / d - 0.5) * 1.5707963267948966);
        dArray[1] = Math.tan(((double)n4 / d - 0.5) * 1.5707963267948966);
        dArray[2] = Math.tan(((double)(++n3) / d - 0.5) * 1.5707963267948966);
        dArray[3] = Math.tan(((double)(++n4) / d - 0.5) * 1.5707963267948966);
        return n2 & 7;
    }

    static final int ucorners(int n, double[][] dArray) {
        double[] dArray2 = new double[4];
        int n2 = QboxNumber.corners(n, dArray2);
        if (n2 == 0) {
            return n2;
        }
        Coocube.setUvec(n2, dArray2[0], dArray2[1], dArray[0]);
        Coocube.setUvec(n2, dArray2[2], dArray2[1], dArray[1]);
        Coocube.setUvec(n2, dArray2[2], dArray2[3], dArray[2]);
        Coocube.setUvec(n2, dArray2[0], dArray2[3], dArray[3]);
        return n2;
    }

    static final int level(double d) {
        int n = MINRAD.length;
        double d2 = d / 60.0;
        while (--n > 0) {
            if (!(MINRAD[n] > d2)) continue;
            return n;
        }
        return 0;
    }

    public QboxNumber() {
        this.level = default_level;
    }

    public QboxNumber(int n) {
        this.level = n;
    }

    public QboxNumber(double d) {
        this.level = QboxNumber.level(d);
    }

    public static int qbox(String string) throws ParseException {
        int n;
        char[] cArray = string.toCharArray();
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < cArray.length && cArray[n] == ' '; ++n) {
        }
        if (n >= cArray.length) {
            return n3;
        }
        if (cArray[n] >= '1' && cArray[n] <= '6') {
            n3 = 8 | Character.digit(cArray[n], 8);
        } else {
            ++n2;
        }
        if (++n < cArray.length && (cArray[n] == ':' || cArray[n] == '.')) {
            ++n;
        }
        while (n < cArray.length && cArray[n] >= '0' && cArray[n] < '4') {
            n3 = n3 << 2 | Character.digit(cArray[n], 4);
            ++n;
        }
        if (n < cArray.length && Character.toUpperCase(cArray[n]) == 'A') {
            ++n;
            n3 |= Integer.MIN_VALUE;
        }
        while (n < cArray.length && cArray[n] == ' ') {
            ++n;
        }
        if (n < cArray.length) {
            ++n2;
        }
        if (n2 > 0) {
            throw new ParseException("****QboxNumber: '" + string + "'+" + n, n);
        }
        return n3;
    }

    public static final int level(int n) {
        int n2 = 0;
        if ((n &= Integer.MAX_VALUE) == 0) {
            return -1;
        }
        if ((n & 0x7FFF0000) != 0) {
            n2 = 7;
            n >>>= 14;
        }
        while ((n & 0xFFFFFFF0) != 0) {
            n >>>= 2;
            ++n2;
        }
        return n2;
    }

    public static final int index(int n) {
        int n2 = QboxNumber.level(n);
        int n3 = (n & Integer.MAX_VALUE) - (9 << (n2 << 1));
        if (n3 < 0) {
            n3 += 8;
        }
        return n3;
    }

    public static final int face(int n) {
        int n2 = QboxNumber.level(n);
        if (n2 < 0) {
            return 0;
        }
        return n >>> (n2 << 1) & 7;
    }

    private static final int boxno(int n, int n2, double d, double d2) {
        int n3 = n2;
        n3 |= 8;
        int n4 = 1 << n;
        double d3 = (0.5 + Math.atan(d) / 1.5707963267948966) * (double)n4;
        int n5 = (int)d3;
        d3 = (0.5 + Math.atan(d2) / 1.5707963267948966) * (double)n4;
        int n6 = (int)d3;
        if (n5 >= n4) {
            n5 = n4 - 1;
        }
        if (n6 >= n4) {
            n6 = n4 - 1;
        }
        if (n5 < 0) {
            n5 = 0;
        }
        if (n6 < 0) {
            n6 = 0;
        }
        n3 <<= n << 1;
        n4 >>= 1;
        int n7 = n - 1;
        while (n4 > 0) {
            n3 |= (n5 & n4) << n7 << 1 | (n6 & n4) << n7;
            n4 >>= 1;
            --n7;
        }
        return n3;
    }

    public final int qbox(double d, double d2) {
        double[] dArray = new double[2];
        double[] dArray2 = new double[3];
        Coo.setUvec(d, d2, dArray2);
        int n = Coocube.setXY(dArray2, dArray);
        return QboxNumber.boxno(this.level, n, dArray[0], dArray[1]);
    }

    public final int qbox(Coocube coocube) {
        return QboxNumber.boxno(this.level, coocube.face, coocube.X, coocube.Y);
    }

    public final int qbox(Coo coo) {
        double[] dArray = new double[2];
        double[] dArray2 = new double[]{coo.x, coo.y, coo.z};
        int n = Coocube.setXY(dArray2, dArray);
        return QboxNumber.boxno(this.level, n, dArray[0], dArray[1]);
    }

    public static final Coo center(int n) {
        double[] dArray = new double[3];
        double[] dArray2 = new double[2];
        int n2 = QboxNumber.center_(n, dArray2);
        System.out.println("....center: face=" + n2 + ", XY=" + dArray2[0] + "," + dArray2[1]);
        Coocube.setUvec(n2, dArray2[0], dArray2[1], dArray);
        Coo coo = new Coo(dArray[0], dArray[1], dArray[2]);
        coo.dump("Center");
        return coo;
    }

    public static final void center(int n, Coo coo) {
        double[] dArray = new double[3];
        double[] dArray2 = new double[2];
        int n2 = QboxNumber.center_(n, dArray2);
        Coocube.setUvec(n2, dArray2[0], dArray2[1], dArray);
        coo.set(dArray[0], dArray[1], dArray[2]);
    }

    public final double maxRadius() {
        return MAXRAD[this.level];
    }

    public final double minRadius() {
        return MINRAD[this.level];
    }

    public static final double area(int n) {
        double[] dArray = new double[4];
        QboxNumber.corners(n & Integer.MAX_VALUE, dArray);
        for (int i = 0; i < 4; ++i) {
            int n2 = i;
            dArray[n2] = dArray[n2] / Math.sqrt(1.0 + dArray[i] * dArray[i]);
        }
        double d = Math.asin(dArray[0] * dArray[1]) + Math.asin(dArray[2] * dArray[3]) - Math.asin(dArray[0] * dArray[3]) - Math.asin(dArray[1] * dArray[2]);
        return 3282.806350011744 * Math.abs(d);
    }

    public static final double radius(int n) {
        double[] dArray = new double[4];
        double[] dArray2 = new double[2];
        double d = 0.0;
        QboxNumber.center_(n & Integer.MAX_VALUE, dArray2);
        QboxNumber.corners(n & Integer.MAX_VALUE, dArray);
        double d2 = 1.0 + dArray2[0] * dArray2[0] + dArray2[1] * dArray2[1];
        for (int i = 0; i < 4; ++i) {
            double d3;
            double d4 = dArray[i & 2];
            double d5 = dArray[(i & 1) << 1 | 1];
            double d6 = d2 * (1.0 + d4 * d4 + d5 * d5);
            double d7 = d4 * dArray2[1] - d5 * dArray2[0];
            d7 *= d7;
            if ((d3 = (d7 += (d4 -= dArray2[0]) * d4 + (d5 -= dArray2[1]) * d5) / d6) > d) {
                d = d3;
            }
            System.out.println("....radius(): corner#" + i + "(" + (i & 2) + "," + ((i & 1) << 1 | 1) + ") -- X,Y=" + d4 + "," + d5 + "\n          s2r=" + d3);
        }
        return 57.29577951308232 * Math.asin(Math.sqrt(d));
    }

    public static final int adjacent(int n, int n2) {
        byte by;
        int n3 = 0;
        int n4 = 0;
        int n5 = n;
        int n6 = n2 & 3;
        while ((n5 & 0xFFFFFFF0) != 0) {
            by = adj_move[n6][n5 & 3];
            if ((by & 4) != 0) {
                n3 |= (by ^ 4) << n4;
                n5 >>= 2;
                n4 += 2;
                continue;
            }
            n5 = n5 & 0xFFFFFFFC | by;
            break;
        }
        if ((n5 & 0xFFFFFFF0) == 0) {
            by = adj_face[n6][n5 & 7];
            if ((by & 8) != 0) {
                int n7 = 0;
                for (n5 = n4; n5 > 0; n5 -= 2) {
                    n7 = n7 << 2 | 2;
                }
                if (move_x[n6]) {
                    n7 >>= 1;
                }
                n3 = n & n7 ^ n7;
                n3 = move_x[n6] ? (n3 <<= 1) : (n3 >>= 1);
                if ((n6 & 2) != 0) {
                    n3 |= n7;
                }
            }
            n5 = 8 | by;
        }
        if (n4 > 0) {
            n5 <<= n4;
            n5 |= n3;
        }
        return n5;
    }

    public static final void nearby(int n, int[] nArray) {
        int n2 = 1 << (QboxNumber.level(n) << 1);
        int n3 = 4;
        boolean[] blArray = new boolean[4];
        for (int i = 0; i < 4; ++i) {
            nArray[i] = QboxNumber.adjacent(n, i);
            blArray[i] = (nArray[i] ^ n) < n2;
        }
        nArray[7] = 0;
        nArray[6] = 0;
        nArray[5] = 0;
        nArray[4] = 0;
        if (blArray[0]) {
            nArray[4] = QboxNumber.adjacent(nArray[0], 1);
            nArray[5] = QboxNumber.adjacent(nArray[0], 2);
            n3 += 2;
        }
        if (blArray[3]) {
            nArray[6] = QboxNumber.adjacent(nArray[3], 1);
            nArray[7] = QboxNumber.adjacent(nArray[3], 2);
            n3 += 2;
        }
        if (n3 >= 7) {
            return;
        }
        if (blArray[1]) {
            if (nArray[4] == 0) {
                nArray[4] = QboxNumber.adjacent(nArray[1], 0);
                ++n3;
            }
            if (nArray[7] == 0) {
                nArray[7] = QboxNumber.adjacent(nArray[1], 3);
                ++n3;
            }
        }
        if (n3 >= 7) {
            return;
        }
        if (blArray[2]) {
            if (nArray[5] == 0) {
                nArray[5] = QboxNumber.adjacent(nArray[2], 0);
                ++n3;
            }
            if (nArray[6] == 0) {
                nArray[6] = QboxNumber.adjacent(nArray[2], 3);
                ++n3;
            }
        }
    }

    public final int nearby(Coo coo, int[] nArray, double[] dArray) {
        double d;
        int n;
        int n2;
        int n3;
        int n4 = this.qbox(coo);
        double[] dArray2 = new double[2];
        double[] dArray3 = new double[4];
        double[] dArray4 = new double[3];
        double[] dArray5 = new double[2];
        int n5 = QboxNumber.corners(n4, dArray3);
        int n6 = 9;
        QboxNumber.nearby(n4, nArray);
        dArray4[0] = coo.x;
        dArray4[1] = coo.y;
        dArray4[2] = coo.z;
        Coocube.setXY(dArray4, dArray2);
        for (n3 = 0; n3 < 8; ++n3) {
            if (nArray[n3] == 0) {
                dArray[n3] = 4.0;
                --n6;
                continue;
            }
            n2 = nearby_xy[n3] >> 3;
            n = nearby_xy[n3] & 7;
            dArray5[0] = (n2 & 4) == 0 ? dArray3[n2] : dArray2[n2 ^ 4];
            dArray5[1] = (n & 4) == 0 ? dArray3[n] : dArray2[n ^ 4];
            Coocube.setUvec(n5, dArray5[0], dArray5[1], dArray4);
            double d2 = dArray4[0] - coo.x;
            d = d2 * d2;
            d2 = dArray4[1] - coo.y;
            d += d2 * d2;
            d2 = dArray4[2] - coo.z;
            dArray[n3] = d += d2 * d2;
        }
        for (n2 = 0; n2 < 7; ++n2) {
            for (n = n2 + 1; n < 8; ++n) {
                if (dArray[n2] <= dArray[n]) continue;
                d = dArray[n2];
                dArray[n2] = dArray[n];
                dArray[n] = d;
                n3 = nArray[n2];
                nArray[n2] = nArray[n];
                nArray[n] = n3;
            }
        }
        for (n3 = 8; n3 > 0; --n3) {
            nArray[n3] = nArray[n3 - 1];
            dArray[n3] = dArray[n3 - 1];
        }
        nArray[0] = n4;
        dArray[0] = 0.0;
        return n6;
    }

    public static final String toString(int n) {
        char[] cArray = new char[20];
        int n2 = cArray.length;
        int n3 = n;
        if ((n3 & Integer.MIN_VALUE) != 0) {
            cArray[--n2] = 65;
            n3 &= Integer.MAX_VALUE;
        }
        while ((n3 & 0xFFFFFFF0) != 0) {
            cArray[--n2] = oct[n3 & 3];
            n3 >>>= 2;
        }
        if (n3 != 0) {
            cArray[--n2] = 58;
        }
        cArray[--n2] = oct[n3 & 7];
        return new String(cArray, n2, cArray.length - n2);
    }

    public final String toString() {
        return "[QboxNumber(" + this.level + ")]";
    }
}

