/*
 * Decompiled with CFR 0.152.
 */
package cds.astro;

import cds.astro.Astroframe;
import cds.astro.Astrotime;
import cds.astro.Coo;
import java.text.ParseException;

public class ICRS
extends Astroframe {
    public static String class_name = "ICRS";

    public ICRS(double d) {
        this.precision = (byte)9;
        this.ICRSmatrix = Coo.Umatrix3;
        this.name = class_name;
        this.epoch = d;
        this.hms = true;
        this.ed_lon = (byte)37;
        this.ed_lat = (byte)53;
    }

    public ICRS() {
        this(2000.0);
    }

    public ICRS(String string) throws ParseException {
        this();
        Astrotime astrotime = new Astrotime();
        int n = astrotime.parse(string, 0);
        if (n > 0) {
            this.epoch = astrotime.getJyr();
        }
        while (n < string.length() && Character.isWhitespace(string.charAt(n))) {
            ++n;
        }
        if (n < string.length()) {
            throw new ParseException("****Astroframe: '" + string + "'+" + n, n);
        }
    }

    public double[][] toICRSmatrix() {
        return Coo.Umatrix3;
    }

    public void toICRS(Coo coo) {
    }

    public void fromICRS(Coo coo) {
    }

    public void toICRS(double[] dArray) {
    }

    public void fromICRS(double[] dArray) {
    }
}

