/*
 * Decompiled with CFR 0.152.
 */
package cds.astro;

import cds.astro.Coo;
import cds.astro.Equatorial;

public class FK5
extends Equatorial {
    private void initialize(double d, double d2) {
        this.precision = (byte)7;
        this.equinox = d;
        this.epoch = d2;
        this.name = "FK5(J" + d + ")";
        this.toBaseEquinox = Math.abs(d - 2000.0) > 3.0E-4 ? FK5.precessionMatrix(d, 2000.0) : Coo.Umatrix3;
        this.ICRSmatrix = this.toBaseEquinox;
    }

    public FK5(double d) {
        this.initialize(d, 2000.0);
    }

    public FK5() {
        this.initialize(2000.0, 2000.0);
    }

    static final double[][] precessionMatrix(double d, double d2) {
        boolean bl = false;
        double d3 = (d - 2000.0) / 100.0;
        double d4 = (d2 - d) / 100.0;
        if (Math.abs(d3) > Math.abs(d3 + d4)) {
            bl = true;
            d3 += d4;
            d4 = -d4;
        }
        double d5 = 2306.2181 + (1.39656 - 1.39E-4 * d3) * d3;
        double d6 = (d5 + (0.30188 - 3.44E-4 * d3 + 0.017998 * d4) * d4) * d4 / 3600.0;
        double d7 = (d5 + (1.09468 + 6.6E-5 * d3 + 0.018203 * d4) * d4) * d4 / 3600.0;
        double d8 = (2004.3109 + (-0.8533 - 2.17E-4 * d3) * d3 + (-0.42665 - 2.17E-4 * d3 - 0.041833 * d4) * d4) * d4 / 3600.0;
        if (bl) {
            return Coo.eulerMatrix(-d6, -d8, -d7);
        }
        return Coo.eulerMatrix(d7, d8, d6);
    }

    public double[][] toICRSmatrix() {
        return this.ICRSmatrix;
    }
}

