/*
 * Decompiled with CFR 0.152.
 */
package cds.astro;

import cds.astro.AstroMath;
import cds.astro.Astroframe;
import cds.astro.FK5;

public class Ecliptic
extends Astroframe {
    protected double equinox;
    protected double[][] fromJ2000;

    private static double[][] Jmatrix(double d) {
        double[][] dArray = new double[3][3];
        double d2 = (d - 2000.0) / 100.0;
        double d3 = 84381.448 + (-46.815 + (-5.9E-4 + 0.001813 * d2) * d2) * d2;
        d3 /= 3600.0;
        dArray[0][0] = 1.0;
        dArray[0][1] = 0.0;
        dArray[0][2] = 0.0;
        dArray[1][0] = 0.0;
        dArray[2][0] = 0.0;
        dArray[1][1] = AstroMath.cosd(d3);
        dArray[1][2] = AstroMath.sind(d3);
        dArray[2][1] = -dArray[1][2];
        dArray[2][2] = dArray[1][1];
        if (d != 2000.0) {
            dArray = AstroMath.m3p(dArray, FK5.precessionMatrix(2000.0, d));
        }
        return dArray;
    }

    private final void setJmatrix() {
        this.fromJ2000 = Ecliptic.Jmatrix(this.equinox);
        this.ICRSmatrix = AstroMath.m3t(this.fromJ2000);
    }

    public Ecliptic(double d) {
        this.precision = (byte)8;
        this.equinox = d;
        this.epoch = d;
        this.fromJ2000 = null;
        this.name = "Ecl(J" + d + ")";
    }

    public Ecliptic() {
        this(2000.0);
    }

    public double[][] toICRSmatrix() {
        if (this.ICRSmatrix == null) {
            this.setJmatrix();
        }
        return this.ICRSmatrix;
    }

    public double getEquinox() {
        return this.equinox;
    }
}

