/*
 * Decompiled with CFR 0.152.
 */
package cds.astro;

import cds.astro.Unit;
import java.text.ParseException;

public class Converter {
    public Unit source;
    public Unit target;
    public double factor;
    static char SEP = (char)10238;

    public Converter(String string, String string2) {
        try {
            this.source = new Unit(string);
        }
        catch (Exception exception) {
            System.err.println(exception);
            this.source = null;
        }
        try {
            this.target = new Unit(string2);
        }
        catch (Exception exception) {
            System.err.println(exception);
            this.target = null;
        }
        this.source.setUnit();
        this.target.setUnit();
        this.factor = this.source.factor / this.target.factor;
    }

    public Converter(String string, String string2, double d) {
        try {
            this.source = new Unit(string);
            this.source.setUnit();
        }
        catch (Exception exception) {
            System.err.println(exception);
            this.source = null;
        }
        try {
            this.target = new Unit(string2);
            this.target.setUnit();
        }
        catch (Exception exception) {
            System.err.println(exception);
            this.target = null;
        }
        this.factor = d;
        Unit.registerConverter(string, string2, this);
    }

    public void dump(String string) {
        System.out.println(string + "(factor=" + this.factor + ")");
        this.source.dump("source_unit ");
        this.target.dump("target_unit ");
    }

    public double convert(double d) throws ArithmeticException {
        this.source.setValue(d);
        if (this.factor == this.factor) {
            this.target.setValue(d * this.factor);
        } else {
            Unit.convert(this.source, this.target);
        }
        return this.target.value;
    }

    public double convert(String string) throws ParseException, ArithmeticException {
        this.source.setValue(string);
        if (this.factor == this.factor) {
            this.target.setValue(this.source.value * this.factor);
        } else {
            Unit.convert(this.source, this.target);
        }
        return this.target.value;
    }

    public String transform(String string) throws ParseException, ArithmeticException {
        this.source.setValue(string);
        if (this.factor == this.factor) {
            this.target.setValue(this.source.value * this.factor);
        } else {
            Unit.convert(this.source, this.target);
        }
        return this.target.editedValue();
    }

    public String transform(double d) throws ArithmeticException {
        this.source.setValue(d);
        if (this.factor == this.factor) {
            this.target.setValue(d * this.factor);
        } else {
            Unit.convert(this.source, this.target);
        }
        return this.target.editedValue();
    }

    public String toString() {
        return this.source.symbol + "=>" + this.target.symbol + "(x" + this.factor + ")";
    }
}

