/*
 * Decompiled with CFR 0.152.
 */
package cds.astro;

import cds.astro.AstroMath;
import cds.astro.Astrocoo;
import cds.astro.Astroframe;
import cds.astro.Coo;
import cds.astro.FK4;
import cds.astro.ICRS;
import cds.astro.Parsing;
import java.io.Serializable;
import java.text.ParseException;

public class Astropos
extends Astrocoo
implements Serializable {
    private static boolean DEBUG = false;
    protected double xd;
    protected double yd;
    protected double zd;
    private double[][] R;
    protected double epocho;
    public double plx;
    public double rv;
    public double e_plx;
    public double e_rv;
    private byte permanent;
    private byte specified;
    private boolean ready;
    private static String[] partnames = new String[]{"plx", "rv", "pm", "meanEp", "cov.pos", "cov.pm", "cov.from.prec", "epoch"};
    protected double[][] cov;
    private static double[] def_err = new double[]{6.48E8, 7560000.0, 756000.0, 126000.0, 12600.0, 2100.0, 210.0, 21.0, 2.1, 0.21000000000000002, 0.021, 0.0021000000000000003};

    private static final void tr3(double[][] dArray) {
        double d = dArray[0][1];
        dArray[0][1] = dArray[1][0];
        dArray[1][0] = d;
        d = dArray[0][2];
        dArray[0][2] = dArray[2][0];
        dArray[2][0] = d;
        d = dArray[1][2];
        dArray[1][2] = dArray[2][1];
        dArray[2][1] = d;
    }

    private final void rot2local(double[] dArray, double[] dArray2) {
        dArray2[0] = this.R[0][0] * dArray[0] + this.R[0][1] * dArray[1] + this.R[0][2] * dArray[2];
        dArray2[1] = this.R[1][0] * dArray[0] + this.R[1][1] * dArray[1];
        dArray2[2] = this.R[2][0] * dArray[0] + this.R[2][1] * dArray[1] + this.R[2][2] * dArray[2];
    }

    private final void rot2fixed(double[] dArray, double[] dArray2) {
        dArray2[0] = this.R[0][0] * dArray[0] + this.R[1][0] * dArray[1] + this.R[2][0] * dArray[2];
        dArray2[1] = this.R[0][1] * dArray[0] + this.R[1][1] * dArray[1] + this.R[2][1] * dArray[2];
        dArray2[2] = this.R[0][2] * dArray[0] + this.R[2][2] * dArray[2];
    }

    private final void rot3(double[][] dArray, double[] dArray2) {
        double d = dArray2[0];
        double d2 = dArray2[1];
        double d3 = dArray2[2];
        for (int i = 0; i < 3; ++i) {
            dArray2[i] = dArray[i][0] * d + dArray[i][1] * d2 + dArray[i][2] * d3;
        }
    }

    private static final void rotate_cov(double[][] dArray, double[][] dArray2) {
        int n;
        int n2;
        double d;
        int n3;
        int n4;
        if (dArray2 == null) {
            return;
        }
        double[][] dArray3 = new double[3][3];
        for (n4 = 0; n4 < 3; ++n4) {
            for (n3 = 0; n3 < 3; ++n3) {
                dArray3[n4][n3] = dArray2[n4][n3];
            }
        }
        for (n4 = 0; n4 < 3; ++n4) {
            for (n3 = 0; n3 < 3; ++n3) {
                d = 0.0;
                for (n2 = 0; n2 < 3; ++n2) {
                    for (n = 0; n < 3; ++n) {
                        d += dArray[n4][n2] * dArray[n3][n] * dArray3[n2][n];
                    }
                }
                dArray2[n4][n3] = d;
            }
        }
        if (dArray2[0].length == 3) {
            return;
        }
        for (n4 = 0; n4 < 3; ++n4) {
            for (n3 = 0; n3 < 3; ++n3) {
                dArray3[n4][n3] = dArray2[n4 + 3][n3 + 3];
            }
        }
        for (n4 = 0; n4 < 3; ++n4) {
            for (n3 = 0; n3 < 3; ++n3) {
                d = 0.0;
                for (n2 = 0; n2 < 3; ++n2) {
                    for (n = 0; n < 3; ++n) {
                        d += dArray[n4][n2] * dArray[n3][n] * dArray3[n2][n];
                    }
                }
                dArray2[n4 + 3][n3 + 3] = d;
            }
        }
        n2 = 0;
        for (n4 = 0; n4 < 3; ++n4) {
            for (n3 = 0; n3 < 3; ++n3) {
                dArray3[n4][n3] = dArray2[n4][n3 + 3];
                if (dArray3[n4][n3] == 0.0) continue;
                ++n2;
            }
        }
        if (n2 != 0) {
            for (n4 = 0; n4 < 3; ++n4) {
                for (n3 = 0; n3 < 3; ++n3) {
                    d = 0.0;
                    for (n2 = 0; n2 < 3; ++n2) {
                        for (n = 0; n < 3; ++n) {
                            d += dArray[n4][n2] * dArray[n3][n] * dArray3[n2][n];
                        }
                    }
                    double d2 = d;
                    dArray2[n4 + 3][n3] = d2;
                    dArray2[n4][n3 + 3] = d2;
                }
            }
        }
    }

    private final double getVar(int n, int n2) {
        if (this.cov == null || this.R == null) {
            return Double.NaN;
        }
        int n3 = 3 * (n / 3);
        int n4 = 3 * (n2 / 3);
        int n5 = n % 3;
        int n6 = n2 % 3;
        double d = 0.0;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                d += this.R[n5][i] * this.R[n6][j] * this.cov[n3 + i][n4 + j];
            }
        }
        return d;
    }

    private static final void propagate_error(double[][] dArray, double d) {
        int n;
        int n2;
        for (n2 = 0; n2 < 3; ++n2) {
            for (n = 0; n < 6; ++n) {
                double[] dArray2 = dArray[n];
                int n3 = n2;
                dArray2[n3] = dArray2[n3] + d * dArray[n][n2 + 3];
            }
        }
        for (n = 0; n < 3; ++n) {
            for (n2 = 0; n2 < 6; ++n2) {
                double[] dArray3 = dArray[n];
                int n4 = n2;
                dArray3[n4] = dArray3[n4] + d * dArray[n + 3][n2];
            }
        }
    }

    private static final void rot6(double[][] dArray, double[] dArray2, double[] dArray3) {
        for (int i = 0; i < 3; ++i) {
            dArray3[i] = dArray[i][0] * dArray2[0] + dArray[i][1] * dArray2[1] + dArray[i][2] * dArray2[2];
            dArray3[i + 3] = dArray[i][0] * dArray2[3] + dArray[i][1] * dArray2[4] + dArray[i][2] * dArray2[5];
        }
    }

    public double normalize() {
        double d = this.x * this.x + this.y * this.y + this.z * this.z;
        if (d <= 0.0) {
            return d;
        }
        if (d == 1.0) {
            return d;
        }
        if (this.cov != null) {
            for (int i = 0; i < 6; ++i) {
                int n = 0;
                while (n < 6) {
                    double[] dArray = this.cov[i];
                    int n2 = n++;
                    dArray[n2] = dArray[n2] / d;
                }
            }
        }
        d = Math.sqrt(d);
        this.x /= d;
        this.y /= d;
        this.z /= d;
        this.xd /= d;
        this.yd /= d;
        this.zd /= d;
        this.plx /= d;
        this.e_plx /= d;
        if (this.R != null) {
            double[] dArray = this.R[0];
            dArray[0] = dArray[0] / d;
            double[] dArray2 = this.R[0];
            dArray2[1] = dArray2[1] / d;
            double[] dArray3 = this.R[0];
            dArray3[2] = dArray3[2] / d;
            double[] dArray4 = this.R[2];
            dArray4[0] = dArray4[0] / d;
            double[] dArray5 = this.R[2];
            dArray5[1] = dArray5[1] / d;
            double[] dArray6 = this.R[2];
            dArray6[2] = dArray6[2] / d;
        }
        return d;
    }

    public final void rotate(double[][] dArray) {
        double[] dArray2 = new double[3];
        super.rotate(dArray);
        dArray2[0] = this.xd;
        dArray2[1] = this.yd;
        dArray2[2] = this.zd;
        this.xd = dArray[0][0] * dArray2[0] + dArray[0][1] * dArray2[1] + dArray[0][2] * dArray2[2];
        this.yd = dArray[1][0] * dArray2[0] + dArray[1][1] * dArray2[1] + dArray[1][2] * dArray2[2];
        this.zd = dArray[2][0] * dArray2[0] + dArray[2][1] * dArray2[1] + dArray[2][2] * dArray2[2];
        if (this.cov != null) {
            Astropos.rotate_cov(dArray, this.cov);
        }
    }

    public static final void varianceToErrorEllipse(double[] dArray, double[] dArray2) {
        double d = (dArray[0] - dArray[1]) / 2.0;
        double d2 = Math.sqrt(d * d + dArray[2] * dArray[2]);
        d = (dArray[0] + dArray[1]) / 2.0;
        double d3 = d + d2;
        double d4 = d - d2;
        dArray2[0] = Math.sqrt(d3);
        dArray2[1] = Math.sqrt(d4);
        dArray2[2] = dArray[2] == 0.0 ? (dArray[0] <= dArray[1] ? 0.0 : 90.0) : AstroMath.atand((d3 - dArray[1]) / dArray[2]);
        if (dArray2[2] < 0.0) {
            dArray2[2] = dArray2[2] + 180.0;
        }
    }

    public static final void errorEllipseToVariance(double[] dArray, double[] dArray2) {
        double d = dArray[0] * dArray[0];
        double d2 = dArray[1] * dArray[1];
        double d3 = AstroMath.cosd(dArray[2]);
        double d4 = AstroMath.sind(dArray[2]);
        dArray2[0] = d * d4 * d4 + d2 * d3 * d3;
        dArray2[1] = d * d3 * d3 + d2 * d4 * d4;
        dArray2[2] = d3 * d4 * (d - d2);
    }

    public static boolean parseErrorEllipse(Parsing parsing, double[] dArray) {
        int n = parsing.pos;
        dArray[1] = Double.NaN;
        dArray[0] = Double.NaN;
        dArray[2] = 90.0;
        parsing.gobbleSpaces();
        int n2 = parsing.parseArray(dArray);
        if (n2 == 0) {
            return false;
        }
        if (Double.isNaN(dArray[2])) {
            dArray[2] = 90.0;
        }
        if (Double.isNaN(dArray[1])) {
            dArray[1] = dArray[0];
        }
        return true;
    }

    private final void pru6(String string) {
        double[] dArray = new double[3];
        String string2 = "                                           ";
        dArray[0] = this.x;
        dArray[1] = this.y;
        dArray[2] = this.z;
        System.out.println(Coo.toString(string, dArray));
        dArray[0] = this.xd;
        dArray[1] = this.yd;
        dArray[2] = this.zd;
        System.out.println(Coo.toString(string2.substring(0, string.length()), dArray));
    }

    private static final void pr_cov(String string, double[][] dArray) {
        StringBuffer stringBuffer = new StringBuffer(256);
        int n = string.length();
        stringBuffer.append(string);
        for (int i = 0; i < 6; ++i) {
            int n2;
            for (n2 = 0; n2 < 6; ++n2) {
                ed.editDouble(stringBuffer, dArray[i][n2], 4, 3, 0);
                stringBuffer.append(' ');
            }
            System.out.println(stringBuffer.toString());
            stringBuffer.setLength(n);
            if (i != 0) continue;
            stringBuffer.setLength(0);
            for (n2 = 0; n2 < n; ++n2) {
                stringBuffer.append(' ');
            }
        }
    }

    private final void compute() {
        int n;
        int n2;
        double[] dArray = null;
        double[] dArray2 = new double[3];
        if (this.ready) {
            return;
        }
        if (DEBUG) {
            this.dump("<<compute: ");
        }
        if (((this.specified | this.permanent) & 0x80) == 0) {
            this.epoch = this.frame.epoch;
        }
        if (((this.specified | this.permanent) & 8) == 0) {
            this.epocho = this.epoch;
        }
        if (((this.specified | this.permanent) & 1) == 0) {
            this.plx = 0.0;
            this.e_plx = 0.0;
        }
        if (Double.isNaN(this.e_plx)) {
            this.e_plx = this.plx;
            if (this.e_plx < 5.0) {
                this.e_plx = 5.0;
            }
        }
        if (((this.specified | this.permanent) & 2) == 0) {
            this.rv = 0.0;
            this.e_rv = 0.0;
        }
        if (Double.isNaN(this.e_rv)) {
            this.e_rv = Math.abs(this.rv) / 2.0;
            if (this.e_rv > 300.0) {
                this.e_rv = 300.0;
            }
            if (this.e_rv < 10.0) {
                this.e_rv = 10.0;
            }
        }
        if (((this.specified | this.permanent) & 4) == 0) {
            if (this.frame instanceof FK4) {
                if (dArray == null) {
                    dArray = new double[6];
                }
                dArray[0] = this.x;
                dArray[1] = this.y;
                dArray[2] = this.z;
                FK4.estimateFK4motion(dArray);
                this.xd = dArray[3];
                this.yd = dArray[4];
                this.zd = dArray[5];
            } else {
                this.zd = 0.0;
                this.yd = 0.0;
                this.xd = 0.0;
            }
            if (this.cov != null) {
                for (n2 = 3; n2 < 6; ++n2) {
                    for (n = 3; n < 6; ++n) {
                        this.cov[n2][n] = 0.0;
                    }
                }
            }
        }
        double d = this.xd * this.xd + this.yd * this.yd + this.zd * this.zd;
        if (((this.specified | this.permanent) & 3) == 3) {
            double d2 = this.plx * this.rv / 4.740470446 / 2.0626480624709636E8;
            if (this.cov != null) {
                this.cov[3][3] = this.e_plx * this.e_rv / 4.740470446;
            }
            if (d2 * d2 >= 0.5 * d) {
                d2 = 0.0;
                if (this.cov != null) {
                    double[] dArray3 = this.cov[3];
                    dArray3[3] = dArray3[3] + d2 * d2;
                }
            } else {
                this.xd += this.x * d2;
                this.yd += this.y * d2;
                this.zd += this.z * d2;
            }
        }
        if (DEBUG) {
            this.pru6("   u+du(1) ");
        }
        if ((this.specified & 0x50) == 0 && this.dlon > 0 && this.dlat > 0 && (this.permanent & 0x10) == 0) {
            n2 = this.dlon;
            if (n2 >= def_err.length) {
                n2 = def_err.length - 1;
            }
            if ((n = (int)this.dlat) >= def_err.length) {
                n = def_err.length - 1;
            }
            this.setErrorEllipse(def_err[n2], def_err[n], 90.0, Double.NaN);
            this.specified = (byte)(this.specified ^ 0x50);
        }
        if ((this.specified & 0x20) == 0) {
            // empty if block
        }
        if (this.epoch != this.epocho) {
            if (DEBUG) {
                Astropos.pr_cov("   cov6(0) ", this.cov);
            }
            Astropos.propagate_error(this.cov, this.epoch - this.epocho);
            if (DEBUG) {
                Astropos.pr_cov("   cov6(t) ", this.cov);
            }
        }
        if (this.R != null) {
            Astropos.tr3(this.R);
            Astropos.rotate_cov(this.R, this.cov);
            Astropos.tr3(this.R);
        }
        if (DEBUG) {
            this.dump(" >compute: ");
        }
        this.ready = true;
    }

    public Astropos() {
        super(new ICRS());
        this.cov = null;
        this.permanent = 0;
        this.epocho = Double.NaN;
        this.reset();
    }

    public Astropos(Astroframe astroframe) {
        super(astroframe);
        this.cov = null;
        this.permanent = 0;
        this.epocho = Double.NaN;
        this.reset();
    }

    public Astropos(Astroframe astroframe, double d, double d2) {
        super(astroframe);
        this.cov = null;
        this.permanent = 0;
        this.epocho = Double.NaN;
        this.reset();
        this.set(d, d2);
    }

    public Astropos(Astroframe astroframe, double d, double d2, double d3, double d4, double d5) {
        super(astroframe);
        this.set(d, d2, d3, null, d4, d5, d3, null, null, null);
    }

    public Astropos(Astrocoo astrocoo) {
        this.set(astrocoo);
    }

    public Astropos(Astroframe astroframe, String string) throws ParseException {
        super(astroframe);
        this.epocho = Double.NaN;
        this.set(string);
    }

    public Astropos(String string) throws ParseException {
        Parsing parsing = new Parsing(string);
        char c = parsing.currentChar();
        if (Astroframe.isIAU(c) && string.indexOf(32) < 0 && string.indexOf(58) < 0) {
            this.frame = Astroframe.create(c);
            if (super.parseIAU(parsing)) {
                parsing.gobbleSpaces();
                if (parsing.pos >= parsing.length) {
                    return;
                }
            }
            this.frame = null;
        }
        this.frame = Astroframe.parse(parsing);
        if (this.frame == null) {
            throw new ParseException("****Astropos: argument '" + string + "' (no frame)", parsing.pos);
        }
        this.epocho = Double.NaN;
        this.set(parsing.toString());
    }

    public Object clone() {
        Astropos astropos = (Astropos)super.clone();
        return astropos;
    }

    public Astropos(Astroframe astroframe, double d, double d2, double d3, double[] dArray, double d4, double d5, double d6, double[] dArray2, double[] dArray3, double[] dArray4) {
        super(astroframe);
        this.set(d, d2, d3, dArray, d4, d5, d6, dArray2, dArray3, dArray4);
    }

    public void dump(String string) {
        int n;
        StringBuffer stringBuffer = new StringBuffer(256);
        int n2 = n = string.length();
        while (--n2 >= 0) {
            stringBuffer.append(' ');
        }
        String string2 = stringBuffer.toString();
        stringBuffer.setLength(0);
        super.dump(string);
        stringBuffer.setLength(0);
        stringBuffer.append(string2);
        ed.editDecimal(stringBuffer, this.xd, 2, 15, 16);
        stringBuffer.append(' ');
        ed.editDecimal(stringBuffer, this.yd, 2, 15, 16);
        stringBuffer.append(' ');
        ed.editDecimal(stringBuffer, this.zd, 2, 15, 16);
        stringBuffer.append(' ');
        stringBuffer.append("(dot)");
        if ((this.specified & 4) == 0) {
            stringBuffer.append("::");
        }
        System.out.println(stringBuffer.toString());
        stringBuffer.setLength(n);
        System.out.println(Coo.toString(stringBuffer.toString(), this.R));
        stringBuffer.setLength(n);
        stringBuffer.append("    Epoch=J");
        stringBuffer.append(this.epoch);
        n2 = n + 20;
        while (stringBuffer.length() < n2) {
            stringBuffer.append(" ");
        }
        stringBuffer.append("specified=0x");
        stringBuffer.append(Integer.toHexString(this.specified & 0xFF));
        stringBuffer.append('(');
        ed.editFlags(stringBuffer, this.specified, partnames);
        stringBuffer.append(')');
        System.out.println(stringBuffer);
        stringBuffer.setLength(n);
        stringBuffer.append("MeanEpoch=J");
        stringBuffer.append(this.epocho);
        n2 = n + 20;
        while (stringBuffer.length() < n2) {
            stringBuffer.append(" ");
        }
        stringBuffer.append("permanent=0x");
        stringBuffer.append(Integer.toHexString(this.permanent & 0xFF));
        stringBuffer.append('(');
        ed.editFlags(stringBuffer, this.permanent, partnames);
        stringBuffer.append(')');
        System.out.println(stringBuffer);
        stringBuffer.setLength(n);
        stringBuffer.append("pm(mas/yr) ");
        ed.editDecimal(stringBuffer, this.getProperMotionLon(), 6, 5, 16);
        stringBuffer.append(" ");
        ed.editDecimal(stringBuffer, this.getProperMotionLat(), 6, 5, 16);
        stringBuffer.append(" ");
        ed.editDecimal(stringBuffer, this.plx, 4, 5, 0);
        stringBuffer.append("mas");
        ed.editDecimal(stringBuffer, this.rv, 6, 5, 16);
        stringBuffer.append("km/s");
        System.out.println(stringBuffer.toString());
        stringBuffer.setLength(n);
        stringBuffer.append("----6x6 Covariance Matrix ");
        if (this.cov == null) {
            stringBuffer.append("(NULL) [");
            if (!this.ready) {
                stringBuffer.append("NOT ");
            }
            stringBuffer.append("ready]");
            System.out.println(stringBuffer.toString());
        } else {
            stringBuffer.append("(mas , yr) [");
            if (!this.ready) {
                stringBuffer.append("NOT ");
            }
            stringBuffer.append("ready]");
            System.out.println(stringBuffer.toString());
            stringBuffer.setLength(n);
            Astropos.pr_cov(stringBuffer.toString(), this.cov);
        }
    }

    private static final double[] dup(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = dArray[i];
        }
        return dArray2;
    }

    public boolean parsing(Parsing parsing) {
        double d;
        double d2;
        double d3;
        double[] dArray = new double[3];
        double[] dArray2 = new double[2];
        double[] dArray3 = null;
        double[] dArray4 = null;
        double[] dArray5 = null;
        double[] dArray6 = null;
        int n = parsing.pos;
        if (DEBUG) {
            System.out.println("....Parsing(0): " + parsing);
        }
        this.reset();
        if (!super.parsing(parsing)) {
            return false;
        }
        this.ready = false;
        double d4 = this.epocho;
        double d5 = this.epoch;
        if (DEBUG) {
            System.out.println("....astrocoo => " + super.toString());
        }
        if (DEBUG) {
            System.out.println("....Parsing(1): " + parsing);
        }
        parsing.gobbleSpaces();
        boolean bl = parsing.match("[");
        if (bl) {
            parsing.gobbleSpaces();
            if (Astropos.parseErrorEllipse(parsing, dArray)) {
                dArray3 = Astropos.dup(dArray);
                parsing.gobbleSpaces();
                d3 = Astropos.getEpoch(parsing);
                if (!Double.isNaN(d3)) {
                    d4 = d3;
                }
            }
            parsing.gobbleSpaces();
            if (!parsing.match("]")) {
                parsing.set(n);
                return false;
            }
        }
        if (DEBUG) {
            System.out.println("....Parsing(2): " + parsing);
        }
        if (DEBUG) {
            System.out.println("           epo= " + d4);
        }
        parsing.gobbleSpaces();
        d3 = Astropos.getEpoch(parsing);
        if (!Double.isNaN(d3)) {
            if (Double.isNaN(d5)) {
                d5 = d3;
            } else {
                d4 = d3;
            }
        }
        parsing.gobbleSpaces();
        if (Double.isNaN(d4) && parsing.currentChar() == '[') {
            n = parsing.pos;
            parsing.match('[');
            d3 = Astropos.getEpoch(parsing);
            if (Double.isNaN(d3)) {
                parsing.set(n);
            } else if (parsing.match(']')) {
                d4 = d3;
            } else {
                parsing.set(n);
            }
        }
        if (DEBUG) {
            System.out.println("....Parsing(3): " + parsing);
        }
        if (DEBUG) {
            System.out.println("           epo= " + d4);
        }
        int n2 = parsing.pos;
        parsing.gobbleSpaces();
        int n3 = parsing.parseArray(dArray2);
        if (n3 == 2) {
            d2 = dArray2[0];
            d = dArray2[1];
        } else {
            d = Double.NaN;
            d2 = Double.NaN;
            parsing.set(n2);
        }
        if (DEBUG) {
            System.out.println("....Parsing(4): " + parsing);
        }
        if (Double.isNaN(d4) && parsing.pos < parsing.length) {
            d4 = Astropos.getEpoch(parsing);
        }
        if (DEBUG) {
            System.out.println("           epo= " + d4);
        }
        n2 = parsing.pos;
        parsing.gobbleSpaces();
        bl = parsing.match("[");
        if (bl) {
            parsing.gobbleSpaces();
            if (Astropos.parseErrorEllipse(parsing, dArray)) {
                dArray4 = Astropos.dup(dArray);
            }
            if (!parsing.match("]")) {
                parsing.set(n);
                return false;
            }
        }
        if (Double.isNaN(d4) && parsing.pos < parsing.length) {
            d4 = Astropos.getEpoch(parsing);
        }
        if (DEBUG) {
            System.out.println("....Parsing(5): " + parsing);
        }
        if (DEBUG) {
            System.out.println("           epo= " + d4);
        }
        if ((n3 = parsing.parseWithError(dArray2)) > 0) {
            parsing.gobbleSpaces();
            if (parsing.match("km/s")) {
                dArray5 = dArray6;
                dArray6 = Astropos.dup(dArray2);
            } else {
                dArray5 = Astropos.dup(dArray2);
                parsing.match("mas");
            }
        }
        if (DEBUG) {
            System.out.println("....Parsing(p): " + parsing);
        }
        if (DEBUG) {
            System.out.println("           epo= " + d4);
        }
        if ((n3 = parsing.parseWithError(dArray2)) > 0) {
            parsing.gobbleSpaces();
            if (parsing.match("mas")) {
                dArray5 = Astropos.dup(dArray2);
            } else {
                dArray6 = Astropos.dup(dArray2);
                parsing.match("km/s");
            }
        }
        if (DEBUG) {
            System.out.println("....Parsing(V): " + parsing);
        }
        if (DEBUG) {
            System.out.println("           epo= " + d4);
        }
        this.set(this.lon, this.lat, d5, dArray3, d2, d, d4, dArray4, dArray5, dArray6);
        return true;
    }

    public int parse(String string, int n) {
        Parsing parsing = new Parsing(string, n);
        if (this.parsing(parsing)) {
            return parsing.pos;
        }
        return n;
    }

    private final void reset() {
        this.specified = 0;
        this.zd = 0.0;
        this.yd = 0.0;
        this.xd = 0.0;
        this.ready = false;
    }

    public void set() {
        super.set();
        this.reset();
    }

    public void set(Coo coo) {
        this.reset();
        super.set(coo);
        if (this.R == null) {
            this.R = super.localMatrix();
        } else {
            super.localMatrix(this.R);
        }
        this.ready = false;
    }

    public void set(Astrocoo astrocoo) {
        this.reset();
        super.set(astrocoo);
        if (this.R == null) {
            this.R = super.localMatrix();
        } else {
            super.localMatrix(this.R);
        }
        this.ready = false;
    }

    public void set(Coo coo, double d) {
        this.reset();
        super.set(coo, d);
        if (this.R == null) {
            this.R = super.localMatrix();
        } else {
            super.localMatrix(this.R);
        }
        this.ready = false;
    }

    public void set(double d, double d2) {
        this.reset();
        super.set(d, d2);
        if (this.R == null) {
            this.R = super.localMatrix();
        } else {
            super.localMatrix(this.R);
        }
        this.ready = false;
    }

    public void set(double d, double d2, double d3) {
        this.set(d, d2);
        if (Double.isNaN(d3)) {
            return;
        }
        this.specified = (byte)(this.specified | 0x80);
        this.epoch = d3;
    }

    public void set(double d, double d2, double d3, double d4, double d5) {
        this.set(d, d2, d3);
        if (!Double.isNaN(d4) && !Double.isNaN(d5)) {
            this.setProperMotion(d4, d5);
        }
        if (this.R == null) {
            this.R = super.localMatrix();
        } else {
            super.localMatrix(this.R);
        }
        this.ready = false;
    }

    public void set(double d, double d2, double d3, double[] dArray, double d4, double d5, double d6, double[] dArray2, double[] dArray3, double[] dArray4) {
        this.set(d, d2, d3, d4, d5);
        this.setProperMotion(d4, d5);
        if (dArray != null) {
            this.setErrorEllipse(dArray[0], dArray[1], dArray[2], d6);
        }
        if (dArray2 != null) {
            this.setErrorProperMotion(dArray2[0], dArray2[1], dArray2[2]);
        }
        if (dArray3 != null) {
            this.setParallax(dArray3[0], dArray3[1]);
        }
        if (dArray4 != null) {
            this.setRadialVelocity(dArray4[0], dArray4[1]);
        }
    }

    public void set(String string) throws ParseException {
        Parsing parsing = new Parsing(string);
        this.reset();
        if (this.parsing(parsing)) {
            parsing.gobbleSpaces();
        }
        if (parsing.pos != parsing.length) {
            throw new ParseException("****Astropos: argument '" + string + "'+" + parsing.pos, parsing.pos);
        }
    }

    public void set(String string, boolean bl) throws ParseException {
        this.set(string);
    }

    public void setFrameEpoch() {
        if (!Double.isNaN(this.epoch)) {
            this.frame.setFrameEpoch(this.epoch);
        }
    }

    public void setDefaultMeanEpoch(double d) {
        this.epocho = d;
        this.permanent = Double.isNaN(d) ? (byte)(this.permanent & 0xFFFFFFF7) : (byte)(this.permanent | 8);
    }

    public boolean setEpoch(double d) {
        if (this.ready) {
            return false;
        }
        this.specified = Double.isNaN(d) ? (byte)(this.specified & 0xFFFFFF7F) : (byte)(this.specified | 0x80);
        this.epoch = d;
        return true;
    }

    public boolean setErrorEllipse(double d, double d2, double d3) {
        return this.setErrorEllipse(d, d2, d3, Double.NaN);
    }

    public boolean setErrorEllipse(double d, double d2, double d3, double d4) {
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        if (this.ready) {
            return false;
        }
        if (!Double.isNaN(d4)) {
            this.epocho = d4;
            this.specified = (byte)(this.specified | 8);
        }
        dArray[0] = d;
        dArray[1] = d2;
        dArray[2] = d3;
        Astropos.errorEllipseToVariance(dArray, dArray2);
        if (this.cov == null) {
            this.cov = new double[6][6];
        }
        for (int i = 0; i < 3; ++i) {
            for (int j = i; j < 6; ++j) {
                this.cov[j][i] = 0.0;
                this.cov[i][j] = 0.0;
            }
        }
        this.cov[1][1] = dArray2[0];
        this.cov[2][2] = dArray2[1];
        double d5 = dArray2[2];
        this.cov[1][2] = d5;
        this.cov[2][1] = d5;
        this.specified = (byte)(this.specified | 0x10);
        return true;
    }

    public boolean setProperMotion(double d, double d2) {
        if (this.ready) {
            return false;
        }
        if (Double.isNaN(d) || Double.isNaN(d2)) {
            this.specified = (byte)(this.specified & 0xFFFFFFFB);
            return true;
        }
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        dArray[0] = 0.0;
        dArray[1] = d / 2.0626480624709636E8;
        dArray[2] = d2 / 2.0626480624709636E8;
        this.rot2fixed(dArray, dArray2);
        this.xd = dArray2[0];
        this.yd = dArray2[1];
        this.zd = dArray2[2];
        this.specified = (byte)(this.specified | 4);
        return true;
    }

    public boolean setErrorProperMotion(double d, double d2) {
        return this.setErrorProperMotion(d, d2, 90.0);
    }

    public boolean setErrorProperMotion(double d, double d2, double d3) {
        if (this.ready) {
            return false;
        }
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        dArray[0] = d;
        dArray[1] = d2;
        dArray[2] = d3;
        Astropos.errorEllipseToVariance(dArray, dArray2);
        if (this.cov == null) {
            this.cov = new double[6][6];
        }
        this.cov[4][4] = dArray2[0];
        this.cov[5][5] = dArray2[1];
        double d4 = dArray2[2];
        this.cov[4][5] = d4;
        this.cov[5][4] = d4;
        this.specified = (byte)(this.specified | 0x20);
        return true;
    }

    public boolean setRadialVelocity(double d, double d2) {
        if (this.ready) {
            return false;
        }
        if (Double.isNaN(d)) {
            return false;
        }
        this.rv = d;
        this.e_rv = d2;
        this.specified = (byte)(this.specified | 2);
        return true;
    }

    public boolean setParallax(double d, double d2) {
        if (this.ready) {
            return false;
        }
        if (Double.isNaN(d)) {
            return false;
        }
        this.plx = d;
        this.e_plx = d2;
        this.specified = (byte)(this.specified | 1);
        return true;
    }

    public boolean copyErrorEllipse(double[] dArray) {
        double[] dArray2 = new double[3];
        if (!this.ready) {
            this.compute();
        }
        dArray2[0] = this.getVar(1, 1);
        dArray2[1] = this.getVar(2, 2);
        dArray2[2] = this.getVar(1, 2);
        Astropos.varianceToErrorEllipse(dArray2, dArray);
        return (this.specified & 0x10) != 0;
    }

    public double sigmaLon() {
        if (!this.ready) {
            this.compute();
        }
        return Math.sqrt(this.getVar(1, 1));
    }

    public double sigmaLat() {
        if (!this.ready) {
            this.compute();
        }
        return Math.sqrt(this.getVar(2, 2));
    }

    public boolean copyProperMotion(double[] dArray) {
        if (this.R == null) {
            dArray[1] = Double.NaN;
            dArray[0] = Double.NaN;
        } else {
            dArray[0] = (this.R[1][0] * this.xd + this.R[1][1] * this.yd) * 180.0 * 3600000.0 / Math.PI;
            dArray[1] = (this.R[2][0] * this.xd + this.R[2][1] * this.yd + this.R[2][2] * this.zd) * 180.0 * 3600000.0 / Math.PI;
        }
        return (this.specified & 4) != 0;
    }

    public double getProperMotionLon() {
        if (this.R == null) {
            return 0.0;
        }
        return (this.R[1][0] * this.xd + this.R[1][1] * this.yd) * 180.0 * 3600000.0 / Math.PI;
    }

    public double getProperMotionLat() {
        if (this.R == null) {
            return 0.0;
        }
        return (this.R[2][0] * this.xd + this.R[2][1] * this.yd + this.R[2][2] * this.zd) * 180.0 * 3600000.0 / Math.PI;
    }

    public boolean copyProperMotionErrorEllipse(double[] dArray) {
        double[] dArray2 = new double[3];
        if (!this.ready) {
            this.compute();
        }
        dArray2[0] = this.getVar(4, 4);
        dArray2[1] = this.getVar(5, 5);
        dArray2[2] = this.getVar(4, 5);
        Astropos.varianceToErrorEllipse(dArray2, dArray);
        return (this.specified & 0x20) != 0;
    }

    public double sigmaProperMotionLon() {
        if (!this.ready) {
            this.compute();
        }
        return Math.sqrt(this.getVar(4, 4));
    }

    public double sigmaProperMotionLat() {
        if (!this.ready) {
            this.compute();
        }
        return Math.sqrt(this.getVar(5, 5));
    }

    public boolean copyParallax(double[] dArray) {
        if (!this.ready) {
            this.compute();
        }
        dArray[0] = this.plx;
        dArray[1] = this.e_plx;
        return (this.specified & 1) != 0;
    }

    public boolean copyVelocity(double[] dArray) {
        if (!this.ready) {
            this.compute();
        }
        dArray[0] = this.rv;
        dArray[1] = this.e_rv;
        return (this.specified & 2) != 0;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (!(object instanceof Astropos)) {
            return bl;
        }
        Astropos astropos = (Astropos)object;
        if (!super.equals((Coo)object)) {
            return bl;
        }
        bl = this.xd == astropos.xd && this.yd == astropos.yd && this.zd == astropos.zd && this.epocho == astropos.epocho;
        return bl;
    }

    public int hashCode() {
        int n = super.hashCode();
        long l = Double.doubleToLongBits(this.xd);
        n = n * 123 + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.yd);
        n = n * 123 + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.zd);
        n = n * 123 + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.epocho);
        n = n * 123 + (int)(l ^ l >>> 32);
        return n;
    }

    private final StringBuffer ed1(StringBuffer stringBuffer, int n) {
        super.edit(stringBuffer, n);
        return stringBuffer;
    }

    public String toString() {
        return this.toString(this.editing);
    }

    public String toString(int n) {
        int n2;
        int n3;
        double[] dArray = new double[3];
        double[] dArray2 = new double[2];
        StringBuffer stringBuffer = new StringBuffer(200);
        int n4 = n3 = (this.precision & 0x80) != 0 ? 3 : 0;
        if (!this.ready) {
            this.compute();
        }
        if (!this.ready) {
            this.compute();
        }
        super.edit(stringBuffer, n3 | n);
        boolean bl = this.copyErrorEllipse(dArray);
        if (bl) {
            n2 = this.precision - 6;
            if (n2 <= 0) {
                n2 = -1;
            }
            stringBuffer.append(" [");
            ed.editDecimal(stringBuffer, dArray[0], 0, n2, 0);
            if (bl) {
                stringBuffer.append(' ');
            } else {
                stringBuffer.append(": ");
            }
            ed.editDecimal(stringBuffer, dArray[1], 0, n2, 0);
            stringBuffer.append(' ');
            if (bl) {
                stringBuffer.append(' ');
            } else {
                stringBuffer.append(": ");
            }
            ed.editDecimal(stringBuffer, dArray[2], 0, -2, 0);
            if ((this.specified & 8) != 0 || (this.editing & 0x800) != 0) {
                stringBuffer.append(" (");
                this.editEpoch(stringBuffer, this.epocho);
                stringBuffer.append(")");
            }
            stringBuffer.append(']');
        }
        if (bl = this.copyProperMotion(dArray2)) {
            stringBuffer.append(" ");
            ed.editDecimal(stringBuffer, dArray2[0], 0, -6, 16);
            stringBuffer.append(" ");
            ed.editDecimal(stringBuffer, dArray2[1], 0, -6, 16);
            bl = this.copyProperMotionErrorEllipse(dArray);
            if (bl) {
                n2 = -2;
                stringBuffer.append(" [");
                ed.editDecimal(stringBuffer, dArray[0], 0, n2, 0);
                if (bl) {
                    stringBuffer.append(' ');
                } else {
                    stringBuffer.append(": ");
                }
                ed.editDecimal(stringBuffer, dArray[1], 0, n2, 0);
                stringBuffer.append(' ');
                if (bl) {
                    stringBuffer.append(' ');
                } else {
                    stringBuffer.append(": ");
                }
                ed.editDecimal(stringBuffer, dArray[2], 0, -2, 0);
                stringBuffer.append(']');
            }
        }
        if ((this.specified & 2) != 0) {
            stringBuffer.append(" ");
            ed.editDecimal(stringBuffer, this.rv, 0, -6, 16);
            stringBuffer.append('[');
            ed.editDecimal(stringBuffer, this.e_rv, 0, -6, 0);
            stringBuffer.append("]km/s");
        }
        if ((this.specified & 1) != 0) {
            stringBuffer.append(" ");
            ed.editDecimal(stringBuffer, this.plx, 0, -6, 0);
            stringBuffer.append('[');
            ed.editDecimal(stringBuffer, this.e_plx, 0, -6, 0);
            stringBuffer.append("]");
        }
        return stringBuffer.toString();
    }

    public void toEpoch(double d) {
        double d2 = d - this.epoch;
        if (DEBUG) {
            System.out.println("....toEpoch(" + this.epoch + ") => " + d);
        }
        if (d2 == 0.0) {
            return;
        }
        if (!this.ready) {
            this.compute();
        }
        this.x += d2 * this.xd;
        this.y += d2 * this.yd;
        this.z += d2 * this.zd;
        this.lat = Double.NaN;
        this.lon = Double.NaN;
        if (this.cov != null) {
            Astropos.propagate_error(this.cov, d2);
        }
        this.epoch = d;
        this.normalize();
    }

    public void convertTo(Astroframe astroframe) {
        double d;
        double d2 = 1.0;
        double[][] dArray = null;
        double[] dArray2 = null;
        if (!this.ready) {
            this.compute();
        }
        double d3 = astroframe.epoch;
        if (DEBUG) {
            System.out.println("....Astropos convert from " + this.getFrame() + ",Ep=" + this.epoch + " to " + astroframe + ",Ep=" + d3);
        }
        if (this.frame.equals(astroframe)) {
            if (DEBUG) {
                System.out.println("....(identical frames)");
            }
            if (d3 != this.epoch) {
                this.toEpoch(d3);
            }
            return;
        }
        if (DEBUG) {
            System.out.println("....Astropos.convert via ICRS:  " + this.frame + " => ICRS => " + astroframe);
        }
        dArray2 = new double[]{this.x, this.y, this.z, this.xd, this.yd, this.zd};
        if (DEBUG) {
            System.out.println(Coo.toString(".... convert(1): ", dArray2));
        }
        if ((d = this.frame.base_epoch - this.epoch) != 0.0) {
            if (DEBUG) {
                System.out.println("     Change epoch: " + this.epoch + " to " + this.frame.base_epoch + " on " + this.frame);
            }
            dArray2[0] = dArray2[0] + dArray2[3] * d;
            dArray2[1] = dArray2[1] + dArray2[4] * d;
            dArray2[2] = dArray2[2] + dArray2[5] * d;
            d2 *= Coo.normalize(dArray2);
            if (DEBUG) {
                System.out.println(Coo.toString(".... base_ep(2): ", dArray2));
            }
        }
        this.frame.toICRS(dArray2);
        if (DEBUG) {
            System.out.println(Coo.toString(".... in.ICRS(3): ", dArray2));
        }
        astroframe.fromICRS(dArray2);
        if (DEBUG) {
            System.out.println(Coo.toString(".... baseNew(4): ", dArray2));
        }
        if ((d = d3 - astroframe.base_epoch) != 0.0) {
            if (DEBUG) {
                System.out.println("     Change epoch: " + astroframe.base_epoch + " to " + d3 + " on " + astroframe);
            }
            dArray2[0] = dArray2[0] + dArray2[3] * d;
            dArray2[1] = dArray2[1] + dArray2[4] * d;
            dArray2[2] = dArray2[2] + dArray2[5] * d;
            d2 *= Coo.normalize(dArray2);
            if (DEBUG) {
                System.out.println(Coo.toString(".... finalEp(5): ", dArray2));
            }
        }
        if (this.cov != null) {
            Coo coo = new Coo(dArray2[0], dArray2[1], dArray2[2]);
            Astropos.propagate_error(this.cov, d3 - this.epoch);
            dArray = this.moveMatrix(coo);
        }
        if (DEBUG) {
            System.out.println(Coo.toString(".... convEnd(6): ", dArray2));
        }
        this.lat = Double.NaN;
        this.lon = Double.NaN;
        this.x = dArray2[0];
        this.y = dArray2[1];
        this.z = dArray2[2];
        this.xd = dArray2[3];
        this.yd = dArray2[4];
        this.zd = dArray2[5];
        this.epoch = d3;
        this.frame = astroframe;
        d2 *= this.normalize();
        if (DEBUG) {
            System.out.println(".... Total inflation=" + d2);
        }
        this.plx /= d2;
        this.e_plx /= d2;
        if (dArray != null) {
            Astropos.rotate_cov(dArray, this.cov);
        }
        this.localMatrix(this.R);
    }
}

