/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

import cds.aladin.Aladin;
import cds.allsky.Constante;
import cds.allsky.Context;
import cds.allsky.MainPanel;
import cds.allsky.Mode;
import cds.tools.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class TabDesc
extends JPanel
implements ActionListener {
    private String REP_SOURCE;
    private String REP_DEST;
    private String REP_DEST_RESET;
    private String INDEX_RESET;
    private JLabel infoLabel;
    private JLabel destLabel;
    private JLabel sourceLabel;
    private JLabel labelAllsky;
    private String LABELALLSKY;
    private String NEXT;
    private String SEE;
    private String INFOALLSKY;
    private String PARAMALLSKY;
    private String KEEPALLSKY;
    private String COADDALLSKY;
    private String OVERWRITEALLSKY;
    private String KEEPCELLALLSKY;
    private String SPECIFALLSKY;
    private String BLANKALLSKY;
    private String BORDERALLSKY;
    private String SKYVALALLSKY;
    private String HDUALLSKY;
    private JLabel paramLabel;
    private JRadioButton keepRadio;
    private JRadioButton coaddRadio;
    private JRadioButton overwriteRadio;
    private JRadioButton keepCellRadio;
    private JCheckBox specifCheckbox;
    private JCheckBox blankCheckbox;
    private JCheckBox hduCheckbox;
    private JCheckBox borderCheckbox;
    private JRadioButton skyvalCheckbox;
    private JCheckBox frameCheckbox;
    private JTextField specifTextField;
    protected JTextField blankTextField;
    protected JTextField hduTextField;
    protected JTextField borderTextField;
    private JTextField skyvalTextField;
    protected JTextField inputField = new JTextField(35);
    protected JTextField outputField = new JTextField(35);
    private JButton browseInput = new JButton();
    private JButton browseOutput = new JButton();
    private JCheckBox resetIndex = new JCheckBox();
    private JCheckBox resetTiles = new JCheckBox();
    private JTextField labelField = new JTextField(35);
    private String defaultDirectory;
    private String BROWSE;
    private JButton next;
    private JButton seeImg;
    private JButton reset;
    private String help;
    private String titlehelp;
    private MainPanel mainPanel;
    private Context context;

    public TabDesc(String defaultDir, final MainPanel mainPanel) {
        super(new BorderLayout());
        this.mainPanel = mainPanel;
        this.context = mainPanel.context;
        this.createChaine();
        this.init();
        JPanel pCenter = new JPanel(new GridBagLayout());
        this.defaultDirectory = defaultDir;
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(1, 3, 1, 3);
        c.anchor = 18;
        c.fill = 2;
        c.gridy = 0;
        c.gridx = 0;
        c.gridwidth = 4;
        pCenter.add((Component)this.infoLabel, c);
        c.insets.top = 20;
        c.gridwidth = 1;
        ++c.gridy;
        c.gridx = 0;
        pCenter.add((Component)this.sourceLabel, c);
        ++c.gridx;
        pCenter.add((Component)Util.getHelpButton(this, this.getString("HELPDIRSRCALLSKY")), c);
        ++c.gridx;
        pCenter.add((Component)this.inputField, c);
        ++c.gridx;
        pCenter.add((Component)this.browseInput, c);
        c.insets.top = 1;
        ++c.gridy;
        c.gridx = 0;
        pCenter.add((Component)this.destLabel, c);
        ++c.gridx;
        pCenter.add((Component)Util.getHelpButton(this, this.getString("HELPDIRTRGALLSKY")), c);
        ++c.gridx;
        pCenter.add((Component)this.outputField, c);
        ++c.gridx;
        pCenter.add((Component)this.browseOutput, c);
        c.insets.bottom = 20;
        ++c.gridy;
        c.gridx = 0;
        pCenter.add((Component)this.labelAllsky, c);
        ++c.gridx;
        pCenter.add((Component)Util.getHelpButton(this, this.getString("HELPLABELALLSKY")), c);
        ++c.gridx;
        pCenter.add((Component)this.labelField, c);
        c.insets.bottom = 1;
        c.gridx = 0;
        ++c.gridy;
        pCenter.add((Component)this.paramLabel, c);
        ++c.gridx;
        pCenter.add((Component)Util.getHelpButton(this, this.getString("HELPPARAMALLSKY")), c);
        ++c.gridx;
        c.gridwidth = 2;
        pCenter.add((Component)this.resetIndex, c);
        ++c.gridy;
        pCenter.add((Component)this.resetTiles, c);
        ++c.gridy;
        JPanel pTiles = new JPanel(new FlowLayout(0, 0, 0));
        pTiles.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        pTiles.add(this.keepRadio);
        pTiles.add(this.overwriteRadio);
        pTiles.add(this.coaddRadio);
        pCenter.add((Component)pTiles, c);
        if (Aladin.PROTO) {
            ++c.gridy;
            pTiles = new JPanel(new FlowLayout(0, 0, 0));
            pTiles.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
            pTiles.add(this.keepCellRadio);
            pCenter.add((Component)pTiles, c);
        }
        c.gridx = 2;
        ++c.gridy;
        JPanel px = new JPanel(new BorderLayout(0, 0));
        this.blankTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                TabDesc.this.blankCheckbox.setSelected(TabDesc.this.blankTextField.getText().trim().length() > 0);
            }
        });
        px.add((Component)this.blankCheckbox, "West");
        px.add((Component)this.blankTextField, "Center");
        pCenter.add((Component)px, c);
        ++c.gridy;
        px = new JPanel(new BorderLayout(0, 0));
        this.hduTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                TabDesc.this.hduCheckbox.setSelected(TabDesc.this.hduTextField.getText().trim().length() > 0);
            }
        });
        px.add((Component)this.hduCheckbox, "West");
        px.add((Component)this.hduTextField, "Center");
        pCenter.add((Component)px, c);
        ++c.gridy;
        px = new JPanel(new BorderLayout(0, 0));
        this.skyvalTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                TabDesc.this.skyvalCheckbox.setSelected(TabDesc.this.skyvalTextField.getText().trim().length() > 0);
            }
        });
        px.add((Component)this.skyvalCheckbox, "West");
        px.add((Component)this.skyvalTextField, "Center");
        pCenter.add((Component)px, c);
        ++c.gridy;
        px = new JPanel(new BorderLayout(0, 0));
        this.borderTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                TabDesc.this.borderCheckbox.setSelected(TabDesc.this.borderTextField.getText().trim().length() > 0);
            }
        });
        px.add((Component)this.borderCheckbox, "West");
        px.add((Component)this.borderTextField, "Center");
        pCenter.add((Component)px, c);
        ++c.gridy;
        px = new JPanel(new BorderLayout(0, 0));
        px.add((Component)this.specifCheckbox, "West");
        px.add((Component)this.specifTextField, "Center");
        this.specifTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                TabDesc.this.specifCheckbox.setSelected(TabDesc.this.specifTextField.getText().trim().length() > 0);
            }
        });
        pCenter.add((Component)px, c);
        if (Aladin.PROTO) {
            ++c.gridy;
            final JCheckBox cb1 = this.frameCheckbox = new JCheckBox("HEALPix in galactic (default is ICRS)", false);
            cb1.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    mainPanel.context.setFrame(cb1.isSelected() ? 3 : 0);
                }
            });
            pCenter.add((Component)cb1, c);
        }
        JPanel fin = new JPanel(new BorderLayout());
        JPanel pBtn = new JPanel();
        pBtn.setLayout(new BoxLayout(pBtn, 0));
        pBtn.add(Box.createHorizontalGlue());
        pBtn.add(this.seeImg);
        pBtn.add(this.reset);
        pBtn.add(this.next);
        pBtn.add(Box.createHorizontalGlue());
        fin.add((Component)pBtn, "Center");
        this.add((Component)pCenter, "Center");
        this.add((Component)fin, "South");
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
    }

    private void createChaine() {
        this.REP_SOURCE = this.getString("REPSALLSKY");
        this.BROWSE = this.getString("FILEBROWSE");
        this.REP_DEST = this.getString("REPDALLSKY");
        this.REP_DEST_RESET = this.getString("REPRESALLSKY");
        this.INDEX_RESET = this.getString("INDEXRESETALLSKY");
        this.LABELALLSKY = this.getString("LABELALLSKY");
        this.SEE = this.getString("SEE");
        this.NEXT = this.getString("NEXT");
        this.titlehelp = this.getString("HHELP");
        this.INFOALLSKY = this.getString("INFOALLSKY");
        this.PARAMALLSKY = this.getString("PARAMALLSKY");
        this.COADDALLSKY = this.getString("COADDALLSKY");
        this.KEEPALLSKY = this.getString("KEEPALLSKY");
        this.KEEPCELLALLSKY = this.getString("KEEPCELLALLSKY");
        this.OVERWRITEALLSKY = this.getString("OVERWRITEALLSKY");
        this.SPECIFALLSKY = this.getString("SPECIFALLSKY");
        this.BLANKALLSKY = this.getString("BLANKALLSKY");
        this.HDUALLSKY = this.getString("HDUALLSKY");
        this.BORDERALLSKY = this.getString("BORDERALLSKY");
        this.SKYVALALLSKY = this.getString("SKYVALALLSKY");
    }

    private String getString(String k) {
        MainPanel mainPanel = this.mainPanel;
        return mainPanel.aladin.getChaine().getString(k);
    }

    public void init() {
        this.infoLabel = new JLabel(Util.fold(this.INFOALLSKY, 100, true));
        this.infoLabel.setFont(this.infoLabel.getFont().deriveFont(2));
        this.sourceLabel = new JLabel(this.REP_SOURCE);
        this.sourceLabel.setFont(this.sourceLabel.getFont().deriveFont(1));
        this.destLabel = new JLabel(this.REP_DEST);
        this.destLabel.setFont(this.destLabel.getFont().deriveFont(1));
        this.inputField.addActionListener(this);
        this.inputField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                super.keyTyped(e);
                if (!TabDesc.this.inputField.getText().equals("")) {
                    TabDesc.this.actionPerformed(new ActionEvent(TabDesc.this.inputField, -1, "dirBrowser Action"));
                }
            }
        });
        this.browseInput.setText(this.BROWSE);
        this.browseInput.addActionListener(this);
        this.outputField.addActionListener(this);
        this.outputField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                super.keyTyped(e);
                if (!TabDesc.this.outputField.getText().equals("")) {
                    TabDesc.this.actionPerformed(new ActionEvent(TabDesc.this.outputField, -1, "dirBrowser Action"));
                }
            }
        });
        this.browseOutput.setText(this.BROWSE);
        this.browseOutput.addActionListener(this);
        this.labelAllsky = new JLabel(this.LABELALLSKY);
        this.labelAllsky.setFont(this.labelAllsky.getFont().deriveFont(1));
        this.paramLabel = new JLabel(this.PARAMALLSKY);
        this.paramLabel.setFont(this.paramLabel.getFont().deriveFont(1));
        ButtonGroup tilesGroup = new ButtonGroup();
        this.keepRadio = new JRadioButton(this.KEEPALLSKY);
        tilesGroup.add(this.keepRadio);
        this.overwriteRadio = new JRadioButton(this.OVERWRITEALLSKY);
        tilesGroup.add(this.overwriteRadio);
        this.coaddRadio = new JRadioButton(this.COADDALLSKY);
        tilesGroup.add(this.coaddRadio);
        this.keepCellRadio = new JRadioButton(this.KEEPCELLALLSKY);
        tilesGroup.add(this.keepCellRadio);
        this.keepRadio.setSelected(true);
        this.specifCheckbox = new JCheckBox(this.SPECIFALLSKY);
        this.specifCheckbox.setSelected(false);
        this.specifTextField = new JTextField();
        this.blankCheckbox = new JCheckBox(this.BLANKALLSKY);
        this.blankCheckbox.setSelected(false);
        this.blankTextField = new JTextField();
        this.hduCheckbox = new JCheckBox(this.HDUALLSKY);
        this.hduCheckbox.setSelected(false);
        this.hduTextField = new JTextField();
        this.borderCheckbox = new JCheckBox(this.BORDERALLSKY);
        this.borderCheckbox.setSelected(false);
        this.borderTextField = new JTextField();
        this.skyvalCheckbox = new JRadioButton(this.SKYVALALLSKY);
        this.skyvalCheckbox.setSelected(false);
        this.skyvalTextField = new JTextField();
        this.skyvalCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabDesc.this.resumeWidgets();
            }
        });
        this.resetTiles.setText(this.REP_DEST_RESET);
        this.resetTiles.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabDesc.this.resumeWidgets();
            }
        });
        this.resetIndex.setText(this.INDEX_RESET);
        this.resetIndex.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabDesc.this.resumeWidgets();
            }
        });
        this.seeImg = new JButton(this.SEE);
        this.seeImg.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabDesc.this.loadImgEtalon();
            }
        });
        this.reset = new JButton(this.getString("RESET"));
        this.reset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabDesc.this.mainPanel.clearForms();
            }
        });
        this.next = new JButton(this.NEXT);
        this.next.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabDesc.this.mainPanel.showBuildTab();
            }
        });
        this.resetTiles.setSelected(false);
        this.resetIndex.setSelected(true);
    }

    private void loadImgEtalon() {
        String fileName = this.context.getImgEtalon();
        if (fileName.endsWith(".hhh")) {
            fileName = fileName.substring(0, fileName.length() - 4) + ".jpg";
        }
        this.mainPanel.aladin.execAsyncCommand("load " + fileName);
    }

    @Override
    public void show() {
        super.show();
        this.resumeWidgets();
    }

    protected void resumeWidgets() {
        try {
            boolean color = this.context.isColor();
            boolean dirExist = this.context.isExistingDir();
            boolean allskyExist = this.context.isExistingAllskyDir();
            boolean indexExist = this.context.isExistingIndexDir();
            boolean isRunning = this.context.isTaskRunning();
            boolean isMap = this.context.isMap();
            this.resetTiles.setEnabled(allskyExist && !isRunning);
            this.resetIndex.setEnabled(indexExist && !isRunning);
            boolean flag = !this.resetTiles.isSelected() && this.resetTiles.isEnabled();
            this.keepRadio.setEnabled(flag);
            this.keepCellRadio.setEnabled(flag);
            this.overwriteRadio.setEnabled(flag);
            this.coaddRadio.setEnabled(flag);
            boolean ready = (dirExist || isMap) && this.outputField.getText().trim().length() > 0;
            this.seeImg.setEnabled(this.context.getImgEtalon() != null && !isMap);
            this.next.setEnabled(ready);
            this.reset.setEnabled(this.getInputField().trim().length() > 0);
            this.blankCheckbox.setEnabled(ready && !isRunning && !color);
            this.blankTextField.setEnabled(ready && !isRunning && !color);
            this.hduCheckbox.setEnabled(ready && !isRunning && !color && !isMap);
            this.hduTextField.setEnabled(ready && !isRunning && !color && !isMap);
            this.borderCheckbox.setEnabled(ready && !isRunning && !isMap);
            this.borderTextField.setEnabled(ready && !isRunning && !isMap);
            this.skyvalCheckbox.setEnabled(ready && !isRunning && !color && !isMap);
            this.skyvalTextField.setEnabled(ready && !isRunning && !color && !isMap);
            this.specifCheckbox.setEnabled(ready && !isRunning && !isMap);
            this.specifTextField.setEnabled(ready && !isRunning && !isMap);
            if (this.frameCheckbox != null) {
                this.frameCheckbox.setEnabled(ready && !isRunning && !isMap);
            }
            this.inputField.setEnabled(!isRunning);
            this.outputField.setEnabled(!isRunning);
            this.labelField.setEnabled(!isRunning);
            if (this.skyvalCheckbox.isSelected() && this.skyvalTextField.getText().trim().length() == 0) {
                this.skyvalTextField.setText("true");
            }
            this.setCursor(isRunning ? Cursor.getPredefinedCursor(3) : Cursor.getPredefinedCursor(0));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void clearForms() {
        this.inputField.setText("");
        this.outputField.setText("");
        if (this.mainPanel != null) {
            this.mainPanel.actionPerformed(new ActionEvent("", -1, "dirBrowser Action"));
        }
        this.labelField.setText("");
        this.resetTiles.setSelected(false);
        this.resetIndex.setSelected(true);
        this.resumeWidgets();
    }

    private void dirBrowser(JTextField dir) {
        String currentDirectoryPath = dir.getText().trim();
        String path = Util.dirBrowser(null, "", currentDirectoryPath, dir);
        if (path == null) {
            return;
        }
        this.mainPanel.actionPerformed(new ActionEvent(dir, -1, "dirBrowser Action"));
    }

    public String getInputField() {
        return this.inputField.getText();
    }

    public String getOutputField() {
        return this.outputField.getText();
    }

    public void setOutputField(String output) {
        this.outputField.setText(output);
    }

    public Mode getCoaddModeField() {
        return this.resetTiles.isSelected() ? Mode.REPLACETILE : (this.keepRadio.isSelected() ? Mode.KEEP : (this.keepCellRadio.isSelected() ? Mode.KEEPTILE : (this.overwriteRadio.isSelected() ? Mode.OVERWRITE : (this.coaddRadio.isSelected() ? Mode.AVERAGE : Mode.REPLACETILE))));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.inputField) {
            this.initTxt();
        } else if (e.getSource() == this.browseInput) {
            this.dirBrowser(this.inputField);
            this.initTxt();
        }
        if (e.getSource() == this.outputField) {
            this.newAllskyDir();
        } else if (e.getSource() == this.browseOutput) {
            this.dirBrowser(this.outputField);
            this.newAllskyDir();
        }
    }

    private void initTxt() {
        String txt = this.inputField.getText();
        int i = txt.lastIndexOf(Util.FS);
        if (i == -1) {
            return;
        }
        while (i + 1 == txt.length()) {
            txt = txt.substring(0, i);
        }
        String str = txt.substring(txt.lastIndexOf(Util.FS) + 1);
        this.labelField.setText(str);
        this.outputField.setText("");
        this.newAllskyDir();
    }

    public String getLabelField() {
        return this.labelField.getText();
    }

    public String getMocField() {
        if (!this.specifCheckbox.isSelected()) {
            return "";
        }
        return this.specifTextField.getText();
    }

    public String getBlank() {
        if (!this.blankCheckbox.isSelected()) {
            return "";
        }
        return this.blankTextField.getText();
    }

    public String getHDU() {
        if (!this.hduCheckbox.isSelected()) {
            return "";
        }
        return this.hduTextField.getText();
    }

    public String getBorderSize() {
        if (!this.borderCheckbox.isSelected()) {
            return "0";
        }
        return this.borderTextField.getText();
    }

    public String getSkyvalField() {
        if (!this.skyvalCheckbox.isSelected()) {
            return null;
        }
        String s = this.skyvalTextField.getText().toUpperCase().trim();
        if (s.length() == 0) {
            s = "true";
        }
        return s;
    }

    private void newAllskyDir() {
        String str = this.outputField.getText();
        while (str.endsWith(Util.FS)) {
            str = str.substring(0, str.lastIndexOf(Util.FS));
        }
        if (str.equals("")) {
            this.initOutputField();
            this.mainPanel.newAllskyDir();
            return;
        }
        Constante.SURVEY = str.substring(str.lastIndexOf(Util.FS) + 1);
        this.mainPanel.newAllskyDir();
        this.resumeWidgets();
    }

    private void initOutputField() {
        Constante.SURVEY = this.getLabelField() + "HiPS";
        String path = this.inputField.getText();
        while (path.endsWith(Util.FS)) {
            path = path.substring(0, path.lastIndexOf(Util.FS));
        }
        this.outputField.setText(path + "HiPS" + Util.FS);
    }

    public boolean isResetTiles() {
        return this.resetTiles.isSelected() && this.resetTiles.isEnabled();
    }

    public boolean isResetIndex() {
        return this.resetIndex.isSelected() && this.resetIndex.isEnabled();
    }

    public void help() {
        JOptionPane.showMessageDialog(this, this.help, this.titlehelp, 1);
    }
}

