/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.allsky.Action;
import cds.allsky.BuildProgressPanel;
import cds.allsky.BuildTable;
import cds.allsky.Context;
import cds.allsky.ContextGui;
import cds.allsky.MainPanel;
import cds.allsky.Task;
import cds.tools.Util;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;

public class TabBuild
extends JPanel
implements ActionListener {
    protected static final String BEST = "best";
    protected static final String FIRST = "first";
    protected JButton abort;
    protected JButton start;
    protected JButton pause;
    protected JButton previous;
    protected JButton next;
    protected JButton moc;
    private static BuildTable tab = null;
    private JLabel method_label = new JLabel();
    private ButtonGroup groupSampl = new ButtonGroup();
    private ButtonGroup groupOverlay = new ButtonGroup();
    private JRadioButton samplFast = new JRadioButton();
    private JRadioButton overlayFast = new JRadioButton();
    private JRadioButton samplBest = new JRadioButton();
    private JRadioButton overlayBest = new JRadioButton();
    private JCheckBox fading = new JCheckBox();
    private ActionListener methodsListener = new MethodSelectListener(new JRadioButton[]{this.samplFast, this.overlayFast, this.samplBest, this.overlayBest}, this.fading);
    private final String BIT8 = "short (8bits)";
    private final String BIT16 = "int (16bits)";
    private final String BIT32 = "long int (32bits)";
    private final String BIT_32 = "float real (32bits)";
    private final String BIT64 = "double real (64bits)";
    private ButtonGroup groupBitpix = new ButtonGroup();
    private JCheckBox keepBB = new JCheckBox();
    private ActionListener bitpixListener = new BitpixListener(this.keepBB);
    private JRadioButton bit8 = new JRadioButton("short (8bits)", false);
    private JRadioButton bit16 = new JRadioButton("int (16bits)", false);
    private JRadioButton bit32 = new JRadioButton("long int (32bits)", true);
    private JRadioButton bit_32 = new JRadioButton("float real (32bits)", false);
    private JRadioButton bit_64 = new JRadioButton("double real (64bits)", false);
    private int bitpixOrig = -1;
    private JLabel bitpixLabel = new JLabel();
    private JLabel resoLabel;
    private JLabel note;
    private String canceltip;
    MainPanel mainPanel;
    Context context;
    protected BuildProgressPanel buildProgressPanel;

    private String getString(String k) {
        MainPanel mainPanel = this.mainPanel;
        return mainPanel.aladin.getChaine().getString(k);
    }

    public TabBuild(MainPanel panel) {
        super(new BorderLayout());
        this.mainPanel = panel;
        this.context = this.mainPanel.context;
        JPanel pCenter = new JPanel();
        pCenter.setLayout(new GridBagLayout());
        this.init();
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.fill = 0;
        c.gridwidth = 1;
        c.insets = new Insets(0, 0, 0, 0);
        ++c.gridy;
        this.bitpixLabel.setText(this.getString("BITPIXALLSKY"));
        pCenter.add((Component)this.bitpixLabel, c);
        c.gridwidth = 0;
        ++c.gridx;
        pCenter.add((Component)Util.getHelpButton(this, this.getString("HELPBITPIXALLSKY")), c);
        c.gridx = 0;
        c.gridwidth = 1;
        ++c.gridy;
        pCenter.add((Component)this.bit8, c);
        ++c.gridx;
        pCenter.add((Component)this.bit16, c);
        ++c.gridx;
        pCenter.add((Component)this.bit32, c);
        ++c.gridy;
        c.gridx = 0;
        pCenter.add((Component)this.bit_32, c);
        ++c.gridx;
        pCenter.add((Component)this.bit_64, c);
        ++c.gridx;
        this.keepBB.setText(this.getString("KEEPORIGALLSKY"));
        pCenter.add((Component)this.keepBB, c);
        c.insets.top = 15;
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        this.resoLabel.setText(this.getString("RESOALLSKY"));
        pCenter.add((Component)this.resoLabel, c);
        ++c.gridx;
        c.gridwidth = 0;
        pCenter.add((Component)Util.getHelpButton(this, this.getString("HELPRESOALLSKY")), c);
        c.insets.top = 0;
        c.gridx = 0;
        ++c.gridy;
        c.anchor = 10;
        c.gridwidth = 0;
        tab.setPreferredScrollableViewportSize(new Dimension(500, 120));
        tab.setRowSelectionAllowed(false);
        JScrollPane pane = new JScrollPane(tab);
        pCenter.add((Component)pane, c);
        ++c.gridy;
        c.anchor = 13;
        JLabel l = this.note = new JLabel("<html><i>(*) whole sky</i></html>");
        pCenter.add((Component)l, c);
        c.insets.top = 15;
        c.fill = 2;
        c.gridwidth = 0;
        ++c.gridy;
        c.gridx = 0;
        this.buildProgressPanel = new BuildProgressPanel();
        pCenter.add((Component)this.buildProgressPanel, c);
        this.buildProgressPanel.resetProgressBar();
        JPanel fin = new JPanel(new BorderLayout());
        this.initBtn();
        JPanel pBtn = new JPanel();
        pBtn.setLayout(new BoxLayout(pBtn, 0));
        pBtn.add(Box.createHorizontalGlue());
        pBtn.add(this.previous);
        pBtn.add(this.moc);
        pBtn.add(this.start);
        pBtn.add(this.pause);
        pBtn.add(this.abort);
        pBtn.add(Box.createRigidArea(new Dimension(10, 0)));
        pBtn.add(this.next);
        pBtn.add(Box.createHorizontalGlue());
        fin.add((Component)pBtn, "Center");
        this.add((Component)pCenter, "Center");
        this.add((Component)fin, "South");
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
    }

    public void init() {
        tab = new BuildTable(this.context, this);
        this.resoLabel = new JLabel();
        this.resoLabel.setFont(this.resoLabel.getFont().deriveFont(1));
        this.bitpixLabel.setFont(this.bitpixLabel.getFont().deriveFont(1));
        this.keepBB.setEnabled(false);
        this.initBitpix();
        this.method_label.setFont(this.resoLabel.getFont().deriveFont(1));
        this.samplBest.setSelected(true);
        this.fading.setSelected(true);
        this.overlayBest.setSelected(true);
        this.initMethods();
        this.initListenerBitpix();
        this.initBtn();
    }

    private void initBtn() {
        JButton bt;
        this.previous = bt = new JButton(this.getString("PREVIOUS"));
        bt.addActionListener(this);
        this.moc = bt = new JButton(this.getString("LOADMOC"));
        bt.addActionListener(this);
        this.start = bt = new JButton(this.getString("START"));
        bt.addActionListener(this);
        this.pause = bt = new JButton(this.getString("PAUSE"));
        bt.addActionListener(this);
        this.abort = bt = new JButton(this.getString("ABORT"));
        bt.addActionListener(this);
        bt.setToolTipText(this.canceltip);
        this.next = bt = new JButton(this.getString("NEXT"));
        bt.addActionListener(this);
    }

    private void loadMoc() {
        String mocFile = this.mainPanel.context.getHpxFinderPath() + Util.FS + "Moc.fits";
        this.mainPanel.aladin.execAsyncCommand("load " + mocFile);
    }

    private void initMethods() {
        this.groupSampl.add(this.samplBest);
        this.groupSampl.add(this.samplFast);
        this.groupOverlay.add(this.overlayBest);
        this.groupOverlay.add(this.overlayFast);
        this.samplBest.addActionListener(this.methodsListener);
        this.samplFast.addActionListener(this.methodsListener);
        this.overlayBest.addActionListener(this.methodsListener);
        this.overlayFast.addActionListener(this.methodsListener);
        this.samplBest.setActionCommand(BEST);
        this.samplFast.setActionCommand(FIRST);
        this.overlayBest.setActionCommand(BEST);
        this.overlayFast.setActionCommand(FIRST);
    }

    private void initListenerBitpix() {
        this.bit8.addActionListener(this.bitpixListener);
        this.bit16.addActionListener(this.bitpixListener);
        this.bit32.addActionListener(this.bitpixListener);
        this.bit_32.addActionListener(this.bitpixListener);
        this.bit_64.addActionListener(this.bitpixListener);
    }

    private void initBitpix() {
        this.bit8.setActionCommand("8");
        this.bit16.setActionCommand("16");
        this.bit32.setActionCommand("32");
        this.bit_32.setActionCommand("-32");
        this.bit_64.setActionCommand("-64");
        this.bit8.addActionListener(this);
        this.bit16.addActionListener(this);
        this.bit32.addActionListener(this);
        this.bit_32.addActionListener(this);
        this.bit_64.addActionListener(this);
        this.groupBitpix.add(this.bit8);
        this.groupBitpix.add(this.bit16);
        this.groupBitpix.add(this.bit32);
        this.groupBitpix.add(this.bit_32);
        this.groupBitpix.add(this.bit_64);
    }

    @Override
    public void show() {
        super.show();
        this.mainPanel.init();
        this.mainPanel.resumeWidgets();
    }

    private String getCoverageString() {
        double cov = this.context.getIndexSkyArea();
        if (cov == 1.0) {
            return "whole sky ";
        }
        double degrad = Math.toDegrees(1.0);
        double skyArea = Math.PI * 4 * degrad * degrad;
        return Util.round(cov * 100.0, 3) + "% of sky => " + Coord.getUnit(skyArea * cov, false, true) + "^2 ";
    }

    protected void resumeWidgets() {
        try {
            boolean isRunning = this.context.isTaskRunning();
            boolean isMap = this.context.isMap();
            boolean isFile = this.context.isInputFile;
            boolean readyToDo = (isFile || isMap || this.context.isExistingDir()) && this.mainPanel.tabDesc.outputField.getText().trim().length() > 0;
            boolean isExistingMoc = this.context.getMocIndex() != null;
            this.moc.setEnabled(isExistingMoc);
            this.note.setText("<html><i>(*) " + this.getCoverageString() + "</i></html>");
            this.previous.setEnabled(readyToDo && !isRunning);
            this.next.setEnabled(readyToDo && !isRunning && this.context.isExistingAllskyDir());
            this.start.setEnabled(readyToDo && !isRunning && !isRunning);
            this.pause.setEnabled(isRunning);
            this.abort.setEnabled(readyToDo && isRunning);
            this.bit8.setEnabled(readyToDo && !isRunning && this.bitpixOrig != 0);
            this.bit16.setEnabled(readyToDo && !isRunning && this.bitpixOrig != 0);
            this.bit32.setEnabled(readyToDo && !isRunning && this.bitpixOrig != 0);
            this.bit_32.setEnabled(readyToDo && !isRunning && this.bitpixOrig != 0);
            this.bit_64.setEnabled(readyToDo && !isRunning && this.bitpixOrig != 0);
            this.samplFast.setEnabled(readyToDo && !isRunning && !isMap);
            this.overlayFast.setEnabled(readyToDo && !isRunning && !isMap);
            this.samplBest.setEnabled(readyToDo && !isRunning && !isMap);
            this.overlayBest.setEnabled(readyToDo && !isRunning && !isMap);
            this.fading.setEnabled(readyToDo && !isRunning && !isMap);
            tab.setBackground(readyToDo && !isRunning ? Color.white : this.getBackground());
            this.setCursor(isRunning ? Cursor.getPredefinedCursor(3) : Cursor.getPredefinedCursor(0));
            tab.refresh();
            if (!isRunning) {
                if (isMap) {
                    JProgressBar bar = ((ContextGui)this.context).mainPanel.getProgressBarIndex();
                    bar.setValue(bar.getMaximum());
                    bar.setString("No indexation for map!");
                } else if (this.context.moc == null) {
                    JProgressBar bar = ((ContextGui)this.context).mainPanel.getProgressBarIndex();
                    bar.setValue(0);
                    bar.setString("");
                    bar = ((ContextGui)this.context).mainPanel.getProgressBarTile();
                    bar.setValue(0);
                    bar.setString("");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void clearForms() {
        this.bitpixOrig = -1;
        this.bit8.setSelected(false);
        this.bit16.setSelected(false);
        this.bit32.setSelected(true);
        this.bit_32.setSelected(false);
        this.bit_64.setSelected(false);
        this.samplBest.setSelected(true);
        this.overlayBest.setSelected(true);
        this.fading.setSelected(true);
        tab.reset();
        this.resumeWidgets();
    }

    public int setSelectedOrder(int val) {
        int i = tab.setSelectedOrder(val);
        tab.setDefaultRow(i);
        tab.repaint();
        return i;
    }

    public int getOrder() {
        return tab.getOrder();
    }

    public void setOrder(int order) {
        this.setSelectedOrder(order);
    }

    public void setOriginalBitpixField(int bitpix) {
        this.bitpixOrig = bitpix;
        ((BitpixListener)this.bitpixListener).setDefault(bitpix);
        switch (bitpix) {
            case 0: {
                this.keepBB.doClick();
                break;
            }
            case 8: {
                this.bit8.doClick();
                break;
            }
            case 16: {
                this.bit16.doClick();
                break;
            }
            case 32: {
                this.bit32.doClick();
                break;
            }
            case -32: {
                this.bit_32.doClick();
                break;
            }
            case 64: {
                this.bit_64.doClick();
            }
        }
    }

    public int getOriginalBitpixField() {
        return this.bitpixOrig;
    }

    public int getBitpixField() {
        if (this.bitpixOrig == 0) {
            return 0;
        }
        ButtonModel b = this.groupBitpix.getSelection();
        int i = BuildTable.DEFAULT_BITPIX;
        try {
            i = Integer.parseInt(b.getActionCommand());
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return i;
    }

    protected int getNpix() {
        return this.context.isColor() ? 4 : Math.abs(this.getBitpixField()) / 8;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        tab.setBitpix(this.getBitpixField());
        if (e.getSource() == this.start) {
            this.perform();
        } else if (e.getSource() == this.abort) {
            this.abort();
        } else if (e.getSource() == this.pause) {
            this.pause();
        } else if (e.getSource() == this.moc) {
            this.loadMoc();
        } else if (e.getSource() == this.next) {
            this.mainPanel.showJpgTab();
        } else if (e.getSource() == this.previous) {
            this.mainPanel.showDescTab();
        }
        this.mainPanel.resumeWidgets();
        this.resumeWidgets();
    }

    private void pause() {
        if (this.context.isTaskPause()) {
            this.context.setTaskPause(false);
            this.pause.setText(this.getString("PAUSE"));
        } else {
            this.context.setTaskPause(true);
            this.pause.setText(this.getString("RESUME"));
        }
    }

    private void abort() {
        if (!Aladin.confirmation(this.mainPanel, "Do you really want to abort the HEALPix survey computation ?")) {
            return;
        }
        this.context.taskAbort();
    }

    private void perform() {
        block9: {
            try {
                Vector<Action> actions = new Vector<Action>();
                boolean isMap = this.context.isMap();
                if (!isMap) {
                    if (this.mainPanel.tabDesc.isResetIndex()) {
                        actions.add(Action.CLEANINDEX);
                    }
                    actions.add(Action.INDEX);
                }
                if (this.mainPanel.tabDesc.isResetTiles()) {
                    actions.add(Action.CLEANTILES);
                }
                if (isMap) {
                    actions.add(Action.MAPTILES);
                } else {
                    actions.add(Action.TILES);
                }
                if (!this.context.isColor()) {
                    actions.add(Action.GZIP);
                    if (!isMap) {
                        actions.add(Action.DETAILS);
                    }
                }
                new Task(this.context, actions, false);
            }
            catch (Exception e1) {
                Aladin.warning(e1.getMessage());
                if (Aladin.levelTrace < 3) break block9;
                e1.printStackTrace();
            }
        }
    }

    class MethodSelectListener
    implements ActionListener {
        private JRadioButton samplFast = null;
        private JRadioButton overlayFast = null;
        private JRadioButton samplBest = null;
        private JRadioButton overlayBest = null;
        private JCheckBox fading = null;

        public MethodSelectListener(JRadioButton[] buttons, JCheckBox fading) {
            this.samplFast = buttons[0];
            this.overlayFast = buttons[1];
            this.samplBest = buttons[2];
            this.overlayBest = buttons[3];
            this.fading = fading;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == this.samplFast && !this.overlayFast.isSelected()) {
                this.overlayFast.doClick();
            }
            if (source == this.overlayFast && !this.samplFast.isSelected()) {
                this.samplFast.doClick();
            }
            if (source == this.samplBest && !this.overlayBest.isSelected()) {
                this.overlayBest.doClick();
            }
            if (source == this.overlayBest && !this.samplBest.isSelected()) {
                this.samplBest.doClick();
            }
            this.fading.setEnabled(this.samplBest.isSelected());
        }
    }

    class BitpixListener
    implements ActionListener {
        int defaultBitpix = BuildTable.DEFAULT_BITPIX;
        JCheckBox check = null;

        public BitpixListener(JCheckBox keepCheckBox) {
            this.check = keepCheckBox;
        }

        public void setDefault(int bitpix) {
            this.defaultBitpix = bitpix;
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            int i = Integer.parseInt(arg0.getActionCommand());
            if (i == this.defaultBitpix) {
                this.setKeepOn();
            } else {
                this.setKeepOff();
            }
        }

        private void setKeepOn() {
            this.check.setEnabled(true);
            this.check.setSelected(true);
        }

        private void setKeepOff() {
            this.check.setSelected(false);
            this.check.setEnabled(false);
        }
    }
}

