/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

import cds.aladin.MyInputStream;
import cds.aladin.MyProperties;
import cds.allsky.Action;
import cds.allsky.Context;
import cds.allsky.Mode;
import cds.allsky.Task;
import cds.moc.HealpixMoc;
import cds.tools.Util;
import java.io.File;
import java.io.FileInputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Set;
import java.util.TimeZone;
import java.util.Vector;

public class HipsGen {
    private File file;
    private boolean force = false;
    private boolean flagMode = false;
    private boolean flagMethod = false;
    private boolean flagFading = false;
    private boolean flagAbort = false;
    private boolean flagPause = false;
    private boolean flagResume = false;
    public Context context = new Context();
    public String launcher = "Aladin.jar -hipsgen";
    private Vector<Action> actions = new Vector();
    public static SimpleDateFormat SDF = new SimpleDateFormat("dd/MM/yy HH:mm:ss");

    private void parseConfig() throws Exception {
        MyProperties properties = new MyProperties();
        FileInputStream reader = new FileInputStream(this.file);
        properties.load(reader);
        Set<Object> keys = properties.keySet();
        for (Object opt : keys) {
            String val = properties.getProperty((String)opt);
            try {
                this.setContextFromOptions((String)opt, val);
            }
            catch (Exception e) {
                e.printStackTrace();
                break;
            }
        }
        reader.close();
    }

    private void setContextFromOptions(String opt, String val) throws Exception {
        val = val.replace("'", "");
        val = val.replace("\"", "");
        System.out.println("OPTION: " + opt + "=" + val);
        if (opt.equalsIgnoreCase("h")) {
            HipsGen.usage(this.launcher);
        } else if (opt.equalsIgnoreCase("verbose")) {
            Context.setVerbose(Integer.parseInt(val));
        } else if (opt.equalsIgnoreCase("blank")) {
            this.context.setBlankOrig(Double.parseDouble(val));
        } else if (opt.equalsIgnoreCase("order")) {
            this.context.setOrder(Integer.parseInt(val));
        } else if (opt.equalsIgnoreCase("minOrder")) {
            this.context.setMinOrder(Integer.parseInt(val));
        } else if (opt.equalsIgnoreCase("mocOrder")) {
            this.context.setMocOrder(Integer.parseInt(val));
        } else if (opt.equalsIgnoreCase("tileOrder")) {
            this.context.setTileOrder(Integer.parseInt(val));
        } else if (opt.equalsIgnoreCase("bitpix")) {
            this.context.setBitpix(Integer.parseInt(val));
        } else if (opt.equalsIgnoreCase("frame")) {
            this.context.setFrameName(val);
        } else if (opt.equalsIgnoreCase("maxThread")) {
            this.context.setMaxNbThread(Integer.parseInt(val));
        } else if (opt.equalsIgnoreCase("skyval")) {
            this.context.setSkyval(val);
        } else if (opt.equalsIgnoreCase("exptime")) {
            this.context.setExpTime(val);
        } else if (opt.equalsIgnoreCase("fading")) {
            this.context.setFading(val);
            this.flagFading = true;
        } else if (opt.equalsIgnoreCase("mixing")) {
            this.context.setMixing(val);
        } else if (opt.equalsIgnoreCase("color")) {
            this.context.setColor(val);
        } else if (opt.equalsIgnoreCase("red")) {
            this.context.setRgbInput(val, 0);
        } else if (opt.equalsIgnoreCase("green")) {
            this.context.setRgbInput(val, 1);
        } else if (opt.equalsIgnoreCase("blue")) {
            this.context.setRgbInput(val, 2);
        } else if (opt.equalsIgnoreCase("redparam")) {
            this.context.setRgbCmParam(val, 0);
        } else if (opt.equalsIgnoreCase("greenparam")) {
            this.context.setRgbCmParam(val, 1);
        } else if (opt.equalsIgnoreCase("blueparam")) {
            this.context.setRgbCmParam(val, 2);
        } else if (opt.equalsIgnoreCase("img")) {
            this.context.setImgEtalon(val);
        } else if (opt.equalsIgnoreCase("fitskeys")) {
            this.context.setIndexFitskey(val);
        } else if (opt.equalsIgnoreCase("publisher")) {
            this.context.setPublisher(val);
        } else if (opt.equalsIgnoreCase("target")) {
            this.context.setTarget(val);
        } else if (opt.equalsIgnoreCase("targetRadius")) {
            this.context.setTargetRadius(val);
        } else if (opt.equalsIgnoreCase("label")) {
            this.context.setLabel(val);
        } else if (opt.equalsIgnoreCase("hdu")) {
            this.context.setHDU(val);
        } else if (opt.equalsIgnoreCase("debug")) {
            if (Boolean.parseBoolean(val)) {
                Context.setVerbose(4);
            }
        } else if (opt.equalsIgnoreCase("in") || opt.equalsIgnoreCase("input")) {
            this.context.setInputPath(val);
        } else if (opt.equalsIgnoreCase("out") || opt.equalsIgnoreCase("output")) {
            this.context.setOutputPath(val);
        } else if (opt.equalsIgnoreCase("mode") || opt.equalsIgnoreCase("pixel")) {
            if (opt.equalsIgnoreCase("pixel")) {
                this.context.warning("Prefer \"mode\" instead of \"pixel\"");
            }
            this.context.setMode(Mode.valueOf(val.toUpperCase()));
            this.flagMode = true;
        } else if (opt.equalsIgnoreCase("region") || opt.equalsIgnoreCase("moc")) {
            if (val.endsWith("fits")) {
                HealpixMoc moc = new HealpixMoc();
                moc.read(val);
                this.context.setMocArea(moc);
            } else {
                this.context.setMocArea(val);
            }
        } else if (opt.equalsIgnoreCase("blocking") || opt.equalsIgnoreCase("cutting") || opt.equalsIgnoreCase("partitioning")) {
            this.context.setPartitioning(val);
        } else if (opt.equalsIgnoreCase("shape")) {
            this.context.setShape(val);
        } else if (opt.equalsIgnoreCase("maxRatio")) {
            try {
                this.context.setMaxRatio(val);
            }
            catch (ParseException e) {
                throw new Exception(e.getMessage());
            }
        } else if (opt.equalsIgnoreCase("circle") || opt.equalsIgnoreCase("radius")) {
            try {
                this.context.setCircle(val);
            }
            catch (ParseException e) {
                throw new Exception(e.getMessage());
            }
        } else if (opt.equalsIgnoreCase("polygon") || opt.equalsIgnoreCase("fov")) {
            try {
                this.context.setPolygon(val);
            }
            catch (ParseException e) {
                throw new Exception(e.getMessage());
            }
        } else if (opt.equalsIgnoreCase("border")) {
            try {
                this.context.setBorderSize(val);
            }
            catch (ParseException e) {
                throw new Exception(e.getMessage());
            }
        } else if (opt.equalsIgnoreCase("jpegMethod") || opt.equalsIgnoreCase("method")) {
            if (opt.equalsIgnoreCase("jpegMethod")) {
                this.context.warning("Prefer \"method\" instead of \"" + opt + "\"");
            }
            this.flagMethod = true;
            this.context.setMethod(val);
        } else if (opt.equalsIgnoreCase("pixelGood")) {
            this.context.setPixelGood(val);
        } else if (opt.equalsIgnoreCase("pixelCut")) {
            this.context.setPixelCut(val);
        } else if (opt.equalsIgnoreCase("pixelRange") || opt.equalsIgnoreCase("dataCut")) {
            if (opt.equalsIgnoreCase("dataCut")) {
                this.context.warning("Prefer \"pixelRange\" instead of \"dataCut\"");
            }
            this.context.setDataCut(val);
        } else {
            throw new Exception("Option unknown [" + opt + "]");
        }
    }

    public void execute(String[] args) {
        int length = args.length;
        boolean first = true;
        if (length == 0) {
            HipsGen.usage(this.launcher);
            return;
        }
        for (String arg : args) {
            String param = "-param=";
            if (arg.startsWith(param)) {
                try {
                    this.setConfigFile(arg.substring(param.length()));
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
            }
            if (arg.equalsIgnoreCase("-skygen") || arg.equalsIgnoreCase("-hipsgen")) continue;
            if (arg.equalsIgnoreCase("-h") || arg.equalsIgnoreCase("-help")) {
                HipsGen.usage(this.launcher);
                return;
            }
            if (first) {
                first = false;
                this.context.info("Starting HipsGen " + SDF.format(new Date()) + " (based on Aladin " + "v8.155" + ")...");
            }
            if (arg.equalsIgnoreCase("-debug") || arg.equalsIgnoreCase("-d")) {
                Context.setVerbose(4);
                continue;
            }
            if (arg.equalsIgnoreCase("-fast")) {
                this.context.mixing = true;
                continue;
            }
            if (arg.equalsIgnoreCase("-force") || arg.equalsIgnoreCase("-f")) {
                this.force = true;
                continue;
            }
            if (arg.equalsIgnoreCase("-n")) {
                this.context.fake = true;
                continue;
            }
            if (arg.contains("=")) {
                String[] opts = arg.split("=");
                try {
                    opts[0] = opts[0].substring(opts[0].indexOf(45) + 1);
                    this.setContextFromOptions(opts[0], opts[1]);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.context.error(e.getMessage());
                    return;
                }
            }
            try {
                Action a = Action.valueOf(arg.toUpperCase());
                if (a == Action.FINDER) {
                    a = Action.INDEX;
                }
                if (a == Action.PROGEN) {
                    a = Action.DETAILS;
                }
                if (a == Action.CONCAT && !this.flagMode) {
                    this.context.setMode(Mode.AVERAGE);
                }
                if (a == Action.ABORT) {
                    this.flagAbort = true;
                }
                if (a == Action.PAUSE) {
                    this.flagPause = true;
                }
                if (a == Action.RESUME) {
                    this.flagResume = true;
                }
                this.actions.add(a);
            }
            catch (Exception e) {
                this.context.error("Unknown skygen command [" + arg + "] !");
                return;
            }
        }
        if (this.flagAbort) {
            try {
                this.context.taskAbort();
            }
            catch (Exception e) {
                this.context.error(e.getMessage());
            }
            return;
        }
        if (this.flagPause) {
            try {
                this.context.setTaskPause(true);
            }
            catch (Exception e) {
                this.context.error(e.getMessage());
            }
            return;
        }
        if (this.flagResume) {
            try {
                this.context.setTaskPause(false);
            }
            catch (Exception e) {
                this.context.error(e.getMessage());
            }
            return;
        }
        boolean all = false;
        if (this.actions.size() == 0) {
            all = true;
            boolean flagMapFits = false;
            File f = new File(this.context.getInputPath());
            if (!f.isDirectory() && f.exists()) {
                try {
                    MyInputStream in = new MyInputStream(new FileInputStream(f));
                    in = in.startRead();
                    flagMapFits = (in.getType() & 0x100000000L) != 0L;
                    in.close();
                    this.context.setMap(flagMapFits);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (flagMapFits) {
                this.actions.add(Action.MAPTILES);
            } else {
                this.actions.add(Action.INDEX);
                this.actions.add(Action.TILES);
            }
            if (!this.context.isColor()) {
                this.actions.add(Action.GZIP);
                this.actions.add(Action.PNG);
                if (!flagMapFits) {
                    this.actions.add(Action.DETAILS);
                }
            }
        }
        if (this.context.isColor() && !this.flagMethod) {
            this.context.setJpegMethod(Context.JpegMethod.MEDIAN);
        }
        if (this.context.getMode() == Mode.ADD) {
            this.context.setFading(false);
            this.context.setPartitioning("false");
            this.context.setMixing("true");
            this.context.info("Pixel mode=ADD => fading, partitioning and no mixing parameter ignored");
        }
        if (this.force) {
            this.context.setIgnoreStamp(true);
            if (all) {
                this.actions.add(0, Action.CLEAN);
            } else {
                for (int i = 0; i < this.actions.size(); ++i) {
                    Action a = this.actions.get(i);
                    if (a == Action.INDEX) {
                        this.actions.add(i, Action.CLEANINDEX);
                        ++i;
                        continue;
                    }
                    if (a == Action.DETAILS) {
                        this.actions.add(i, Action.CLEANDETAILS);
                        ++i;
                        continue;
                    }
                    if (a == Action.TILES) {
                        this.actions.add(i, Action.CLEANTILES);
                        ++i;
                        continue;
                    }
                    if (a == Action.MAPTILES) {
                        this.actions.add(i, Action.CLEANTILES);
                        ++i;
                        continue;
                    }
                    if (a == Action.JPEG) {
                        this.actions.add(i, Action.CLEANJPEG);
                        ++i;
                        continue;
                    }
                    if (a == Action.PNG) {
                        this.actions.add(i, Action.CLEANPNG);
                        ++i;
                        continue;
                    }
                    if (a != Action.CUBE) continue;
                    this.actions.add(i, Action.CLEAN);
                    ++i;
                }
            }
        }
        if (this.context.fake) {
            this.context.warning("NO RUN MODE (option -n), JUST PRINT INFORMATION !!!");
        }
        for (Action a : this.actions) {
            this.context.info("Action => " + (Object)((Object)a) + ": " + a.doc());
        }
        this.setDefaultFrame();
        try {
            long t = System.currentTimeMillis();
            new Task(this.context, this.actions, true);
            this.context.done("=================== THE END (done in " + Util.getTemps(System.currentTimeMillis() - t) + ") =======================");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.context.error(e.getMessage());
            return;
        }
    }

    private void setDefaultFrame() {
        if (this.context.hasFrame()) {
            return;
        }
        String path = this.context.getOutputPath();
        String frame = null;
        try {
            String propFile = path + Util.FS + "properties";
            MyProperties prop = new MyProperties();
            File f = new File(propFile);
            if (f.exists()) {
                FileInputStream in = new FileInputStream(propFile);
                prop.load(in);
                in.close();
                String s = prop.getProperty("hips_frame");
                if (s == null) {
                    s = prop.getProperty("coordsys");
                }
                frame = s != null && s.length() > 0 ? s : "galactic";
            } else {
                frame = this.context.isExistingAllskyDir() ? "galactic" : "equatorial";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.context.setFrameName(frame);
    }

    public void executeAsync(String[] args) {
        new ExecuteAsyncThread(args);
    }

    private static void usage(String launcher) {
        System.out.println("Usage: java -jar " + launcher + " in=file|dir [otherParams ... ACTIONs ...]");
        System.out.println("       java -jar " + launcher + " -param=configfile\n");
        System.out.println("The config file must contain these following options, or use them\ndirectly on the comand line :\n");
        System.out.println("Required parameter:\n   in=dir             Source image directory (FITS or JPEG|PNG +hhh or HiPS),\n                      unique image or HEALPix map file\n\nBasic optional parameters:\n   out=dir            HiPS target directory (default $PWD+\"HiPS\")\n   label=name         Label of the survey (by default, input directory name)\n   publisher=name     Name of the person|institute who builds the HiPS\n   hdu=n1,n2-n3,...|all  List of HDU numbers (0 is the primary HDU - default is 0)\n   blank=nn           Specifical BLANK value\n   skyval=true|key    Fits key to use for removing a sky background, true for automatic detection\n   color=jpeg|png     The source images are colored images (jpg or png) and the tiles will be produced in jpeg (resp. png)\n   shape=...          Shape of the observations (ellipse|rectangle)\n   border=...         Margins (in pixels) to ignore in the original observations (N W S E or constant)\n   fov=true|x1,y1..   Observed regions by files.fov or global polygon (in FITS convention).\n   verbose=n          Debug information from -1 (nothing) to 4 (a lot)\n   -f                 clear previous computations\n   -n                 Just print process information, but do not execute it.\n\nAdvanced optional parameters:\n   order=nn           Specifical HEALPix order - by default, adapted to the original resolution\n   bitpix=nn          Specifical target bitpix (-64|-32|8|16|32|64)\n   pixelCut=min max   Specifical pixel cut and/or transfert function for PNG/JPEG 8 bits\n                      conversion - ex: \"120 140 log\")\n   pixelRange=min max Specifical pixel value range (required for bitpix\n                      conversion, or for removing bad pixels - ex: \"-5 110\")\n   pixelGood=min [max] Range of pixel values kept\n   img=file           Specifical reference image for default initializations \n                      (BITPIX,BSCALE,BZERO,BLANK,order,pixelCut,dataRange)\n   mode=xx            Coadd mode when restart: pixel level(OVERWRITE|KEEP|ADD|AVERAGE) \n                      or tile level (REPLACETILE|KEEPTILE) - (default OVERWRITE)\n                      Or LINK|COPY for CUBE action (default COPY)\n   fading=true|false  False to avoid fading effect on overlapping original images (default is true)\n   mixing=true|false  False to avoid mixing (and fading) effect on overlapping original images (default is true)\n   partitioning=true|false True for cutting large original images in blocks of 1024x1024 (default is true)\n   region=moc         Specifical HEALPix region to compute (ex: 3/34-38 50 53)\n                      or Moc.fits file (all sky by default)\n   maxRatio=nn        Max pixel height width pixel ratio tolerated for original obs (default 2, 0 for removing the test)\n   fitskeys=list      Fits key list (blank separator) designing metadata FITS keyword value to memorized in the HiPS index\n   minOrder=nn        Specifical HEALPix min order (only for DETAILS action)\n   method=m           Method (MEDIAN|MEAN|FIRST) (default MEDIAN) for aggregating colored compressed tiles (JPEG|PNG)\n   tileOrder=nn       Specifical tile order - default 9\n   mocOrder=nn        Specifical HEALPix MOC order (only for MOC action) - by default auto-adapted to the HiPS\n   maxThread=nn       Max number of computing threads\n   target=ra +dec     Default HiPS target (ICRS deg)\n   targetRadius=rad   Default HiPS radius view (deg)\n");
        System.out.println("\nSpecifical actions (by default: \"INDEX TILES PNG GZIP DETAILS\"):\n   INDEX      " + Action.INDEX.doc() + "\n" + "   TILES      " + Action.TILES.doc() + "\n" + "   JPEG       " + Action.JPEG.doc() + "\n" + "   PNG        " + Action.PNG.doc() + "\n" + "   MOC        " + Action.MOC.doc() + "\n" + "   ALLSKY     " + Action.ALLSKY.doc() + "\n" + "   TREE       " + Action.TREE.doc() + "\n" + "   MAPTILES   " + Action.MAPTILES.doc() + "\n" + "   CONCAT     " + Action.CONCAT.doc() + "\n" + "   CUBE       " + Action.CUBE.doc() + "\n" + "   GZIP       " + Action.GZIP.doc() + "\n" + "   CLEANFITS  " + Action.CLEANFITS.doc() + "\n" + "   DETAILS    " + Action.DETAILS.doc() + "\n");
        System.out.println("\nEx: java -jar " + launcher + " in=/MyImages    => Do all the job." + "\n    java -jar " + launcher + " in=/MyImages bitpix=16 pixelCut=\"-1 100 log\" => Do all the job" + "\n           The FITS tiles will be coded in short integers, the preview tiles" + "\n           will map the physical values [-1..100] with a log function contrast in [0..255]." + "\n    java -jar " + launcher + " in=/MyImages blank=0 border=\"100 50 100 50\" mode=REPLACETILE    => recompute tiles" + "\n           The original pixels in the border or equal to 0 will be ignored." + "\n    java -jar " + launcher + " in=HiPS out=HiPStarget CONCAT   => Concatenate HiPS to HiPStarget");
    }

    private void setConfigFile(String configfile) throws Exception {
        this.file = new File(configfile);
        this.parseConfig();
    }

    public static void main(String[] args) {
        HipsGen generator = new HipsGen();
        generator.launcher = "HipsGen";
        generator.execute(args);
    }

    static {
        SDF.setTimeZone(TimeZone.getDefault());
    }

    class ExecuteAsyncThread
    extends Thread {
        String[] args;

        public ExecuteAsyncThread(String[] args) {
            this.args = args;
            this.start();
        }

        @Override
        public void run() {
            HipsGen.this.execute(this.args);
        }
    }
}

