/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.PlanBG;
import cds.aladin.PlanImage;
import cds.aladin.TreeNodeAllsky;
import cds.allsky.Action;
import cds.allsky.BuilderAllsky;
import cds.allsky.Context;
import cds.allsky.MainPanel;
import cds.allsky.TransfertFct;
import cds.fits.CacheFits;
import cds.tools.pixtools.CDSHealpix;
import cds.tools.pixtools.Util;
import java.io.File;
import java.text.ParseException;
import javax.swing.JProgressBar;

public class ContextGui
extends Context {
    protected MainPanel mainPanel;
    private int lastShowAllSkyNorder3 = -1;
    private PreviewThread previewThread = null;

    public void setMainPanel(MainPanel mainPanel) {
        this.mainPanel = mainPanel;
    }

    @Override
    public int[] getBorderSize() {
        try {
            this.setBorderSize(this.mainPanel.tabDesc.getBorderSize().trim());
        }
        catch (ParseException e) {
            this.mainPanel.tabDesc.borderTextField.setText("Border error => assume 0");
            e.printStackTrace();
        }
        return this.borderSize;
    }

    @Override
    public void setOrder(int order) {
        this.mainPanel.tabBuild.setOrder(order);
    }

    @Override
    public int getOrder() {
        return this.mainPanel.tabBuild.getOrder();
    }

    @Override
    protected void showIndexStat(int statNbFile, int statBlocFile, int statNbZipFile, long statMemFile, long statPixSize, long statMaxSize, int statMaxWidth, int statMaxHeight, int statMaxDepth, int statMaxNbyte, long statDuree) {
        this.mainPanel.tabBuild.buildProgressPanel.setSrcStat(statNbFile, statNbZipFile, statMemFile, statMaxSize, statMaxWidth, statMaxDepth, statMaxHeight, statMaxNbyte);
    }

    @Override
    protected void showTilesStat(int statNbThreadRunning, int statNbThread, long totalTime, int statNbTile, int statNbEmptyTile, int statNodeTile, long statMinTime, long statMaxTime, long statAvgTime, long statNodeAvgTime, long usedMem, long deltaTime, long deltaNbTile) {
        if (statNbTile == 0) {
            return;
        }
        int tileSide = this.getTileSide();
        this.mainPanel.tabBuild.buildProgressPanel.setMemStat(statNbThreadRunning, statNbThread, this.cacheFits);
        long nbLowCells = this.getNbLowCells();
        this.mainPanel.tabBuild.buildProgressPanel.setLowTileStat(statNbTile, statNbEmptyTile, nbLowCells, tileSide * tileSide * this.getNpix(), statMinTime, statMaxTime, statAvgTime);
        this.mainPanel.tabBuild.buildProgressPanel.setNodeTileStat(statNodeTile, tileSide * tileSide * this.getNpix(), statNodeAvgTime);
        long nbCells = this.getNbLowCells();
        long nbLowTile = statNbTile + statNbEmptyTile;
        long tempsTotalEstime = nbLowTile == 0L ? 0L : (nbCells == 0L ? 0L : nbCells * (totalTime / nbLowTile) - totalTime);
        long nbTilesPerMin = deltaNbTile * 60000L / deltaTime;
        this.mainPanel.tabBuild.buildProgressPanel.setTimeStat(totalTime, nbTilesPerMin, tempsTotalEstime);
        this.setProgress(statNbTile + statNbEmptyTile, nbLowCells);
    }

    @Override
    protected void showMapStat(long cRecord, long nbRecord, long cTime, CacheFits cache, String info) {
        double pourcent = (double)cRecord / (double)nbRecord;
        long totalTime = pourcent == 0.0 ? 0L : (long)((double)cTime / pourcent);
        long endsIn = totalTime == 0L ? 0L : totalTime - cTime;
        String s = cds.tools.Util.round(pourcent * 100.0, 1) + "% in " + cds.tools.Util.getTemps(cTime, true);
        if (endsIn > 0L) {
            s = s + " ends n=" + cds.tools.Util.getTemps(endsIn, true);
        }
        this.mainPanel.tabBuild.buildProgressPanel.setTimeStat(s);
        s = "Records: " + cRecord + " / " + nbRecord;
        this.mainPanel.tabBuild.buildProgressPanel.setLowTileStat(s);
        this.mainPanel.tabBuild.buildProgressPanel.setMemStat(1, 1, cache);
        this.mainPanel.tabBuild.buildProgressPanel.srcFileStat(info);
        this.setProgress(cRecord, nbRecord);
    }

    @Override
    protected void showJpgStat(int statNbFile, long totalTime, int statNbThread, int statNbThreadRunning) {
        long nbLowCells = this.getNbLowCells();
        long tempsTotalEstime = nbLowCells == 0L ? 0L : (statNbFile == 0 ? 0L : nbLowCells * (totalTime / (long)statNbFile) - totalTime);
        String s1 = statNbFile + " / " + nbLowCells + " tiles";
        String s2 = cds.tools.Util.getTemps(totalTime, true);
        if (tempsTotalEstime > 0L) {
            s2 = s2 + " - ends in " + cds.tools.Util.getTemps(tempsTotalEstime, true);
        }
        this.mainPanel.tabJpg.setStat(s1, s2);
        this.setProgress(statNbFile, nbLowCells);
    }

    @Override
    protected void showRgbStat(int statNbFile, long statSize, long totalTime) {
        this.mainPanel.tabRgb.setStat(statNbFile, statSize, totalTime);
    }

    public void updateHipsPreview(boolean force) {
        if (!force) {
            if (this.previewThread != null) {
                return;
            }
            if (this.lastShowAllSkyNorder3 == this.lastNorder3) {
                return;
            }
        }
        this.lastShowAllSkyNorder3 = this.lastNorder3;
        if (this.previewThread != null) {
            this.previewThread.abort();
            this.previewThread = null;
        }
        this.previewThread = new PreviewThread(this);
        this.previewThread.start();
    }

    @Override
    public void progressStatus() {
        if (this.progressBar == null) {
            super.progressStatus();
            return;
        }
        if (this.progressMax <= 0.0) {
            this.progressBar.setIndeterminate(true);
            this.progressBar.setValue((int)this.progress);
        } else {
            this.progressBar.setIndeterminate(false);
            this.progressBar.setMaximum((int)this.progressMax);
            this.progressBar.setValue((int)this.progress);
        }
        if ((this.action == Action.TILES || this.action == Action.JPEG || this.action == Action.PNG || this.action == Action.RGB) && this.lastNorder3 >= 0) {
            this.updateHipsPreview(false);
        }
    }

    @Override
    public void endAction() throws Exception {
        if (this.progressBar != null) {
            this.progressBar.setIndeterminate(false);
            this.progressBar.setMaximum(100);
            this.progressBar.setValue(100);
            if (this.action == null) {
                this.progressBar.setString("Already done !");
            } else if (this.taskAborting) {
                this.progressBar.setString("Aborted !");
            } else {
                this.progressBar.setString("Done !");
            }
        }
        if ((this.action == Action.TILES || this.action == Action.MAPTILES || this.action == Action.JPEG || this.action == Action.PNG || this.action == Action.RGB) && this.lastNorder3 >= 0) {
            this.updateHipsPreview(true);
        }
        if (this.action == Action.INDEX) {
            this.mainPanel.tabBuild.resumeWidgets();
        }
        super.endAction();
    }

    @Override
    public void setTaskPause(boolean flag) {
        super.setTaskPause(flag);
        if (this.progressBar != null) {
            if (flag) {
                this.progressBar.setIndeterminate(true);
                this.progressBar.setString("pause");
            } else {
                this.progressBar.setIndeterminate(false);
                this.progressBar.setString(null);
            }
        }
    }

    @Override
    public void enableProgress(boolean flag) {
        if (this.progressBar == null) {
            super.enableProgress(flag);
        } else {
            this.progressBar.setEnabled(flag);
        }
    }

    @Override
    public void resumeWidgets() {
        this.mainPanel.resumeWidgets();
    }

    @Override
    public void setProgressBar(JProgressBar bar) {
        this.progressBar = bar;
        this.progressBar.setString(null);
    }

    public void setRgbPlans(Object[] plans) {
        this.plansRgb = plans;
    }

    public void setRgbOutput(String output) {
        this.outputRgb = output;
    }

    public void setRgbMethod(Context.JpegMethod method) {
        this.methodRgb = method;
    }

    public Object[] getRgbPlans() {
        return this.plansRgb;
    }

    public String getRgbOutput() {
        return this.outputRgb;
    }

    public Context.JpegMethod getRgbMethod() {
        return this.methodRgb;
    }

    public int getRgbFormat() {
        return this.targetColorMode;
    }

    public void setRgbFormat(int format) {
        this.targetColorMode = format;
    }

    @Override
    public String getInputPath() {
        return this.mainPanel.tabDesc.getInputField();
    }

    @Override
    public String getOutputPath() {
        return this.mainPanel.tabDesc.getOutputField();
    }

    @Override
    public void setOutputPath(String output) {
        this.mainPanel.tabDesc.setOutputField(output);
    }

    @Override
    public int getBitpixOrig() {
        return this.mainPanel.tabBuild.getOriginalBitpixField();
    }

    @Override
    public int getBitpix() {
        return this.mainPanel.tabBuild.getBitpixField();
    }

    @Override
    public double getBlankOrig() {
        double b = Double.NaN;
        this.hasAlternateBlank = false;
        String s = "";
        try {
            s = this.mainPanel.tabDesc.getBlank().trim();
            if (s.length() > 0) {
                b = Double.parseDouble(s);
                this.hasAlternateBlank = true;
            }
        }
        catch (Exception e) {
            this.mainPanel.tabDesc.blankTextField.setText("Unknown value => [" + s + "]");
        }
        return b;
    }

    @Override
    public int[] getHDU() {
        String s = "";
        try {
            s = this.mainPanel.tabDesc.getHDU().trim();
            this.hdu = ContextGui.parseHDU(s);
        }
        catch (Exception e) {
            this.mainPanel.tabDesc.blankTextField.setText("Syntax error => [" + s + "]");
        }
        return this.hdu;
    }

    @Override
    public void initParameters() throws Exception {
        this.setMocArea(this.mainPanel.tabDesc.getMocField().trim());
        this.setMode(this.mainPanel.tabDesc.getCoaddModeField());
        this.setSkyValName(this.mainPanel.tabDesc.getSkyvalField());
        super.initParameters();
    }

    @Override
    public String getSkyval() {
        this.skyvalName = this.mainPanel.tabDesc.getSkyvalField().toUpperCase();
        return this.skyvalName;
    }

    @Override
    public String getLabel() {
        return this.mainPanel.tabDesc.getLabelField();
    }

    @Override
    public TransfertFct getFct() throws Exception {
        if (this.mainPanel.tabJpg.isCutFromPlanBase()) {
            PlanImage p = (PlanImage)this.mainPanel.aladin.calque.getPlanBase();
            return TransfertFct.getFromCode(p.transfertFct);
        }
        return super.getFct();
    }

    @Override
    public double[] getPixelRangeCut() throws Exception {
        double[] cut = new double[5];
        for (int i = 0; i < 4; ++i) {
            cut[i] = Double.NaN;
        }
        if (this.mainPanel.tabJpg.isCutFromPlanBase()) {
            PlanImage p = (PlanImage)this.mainPanel.aladin.calque.getPlanBase();
            cut[0] = p.getCutMin() * p.bScale + p.bZero;
            cut[1] = p.getCutMax() * p.bScale + p.bZero;
        } else {
            String cutMin = this.mainPanel.tabJpg.getCutMin();
            String cutMax = this.mainPanel.tabJpg.getCutMax();
            try {
                cut[0] = Double.parseDouble(cutMin);
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                cut[1] = Double.parseDouble(cutMax);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return cut;
    }

    @Override
    public void setCutOrig(double[] c) {
        super.setCutOrig(c);
        this.mainPanel.tabJpg.setCutMin(cds.tools.Util.myRound(c[0] * this.bScaleOrig + this.bZeroOrig));
        this.mainPanel.tabJpg.setCutMax(cds.tools.Util.myRound(c[1] * this.bScaleOrig + this.bZeroOrig));
    }

    @Override
    public void running(String string) {
        this.trace(3, "RUN   : " + string);
    }

    public void nldone(String string) {
        this.trace(3, "DONE  : " + string);
    }

    @Override
    public void done(String string) {
        this.trace(3, "DONE  : " + string);
    }

    @Override
    public void info(String string) {
        this.trace(3, "INFO  : " + string);
    }

    @Override
    public void warning(String string) {
        Aladin cfr_ignored_0 = this.mainPanel.aladin;
        Aladin.warning(this.mainPanel, string);
        this.trace(3, "WARN  : " + string);
    }

    @Override
    public void error(String string) {
        Aladin cfr_ignored_0 = this.mainPanel.aladin;
        Aladin.warning(this.mainPanel, string);
        this.trace(3, "ERROR : " + string);
    }

    @Override
    public void action(String string) {
        this.trace(3, "ACTION: " + string);
    }

    public void nlstat(String string) {
        this.trace(3, "STAT  : " + string);
    }

    @Override
    public void trace(int i, String string) {
        Aladin.trace(i, string);
    }

    class PreviewThread
    extends Thread {
        Context context;
        BuilderAllsky builder = null;

        PreviewThread(Context context) {
            this.context = context;
        }

        protected void abort() {
            this.builder.abort();
        }

        @Override
        public void run() {
            try {
                String path = ContextGui.this.getOutputPath() + cds.tools.Util.FS + "Norder3";
                if (!ContextGui.this.isExistingAllskyDir() || !new File(path).isDirectory()) {
                    throw new Exception("order3 tiles not found");
                }
                this.builder = new BuilderAllsky(this.context);
                this.builder.run();
                String mysky = ContextGui.this.getLabel();
                if (mysky.trim().length() == 0) {
                    mysky = "MySky";
                }
                int npix = ContextGui.this.lastShowAllSkyNorder3 >= 0 ? ContextGui.this.lastShowAllSkyNorder3 : 0;
                ContextGui.this.mainPanel.planPreview = (PlanBG)ContextGui.this.mainPanel.aladin.calque.getPlan(mysky);
                if (ContextGui.this.mainPanel.planPreview == null || ContextGui.this.mainPanel.planPreview.isFree() || ContextGui.this.mainPanel.planPreview.hasError()) {
                    double[] res = CDSHealpix.pix2ang_nest(Util.nside(3), npix);
                    double[] radec = CDSHealpix.polarToRadec(new double[]{res[0], res[1]});
                    radec = ContextGui.this.gal2ICRSIfRequired(radec);
                    TreeNodeAllsky gSky = new TreeNodeAllsky(ContextGui.this.mainPanel.aladin, ContextGui.this.getOutputPath());
                    int n = ContextGui.this.mainPanel.aladin.calque.newPlanBG(gSky, ContextGui.this.getOutputPath(), null, "=" + mysky, Coord.getSexa(radec[0], radec[1]), "30");
                    Aladin.trace(4, "ContextGui.preview(): create " + mysky);
                    ContextGui.this.mainPanel.planPreview = (PlanBG)ContextGui.this.mainPanel.aladin.calque.getPlan(n);
                } else {
                    ContextGui.this.mainPanel.planPreview.forceReload();
                    ContextGui.this.mainPanel.aladin.calque.repaintAll();
                    Aladin.trace(4, "ContextGui.preview(): update " + mysky);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ContextGui.this.previewThread = null;
        }
    }
}

