/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.Localisation;
import cds.aladin.MyInputStream;
import cds.aladin.MyProperties;
import cds.aladin.PlanBG;
import cds.aladin.PlanImage;
import cds.aladin.Tok;
import cds.allsky.Action;
import cds.allsky.BuilderAllsky;
import cds.allsky.BuilderTiles;
import cds.allsky.Constante;
import cds.allsky.HipsGen;
import cds.allsky.Mode;
import cds.allsky.TransfertFct;
import cds.astro.Astrocoo;
import cds.astro.Astroframe;
import cds.astro.Galactic;
import cds.astro.ICRS;
import cds.fits.CacheFits;
import cds.fits.Fits;
import cds.fits.HeaderFits;
import cds.moc.HealpixMoc;
import cds.tools.pixtools.CDSHealpix;
import cds.tools.pixtools.Util;
import java.awt.Polygon;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JProgressBar;

public class Context {
    private static boolean verbose = false;
    protected String label;
    protected String inputPath;
    protected String outputPath;
    protected String hpxFinderPath;
    protected String imgEtalon;
    protected HeaderFits header = null;
    protected boolean isInputFile = false;
    public int depth = 1;
    protected boolean depthInit = false;
    public double crpix3 = 0.0;
    public double crval3 = 0.0;
    public double cdelt3 = 0.0;
    public String bunit3 = null;
    protected int[] hdu = null;
    public int bitpixOrig = -1;
    protected double blankOrig = Double.NaN;
    protected boolean hasAlternateBlank = false;
    public double bZeroOrig = 0.0;
    public double bScaleOrig = 1.0;
    protected boolean bscaleBzeroOrigSet = false;
    protected double[] cutOrig;
    protected double[] pixelRangeCut;
    public double[] pixelGood = null;
    public double[] good = null;
    public int[] borderSize = new int[]{0, 0, 0, 0};
    public Polygon polygon = null;
    public boolean scanFov = false;
    protected int circle = 0;
    public int dataArea = 0;
    public double maxRatio = 2.0;
    protected boolean fading = true;
    protected boolean mixing = true;
    protected boolean fake = false;
    protected boolean partitioning = true;
    public String skyvalName;
    public String expTimeName;
    protected double coef;
    protected ArrayList<String> fitsKeys = null;
    protected int typicalImgWidth = -1;
    protected int bitpix = -1;
    protected double blank = Double.NaN;
    protected double bzero = 0.0;
    protected double bscale = 1.0;
    protected double[] cut;
    protected TransfertFct fct = TransfertFct.LINEAR;
    private JpegMethod jpegMethod = JpegMethod.MEDIAN;
    protected Mode mode = Mode.getDefault();
    protected int maxNbThread = -1;
    protected String publisher = null;
    protected int order = -1;
    public int minOrder = -1;
    private int frame = -1;
    protected HealpixMoc mocArea = null;
    protected HealpixMoc mocIndex = null;
    protected HealpixMoc moc = null;
    protected int mocOrder = -1;
    protected int tileOrder = -1;
    protected CacheFits cacheFits;
    protected Vector<String> keyAddProp = null;
    protected Vector<String> valueAddProp = null;
    protected String target = null;
    protected String targetRadius = null;
    protected String resolution = null;
    protected int targetColorMode = 1;
    private String lastImgEtalon = null;
    private static int nbFiles;
    protected Object[] plansRgb;
    protected String outputRgb;
    protected JpegMethod methodRgb;
    private static final String[] LABELRGB;
    protected int lastNorder3 = -2;
    protected Action action = null;
    protected double progress = -1.0;
    protected double progressMax = Double.MAX_VALUE;
    protected JProgressBar progressBar = null;
    protected MyProperties prop = null;
    private boolean isMap = false;
    protected boolean ignoreStamp;
    private boolean taskRunning = false;
    private boolean taskPause = false;
    protected boolean taskAborting = false;
    private static SimpleDateFormat DATEFORMAT;
    private boolean flagNL = false;
    private boolean validateOutputDone = false;
    private boolean validateInputDone = false;
    private boolean validateCutDone = false;
    private static final Astrocoo COO_GAL;
    private static final Astrocoo COO_EQU;
    private static Astroframe AF_GAL1;
    private static Astroframe AF_ICRS1;
    private String INDEX = "<HTML>\n<HEAD>\n   <script type=\"text/javascript\" src=\"http://code.jquery.com/jquery-1.10.1.min.js\"></script>\n   <link rel=\"stylesheet\" href=\"http://aladin.u-strasbg.fr/AladinLite/api/v2/latest/aladin.min.css\" >\n   <script type=\"text/javascript\">var jqMenu = jQuery.noConflict();</script>\n   <script type=\"text/javascript\">\nvar hipsDir=null;</script>\n</HEAD>\n<H1>\"$LABEL\" progressive survey</H1>\nThis Web resource contains HiPS(*) components for <B>$LABEL</B> progressive survey.\n<script type=\"text/javascript\">\nhipsDir = location.href;\nhipsDir = hipsDir.substring(0,hipsDir.lastIndexOf(\"/\",hipsDir.length));\ndocument.getElementById(\"hipsBase\").innerHTML=hipsDir;\n</script>\n<TABLE>\n<TR>\n<TD>\n   <script type=\"text/javascript\" src=\"http://aladin.u-strasbg.fr/AladinLite/api/v2/latest/aladin.min.js\" charset=\"utf-8\"></script>\n<div id=\"aladin-lite-div\" style=\"width:350px;height:350px;\"></div>\n<script type=\"text/javascript\">\n//var hipsDir = location.href;\n//hipsDir = hipsDir.substring(0,hipsDir.lastIndexOf(\"/\",hipsDir.length));\nvar aladin = $.aladin(\"#aladin-lite-div\");\naladin.setImageSurvey(aladin.createImageSurvey('$LABEL', '$LABEL',\nhipsDir, '$SYS', $ORDER, {imgFormat: '$FMT'}));\n</script>    \n</TD>\n<TD>\n<UL>\n$INFO   <LI> <B>Raw property file:</B> <A HREF=\"properties\">properties</A>\n   <LI> <B>Base URL:<p id=\"hipsBase\"></p></B> \n</UL>\n</TD>\n</TR>\n</TABLE>\nThis survey can be displayed by <A HREF=\"http://aladin.u-strasbg.fr/AladinLite\">Aladin Lite</A> (see above), \nby <A HREF=\"http://aladin.u-strasbg.fr/java/nph-aladin.pl?frame=downloading\">Aladin Desktop</A> client\n(just open the base URL)<BR>or any other HiPS aware clients .\n<HR>\n<I>(*) The HiPS technology allows a dedicated client to access an astronomical survey at any location and at any scale. \nHiPS is based on HEALPix sky tessellation and it is designed for astronomical scientifical usages (low distorsion, true pixel values...).HiPS technical documentation is available <A HREF=\"http://aladin.u-strasbg.fr/HiPS/HiPS%20technical%20doc.pdf\">here<A></I>\n<script type=\"text/javascript\">\ndocument.getElementById(\"hipsBase\").innerHTML=hipsDir;\n</script>\n</HTML>\n";
    private transient boolean lock;
    private final Object lockObj = new Object();
    public int[] xy2hpx = null;
    public int[] hpx2xy = null;

    public void reset() {
        this.moc = null;
        this.mocIndex = null;
        this.mocArea = null;
        this.mode = Mode.getDefault();
        this.hasAlternateBlank = false;
        this.bscaleBzeroOrigSet = false;
        this.outputPath = null;
        this.inputPath = null;
        this.hpxFinderPath = null;
        this.imgEtalon = null;
        this.lastNorder3 = -2;
        this.validateCutDone = false;
        this.validateInputDone = false;
        this.validateOutputDone = false;
        this.isMap = false;
        this.prop = null;
        this.pixelGood = null;
        this.good = null;
        this.pixelRangeCut = null;
        this.depth = 1;
        this.depthInit = false;
        this.cdelt3 = 0.0;
        this.crval3 = 0.0;
        this.crpix3 = 0.0;
        this.bunit3 = null;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean getFading() {
        return this.fading;
    }

    public int[] getBorderSize() {
        int[] nArray;
        if (this.dataArea == 0) {
            nArray = this.borderSize;
        } else {
            int[] nArray2 = new int[4];
            nArray2[0] = 0;
            nArray2[1] = 0;
            nArray2[2] = 0;
            nArray = nArray2;
            nArray2[3] = 0;
        }
        return nArray;
    }

    public double getMaxRatio() {
        return this.maxRatio;
    }

    public int getOrder() {
        return this.order;
    }

    public boolean hasFrame() {
        return this.frame >= 0;
    }

    public int getFrame() {
        return this.hasFrame() ? this.frame : 0;
    }

    public String getFrameName() {
        return Localisation.getFrameName(this.getFrame());
    }

    public String getFrameCode() {
        return this.getFrame() == 3 ? "G" : "C";
    }

    public CacheFits getCache() {
        return this.cacheFits;
    }

    public String getInputPath() {
        return this.inputPath;
    }

    public String getOutputPath() {
        return this.outputPath;
    }

    public String getHpxFinderPath() {
        return this.hpxFinderPath != null ? this.hpxFinderPath : cds.tools.Util.concatDir(this.getOutputPath(), "HpxFinder");
    }

    public String getImgEtalon() {
        return this.imgEtalon;
    }

    public int getBitpixOrig() {
        return this.bitpixOrig;
    }

    public int getBitpix() {
        return this.isColor() ? this.bitpixOrig : this.bitpix;
    }

    public int getNpix() {
        return this.isColor() || this.bitpix == -1 ? 4 : Math.abs(this.bitpix) / 8;
    }

    public int getNpixOrig() {
        return this.isColor() || this.bitpixOrig == -1 ? 4 : Math.abs(this.bitpixOrig) / 8;
    }

    public double getBScaleOrig() {
        return this.bScaleOrig;
    }

    public double getBZeroOrig() {
        return this.bZeroOrig;
    }

    public double getBZero() {
        return this.bzero;
    }

    public double getBScale() {
        return this.bscale;
    }

    public double getBlank() {
        return this.blank;
    }

    public double getBlankOrig() {
        return this.blankOrig;
    }

    public boolean hasAlternateBlank() {
        return this.hasAlternateBlank;
    }

    public HealpixMoc getArea() {
        return this.mocArea;
    }

    public Mode getMode() {
        return this.mode;
    }

    public double[] getCut() throws Exception {
        return this.cut;
    }

    public double[] getCutOrig() throws Exception {
        return this.cutOrig;
    }

    public String getSkyval() {
        return this.skyvalName;
    }

    public boolean isColor() {
        return this.bitpixOrig == 0;
    }

    public boolean isCube() {
        return this.depth > 1;
    }

    public boolean isCubeCanal() {
        return this.crpix3 != 0.0 || this.crval3 != 0.0 || this.cdelt3 != 0.0;
    }

    public boolean isInMocTree(int order, long npix) {
        return this.moc == null || this.moc.isIntersecting(order, npix);
    }

    public boolean isInMoc(int order, long npix) {
        return this.moc == null || this.moc.isIntersecting(order, npix);
    }

    public boolean isMocDescendant(int order, long npix) {
        return this.moc == null || this.moc.isDescendant(order, npix);
    }

    public int getMaxNbThread() {
        return this.maxNbThread;
    }

    public int getMocOrder() {
        return this.mocOrder;
    }

    public int getMinOrder() {
        return this.minOrder;
    }

    public int getTileOrder() {
        return this.tileOrder == -1 ? 9 : this.tileOrder;
    }

    public int getTileSide() {
        return (int)CDSHealpix.pow2(this.getTileOrder());
    }

    public void setFlagInputFile(boolean flag) {
        this.isInputFile = flag;
    }

    public void setHeader(HeaderFits h) {
        this.header = h;
    }

    public void setPublisher(String s) {
        this.publisher = s;
    }

    public void setLabel(String s) {
        this.label = s;
    }

    public void setMaxNbThread(int max) {
        this.maxNbThread = max;
    }

    public void setFading(boolean fading) {
        this.fading = fading;
    }

    public void setFading(String s) {
        this.fading = !s.equalsIgnoreCase("false");
    }

    public void setMixing(String s) {
        this.mixing = !s.equalsIgnoreCase("false");
    }

    public void setPartitioning(String s) {
        this.partitioning = !s.equalsIgnoreCase("false");
    }

    public void setCircle(String r) throws Exception {
        this.circle = Integer.parseInt(r);
    }

    public void setMaxRatio(String r) throws Exception {
        this.maxRatio = Double.parseDouble(r);
    }

    public void setBorderSize(String borderSize) throws ParseException {
        this.borderSize = this.parseBorderSize(borderSize);
    }

    public void setBorderSize(int[] borderSize) {
        this.borderSize = borderSize;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void setMinOrder(int minOrder) {
        this.minOrder = minOrder;
    }

    public void setMocOrder(int mocOrder) {
        this.mocOrder = mocOrder;
    }

    public void setTileOrder(int tileOrder) {
        this.tileOrder = tileOrder;
    }

    public void setFrame(int frame) {
        this.frame = frame;
    }

    public void setFrameName(String frame) {
        this.frame = frame.equals("G") || frame.equals("galactic") ? 3 : (frame.equals("E") || frame.equals("ecliptic") ? 2 : 0);
    }

    public void setSkyValName(String s) {
        this.skyvalName = s;
        if (s == null) {
            return;
        }
        if (s.equalsIgnoreCase("true")) {
            this.info("Skyval automatical adjustement activated...");
        } else {
            this.info("Skyval adjustement based on the FITS keyword [" + s + "]");
        }
    }

    public int[] getHDU() {
        return this.hdu;
    }

    public void setHDU(String s) throws Exception {
        this.hdu = Context.parseHDU(s);
    }

    public void setShape(String s) {
        if (cds.tools.Util.indexOfIgnoreCase(s, "circle") >= 0 || cds.tools.Util.indexOfIgnoreCase(s, "ellipse") >= 0) {
            this.dataArea = 1;
            this.info("Ellipse shape data area autodetection");
        } else if (cds.tools.Util.indexOfIgnoreCase(s, "square") >= 0 || cds.tools.Util.indexOfIgnoreCase(s, "rectangular") >= 0) {
            this.dataArea = 2;
            this.info("Rectangular shape data area autodetection");
        } else {
            this.dataArea = 0;
        }
    }

    public void setPolygon(String r) throws Exception {
        boolean bl = this.scanFov = r.equalsIgnoreCase("true") || (this.polygon = Context.createPolygon(r)) != null;
        if (this.scanFov) {
            this.info("FoV files associated to the original images");
        }
    }

    public static Polygon createPolygon(String r) throws Exception {
        Polygon p = new Polygon();
        Tok tok = new Tok(r, " ,;\t");
        while (tok.hasMoreTokens()) {
            int x = (int)(Double.parseDouble(tok.nextToken()) + 0.5);
            int y = (int)(Double.parseDouble(tok.nextToken()) + 0.5);
            p.addPoint(x, y);
        }
        return p;
    }

    public static int[] parseHDU(String s) throws Exception {
        int[] hdu = null;
        if (s.length() == 0 || s.equals("0")) {
            return hdu;
        }
        if (s.equalsIgnoreCase("all")) {
            return new int[]{-1};
        }
        StringTokenizer st = new StringTokenizer(s, " ,;-", true);
        ArrayList<Integer> a = new ArrayList<Integer>();
        boolean flagRange = false;
        int previousN = -1;
        while (st.hasMoreTokens()) {
            String s1 = st.nextToken();
            if (s1.equals("-")) {
                flagRange = true;
                continue;
            }
            if (!Character.isDigit(s1.charAt(0))) continue;
            int n = Integer.parseInt(s1);
            if (flagRange) {
                for (int i = previousN + 1; i <= n && i < 1000; ++i) {
                    a.add(i);
                }
                flagRange = false;
            } else {
                a.add(n);
            }
            previousN = n;
        }
        hdu = new int[a.size()];
        for (int i = 0; i < hdu.length; ++i) {
            hdu[i] = (Integer)a.get(i);
        }
        return hdu;
    }

    public void setInputPath(String path) {
        this.inputPath = path;
    }

    public void setOutputPath(String path) {
        this.outputPath = path;
    }

    public void setImgEtalon(String filename) throws Exception {
        this.imgEtalon = filename;
        this.initFromImgEtalon();
    }

    public void setIndexFitskey(String list) {
        StringTokenizer st = new StringTokenizer(list);
        this.fitsKeys = new ArrayList(st.countTokens());
        while (st.hasMoreTokens()) {
            this.fitsKeys.add(st.nextToken());
        }
    }

    public void setMode(Mode coAdd) {
        this.mode = coAdd;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setTargetRadius(String targetRadius) {
        this.targetRadius = targetRadius;
    }

    public void setBScaleOrig(double x) {
        this.bScaleOrig = x;
        this.bscaleBzeroOrigSet = true;
    }

    public void setBZeroOrig(double x) {
        this.bZeroOrig = x;
        this.bscaleBzeroOrigSet = true;
    }

    public void setBitpixOrig(int bitpixO) {
        this.bitpixOrig = bitpixO;
        if (this.bitpix == -1) {
            this.bitpix = bitpixO;
        }
    }

    public void setBitpix(int bitpix) {
        this.bitpix = bitpix;
    }

    public void setBlankOrig(double x) {
        this.blankOrig = x;
        this.hasAlternateBlank = true;
    }

    public void setColor(String colorMode) {
        if (colorMode.equalsIgnoreCase("false")) {
            return;
        }
        this.bitpixOrig = 0;
        this.targetColorMode = colorMode.equalsIgnoreCase("png") ? 0 : 1;
    }

    public void setCut(double[] cut) {
        this.cut = cut;
    }

    public void setPixelCut(String scut) throws Exception {
        StringTokenizer st = new StringTokenizer(scut, " ");
        int i = 0;
        if (this.pixelRangeCut == null) {
            this.pixelRangeCut = new double[]{Double.NaN, Double.NaN, Double.NaN, Double.NaN};
        }
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            try {
                this.pixelRangeCut[i] = Double.parseDouble(s);
                ++i;
            }
            catch (Exception e) {
                this.setTransfertFct(s);
            }
        }
        if (i == 1 || i > 2) {
            throw new Exception("pixelCut parameter error");
        }
    }

    public void setPixelGood(String sGood) throws Exception {
        StringTokenizer st = new StringTokenizer(sGood, " ");
        if (this.pixelGood == null) {
            this.pixelGood = new double[]{Double.NaN, Double.NaN};
        }
        try {
            this.pixelGood[0] = Double.parseDouble(st.nextToken());
            this.pixelGood[1] = st.hasMoreTokens() ? Double.parseDouble(st.nextToken()) : this.pixelGood[0];
        }
        catch (Exception e) {
            throw new Exception("pixelGood parameter error");
        }
    }

    public double[] getPixelRangeCut() throws Exception {
        return this.pixelRangeCut;
    }

    public TransfertFct getFct() throws Exception {
        return this.fct;
    }

    public String getTransfertFct() throws Exception {
        return this.getFct().toString().toLowerCase();
    }

    public void setTransfertFct(String txt) {
        this.fct = TransfertFct.valueOf(txt.toUpperCase());
    }

    public String getTileExt() {
        return this.isColor() ? Constante.TILE_EXTENSION[this.targetColorMode] : ".fits";
    }

    public void setJpegMethod(JpegMethod jpegMethod) {
        this.jpegMethod = jpegMethod;
    }

    public void setMethod(String jpegMethod) {
        this.jpegMethod = JpegMethod.valueOf(jpegMethod.toUpperCase());
    }

    public JpegMethod getJpegMethod() {
        return this.jpegMethod;
    }

    public void setDataCut(String scut) throws Exception {
        StringTokenizer st = new StringTokenizer(scut, " ");
        int i = 2;
        if (this.pixelRangeCut == null) {
            this.pixelRangeCut = new double[]{Double.NaN, Double.NaN, Double.NaN, Double.NaN};
        }
        while (st.hasMoreTokens() && i < 4) {
            String s = st.nextToken();
            this.pixelRangeCut[i] = Double.parseDouble(s);
            ++i;
        }
        if (i < 4) {
            throw new Exception("Missing dataCut parameter");
        }
    }

    public void setCutOrig(double[] cutOrig) {
        this.cutOrig = cutOrig;
    }

    public void setDepth(int depth) {
        this.depth = depth;
        this.depthInit = true;
    }

    protected void initFromImgEtalon() throws Exception {
        if (this.lastImgEtalon != null && this.lastImgEtalon.equals(this.imgEtalon)) {
            return;
        }
        String path = this.imgEtalon;
        Fits fitsfile = new Fits();
        fitsfile.loadHeaderFITS(path);
        this.setBitpixOrig(fitsfile.bitpix);
        if (!this.isColor()) {
            this.setBZeroOrig(fitsfile.bzero);
            this.setBScaleOrig(fitsfile.bscale);
            if (!Double.isNaN(fitsfile.blank)) {
                this.setBlankOrig(fitsfile.blank);
            }
        }
        this.typicalImgWidth = Math.max(fitsfile.width, fitsfile.height);
        try {
            this.setDepth(fitsfile.headerFits.getIntFromHeader("NAXIS3"));
            try {
                this.crpix3 = fitsfile.headerFits.getDoubleFromHeader("CRPIX3");
                this.crval3 = fitsfile.headerFits.getDoubleFromHeader("CRVAL3");
                this.cdelt3 = fitsfile.headerFits.getDoubleFromHeader("CDELT3");
                this.bunit3 = fitsfile.headerFits.getStringFromHeader("BUNIT3");
            }
            catch (Exception e) {
                this.cdelt3 = 0.0;
                this.crval3 = 0.0;
                this.crpix3 = 0.0;
                this.bunit3 = null;
            }
        }
        catch (Exception e) {
            this.setDepth(1);
        }
        try {
            this.initCut(fitsfile);
        }
        catch (Exception e) {
            Aladin.trace(4, "initFromImgEtalon :" + e.getMessage());
        }
        if (this.target == null) {
            Coord c = fitsfile.calib.getImgCenter();
            this.setTarget(cds.tools.Util.round(c.al, 5) + " " + (c.del >= 0.0 ? "+" : "") + cds.tools.Util.round(c.del, 5));
            if (this.targetRadius == null) {
                double r = Math.max(fitsfile.calib.getImgHeight(), fitsfile.calib.getImgWidth());
                this.setTargetRadius(cds.tools.Util.round(r, 5) + "");
            }
        }
        double[] res = fitsfile.calib.GetResol();
        this.resolution = cds.tools.Util.myRound(Math.min(res[0], res[1]));
        this.lastImgEtalon = this.imgEtalon;
    }

    protected void initCut(Fits file) throws Exception {
        double rangeData;
        double[] cutOrig;
        double centerRange;
        int w = file.width;
        int h = file.height;
        int d = file.depth;
        int x = 0;
        int y = 0;
        int z = 0;
        if (w > 1024) {
            w = 1024;
            x = file.width / 2 - 512;
        }
        if (h > 1024) {
            h = 1024;
            y = file.height / 2 - 512;
        }
        if (d > 1) {
            d = 1;
            z = file.depth / 2 - 0;
        }
        if (file.getFilename() != null) {
            file.loadFITS(file.getFilename(), 0, x, y, z, w, h, d);
        }
        if (!Double.isInfinite((centerRange = (cutOrig = file.findAutocutRange())[2] / 2.0 + cutOrig[3] / 2.0) - (rangeData = cutOrig[3] - cutOrig[2]))) {
            cutOrig[2] = centerRange - rangeData;
        }
        if (!Double.isInfinite(centerRange + rangeData)) {
            cutOrig[3] = centerRange + rangeData;
        }
        this.setCutOrig(cutOrig);
    }

    boolean findImgEtalon(String rootPath) {
        if (this.isInputFile) {
            try {
                this.setImgEtalon(rootPath);
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }
        nbFiles = 0;
        return this.findImgEtalon1(rootPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean findImgEtalon1(String rootPath) {
        File main = new File(rootPath);
        String[] list = main.list();
        if (list == null) {
            return false;
        }
        String path = rootPath;
        ArrayList<String> dir = new ArrayList<String>();
        for (int f = 0; f < list.length; ++f) {
            if (!rootPath.endsWith(cds.tools.Util.FS)) {
                rootPath = rootPath + cds.tools.Util.FS;
            }
            if (new File(path = rootPath + list[f]).isDirectory()) {
                if (list[f].equals(Constante.SURVEY)) continue;
                dir.add(path);
                continue;
            }
            if (++nbFiles > 100) {
                Aladin.trace(4, "Context.findImgEtalon: too many files - ignored this step...");
                return false;
            }
            MyInputStream in = null;
            try {
                in = new MyInputStream(new FileInputStream(path)).startRead();
                if ((in.getType() & 1L) != 1L && !in.hasCommentCalib()) continue;
                Aladin.trace(4, "Context.findImgEtalon: " + path + "...");
                this.setImgEtalon(path);
                boolean e1 = true;
                return e1;
            }
            catch (Exception e) {
                Aladin.trace(4, "findImgEtalon : " + e.getMessage());
                continue;
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception e1) {}
                }
            }
        }
        for (String s : dir) {
            if (!this.findImgEtalon1(s)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String justFindImgEtalon(String rootPath) {
        if (this.isInputFile) {
            return rootPath;
        }
        File main = new File(rootPath);
        String[] list = main.list();
        if (list == null) {
            return null;
        }
        String path = rootPath;
        ArrayList<String> dir = new ArrayList<String>();
        for (int f = 0; f < list.length; ++f) {
            String string;
            if (!rootPath.endsWith(cds.tools.Util.FS)) {
                rootPath = rootPath + cds.tools.Util.FS;
            }
            if (new File(path = rootPath + list[f]).isDirectory()) {
                if (list[f].equals(Constante.SURVEY)) continue;
                dir.add(path);
                continue;
            }
            MyInputStream in = null;
            try {
                if (path.endsWith(".hhh")) {
                    String string2 = path;
                    return string2;
                }
                in = new MyInputStream(new FileInputStream(path)).startRead();
                long type = in.getType();
                if ((type & 1L) != 1L && !in.hasCommentCalib()) continue;
                string = path + (this.hdu == null || this.hdu.length > 0 && this.hdu[0] == -1 ? "" : "[" + this.hdu[0] + "]");
            }
            catch (Exception e) {
                Aladin.trace(4, "justFindImgEtalon : " + e.getMessage());
                continue;
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception e1) {}
                }
            }
            return string;
        }
        for (String s : dir) {
            String rep = this.justFindImgEtalon(s);
            if (rep == null) continue;
            return rep;
        }
        return null;
    }

    public void setRgbInput(String path, int c) {
        if (this.plansRgb == null) {
            this.plansRgb = new Object[3];
        }
        this.plansRgb[c] = new PlanBG(Aladin.aladin, path, LABELRGB[c], new Coord(0.0, 0.0), 0.0, null);
        ((PlanImage)this.plansRgb[c]).transfertFct = 3;
    }

    public void setRgbCmParam(String cmParam, int c) throws Exception {
        if (this.plansRgb == null || this.plansRgb[c] == null) {
            throw new Exception("Color component folder must be defined first");
        }
        ((PlanImage)this.plansRgb[c]).setCmParam(cmParam);
    }

    public void setSkyval(String fieldName) {
        this.skyvalName = fieldName.toUpperCase();
    }

    public void setExpTime(String expTime) {
        this.expTimeName = expTime.toUpperCase();
    }

    public void setCache(CacheFits cache) {
        this.cacheFits = cache;
        cache.setContext(this);
    }

    protected void setMocArea(String s) throws Exception {
        if (s.length() == 0) {
            return;
        }
        this.mocArea = new HealpixMoc(s);
        if (this.mocArea.getSize() == 0) {
            throw new Exception("MOC sky area syntax error");
        }
    }

    public void setMocArea(HealpixMoc area) throws Exception {
        this.mocArea = area;
    }

    public double getSkyArea() {
        if (this.moc == null) {
            return 1.0;
        }
        return this.moc.getCoverage();
    }

    public double getIndexSkyArea() {
        if (this.mocIndex == null) {
            return 1.0;
        }
        return this.mocIndex.getCoverage();
    }

    public void initParameters() throws Exception {
        if (!this.isColor()) {
            this.bitpix = this.getBitpix();
            this.bitpixOrig = this.getBitpixOrig();
            this.cutOrig = this.getCutOrig();
            this.blankOrig = this.getBlankOrig();
            this.blank = this.getDefaultBlankFromBitpix(this.bitpix);
            this.cut = new double[5];
            if (this.cutOrig == null) {
                this.cutOrig = new double[5];
            }
            System.arraycopy(this.cutOrig, 0, this.cut, 0, this.cutOrig.length);
            if (this.cutOrig[2] >= this.cutOrig[3]) {
                double d = this.bitpixOrig == -64 ? -1.7976931348623157E308 : (this.bitpixOrig == -32 ? -3.4028234663852886E38 : (this.bitpixOrig == 64 ? -9.223372036854776E18 : (this.bitpixOrig == 32 ? -2.147483647E9 : (this.cutOrig[2] = this.bitpixOrig == 16 ? -32767.0 : 1.0))));
                double d2 = this.bitpixOrig == -64 ? Double.MAX_VALUE : (this.bitpixOrig == -32 ? 3.4028234663852886E38 : (this.bitpixOrig == 64 ? 9.223372036854776E18 : (this.bitpixOrig == 32 ? 2.147483647E9 : (this.cutOrig[3] = this.bitpixOrig == 16 ? 32767.0 : 255.0))));
            }
            if (this.bitpixOrig != -1 && this.bitpix != this.bitpixOrig) {
                double d = this.bitpix == -64 ? -1.7976931348623157E308 : (this.bitpix == -32 ? -3.4028234663852886E38 : (this.bitpix == 64 ? -9.223372036854776E18 : (this.bitpix == 32 ? -2.147483647E9 : (this.cut[2] = this.bitpix == 16 ? -32767.0 : 1.0))));
                this.cut[3] = this.bitpix == -64 ? Double.MAX_VALUE : (this.bitpix == -32 ? 3.4028234663852886E38 : (this.bitpix == 64 ? 9.223372036854776E18 : (this.bitpix == 32 ? 2.147483647E9 : (this.bitpix == 16 ? 32767.0 : 255.0))));
                this.coef = (this.cut[3] - this.cut[2]) / (this.cutOrig[3] - this.cutOrig[2]);
                this.cut[0] = (this.cutOrig[0] - this.cutOrig[2]) * this.coef + this.cut[2];
                this.cut[1] = (this.cutOrig[1] - this.cutOrig[2]) * this.coef + this.cut[2];
                this.bzero = this.bZeroOrig + this.bScaleOrig * (this.cutOrig[2] - this.cut[2] / this.coef);
                this.bscale = this.bScaleOrig / this.coef;
                this.info("Change BITPIX from " + this.bitpixOrig + " to " + this.bitpix);
                this.info("Map original pixel range [" + this.cutOrig[2] + " .. " + this.cutOrig[3] + "] " + "to [" + this.cut[2] + " .. " + this.cut[3] + "]");
                this.info("Change BZERO,BSCALE,BLANK=" + this.bZeroOrig + "," + this.bScaleOrig + "," + this.blankOrig + " to " + this.bzero + "," + this.bscale + "," + this.blank);
                if (Double.isInfinite(this.bzero) || Double.isInfinite(this.bscale)) {
                    throw new Exception("pixelRange parameter required !");
                }
            } else {
                this.bzero = this.bZeroOrig;
                this.bscale = this.bScaleOrig;
                Aladin.trace(3, "BITPIX kept " + this.bitpix + " BZERO,BSCALE,BLANK=" + this.bzero + "," + this.bscale + "," + this.blank);
            }
            if (this.pixelGood != null) {
                this.good = new double[2];
                this.good[0] = (this.pixelGood[0] - this.bZeroOrig) / this.bScaleOrig;
                this.good[1] = (this.pixelGood[1] - this.bZeroOrig) / this.bScaleOrig;
            }
        }
        this.initRegion();
    }

    protected void initRegion() throws Exception {
        try {
            if (this.mocIndex == null) {
                if (this.isMap()) {
                    this.mocIndex = new HealpixMoc("0/0-11");
                } else {
                    this.loadMocIndex();
                }
            }
        }
        catch (Exception e) {
            this.mocIndex = new HealpixMoc("0/0-11");
        }
        this.moc = this.mocArea == null ? this.mocIndex : this.mocIndex.intersection(this.mocArea);
    }

    protected HealpixMoc getRegion() {
        return this.moc;
    }

    protected void loadMocIndex() throws Exception {
        HealpixMoc mocIndex = new HealpixMoc();
        mocIndex.read(this.getHpxFinderPath() + cds.tools.Util.FS + "Moc.fits");
        this.mocIndex = mocIndex;
    }

    protected void loadMoc() throws Exception {
        HealpixMoc mocIndex = new HealpixMoc();
        mocIndex.read(this.getOutputPath() + cds.tools.Util.FS + "Moc.fits");
        this.mocIndex = mocIndex;
    }

    protected HealpixMoc getMocIndex() {
        return this.mocIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verifTileOrder() {
        InputStream in = null;
        boolean flagTileOrderFound = false;
        try {
            String propFile = this.getHpxFinderPath() + cds.tools.Util.FS + "properties";
            MyProperties prop = new MyProperties();
            in = new FileInputStream(propFile);
            prop.load(in);
            String s = prop.getProperty("hips_tile_width");
            int o = s != null ? (int)CDSHealpix.log2(Integer.parseInt(s)) : Integer.parseInt(prop.getProperty("tileOrder"));
            if (o != this.getTileOrder()) {
                if (this.tileOrder != -1 && o != this.tileOrder) {
                    this.warning("Uncompatible tileOrder=" + this.tileOrder + " compared to pre-existing survey tileOrder=" + o);
                    boolean bl = false;
                    return bl;
                }
                this.setTileOrder(o);
                int w = this.getTileSide();
                this.info("Specifical tileOrder=" + o + " tileSize=" + w + "x" + w);
            }
            flagTileOrderFound = true;
        }
        catch (Exception e) {
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {}
            }
        }
        if (!flagTileOrderFound && this.getTileOrder() != 9) {
            this.warning("Uncompatible tileOrder=" + this.getTileOrder() + " compared to default pre-existing survey tileOrder=" + 9);
            return false;
        }
        return true;
    }

    public boolean verifCoherence() {
        int or;
        if (!this.verifTileOrder()) {
            return false;
        }
        if (this.mode == Mode.REPLACETILE) {
            return true;
        }
        if (!this.isColor()) {
            String fileName = this.getOutputPath() + cds.tools.Util.FS + "Norder3" + cds.tools.Util.FS + "Allsky.fits";
            if (!new File(fileName).exists()) {
                return true;
            }
            Fits fits = new Fits();
            try {
                fits.loadHeaderFITS(fileName);
            }
            catch (Exception e) {
                return true;
            }
            if (fits.bitpix != this.bitpix) {
                this.warning("Uncompatible BITPIX=" + this.bitpix + " compared to pre-existing survey BITPIX=" + fits.bitpix);
                return false;
            }
            boolean nanO = Double.isNaN(fits.blank);
            boolean nan = Double.isNaN(this.blank);
            if (this.bitpix > 0 && nanO) {
                boolean bl = nan = !Double.isNaN(this.getBlankOrig());
            }
            if (nanO != nan || !nan && fits.blank != this.blank) {
                this.warning("Uncompatible BLANK=" + this.blank + " compared to pre-existing survey BLANK=" + fits.blank);
                return false;
            }
        }
        if ((or = Util.getMaxOrderByPath(this.getOutputPath())) != -1 && or != this.getOrder()) {
            this.warning("Uncompatible order=" + this.getOrder() + " compared to pre-existing survey order=" + or);
            return false;
        }
        return true;
    }

    private double getDefaultBlankFromBitpix(int bitpix) {
        return bitpix < 0 ? Double.NaN : (bitpix == 32 ? -2.147483648E9 : (bitpix == 16 ? -32768.0 : 0.0));
    }

    private int[] parseBorderSize(String s) throws ParseException {
        int[] border = new int[]{0, 0, 0, 0};
        try {
            StringTokenizer st = new StringTokenizer(s, " ,;-");
            for (int i = 0; i < 4 && st.hasMoreTokens(); ++i) {
                String s1 = st.nextToken();
                border[i] = Integer.parseInt(s1);
                if (i != 0) continue;
                border[2] = border[1] = border[0];
                border[3] = border[1];
            }
            int x = border[0];
            border[0] = border[2];
            border[2] = x;
        }
        catch (Exception e) {
            throw new ParseException("Border error => assume 0", 0);
        }
        return border;
    }

    protected boolean isExistingDir() {
        String path = this.getInputPath();
        if (path == null) {
            return false;
        }
        return new File(path).isDirectory();
    }

    protected boolean isExistingAllskyDir() {
        return this.isExistingAllskyDir(this.getOutputPath());
    }

    protected boolean isExistingAllskyDir(String path) {
        if (path == null) {
            return false;
        }
        File f = new File(path);
        if (!f.exists()) {
            return false;
        }
        int order = Util.getMaxOrderByPath(path);
        return order != -1;
    }

    protected boolean isExistingIndexDir() {
        String path = this.getHpxFinderPath();
        if (path == null) {
            return false;
        }
        File f = new File(path);
        if (!f.exists()) {
            return false;
        }
        for (File fc : f.listFiles()) {
            if (!fc.isDirectory() || !fc.getName().startsWith("Norder")) continue;
            return true;
        }
        return false;
    }

    protected void setMocIndex(HealpixMoc m) throws Exception {
        this.mocIndex = m;
    }

    protected long getNbLowCells() {
        HealpixMoc m;
        if (this.moc == null && this.mocIndex == null || this.getOrder() == -1) {
            return -1L;
        }
        HealpixMoc healpixMoc = m = this.moc != null ? this.moc : this.mocIndex;
        if (this.getOrder() != m.getMocOrder()) {
            m = (HealpixMoc)m.clone();
            try {
                m.setMocOrder(this.getOrder());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        long res = m.getUsedArea() * (long)this.depth;
        return res;
    }

    protected long getDiskMem() {
        long nbLowCells = this.getNbLowCells();
        if (nbLowCells == -1L || this.bitpix == 0) {
            return -1L;
        }
        long mem = nbLowCells * (long)this.getTileSide() * (long)this.getTileSide() * (long)(Math.abs(this.bitpix) / 8);
        return mem;
    }

    protected void setProgressLastNorder3(int lastNorder3) {
        this.lastNorder3 = lastNorder3;
    }

    protected void showIndexStat(int statNbFile, int statBlocFile, int statNbZipFile, long statMemFile, long statPixSize, long statMaxSize, int statMaxWidth, int statMaxHeight, int statMaxDepth, int statMaxNbyte, long statDuree) {
        String s;
        if (statNbFile == -1) {
            s = "";
        } else {
            String nbPerSec = statDuree > 1000L ? "" + cds.tools.Util.round((double)statNbFile / ((double)statDuree / 1000.0), 1) : "";
            s = statNbFile + " file" + (statNbFile > 1 ? "s" : "") + " in " + cds.tools.Util.getTemps(statDuree) + (nbPerSec.length() == 0 ? "" : " => " + nbPerSec + "/s") + (statNbFile > 0 && statNbZipFile == statNbFile ? " - all gzipped" : (statNbZipFile > 0 ? " (" + statNbZipFile + " gzipped)" : "")) + " => " + cds.tools.Util.getUnitDisk(statPixSize).replace("B", "pix") + " using " + cds.tools.Util.getUnitDisk(statMemFile) + (statNbFile > 1 && statMaxSize < 0L ? "" : " => biggest: [" + statMaxWidth + "x" + statMaxHeight + (statMaxDepth > 1 ? "x" + statMaxDepth : "") + " x" + statMaxNbyte + "]");
        }
        this.stat(s);
    }

    protected void showTilesStat(int statNbThreadRunning, int statNbThread, long totalTime, int statNbTile, int statNbEmptyTile, int statNodeTile, long statMinTime, long statMaxTime, long statAvgTime, long statNodeAvgTime, long usedMem, long deltaTime, long deltaNbTile) {
        String pourcentNbCells;
        String sNbCells;
        if (statNbTile == 0) {
            return;
        }
        long nbCells = this.getNbLowCells();
        long nbLowTile = statNbTile + statNbEmptyTile;
        String string = sNbCells = nbCells == -1L ? "" : "/" + nbCells;
        String string2 = nbCells == -1L ? "" : (pourcentNbCells = nbCells == 0L ? "-" : (double)Math.round((double)nbLowTile / (double)nbCells * 1000.0) / 10.0 + "%");
        long tempsTotalEstime = nbLowTile == 0L ? 0L : (nbCells == 0L ? 0L : nbCells * (totalTime / nbLowTile) - totalTime);
        long nbTilesPerMin = deltaNbTile * 60000L / deltaTime;
        String s = statNbTile + "+" + statNbEmptyTile + sNbCells + " tiles + " + statNodeTile + " nodes computed in " + cds.tools.Util.getTemps(totalTime, true) + " (" + pourcentNbCells + (nbTilesPerMin <= 0L ? "" : " " + nbTilesPerMin + "tiles/mn EndsIn=" + cds.tools.Util.getTemps(tempsTotalEstime, true)) + ") " + cds.tools.Util.getTemps(statAvgTime) + "/tile [" + cds.tools.Util.getTemps(statMinTime) + " .. " + cds.tools.Util.getTemps(statMaxTime) + "] " + cds.tools.Util.getTemps(statNodeAvgTime) + "/node" + (statNbThread == 0 ? "" : " by " + statNbThreadRunning + "/" + statNbThread + " threads");
        this.stat(s);
        if (this.cacheFits != null && this.cacheFits.getStatNbOpen() > 0) {
            this.stat(this.cacheFits + "");
        }
        this.setProgress(statNbTile + statNbEmptyTile, nbCells);
    }

    protected void showMapStat(long cRecord, long nbRecord, long cTime, CacheFits cache, String info) {
        double pourcent = (double)cRecord / (double)nbRecord;
        long totalTime = (long)((double)cTime / pourcent);
        long endsIn = totalTime - cTime;
        this.stat(cds.tools.Util.round(pourcent * 100.0, 1) + "% in " + cds.tools.Util.getTemps(cTime, true) + " endsIn=" + cds.tools.Util.getTemps(endsIn, true) + " (record=" + (cRecord + 1L) + "/" + nbRecord + ")");
        if (cache != null && cache.getStatNbOpen() > 0) {
            this.stat(cache + "");
        }
        this.setProgress(cRecord, nbRecord);
    }

    protected void showJpgStat(int statNbFile, long cTime, int statNbThread, int statNbThreadRunning) {
        String pourcentNbCells;
        long nbLowCells = this.getNbLowCells();
        double pourcent = nbLowCells <= 0L ? 0.0 : (double)statNbFile / (double)nbLowCells;
        long totalTime = (long)((double)cTime / pourcent);
        long endsIn = totalTime - cTime;
        String string = pourcentNbCells = nbLowCells == -1L ? "" : (double)Math.round((double)statNbFile / (double)nbLowCells * 1000.0) / 10.0 + "%) ";
        String s = nbLowCells <= 0L ? statNbFile + " tiles created in " + cds.tools.Util.getTemps(cTime, true) : statNbFile + "/" + nbLowCells + " tiles created in " + cds.tools.Util.getTemps(cTime, true) + " (" + pourcentNbCells + " endsIn=" + cds.tools.Util.getTemps(endsIn, true) + (statNbThread == 0 ? "" : " by " + statNbThreadRunning + "/" + statNbThread + " threads");
        this.stat(s);
    }

    protected void showRgbStat(int statNbFile, long statSize, long totalTime) {
    }

    protected boolean isMap() {
        return this.isMap;
    }

    protected void setMap(boolean flag) {
        this.isMap = flag;
    }

    public void setIgnoreStamp(boolean flag) {
        this.ignoreStamp = true;
    }

    public boolean isTaskRunning() {
        return this.taskRunning;
    }

    public void setTaskRunning(boolean flag) {
        if (flag) {
            this.taskAborting = false;
        } else {
            this.progressBar = null;
        }
        this.taskRunning = flag;
        this.resumeWidgets();
    }

    public boolean isTaskPause() {
        return this.taskPause;
    }

    public void setTaskPause(boolean flag) {
        this.taskPause = flag;
        this.resumeWidgets();
    }

    public void taskAbort() {
        this.taskAborting = true;
        this.taskPause = false;
    }

    public boolean isTaskAborting() {
        if (this.taskAborting) {
            return true;
        }
        while (this.taskPause) {
            cds.tools.Util.pause(500);
        }
        return false;
    }

    protected static String getNow() {
        return Constante.getDate();
    }

    static long getTime(String date) throws Exception {
        return DATEFORMAT.parse(date).getTime();
    }

    private static String getKeyActionStart(Action a) {
        return "Processing." + (Object)((Object)a) + ".start";
    }

    private static String getKeyActionEnd(Action a) {
        return "Processing." + (Object)((Object)a) + ".end";
    }

    public void startAction(Action a) throws Exception {
        this.action = a;
        this.action.startTime();
        this.setProgress(0.0, -1.0);
    }

    public void endAction() throws Exception {
        if (this.action == null) {
            return;
        }
        if (this.isTaskAborting()) {
            this.done((Object)((Object)this.action) + " abort (after " + cds.tools.Util.getTemps(this.action.getDuree()) + ")");
        } else {
            this.done((Object)((Object)this.action) + " done (in " + cds.tools.Util.getTemps(this.action.getDuree()) + ")");
        }
        this.action = null;
    }

    public Action getAction() {
        return this.action;
    }

    public boolean actionAlreadyDone(Action a) {
        if (this.ignoreStamp) {
            return false;
        }
        try {
            if (this.prop == null) {
                this.loadProperties();
            }
            if (this.prop == null) {
                return false;
            }
            String end = this.prop.getProperty(Context.getKeyActionEnd(a));
            if (end == null) {
                return false;
            }
            String start = this.prop.getProperty(Context.getKeyActionStart(a));
            if (start == null) {
                return false;
            }
            if (Context.getTime(end) < Context.getTime(start)) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean actionPrecedeAction(Action avant, Action apres) {
        if (this.ignoreStamp) {
            return false;
        }
        try {
            if (this.prop == null) {
                this.loadProperties();
            }
            if (this.prop == null) {
                return false;
            }
            if (!this.actionAlreadyDone(avant) || !this.actionAlreadyDone(apres)) {
                return false;
            }
            String endAvant = this.prop.getProperty(Context.getKeyActionEnd(avant));
            String endApres = this.prop.getProperty(Context.getKeyActionEnd(apres));
            if (Context.getTime(endApres) < Context.getTime(endAvant)) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public void setProgress(double progress, double progressMax) {
        this.setProgress(progress);
        this.setProgressMax(progressMax);
    }

    public void setProgress(double progress) {
        this.progress = progress;
    }

    public void setProgressMax(double progressMax) {
        this.progressMax = progressMax;
    }

    public void progressStatus() {
        System.out.print('.');
        this.flagNL = true;
    }

    public void enableProgress(boolean flag) {
        System.out.println("progress [" + (Object)((Object)this.action) + "] enable=" + flag);
    }

    public void setProgressBar(JProgressBar bar) {
    }

    public void resumeWidgets() {
    }

    public void trace(int i, String string) {
        if (Aladin.levelTrace >= i) {
            System.out.println(string);
        }
    }

    public void setTrace(int trace) {
        Aladin.levelTrace = trace;
    }

    public static void setVerbose(boolean verbose) {
        Context.verbose = verbose;
        BuilderTiles.DEBUG = true;
    }

    public static int getVerbose() {
        return Aladin.levelTrace;
    }

    public static void setVerbose(int level) {
        if (level >= 0) {
            verbose = true;
            Aladin.levelTrace = level;
        } else {
            verbose = false;
            Aladin.levelTrace = 0;
        }
    }

    private void nl() {
        if (this.flagNL) {
            System.out.println();
        }
        this.flagNL = false;
    }

    public void running(String s) {
        this.nl();
        System.out.println("RUN   : ================================ " + s + " ===============================");
    }

    public void done(String r) {
        this.nl();
        System.out.println("DONE  : " + r);
    }

    public void info(String s) {
        this.nl();
        System.out.println("INFO  : " + s);
    }

    public void warning(String s) {
        this.nl();
        System.out.println("WARN  : " + s);
    }

    public void error(String s) {
        this.nl();
        System.out.println("ERROR : " + s);
    }

    public void action(String s) {
        this.nl();
        System.out.println("ACTION: " + s);
    }

    public void stat(String s) {
        this.nl();
        System.out.println("STAT  : " + s);
    }

    public boolean isValidateOutput() {
        return this.validateOutputDone;
    }

    public void setValidateOutput(boolean flag) {
        this.validateOutputDone = flag;
    }

    public boolean isValidateInput() {
        return this.validateInputDone;
    }

    public void setValidateInput(boolean flag) {
        this.validateInputDone = flag;
    }

    public boolean isValidateCut() {
        return this.validateCutDone;
    }

    public void setValidateCut(boolean flag) {
        this.validateCutDone = flag;
    }

    protected void setComment(String comment) {
        this.setPropriete("#", "#" + comment);
    }

    protected void setPropriete(String key, String value) {
        if (this.keyAddProp == null) {
            this.keyAddProp = new Vector();
            this.valueAddProp = new Vector();
        }
        this.keyAddProp.addElement(key);
        this.valueAddProp.addElement(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeIndexHtml() throws Exception {
        String metadata;
        String sys;
        int order;
        String label = this.getLabel();
        if (label == null || label.length() == 0) {
            label = "XXX_" + System.currentTimeMillis() / 1000L;
        }
        if ((order = this.getOrder()) == -1) {
            order = Util.getMaxOrderByPath(this.getOutputPath());
        }
        if (this.moc == null) {
            try {
                this.loadMoc();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.prop == null) {
            this.loadProperties();
        }
        if ((sys = this.prop.getProperty("hips_frame")) == null) {
            sys = "galactic";
        }
        long nside = CDSHealpix.pow2(order);
        long nsideP = CDSHealpix.pow2(order + this.getTileOrder());
        double resol = CDSHealpix.pixRes(nsideP) / 3600.0;
        int width = this.getTileSide();
        String tiles = this.getAvailableTileFormats();
        String fmt = tiles.indexOf("png") >= 0 ? "png" : "jpg";
        String res = this.INDEX.replace("$LABEL", label);
        StringBuilder info = new StringBuilder();
        info.append("   <LI> <B>Label:</B> " + label + "\n");
        info.append("   <LI> <B>Type:</B> " + (this.depth > 1 ? "HiPS cube (" + this.depth + " frames)" : (this.isColor() ? "colored HiPS image" : "HiPS image")) + "\n");
        info.append("   <LI> <B>Best pixel angular resolution:</B> " + Coord.getUnit(resol) + "\n");
        info.append("   <LI> <B>Max tile order:</B> " + order + " (NSIDE=" + nside + ")\n");
        info.append("   <LI> <B>Available encoding tiles:</B> " + tiles + "\n");
        info.append("   <LI> <B>Tile size:</B> " + width + "x" + width + "\n");
        if (this.bitpix != 0 && this.bitpix != -1) {
            info.append("   <LI> <B>FITS tile BITPIX:</B> " + this.bitpix + "\n");
        }
        info.append("   <LI> <B>Processing date:</B> " + Context.getNow() + "\n");
        info.append("   <LI> <B>HiPS builder:</B> Aladin/HipsGen v8.155\n");
        info.append("   <LI> <B>Coordinate frame:</B> " + sys + "\n");
        if (this.moc != null) {
            double cov = this.moc.getCoverage();
            double degrad = Math.toDegrees(1.0);
            double skyArea = Math.PI * 4 * degrad * degrad;
            info.append("   <LI> <B>Sky area:</B> " + cds.tools.Util.round(cov * 100.0, 3) + "% of sky => " + Coord.getUnit(skyArea * cov, false, true) + "^2\n");
            info.append("   <LI> <B>Associated coverage map:</B> <A HREF=\"Moc.fits\">MOC</A>\n");
        }
        if (new File(metadata = cds.tools.Util.concatDir(this.getHpxFinderPath(), "metadata.xml")).exists()) {
            info.append("   <LI> <B>Original data access template:</B> <A HREF=\"HpxFinder/metadata.xml\">metadata.xml</A>\n");
        }
        res = res.replace("$INFO", info);
        res = res.replace("$ORDER", order + "");
        res = res.replace("$SYS", sys);
        res = res.replace("$FMT", fmt);
        String tmp = this.getOutputPath() + cds.tools.Util.FS + "index.html";
        File ftmp = new File(tmp);
        if (ftmp.exists()) {
            ftmp.delete();
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(ftmp);
            out.write(res.getBytes());
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeMetadataFits() throws Exception {
        if (this.header == null) {
            return;
        }
        String tmp = this.getOutputPath() + cds.tools.Util.FS + "metadata.txt";
        File ftmp = new File(tmp);
        if (ftmp.exists()) {
            ftmp.delete();
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(ftmp);
            out.write(this.header.getOriginalHeaderFits().getBytes());
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    protected void writePropertiesFile() throws Exception {
        double skyFraction;
        String label;
        int order = this.getOrder();
        if (order == -1) {
            order = Util.getMaxOrderByPath(this.getOutputPath());
        }
        if ((label = this.getLabel()) == null || label.length() == 0) {
            label = "XXX_" + System.currentTimeMillis() / 1000L;
        }
        this.setPropriete("#publisher_did", "Dataset identifier (IVORN) given by the publisher (ex: ivo://CDS/P/2MASS/J)");
        this.setPropriete("obs_collection", label);
        this.setPropriete("#obs_title", "Dataset text title");
        this.setPropriete("#obs_description", "Dataset text description");
        this.setPropriete("#obs_ack", "Acknowledgement mention");
        this.setPropriete("#prov_progenitor", "Provenance of the original data (free text)");
        this.setPropriete("#bib_reference", "Bibcode for bibliographic reference");
        this.setPropriete("#bib_reference_url", "URL to bibliographic reference");
        this.setPropriete("#obs_copyright", "Copyright mention");
        this.setPropriete("#obs_copyright_url", "URL to copyright page");
        this.setPropriete("#t_min", "Start time in MJD");
        this.setPropriete("#t_max", "Stop time in MJD");
        this.setPropriete("#em_min", "Start in spectral coordinates in meters");
        this.setPropriete("#em_max", "Stop in spectral coordinates in meters");
        this.setPropriete("hips_builder", "Aladin/HipsGen v8.155");
        this.setPropriete("hips_version", "1.3");
        this.setPropriete("hips_release_date", Context.getNow());
        if (this.publisher != null) {
            this.setPropriete("hips_publisher", this.publisher);
        } else {
            this.setPropriete("#hips_publisher", "HiPS publisher (institute or person)");
        }
        int f = this.getFrame();
        this.setPropriete("hips_frame", f == 0 ? "equatorial" : (f == 2 ? "ecliptic" : "galactic"));
        this.setPropriete("coordsys", f == 0 ? "C" : (f == 2 ? "E" : "G"));
        this.setPropriete("hips_order", order + "");
        this.setPropriete("hips_tile_width", CDSHealpix.pow2(this.getTileOrder()) + "");
        this.setPropriete("#hips_service_url", "ex: http://yourHipsServer/" + label + "");
        this.setPropriete("#hips_status", "ex: public master clonable");
        String fmt = this.getAvailableTileFormats();
        if (fmt.length() > 0) {
            this.setPropriete("hips_tile_format", fmt);
        }
        if (fmt.indexOf("fits") >= 0) {
            if (this.bitpix != -1) {
                this.setPropriete("hips_pixel_bitpix", this.bitpix + "");
            }
            if (this.bitpixOrig != -1) {
                this.setPropriete("data_pixel_bitpix", this.bitpixOrig + "");
            }
        }
        this.setPropriete("hips_hierarchy", "mean");
        if (this.cut != null) {
            if (this.cut[0] != 0.0 || this.cut[1] != 0.0) {
                String s1 = "";
                this.setPropriete("hips_pixel_cut", cds.tools.Util.myRound(this.bscale * this.cut[0] + this.bzero) + " " + cds.tools.Util.myRound(this.bscale * this.cut[1] + this.bzero) + s1);
            }
            if (this.cut[2] != 0.0 || this.cut[3] != 0.0) {
                this.setPropriete("hips_data_range", cds.tools.Util.myRound(this.bscale * this.cut[2] + this.bzero) + " " + cds.tools.Util.myRound(this.bscale * this.cut[3] + this.bzero));
            }
        }
        if (this.target != null) {
            int offset = this.target.indexOf(32);
            this.setPropriete("hips_initial_ra", this.target.substring(0, offset));
            this.setPropriete("hips_initial_dec", this.target.substring(offset + 1));
        }
        if (this.targetRadius != null) {
            this.setPropriete("hips_initial_fov", this.targetRadius);
        }
        double res = CDSHealpix.pixRes(CDSHealpix.pow2(order + this.getTileOrder()));
        this.setPropriete("hips_pixel_scale", cds.tools.Util.myRound(res / 3600.0));
        if (this.resolution != null) {
            this.setPropriete("s_pixel_scale", this.resolution);
        }
        if (this.depth > 1) {
            this.setPropriete("dataproduct_type", "cube");
            this.setPropriete("hips_cube_depth", this.depth + "");
            this.setPropriete("hips_cube_firstframe", this.depth / 2 + "");
            if (this.isCubeCanal()) {
                this.setPropriete("data_cube_crpix3", this.crpix3 + "");
                this.setPropriete("data_cube_crval3", this.crval3 + "");
                this.setPropriete("data_cube_cdelt3", this.cdelt3 + "");
                this.setPropriete("data_cube_bunit3", this.bunit3 + "");
            }
        } else {
            this.setPropriete("dataproduct_type", "image");
        }
        if (this.isColor()) {
            this.setPropriete("dataproduct_subtype", "color");
        }
        HealpixMoc m = this.moc != null ? this.moc : this.mocIndex;
        double d = skyFraction = m == null ? 0.0 : m.getCoverage();
        if (skyFraction > 0.0) {
            this.setPropriete("moc_sky_fraction", cds.tools.Util.myRound(skyFraction));
            long tileSizeFits = (long)Math.abs(this.bitpix / 8) * CDSHealpix.pow2(this.getTileOrder()) * CDSHealpix.pow2(this.getTileOrder()) + 2048L;
            long tileSizeJpeg = 70000L;
            long tileSizePng = 100000L;
            double coverage = m.getCoverage();
            long numberOfTiles = CDSHealpix.pow2(order) * CDSHealpix.pow2(order) * 12L;
            long fitsSize = (long)((double)(tileSizeFits * numberOfTiles) * 1.3 * coverage) / 1024L;
            long jpegSize = (long)((double)(tileSizeJpeg * numberOfTiles) * 1.3 * coverage) / 1024L;
            long pngSize = (long)((double)(tileSizePng * numberOfTiles) * 1.3 * coverage) / 1024L;
            long size = (fmt.indexOf("fits") >= 0 ? fitsSize : 0L) + (fmt.indexOf("jpeg") >= 0 ? jpegSize : 0L) + (fmt.indexOf("png") >= 0 ? pngSize : 0L) + 8L;
            this.setPropriete("hips_estsize", size + "");
        }
        String[] k = new String[this.keyAddProp == null ? 0 : this.keyAddProp.size()];
        String[] v = new String[k.length];
        for (int i = 0; i < k.length; ++i) {
            k[i] = this.keyAddProp.get(i);
            v[i] = this.valueAddProp.get(i);
        }
        this.updateProperties(k, v, true);
        this.writeIndexHtml();
        this.writeMetadataFits();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeHpxFinderProperties() throws Exception {
        String path;
        int frame = this.getFrame();
        MyProperties prop = new MyProperties();
        String label = this.getLabel();
        if ((label == null || label.trim().length() == 0) && (path = this.getOutputPath()) != null) {
            label = new File(path).getName();
        }
        if (label == null || label.trim().length() == 0) {
            label = "XXX_" + System.currentTimeMillis() / 1000L;
        }
        prop.setProperty("obs_collection", label + "_" + "HpxFinder");
        prop.setProperty("dataproduct_type", "meta");
        prop.setProperty("hips_frame", frame == 0 ? "equatorial" : (frame == 2 ? "ecliptic" : "galactic"));
        prop.setProperty("coordsys", frame == 0 ? "C" : (frame == 2 ? "E" : "G"));
        prop.setProperty("hips_order", this.getOrder() + "");
        if (this.minOrder > 3) {
            prop.setProperty("minOrder", this.minOrder + "");
        }
        prop.setProperty("hips_release_date", Context.getNow());
        prop.setProperty("hips_version", "1.3");
        prop.setProperty("hips_builder", "Aladin/HipsGen v8.155");
        String propFile = this.getHpxFinderPath() + cds.tools.Util.FS + "properties";
        File f = new File(propFile);
        if (f.exists()) {
            f.delete();
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(f);
            prop.store(out, null);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    protected String getAvailableTileFormats() {
        String path = BuilderAllsky.getFileName(this.getOutputPath(), 3, 0);
        StringBuffer res = new StringBuffer();
        for (int i = 0; i < Constante.TILE_EXTENSION.length; ++i) {
            File f = new File(path + Constante.TILE_EXTENSION[i]);
            if (!f.exists()) continue;
            if (res.length() > 0) {
                res.append(' ');
            }
            res.append(Constante.TILE_MODE[i]);
        }
        return res.toString();
    }

    private void replaceKey(MyProperties prop, String oldKey, String key) {
        if (prop.getProperty(key) == null) {
            prop.replaceKey(oldKey, key);
        }
    }

    private void replaceKeys(MyProperties prop) {
        String v;
        this.replaceKey(prop, "HiPSBuilder", "hips_builder");
        this.replaceKey(prop, "id", "publisher_did");
        this.replaceKey(prop, "label", "obs_collection");
        this.replaceKey(prop, "description", "obs_title");
        this.replaceKey(prop, "verboseDescription", "obs_description");
        this.replaceKey(prop, "descriptionVerbose", "obs_description");
        this.replaceKey(prop, "acknowledgement", "obs_ack");
        this.replaceKey(prop, "copyright", "obs_copyright");
        this.replaceKey(prop, "copyrightUrl", "obs_copyright_url");
        this.replaceKey(prop, "cubeDepth", "hips_cube_depth");
        this.replaceKey(prop, "cubeFirstFrame", "hips_cube_firstframe");
        this.replaceKey(prop, "processingDate", "hips_release_date");
        this.replaceKey(prop, "pixelRange", "hips_data_range");
        this.replaceKey(prop, "pixelCut", "hips_pixel_cut");
        this.replaceKey(prop, "maxOrder", "hips_order");
        this.replaceKey(prop, "minOrder", "hips_order_min");
        this.replaceKey(prop, "format", "hips_tile_format");
        this.replaceKey(prop, "nside", "hips_tile_width");
        this.replaceKey(prop, "category", "client_category");
        this.replaceKey(prop, "red", "hips_rgb_red");
        this.replaceKey(prop, "green", "hips_rgb_green");
        this.replaceKey(prop, "blue", "hips_rgb_blue");
        String s = prop.getProperty("firstProcessingDate");
        if (s != null && prop.getProperty("hips_creation_date") == null) {
            try {
                v = Constante.sdf.format(HipsGen.SDF.parse(s)) + "Z";
                prop.replaceKey("firstProcessingDate", "hips_creation_date");
                prop.replaceValue("hips_creation_date", v);
            }
            catch (ParseException e) {
                // empty catch block
            }
        }
        if ((s = prop.getProperty("processingDate")) != null && prop.getProperty("hips_release_date") == null) {
            try {
                v = Constante.sdf.format(HipsGen.SDF.parse(s)) + "Z";
                prop.replaceKey("processingDate", "hips_release_date");
                prop.replaceValue("hips_release_date", v);
            }
            catch (ParseException e) {
                // empty catch block
            }
        }
        if ((s = prop.getProperty("coordsys")) != null && prop.getProperty("hips_frame") == null) {
            v = s.equals("C") || s.equals("Q") ? "equatorial" : (s.equals("E") ? "ecliptic" : "galactic");
            prop.setProperty("hips_frame", v);
        }
        if ((s = prop.getProperty("target")) != null) {
            int i = s.indexOf(32);
            prop.setProperty("hips_initial_ra", s.substring(0, i));
            prop.setProperty("hips_initial_dec", s.substring(i + 1));
            prop.remove("target");
        }
        if ((s = prop.getProperty("targetRadius")) != null) {
            prop.replaceKey("targetRadius", "hips_initial_fov");
        }
        if ((s = prop.getProperty("isColored")) != null) {
            if (s.equals("true") && prop.getProperty("dataproduct_subtype") == null) {
                prop.setProperty("dataproduct_subtype", "color");
            }
            prop.remove("isColored");
        }
        if ((s = prop.getProperty("isCatalog")) != null) {
            if (s.equals("true") && prop.getProperty("dataproduct_type") == null) {
                prop.setProperty("dataproduct_type", "catalog");
            }
            prop.remove("isCatalog");
        }
        if ((s = prop.getProperty("isCube")) != null) {
            if (s.equals("true") && prop.getProperty("dataproduct_type") == null) {
                prop.setProperty("dataproduct_type", "cube");
            }
            prop.remove("isCube");
        }
        prop.remove("aladinVersion");
    }

    protected void updateProperties(String key, String value, boolean overwrite) throws Exception {
        this.updateProperties(new String[]{key}, new String[]{value}, overwrite);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateProperties(String[] key, String[] value, boolean overwrite) throws Exception {
        this.waitingPropertieFile();
        try {
            File dir;
            String propFile = this.getOutputPath() + cds.tools.Util.FS + "properties";
            this.prop = new MyProperties();
            File f = new File(propFile);
            if (f.exists()) {
                if (!f.canRead() || !f.canWrite()) {
                    throw new Exception("Propertie file not available ! [" + propFile + "]");
                }
                FileInputStream in = new FileInputStream(propFile);
                this.prop.load(in);
                in.close();
            }
            this.replaceKeys(this.prop);
            for (int i = 0; i < key.length; ++i) {
                String v;
                if (key[i].equals("hips_release_date") && this.prop.getProperty("hips_creation_date") == null && (v = this.prop.getProperty("hips_release_date")) != null) {
                    this.prop.setProperty("hips_creation_date", v);
                }
                if (key[i].charAt(0) == '#' && this.prop.getProperty(key[i].substring(1)) != null) continue;
                if (overwrite) {
                    if (value[i] == null) {
                        this.prop.remove(key[i]);
                    } else if (value[i] != null) {
                        this.prop.setProperty(key[i], value[i]);
                    }
                } else {
                    v = this.prop.getProperty(key[i]);
                    if (v == null && value[i] != null) {
                        this.prop.setProperty(key[i], value[i]);
                    }
                }
                if (value[i] == null || key[i].charAt(0) == '#' || this.prop.getProperty("#" + key[i]) == null) continue;
                this.prop.remove("#" + key[i]);
            }
            String tmp = this.getOutputPath() + cds.tools.Util.FS + "properties" + ".tmp";
            File ftmp = new File(tmp);
            if (ftmp.exists()) {
                ftmp.delete();
            }
            if (!(dir = new File(this.getOutputPath())).exists() && !dir.mkdir()) {
                throw new Exception("Cannot create output directory");
            }
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(ftmp);
                this.prop.store(out, null);
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
            if (f.exists() && !f.delete()) {
                throw new Exception("Propertie file locked ! (cannot delete)");
            }
            if (!ftmp.renameTo(new File(propFile))) {
                throw new Exception("Propertie file locked ! (cannot rename)");
            }
        }
        finally {
            this.releasePropertieFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadProperties() throws Exception {
        this.waitingPropertieFile();
        try {
            String propFile = this.getOutputPath() + cds.tools.Util.FS + "properties";
            this.prop = new MyProperties();
            File f = new File(propFile);
            if (f.exists()) {
                if (!f.canRead() || !f.canWrite()) {
                    throw new Exception("Propertie file not available ! [" + propFile + "]");
                }
                FileInputStream in = new FileInputStream(propFile);
                this.prop.load(in);
                in.close();
                this.replaceKeys(this.prop);
            }
        }
        finally {
            this.releasePropertieFile();
        }
    }

    private void waitingPropertieFile() {
        while (!this.getLock()) {
            try {
                Thread.currentThread();
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void releasePropertieFile() {
        this.lock = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getLock() {
        Object object = this.lockObj;
        synchronized (object) {
            if (this.lock) {
                return false;
            }
            this.lock = true;
            return true;
        }
    }

    protected double[] gal2ICRSIfRequired(double al, double del) {
        return this.gal2ICRSIfRequired(new double[]{al, del});
    }

    protected double[] gal2ICRSIfRequired(double[] aldel) {
        if (this.getFrame() == 0) {
            return aldel;
        }
        Astrocoo coo = (Astrocoo)COO_GAL.clone();
        coo.set(aldel[0], aldel[1]);
        coo.convertTo(AF_ICRS1);
        aldel[0] = coo.getLon();
        aldel[1] = coo.getLat();
        return aldel;
    }

    protected double[] ICRS2galIfRequired(double al, double del) {
        return this.ICRS2galIfRequired(new double[]{al, del});
    }

    protected double[] ICRS2galIfRequired(double[] aldel) {
        if (this.getFrame() == 0) {
            return aldel;
        }
        Astrocoo coo = (Astrocoo)COO_EQU.clone();
        coo.set(aldel[0], aldel[1]);
        coo.convertTo(AF_GAL1);
        aldel[0] = coo.getLon();
        aldel[1] = coo.getLat();
        return aldel;
    }

    private void fillUp(int[] npix, int nsize, int[] pos) {
        int i;
        int size = nsize * nsize;
        int[][] fils = new int[4][size / 4];
        int[] nb = new int[4];
        for (i = 0; i < size; ++i) {
            int dg = i % nsize < nsize / 2 ? 0 : 1;
            int bh = i < size / 2 ? 1 : 0;
            int quad = dg << 1 | bh;
            int j = pos == null ? i : pos[i];
            npix[j] = npix[j] << 2 | quad;
            int n = quad;
            int n2 = nb[n];
            nb[n] = n2 + 1;
            fils[quad][n2] = j;
        }
        if (size > 4) {
            for (i = 0; i < 4; ++i) {
                this.fillUp(npix, nsize / 2, fils[i]);
            }
        }
    }

    public void createHealpixOrder(int order) {
        int nside = (int)CDSHealpix.pow2(order);
        if (this.xy2hpx != null && this.xy2hpx.length == nside * nside) {
            return;
        }
        this.xy2hpx = new int[nside * nside];
        this.hpx2xy = new int[nside * nside];
        this.fillUp(this.xy2hpx, nside, null);
        for (int i = 0; i < this.xy2hpx.length; ++i) {
            this.hpx2xy[this.xy2hpx[i]] = i;
        }
    }

    public final int xy2hpx(int hpxOffset) {
        return this.xy2hpx[hpxOffset];
    }

    public final int hpx2xy(int xyOffset) {
        return this.hpx2xy[xyOffset];
    }

    public long getMem() {
        return Runtime.getRuntime().maxMemory() - (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory());
    }

    static {
        LABELRGB = new String[]{"red", "gree", "blue"};
        DATEFORMAT = new SimpleDateFormat("dd/MM/yy HH:mm:ss");
        COO_GAL = new Astrocoo(new Galactic());
        COO_EQU = new Astrocoo(new ICRS());
        AF_GAL1 = new Galactic();
        AF_ICRS1 = new ICRS();
    }

    protected static enum JpegMethod {
        MEDIAN,
        MEAN,
        FIRST;

    }
}

