/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

import cds.allsky.Action;
import cds.allsky.BuilderAllsky;
import cds.allsky.BuilderMoc;
import cds.allsky.BuilderTiles;
import cds.allsky.Context;
import cds.allsky.ThreadBuilderTile;
import cds.fits.Fits;

public class BuilderTree
extends BuilderTiles {
    private boolean first = true;

    public BuilderTree(Context context) {
        super(context);
    }

    @Override
    public Action getAction() {
        return Action.TREE;
    }

    @Override
    public void run() throws Exception {
        this.context.info("Creating " + this.context.getTileExt() + " tree and allsky (max depth=" + this.context.getOrder() + ")...");
        this.context.info("sky area to process: " + this.context.getNbLowCells() + " low level HEALPix cells");
        this.build();
        if (!this.context.isTaskAborting()) {
            new BuilderAllsky(this.context).run();
            this.context.info("Allsky done");
        }
    }

    @Override
    public void validateContext() throws Exception {
        this.validateOutput();
        if (!this.context.isExistingAllskyDir()) {
            throw new Exception("No tile found");
        }
        this.validateOrder(this.context.getOutputPath());
        try {
            this.context.loadMoc();
        }
        catch (Exception e) {
            new BuilderMoc(this.context).run();
            this.context.info("MOC rebuilt from low rhombs");
            this.context.loadMoc();
        }
        this.context.initRegion();
    }

    protected void setConstantes(Fits f) {
        this.first = false;
        this.context.bitpix = this.bitpix = f.bitpix;
        this.context.blank = this.blank = f.blank;
        this.context.bzero = this.bzero = f.bzero;
        this.context.bscale = this.bscale = f.bscale;
        if (this.context.bitpix != 0) {
            this.context.info("Found in first low rhomb: BITPIX=" + this.bitpix + " BLANK=" + this.blank + " BZERO=" + this.bzero + " BSCALE=" + this.bscale);
        } else {
            this.context.info("Colored pixels found in first low rhomb");
        }
    }

    @Override
    protected Fits createLeaveHpx(ThreadBuilderTile hpx, String file, int order, long npix, int z) throws Exception {
        long t = System.currentTimeMillis();
        Fits f = this.findLeaf(file);
        if (this.first && f != null) {
            this.setConstantes(f);
        }
        long duree = System.currentTimeMillis() - t;
        if (f == null) {
            this.updateStat(0, 0, 1, duree, 0, 0L);
        } else {
            this.updateStat(0, 1, 0, duree, 0, 0L);
        }
        return f;
    }
}

