/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

import cds.aladin.CanvasColorMap;
import cds.aladin.PlanBG;
import cds.aladin.PlanImage;
import cds.allsky.Action;
import cds.allsky.Builder;
import cds.allsky.BuilderAllsky;
import cds.allsky.BuilderMoc;
import cds.allsky.Constante;
import cds.allsky.Context;
import cds.allsky.ContextGui;
import cds.fits.Fits;
import cds.tools.pixtools.Util;
import java.awt.image.IndexColorModel;
import java.io.File;

public class BuilderRgb
extends Builder {
    private PlanBG[] p;
    private String path;
    private int width = -1;
    private double[] blank;
    private double[] bscale;
    private double[] bzero;
    private byte[][] tcm;
    private int[] bitpix;
    private int maxOrder = 100;
    private int missing = -1;
    private Context.JpegMethod method;
    private int format;
    private int statNbFile;
    private long statSize;
    private long startTime;
    private long totalTime;

    public BuilderRgb(Context context) {
        super(context);
    }

    @Override
    public Action getAction() {
        return Action.RGB;
    }

    @Override
    public void run() throws Exception {
        this.build();
        if (!this.context.isTaskAborting()) {
            new BuilderAllsky(this.context).createAllSkyColor(this.path, 3, Constante.TILE_MODE[this.format], 64, 0);
        }
        if (!this.context.isTaskAborting()) {
            new BuilderMoc(this.context).createMoc(this.path);
        }
    }

    @Override
    public void showStatistics() {
        this.context.showRgbStat(this.statNbFile, this.statSize, this.totalTime);
    }

    @Override
    public void validateContext() throws Exception {
        int c;
        Object[] plans = ((ContextGui)this.context).getRgbPlans();
        String path = ((ContextGui)this.context).getRgbOutput();
        Context.JpegMethod method = ((ContextGui)this.context).getRgbMethod();
        this.format = ((ContextGui)this.context).getRgbFormat();
        String label = null;
        this.p = new PlanBG[3];
        for (c = 0; c < 3; ++c) {
            if (!(plans[c] instanceof PlanBG)) continue;
            this.p[c] = (PlanBG)plans[c];
        }
        this.path = path;
        this.bitpix = new int[3];
        for (c = 0; c < 3; ++c) {
            this.bitpix[c] = 0;
        }
        this.blank = new double[3];
        this.bzero = new double[3];
        this.bscale = new double[3];
        this.tcm = new byte[3][];
        this.method = method;
        int frame = -1;
        for (int c2 = 0; c2 < 3; ++c2) {
            if (this.p[c2] == null) {
                this.missing = c2;
                continue;
            }
            if (label == null) {
                label = this.p[c2].label;
            }
            if (frame == -1) {
                frame = this.p[c2].getFrameOrigin();
            } else if (frame != this.p[c2].getFrameOrigin()) {
                this.context.warning("All components must be used the same HEALPix coordinate system !");
                return;
            }
            IndexColorModel cm = CanvasColorMap.getCM(this.p[c2].cmControl[0], this.p[c2].cmControl[1], this.p[c2].cmControl[2], false, this.p[c2].typeCM, this.p[c2].transfertFct, this.p[c2].isTransparent());
            this.tcm[c2] = cds.tools.Util.getTableCM(cm, 2);
            this.context.setPropriete(c2 == 0 ? "red" : (c2 == 1 ? "green" : "blue"), this.p[c2].label + " [" + this.p[c2].getPixelMin() + " " + this.p[c2].getPixelMiddle() + " " + this.p[c2].getPixelMax() + " " + PlanImage.TRANSFERTFCT[this.p[c2].transfertFct] + "]");
            int order = this.p[c2].getMaxFileOrder();
            if (this.maxOrder <= order) continue;
            this.maxOrder = order;
        }
        ((ContextGui)this.context).mainPanel.clearForms();
        this.context.setFrame(frame);
        this.context.setOrder(this.maxOrder);
        this.context.setOutputPath(path);
        this.context.setBitpixOrig(0);
        if (this.context.label == null || this.context.label.trim().length() == 0) {
            this.context.label = "RGB-" + label;
        }
        this.context.writePropertiesFile();
    }

    private void initStat() {
        this.statNbFile = 0;
        this.statSize = 0L;
        this.startTime = System.currentTimeMillis();
    }

    private void updateStat(File f) {
        ++this.statNbFile;
        this.statSize += f.length();
        this.totalTime = System.currentTimeMillis() - this.startTime;
    }

    public void build() throws Exception {
        this.initStat();
        for (int i = 0; i < 768; ++i) {
            if (this.context.isTaskAborting()) {
                new Exception("Task abort !");
            }
            String rgbfile = Util.getFilePath(this.path, 3, (long)i) + Constante.TILE_EXTENSION[this.format];
            if (!this.context.isInMocTree(3, i) || new File(rgbfile).exists()) continue;
            this.createRGB(3, i);
            this.context.setProgressLastNorder3(i);
        }
    }

    private Fits[] createRGB(int order, long npix) throws Exception {
        if (this.context.isTaskAborting()) {
            new Exception("Task abort !");
        }
        int trouve = 0;
        for (int c = 0; c < 3; ++c) {
            String file;
            if (c == this.missing || !new File(file = Util.getFilePath(this.p[c].getUrl(), order, npix) + ".fits").exists()) continue;
            ++trouve;
        }
        if (trouve == 0) {
            return null;
        }
        Fits[] out = null;
        if (order == this.maxOrder) {
            out = this.createLeaveRGB(order, npix);
        } else {
            Fits[][] fils = new Fits[4][3];
            boolean found = false;
            for (int i = 0; i < 4; ++i) {
                fils[i] = this.createRGB(order + 1, npix * 4L + (long)i);
                if (fils[i] == null || found) continue;
                found = true;
            }
            if (found) {
                out = this.createNodeRGB(fils);
            }
        }
        if (out != null) {
            this.generateRGB(out, order, npix);
        }
        return out;
    }

    private Fits[] createNodeRGB(Fits[][] fils) throws Exception {
        Fits[] out = new Fits[3];
        if (this.context.isTaskAborting()) {
            throw new Exception("Task abort !");
        }
        for (int c = 0; c < 3; ++c) {
            out[c] = new Fits(this.width, this.width, this.bitpix[c]);
            out[c].setBlank(this.blank[c]);
            out[c].setBzero(this.bzero[c]);
            out[c].setBscale(this.bscale[c]);
        }
        for (int dg = 0; dg < 2; ++dg) {
            for (int hb = 0; hb < 2; ++hb) {
                int quad = dg << 1 | hb;
                int offX = dg * this.width / 2;
                int offY = (1 - hb) * this.width / 2;
                for (int c = 0; c < 3; ++c) {
                    if (c == this.missing) continue;
                    Fits in = fils[quad] == null ? null : fils[quad][c];
                    double[] p = new double[4];
                    double[] coef = new double[4];
                    for (int y = 0; y < this.width; y += 2) {
                        for (int x = 0; x < this.width; x += 2) {
                            double pix = this.blank[c];
                            if (in != null) {
                                if (this.method == Context.JpegMethod.MEAN) {
                                    int i;
                                    double totalCoef = 0.0;
                                    for (i = 0; i < 4; ++i) {
                                        int dx = i == 1 || i == 3 ? 1 : 0;
                                        int dy = i >= 2 ? 1 : 0;
                                        p[i] = in.getPixelDouble(x + dx, y + dy);
                                        coef[i] = in.isBlankPixel(p[i]) ? 0.0 : 1.0;
                                        totalCoef += coef[i];
                                    }
                                    if (totalCoef != 0.0) {
                                        pix = 0.0;
                                        for (i = 0; i < 4; ++i) {
                                            if (coef[i] == 0.0) continue;
                                            pix += p[i] * (coef[i] / totalCoef);
                                        }
                                    }
                                } else {
                                    double p4;
                                    double p3;
                                    double p2;
                                    double p1 = in.getPixelDouble(x, y);
                                    if (in.isBlankPixel(p1)) {
                                        p1 = Double.NaN;
                                    }
                                    if (in.isBlankPixel(p2 = in.getPixelDouble(x + 1, y))) {
                                        p1 = Double.NaN;
                                    }
                                    if (in.isBlankPixel(p3 = in.getPixelDouble(x, y + 1))) {
                                        p1 = Double.NaN;
                                    }
                                    if (in.isBlankPixel(p4 = in.getPixelDouble(x + 1, y + 1))) {
                                        p1 = Double.NaN;
                                    }
                                    pix = p1 > p2 && (p1 < p3 || p1 < p4) || p1 < p2 && (p1 > p3 || p1 > p4) ? p1 : (p2 > p1 && (p2 < p3 || p2 < p4) || p2 < p1 && (p2 > p3 || p2 > p4) ? p2 : (p3 > p1 && (p3 < p2 || p3 < p4) || p3 < p1 && (p3 > p2 || p3 > p4) ? p3 : p4));
                                }
                            }
                            out[c].setPixelDouble(offX + x / 2, offY + y / 2, pix);
                        }
                    }
                }
            }
        }
        for (int j = 0; j < 4; ++j) {
            for (int c = 0; c < 3; ++c) {
                if (c == this.missing || fils[j] == null || fils[j][c] == null) continue;
                fils[j][c].free();
            }
        }
        return out;
    }

    private Fits[] createLeaveRGB(int order, long npix) throws Exception {
        if (this.context.isTaskAborting()) {
            new Exception("Task abort !");
        }
        Fits[] out = null;
        out = new Fits[3];
        for (int c = 0; c < 3; ++c) {
            if (c == this.missing) continue;
            out[c] = new Fits();
            try {
                out[c].loadFITS(Util.getFilePath(this.p[c].getUrl(), order, npix) + ".fits");
            }
            catch (Exception e) {
                out[c] = null;
            }
            if (out[c] == null || this.bitpix[c] != 0) continue;
            this.bitpix[c] = out[c].bitpix;
            this.blank[c] = out[c].blank;
            this.bscale[c] = out[c].bscale;
            this.bzero[c] = out[c].bzero;
            if (this.width != -1) continue;
            this.width = out[c].width;
        }
        return out;
    }

    private void generateRGB(Fits[] out, int order, long npix) throws Exception {
        byte[][] pixx8 = new byte[3][];
        for (int c = 0; c < 3; ++c) {
            if (c == this.missing || out[c] == null) continue;
            pixx8[c] = out[c].toPix8(this.p[c].getCutMin(), this.p[c].getCutMax(), this.tcm[c], this.format == 0 ? 4 : 3);
        }
        Fits rgb = new Fits(this.width, this.width, 0);
        int[] pix8 = new int[3];
        for (int i = this.width * this.width - 1; i >= 0; --i) {
            int pix;
            int tot = 0;
            for (int c = 0; c < 3; ++c) {
                if (c == this.missing) continue;
                if (out[c] == null) {
                    pix8[c] = 0;
                    continue;
                }
                pix8[c] = 0xFF & pixx8[c][i];
                tot += pix8[c];
            }
            if (this.missing != -1) {
                pix8[this.missing] = tot / 2;
            }
            if (tot == 0) {
                pix = 0;
            } else {
                pix = 255;
                for (int c = 0; c < 3; ++c) {
                    pix = pix << 8 | pix8[c];
                }
            }
            rgb.rgb[i] = pix;
        }
        String file = "";
        file = Util.getFilePath(this.path, order, npix) + Constante.TILE_EXTENSION[this.format];
        rgb.writeRGBPreview(file, Constante.TILE_MODE[this.format]);
        rgb.free();
        File f = new File(file);
        this.updateStat(f);
    }
}

