/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

import cds.aladin.HealpixProgen;
import cds.allsky.Action;
import cds.allsky.Builder;
import cds.allsky.BuilderAllsky;
import cds.allsky.Context;
import cds.tools.pixtools.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.RandomAccessFile;

public class BuilderDetails
extends Builder {
    public static final int MINORDER = 3;
    private int detailOrder;
    private int maxOrder;
    private long[] nbItemPerOrder;
    private int statNbFile;
    private long startTime;
    private long totalTime;
    private static final String METADATA = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n<!-- VOTable HiPS hpxfinder mapping file.\n     Use to map and build from a HpxFinder JSON tile a classical VOTable HiPS tile.\n     Adapt it according to your own (see examples below in the comments)\n-->\n\n<VOTABLE version=\"1.2\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n  xmlns=\"http://www.ivoa.net/xml/VOTable/v1.2\"\n  xsi:schemaLocation=\"http://www.ivoa.net/xml/VOTable/v1.2 http://www.ivoa.net/xml/VOTable/v1.2\">\n \n<RESOURCE>\n  <COOSYS ID=\"J2000\" system=\"eq_FK5\" equinox=\"J2000\"/>\n  <TABLE name=\"YOUR_SURVEY_LABEL\">\n    <FIELD name=\"RAJ2000\" ucd=\"pos.eq.ra\" ref=\"J2000\" datatype=\"double\" precision=\"5\" unit=\"deg\">\n      <DESCRIPTION>Right ascension</DESCRIPTION>\n    </FIELD>\n    <FIELD name=\"DEJ2000\" ucd=\"pos.eq.dec\" ref=\"J2000\" datatype=\"double\" precision=\"5\" unit=\"deg\">\n      <DESCRIPTION>Declination</DESCRIPTION>\n    </FIELD>\n    <FIELD name=\"id\" ucd=\"meta.id;meta.dataset\" datatype=\"char\" arraysize=\"13*\">\n      <DESCRIPTION>Dataset name, uniquely identifies the data for a given exposure.</DESCRIPTION>\n       <!-- Simple HTTP link description (Aladin will open it in a Web navigator)\n         <LINK href=\"http://your.server.edu/info?param=${id}&amp;otherparam=foo\"/>\n       -->\n     </FIELD>\n    <FIELD name=\"access\" datatype=\"char\" arraysize=\"9*\">\n      <DESCRIPTION>Display original image</DESCRIPTION>\n       <LINK content-type=\"image/fits\" href=\"${access}\"/>\n       <!--  Image HTTP link description (Aladin will load it)\n          <LINK content-type=\"image/fits\" href=\"http://your.server.edu/getdata?param=${id}&amp;otherparam=foo\" title=\"remote img\"/>\n        -->\n    </FIELD>\n    <FIELD name=\"FoV\" datatype=\"char\" utype=\"stc:ObservationLocation.AstroCoordArea.Region\" arraysize=\"12*\">\n       <DESCRIPTION>Field of View (STC description)</DESCRIPTION>\n    </FIELD>\n    <!-- Additional Field for extracting Instrument name from original filepath\n         see also associated TD example below\n       <FIELD name=\"Instrument\" datatype=\"char\" arraysize=\"12*\">\n          <DESCRIPTION>Instrument</DESCRIPTION>\n       </FIELD \n     -->\n<DATA>\n   <TABLEDATA> \n      <TR>\n      <TD>$[ra]</TD>\n      <TD>$[dec]</TD>\n      <TD>$[name]</TD>\n      <TD>$[path:([^\\[]*).*]</TD>\n      <TD>$[stc]</TD>\n      <!-- Extended example via prefix and regular expression mapping\n           (here, the instrument name is coded in the original path after \"data\" directory)\n           <TD>Instrument: $[path:.*/data/(.+)/.*]</TD> \n        -->\n      </TR>\n   </TABLEDATA>\n</DATA>\n</TABLE>\n</RESOURCE>\n</VOTABLE>\n\n";

    public BuilderDetails(Context context) {
        super(context);
    }

    @Override
    public Action getAction() {
        return Action.DETAILS;
    }

    @Override
    public void run() throws Exception {
        this.build();
    }

    @Override
    public void validateContext() throws Exception {
        this.validateOutput();
        this.validateIndex();
        this.maxOrder = Util.getMaxOrderByPath(this.context.getHpxFinderPath());
        if (this.maxOrder == -1) {
            throw new Exception("HpxFinder seems to be not yet ready ! (order=-1)");
        }
        this.context.info("Order retrieved from HpxFinder => " + this.maxOrder);
        if (this.context.getOrder() < this.maxOrder) {
            this.context.setMinOrder(this.context.getOrder());
        }
        this.context.setOrder(this.maxOrder);
        this.detailOrder = this.context.getMinOrder();
        if (this.detailOrder != -1) {
            this.context.info("Detail table min order determined by \"minOrder\" parameter => " + this.detailOrder);
        } else {
            this.validateImgWidth();
            if (this.context.typicalImgWidth == -1) {
                this.detailOrder = this.maxOrder - 5;
                this.context.warning("Detail table min order determined in function of max order => " + this.detailOrder);
            } else {
                this.detailOrder = this.maxOrder - this.context.typicalImgWidth / this.context.getTileSide() - 2;
                this.context.info("Detail table min order determined by original image resolution => " + this.detailOrder);
            }
        }
        if (this.detailOrder < 3) {
            this.detailOrder = 3;
        }
        if (this.detailOrder > this.maxOrder) {
            this.context.warning("The target Order (" + this.detailOrder + ") is greater than the index order (" + this.maxOrder + ") => assuming " + this.maxOrder + "...");
            this.detailOrder = this.maxOrder;
        }
        this.context.mocIndex = null;
        this.context.initRegion();
    }

    private void validateIndex() throws Exception {
        String path = this.context.getHpxFinderPath();
        if (path == null) {
            throw new Exception("HEALPix index directory [HpxFinder] not defined => specify the output (or input) directory");
        }
        File f = new File(path);
        if (!(f.exists() && f.isDirectory() && f.canWrite() && f.canRead())) {
            throw new Exception("HEALPix index directory not available [" + path + "]");
        }
    }

    private void validateImgWidth() throws Exception {
        String img = this.context.getImgEtalon();
        if (img == null && this.context.getInputPath() != null && (img = this.context.justFindImgEtalon(this.context.getInputPath())) != null) {
            this.context.info("Use this reference image => " + img);
        }
        if (img != null) {
            try {
                this.context.setImgEtalon(img);
            }
            catch (Exception e) {
                this.context.warning("Reference image problem [" + img + "] => " + e.getMessage());
            }
        }
    }

    @Override
    public void showStatistics() {
        this.context.showJpgStat(this.statNbFile, this.totalTime, 0, 0);
    }

    public void build() throws Exception {
        this.initStat();
        this.context.setProgressMax(768.0);
        String output = this.context.getHpxFinderPath();
        HealpixProgen allsky = null;
        this.nbItemPerOrder = new long[this.maxOrder + 1];
        for (int i = 0; i < 768; ++i) {
            HealpixProgen hi = this.createTree(output, 3, i);
            if (hi != null) {
                if (allsky == null) {
                    allsky = new HealpixProgen();
                }
                if (!allsky.hasTooMany()) {
                    allsky.merge(hi);
                    if (allsky.size() > HealpixProgen.TOOMANY) {
                        allsky.setTooMany(true);
                    }
                }
            }
            this.context.setProgress(i);
        }
        if (this.detailOrder > 3) {
            long size = 768L;
            int o = 3;
            while (o < this.detailOrder && this.nbItemPerOrder[o] > (long)HealpixProgen.TOOMANY * size) {
                String file = cds.tools.Util.concatDir(output, "Norder" + o);
                this.context.info("Removing HpxFinder detail order " + o + " (too many entries [" + this.nbItemPerOrder[o] + "])...");
                cds.tools.Util.deleteDir(new File(file));
                if (o == 3) {
                    allsky = null;
                }
                ++o;
                size *= 4L;
            }
            this.detailOrder = o;
        }
        if (allsky != null && !allsky.hasTooMany()) {
            String file = BuilderAllsky.getFileName(this.context.getHpxFinderPath(), 3, 0);
            this.writeIndexFile(file, allsky);
        }
        this.generateMedataFile();
    }

    private void initStat() {
        this.statNbFile = 0;
        this.startTime = System.currentTimeMillis();
    }

    private void updateStat() {
        ++this.statNbFile;
        this.totalTime = System.currentTimeMillis() - this.startTime;
    }

    private HealpixProgen createTree(String path, int order, long npix) throws Exception {
        if (this.context.isTaskAborting()) {
            throw new Exception("Task abort !");
        }
        if (!this.context.isInMocTree(order - 1, npix / 4L)) {
            return null;
        }
        String file = Util.getFilePath(path, order, npix);
        HealpixProgen out = null;
        if (order == this.maxOrder) {
            out = this.createLeave(file);
        } else {
            HealpixProgen[] fils = new HealpixProgen[4];
            boolean found = false;
            for (int i = 0; i < 4; ++i) {
                fils[i] = this.createTree(path, order + 1, npix * 4L + (long)i);
                if (fils[i] == null || found) continue;
                found = true;
            }
            if (found) {
                out = this.createNode(fils);
            }
        }
        if (order < this.detailOrder && out != null && out.size() > HealpixProgen.TOOMANY) {
            out.setTooMany(true);
        }
        if (out != null && this.context.isInMocTree(order, npix)) {
            int n = order;
            this.nbItemPerOrder[n] = this.nbItemPerOrder[n] + (long)out.size();
            if (!out.hasTooMany()) {
                this.writeIndexFile(file, out);
            }
        }
        if (out != null && out.hasTooMany()) {
            out = null;
        }
        return out;
    }

    private void writeIndexFile(String file, HealpixProgen map) throws Exception {
        cds.tools.Util.createPath(file);
        map.writeStream(new FileOutputStream(file));
    }

    private HealpixProgen createLeave(String file) throws Exception {
        File f = new File(file);
        if (!f.exists()) {
            return null;
        }
        HealpixProgen out = new HealpixProgen();
        out.loadStream(new FileInputStream(f));
        this.updateStat();
        return out;
    }

    private HealpixProgen createNode(HealpixProgen[] fils) throws Exception {
        HealpixProgen out = new HealpixProgen();
        for (int i = 0; i < 4; ++i) {
            if (fils[i] == null) continue;
            if (fils[i].hasTooMany()) {
                out.setTooMany(true);
                break;
            }
            out.merge(fils[i]);
            fils[i] = null;
        }
        return out;
    }

    private void generateMedataFile() throws Exception {
        String metadata = cds.tools.Util.concatDir(this.context.getHpxFinderPath(), "metadata.xml");
        if (new File(metadata).exists()) {
            this.context.info("Pre-existing metadata.xml file => keep it");
        } else {
            RandomAccessFile f = new RandomAccessFile(metadata, "rw");
            String s = METADATA.replace("YOUR_SURVEY_LABEL", this.context.getLabel() + " details");
            f.write(s.getBytes());
            f.close();
            this.context.info("Mapping hpxFinder/metadata.xml file has been generated");
        }
        this.context.writeHpxFinderProperties();
        this.context.writeIndexHtml();
    }
}

