/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

import cds.allsky.Action;
import cds.allsky.BuilderClean;
import cds.allsky.Context;
import cds.tools.pixtools.Util;
import java.io.File;

public class BuilderCleanDetails
extends BuilderClean {
    private String lastOrder;

    public BuilderCleanDetails(Context context) {
        super(context);
    }

    @Override
    public Action getAction() {
        return Action.CLEANDETAILS;
    }

    @Override
    public void validateContext() throws Exception {
        super.validateContext();
        int orderIndex = Util.getMaxOrderByPath(this.context.getHpxFinderPath());
        if (orderIndex == -1) {
            throw new Exception("HpxFinder order dir not found !");
        }
        this.lastOrder = "Norder" + orderIndex;
        this.context.info("Cleaning all Norder dir except " + this.lastOrder + "...");
    }

    public void deleteDirExceptLastOrder(File dir) throws Exception {
        if (this.context.isTaskAborting()) {
            throw new Exception("Task abort !");
        }
        for (File f : dir.listFiles()) {
            if (f.getName().equals(this.lastOrder)) continue;
            this.deleteDir(f);
        }
    }

    @Override
    public void run() throws Exception {
        this.deleteDirExceptLastOrder(new File(this.context.getHpxFinderPath()));
    }

    @Override
    public boolean mustBeDeleted(File f) {
        String name = f.getName();
        if (name.equals("metadata.xml")) {
            return false;
        }
        return !name.equals("Moc.fits");
    }
}

