/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

import cds.aladin.Coord;
import cds.allsky.Context;
import cds.allsky.TabBuild;
import cds.tools.Util;
import cds.tools.pixtools.CDSHealpix;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;

public class BuildTable
extends JTable {
    static int DEFAULT_BITPIX = -32;
    private Context context;
    private TabBuild tabBuild;
    private static final int MAXHEALPIXORDER = 21;
    private static final int CHECK_IDX = 0;
    private static final int RES_IDX = 1;
    private static final int NSIDE_IDX = 2;
    private static final int TILES_IDX = 3;
    private static final int VOL_IDX = 4;
    private static int[] columnSize = new int[]{60, 100, 120, 120, 80};
    private static String[] columnNames = new String[]{"", "<html>Pixel angular<br>resolution</html>", "<html>HEALPix:<br>order / NSIDE</html>", "<html>Tiles: (*)<br>Depth / Nb</html>", "<html>Space<br>required (*)</html>"};
    private static String[] columnToolTips = new String[]{"Your choice", "Target pixel angular resolution", "HEALPix parameters: order = log2(NSIDE)", "<html>Number of levels & Number of tiles (image 512x512)<br>at the end of the process<html>", "Disk space used at the end of the process"};
    int defaultRow = -1;
    private int defaultOrder = -1;
    static final Border bord = BorderFactory.createEmptyBorder(0, 10, 0, 0);

    BuildTable(Context context, TabBuild tabBuild) {
        super(BuildTable.createData(DEFAULT_BITPIX, context.getTileOrder()), columnNames);
        this.tabBuild = tabBuild;
        this.context = context;
        this.setAutoscrolls(true);
        for (int i = 0; i < columnSize.length; ++i) {
            this.getColumnModel().getColumn(i).setPreferredWidth(columnSize[i]);
        }
    }

    @Override
    protected JTableHeader createDefaultTableHeader() {
        return new JTableHeader(this.columnModel){

            @Override
            public String getToolTipText(MouseEvent e) {
                Point p = e.getPoint();
                int index = this.columnModel.getColumnIndexAtX(p.x);
                int realIndex = this.columnModel.getColumn(index).getModelIndex();
                return columnToolTips[realIndex];
            }
        };
    }

    public void setBitpix(int newbitpix) {
        BuildTable.setDiskHeader(newbitpix);
    }

    private static String getDiskHeader(int bitpix) {
        return "Disk space (bitpix=" + bitpix + ")";
    }

    public static void setDiskHeader(int bitpix) {
        BuildTable.columnToolTips[4] = BuildTable.getDiskHeader(bitpix);
    }

    public void setDefaultRow(int row) {
        this.defaultRow = row;
    }

    public int getDefaultRow() {
        return this.defaultRow;
    }

    public int setSelectedOrder(int order) {
        if (order < 3) {
            order = 3;
        }
        this.defaultOrder = order;
        this.setValueAt(Boolean.TRUE, order - 3, 0);
        return order - 3;
    }

    public void reset() {
        this.defaultOrder = -1;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            this.setValueAt(new Boolean(false), i, 0);
        }
    }

    public void refresh() {
        this.repaint();
    }

    @Override
    public Component prepareRenderer(TableCellRenderer renderer, int rowIndex, int colIndex) {
        Component c = super.prepareRenderer(renderer, rowIndex, colIndex);
        Color color = this.getBackground();
        if (rowIndex == this.defaultRow) {
            color = new Color(204, 234, 234);
        }
        c.setBackground(color);
        ((JComponent)c).setBorder(bord);
        if (colIndex == 2 && c instanceof JComponent) {
            ((JComponent)c).setToolTipText(this.getOrderToolTip(rowIndex));
        }
        return c;
    }

    private static Object[][] createData(int bitpix, int tileOrder) {
        Object[][] data = new Object[18][5];
        double surface = 41252.96124941927;
        long pixelPerFile = (long)Math.pow(4.0, tileOrder);
        long nbBytePerPixel = Math.abs(bitpix) / 8;
        for (int i = 0; i < data.length; ++i) {
            int order = i + 3 + 9;
            long nside = CDSHealpix.pow2(order);
            long nbPixel = 12L * nside * nside;
            data[i][0] = new Boolean(false);
            data[i][1] = Coord.getUnit(Math.sqrt(surface / (double)nbPixel));
            data[i][2] = order + " / " + nside;
            data[i][3] = i + 3 + " / " + nbPixel / pixelPerFile;
            data[i][4] = Util.getUnitDisk(nbPixel * nbBytePerPixel);
        }
        return data;
    }

    public int getOrder() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (this.getValueAt(i, 0) != Boolean.TRUE) continue;
            return i + 3;
        }
        return this.defaultOrder;
    }

    public String getOrderToolTip(int row) {
        return "<html>512 x 2<sup>" + (row + 3) + "</sup></html>";
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (column == 4) {
            double skyArea = this.context.getIndexSkyArea();
            long nbBytePerPixel = this.tabBuild.getNpix();
            int order = row + 3 + this.context.getTileOrder();
            long nside = CDSHealpix.pow2(order);
            long nbPixel = 12L * nside * nside;
            return Util.getUnitDisk((long)((double)(nbPixel * nbBytePerPixel) * skyArea * (row == 1 ? 1.0 : 1.33)));
        }
        if (column == 3 && this.context.mocIndex != null) {
            double skyArea = this.context.getIndexSkyArea();
            int order = row + 3 + this.context.getTileOrder();
            long nside = CDSHealpix.pow2(order);
            long nbPixel = 12L * nside * nside;
            return row + 3 + " / " + (long)((double)nbPixel * skyArea) / (long)(this.context.getTileSide() * this.context.getTileSide());
        }
        return super.getModel().getValueAt(row, column);
    }

    public Class<? extends Object> getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (col != 0) {
            super.setValueAt(value, row, col);
            return;
        }
        if (value == Boolean.TRUE && this.getValueAt(row, 0) == Boolean.TRUE) {
            return;
        }
        for (int i = 0; i < this.getRowCount(); ++i) {
            super.setValueAt(new Boolean(false), i, 0);
        }
        super.setValueAt(value, row, col);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col == 0;
    }
}

