/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Calib;
import cds.aladin.Coord;
import cds.aladin.Cote;
import cds.aladin.Hist;
import cds.aladin.Ligne;
import cds.aladin.Localisation;
import cds.aladin.Obj;
import cds.aladin.PlanBG;
import cds.aladin.PlanImage;
import cds.aladin.PlanImageCube;
import cds.aladin.PlanImageRGB;
import cds.aladin.PlanRGBInterface;
import cds.aladin.PointD;
import cds.aladin.Projection;
import cds.aladin.RectangleD;
import cds.aladin.Repere;
import cds.aladin.SED;
import cds.aladin.Select;
import cds.aladin.Source;
import cds.aladin.Tool;
import cds.aladin.ViewSimple;
import cds.aladin.Widget;
import cds.aladin.WidgetControl;
import cds.tools.Util;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import javax.swing.JComponent;

public final class ZoomView
extends JComponent
implements MouseWheelListener,
MouseListener,
MouseMotionListener,
Widget {
    protected int WENZOOM = 8;
    static int SIZE;
    Aladin aladin;
    Image img;
    Image imgwen;
    MemoryImageSource mImgWen;
    Graphics gwen;
    Image imgbuf;
    Graphics gbuf;
    int lastImgID = -1;
    RectangleD rectzoom;
    RectangleD or;
    boolean flagdrag;
    boolean imgok;
    Rectangle clip;
    int W;
    int H;
    double xwen;
    double ywen;
    private PointD oc;
    private int oframe;
    boolean zoomok;
    int xmwen;
    int ymwen;
    boolean memInv;
    boolean flagRGB;
    boolean flagwen;
    private int[] cut;
    private int[] cutR;
    private int[] cutG;
    private int[] cutB;
    protected boolean flagCut = false;
    private Obj objCut;
    Hist hist = null;
    SED sed = null;
    protected boolean flagHist = false;
    protected boolean flagSED = false;
    private boolean flagSynchronized = false;
    static Dimension DIM;
    private int cutX = -1;
    private int cutY = -1;
    private String INFO = null;
    private int ov = 0;
    private short oiz = (short)-2;
    private Projection proj = null;
    static final int CUTNORMAL = 0;
    static final int CUTRGB = 1;
    static final int CUTHIST = 2;
    private String oSrcSed = "";
    private byte[] pixels = null;
    private byte[] scalepixels = null;
    private int[] pixelsRGB = null;
    private int[] scalepixelsRGB = null;
    private static int WF;
    static int[] XF;
    static int[] YF;
    private int owidth;
    private int oheight;
    protected long startTaquinTime = 0L;
    private WidgetControl voc = null;

    protected ZoomView(Aladin aladin) {
        this.aladin = aladin;
        this.setOpaque(true);
        this.setBackground(Aladin.BLUE);
        SIZE = Select.ws + 16;
        this.setSize(SIZE, SIZE);
        this.cut = new int[SIZE];
        this.cutR = new int[SIZE];
        this.cutG = new int[SIZE];
        this.cutB = new int[SIZE];
        this.addMouseWheelListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.WENZOOM = 8;
    }

    @Override
    public Dimension getPreferredSize() {
        return DIM;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (this.aladin.inHelp) {
            return;
        }
        if (e.getClickCount() == 2) {
            return;
        }
        if (this.flagSED) {
            if (this.sed.mouseWheel(e)) {
                this.repaint();
            }
            return;
        }
        if (this.flagHist) {
            if (this.hist.mouseWheelMoved(e)) {
                this.repaint();
            }
            return;
        }
        this.synchronize(e);
        this.aladin.calque.zoom.incZoom(-e.getWheelRotation());
    }

    protected void free() {
        this.hist = null;
        this.sed = null;
        this.flagSED = false;
        this.flagHist = false;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.aladin.inHelp) {
            return;
        }
        if (this.flagCut || this.flagHist || this.flagSED) {
            return;
        }
        ViewSimple v = this.aladin.view.getCurrentView();
        v.stopAutomaticScroll();
        this.or = null;
        if (!v.isFree() && v.pref instanceof PlanBG) {
            this.setAllSkyCenter(v, e.getX(), e.getY());
        } else {
            this.flagdrag = true;
            this.newZoom(e.getX(), e.getY());
            this.synchronize(e);
        }
    }

    protected void synchronize(MouseEvent e) {
        if (e.isShiftDown() && this.flagSynchronized || !this.aladin.view.isMultiView()) {
            return;
        }
        ViewSimple vc = this.aladin.view.getCurrentView();
        if (vc == null || vc.isFree() || !Projection.isOk(vc.pref.projd)) {
            return;
        }
        if (e.isShiftDown()) {
            this.aladin.view.selectCompatibleViews();
            this.aladin.view.setZoomRaDecForSelectedViews(this.aladin.calque.zoom.getValue(), null);
            this.flagSynchronized = true;
        } else {
            this.flagSynchronized = false;
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.aladin.inHelp) {
            return;
        }
        if (this.flagSED) {
            return;
        }
        if (this.flagHist) {
            if (this.hist.mouseDragged(e)) {
                this.repaint();
            }
            return;
        }
        if (this.flagCut) {
            if (this.objCut instanceof Repere) {
                this.setFrameCube(e.getX());
            }
            return;
        }
        ViewSimple v = this.aladin.view.getCurrentView();
        if (v.isPlotView()) {
            return;
        }
        this.flagdrag = true;
        if (!v.isFree() && v.pref instanceof PlanBG) {
            this.setAllSkyCenter(v, e.getX(), e.getY());
        } else {
            this.synchronize(e);
            this.newZoom(e.getX(), e.getY());
            this.drawInViewNow(e.getX(), e.getY());
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.aladin.inHelp) {
            return;
        }
        if (this.flagSED) {
            this.sed.mouseMove(e.getX(), e.getY());
            this.repaint();
            return;
        }
        if (this.INFO == null) {
            this.INFO = Aladin.chaine.getString("ZINFO");
        }
        this.aladin.status.setText(this.INFO);
        this.cutX = e.getX();
        this.cutY = e.getY();
        if (this.flagHist && this.hist.setOnMouse(e.getX(), e.getY())) {
            this.repaint();
            if (this.hist.flagHistPixel) {
                this.aladin.view.getCurrentView().repaint();
            }
        } else if (this.flagCut) {
            this.repaint();
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.aladin.inHelp) {
            return;
        }
        if (this.flagSED) {
            this.sed.mouseExit();
            this.repaint();
            return;
        }
        Aladin.makeCursor(this, 0);
        if (this.aladin.view.flagHighlight) {
            this.hist.resetHighlightSource();
            this.aladin.view.flagHighlight = false;
            this.aladin.view.repaint();
        }
        if (this.flagCut || this.flagHist) {
            if (this.flagHist) {
                this.hist.setOnMouse(-1, -1);
            }
            this.cutY = -1;
            this.cutX = -1;
            this.repaint();
            if (this.hist != null && this.hist.flagHistPixel) {
                this.aladin.view.getCurrentView().repaint();
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.aladin.inHelp) {
            this.aladin.help.setText(this.Help());
            return;
        }
        if (this.flagSED) {
            this.sed.mouseEnter();
            return;
        }
        boolean resize = this.flagCut;
        if (this.objCut instanceof Repere && ((Repere)this.objCut).hasRayon()) {
            resize = false;
        }
        if (Ligne.isLigne(this.objCut)) {
            resize = false;
        }
        Aladin.makeCursor(this, resize ? 5 : 2);
    }

    protected Coord drawInViewNow(double xmouse, double ymouse) {
        ViewSimple vc = this.aladin.view.getCurrentView();
        if (vc == null || vc.isFree()) {
            return null;
        }
        Coord coo = null;
        if (!vc.isPlotView()) {
            try {
                Projection proj = vc.getProj();
                if (Projection.isOk(proj)) {
                    PointD p = vc.zoomViewToImage(xmouse, ymouse);
                    coo = new Coord();
                    coo.x = p.x;
                    coo.y = p.y;
                    proj.getCoord(coo);
                    if (Double.isNaN(coo.al)) {
                        coo = null;
                    }
                }
            }
            catch (Exception e) {
                coo = null;
            }
        }
        if (coo == null) {
            this.calculZoom(vc, xmouse, ymouse);
            this.repaint();
            vc.repaint();
        } else {
            this.aladin.view.setZoomRaDecForSelectedViews(0.0, coo, vc, false, true);
            this.aladin.view.syncView(1.0, coo, null);
        }
        return coo;
    }

    private void setFrameCube(int xc) {
        ViewSimple vc = this.aladin.view.getCurrentView();
        int nbFrame = vc.cubeControl.nbFrame;
        int frame = (int)((double)nbFrame * ((double)xc / (double)SIZE));
        if (frame >= nbFrame) {
            frame = nbFrame - 1;
        }
        if (frame < 0) {
            frame = 0;
        }
        vc.cubeControl.setFrameLevel(frame);
        vc.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.aladin.inHelp) {
            this.aladin.helpOff();
            return;
        }
        if (this.flagSED) {
            this.sed.mouseRelease(e.getX(), e.getY());
            return;
        }
        if (this.flagCut) {
            if (this.objCut instanceof Repere) {
                this.setFrameCube(e.getX());
            }
            this.flagdrag = false;
            return;
        }
        if (this.flagHist) {
            if (e.getX() < 10) {
                if (this.hist.mouseDragged(e)) {
                    this.repaint();
                }
            } else {
                if (this.hist.inCroix(e.getX(), e.getY())) {
                    this.stopHist();
                } else {
                    this.hist.selectHighlightSource();
                }
                this.aladin.calque.repaintAll();
            }
            return;
        }
        this.flagSynchronized = false;
        ViewSimple v = this.aladin.view.getCurrentView();
        if (e.isControlDown() || v.isPlotView()) {
            v.reInitZoom(true);
            return;
        }
        Coord coo = this.drawInViewNow(e.getX(), e.getY());
        if (coo != null) {
            this.aladin.view.setRepere(coo);
        }
        this.flagdrag = false;
    }

    protected void startDrag() {
        this.flagdrag = true;
    }

    protected void stopDrag() {
        this.flagdrag = false;
        this.or = null;
        this.repaint();
    }

    protected boolean newZoom(double xc, double yc) {
        return this.newZoom(this.aladin.view.getCurrentView(), xc, yc);
    }

    protected boolean newZoom(ViewSimple v, double xc, double yc) {
        if (v.locked) {
            return false;
        }
        if (!this.calculZoom(v, xc, yc)) {
            return false;
        }
        this.repaint();
        return true;
    }

    protected boolean calculZoom(ViewSimple v, double xc, double yc) {
        this.zoomok = false;
        if (v.isFree()) {
            return false;
        }
        v.setZoomXY(v.zoom, xc, yc);
        if (this.rectzoom != null && v.rzoomView.equals(this.rectzoom)) {
            this.zoomok = true;
            return false;
        }
        this.rectzoom = v.rzoomView;
        this.aladin.calque.zoom.setValue(v.zoom);
        v.newView();
        this.zoomok = true;
        return true;
    }

    protected void resetImgID() {
        this.lastImgID = -1;
    }

    protected boolean drawImgZoom(ViewSimple v) {
        this.mImgWen = null;
        int w = this.getWidth();
        int h = this.getHeight();
        if (this.imgbuf == null || this.imgbuf.getWidth(this.aladin) != w || this.imgbuf.getHeight(this.aladin) != h) {
            if (this.gbuf != null) {
                this.gbuf.dispose();
            }
            this.imgbuf = this.aladin.createImage(w, h);
            this.gbuf = this.imgbuf.getGraphics();
        }
        if (v == null || v.isFree() || !v.pref.isImage() || v.northUp) {
            if (this.lastImgID != -2) {
                this.gbuf.setColor(Aladin.LBLUE);
                this.gbuf.fillRect(0, 0, w, h);
                this.drawBord(this.gbuf);
                this.lastImgID = -2;
            }
            if (v != null && !v.isFree()) {
                this.calculZoom(v, v.xzoomView, v.yzoomView);
            }
        } else {
            try {
                PlanImage pi = (PlanImage)v.pref;
                if (this.lastImgID != pi.getImgID() || pi.pixelsZoom.length != w * h) {
                    Image pimg;
                    this.gbuf.setColor(Aladin.LBLUE);
                    this.gbuf.fillRect(0, 0, w, h);
                    if (pi.type == 2 || pi.type == 20) {
                        if (((PlanRGBInterface)((Object)pi)).getPixelsZoomRGB() == null) {
                            ((PlanRGBInterface)((Object)pi)).calculPixelsZoomRGB();
                        }
                        pimg = this.createImage(new MemoryImageSource(w, h, ((PlanRGBInterface)((Object)pi)).getPixelsZoomRGB(), 0, w));
                    } else {
                        pi.calculPixelsZoom();
                        pimg = this.createImage(new MemoryImageSource(w, h, pi.cm, pi.pixelsZoom, 0, w));
                    }
                    this.gbuf.drawImage(pimg, 0, 0, this);
                    this.drawBord(this.gbuf);
                    this.lastImgID = pi.getImgID();
                    this.calculZoom(v, v.xzoomView, v.yzoomView);
                }
            }
            catch (OutOfMemoryError eOut) {
                this.aladin.gc();
                return false;
            }
            catch (Exception ezoom) {
                ezoom.printStackTrace();
                System.out.println("Try ezoom error: " + ezoom);
                return false;
            }
        }
        this.img = this.imgbuf;
        return true;
    }

    protected void setAllSkyCenter(ViewSimple v, double xc, double yc) {
        Coord c = new Coord();
        c.x = xc;
        c.y = yc;
        this.proj.getCoord(c);
        if (Double.isNaN(c.al)) {
            return;
        }
        v.goToAllSky(c);
    }

    private void drawAllSkyControl(Graphics g, ViewSimple v) {
        block10: {
            try {
                int w = this.getWidth();
                int h = this.getHeight();
                if (this.imgbuf == null || this.imgbuf.getWidth(this.aladin) != w || this.imgbuf.getHeight(this.aladin) != h) {
                    if (this.gbuf != null) {
                        this.gbuf.dispose();
                    }
                    this.imgbuf = this.aladin.createImage(w, h);
                    this.gbuf = this.imgbuf.getGraphics();
                }
                if (this.oiz != v.iz || this.ov != v.hashCode()) {
                    int x = w / 2;
                    int y = h / 2;
                    int ga = 4 * w / 10;
                    this.gbuf.setColor(Color.white);
                    this.gbuf.fillRect(0, 0, w, h);
                    this.oiz = v.iz;
                    this.ov = v.hashCode();
                    if (this.proj == null) {
                        this.proj = new Projection(null, 0, 0.0, 0.0, 21600.0, (double)(w / 2), (double)(h / 2), (double)w, 0.0, false, 4, Calib.FK5);
                    } else {
                        this.proj.frame = 0;
                    }
                    Coord c = new Coord(0.0, 0.0);
                    this.proj.getXY(c);
                    x = (int)c.x;
                    y = (int)c.y;
                    c.al = 180.0;
                    this.proj.getXY(c);
                    ga = (int)Math.abs(c.x - (double)x);
                    int pa = ga / 2;
                    this.gbuf.setColor(Aladin.GREEN);
                    this.gbuf.drawOval(x - ga, y - pa, ga * 2, pa * 2);
                    this.gbuf.drawOval(x - (ga + pa) / 2, y - pa, ga + pa, pa * 2);
                    this.gbuf.drawOval(x - pa, y - pa, pa * 2, pa * 2);
                    this.gbuf.drawOval(x - pa / 2, y - pa, pa, pa * 2);
                    this.gbuf.drawLine(x - ga, y, x + ga, y);
                    this.gbuf.drawLine(x, y - pa, x, y + pa);
                    Coord[] coin = v.getCouverture();
                    if (coin != null) {
                        this.proj.frame = this.aladin.localisation.getFrame();
                        this.gbuf.setColor(Color.blue);
                        for (int i = 0; i < coin.length; ++i) {
                            if (Double.isNaN(coin[i].al)) continue;
                            c.al = coin[i].al;
                            c.del = coin[i].del;
                            this.proj.getXY(c);
                            this.gbuf.drawLine((int)c.x, (int)c.y, (int)c.x, (int)c.y);
                        }
                        c = v.getCooCentre();
                        if (c == null) {
                            System.out.println("Gag ++ ");
                            this.proj = v.pref.projd = new Projection("allsky", 2, 0.0, 0.0, 240.0, 240.0, 250.0, 250.0, 500.0, 500.0, 0.0, false, 1, Calib.FK5);
                            v.pref.projd.frame = this.aladin.localisation.getFrame();
                            v.projLocal = v.pref.projd.copy();
                            this.drawAllSkyControl(g, v);
                            return;
                        }
                        this.proj.getXY(c);
                        this.gbuf.setColor(Color.red);
                        Util.fillCircle7(this.gbuf, (int)c.x, (int)c.y);
                    }
                    this.gbuf.setFont(Aladin.SPLAIN);
                    this.gbuf.setColor(Aladin.GREEN);
                    this.gbuf.drawString("+90", x - 5, y - pa - 2);
                    this.gbuf.drawString("-90", x - 5, y + pa + 10);
                    this.gbuf.drawString("-180", w - this.gbuf.getFontMetrics().stringWidth("+270"), y + 35);
                    this.gbuf.drawString("+180", 1, y - 25);
                    this.gbuf.setFont(Aladin.SPLAIN);
                    FontMetrics fm = this.gbuf.getFontMetrics();
                    String s = "Frame: " + Localisation.REPERE[this.aladin.localisation.getFrame()];
                    this.gbuf.drawString(s, SIZE - fm.stringWidth(s) - 2, 10);
                    this.gbuf.setColor(Color.red);
                    s = this.aladin.localisation.J2000ToString(c.al, c.del);
                    this.gbuf.drawString(s, w / 2 - fm.stringWidth(s) / 2, h - 16);
                    this.gbuf.setColor(Color.blue);
                    s = v.getTaille(0);
                    this.gbuf.drawString(s, w / 2 - fm.stringWidth(s) / 2, h - 4);
                    this.drawBord(this.gbuf);
                }
                g.drawImage(this.imgbuf, 0, 0, this);
            }
            catch (Exception e) {
                if (Aladin.levelTrace < 3) break block10;
                e.printStackTrace();
            }
        }
    }

    private void drawBord(Graphics g) {
        Util.drawEdge(g, this.getWidth(), this.getHeight());
    }

    protected void setCM(IndexColorModel ic) {
        this.repaint();
    }

    protected void drawImgHist(Graphics g) {
        this.hist.draw(g);
        this.drawBord(g);
    }

    protected boolean drawImgSED(Graphics g) {
        if (this.sed.getCount() == 0) {
            return false;
        }
        this.sed.draw(g);
        this.drawBord(g);
        return true;
    }

    protected void drawImgCut(Graphics g) {
        int i;
        int w = this.getWidth();
        int h = this.getHeight();
        g.clearRect(1, 1, w - 2, h - 2);
        this.drawBord(g);
        boolean trouve = false;
        for (i = 1; i < this.cut.length - 1; ++i) {
            if (this.cut[i] == 0 && this.cutR[i] == 0 && this.cutG[i] == 0 && this.cutB[i] == 0) continue;
            trouve = true;
            break;
        }
        if (!trouve) {
            this.aladin.status.setText("Nothing in cut graph !!");
            return;
        }
        if (this.cut[0] != -1) {
            g.setColor(Color.cyan);
            for (i = 1; i < this.cut.length - 1; ++i) {
                g.drawLine(i, h - this.cut[i], i, h);
            }
            g.setColor(Color.blue);
            for (i = 1; i < this.cut.length - 1; ++i) {
                g.drawLine(i, h - this.cut[i - 1], i, h - this.cut[i]);
            }
        } else {
            g.setColor(Color.red);
            for (i = 1; i < this.cutR.length - 1; ++i) {
                g.drawLine(i - 1, h - this.cutR[i - 1], i, h - this.cutR[i]);
            }
            g.setColor(Color.green);
            for (i = 1; i < this.cutG.length - 1; ++i) {
                g.drawLine(i - 1, h - this.cutG[i - 1], i, h - this.cutG[i]);
            }
            g.setColor(Color.blue);
            for (i = 1; i < this.cutB.length - 1; ++i) {
                g.drawLine(i - 1, h - this.cutB[i - 1], i, h - this.cutB[i]);
            }
        }
    }

    private void drawFWHM(Graphics g) {
        int x2;
        int x1;
        if (this.cutX < 0 || this.cut[0] == -1) {
            return;
        }
        int y = SIZE - this.cutY;
        PlanImage pimg = (PlanImage)this.aladin.calque.getPlanBase();
        String pixel = "pixel value: " + pimg.getPixelInfoFromGrey(y * 256 / SIZE);
        g.setFont(Aladin.SPLAIN);
        g.setColor(Color.black);
        g.drawLine(1, this.cutY, 4, this.cutY);
        g.drawLine(SIZE - 4, this.cutY, SIZE, this.cutY);
        g.drawString(pixel, 25, this.cutY < 20 ? SIZE - 2 : 10);
        for (x1 = this.cutX; x1 > 0 && y <= this.cut[x1]; --x1) {
        }
        for (x2 = this.cutX; x2 < SIZE && y <= this.cut[x2]; ++x2) {
        }
        if (x2 <= x1) {
            return;
        }
        g.setColor(Color.red);
        g.drawLine(x1 + 1, this.cutY, x2 - 1, this.cutY);
        g.drawLine(x1 + 1, this.cutY + 1, x2 - 1, this.cutY + 1);
        double distXY = ((Cote)this.objCut).getDistXY();
        if (distXY == -1.0) {
            return;
        }
        double f = (double)(x2 - x1) * distXY / (double)SIZE;
        String fwhm = Util.myRound(f + "", 1) + "pix";
        int x = SIZE - this.cutX < 40 ? this.cutX - 50 : this.cutX + 7;
        g.drawString(fwhm, x, this.cutY - 2);
        double dist = ((Cote)this.objCut).getDist();
        if (dist != -1.0) {
            g.drawString(Coord.getUnit(dist * f / distXY), x, this.cutY + 15);
        }
    }

    private void drawPixelCourant(Graphics g) {
        block4: {
            try {
                PlanImage p = (PlanImage)this.aladin.calque.getPlanBase();
                if (p == null) {
                    return;
                }
                g.setColor(Color.blue);
                g.setFont(Aladin.SPLAIN);
                String s = p.getPixelInfoFromGrey(0);
                g.drawString(s, 2, 10);
                s = p.getPixelInfoFromGrey(255);
                g.drawString(s, SIZE - g.getFontMetrics().stringWidth(s) - 2, 10);
                if (this.cutX > 0) {
                    s = p.getPixelInfoFromGrey((int)Math.floor((double)this.cutX * (256.0 / (double)SIZE)));
                    int x = this.cutX;
                    g.setColor(Color.red);
                    g.drawLine(x, 0, x, SIZE);
                    int len = g.getFontMetrics().stringWidth(s);
                    x = x + len > SIZE - 5 ? x - 5 - len : (x += 5);
                    g.drawString(s, x, SIZE - 5);
                }
            }
            catch (Exception e) {
                if (Aladin.levelTrace < 3) break block4;
                e.printStackTrace();
            }
        }
    }

    private void drawCubeFrame(Graphics g) {
        int width = this.getWidth();
        int height = this.getHeight();
        ViewSimple vc = this.aladin.view.getCurrentView();
        int frame = vc.cubeControl.lastFrame;
        int nbFrame = vc.cubeControl.nbFrame;
        int x = (int)((double)width * ((double)frame / (double)nbFrame));
        int w = Math.max(1, (int)((double)width / (double)nbFrame));
        g.setColor(Color.red);
        g.fillRect(x, 0, w, height);
        PlanImageCube pic = null;
        pic = vc.pref.type == 4 ? (PlanImageCube)vc.pref : null;
        g.setFont(Aladin.SPLAIN);
        String s = pic != null && pic.fromCanal ? pic.getCanalValue(frame) : "" + (frame + 1);
        int l = g.getFontMetrics().stringWidth(s);
        g.drawString(s, x + l + w > width ? x - l - 2 : x + w + 2, height - 2);
        int y = height - this.cutY;
        String pixel = ((PlanImage)vc.pref).getPixelInfoFromGrey(y * 256 / height);
        if (pixel.length() == 0) {
            return;
        }
        g.setColor(Color.black);
        g.drawLine(1, this.cutY, width, this.cutY);
        g.drawString(pixel, 10, this.cutY < 20 ? this.cutY + 10 : this.cutY - 2);
    }

    protected void suspendCut() {
        this.flagCut = false;
        this.repaint();
    }

    protected Obj getObjCut() {
        return this.objCut;
    }

    protected void cutOff(Obj objCut) {
        if (objCut != this.objCut) {
            return;
        }
        this.setCut(null);
    }

    protected void setCut(int[] v) {
        this.setCut(null, v, 0);
    }

    protected void setCut(Obj objCut, int[] v, int mode) {
        this.cutX = -1;
        this.objCut = objCut;
        if (objCut == null || v == null || this.aladin.toolBox.tool[6].mode == -1) {
            if (this.flagCut) {
                this.repaint();
            }
            this.flagCut = false;
            return;
        }
        this.flagCut = true;
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.cut == null || this.cut.length != width) {
            this.cut = new int[width];
            this.cutR = new int[width];
            this.cutG = new int[width];
            this.cutB = new int[width];
        }
        double f = (double)height / 256.0;
        double w = (double)v.length / (double)width;
        int j = 0;
        for (int i = 0; i < width; ++i) {
            int n = 0;
            double sw = w * (double)i;
            if (mode == 1) {
                this.cut[0] = -1;
                boolean valid = true;
                double tG = 0.0;
                double tB = 0.0;
                double tR = 0.0;
                while ((double)j < sw && j < v.length) {
                    if (valid && v[j] == -1) {
                        valid = false;
                    }
                    tR += (double)(v[j] >> 16 & 0xFF);
                    tG += (double)(v[j] >> 8 & 0xFF);
                    tB += (double)(v[j] & 0xFF);
                    ++j;
                    ++n;
                }
                tR /= (double)n;
                tG /= (double)n;
                tB /= (double)n;
                if (!valid) {
                    this.cutG[i] = this.cutB[i] = SIZE;
                    this.cutR[i] = this.cutB[i];
                    continue;
                }
                this.cutR[i] = (int)(f * tR);
                this.cutG[i] = (int)(f * tG);
                this.cutB[i] = (int)(f * tB);
                if (this.cutR[i] == 0 && i > 0) {
                    this.cutR[i] = this.cutR[i - 1];
                }
                if (this.cutG[i] == 0 && i > 0) {
                    this.cutG[i] = this.cutG[i - 1];
                }
                if (this.cutB[i] != 0 || i <= 0) continue;
                this.cutB[i] = this.cutB[i - 1];
                continue;
            }
            double t = 0.0;
            boolean valid = true;
            while ((double)j < sw && j < v.length) {
                if (valid && v[j] == -1) {
                    valid = false;
                }
                t += (double)v[j++];
                ++n;
            }
            t /= (double)n;
            if (!valid) {
                this.cut[i] = 0;
                continue;
            }
            this.cut[i] = (int)(f * t);
            if (mode != 0 || this.cut[i] != 0 || i <= 0) continue;
            this.cut[i] = this.cut[i - 1];
        }
        this.repaint();
    }

    protected void clearSED() {
        this.flagSED = false;
        this.oSrcSed = "";
        this.aladin.view.simRep = null;
        this.aladin.calque.repaintAll();
    }

    protected void setSED(String source) {
        this.setSED(source, null);
    }

    protected void setSED(String source, Repere simRep) {
        if (source == null) {
            source = "";
        }
        if (this.oSrcSed.equals(source)) {
            return;
        }
        this.oSrcSed = source;
        if (source.length() == 0) {
            this.clearSED();
        } else {
            if (this.sed == null) {
                this.sed = new SED(this.aladin);
            }
            this.flagSED = true;
            this.flagHist = false;
            this.sed.setRepere(simRep);
            this.sed.loadFromSource(source);
        }
        this.repaint();
    }

    protected void setSED(Source o) {
        String source;
        String string = source = o == null ? null : o.id;
        if (source == null) {
            source = "";
        }
        this.oSrcSed = source;
        if (source.length() == 0) {
            this.clearSED();
        } else {
            if (this.sed == null) {
                this.sed = new SED(this.aladin);
            }
            this.sed.clear();
            this.flagSED = true;
            this.flagHist = false;
            this.sed.addFromIterator(this.aladin.mesure.iterator());
            this.sed.setHighLight(o);
        }
        this.repaint();
    }

    protected void resumeSED() {
        Source s = this.aladin.mesure.getFirstSrc();
        if (!(s != null && s.leg.isSED() || this.flagSED)) {
            return;
        }
        this.setSED(s);
    }

    protected void stopHist() {
        if (!this.flagHist) {
            return;
        }
        this.flagHist = false;
        this.aladin.view.flagHighlight = false;
        this.hist.resetHighlightSource();
        this.repaint();
    }

    protected void initPixelHist() {
        int w = this.getWidth();
        int h = this.getHeight();
        if (this.hist == null || this.hist.width != w || this.hist.height != h) {
            this.hist = new Hist(this.aladin, w, h);
        }
        this.hist.startHistPixel();
    }

    protected void addPixelHist(double pix) {
        this.hist.addPixel(pix);
    }

    protected void createPixelHist(String titre) {
        this.hist.createHistPixel(titre);
    }

    protected void activeHistPixel(String texte) {
        this.flagHist = true;
        this.hist.setText(texte);
        this.repaint();
    }

    protected boolean setHist(Source o, int nField) {
        boolean rep = false;
        this.flagSED = false;
        this.oSrcSed = "";
        int w = this.getWidth();
        int h = this.getHeight();
        if (this.hist == null || this.hist.width != w || this.hist.height != h) {
            this.hist = new Hist(this.aladin, w, h);
            rep = true;
        }
        boolean bl = this.hist.o != o || this.hist.nField != nField;
        this.flagHist = this.hist.init(o, nField);
        this.repaint();
        return rep |= bl;
    }

    protected void changeWen(int sens) {
        if (sens == -1 && this.WENZOOM > 8) {
            this.WENZOOM /= 2;
            this.oc = null;
            this.mImgWen = null;
        } else if (sens == 1 && this.WENZOOM < 64) {
            this.WENZOOM *= 2;
            this.oc = null;
            this.mImgWen = null;
        }
        this.repaint();
    }

    protected void setPixelTable(boolean flag) {
        this.WENZOOM = flag ? 32 : 8;
    }

    protected void drawImgWen() {
        ViewSimple v = this.aladin.view.getMouseView();
        if (v == null || v.isFree() || !v.pref.isImage() || v.isProjSync() || v.northUp) {
            this.img = null;
            this.imgok = false;
            return;
        }
        PointD c = v.getPosition(this.xwen, this.ywen);
        int frame = v.pref.type == 3 || v.pref.type == 4 ? v.cubeControl.lastFrame : this.oframe;
        if (c.equals(this.oc) && frame == this.oframe) {
            return;
        }
        this.oc = c;
        this.oframe = frame;
        this.calculWen(v, (int)c.x, (int)c.y);
    }

    protected void calculWen(ViewSimple v, int x, int y) {
        boolean isPlanRGB;
        this.xmwen = x;
        this.ymwen = y;
        int w = (int)Math.ceil((double)SIZE / (double)this.WENZOOM);
        int x1 = this.xmwen - w / 2;
        int y1 = this.ymwen - w / 2;
        PlanImage p = (PlanImage)v.pref;
        boolean bl = isPlanRGB = p.type == 2;
        if (v.hashCode() != this.ov) {
            this.mImgWen = null;
        }
        this.ov = v.hashCode();
        if (isPlanRGB) {
            if (this.pixelsRGB == null || this.pixelsRGB.length != w * w) {
                this.pixelsRGB = new int[w * w];
            }
            if (this.scalepixelsRGB == null || this.scalepixelsRGB.length != w * w * this.WENZOOM * this.WENZOOM) {
                this.scalepixelsRGB = new int[w * w * this.WENZOOM * this.WENZOOM];
            }
        } else {
            if (this.pixels == null || this.pixels.length != w * w) {
                this.pixels = new byte[w * w];
            }
            if (this.scalepixels == null || this.scalepixels.length != w * w * this.WENZOOM * this.WENZOOM) {
                this.scalepixels = new byte[w * w * this.WENZOOM * this.WENZOOM];
            }
        }
        if (x1 >= 0 && y1 >= 0 && x1 + w < p.width && y1 + w < p.height) {
            if (isPlanRGB) {
                PlanImageRGB pi = (PlanImageRGB)p;
                pi.getPixels(this.pixelsRGB, x1, y1, w, w);
                this.flagRGB = true;
                int d = 0;
                for (int i = 0; i < w; ++i) {
                    int orig = d;
                    for (int k = 0; k < w; ++k) {
                        int c = this.pixelsRGB[i * w + k];
                        for (int m = 0; m < this.WENZOOM; ++m) {
                            this.scalepixelsRGB[d + m] = c;
                        }
                        d += this.WENZOOM;
                    }
                    for (int j = 1; j < this.WENZOOM; j += j) {
                        System.arraycopy(this.scalepixelsRGB, orig, this.scalepixelsRGB, orig + j * w * this.WENZOOM, j * this.WENZOOM * w);
                    }
                    d += (this.WENZOOM - 1) * this.WENZOOM * w;
                }
            } else {
                p.getPixels(this.pixels, x1, y1, w, w);
                this.flagRGB = false;
                int d = 0;
                for (int i = 0; i < w; ++i) {
                    int orig = d;
                    for (int k = 0; k < w; ++k) {
                        byte c = this.pixels[i * w + k];
                        for (int m = 0; m < this.WENZOOM; ++m) {
                            this.scalepixels[d + m] = c;
                        }
                        d += this.WENZOOM;
                    }
                    for (int j = 1; j < this.WENZOOM; j += j) {
                        System.arraycopy(this.scalepixels, orig, this.scalepixels, orig + j * w * this.WENZOOM, j * this.WENZOOM * w);
                    }
                    d += (this.WENZOOM - 1) * this.WENZOOM * w;
                }
            }
        }
        if (isPlanRGB) {
            if (this.mImgWen == null) {
                this.mImgWen = new MemoryImageSource(w * this.WENZOOM, w * this.WENZOOM, this.scalepixelsRGB, 0, w * this.WENZOOM);
                this.mImgWen.setAnimated(true);
                this.imgwen = this.getToolkit().createImage(this.mImgWen);
            } else {
                this.mImgWen.newPixels(this.scalepixelsRGB, ColorModel.getRGBdefault(), 0, w * this.WENZOOM);
            }
        } else if (this.mImgWen == null) {
            this.mImgWen = new MemoryImageSource(w * this.WENZOOM, w * this.WENZOOM, p.cm, this.scalepixels, 0, w * this.WENZOOM);
            this.mImgWen.setAnimated(true);
            this.imgwen = this.getToolkit().createImage(this.mImgWen);
        } else {
            this.mImgWen.newPixels(this.scalepixels, p.cm, 0, w * this.WENZOOM);
        }
        if (this.flagwen) {
            this.imgok = true;
            this.img = this.imgwen;
        }
    }

    private void drawInfo(Graphics g, int w, int h) {
        try {
            Projection proj = this.aladin.view.getCurrentView().pref.projd;
            if (proj.isXYLinear()) {
                return;
            }
            Calib c = proj.c;
            String w1 = Coord.getUnit(c.getImgWidth());
            String h1 = Coord.getUnit(c.getImgHeight());
            g.setFont(Aladin.SPLAIN);
            g.setColor(Color.blue);
            String s = w1 + " x " + h1;
            g.drawString(s, w / 2 - g.getFontMetrics().stringWidth(s) / 2, h - 10);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private static void drawFleche(Graphics g, int x, int y, char d) {
        int dx;
        int n = d == 'W' ? -WF : (dx = d == 'E' ? WF : 0);
        int dy = d == 'N' ? -WF : (d == 'S' ? WF : 0);
        int xb = x + dx;
        int yb = y + dy;
        g.drawLine(x, y, xb, yb);
        ZoomView.XF[0] = xb;
        ZoomView.YF[0] = yb;
        ZoomView.XF[1] = xb + (dy /= 3) - (dx /= 3);
        ZoomView.YF[1] = yb - dy - dx;
        ZoomView.XF[2] = xb - dy - dx;
        ZoomView.YF[2] = yb - dy + dx;
        g.fillPolygon(XF, YF, 3);
        g.drawPolygon(XF, YF, 3);
    }

    String getTaquinTime() {
        long time = (System.currentTimeMillis() - this.startTaquinTime) / 1000L;
        return Util.align2((int)time / 60) + ":" + Util.align2((int)time % 60);
    }

    protected boolean isPixelTable() {
        return this.WENZOOM >= 32;
    }

    protected void copier() {
        if (!this.flagHist) {
            return;
        }
        String s = this.hist.getCopier();
        this.aladin.copyToClipBoard(s);
    }

    @Override
    public void paintComponent(Graphics gr) {
        Dimension d;
        if (Aladin.NOGUI) {
            return;
        }
        this.aladin.setAliasing(gr);
        ViewSimple v = this.aladin.view.getCurrentView();
        int w = this.getWidth();
        int h = this.getHeight();
        if (v == null || v.isFree()) {
            gr.setColor(Aladin.LBLUE);
            gr.fillRect(0, 0, w, h);
            this.drawBord(gr);
            return;
        }
        Dimension dimension = d = v == null ? new Dimension(0, 0) : v.getSize();
        if (this.flagwen) {
            this.imgok = true;
            this.drawImgWen();
        } else if (!this.flagdrag) {
            this.imgok = this.drawImgZoom(v);
        }
        if (this.flagHist) {
            this.drawImgHist(gr);
            return;
        }
        if (this.flagSED && this.drawImgSED(gr)) {
            return;
        }
        if (this.flagCut) {
            this.drawImgCut(gr);
            try {
                if (this.objCut instanceof Cote) {
                    this.drawFWHM(gr);
                } else if (this.objCut instanceof Repere) {
                    if (((Repere)this.objCut).hasRayon()) {
                        this.drawPixelCourant(gr);
                    } else {
                        this.drawCubeFrame(gr);
                    }
                } else if (Ligne.isLigne(this.objCut)) {
                    this.drawPixelCourant(gr);
                }
            }
            catch (Exception e) {
                this.setCut(null);
            }
            return;
        }
        if (v.isPlotView()) {
            gr.clearRect(0, 0, w, h);
            this.drawBord(gr);
            return;
        }
        if (v.pref instanceof PlanBG) {
            this.drawAllSkyControl(gr, v);
            return;
        }
        if (!(Aladin.NOGUI || v == null || v.isFree() || d.width == this.owidth && d.height == this.oheight)) {
            this.owidth = d.width;
            this.oheight = d.height;
            this.newZoom(v.xzoomView, v.yzoomView);
            return;
        }
        if (this.imgok) {
            gr.drawImage(this.img, 0, 0, this);
        } else {
            gr.clearRect(0, 0, w, h);
        }
        if (this.aladin.view.flagTaquin) {
            gr.setFont(new Font("Helvetica", 1, 30));
            gr.setColor(Color.red);
            if (this.startTaquinTime == 0L) {
                this.startTaquinTime = System.currentTimeMillis();
            }
            gr.drawString(this.getTaquinTime(), 38, w / 2 + 15);
            this.drawBord(gr);
            return;
        }
        if (!(v == null || v.isFree() || this.flagwen || this.flagCut || this.rectzoom == null)) {
            this.drawArea(gr, (int)Math.round(this.rectzoom.x), (int)Math.round(this.rectzoom.y), (int)Math.round(this.rectzoom.width - 1.0), (int)Math.round(this.rectzoom.height - 1.0));
            gr.setColor(Color.blue);
            this.drawInfo(gr, w, h);
        }
        if (this.flagwen && this.imgok) {
            int n = (int)Math.ceil((double)SIZE / (double)this.WENZOOM);
            int c = n / 2 * this.WENZOOM;
            int W2 = this.WENZOOM / 2;
            gr.setColor(Color.blue);
            gr.drawRect(c, c, this.WENZOOM, this.WENZOOM);
            if (this.WENZOOM <= 16) {
                ZoomView.drawFleche(gr, c + W2, c - this.WENZOOM, 'N');
                ZoomView.drawFleche(gr, c + W2, c + 2 * this.WENZOOM, 'S');
                ZoomView.drawFleche(gr, c - this.WENZOOM, c + W2, 'W');
                ZoomView.drawFleche(gr, c + 2 * this.WENZOOM, c + W2, 'E');
            }
            gr.setFont(Aladin.LBOLD);
            gr.setColor(Color.red);
            if (this.WENZOOM > 8) {
                gr.drawString("-", w - 11, h - 15);
            }
            if (this.WENZOOM < 64) {
                gr.drawString("+", w - 12, h - 5);
            }
            if (this.isPixelTable() && v.pref.type != 2) {
                v = this.aladin.view.getMouseView();
                int step = this.WENZOOM == 32 ? 2 : 1;
                gr.setFont(Aladin.BOLD);
                gr.setColor(Color.black);
                int j = 0;
                int y1 = this.ymwen - step;
                while (y1 <= this.ymwen + step) {
                    int i = 0;
                    int x1 = this.xmwen - step;
                    while (x1 <= this.xmwen + step) {
                        int xx = i * this.WENZOOM + 8;
                        int yy = j * this.WENZOOM + 2 * this.WENZOOM / 3 - 7 + i % 2 * this.WENZOOM / 2;
                        String pix = ((PlanImage)v.pref).getPixelInfo(x1, y1, 3);
                        Util.drawStringOutline(gr, pix, xx, yy, y1 == this.ymwen && x1 == this.xmwen ? Color.cyan : Color.white, Color.black);
                        ++x1;
                        ++i;
                    }
                    ++y1;
                    ++j;
                }
            }
        }
        this.drawBord(gr);
    }

    private void drawArea(Graphics g, int x, int y, int width, int height) {
        Util.drawArea(this.aladin, g, x, y, width, height, Color.blue, 0.15f, true);
        int w = this.getWidth();
        int h = this.getHeight();
        g.setColor(Color.red);
        if (x + width < 0) {
            ZoomView.drawFleche(g, 15, h / 2, 'W');
        }
        if (y + height < 0) {
            ZoomView.drawFleche(g, w / 2, 15, 'N');
        }
        if (x >= SIZE) {
            ZoomView.drawFleche(g, w - 15, h / 2, 'E');
        }
        if (y >= SIZE) {
            ZoomView.drawFleche(g, w / 2, h - 15, 'S');
        }
    }

    protected void wen(double x, double y) {
        if (!this.flagwen) {
            return;
        }
        if (this.xwen == x && this.ywen == y) {
            return;
        }
        this.xwen = x;
        this.ywen = y;
        this.repaint();
    }

    protected void wenOn() {
        this.flagwen = true;
    }

    void wenOff() {
        this.flagwen = false;
        this.repaint();
    }

    protected String Help() {
        return Aladin.chaine.getString("ZoomView.HELP");
    }

    @Override
    public WidgetControl getWidgetControl() {
        return this.voc;
    }

    @Override
    public void createWidgetControl(int x, int y, int width, int height, float opacity, JComponent parent) {
        this.voc = new WidgetControl(this, x, y, width, height, opacity, parent);
        this.voc.setResizable(true);
    }

    @Override
    public void paintCollapsed(Graphics g) {
        Tool.drawVOHand(g, 3, 2);
    }

    static {
        DIM = new Dimension(Select.ws + 16, Select.ws + 16);
        WF = 12;
        XF = new int[3];
        YF = new int[3];
    }
}

