/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Glu;
import cds.aladin.MCanvas;
import cds.aladin.MyLabel;
import cds.aladin.Obj;
import cds.tools.Util;

public final class Words
implements Runnable {
    static final int LEFT = 0;
    static final int RIGHT = 1;
    static final int CENTER = 2;
    static final int COORD = 3;
    String text;
    int width;
    int precision;
    String id;
    String param;
    int x;
    int y;
    int w;
    int h;
    int align;
    int size;
    int sort;
    boolean computed = false;
    boolean glu;
    boolean repere;
    boolean pin;
    boolean archive;
    boolean samp;
    boolean footprint;
    boolean onMouse;
    boolean show;
    boolean pushed = false;
    boolean haspushed = false;
    Thread thread;
    MCanvas m;
    Glu g;
    private boolean callArchive = false;
    private Aladin _aladin;
    private Obj _o;

    protected Words(String tag) {
        this(tag, 0, -1, 0);
    }

    protected Words(String tag, int width) {
        this(tag, width, -1, 0);
    }

    protected Words(String tag, int width, int precision, int align) {
        this(tag, width, precision, align, false, 0);
    }

    protected Words(String tag, int width, int precision, int align, boolean computed, int sort) {
        this.width = width;
        this.precision = precision;
        this.align = align;
        this.computed = computed;
        this.sort = sort;
        char[] a = tag.toCharArray();
        this.glu = this.tagGlu(a);
        if (!this.glu) {
            this.text = tag;
        }
        this.setRepere();
    }

    protected Words(String tag, int width, int precision, int align, boolean computed, boolean footprint) {
        this(tag, width, precision, align);
        this.computed = computed;
        this.footprint = footprint;
    }

    void setRepere() {
        this.repere = false;
        if (!this.glu) {
            return;
        }
        String type = this.id.substring(0, 1);
        if (type.equals("_")) {
            this.repere = true;
        } else if (type.equals("^")) {
            this.archive = true;
        } else if (type.equals("\u00a3")) {
            this.archive = true;
            this.samp = true;
        } else {
            return;
        }
        this.id = this.id.substring(1);
    }

    protected void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    protected String getText() {
        return this.text;
    }

    protected void urlStatus(MyLabel urlStatus) {
        String s = this.id.equals("Http") ? this.param : (this.param.length() > 0 ? "Glu tag: <&" + this.id + " " + this.param + ">" : "Glu: <&" + this.id + ">");
        urlStatus.setText(s);
    }

    protected void setPosition(int x, int y, int w, int h) {
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
    }

    int anchorGlu(char[] a, int i) {
        int j;
        StringBuffer anchor = new StringBuffer();
        for (j = i + 1; j < a.length && a[j] != '>'; ++j) {
            anchor.append(a[j]);
        }
        if (j == i) {
            return j;
        }
        this.text = anchor.toString();
        return j == a.length ? -1 : j;
    }

    int paramGlu(char[] a, int i) {
        int j;
        StringBuffer param = new StringBuffer();
        for (j = i; j < a.length && a[j] == ' ' && a[j] != '>' && a[j] != '|'; ++j) {
        }
        while (j < a.length && a[j] != '>' && a[j] != '|') {
            param.append(a[j]);
            ++j;
        }
        if (j == i) {
            return j;
        }
        this.param = this.text = param.toString();
        return j == a.length ? -1 : j;
    }

    int idGlu(char[] a, int i) {
        int j;
        StringBuffer id = new StringBuffer();
        for (j = i; j < a.length && a[j] != ' ' && a[j] != '>' && a[j] != '|'; ++j) {
            id.append(a[j]);
        }
        if (j == i) {
            return -1;
        }
        this.id = this.text = id.toString();
        return j == a.length ? -1 : j;
    }

    protected boolean tagGlu(char[] a) {
        if (a.length < 2 || a[0] != '<' || a[1] != '&') {
            return false;
        }
        int i = 2;
        if ((i = this.idGlu(a, i)) < 0) {
            return false;
        }
        if ((i = this.paramGlu(a, i)) < 0) {
            return false;
        }
        if (a[i] == '|' && (i = this.anchorGlu(a, i)) < 0) {
            return false;
        }
        if (a[i] != '>') {
            return false;
        }
        this.size = i + 1;
        return true;
    }

    protected boolean inside(int xc, int yc) {
        return xc >= this.x - 4 && xc <= this.x + this.w + 2 && yc >= this.y - 1 && yc <= this.y + this.h + 1;
    }

    protected boolean onBord(int xc, int yc) {
        return xc >= this.x + this.w - 3 && xc <= this.x + this.w + 3 && yc >= this.y - 1 && yc <= this.y + this.h + 1;
    }

    protected void callGlu(Glu g, MCanvas m) {
        this.g = g;
        this.m = m;
        this.pushed = true;
        this.haspushed = true;
        this.thread = new Thread((Runnable)this, "AladinCallGlu");
        this.thread.setPriority(4);
        this.thread.start();
    }

    @Override
    public void run() {
        if (this.callArchive) {
            this.callArchive = false;
            this.callArchive1(this._aladin, this._o);
        } else {
            this.g.showDocument(this.id, this.param, this.id.equals("Http"));
        }
        Util.pause(3000);
        this.pushed = false;
        if (this.m != null) {
            this.m.repaint();
        }
    }

    protected void callArchive(Aladin aladin, Obj o) {
        this.pushed = true;
        this.haspushed = true;
        this.callArchive = true;
        this._aladin = aladin;
        this._o = o;
        this.thread = new Thread((Runnable)this, "AladinCallGlu");
        this.thread.setPriority(4);
        this.thread.start();
    }

    private void callArchive1(Aladin aladin, Obj o) {
        String label = this.param;
        boolean flagHttp = this.id.equals("Http");
        String url = null;
        if (flagHttp) {
            url = this.param;
        } else {
            try {
                url = aladin.glu.getURL(this.id, this.param, flagHttp) + "";
                if (url == null) {
                    throw new Exception("Error during GLU resolution !");
                }
            }
            catch (Exception e) {
                Aladin.warning(aladin, "URL error");
                if (Aladin.levelTrace >= 3) {
                    e.printStackTrace();
                }
                return;
            }
        }
        if (label.startsWith("http://") || label.startsWith("https://") || label.startsWith("ftp://")) {
            label = this.text;
        }
        if (this.samp) {
            aladin.mesure.mcanvas.toSamp(url, this.x + this.w / 2, this.y);
            return;
        }
        aladin.calque.newPlan(url, label, "provided by the original archive server", o);
    }
}

