/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Action;
import cds.aladin.Aladin;
import cds.aladin.MetaDataTree;
import cds.aladin.PlanFilter;
import cds.aladin.Source;
import cds.astro.Unit;
import cds.tools.Util;
import cds.tools.parser.Parser;
import cds.tools.parser.ParserException;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class UCDFilter {
    static final String UNDEFINED = "undefined";
    static String ERR1;
    static String ERR2;
    static String ERR3;
    static String ERR4;
    static String ERR5;
    static String ERR6;
    static String ERR7;
    static String ERR8;
    static String ERR9;
    static String ERR10;
    static String ERR11;
    static String ERR12;
    static String ERR13;
    private static final String GT = ">";
    private static final String GE = ">=";
    private static final String LT = "<";
    private static final String LE = "<=";
    private static final String EQ = "=";
    private static final String NE = "!=";
    private boolean convertProblem = false;
    private int nbConvertProblem = 0;
    private int numero;
    private int position;
    private String curOperator = null;
    private Vector<ConstraintsBlock> constraintsBlocks;
    private ConstraintsBlock block;
    protected String definition;
    boolean isValidated = false;
    boolean badSyntax = false;
    String name = null;
    Aladin a;
    PlanFilter pf;

    protected void createChaine() {
        ERR1 = Aladin.chaine.getString("UFERR1");
        ERR2 = Aladin.chaine.getString("UFERR2");
        ERR3 = Aladin.chaine.getString("UFERR3");
        ERR4 = Aladin.chaine.getString("UFERR4");
        ERR5 = Aladin.chaine.getString("UFERR5");
        ERR6 = Aladin.chaine.getString("UFERR6");
        ERR7 = Aladin.chaine.getString("UFERR7");
        ERR8 = Aladin.chaine.getString("UFERR8");
        ERR9 = Aladin.chaine.getString("UFERR9");
        ERR10 = Aladin.chaine.getString("UFERR10");
        ERR11 = Aladin.chaine.getString("UFERR11");
        ERR12 = Aladin.chaine.getString("UFERR12");
        ERR13 = Aladin.chaine.getString("UFERR13");
    }

    UCDFilter(String name, String constraints, Aladin a, PlanFilter pf) {
        this.a = a;
        this.createChaine();
        this.name = name;
        this.pf = pf;
        this.decodeConstraints(constraints);
        if (!this.badSyntax) {
            this.isValidated = true;
        }
    }

    UCDFilter(String definition, Aladin a, PlanFilter pf) {
        this.a = a;
        this.pf = pf;
        this.decodeDefinition(definition);
        if (!this.badSyntax) {
            this.isValidated = true;
        }
    }

    protected void changeDefinition(String newDef) {
        this.isValidated = false;
        this.badSyntax = false;
        String oldDef = this.definition;
        this.decodeConstraints(newDef);
        if (!this.badSyntax) {
            this.isValidated = true;
        }
    }

    void setNumero(int numero) {
        this.numero = numero;
    }

    protected void resetActions() {
        Enumeration<ConstraintsBlock> e = this.constraintsBlocks.elements();
        ConstraintsBlock cb = null;
        while (e.hasMoreElements()) {
            cb = e.nextElement();
            for (int i = 0; i < cb.actions.length; ++i) {
                cb.actions[i].reset();
            }
        }
    }

    private void decodeConstraints(String def) {
        this.constraintsBlocks = new Vector();
        while (def.length() > 0 && def.charAt(0) == '\n') {
            def = def.substring(1);
        }
        this.definition = new String(def);
        def = def.replace('\t', ' ');
        String tmp = new String("");
        StringTokenizer st = new StringTokenizer(def, "\n");
        while (st.hasMoreTokens()) {
            String curTok = st.nextToken();
            if (UCDFilter.skipSpaces(curTok).startsWith("#")) continue;
            tmp = tmp + curTok + "\n";
        }
        def = tmp;
        if (Action.countNbOcc('{', def) != Action.countNbOcc('}', def)) {
            this.badSyntax = true;
            Aladin.warning(ERR1, 1);
            return;
        }
        if (Action.countNbOcc('[', def) != Action.countNbOcc(']', def)) {
            this.badSyntax = true;
            Aladin.warning(ERR2, 1);
            return;
        }
        int longueur = def.length();
        int indice = 0;
        while (indice < longueur) {
            int endAction;
            this.block = new ConstraintsBlock();
            int beginAction = this.getOpeningBracket(def, indice);
            if (beginAction < 0) {
                if (indice != 0 || !def.trim().startsWith("draw")) break;
                def = "{" + def + "}";
                this.definition = "{\n" + this.definition + "\n}";
                longueur += 2;
                beginAction = 0;
            }
            if ((endAction = this.getClosingBracket(def, beginAction + 1)) < 0) {
                this.badSyntax = true;
                Aladin.warning(ERR3, 1);
                return;
            }
            String constraintsStr = def.replace('$', ' ').substring(indice, beginAction);
            String actionStr = def.replace('$', ' ').substring(beginAction + 1, endAction);
            this.block.actions = this.getActions(actionStr);
            for (int i = 0; i < this.block.actions.length; ++i) {
                if (!this.block.actions[i].badSyntax) continue;
                this.badSyntax = true;
                return;
            }
            if (UCDFilter.skipSpaces(constraintsStr = constraintsStr.replace('\n', ' ')).length() == 0) {
                constraintsStr = "1=1";
            }
            int index = 0;
            String str = new String();
            while (index < constraintsStr.length()) {
                int i1 = constraintsStr.substring(index).indexOf("\"");
                if (i1 >= 0) {
                    int i2 = constraintsStr.substring((i1 += index) + 1).indexOf("\"");
                    if (i2 >= 0) {
                        str = str + UCDFilter.skipSpaces(constraintsStr.substring(index, i1));
                        str = str + constraintsStr.substring(i1, (i2 += i1 + 1) + 1);
                        index = i2 + 1;
                        continue;
                    }
                    str = str + UCDFilter.skipSpaces(constraintsStr.substring(index));
                    index = constraintsStr.length();
                    continue;
                }
                str = str + UCDFilter.skipSpaces(constraintsStr.substring(index));
                index = constraintsStr.length();
            }
            constraintsStr = MetaDataTree.replace(str, "==", EQ, -1);
            String[] conditions = this.getConditions(constraintsStr);
            this.block.valueConstraints = new Constraint[conditions.length];
            for (int i = 0; i < conditions.length; ++i) {
                if (conditions[i].startsWith(UNDEFINED)) {
                    this.block.valueConstraints[i] = this.decodeUndefinedConstraint(conditions[i]);
                } else {
                    if (!this.containsOperator(conditions[i])) {
                        Aladin.warning(ERR9, 1);
                        this.badSyntax = true;
                        return;
                    }
                    this.block.valueConstraints[i] = this.decodeValueConstraint(conditions[i]);
                }
                if (!this.badSyntax) continue;
                return;
            }
            for (int l = 0; l < conditions.length; ++l) {
                constraintsStr = UCDFilter.replace(constraintsStr, conditions[l], "\\" + l);
            }
            this.block.checkExpr = constraintsStr = UCDFilter.replace(UCDFilter.replace(constraintsStr, "||", "+"), "&&", "*");
            this.constraintsBlocks.addElement(this.block);
            this.block = new ConstraintsBlock();
            indice = endAction + 1;
        }
    }

    private String[] getConditions(String s) {
        StringTokenizer st = new StringTokenizer(s, "|&");
        String workStr = null;
        String[] conditions = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            int pos;
            int rIndex;
            int lIndex;
            String curToken = st.nextToken();
            String saveToken = new String(curToken);
            if (curToken.startsWith(UNDEFINED)) {
                conditions[i] = curToken;
                ++i;
                continue;
            }
            if (curToken.indexOf("\"") > 0 && (lIndex = curToken.indexOf("\"")) != (rIndex = curToken.lastIndexOf("\""))) {
                String btw = curToken.substring(lIndex, rIndex + 1);
                btw = btw.replace('(', 'X');
                btw = btw.replace(')', 'X');
                btw = btw.replace('{', 'X');
                btw = btw.replace('}', 'X');
                btw = btw.replace('[', 'X');
                btw = btw.replace(']', 'X');
                curToken = saveToken.substring(0, lIndex) + btw + saveToken.substring(rIndex + 1);
            }
            this.containsOperator(curToken);
            String tmp = curToken.substring(0, this.position);
            if (tmp.indexOf("(") >= 0) {
                int length;
                pos = length = tmp.length();
                workStr = "";
                while (pos > 0 && Action.countNbOcc(')', workStr) >= Action.countNbOcc('(', workStr)) {
                    workStr = tmp.substring(--pos);
                }
                if (Action.countNbOcc('(', workStr) > Action.countNbOcc(')', workStr)) {
                    workStr = workStr.substring(1);
                    ++pos;
                }
            } else {
                pos = 0;
            }
            int finCond = curToken.substring(this.position).indexOf(41);
            finCond = finCond < 0 ? curToken.length() : (finCond += this.position);
            conditions[i] = workStr = saveToken.substring(pos, finCond);
            ++i;
        }
        return conditions;
    }

    private Constraint decodeUndefinedConstraint(String constraint) {
        int begin = constraint.indexOf("(");
        int end = constraint.indexOf(")");
        if (begin < 0 || end < 0 || begin > end) {
            Aladin.warning(ERR10 + " " + UNDEFINED + " " + ERR11, 1);
            this.badSyntax = true;
            return null;
        }
        String undefVar = constraint.substring(begin + 1, end);
        return new Constraint(undefVar);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Constraint decodeValueConstraint(String constraint) {
        Parser parser;
        int indexOperator = constraint.indexOf(this.curOperator);
        String strToParse = constraint.substring(0, indexOperator);
        boolean isStringConstraint = false;
        String op = this.curOperator;
        double value = 0.0;
        String strValue = null;
        String valueStr = constraint.substring(indexOperator + this.curOperator.length(), constraint.length());
        Unit unit = null;
        if (this.isStrValue(valueStr)) {
            if (!this.curOperator.equals(EQ) && !this.curOperator.equals(NE)) {
                Aladin.warning(ERR12, 1);
                this.badSyntax = true;
                return null;
            }
            strValue = valueStr;
            isStringConstraint = true;
        } else {
            try {
                unit = new Unit(valueStr);
            }
            catch (ParseException e) {
                Aladin.warning(ERR12, 1);
                this.badSyntax = true;
                return null;
            }
            catch (ArithmeticException aExc) {
                this.badSyntax = true;
                Aladin.warning(ERR4, 1);
                return null;
            }
        }
        if (isStringConstraint) {
            int nQuote = Action.countNbOcc('\"', strValue);
            if (nQuote != 0 && nQuote != 2) {
                Aladin.warning(ERR5, 1);
                this.badSyntax = true;
                return null;
            }
            return new Constraint(strToParse, op, strValue);
        }
        try {
            parser = UCDFilter.createParser(strToParse, this.a);
        }
        catch (ParserException e) {
            Aladin.warning(ERR13 + "\n" + e.getMessage(), 1);
            this.badSyntax = true;
            return null;
        }
        value = unit.value;
        if (unit.symbol.length() > 0) {
            return new Constraint(parser, op, value, unit);
        }
        return new Constraint(parser, op, value);
    }

    private boolean isStrValue(String s) {
        return s.trim().charAt(0) == '\"';
    }

    public static String replace(String source, String pattern, String replace) {
        int len = pattern.length();
        StringBuffer sb = new StringBuffer();
        int found = -1;
        int start = 0;
        while ((found = source.indexOf(pattern, start)) != -1) {
            sb.append(source.substring(start, found));
            sb.append(replace);
            start = found + len;
        }
        sb.append(source.substring(start));
        return sb.toString();
    }

    private static String[] getVariables(String str, Aladin aladin) {
        Vector<String> vec = new Vector<String>();
        String variable = null;
        while (str.length() > 0) {
            int end;
            int begin;
            int beginUCD = str.indexOf("[");
            int beginCol = str.indexOf("{");
            if (beginUCD < 0 && beginCol < 0) break;
            if (beginCol < 0 || beginUCD >= 0 && beginUCD < beginCol) {
                begin = beginUCD;
                end = str.indexOf("]");
                variable = str.substring(begin, end + 1);
                try {
                    while (Action.countNbOcc('[', variable) != Action.countNbOcc(']', variable)) {
                        variable = str.substring(begin, ++end + 1);
                    }
                }
                catch (StringIndexOutOfBoundsException e) {
                    Aladin.warning(ERR6, 1);
                    return null;
                }
            }
            begin = beginCol;
            end = str.indexOf("}");
            variable = str.substring(begin, end + 1);
            try {
                while (Action.countNbOcc('{', variable) != Action.countNbOcc('}', variable)) {
                    variable = str.substring(begin, ++end + 1);
                }
            }
            catch (StringIndexOutOfBoundsException e) {
                Aladin.warning(ERR7);
                return null;
            }
            vec.addElement(variable);
            str = str.substring(end + 1, str.length());
        }
        Object[] ret = new String[vec.size()];
        vec.copyInto(ret);
        return ret;
    }

    private boolean containsOperator(String str) {
        int pos = str.indexOf(NE);
        if (pos >= 0) {
            this.curOperator = NE;
            this.position = pos;
            return true;
        }
        pos = str.indexOf(GE);
        if (pos >= 0) {
            this.curOperator = GE;
            this.position = pos;
            return true;
        }
        pos = str.indexOf(LE);
        if (pos >= 0) {
            this.curOperator = LE;
            this.position = pos;
            return true;
        }
        pos = str.indexOf(EQ);
        if (pos >= 0) {
            this.curOperator = EQ;
            this.position = pos;
            return true;
        }
        pos = str.indexOf(GT);
        if (pos >= 0) {
            this.curOperator = GT;
            this.position = pos;
            return true;
        }
        pos = str.indexOf(LT);
        if (pos >= 0) {
            this.curOperator = LT;
            this.position = pos;
            return true;
        }
        return false;
    }

    public static String skipSpaces(String str) {
        StringTokenizer sTok = new StringTokenizer(str, " ", false);
        StringBuffer result = new StringBuffer();
        while (sTok.hasMoreTokens()) {
            result.append(sTok.nextToken());
        }
        return result.toString();
    }

    void decodeDefinition(String def) {
        int posBeginDef = -1;
        this.name = "";
        this.definition = def;
        if (def.indexOf("}") < 0 || (posBeginDef = def.indexOf("{")) < 0) {
            this.badSyntax = true;
            Aladin.warning(ERR8, 1);
            return;
        }
        int posBeginName = def.indexOf("filter") + 6;
        if (posBeginName < 0) {
            this.badSyntax = true;
            Aladin.warning(ERR8, 1);
            return;
        }
        this.name = UCDFilter.skipSpaces(def.substring(posBeginName, posBeginDef));
        int posEnd = def.lastIndexOf("}");
        if ((def = def.substring(posBeginDef + 1, posEnd)).startsWith(Util.CR)) {
            def = def.substring(Util.CR.length());
        }
        if (def.endsWith(Util.CR)) {
            def = def.substring(0, def.lastIndexOf(Util.CR));
        } else if (def.endsWith("\n")) {
            def = def.substring(0, def.lastIndexOf("\n"));
        }
        this.decodeConstraints(def);
    }

    protected void select(Source[] sources) {
        int i;
        ConstraintsBlock curBlock = null;
        Vector<Source> remainingSources = new Vector<Source>();
        this.nbConvertProblem = 0;
        Enumeration<ConstraintsBlock> eBlocks = this.constraintsBlocks.elements();
        this.a.view.deSelect();
        while (eBlocks.hasMoreElements()) {
            curBlock = eBlocks.nextElement();
            remainingSources.removeAllElements();
            for (i = sources.length - 1; i >= 0; --i) {
                if (Aladin.isSlow && i % 50 == 0) {
                    Util.pause(10);
                }
                if (this.verifyValueConstraints(sources[i], curBlock)) {
                    sources[i].setSelect(true);
                    this.a.view.vselobj.addElement(sources[i]);
                    continue;
                }
                if (this.convertProblem) {
                    ++this.nbConvertProblem;
                    continue;
                }
                remainingSources.addElement(sources[i]);
            }
            if (remainingSources.size() <= 0) break;
            sources = new Source[remainingSources.size()];
            remainingSources.copyInto(sources);
        }
        if (remainingSources.size() > 0) {
            for (i = sources.length - 1; i >= 0; --i) {
                sources[i].setSelect(false);
            }
        }
        if (this.nbConvertProblem > 0) {
            Aladin.warning("Warning : there were conversion problems for " + this.nbConvertProblem + " sources", 1);
        }
    }

    protected Source[] getFilteredSources(Source[] sources, boolean inThread) {
        int i;
        int k;
        int i2;
        long start = System.currentTimeMillis();
        Vector<Source> filteredSources = new Vector<Source>();
        int nbSources = sources.length;
        this.nbConvertProblem = 0;
        Enumeration<ConstraintsBlock> eBlocks = this.constraintsBlocks.elements();
        ConstraintsBlock curBlock = null;
        ConstraintsBlock[] blocks = new ConstraintsBlock[this.constraintsBlocks.size()];
        int l = 0;
        while (eBlocks.hasMoreElements()) {
            blocks[l] = eBlocks.nextElement();
            ++l;
        }
        Vector[] vecBlockSources = new Vector[blocks.length];
        for (i2 = 0; i2 < vecBlockSources.length; ++i2) {
            vecBlockSources[i2] = new Vector();
        }
        for (i2 = sources.length - 1; i2 >= 0; --i2) {
            if (sources[i2].values == null) {
                sources[i2].values = new double[PlanFilter.LIMIT][][];
            }
            if (sources[i2].isSelected == null) {
                sources[i2].isSelected = new boolean[PlanFilter.LIMIT];
            }
            if (sources[i2].actions == null) {
                sources[i2].actions = new Action[PlanFilter.LIMIT][];
            }
            if (i2 % 50 == 0) {
                this.pf.setPourcent(100.0 * ((double)(nbSources - i2) / (double)nbSources));
                if (Aladin.isSlow) {
                    Util.pause(10);
                }
            }
            if (inThread && i2 % 100 == 0 && this.pf.runme == null) {
                return null;
            }
            boolean accomplished = false;
            for (k = 0; !accomplished && k < blocks.length; ++k) {
                curBlock = blocks[k];
                if (this.verifyValueConstraints(sources[i2], curBlock)) {
                    filteredSources.add(sources[i2]);
                    vecBlockSources[k].add(sources[i2]);
                    accomplished = true;
                    sources[i2].isSelected[this.numero] = true;
                    sources[i2].actions[this.numero] = curBlock.actions;
                    sources[i2].values[this.numero] = new double[sources[i2].actions[this.numero].length][4];
                    for (int j = 0; j < sources[i2].actions[this.numero].length; ++j) {
                        sources[i2].actions[this.numero][j].computeValues(sources[i2], this.numero, j);
                    }
                    continue;
                }
                if (!this.convertProblem) continue;
                ++this.nbConvertProblem;
                accomplished = true;
            }
            if (accomplished) continue;
            sources[i2].actions[this.numero] = null;
        }
        Source[][] blockSources = new Source[blocks.length][];
        for (i = 0; i < vecBlockSources.length; ++i) {
            blockSources[i] = new Source[vecBlockSources[i].size()];
            vecBlockSources[i].copyInto(blockSources[i]);
            vecBlockSources[i] = null;
        }
        for (i = 0; i < blocks.length; ++i) {
            for (k = 0; k < blocks[i].actions.length; ++k) {
                blocks[i].actions[k].computeExtremum(blockSources[i]);
            }
            for (int j = 0; j < blockSources[i].length; ++j) {
                if (inThread && j % 100 == 0 && this.pf.runme == null) {
                    return null;
                }
                for (int k2 = 0; k2 < blocks[i].actions.length; ++k2) {
                    blocks[i].actions[k2].finalcomputeValues(blockSources[i][j], this.numero, k2);
                }
            }
        }
        Object[] sourceArray = new Source[filteredSources.size()];
        filteredSources.copyInto(sourceArray);
        if (this.nbConvertProblem > 0) {
            Aladin.warning("Warning : there were conversion problems for " + this.nbConvertProblem + " sources", 1);
        }
        long end = System.currentTimeMillis();
        Aladin.trace(3, "Total time for filtering: " + (end - start));
        return sourceArray;
    }

    protected Source[] getFilteredSources(Source[] sources) {
        return this.getFilteredSources(sources, false);
    }

    protected boolean hasRainbowFunction() {
        return this.definition.toLowerCase().indexOf("rainbow") >= 0;
    }

    protected double[] getRainbowMinMax() {
        for (ConstraintsBlock constraint : this.constraintsBlocks) {
            if (constraint.actions == null) continue;
            for (Action action : constraint.actions) {
                if (action.rainbowMinValue == action.rainbowMaxValue) continue;
                return new double[]{action.rainbowMinValue, action.rainbowMaxValue};
            }
        }
        return new double[]{0.0, 0.0};
    }

    protected boolean verifyValueConstraints(Source s, int indexBlock) {
        return this.verifyValueConstraints(s, this.constraintsBlocks.elementAt(indexBlock));
    }

    private boolean verifyValueConstraints(Source s, ConstraintsBlock b) {
        int i;
        Constraint curConst = null;
        if (b.valueConstraints == null) {
            return true;
        }
        int length = b.valueConstraints.length;
        boolean[] check = new boolean[length];
        for (i = 0; i < length; ++i) {
            curConst = b.valueConstraints[i];
            check[i] = this.verifyOneValueConstraint(s, curConst);
            if (!this.convertProblem) continue;
            return false;
        }
        String un = "1";
        String zero = "0";
        String checkStr = new String(b.checkExpr);
        for (i = length - 1; i >= 0; --i) {
            String foo = check[i] ? "1" : "0";
            checkStr = MetaDataTree.replace(checkStr, "\\" + i, foo, 1);
        }
        Parser parserCheck = new Parser(checkStr);
        parserCheck.parseString();
        return parserCheck.eval() > 0.0;
    }

    private boolean verifyOneValueConstraint(Source s, Constraint cons) {
        double leftValue = 0.0;
        String strLeftValue = null;
        this.convertProblem = false;
        if (cons.stringConstraint) {
            String colOrUCD = cons.ucd.substring(1, cons.ucd.length() - 1);
            int pos = cons.ucd.startsWith("[") ? s.findUCD(colOrUCD.toUpperCase()) : s.findColumn(colOrUCD);
            if (pos < 0) {
                return false;
            }
            strLeftValue = s.getValue(pos);
            if (strLeftValue == null) {
                return false;
            }
            if (cons.operator.equals(EQ)) {
                return this.match(cons.strValue, strLeftValue);
            }
            if (cons.operator.equals(NE)) {
                return !this.match(cons.strValue, strLeftValue);
            }
        } else {
            if (cons.undefinedConstraint) {
                String undefVar = cons.ucd.substring(1, cons.ucd.length() - 1);
                if (cons.ucd.startsWith("[")) {
                    return s.findUCD(undefVar.toUpperCase()) < 0;
                }
                return s.findColumn(undefVar) < 0;
            }
            if (!Action.setAllVariables(cons.parser, s, false, cons.convertUnit)) {
                return false;
            }
            leftValue = cons.parser.eval();
            if (cons.convertUnit) {
                Unit refUnit;
                try {
                    refUnit = new Unit(cons.unit);
                    Unit evalUnit = cons.parser.evalUnit();
                    refUnit.convertFrom(evalUnit);
                }
                catch (ArithmeticException aExc) {
                    System.err.println(aExc);
                    this.convertProblem = true;
                    return false;
                }
                catch (ParseException pExc) {
                    System.err.println(pExc);
                    this.convertProblem = true;
                    return false;
                }
                leftValue = refUnit.value;
            } else {
                leftValue = cons.parser.eval();
            }
            return this.checkExpr(leftValue, cons.operator, cons.value);
        }
        return true;
    }

    private boolean checkExpr(double lVal, String op, double rVal) {
        if (op.equals(EQ)) {
            return lVal == rVal;
        }
        if (op.equals(GT)) {
            return lVal > rVal;
        }
        if (op.equals(GE)) {
            return lVal >= rVal;
        }
        if (op.equals(LT)) {
            return lVal < rVal;
        }
        if (op.equals(LE)) {
            return lVal <= rVal;
        }
        if (op.equals(NE)) {
            return lVal != rVal;
        }
        return false;
    }

    private boolean match(String mask, String word) {
        if (Source.useWildcard(mask)) {
            return Util.matchMask(mask, word);
        }
        return word.equals(MetaDataTree.replace(mask, "\\*", "*", -1));
    }

    protected static Parser createParser(String strToParse, Aladin aladin) throws ParserException {
        String[] vars = UCDFilter.getVariables(strToParse, aladin);
        if (vars == null) {
            throw new ParserException();
        }
        String[] encodedVars = new String[vars.length];
        for (int i = 0; i < encodedVars.length; ++i) {
            encodedVars[i] = vars[i];
        }
        strToParse = new String(strToParse);
        Parser parser = new Parser(strToParse);
        for (int i = 0; i < vars.length; ++i) {
            parser.addVar(encodedVars[i]);
        }
        try {
            parser.parseString();
        }
        catch (ParserException e) {
            e.printStackTrace();
            throw new ParserException("Maybe a problem with your variables names");
        }
        return parser;
    }

    private Action[] getActions(String s) {
        Action[] ret;
        String strTmp;
        StringTokenizer st = new StringTokenizer(s, "\n");
        String cleanedStr = new String("");
        while (st.hasMoreTokens()) {
            String curToken = st.nextToken();
            while (st.hasMoreTokens() && Action.countNbOcc('(', curToken) != Action.countNbOcc(')', curToken)) {
                curToken = curToken + st.nextToken();
            }
            curToken.replace('\n', ' ');
            cleanedStr = cleanedStr + curToken + "\n";
        }
        s = cleanedStr;
        Vector<String> v = new Vector<String>();
        StringBuffer tmp = new StringBuffer();
        char[] charArray = s.toCharArray();
        int closing2 = 0;
        int closing1 = 0;
        int opening2 = 0;
        int opening1 = 0;
        for (int i = 0; i < charArray.length; ++i) {
            char c = charArray[i];
            if (c == '\n' || c == ';' && opening1 == closing1 && opening2 == closing2) {
                strTmp = tmp.toString();
                if (strTmp.trim().length() > 0) {
                    v.addElement(tmp.toString());
                }
                tmp = new StringBuffer();
                closing2 = 0;
                closing1 = 0;
                opening2 = 0;
                opening1 = 0;
                continue;
            }
            if (c == '{') {
                ++opening1;
            } else if (c == '}') {
                ++closing1;
            } else if (c == '[') {
                ++opening2;
            } else if (c == ']') {
                ++closing2;
            }
            tmp.append(c);
        }
        strTmp = tmp.toString();
        if (strTmp.trim().length() > 0) {
            v.addElement(strTmp);
        }
        if (v.size() == 0) {
            ret = new Action[]{new Action("drawobject", this.a, this.pf)};
        } else {
            ret = new Action[v.size()];
            Enumeration eActions = v.elements();
            int i = 0;
            while (eActions.hasMoreElements()) {
                ret[i++] = new Action((String)eActions.nextElement(), this.a, this.pf);
            }
        }
        return ret;
    }

    private int getOpeningBracket(String s, int begin) {
        int result;
        while (true) {
            if ((result = s.indexOf("{", begin)) == -1) {
                return -1;
            }
            if (result <= 0 || s.charAt(result - 1) != '$') break;
            begin = result + 1;
        }
        return result;
    }

    private int getClosingBracket(String s, int begin) {
        int oBegin = begin;
        int result;
        while ((result = s.indexOf("}", begin)) != -1) {
            String subStr = s.substring(oBegin, result + 1);
            if (Action.countNbOcc('{', subStr) + 1 == Action.countNbOcc('}', subStr)) {
                return result;
            }
            begin = result + 1;
        }
        return -1;
    }

    protected void Free() {
        if (this.constraintsBlocks != null) {
            this.constraintsBlocks.removeAllElements();
            this.constraintsBlocks = null;
        }
        this.block = null;
    }

    class ConstraintsBlock {
        Action[] actions = null;
        Constraint[] valueConstraints;
        String checkExpr;

        ConstraintsBlock() {
        }
    }

    class Constraint {
        Parser parser;
        double value;
        Unit unit;
        String operator;
        boolean stringConstraint;
        boolean convertUnit = false;
        boolean undefinedConstraint = false;
        String strValue = null;
        String ucd = null;

        Constraint(Parser parser, String operator, double value) {
            this.parser = parser;
            this.operator = operator;
            this.value = value;
            this.stringConstraint = false;
        }

        Constraint(Parser parser, String operator, double value, Unit unit) {
            this(parser, operator, value);
            this.unit = unit;
            this.convertUnit = true;
        }

        Constraint(String ucd, String operator, String strValue) {
            this.ucd = ucd;
            this.operator = operator;
            this.strValue = strValue;
            this.stringConstraint = true;
            if (strValue.length() > 0 && strValue.charAt(0) == '\"' && strValue.charAt(strValue.length() - 1) == '\"') {
                this.strValue = strValue.substring(1, strValue.length() - 1);
            }
        }

        Constraint(String ucd) {
            this.ucd = ucd;
            this.undefinedConstraint = true;
        }
    }
}

