/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.MetaDataTree;
import cds.aladin.PlanImage;
import cds.aladin.ResourceNode;
import cds.aladin.Server;
import cds.aladin.ServerAladin;
import cds.aladin.ServerDialog;
import cds.aladin.ServerVizieR;
import cds.aladin.TreeBuilder;
import cds.aladin.View;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public final class TreeView
extends JFrame
implements WindowListener,
ActionListener {
    static String NOM;
    static String SUBMIT;
    static String RESET;
    static String CLOSE;
    static String CLEAR;
    static String WERR;
    static String UNKNOWNOBJ;
    static String NODATA;
    MetaDataTree mTree;
    JScrollPane scrollTree;
    private static final int SCROLL_TREE_WIDTH = 320;
    private static final int SCROLL_INFO_WIDTH = 360;
    String targetFound;
    String error;
    Aladin aladin;

    protected void createChaine() {
        NOM = Aladin.chaine.getString("TREETITLE");
        UNKNOWNOBJ = Aladin.chaine.getString("UNKNOWNOBJ");
        SUBMIT = Aladin.chaine.getString("SUBMIT");
        RESET = Aladin.chaine.getString("RESET");
        CLOSE = Aladin.chaine.getString("CLOSE");
        CLEAR = Aladin.chaine.getString("CLEAR");
        WERR = Aladin.chaine.getString("ERROR");
        NODATA = Aladin.chaine.getString("NODATA");
    }

    protected TreeView(Aladin aladin) {
        this.aladin = aladin;
        Aladin.setIcon(this);
        this.createChaine();
        this.setTitle(NOM);
        this.setSize(450, 500);
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        JPanel p = new JPanel(new BorderLayout());
        p.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(null, NOM, 4, 2, Aladin.BOLD), BorderFactory.createEmptyBorder(4, 4, 4, 4))));
        this.addWindowListener(this);
        ResourceNode root = new ResourceNode(aladin, "root");
        root.hide = true;
        root.isOpen = true;
        this.mTree = new MetaDataTree(root, aladin, null, true);
        this.mTree.setAllowSortByFields(false);
        this.mTree.setFullExpandAtStart(false);
        this.scrollTree = new JScrollPane(this.mTree, 20, 30);
        this.scrollTree.setSize(320, this.getSize().height - 70);
        this.mTree.setScroll(this.scrollTree);
        this.scrollTree.setBackground(this.mTree.bkgColor);
        p.add((Component)this.scrollTree, "Center");
        this.getContentPane().add((Component)p, "Center");
        this.getContentPane().add((Component)this.buttonPanel(), "South");
    }

    private JPanel buttonPanel() {
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout(1));
        p.setFont(Aladin.LBOLD);
        p.add(this.createButton(RESET));
        p.add(this.createButton(CLEAR));
        JButton b = this.createButton(SUBMIT);
        p.add(b);
        b.setFont(Aladin.BOLD);
        p.add(this.createButton(CLOSE));
        return p;
    }

    private JButton createButton(String s) {
        JButton b = new JButton(s);
        b.addActionListener(this);
        return b;
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.setVisible(false);
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    public boolean updateTree(InputStream is, MetaDataTree tree, Server server, String target, String requestedPos) {
        if (server != null && server.target != null && (target == null || target.length() == 0)) {
            target = server.target.getText();
        }
        ResourceNode newBranch = this.createNewBranch(null, is, target, null, server, null, requestedPos);
        if (this.error != null) {
            Aladin.warning(tree, this.error);
            return false;
        }
        if (newBranch.nbChildren <= 0) {
            Aladin.warning(tree, NODATA);
            return false;
        }
        if ((target == null || target.length() == 0) && this.targetFound != null) {
            target = this.targetFound;
        }
        if (target != null && target.length() != 0) {
            this.mTree.addNode(this.getTargetNode(target, this.mTree), newBranch);
        } else {
            this.mTree.addNode((ResourceNode)this.mTree.getRootNode(), newBranch);
        }
        ResourceNode clone = (ResourceNode)newBranch.clone();
        clone.hide = true;
        tree.setRoot(clone);
        tree.requestFocus();
        this.targetFound = null;
        this.error = null;
        return true;
    }

    public boolean appendToTree(InputStream is, MetaDataTree tree, Server server, String target, String requestedPos) {
        if (server != null && server.target != null && (target == null || target.length() == 0)) {
            target = server.target.getText();
        }
        ResourceNode newBranch = this.createNewBranch(null, is, target, null, server, null, requestedPos);
        if (this.error != null) {
            this.aladin.command.println("!!! " + this.error);
            return false;
        }
        if (newBranch != null && newBranch.nbChildren <= 0) {
            return false;
        }
        if ((target == null || target.length() == 0) && this.targetFound != null) {
            target = this.targetFound;
        }
        if (target != null && target.length() != 0) {
            this.mTree.addNode(this.getTargetNode(target, this.mTree), newBranch);
        } else {
            this.mTree.addNode((ResourceNode)this.mTree.getRootNode(), newBranch);
        }
        ResourceNode clone = (ResourceNode)newBranch.clone();
        clone.hide = false;
        tree.addNode((ResourceNode)tree.getRootNode(), clone);
        this.targetFound = null;
        this.error = null;
        return true;
    }

    private ResourceNode getTargetNode(String target, MetaDataTree mdt) {
        ResourceNode targetNode = (ResourceNode)mdt.searchNodeByName(target);
        if (targetNode == null) {
            targetNode = new ResourceNode(this.aladin, target);
            mdt.getRootNode().addChild(targetNode);
            mdt.traverseTree();
        }
        targetNode.isOpen = true;
        return targetNode;
    }

    protected static String resolveTarget(String s, Aladin a) {
        Coord c;
        try {
            c = !View.notCoord(s) ? new Coord(s) : a.view.sesame(s);
        }
        catch (Exception e) {
            return null;
        }
        return c.getSexa(":");
    }

    protected static Coord resolveTargetCoo(String s, Aladin a) {
        Coord c = null;
        try {
            c = !View.notCoord(s) ? new Coord(s) : a.view.sesame(s);
        }
        catch (Exception e) {
            return null;
        }
        return c;
    }

    private ResourceNode createNewBranch(URL url, InputStream is, String target, String radius, Server server, String serverName, String requestedPos) {
        String targetCoo = null;
        if (url == null && is == null && (targetCoo = TreeView.resolveTarget(target, this.aladin)) == null) {
            Aladin.warning(UNKNOWNOBJ + " " + target, 1);
            return null;
        }
        ResourceNode newBranch = url == null && is == null ? this.createNode(targetCoo, radius, server, requestedPos) : this.createNode(url, is, server, requestedPos, target);
        if (newBranch == null) {
            Aladin.trace(3, "The new branch of the tree could not be built");
            return null;
        }
        if (serverName == null) {
            if (server instanceof ServerAladin) {
                serverName = "Aladin";
            } else if (server instanceof ServerVizieR) {
                serverName = "VizieR";
            } else if (url == null) {
                serverName = server == null ? null : server.aladinLabel;
            } else {
                serverName = url.toString();
                serverName = "..." + serverName.substring(Math.max(0, serverName.length() - 20));
            }
        }
        newBranch.name = serverName;
        return newBranch;
    }

    private URL buildURL(String target, String radius, Server server) {
        URL url;
        double radiusDeg = Server.getAngle(radius, 1) / 60.0;
        try {
            if (server instanceof ServerAladin) {
                url = new URL("http://aladin.u-strasbg.fr/cgi-bin/nph-HTTP.cgi?out=qualifier&position=" + URLEncoder.encode(TreeView.getDeciCoord(target)) + "&radius=" + radiusDeg + "&mode=xml_votable");
            }
            if (server instanceof ServerVizieR) {
                url = new URL("http://vizier.u-strasbg.fr/cgi-bin/votable/-w?-meta&-c=" + URLEncoder.encode(target) + "&-c.r=" + radiusDeg + "&-c.u=degree&-c.eq=J2000");
            }
            return null;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            Aladin.trace(1, "URL could not be built");
            return null;
        }
        Aladin.trace(3, "Building url " + url);
        return url;
    }

    protected int creatCatPlane(String cat, String target, String label) {
        String sz = "10";
        return ((ServerVizieR)this.aladin.dialog.server[ServerDialog.VIZIER]).creatVizieRPlane(target, sz, cat, label, "", false);
    }

    static String getDeciCoord(String coo) {
        Coord c;
        try {
            c = new Coord(coo);
        }
        catch (Exception e) {
            return "";
        }
        return c.al + " " + (c.del >= 0.0 ? "+" : "") + c.del;
    }

    static double[] getDeciCoord(String ra, String dec) {
        Coord c;
        try {
            c = new Coord(ra + " " + dec);
        }
        catch (Exception e) {
            return null;
        }
        return new double[]{c.al, c.del};
    }

    private ResourceNode createNode(String target, String radius, Server server, String requestedPos) {
        URL url = this.buildURL(target, radius, server);
        return this.createNode(url, null, server, requestedPos, target);
    }

    private ResourceNode createNode(URL url, InputStream is, Server server, String requestedPos, String target) {
        if (url == null && is == null) {
            return null;
        }
        int type = -1;
        if (server instanceof ServerAladin) {
            type = 0;
        }
        Aladin.trace(1, "Updating the data tree view, using " + (url != null ? "URL " + url : "input stream"));
        ResourceNode ret = null;
        try {
            TreeBuilder tb = url != null ? new TreeBuilder(this.aladin, url, type, server, target) : new TreeBuilder(this.aladin, is, type, server, target);
            if (requestedPos != null) {
                tb.setRequestedPos(requestedPos);
            }
            ret = tb.build();
            this.targetFound = tb.getTarget();
            this.error = tb.getError();
            if (ret != null) {
                ret.hide = false;
            }
        }
        catch (Exception e) {
            System.out.println("An error occured while building the tree :");
            e.printStackTrace();
            this.error = ret == null ? "Could not build the tree for server " + server.aladinLabel : e.getMessage();
        }
        return ret;
    }

    public void submit() {
        this.mTree.loadSelected();
        this.mTree.resetCb();
    }

    protected static String getPlanLabel(String resol, String qual) {
        return TreeView.getPlanLabel(PlanImage.getRes(resol), qual);
    }

    protected static String getPlanLabel(int resol, String qual) {
        StringBuffer s = new StringBuffer();
        String[] f = new String[3];
        StringTokenizer st = new StringTokenizer(qual);
        for (int i = 0; i < 3; ++i) {
            f[i] = st.nextToken();
        }
        if (f[0].indexOf("2MASS") >= 0) {
            f[2] = f[0];
            f[0] = null;
        }
        if (resol == 3) {
            s.append("Pl-");
        } else if (resol == 2) {
            s.append("Lw-");
        }
        if (f[2].equals("STScI") || f[2].equals("STSCI")) {
            s.append("DSS1");
        } else if (!f[2].startsWith("___")) {
            s.append(f[2] + ".");
        }
        s.append(f[1]);
        if (f[0] != null) {
            s.append("." + (f[0].startsWith("GOODS-") ? f[0].substring(6) : f[0]));
        }
        return s.toString();
    }

    protected void reset() {
        this.mTree.resetCb();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String o = ae.getActionCommand();
        if (o.equals(SUBMIT)) {
            this.submit();
        } else if (o.equals(RESET)) {
            this.reset();
        } else if (o.equals(CLEAR)) {
            this.mTree.clear();
        } else if (o.equals(CLOSE)) {
            this.setVisible(false);
        }
    }
}

