/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.GluApp;
import cds.aladin.Localisation;
import cds.aladin.MyInputStream;
import cds.aladin.MyProperties;
import cds.aladin.Server;
import cds.aladin.Tok;
import cds.aladin.TreeNode;
import cds.moc.Healpix;
import cds.tools.Util;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class TreeNodeAllsky
extends TreeNode {
    public String internalId;
    private String url;
    public String description;
    public String verboseDescr;
    public String ack;
    public String copyright;
    public String copyrightUrl;
    public String hpxParam;
    public String version;
    public String aladinProfile;
    private String skyFraction;
    public String aladinLabel;
    public int minOrder;
    public int maxOrder;
    private boolean useCache;
    private boolean cube;
    private boolean color;
    private boolean inFits;
    private boolean inJPEG;
    private boolean inPNG;
    private boolean truePixels;
    private boolean truePixelsSet;
    private boolean cat;
    private boolean progen;
    private boolean map;
    private boolean moc;
    public int cubeDepth;
    public int cubeFirstFrame;
    public int frame;
    public Coord target;
    public double radius;
    public int nside;
    public boolean local;

    public TreeNodeAllsky(Aladin aladin, String pathOrUrl) {
        String s;
        MyProperties prop;
        block59: {
            this.version = "";
            this.minOrder = -1;
            this.maxOrder = -1;
            this.useCache = true;
            this.cube = false;
            this.color = false;
            this.inFits = false;
            this.inJPEG = false;
            this.inPNG = false;
            this.truePixels = false;
            this.truePixelsSet = false;
            this.cat = false;
            this.progen = false;
            this.map = false;
            this.moc = false;
            this.cubeDepth = -1;
            this.cubeFirstFrame = 0;
            this.frame = 3;
            this.target = null;
            this.radius = -1.0;
            this.nside = -1;
            this.local = false;
            this.aladin = aladin;
            this.local = !pathOrUrl.startsWith("http:") && !pathOrUrl.startsWith("https:") && !pathOrUrl.startsWith("ftp:");
            prop = new MyProperties();
            try {
                InputStream in = null;
                in = !this.local ? new URL(pathOrUrl + "/" + "properties").openStream() : new FileInputStream(new File(pathOrUrl + Util.FS + "properties"));
                if (in != null) {
                    prop.load(in);
                    in.close();
                }
            }
            catch (Exception e) {
                Aladin.trace(3, "No properties file found => auto discovery...");
            }
            String strFrame = prop.getProperty("hips_frame");
            if (strFrame == null) {
                strFrame = prop.getProperty("coordsys");
            }
            if (strFrame == null) {
                strFrame = "galactic";
            }
            if (strFrame.equals("equatorial") || strFrame.equals("C") || strFrame.equals("Q")) {
                this.frame = 0;
            } else if (strFrame.equals("ecliptic") || strFrame.equals("E")) {
                this.frame = 2;
            } else if (strFrame.equals("galactic") || strFrame.equals("G")) {
                this.frame = 3;
            }
            this.url = pathOrUrl;
            s = prop.getProperty("obs_collection");
            if (s == null) {
                s = prop.getProperty("label");
            }
            if (s != null) {
                this.label = s;
            } else {
                int c = this.local ? (int)Util.FS.charAt(0) : 47;
                int end = pathOrUrl.length();
                int offset = pathOrUrl.lastIndexOf(c);
                if (offset == end - 1 && offset > 0) {
                    end = offset;
                    offset = pathOrUrl.lastIndexOf(c, end - 1);
                }
                this.label = pathOrUrl.substring(offset + 1, end);
            }
            this.id = "__" + this.label;
            s = prop.getProperty("version");
            if (s != null) {
                this.version = s;
            }
            this.description = prop.getProperty("obs_title");
            if (this.description == null) {
                this.description = prop.getProperty("description");
            }
            this.verboseDescr = prop.getProperty("obs_description");
            if (this.verboseDescr == null) {
                this.verboseDescr = prop.getProperty("verboseDescription");
            }
            this.copyright = prop.getProperty("obs_copyright");
            if (this.copyright == null) {
                this.copyright = prop.getProperty("copyright");
            }
            this.copyrightUrl = prop.getProperty("obs_copyright_url");
            if (this.copyrightUrl == null) {
                this.copyrightUrl = prop.getProperty("copyrightUrl");
            }
            this.useCache = !this.local && Boolean.parseBoolean(prop.getProperty("useCache", "True"));
            this.skyFraction = prop.getProperty("moc_sky_fraction");
            s = prop.getProperty("hips_initial_ra");
            if (s != null) {
                String s1 = prop.getProperty("hips_initial_dec");
                s = s1 != null ? s + " " + s1 : null;
            }
            if (s == null) {
                s = prop.getProperty("target");
            }
            if (s == null) {
                this.target = null;
            } else {
                try {
                    this.target = new Coord(s);
                }
                catch (Exception e) {
                    Aladin.trace(3, "target error!");
                    this.target = null;
                }
            }
            double div2 = 2.0;
            s = prop.getProperty("hips_initial_fov");
            if (s == null) {
                s = prop.getProperty("targetRadius");
                div2 = 1.0;
            }
            if (s == null) {
                this.radius = -1.0;
            } else {
                try {
                    this.radius = Server.getAngle(s, 8) / 60.0 / div2;
                }
                catch (Exception e) {
                    Aladin.trace(3, "radius error!");
                    this.radius = -1.0;
                }
            }
            s = prop.getProperty("hips_tile_width");
            if (s == null) {
                s = prop.getProperty("nside");
            }
            if (s != null) {
                try {
                    this.nside = Integer.parseInt(s);
                }
                catch (Exception e) {
                    Aladin.trace(3, "NSIDE number not parsable !");
                    this.nside = -1;
                }
            }
            if ((s = prop.getProperty("hips_order")) == null) {
                s = prop.getProperty("maxOrder");
            }
            try {
                this.maxOrder = new Integer(s);
            }
            catch (Exception e) {
                this.maxOrder = this.getMaxOrderByPath(pathOrUrl, this.local);
                if (this.maxOrder != -1) break block59;
                Aladin.trace(3, "No maxOrder found (even with scanning dir.) => assuming 11");
                this.maxOrder = 11;
            }
        }
        String s1 = prop.getProperty("dataproduct_type");
        if (s1 != null) {
            this.cube = s1.indexOf("cube") >= 0;
        } else {
            try {
                this.cube = new Boolean(prop.getProperty("isCube"));
            }
            catch (Exception e) {
                this.cube = false;
            }
        }
        if (this.cube) {
            s = prop.getProperty("hips_cube_depth");
            if (s == null) {
                s = prop.getProperty("cubeDepth");
            }
            if (s != null) {
                try {
                    this.cubeDepth = Integer.parseInt(s);
                }
                catch (Exception e) {
                    Aladin.trace(3, "CubeDepth syntax error [" + s + "] => trying autodetection");
                    this.cubeDepth = -1;
                }
            }
            if ((s = prop.getProperty("hips_cube_firstframe")) == null) {
                s = prop.getProperty("cubeFirstFrame");
            }
            if (s != null) {
                try {
                    this.cubeFirstFrame = Integer.parseInt(s);
                }
                catch (Exception e) {
                    Aladin.trace(3, "cubeFirstFrame syntax error [" + s + "] => assuming frame 0");
                    this.cubeFirstFrame = -1;
                }
            }
        }
        this.progen = pathOrUrl.endsWith("HpxFinder") || pathOrUrl.endsWith("HpxFinder/");
        s = prop.getProperty("dataproduct_type");
        this.cat = s != null ? s.indexOf("catalog") >= 0 : ((s = prop.getProperty("isCatalog")) != null ? new Boolean(s).booleanValue() : this.getFormatByPath(pathOrUrl, this.local, 2));
        String keyColor = prop.getProperty("dataproduct_subtype");
        if (keyColor != null) {
            this.color = keyColor.indexOf("color") >= 0;
        } else {
            keyColor = prop.getProperty("isColored");
            if (keyColor != null) {
                this.color = new Boolean(keyColor);
            }
        }
        if (!this.cat && !this.progen) {
            String format = prop.getProperty("hips_tile_format");
            if (format == null) {
                format = prop.getProperty("format");
            }
            if (format != null) {
                int a = Util.indexOfIgnoreCase(format, "fit");
                this.inFits = a >= 0;
                int b = Util.indexOfIgnoreCase(format, "jpeg");
                this.inJPEG = b >= 0 || (b = Util.indexOfIgnoreCase(format, "jpg")) >= 0;
                b = Util.indexOfIgnoreCase(format, "png");
                this.inPNG = b >= 0;
                this.truePixels = this.inFits && a < b;
            } else {
                this.inFits = this.getFormatByPath(pathOrUrl, this.local, 0);
                this.inJPEG = this.getFormatByPath(pathOrUrl, this.local, 1);
                this.inPNG = this.getFormatByPath(pathOrUrl, this.local, 3);
                boolean bl = this.truePixels = this.local && this.inFits || this.local || !this.inJPEG && !this.inPNG;
            }
            if (keyColor == null) {
                this.color = this.getIsColorByPath(pathOrUrl, this.local);
            }
            if (this.color) {
                this.truePixels = false;
            }
        }
        Aladin.trace(4, this.toString1());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getIsColorByPath(String path, boolean local) {
        boolean bl;
        String ext = this.inPNG ? ".png" : ".jpg";
        MyInputStream in = null;
        try {
            if (local) {
                boolean bl2 = Util.isJPEGColored(path + Util.FS + "Norder3" + Util.FS + "Allsky" + ext);
                return bl2;
            }
            in = new MyInputStream(Util.openStream(path + "/Norder3/Allsky" + ext));
            byte[] buf = in.readFully();
            bl = Util.isColoredImage(buf);
        }
        catch (Exception e) {
            Aladin.trace(3, "Allsky" + ext + " not found => assume B&W survey");
            boolean bl3 = false;
            return bl3;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e1) {}
        }
        return bl;
    }

    private boolean getFormatByPath(String path, boolean local, int fmt) {
        String ext = fmt == 0 ? ".fits" : (fmt == 1 ? ".jpg" : (fmt == 3 ? ".png" : ".xml"));
        return local && new File(path + Util.FS + "Norder3" + Util.FS + "Allsky" + ext).exists() || !local && Util.isUrlResponding(path + "/Norder3/Allsky" + ext);
    }

    private int getMaxOrderByPath(String urlOrPath, boolean local) {
        for (int n = 25; n >= 1; --n) {
            if ((!local || !new File(urlOrPath + Util.FS + "Norder" + n).isDirectory()) && (local || !Util.isUrlResponding(urlOrPath + "/Norder" + n))) continue;
            return n;
        }
        return -1;
    }

    public TreeNodeAllsky(Aladin aladin, String actionName, String id, String aladinMenuNumber, String url, String aladinLabel, String description, String verboseDescr, String ack, String aladinProfile, String copyright, String copyrightUrl, String path, String aladinHpxParam, String skyFraction) {
        super(aladin, actionName, aladinMenuNumber, aladinLabel, path);
        char c;
        this.version = "";
        this.minOrder = -1;
        this.maxOrder = -1;
        this.useCache = true;
        this.cube = false;
        this.color = false;
        this.inFits = false;
        this.inJPEG = false;
        this.inPNG = false;
        this.truePixels = false;
        this.truePixelsSet = false;
        this.cat = false;
        this.progen = false;
        this.map = false;
        this.moc = false;
        this.cubeDepth = -1;
        this.cubeFirstFrame = 0;
        this.frame = 3;
        this.target = null;
        this.radius = -1.0;
        this.nside = -1;
        this.local = false;
        this.aladinLabel = aladinLabel;
        this.url = url;
        this.description = description;
        this.verboseDescr = verboseDescr;
        this.ack = ack;
        this.copyright = copyright;
        this.copyrightUrl = copyrightUrl;
        this.hpxParam = aladinHpxParam;
        this.aladinProfile = aladinProfile;
        this.internalId = id;
        this.skyFraction = skyFraction;
        if (this.url != null && ((c = this.url.charAt(this.url.length() - 1)) == '/' || c == '\\')) {
            this.url = this.url.substring(0, this.url.length() - 1);
        }
        boolean first = true;
        if (this.hpxParam != null) {
            StringTokenizer st = new StringTokenizer(this.hpxParam);
            try {
                while (st.hasMoreTokens()) {
                    String s = st.nextToken();
                    try {
                        int n = Integer.parseInt(s);
                        if (this.maxOrder != -1) {
                            this.minOrder = this.maxOrder;
                            this.maxOrder = n;
                        } else {
                            this.maxOrder = n;
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (Util.indexOfIgnoreCase(s, "nocache") >= 0) {
                        this.useCache = false;
                    }
                    if (Util.indexOfIgnoreCase(s, "color") >= 0) {
                        this.color = true;
                    }
                    if (Util.indexOfIgnoreCase(s, "cube") >= 0) {
                        this.cube = true;
                    }
                    if (Util.indexOfIgnoreCase(s, "fits") >= 0) {
                        this.inFits = true;
                        if (first) {
                            first = false;
                            this.truePixels = true;
                        }
                    }
                    if (Util.indexOfIgnoreCase(s, "jpeg") >= 0 || Util.indexOfIgnoreCase(s, "jpg") >= 0) {
                        this.inJPEG = true;
                        if (first) {
                            first = false;
                            this.truePixels = false;
                        }
                    }
                    if (Util.indexOfIgnoreCase(s, "png") >= 0) {
                        this.inPNG = true;
                        if (first) {
                            first = false;
                            this.truePixels = false;
                        }
                    }
                    if (Util.indexOfIgnoreCase(s, "gal") >= 0) {
                        this.frame = 3;
                    }
                    if (Util.indexOfIgnoreCase(s, "ecl") >= 0) {
                        this.frame = 2;
                    }
                    if (Util.indexOfIgnoreCase(s, "equ") >= 0) {
                        this.frame = 0;
                    }
                    if (Util.indexOfIgnoreCase(s, "cat") >= 0) {
                        this.cat = true;
                    }
                    if (Util.indexOfIgnoreCase(s, "progen") >= 0) {
                        this.progen = true;
                    }
                    if (Util.indexOfIgnoreCase(s, "map") >= 0) {
                        this.map = true;
                    }
                    if (Util.indexOfIgnoreCase(s, "moc") >= 0) {
                        this.moc = true;
                    }
                    if (s.charAt(0) != 'v') continue;
                    try {
                        double n = Double.parseDouble(s.substring(1));
                        this.version = "-" + s;
                    }
                    catch (Exception e) {}
                }
                if (this.minOrder == -1) {
                    this.minOrder = 2;
                }
                if (this.maxOrder == -1) {
                    this.maxOrder = 8;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (url != null && !url.startsWith("http") && !url.startsWith("ftp")) {
            this.useCache = false;
        }
        if (copyright != null || copyrightUrl != null) {
            this.setCopyright(copyright);
        }
        this.setMoc();
    }

    public String toString1() {
        Coord c = this.getTarget();
        double r = this.getRadius();
        return "GluSky [" + this.id + "]" + (this.isCatalog() ? " catalog" : (this.isProgen() ? " progen" : (this.isMap() ? " fitsMap" : " survey"))) + " maxOrder:" + this.getMaxOrder() + (this.getLosangeOrder() >= 0 ? " cellOrder:" + this.getLosangeOrder() : "") + (!this.isCatalog() && this.isColored() ? " colored" : " B&W") + (!this.isCube() ? "" : " cube" + (this.cubeDepth == -1 ? "" : "/" + this.cubeDepth + (this.cubeFirstFrame == 0 ? "" : "/" + this.cubeFirstFrame))) + (!this.isFits() ? "" : (this.isTruePixels() ? " *inFits*" : " inFits")) + (!this.isJPEG() ? "" : (this.isTruePixels() ? " inJPEG" : " *inJPEG*")) + (!this.isPNG() ? "" : (this.isTruePixels() ? " inPNG" : " *inPNG*")) + (this.loadMocNow() ? " withMoc" : "") + (this.useCache() ? " cache" : " nocache") + " " + Localisation.getFrameName(this.getFrame()) + (this.isLocalDef() ? " localDef" : "") + (this.isLocal() ? " local" : "") + (c != null ? " target:" + c : "") + (r != -1.0 ? "/" + Coord.getUnit(r) : "") + " \"" + this.label + "\" => " + this.getUrl();
    }

    protected boolean isLocalDef() {
        return this.aladinProfile != null && this.aladinProfile.indexOf("localdef") >= 0;
    }

    protected boolean isMap() {
        return this.map;
    }

    protected boolean isCatalog() {
        return this.cat;
    }

    protected boolean isProgen() {
        return this.progen;
    }

    protected boolean isColored() {
        return this.color;
    }

    protected boolean isCube() {
        return this.cube;
    }

    protected int getFrame() {
        return this.frame;
    }

    protected boolean isFits() {
        return this.inFits;
    }

    protected int getMaxOrder() {
        return this.maxOrder;
    }

    protected Coord getTarget() {
        return this.target;
    }

    protected double getRadius() {
        return this.radius;
    }

    protected String getVersion() {
        return this.version == null ? "" : this.version;
    }

    protected int getLosangeOrder() {
        if (this.progen || this.cat || this.nside == -1) {
            return -1;
        }
        return (int)Healpix.log2(this.nside);
    }

    protected boolean isLocal() {
        return this.local;
    }

    protected boolean loadMocNow() {
        return this.moc;
    }

    protected boolean isJPEG() {
        return this.inJPEG;
    }

    protected boolean isPNG() {
        return this.inPNG;
    }

    protected boolean isTruePixels() {
        if (this.truePixelsSet) {
            return this.truePixels;
        }
        return !this.isColored() && (this.inFits && this.local || !this.inJPEG && !this.inPNG && !this.local);
    }

    protected boolean useCache() {
        return this.useCache;
    }

    protected String getUrl() {
        try {
            if (this.id != null && this.aladin.glu.aladinDic.get(this.id) != null) {
                return this.aladin.glu.getURL(this.id, "", false, false, 1) + "";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.url;
    }

    protected String getAladinTree() {
        int i = this.path.lastIndexOf(47);
        if (i == -1) {
            return "";
        }
        return this.path.substring(0, i);
    }

    public String getGluDic() {
        StringBuffer s = new StringBuffer();
        s.append(GluApp.glu("ActionName", this.id));
        s.append(GluApp.glu("Description", this.description));
        s.append(GluApp.glu("Url", this.getUrl()));
        s.append(GluApp.glu("Aladin.Label", this.label));
        s.append(GluApp.glu("Aladin.Tree", this.getAladinTree()));
        s.append(GluApp.glu("Aladin.HpxParam", this.hpxParam));
        s.append(GluApp.glu("Aladin.Profile", this.aladinProfile));
        s.append(GluApp.glu("Copyright", this.copyright));
        s.append(GluApp.glu("Copyright.Url", this.copyrightUrl));
        s.append(GluApp.glu("VerboseDescr", this.verboseDescr));
        s.append(Util.CR);
        return s.toString();
    }

    @Override
    protected void submit() {
        String mode = this.isTruePixels() ? ",fits" : "";
        this.aladin.console.printCommand("get allsky(" + Tok.quote(this.label) + mode + ")");
        this.aladin.allsky(this);
    }

    void loadCopyright() {
        this.aladin.glu.showDocument(this.copyrightUrl);
    }

    void setDefaultMode(int mode) {
        this.truePixelsSet = true;
        if (mode == 2 && this.inFits) {
            this.truePixels = true;
        } else if (mode == 1 && (this.inJPEG || this.inPNG)) {
            this.truePixels = false;
        }
    }

    protected void reset() {
        this.truePixelsSet = false;
    }

    void setMoc() {
        if (this.skyFraction == null || this.skyFraction.equals("1")) {
            return;
        }
        JButton b = new JButton(" (get Moc)");
        b.setFont(b.getFont().deriveFont(2));
        b.setForeground(Color.blue);
        b.setBackground(background);
        b.setContentAreaFilled(false);
        b.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.blue));
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreeNodeAllsky.this.loadMoc();
            }
        });
        this.gc.insets.bottom = 7;
        this.gb.setConstraints(b, this.gc);
        this.getPanel().add(b);
    }

    void loadMoc() {
        block2: {
            MyInputStream mis = null;
            try {
                mis = Util.openAnyStream(this.getUrl() + "/Moc.fits");
                this.aladin.calque.newPlanMOC(mis, this.label + " MOC");
            }
            catch (Exception e) {
                if (Aladin.levelTrace < 3) break block2;
                e.printStackTrace();
            }
        }
    }

    void setUrl(String url) {
        this.url = url;
    }

    void setCopyright(String copyright) {
        JComponent c = null;
        if (this.copyrightUrl == null) {
            JLabel l;
            c = l = new JLabel("(" + copyright + ")");
            this.gc.insets.bottom = 0;
        } else {
            JButton b = new JButton(copyright != null ? copyright : "Copyright");
            b.setFont(b.getFont().deriveFont(2));
            b.setForeground(Color.blue);
            b.setBackground(background);
            b.setContentAreaFilled(false);
            b.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.blue));
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TreeNodeAllsky.this.loadCopyright();
                }
            });
            c = b;
            this.gc.insets.bottom = 5;
        }
        this.gb.setConstraints(c, this.gc);
        this.getPanel().add(c);
    }
}

