/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Comparator;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class TreeNode
implements Comparator {
    Aladin aladin;
    String id;
    String label;
    String path;
    String ordre;
    boolean ok;
    protected JCheckBox checkbox;
    private JPanel panel;
    protected GridBagConstraints gc;
    protected GridBagLayout gb;
    protected static Color background = Color.white;

    public TreeNode() {
    }

    TreeNode(Aladin aladin, String id, String ordre, String label, String path) {
        this.aladin = aladin;
        this.id = id;
        this.label = label;
        this.path = path;
        this.ordre = ordre == null ? "Z" : ordre;
        this.ok = true;
        this.createPanel();
    }

    String getID() {
        return this.id;
    }

    void noCheckbox() {
        this.checkbox = null;
    }

    boolean hasCheckBox() {
        return this.checkbox != null;
    }

    void setCheckBox(boolean f) {
        if (!this.hasCheckBox()) {
            return;
        }
        this.checkbox.setSelected(f);
    }

    boolean isCheckBoxSelected() {
        if (!this.hasCheckBox()) {
            return false;
        }
        return this.checkbox.isSelected();
    }

    void setOk(boolean ok) {
        this.ok = ok;
    }

    boolean isOk() {
        return this.ok;
    }

    JPanel getPanel() {
        return this.panel;
    }

    public void setForeground(Color fg) {
        this.checkbox.setForeground(fg);
    }

    public Color getForeground() {
        return this.checkbox.getForeground();
    }

    private void createPanel() {
        this.checkbox = new JCheckBox(this.label);
        this.checkbox.setBorder(BorderFactory.createEmptyBorder());
        this.gc = new GridBagConstraints();
        this.gc.fill = 3;
        this.gc.anchor = 10;
        this.gc.gridx = -1;
        this.gc.insets = new Insets(0, 0, 0, 5);
        this.gb = new GridBagLayout();
        this.panel = new JPanel(this.gb);
        this.panel.setOpaque(true);
        this.gb.setConstraints(this.checkbox, this.gc);
        this.panel.add(this.checkbox);
    }

    protected void submit() {
    }

    public String toString() {
        return this.label;
    }

    protected static Comparator getComparator() {
        return new TreeNode();
    }

    public int compare(Object o1, Object o2) {
        TreeNode a1 = (TreeNode)o1;
        TreeNode a2 = (TreeNode)o2;
        if (a1.ordre == a2.ordre) {
            return 0;
        }
        if (a1.ordre == null) {
            return -1;
        }
        if (a2.ordre == null) {
            return 1;
        }
        return a1.ordre.compareTo(a2.ordre);
    }

    @Override
    public boolean equals(Object o) {
        TreeNode a1 = (TreeNode)o;
        return a1.id.equals(this.id);
    }
}

