/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Plan;
import cds.aladin.PlanBGCat;
import cds.aladin.PlanMoc;
import cds.aladin.SliderPlusMoins;
import java.awt.Graphics;

public class SliderDensity
extends SliderPlusMoins {
    public SliderDensity(Aladin aladin) {
        super(aladin, aladin.getChaine().getString("SLIDERDENSITY"), -3, 3, 1);
        this.setTooltip(aladin.getChaine().getString("SLIDERDENSITYTIP"));
    }

    @Override
    void submit(int inc) {
        Plan[] p = this.getPlanCatalog();
        if (p == null) {
            return;
        }
        for (Plan p1 : p) {
            try {
                if (p1 instanceof PlanBGCat) {
                    ((PlanBGCat)p1).setGapOrder((int)this.slider.getValue() + inc);
                    continue;
                }
                ((PlanMoc)p1).setGapOrder((int)this.slider.getValue() + inc);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.aladin.calque.repaintAll();
    }

    Plan[] getPlanCatalog() {
        Plan[] p = this.aladin.calque.getPlans();
        int n = 0;
        for (Plan p1 : p) {
            if (!this.isOk(p1)) continue;
            ++n;
        }
        if (n == 0) {
            return null;
        }
        Plan[] p2 = new Plan[n];
        n = 0;
        for (Plan p1 : p) {
            if (!this.isOk(p1)) continue;
            p2[n++] = p1;
        }
        return p2;
    }

    private boolean isOk(Plan p) {
        return p.selected && (p.type == 18 || p.type == 19);
    }

    @Override
    public void paintComponent(Graphics g) {
        Plan[] p = this.getPlanCatalog();
        if (p != null) {
            this.setEnabled(true);
            this.slider.setValue(((PlanBGCat)p[0]).getGapOrder());
        } else {
            this.slider.setValue(this.slider.min);
            this.setEnabled(false);
        }
        super.paintComponent(g);
    }
}

