/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.Glu;
import cds.aladin.MyInputStream;
import cds.aladin.MyLabel;
import cds.aladin.Server;
import cds.aladin.ServerVizieRSurvey;
import cds.tools.Util;
import cds.vizier.VizieRTable;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ServerVizieRMission
extends Server {
    static final String MOCGLU = "getMOC";
    static final String DMAPPNGGLU = "getDMapIcon";
    static final String MOCERROR = "Catalog unknown or MOC server error";
    Vector vArchives;
    VizieRTable missionlist;
    JTextField mission;
    MyLabel currentlist;
    protected String default_methode;
    protected String help_list;
    protected String nomTextfield;
    JCheckBox cbGetAll;
    JCheckBox cbGetAllCat;
    JButton getReadMe;
    JButton getMoc;
    JButton getDMap;
    protected String CATDESC;
    protected String TAGGLU = "VizieRXML++";
    protected String GETALL;
    protected String GETALL1;
    protected String CATMOC;
    protected String CATDMAP;
    protected String ALLCAT;
    private PngMap pngMap;
    private String oCat = null;

    protected void init() {
        this.aladinLogo = "VizieRMLogo.gif";
        this.docUser = "http://vizier.u-strasbg.fr";
    }

    @Override
    protected void createChaine() {
        super.createChaine();
        this.aladinLabel = Aladin.chaine.getString("ARNAME");
        this.nomTextfield = Aladin.chaine.getString("ARCAT");
        this.title = Aladin.chaine.getString("ARTITLE");
        this.description = Aladin.chaine.getString("ARINFO");
        this.default_methode = Aladin.chaine.getString("ARINFO1");
        this.help_list = Aladin.chaine.getString("ARINFO2");
        this.CATDESC = Aladin.chaine.getString("VZCATDESC");
        this.CATMOC = Aladin.chaine.getString("VZCATMOC");
        this.CATDMAP = Aladin.chaine.getString("VZCATDMAP");
        this.verboseDescr = Aladin.chaine.getString("ARDESC");
        this.GETALL = Aladin.chaine.getString("VZGETALL2");
        this.GETALL1 = Aladin.chaine.getString("VZGETALL3");
        this.ALLCAT = Aladin.chaine.getString("VZALLCAT");
    }

    protected ServerVizieRMission(Aladin aladin, Vector vArchives) {
        this.aladin = aladin;
        this.createChaine();
        this.init();
        this.type = 2;
        this.setBackground(Aladin.BLUE);
        this.setLayout(null);
        this.setFont(Aladin.PLAIN);
        int y = 0;
        int w = 100;
        int h1 = 50;
        this.pngMap = new PngMap();
        this.pngMap.setBackground(Aladin.BLUE);
        this.pngMap.setBounds(XWIDTH - w - 5, 15, w, h1);
        this.add(this.pngMap);
        JPanel tp = new JPanel();
        tp.setBackground(Aladin.BLUE);
        Dimension d = this.makeTitle(tp, this.aladinLabel);
        tp.setBounds(XWIDTH / 2 - d.width / 2, y, d.width, d.height);
        y += d.height + 10;
        this.add(tp);
        StringTokenizer st = new StringTokenizer(this.default_methode, "\n");
        while (st.hasMoreTokens()) {
            JLabel info = new JLabel(st.nextToken());
            info.setBounds(86, y, 400, 20);
            y += 15;
            this.add(info);
        }
        int yGetAll = (y += 5) + 15;
        int xGetAll = XWIDTH - 90 - 15;
        JPanel tPanel = new JPanel();
        tPanel.setBackground(Aladin.BLUE);
        int h = this.makeTargetPanel(tPanel, 8);
        tPanel.setBounds(0, y, xGetAll - 5, h);
        this.add(tPanel);
        this.modeCoo = 5;
        this.modeRad = 1;
        y += h;
        this.cbGetAll = new JCheckBox(this.GETALL, false);
        this.cbGetAll.setEnabled(false);
        if (!Aladin.OUTREACH) {
            this.cbGetAll.setBackground(Aladin.BLUE);
            this.cbGetAll.setBounds(xGetAll, yGetAll, 120, 20);
            yGetAll += 20;
            this.add(this.cbGetAll);
        }
        this.cbGetAllCat = new JCheckBox(this.GETALL1, false);
        this.cbGetAllCat.setEnabled(false);
        this.cbGetAllCat.setBackground(Aladin.BLUE);
        this.cbGetAllCat.setBounds(xGetAll, yGetAll, 120, 20);
        this.cbGetAllCat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean flag = !ServerVizieRMission.this.cbGetAllCat.isSelected();
                ServerVizieRMission.this.target.setEnabled(flag);
                ServerVizieRMission.this.radius.setEnabled(flag);
            }
        });
        if (!Aladin.OUTREACH && !(this instanceof ServerVizieRSurvey)) {
            this.add(this.cbGetAllCat);
            yGetAll += 20;
        }
        JLabel label1 = new JLabel(this.addDot(this.nomTextfield));
        label1.setBackground(Aladin.BLUE);
        label1.setFont(Aladin.BOLD);
        int l = 85;
        label1.setBounds(10, y, l, HAUT);
        this.add(label1);
        this.mission = new JTextField(28);
        this.mission.setBounds(l + 15, y, 120, HAUT);
        this.mission.addKeyListener(this);
        this.mission.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                ServerVizieRMission.this.updateWidgets();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                ServerVizieRMission.this.updateWidgets();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ServerVizieRMission.this.updateWidgets();
            }
        });
        this.add(this.mission);
        JLabel label2 = new JLabel(this.addDot(this.RAD));
        label2.setBackground(Aladin.BLUE);
        label2.setFont(Aladin.BOLD);
        label2.setBounds(231, y, l, HAUT);
        this.add(label2);
        this.radius = new JTextField("10 arcmin");
        this.radius.addKeyListener(this);
        this.radius.addActionListener(this);
        this.radius.setBounds(279, y, Aladin.OUTREACH ? 60 : 105, HAUT);
        y += HAUT + MARGE - 2;
        this.add(this.radius);
        this.modeRad = 1;
        Insets insets = new Insets(0, 10, 0, 10);
        this.getReadMe = new JButton(this.CATDESC);
        this.getReadMe.setMargin(insets);
        this.getReadMe.setEnabled(false);
        this.getReadMe.addActionListener(this);
        this.getReadMe.setFont(Aladin.BOLD);
        this.getMoc = new JButton(this.CATMOC);
        this.getMoc.setMargin(insets);
        this.getMoc.setEnabled(false);
        this.getMoc.addActionListener(this);
        this.getMoc.setFont(Aladin.BOLD);
        this.getDMap = new JButton(this.CATDMAP);
        this.getDMap.setMargin(insets);
        this.getDMap.setEnabled(false);
        this.getDMap.addActionListener(this);
        this.getDMap.setFont(Aladin.BOLD);
        JPanel catControl = new JPanel(new FlowLayout(0));
        catControl.setBounds(l + 15, y, 350, HAUT);
        catControl.setBackground(Aladin.BLUE);
        catControl.add(this.getReadMe);
        catControl.add(this.getMoc);
        if (Aladin.BETA) {
            catControl.add(this.getDMap);
        }
        if (!Aladin.OUTREACH) {
            this.add(catControl);
        }
        JLabel info2 = new JLabel(this.help_list);
        info2.setBounds(56, y += HAUT + MARGE + 5, 400, 20);
        y += 20;
        this.add(info2);
        this.missionlist = new VizieRTable(this.mission, null, null, vArchives, 12, 0);
        this.missionlist.setFont(Aladin.PLAIN);
        JScrollPane jc = new JScrollPane(this.missionlist);
        jc.setBounds(10, y, XWIDTH - 20, 180);
        y += 190;
        this.add(jc);
        this.setMaxComp(jc);
    }

    @Override
    protected boolean setParam(String param) {
        Vector v = this.missionlist.getList();
        Enumeration e = v.elements();
        StringTokenizer st = new StringTokenizer(param);
        String id = st.nextToken();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            st = new StringTokenizer(s, "\t");
            String sId = st.nextToken();
            if (!sId.equals(id)) continue;
            this.mission.setText(id);
            this.missionlist.selectCatalog(id);
            return true;
        }
        return false;
    }

    @Override
    protected String[] getNomPaths() {
        String n = super.getNomPaths()[0];
        Vector v = this.missionlist.getList();
        String[] res = new String[v.size()];
        Enumeration e = v.elements();
        int i = 0;
        while (e.hasMoreElements()) {
            StringTokenizer st = new StringTokenizer((String)e.nextElement(), "\t");
            res[i] = n + "/" + Util.slash(st.nextToken() + " - " + st.nextToken());
            ++i;
        }
        return res;
    }

    @Override
    protected int createPlane(String target, String radius, String criteria, String label, String origin) {
        String catalogs = criteria = ServerVizieRMission.specialUnQuoteCriteria(criteria);
        if (label == null) {
            label = catalogs;
        }
        return this.creatArchivePlane(target, radius, catalogs, label, origin, this.cbGetAll.isSelected());
    }

    protected int creatArchivePlane(String target, String radius, String catalogs, String label, String origin, boolean allColumns) {
        URL u;
        radius = ServerVizieRMission.getRM(radius) + "";
        String s = Glu.quote(catalogs) + " " + Glu.quote(target) + " " + Glu.quote(radius);
        if (allColumns) {
            s = s + " -out.all";
        }
        if ((u = this.aladin.glu.getURL(this.TAGGLU, s)) == null) {
            Aladin.warning(this, this.WERROR);
            return -1;
        }
        if (!this.verif(8, target, label + " " + radius)) {
            return -1;
        }
        return this.aladin.calque.newPlanCatalog(u, label, target, label + " " + radius, origin, this);
    }

    protected int createMocPlane(String cat) {
        MyInputStream in;
        URL u = this.aladin.glu.getURL(MOCGLU, Glu.quote(cat));
        Aladin.trace(4, "ServerVizierMission.createMocPlane(" + cat + ") URL= " + u);
        try {
            in = Util.openStream(u);
        }
        catch (Exception e) {
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            Aladin.warning(this, MOCERROR, 1);
            return -1;
        }
        return this.aladin.calque.newPlanMOC(in, cat + " MOC");
    }

    @Override
    public void submit() {
        String objet = "";
        double rm = 0.0;
        boolean allcat = this.cbGetAllCat.isSelected();
        String cata = this.mission.getText().trim();
        if (!allcat && (objet = this.getTarget()) == null) {
            return;
        }
        if (cata.equals("")) {
            Aladin.warning(this, this.WNEEDCAT);
            return;
        }
        if (allcat || objet == null || objet.length() == 0) {
            if (cata.length() == 0) {
                Aladin.warning(this, this.WNEEDCAT);
                return;
            }
            if (!Aladin.confirmation(this, this.ALLCAT + " \"" + cata + "\" ?")) {
                return;
            }
            objet = "";
            rm = 0.0;
        } else if (!allcat) {
            String r = this.getRadius();
            if (r == null) {
                return;
            }
            rm = ServerVizieRMission.getRM(r);
        }
        if (allcat) {
            objet = "";
        }
        this.waitCursor();
        this.resetList();
        String s = "";
        if (this.cbGetAll.isSelected()) {
            s = ",allcolumns";
        }
        if (!this.cbGetAllCat.isSelected() && objet != null && objet.length() > 0) {
            this.aladin.console.printCommand("get VizieR(" + cata + s + ") " + objet + " " + Coord.getUnit(rm / 60.0));
        } else {
            this.aladin.console.printCommand("get VizieR(" + cata + s + ")");
        }
        int n = this.createPlane(objet, rm + "", cata, null, this.institute);
        if (n != -1) {
            this.aladin.calque.getPlan(n).setBookmarkCode("get VizieR(" + cata + s + ") $TARGET $RADIUS");
        }
        this.resetFlagBoxes();
        this.defaultCursor();
    }

    protected void resetList() {
        this.missionlist.resetList();
        this.pngMap.setImage(null);
    }

    @Override
    protected void clear() {
        super.clear();
        this.mission.setText("");
        this.resetList();
    }

    @Override
    protected void reset() {
        super.reset();
        this.mission.setText("");
        this.resetList();
        this.resetFlagBoxes();
    }

    protected void resetFlagBoxes() {
        this.cbGetAll.setSelected(false);
        this.cbGetAllCat.setSelected(false);
        this.target.setEnabled(true);
        this.radius.setEnabled(true);
    }

    @Override
    protected boolean updateWidgets() {
        if (!super.updateWidgets()) {
            return false;
        }
        if (this.mission == null) {
            return false;
        }
        String cat = this.mission.getText().trim();
        if (this.oCat != null && this.oCat.equals(cat)) {
            return true;
        }
        this.oCat = cat;
        boolean catOk = cat.length() != 0;
        this.getReadMe.setEnabled(catOk);
        this.getMoc.setEnabled(catOk);
        this.getDMap.setEnabled(catOk);
        this.cbGetAll.setEnabled(catOk);
        this.cbGetAllCat.setEnabled(catOk);
        return true;
    }

    protected void reaffiche() {
        this.hide();
        this.show();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        Object s = e.getSource();
        if (s instanceof JButton) {
            try {
                String action = ((JButton)s).getActionCommand();
                if (action.equals(this.CATDESC) || action.equals(this.CATMOC) || action.equals(this.CATDMAP)) {
                    String cata = this.mission.getText().trim();
                    if (cata.equals("")) {
                        Aladin.warning(this, this.WNEEDCAT);
                        return;
                    }
                    if (action.equals(this.CATDESC)) {
                        this.aladin.glu.showDocument("getReadMe", Glu.quote(cata));
                    } else if (action.equals(this.CATMOC)) {
                        URL u = this.aladin.glu.getURL(MOCGLU, Glu.quote(cata) + " 512");
                        this.aladin.execAsyncCommand("'" + cata + " MOC'=get File(" + u + ")");
                    } else if (action.equals(this.CATDMAP)) {
                        this.aladin.calque.newPlanDMap(cata);
                    }
                    this.defaultCursor();
                    return;
                }
            }
            catch (Exception e1) {
                Aladin.warning("Error: cannot load this product\n" + e1.getMessage());
            }
        }
    }

    class PngMap
    extends JComponent {
        Image image = null;

        PngMap() {
        }

        void setImage(Image image) {
            this.image = image;
            this.repaint();
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.image != null) {
                g.drawImage(this.image, 0, 0, this);
            }
        }
    }
}

