/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.MyInputStream;
import cds.aladin.Plan;
import cds.aladin.PlanMoc;
import cds.aladin.Server;
import cds.moc.HealpixMoc;
import cds.tools.MultiPartPostOutputStream;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ServerMocQuery
extends Server {
    private static String[] LARGE_CATS = new String[]{"2MASS", "CMC14", "UCAC3", "UCAC4", "2MASS6X", "SDSS8", "USNOB1", "WISE_ALLSKY", "DENIS", "GLIMPSE", "GSC23", "NOMAD", "PPMX", "PPMXL", "TYCHO2", "SIMBAD", "UKIDSS_DR8_LAS", "UKIDSS_DR6_GPS"};
    private String baseUrl = "http://cdsxmatch.u-strasbg.fr/QueryCat/QueryCat";
    private JComboBox comboMoc;
    private JComboBox comboCat;
    private JTextField textCat;
    private JComboBox comboMaxNbRows;

    protected void init() {
        this.type = 2;
        this.title = "MOC query";
        this.aladinLabel = "MOC";
    }

    @Override
    protected void createChaine() {
        this.description = "Query by MOC";
        super.createChaine();
    }

    protected ServerMocQuery(Aladin aladin) {
        this.aladin = aladin;
        this.createChaine();
        this.init();
        this.setBackground(Aladin.BLUE);
        this.setLayout(null);
        this.setFont(Aladin.PLAIN);
        int y = Aladin.OUTREACH ? 60 : 50;
        int X = 150;
        JPanel tp = new JPanel();
        Dimension d = this.makeTitle(tp, this.title);
        tp.setBackground(Aladin.BLUE);
        tp.setBounds(235 - d.width / 2, y, d.width, d.height);
        this.add(tp);
        JLabel l = new JLabel(this.description);
        l.setBounds(90, y += d.height + 10, 400, 20);
        this.add(l);
        JLabel pTitre = new JLabel("Choose a MOC");
        pTitre.setFont(Aladin.BOLD);
        pTitre.setBounds(10, y += 20, 150, HAUT);
        this.add(pTitre);
        this.comboMoc = new JComboBox();
        this.comboMoc.setBounds(160, y, XWIDTH - 160, HAUT);
        this.add(this.comboMoc);
        pTitre = new JLabel("Catalog to query");
        pTitre.setFont(Aladin.BOLD);
        pTitre.setBounds(10, y += HAUT + MARGE, 150, HAUT);
        this.add(pTitre);
        pTitre = new JLabel("Choose in list");
        pTitre.setFont(Aladin.ITALIC);
        pTitre.setBounds(10, y += HAUT + MARGE, 150, HAUT);
        this.add(pTitre);
        this.comboCat = new JComboBox();
        this.comboCat.addItem("---");
        Arrays.sort(LARGE_CATS);
        for (String cat : LARGE_CATS) {
            this.comboCat.addItem(cat);
        }
        this.comboCat.setBounds(160, y, XWIDTH - 160, HAUT);
        this.add(this.comboCat);
        pTitre = new JLabel("Or enter a VizieR table ID");
        pTitre.setFont(Aladin.ITALIC);
        pTitre.setBounds(10, y += HAUT + MARGE, 150, HAUT);
        this.add(pTitre);
        this.textCat = new JTextField();
        this.textCat.setBounds(160, y, XWIDTH - 160, HAUT);
        y += HAUT + MARGE;
        this.add(this.textCat);
        this.comboCat.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getItem().equals("---")) {
                    ServerMocQuery.this.textCat.setEnabled(true);
                } else {
                    ServerMocQuery.this.textCat.setEnabled(false);
                    ServerMocQuery.this.textCat.setText("");
                }
            }
        });
        pTitre = new JLabel("Max nb of rows");
        pTitre.setFont(Aladin.BOLD);
        pTitre.setBounds(10, y, 150, HAUT);
        this.add(pTitre);
        this.comboMaxNbRows = new JComboBox();
        this.comboMaxNbRows.addItem("10,000");
        this.comboMaxNbRows.addItem("50,000");
        this.comboMaxNbRows.addItem("100,000");
        this.comboMaxNbRows.addItem("unlimited");
        this.comboMaxNbRows.setBounds(160, y, XWIDTH - 160, HAUT);
        y += HAUT + MARGE;
        this.add(this.comboMaxNbRows);
    }

    @Override
    protected void adjustInputChoice(JComboBox c, Vector v, int defaut) {
        int i = c.getSelectedIndex();
        String s = i >= 0 ? (String)c.getItemAt(i) : null;
        c.removeAllItems();
        c.addItem(this.NOINPUTITEM);
        if (v != null) {
            Enumeration e = v.elements();
            while (e.hasMoreElements()) {
                c.addItem(((Plan)e.nextElement()).label);
            }
        }
        if (defaut > 0) {
            c.setSelectedIndex(defaut);
        } else if (s == null || s.equals(this.NOINPUTITEM)) {
            c.setSelectedIndex(0);
        } else {
            c.setSelectedItem(s);
        }
    }

    @Override
    public void setVisible(boolean flag) {
        if (flag) {
            Vector<Plan> mocs = this.aladin.calque.getPlans(PlanMoc.class);
            this.comboMoc.removeAllItems();
            if (mocs != null) {
                Iterator<Plan> it = mocs.iterator();
                while (it.hasNext()) {
                    this.comboMoc.addItem(it.next());
                }
            }
        }
        super.setVisible(flag);
    }

    @Override
    protected boolean isDiscovery() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void submitThread() {
        URL url;
        this.waitCursor();
        try {
            url = new URL(this.baseUrl);
        }
        catch (MalformedURLException mue) {
            this.defaultCursor();
            mue.printStackTrace();
            return;
        }
        PlanMoc selectedMoc = (PlanMoc)this.comboMoc.getSelectedItem();
        if (selectedMoc == null) {
            Aladin.warning("No MOC selected !");
            return;
        }
        try {
            MultiPartPostOutputStream.setTmpDir(Aladin.CACHEDIR);
            String boundary = MultiPartPostOutputStream.createBoundary();
            URLConnection urlConn = MultiPartPostOutputStream.createConnection(url);
            urlConn.setRequestProperty("Accept", "*/*");
            urlConn.setRequestProperty("Content-Type", MultiPartPostOutputStream.getContentType(boundary));
            urlConn.setRequestProperty("Connection", "Keep-Alive");
            urlConn.setRequestProperty("Cache-Control", "no-cache");
            MultiPartPostOutputStream out = new MultiPartPostOutputStream(urlConn.getOutputStream(), boundary);
            String catName = this.comboCat.getSelectedItem().equals("---") ? this.textCat.getText().trim() : this.comboCat.getSelectedItem().toString();
            out.writeField("catName", catName);
            out.writeField("mode", "mocfile");
            out.writeField("format", "votable");
            String limit = this.comboMaxNbRows.getSelectedItem().toString();
            if (!limit.equals("unlimited")) {
                limit = limit.replaceAll(",", "");
                out.writeField("limit", limit);
            }
            HealpixMoc hpxMoc = selectedMoc.getMoc();
            File tmpMoc = File.createTempFile("moc", "fits");
            tmpMoc.deleteOnExit();
            FileOutputStream fo = new FileOutputStream(tmpMoc);
            try {
                hpxMoc.writeFits(fo);
            }
            finally {
                try {
                    fo.close();
                }
                catch (Exception e) {}
            }
            out.writeFile("mocfile", null, tmpMoc, false);
            out.close();
            this.aladin.calque.newPlanCatalog(new MyInputStream(urlConn.getInputStream()), catName + " MOC query");
        }
        catch (Exception ioe) {
            this.defaultCursor();
            ioe.printStackTrace();
            Aladin.warning("An error occured while contacting the QueryCat service");
            return;
        }
        this.defaultCursor();
    }

    @Override
    public void submit() {
        new Thread(){

            @Override
            public void run() {
                ServerMocQuery.this.submitThread();
            }
        }.start();
    }
}

