/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.Couleur;
import cds.aladin.Hist;
import cds.aladin.Localisation;
import cds.aladin.Plan;
import cds.aladin.PlanBG;
import cds.aladin.PlanField;
import cds.aladin.PlanImage;
import cds.aladin.Position;
import cds.aladin.Projection;
import cds.aladin.Server;
import cds.aladin.ViewSimple;
import cds.aladin.prop.Prop;
import cds.aladin.prop.PropAction;
import cds.tools.Util;
import cds.tools.pixtools.CDSHealpix;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JTextField;

public class Repere
extends Position {
    static final int DEFAULT = 0;
    static final int TARGET = 1;
    static final int TARGETL = 2;
    static final int ARROW = 3;
    static final int CENTER = 4;
    static final int ROTCENTER = 5;
    static final int CARTOUCHE = 6;
    protected int L = 5;
    private double radius;
    protected int dw;
    protected int dh;
    protected int type = 0;
    protected Color couleur = null;
    private static final String C = "|";
    Position rotcenter = null;
    static final Color JAUNEPALE = new Color(255, 255, 225);

    protected Repere(Plan plan, ViewSimple v, double x, double y) {
        super(plan, v, x, y, 0.0, 0.0, 5, null);
    }

    protected Repere(Plan plan) {
        super(plan);
    }

    protected Repere(Plan plan, Coord c) {
        super(plan, null, 0.0, 0.0, c.al, c.del, 2, null);
    }

    protected Repere(Plan plan, ViewSimple v, double x, double y, double raj, double dej) {
        super(plan, v, x, y, raj, dej, 3, null);
        this.setId();
        this.setWithLabel(false);
    }

    public Vector getProp() {
        Vector<Prop> propList = super.getProp();
        if (this.hasRayon()) {
            final Repere myself = this;
            final JTextField testRadius = new JTextField(10);
            final PropAction updateRadius = new PropAction(){

                @Override
                public int action() {
                    testRadius.setText(Coord.getUnit(Repere.this.getRadius()));
                    return 1;
                }
            };
            PropAction changRadius = new PropAction(){

                @Override
                public int action() {
                    testRadius.setForeground(Color.black);
                    String oval = Coord.getUnit(Repere.this.getRadius());
                    try {
                        String nval = testRadius.getText();
                        if (nval.equals(oval)) {
                            return -1;
                        }
                        ((Repere)myself).setRadius(nval);
                        return 1;
                    }
                    catch (Exception e1) {
                        updateRadius.action();
                        testRadius.setForeground(Color.red);
                        return 0;
                    }
                }
            };
            propList.add(Prop.propFactory("radius", "Radius", "", testRadius, updateRadius, changRadius));
        }
        final Couleur col = new Couleur(this.couleur, true);
        final PropAction changeCouleur = new PropAction(){

            @Override
            public int action() {
                Color c = col.getCouleur();
                if (c == Repere.this.couleur) {
                    return -1;
                }
                Repere.this.couleur = c;
                return 1;
            }
        };
        col.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                changeCouleur.action();
                Repere.this.plan.aladin.view.repaintAll();
            }
        });
        propList.add(Prop.propFactory("color", "Color", "Alternative color", col, null, changeCouleur));
        return propList;
    }

    @Override
    protected String getSpecificAJInfo() {
        return this.id + C + (this.hasRayon() ? Double.valueOf(this.getRadius()) : "");
    }

    @Override
    protected void setSpecificAJInfo(String s) {
        block3: {
            StringTokenizer tok = new StringTokenizer(s, C);
            String s1 = tok.nextToken();
            String string = this.id = s1.length() == 0 ? null : s1;
            if (tok.hasMoreTokens()) {
                try {
                    this.radius = Double.parseDouble(tok.nextToken());
                }
                catch (Exception e) {
                    if (Aladin.levelTrace != 3) break block3;
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public String getObjType() {
        return "Phot";
    }

    protected void setType(int type) {
        this.type = type;
    }

    protected void setRotCenterType(Position o) {
        this.type = 5;
        this.rotcenter = o;
    }

    protected int getType() {
        return this.type;
    }

    protected boolean isLargeReticle() {
        return this.type == 2;
    }

    protected void setSize(int L) {
        this.L = L;
    }

    @Override
    protected void setCoord(ViewSimple v) {
        super.setCoord(v);
        this.setId();
    }

    @Override
    protected void setPosition(ViewSimple v, double x, double y) {
        super.setPosition(v, x, y);
        this.setId();
    }

    @Override
    protected void deltaPosition(ViewSimple v, double x, double y) {
        super.deltaPosition(v, x, y);
        this.setId();
    }

    @Override
    protected void deltaRaDec(double dra, double dde) {
        super.deltaRaDec(dra, dde);
        this.setId();
    }

    protected void reprojection(ViewSimple v) {
        super.projection(v);
    }

    void setD() {
        FontMetrics m = Toolkit.getDefaultToolkit().getFontMetrics(DF);
        this.dw = m.stringWidth(this.id) + 4;
        this.dh = HF;
    }

    @Override
    public void setColor(Color c) {
        this.couleur = c;
    }

    protected void setRadius(String r) {
        this.radius = Server.getAngle(r, 1) / 60.0;
    }

    void setRayon(ViewSimple v, double r) {
        Coord c = new Coord();
        Projection proj = v.getProj().copy();
        proj.setProjCenter(0.0, 0.0);
        double d = 0.0;
        c.del = 0.0;
        c.al = 0.0;
        proj.getXY(c);
        if (Double.isNaN(c.del)) {
            proj = v.getProj().copy();
            c.al = this.raj;
            c.del = this.dej;
            d = this.dej;
            proj.getXY(c);
        }
        c.y += r;
        proj.getCoord(c);
        this.radius = Math.abs(d - c.del);
    }

    protected void setId(String s) {
        this.id = s;
        this.setD();
    }

    void setId() {
        this.id = this.plan.aladin.localisation.J2000ToString(this.raj, this.dej);
        this.setD();
    }

    @Override
    protected boolean inside(ViewSimple v, double x, double y) {
        if (!this.isVisible()) {
            return false;
        }
        double r = this.getRayon(v);
        if (r > 0.0) {
            return (x - this.xv[v.n]) * (x - this.xv[v.n]) + (y - this.yv[v.n]) * (y - this.yv[v.n]) <= (r + 1.0) * (r + 1.0);
        }
        double l = (double)this.L / v.getZoom();
        double xc = this.xv[v.n];
        double yc = this.yv[v.n];
        if (this.type == 6) {
            return xc <= x + l + (double)(this.dw / 2) && xc >= x - l - (double)(this.dw / 2) && yc <= y + l + (double)(this.dh / 2) && yc >= y - l - (double)(this.dh / 2);
        }
        return xc <= x + l && xc >= x - l && yc <= y + l && yc >= y - l;
    }

    protected boolean inLabel(ViewSimple v, double x, double y) {
        Point p = this.getViewCoord(v, this.L, this.L);
        if (p == null) {
            return false;
        }
        return x >= (double)(p.x - this.dw / 2) && x <= (double)(p.x + this.dw / 2) && y >= (double)(p.y - this.L - this.dh - 1) && y <= (double)(p.y - this.L + 5);
    }

    @Override
    protected Rectangle extendClip(ViewSimple v, Rectangle clip) {
        Point p1;
        if (!this.isVisible()) {
            return clip;
        }
        int L = (int)Math.ceil(Math.max((double)this.L, this.getRayon(v) * v.getZoom()));
        Point p = this.getViewCoord(v, L, L);
        if (p == null) {
            return clip;
        }
        int D = L;
        if (this.type == 4 || this.type == 5) {
            D = (int)Math.min(Math.max(2.0, v.getZoom() * 3.0), 16.0);
        }
        clip = Repere.unionRect(clip, p.x - D, p.y - D, D * 2, D * 2);
        if (this.type == 5 && (p1 = v.getViewCoord(this.rotcenter.xv[v.n], this.rotcenter.yv[v.n])) != null) {
            clip = Repere.unionRect(clip, p1.x - D, p1.y - D, D * 2, D * 2);
        }
        if (this.isSelected()) {
            clip = Repere.unionRect(clip, p.x - L - 4, p.y - L - 4, L * 2 + 8, L * 2 + 8);
        }
        if (this.isWithLabel()) {
            clip = Repere.unionRect(clip, p.x - this.dw / 2, p.y - L - 1 - this.dh - 1, this.dw, this.dh);
        }
        if (this.hasRayon() && this.isSelected()) {
            clip = Repere.unionRect(clip, this.getStatPosition(v));
        }
        return clip;
    }

    protected Rectangle getClipRayon(ViewSimple v) {
        Rectangle clip = null;
        if (!this.isVisible()) {
            return null;
        }
        int L = (int)Math.ceil(this.getRayon(v) * v.getZoom());
        Point p = this.getViewCoord(v, L, L);
        if (p == null) {
            return null;
        }
        if (this.isSelected()) {
            clip = Repere.unionRect(clip, p.x - L - 4, p.y - L - 4, L * 2 + 8, L * 2 + 8);
        }
        return clip;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Color getColor() {
        if (this.type == 1 || this.type == 2) {
            this.couleur = Color.magenta.darker();
        }
        if (this.couleur != null) {
            return this.couleur;
        }
        if (this.type == 6) {
            this.couleur = Color.blue;
            return this.couleur;
        } else if (this.type == 3) {
            this.couleur = Color.red;
            return this.couleur;
        } else {
            if (this.plan == null) return Color.black;
            if (this.plan.type != 10) return this.plan.c;
            this.couleur = ((PlanField)this.plan).getColor(this);
        }
        return this.couleur;
    }

    private void drawReticule(Graphics g, int x, int y, int demiLargeur, int demiCentre, Color c) {
        g.setColor(c);
        g.drawLine(x - demiLargeur, y, x - demiCentre, y);
        g.drawLine(x + demiCentre, y, x + demiLargeur, y);
        g.drawLine(x, y - demiLargeur, x, y - demiCentre);
        g.drawLine(x, y + demiLargeur, x, y + demiCentre);
    }

    @Override
    protected boolean statCompute(Graphics g, ViewSimple v) {
        boolean flagHist;
        boolean bl = flagHist = v == v.aladin.view.getCurrentView();
        if (v == null || v.isFree() || !this.hasPhot(v.pref)) {
            return false;
        }
        this.statInit();
        double xc = this.xv[v.n] - 0.5;
        double yc = this.yv[v.n] - 0.5;
        double r = this.getRayon(v);
        if (r > 100.0 && v.flagClicAndDrag) {
            return false;
        }
        minx = (int)Math.floor(xc - r);
        maxx = (int)Math.ceil(xc + r);
        miny = (int)Math.floor(yc - r);
        maxy = (int)Math.ceil(yc + r);
        double carreRayon = r * r;
        double pixelSurf = 0.0;
        Hist.HistItem onMouse = null;
        if (flagHist) {
            Hist.HistItem histItem = onMouse = v.aladin.view.zoomview.hist == null ? null : v.aladin.view.zoomview.hist.onMouse;
            if (onMouse == null) {
                v.aladin.view.zoomview.initPixelHist();
            } else {
                flagHist = false;
            }
        }
        if (v.pref instanceof PlanBG) {
            try {
                PlanBG pbg = (PlanBG)v.pref;
                int orderFile = pbg.getOrder();
                long nsideFile = CDSHealpix.pow2(orderFile);
                long nsideLosange = CDSHealpix.pow2(pbg.getTileOrder());
                long nside = nsideFile * nsideLosange;
                pixelSurf = CDSHealpix.pixRes(nside) / 3600.0;
                pixelSurf *= pixelSurf;
                Coord coo = new Coord(this.raj, this.dej);
                coo = Localisation.frameToFrame(coo, 0, pbg.frameOrigin);
                double radiusRadian = Math.toRadians(this.getRadius());
                long[] npix = CDSHealpix.query_disc(nside, coo.al, coo.del, radiusRadian, false);
                for (int i = 0; i < npix.length; ++i) {
                    long npixFile = npix[i] / (nsideLosange * nsideLosange);
                    double pix = pbg.getHealpixPixel(orderFile, npixFile, npix[i], 0);
                    if (Double.isNaN(pix)) continue;
                    pix = pix * pbg.bScale + pbg.bZero;
                    double[] polar = CDSHealpix.pix2ang_nest(nside, npix[i]);
                    polar = CDSHealpix.polarToRadec(polar);
                    coo.al = polar[0];
                    coo.del = polar[1];
                    coo = Localisation.frameToFrame(coo, pbg.frameOrigin, 0);
                    this.statPixel(g, pix, coo.al, coo.del, v, onMouse);
                    if (!flagHist) continue;
                    v.aladin.view.zoomview.addPixelHist(pix);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            try {
                pixelSurf = v.pref.projd.getPixResAlpha() * v.pref.projd.getPixResDelta();
            }
            catch (Exception e) {
                // empty catch block
            }
            for (double y = miny; y <= maxy; y += 1.0) {
                for (double x = minx; x <= maxx; x += 1.0) {
                    double pix;
                    if ((x - xc) * (x - xc) + (y - yc) * (y - yc) > carreRayon || Double.isNaN(pix = this.statPixel(g, (int)x, (int)y, v, onMouse)) || !flagHist) continue;
                    v.aladin.view.zoomview.addPixelHist(pix);
                }
            }
        }
        if (flagHist) {
            v.aladin.view.zoomview.createPixelHist(v.pref.type == 16 ? "HEALPixels" : "Pixels");
        }
        xc = this.xv[v.n];
        yc = this.yv[v.n];
        minx = xc - r;
        maxx = xc + r;
        miny = yc - r;
        maxy = yc + r;
        try {
            surface = (double)nombre * pixelSurf;
            moyenne = total / (double)nombre;
            variance = carre / (double)nombre - moyenne * moyenne;
            sigma = Math.sqrt(variance);
            if (medianeArrayNb == 10000) {
                mediane = Double.NaN;
            } else {
                Arrays.sort(medianeArray, 0, medianeArrayNb);
                mediane = medianeArray[medianeArrayNb / 2];
            }
            this.setWithStat(true);
        }
        catch (Exception e) {
            // empty catch block
        }
        return true;
    }

    @Override
    public boolean hasSurface() {
        return this.radius > 0.0;
    }

    @Override
    public double[] getStatistics(Plan p) throws Exception {
        double pixelSurf;
        Projection proj = p.projd;
        if (!p.hasAvailablePixels()) {
            throw new Exception("getStats error: image without pixel values");
        }
        if (!this.hasPhot(p)) {
            throw new Exception("getStats error: not compatible image");
        }
        if (!Projection.isOk(proj)) {
            throw new Exception("getStats error: image without astrometrical calibration");
        }
        if (this.radius <= 0.0) {
            throw new Exception("getStats error: no radius");
        }
        double nombre = 0.0;
        double carre = 0.0;
        double total = 0.0;
        if (p.type == 16) {
            PlanBG pbg = (PlanBG)p;
            int orderFile = pbg.getOrder();
            long nsideFile = CDSHealpix.pow2(orderFile);
            long nsideLosange = CDSHealpix.pow2(pbg.getTileOrder());
            long nside = nsideFile * nsideLosange;
            pixelSurf = CDSHealpix.pixRes(nside) / 3600.0;
            pixelSurf *= pixelSurf;
            Coord coo = new Coord(this.raj, this.dej);
            coo = Localisation.frameToFrame(coo, 0, pbg.frameOrigin);
            double radiusRadian = Math.toRadians(this.getRadius());
            long[] npix = CDSHealpix.query_disc(nside, coo.al, coo.del, radiusRadian, false);
            for (int i = 0; i < npix.length; ++i) {
                long npixFile = npix[i] / (nsideLosange * nsideLosange);
                double pix = pbg.getHealpixPixel(orderFile, npixFile, npix[i], 0);
                if (Double.isNaN(pix)) continue;
                pix = pix * pbg.bScale + pbg.bZero;
                nombre += 1.0;
                total += pix;
                carre += pix * pix;
            }
        } else {
            PlanImage pi = (PlanImage)p;
            pi.setLockCacheFree(true);
            pi.pixelsOriginFromCache();
            pixelSurf = proj.getPixResAlpha() * proj.getPixResDelta();
            Coord c = new Coord(this.raj, this.dej);
            proj.getXY(c);
            double xc = c.x - 0.5;
            double yc = c.y - 0.5;
            c.del = this.dej + this.radius;
            proj.getXY(c);
            double dy = yc + 0.5 - c.y;
            double dx = xc + 0.5 - c.x;
            double r = Math.sqrt(dx * dx + dy * dy);
            double carreRayon = r * r;
            int minx = (int)Math.floor(xc - r);
            int maxx = (int)Math.ceil(xc + r);
            int miny = (int)Math.floor(yc - r);
            int maxy = (int)Math.ceil(yc + r);
            for (int y = miny; y <= maxy; ++y) {
                for (int x = minx; x <= maxx; ++x) {
                    double pix;
                    if (((double)x - xc) * ((double)x - xc) + ((double)y - yc) * ((double)y - yc) > carreRayon || Double.isNaN(pix = pi.getPixelInDouble(x, y))) continue;
                    nombre += 1.0;
                    total += pix;
                    carre += pix * pix;
                }
            }
            pi.setLockCacheFree(false);
        }
        double surface = nombre * pixelSurf;
        double moyenne = total / nombre;
        double variance = carre / nombre - moyenne * moyenne;
        double sigma = Math.sqrt(variance);
        return new double[]{nombre, total, sigma, surface};
    }

    @Override
    public double getRadius() {
        return this.radius;
    }

    protected boolean hasRayon() {
        return this.radius > 0.0;
    }

    @Override
    public boolean hasPhot() {
        return this.hasRayon();
    }

    public boolean hasPhot(Plan p) {
        if (!this.hasPhot()) {
            return false;
        }
        return p.hasAvailablePixels();
    }

    @Override
    public String getCommand() {
        String r = this.plan.aladin.localisation.getFrame() == 11 ? Util.myRound(this.getRayon(this.plan.aladin.view.getCurrentView())) : Coord.getUnit(this.getRadius());
        return "draw phot(" + this.getLocalisation() + "," + r + ")";
    }

    protected double getRayon(ViewSimple v) {
        Coord c = new Coord();
        Projection proj = v.getProj();
        if (this.radius == 0.0 || v.pref == null || !Projection.isOk(proj)) {
            return 0.0;
        }
        c.al = this.raj;
        c.del = this.dej + this.radius;
        proj.getXY(c);
        double dy = this.yv[v.n] - c.y;
        double dx = this.xv[v.n] - c.x;
        return Math.sqrt(dx * dx + dy * dy);
    }

    protected void drawSpecialCircle(Graphics g, ViewSimple v) {
        Coord c = new Coord();
        Point p1 = new Point(0, 0);
        Point p2 = new Point(0, 0);
        Projection proj = v.getProj().copy();
        for (double theta = 0.0; theta < 6.3; theta += 0.1) {
            c.del = this.dej + this.radius * Math.sin(theta);
            c.al = this.raj + this.radius * Math.cos(theta);
            proj.getXY(c);
            if (Double.isNaN(c.x)) continue;
            p2 = v.getViewCoord(p2, c.x, c.y);
            if (theta > 0.0) {
                g.drawLine(p1.x, p1.y, p2.x, p2.y);
            }
            p1.x = p2.x;
            p1.y = p2.y;
        }
    }

    protected boolean onPoignee(ViewSimple v, double x, double y) {
        double r = this.getRayon(v) + 1.0;
        for (int i = 0; i < 4; ++i) {
            double xc = this.xv[v.n];
            double yc = this.yv[v.n];
            if (i == 0) {
                yc += r;
            } else if (i == 2) {
                yc -= r;
            } else {
                xc = i == 1 ? (xc += r) : (xc -= r);
            }
            double dx = x - xc;
            double dy = y - yc;
            double l = (double)this.L / v.getZoom();
            if (l < 1.0) {
                l = 1.0;
            }
            if (!(dx * dx + dy * dy < l * l)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean draw(Graphics g, ViewSimple v, int dx, int dy) {
        if (!this.isVisible()) {
            return false;
        }
        Point p = this.getViewCoord(v, this.L, this.L);
        if (p == null) {
            return false;
        }
        p.x += dx;
        p.y += dy;
        g.setColor(this.getColor());
        switch (this.type) {
            case 1: 
            case 2: {
                int demiLargeur = (int)Math.min(Math.max(8.0, v.getZoom() * 12.0), 32.0);
                int demiCentre = Math.max(Math.min(demiLargeur - 7, demiLargeur / 3), 2);
                if (demiLargeur > 10) {
                    g.drawLine(p.x, p.y, p.x, p.y);
                }
                if (this.type == 2) {
                    demiLargeur = 3000;
                }
                this.drawReticule(g, p.x, p.y, demiLargeur, demiCentre, this.getColor());
                break;
            }
            case 4: {
                int demiLargeur = (int)Math.min(Math.max(2.0, v.getZoom() * 3.0), 16.0);
                int demiCentre = 2 * demiLargeur / 3;
                this.drawReticule(g, p.x, p.y, demiLargeur, demiCentre, this.getColor());
                break;
            }
            case 5: {
                if (!Aladin.ROTATEFOVCENTER) {
                    return false;
                }
                Util.drawCircle7(g, p.x, p.y);
                Point p1 = v.getViewCoord(this.rotcenter.xv[v.n], this.rotcenter.yv[v.n]);
                if (p1 == null) {
                    return false;
                }
                g.drawLine(p.x, p.y, p1.x, p1.y);
                break;
            }
            case 0: {
                if (!this.hasRayon()) {
                    g.drawLine(p.x - this.L, p.y, p.x + this.L, p.y);
                    g.drawLine(p.x, p.y - this.L, p.x, p.y + this.L);
                    if (this.isSelected() && this.plan.aladin.view.nbSelectedObjet() <= 2) {
                        this.cutOn();
                        break;
                    }
                    this.cutOff();
                    break;
                }
                int l = (int)(this.getRayon(v) * v.getZoom());
                if (this.hasPhot(v.pref)) {
                    Util.drawFillOval(g, p.x - l, p.y - l, l * 2, l * 2, 0.1f * this.plan.getOpacityLevel(), null);
                    if (!this.isSelected()) break;
                    this.statDraw(g, v, dx, dy);
                    break;
                }
                g.drawOval(p.x - l, p.y - l, l * 2, l * 2);
                break;
            }
            case 3: {
                g.drawLine(p.x, p.y - this.L, p.x, p.y - 3);
                g.drawLine(p.x, p.y - 3, p.x - 3, p.y - 6);
                g.drawLine(p.x, p.y - 3, p.x + 3, p.y - 6);
                break;
            }
            case 6: {
                g.setColor(JAUNEPALE);
                g.drawLine(p.x - this.L + 1, p.y - this.L, p.x + 1, p.y);
                g.setColor(Color.black);
                g.drawLine(p.x - this.L, p.y - this.L, p.x, p.y);
                g.setColor(JAUNEPALE);
                Util.fillCircle5(g, p.x, p.y);
                g.setColor(Color.black);
                Util.drawCircle7(g, p.x, p.y);
            }
        }
        if (this.isWithLabel() && !this.hasRayon()) {
            if (this.id == null) {
                this.setId();
            }
            if (this.type == 6) {
                Util.drawCartouche(g, p.x - this.dw / 2, p.y - this.L - this.dh - 1, this.dw - 2, this.dh + 3, 1.0f, Color.black, JAUNEPALE);
                g.setColor(this.getColor());
                g.setFont(Aladin.SPLAIN);
                g.drawString(this.id, p.x - this.dw / 2, p.y - this.L - 1);
            } else {
                g.drawString(this.id, p.x - this.dw / 2, p.y - this.L - 1);
            }
        }
        if (this.isSelected()) {
            g.setColor(Color.green);
            this.drawSelect(g, v);
        }
        return true;
    }

    @Override
    protected void drawSelect(Graphics g, ViewSimple v) {
        if (this.type == 5) {
            this.drawRotCenterSelect(g, v);
        } else if (!this.hasRayon()) {
            super.drawSelect(g, v);
        } else {
            this.drawSelect1(g, v);
        }
    }

    protected void drawSelect1(Graphics g, ViewSimple v) {
        Rectangle r = this.getClipRayon(v);
        int xc = 0;
        int yc = 0;
        Color c = g.getColor();
        for (int i = 0; i < 4; ++i) {
            switch (i) {
                case 0: {
                    xc = r.x + r.width / 2 - 4;
                    yc = r.y;
                    break;
                }
                case 1: {
                    xc = r.x + r.width / 2 - 4;
                    yc = r.y + r.height - 4;
                    break;
                }
                case 2: {
                    xc = r.x + r.width - 4;
                    yc = r.y + r.height / 2 - 4;
                    break;
                }
                case 3: {
                    xc = r.x;
                    yc = r.y + r.height / 2 - 4;
                }
            }
            g.setColor(c);
            g.fillRect(xc + 1, yc + 1, 4, 4);
            g.setColor(Color.black);
            g.drawRect(xc, yc, 4, 4);
        }
        g.setColor(c);
    }

    protected void drawRotCenterSelect(Graphics g, ViewSimple v) {
        Point p = this.getViewCoord(v, this.L, this.L);
        g.setColor(Color.green);
        Util.fillCircle5(g, p.x, p.y);
        g.setColor(Color.black);
        Util.drawCircle5(g, p.x, p.y);
    }

    @Override
    protected void remove() {
        this.cutOff();
    }

    protected void cutOff() {
        this.plan.aladin.calque.zoom.zoomView.stopHist();
        this.plan.aladin.calque.zoom.zoomView.cutOff(this);
    }

    @Override
    protected boolean cutOn() {
        ViewSimple v = this.plan.aladin.view.getCurrentView();
        if (v == null || this.plan.aladin.toolBox.getTool() == 8) {
            return false;
        }
        Plan pc = v.pref;
        if (!pc.isCube()) {
            return false;
        }
        double x = this.xv[v.n];
        double y = this.yv[v.n];
        int n = pc.getDepth();
        int[] res = new int[n];
        try {
            for (int z = 0; z < n; ++z) {
                res[z] = pc.getPixel8bit(z, x, y) & 0xFF;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.plan.aladin.calque.zoom.zoomView.setCut(this, res, 0);
        return true;
    }
}

