/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.AppMessagingInterface;
import cds.aladin.Plan;
import cds.tools.Util;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public final class PlasticWidget
extends JComponent
implements MouseMotionListener,
MouseListener,
KeyListener,
ActionListener {
    static String DISCONNECTED;
    static String CONNECTED_ALONE;
    static String CAN_TRANSMIT;
    static String TRANSMITTING;
    static final Color WAVE_OFF_COLOR;
    static final Color WAVE_ON_COLOR;
    static final int[] TOWER_LINES;
    static final int[] WAVE_LINES;
    static final int W = 23;
    static final int H = 23;
    JPopupMenu popup;
    static String REGISTER;
    static String UNREGISTER;
    static String BROADCAST;
    static String PREFS;
    static String STARTINTERNALHUB;
    static String STOPINTERNALHUB;
    private boolean isConnected = false;
    private boolean isIn = false;
    private JMenuItem registerItem;
    private JMenuItem unregisterItem;
    private JMenuItem broadcastItem;
    private JMenuItem startInternalHubItem;
    private JMenuItem stopInternalHubItem;
    private Aladin aladin;
    private int nbWavesToShow = 0;
    private static int[] waveColBoundaries;
    private static Point waveStartPoint;
    private static int[][] RH;
    private static int[][] RV;
    private static int[][] RB;
    private int state;
    private Thread animationThread;
    private static long sleepTime;

    protected PlasticWidget(Aladin aladin) {
        this.aladin = aladin;
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.addKeyListener(this);
        this.createChaine();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(23, 23);
    }

    private void createChaine() {
        String name = this.aladin.getMessagingMgr().getProtocolName();
        DISCONNECTED = Aladin.chaine.getString("PWDISCONNECTED").replaceAll("SAMP", name);
        CONNECTED_ALONE = Aladin.chaine.getString("PWCONNECTED").replaceAll("SAMP", name);
        CAN_TRANSMIT = Aladin.chaine.getString("PWCANTRANSMIT").replaceAll("SAMP", name);
        TRANSMITTING = Aladin.chaine.getString("PWTRANSMITTING").replaceAll("SAMP", name);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.popup == null) {
            this.createPopup();
        }
        this.updatePopupStatus();
        this.popup.show(this, e.getX(), e.getY());
    }

    @Override
    public void mouseExited(MouseEvent e) {
        Aladin.makeCursor(this, 0);
        this.isIn = false;
        this.repaint();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        Aladin.makeCursor(this, 2);
        this.requestFocus();
        Util.toolTip(this, this.getDescription());
        this.aladin.getMessagingMgr().updateState();
        this.isIn = true;
        this.repaint();
    }

    private String getDescription() {
        switch (this.state) {
            case 0: {
                return DISCONNECTED;
            }
            case 1: {
                return DISCONNECTED;
            }
            case 2: {
                return CONNECTED_ALONE;
            }
            case 3: {
                if (this.animationThread != null && this.animationThread.isAlive()) {
                    return TRANSMITTING;
                }
                return CAN_TRANSMIT;
            }
        }
        return "";
    }

    private void createPopup() {
        this.popup = new JPopupMenu();
        String name = this.aladin.getMessagingMgr().getProtocolName();
        REGISTER = Aladin.chaine.getString("PWREGISTER").replaceAll("SAMP", name);
        UNREGISTER = Aladin.chaine.getString("PWUNREGISTER").replaceAll("SAMP", name);
        BROADCAST = Aladin.chaine.getString("PWBROADCAST");
        PREFS = Aladin.chaine.getString("PWPREFS").replaceAll("SAMP", name);
        if (Aladin.BETA) {
            STARTINTERNALHUB = Aladin.chaine.getString("PWSTARTINTERNALHUB");
            STOPINTERNALHUB = Aladin.chaine.getString("PWSTOPINTERNALHUB");
        }
        this.registerItem = new JMenuItem(REGISTER);
        this.popup.add(this.registerItem);
        this.registerItem.addActionListener(this);
        this.unregisterItem = new JMenuItem(UNREGISTER);
        this.popup.add(this.unregisterItem);
        this.unregisterItem.addActionListener(this);
        this.popup.addSeparator();
        if (Aladin.BETA) {
            this.startInternalHubItem = new JMenuItem(STARTINTERNALHUB);
            this.popup.add(this.startInternalHubItem);
            this.startInternalHubItem.addActionListener(this);
            this.stopInternalHubItem = new JMenuItem(STOPINTERNALHUB);
            this.popup.add(this.stopInternalHubItem);
            this.stopInternalHubItem.addActionListener(this);
            this.popup.addSeparator();
        }
        this.broadcastItem = new JMenuItem(BROADCAST);
        this.popup.add(this.broadcastItem);
        this.broadcastItem.addActionListener(this);
        this.popup.addSeparator();
        JMenuItem prefItem = new JMenuItem(PREFS);
        this.popup.add(prefItem);
        prefItem.addActionListener(this);
        this.updatePopupStatus();
        super.add(this.popup);
    }

    protected void showPrefs() {
        this.aladin.plasticPrefs.showPrefs();
        this.aladin.plasticPrefs.toFront();
    }

    @Override
    public void paintComponent(Graphics gr) {
        super.paintComponent(gr);
        this.drawWidget(gr);
    }

    private Color getWaveColor(int i) {
        return this.mustBeHighilighted(i) ? WAVE_ON_COLOR : WAVE_OFF_COLOR;
    }

    private boolean mustBeHighilighted(int i) {
        return waveColBoundaries[this.nbWavesToShow] > i;
    }

    private void drawWidget(Graphics gr) {
        int i;
        gr.setColor(this.getBackground());
        gr.fillRect(0, 0, 23, 23);
        gr.setColor(this.isConnected || this.isIn || this.state == 1 ? Color.black : Color.gray);
        for (i = 0; i < RH.length; ++i) {
            gr.drawLine(RH[i][1] - 2, RH[i][0] + 2, RH[i][2] - 2, RH[i][0] + 2);
        }
        for (i = 0; i < RV.length; ++i) {
            gr.drawLine(RV[i][0] - 2, RV[i][1] + 2, RV[i][0] - 2, RV[i][2] + 2);
        }
        gr.setColor(this.isIn ? Aladin.DARKBLUE : Color.white);
        for (i = 0; i < RB.length; ++i) {
            gr.drawLine(RB[i][1] - 2, RB[i][0] + 2, RB[i][2] - 2, RB[i][0] + 2);
        }
        if (!this.isConnected) {
            Color c = this.isIn ? Color.red.darker() : Color.red.darker().darker();
            gr.setColor(c);
            gr.drawLine(16, 15, 22, 21);
            gr.drawLine(16, 21, 22, 15);
            c = this.isIn ? Color.red : Color.red.darker();
            gr.setColor(c);
            gr.drawLine(14, 15, 20, 21);
            gr.drawLine(15, 15, 21, 21);
            gr.drawLine(14, 21, 20, 15);
            gr.drawLine(15, 21, 21, 15);
        } else if (this.state != 2) {
            for (i = 0; i < WAVE_LINES.length; ++i) {
                gr.setColor(this.getWaveColor(i));
                this.drawWaveLine(i, WAVE_LINES[i], gr);
                if (!this.mustBeHighilighted(i)) continue;
                this.drawWaveLine(i - 1, WAVE_LINES[i], gr);
            }
        }
    }

    private void drawWaveLine(int col, int codedLine, Graphics gr) {
        int end = 0;
        int start = 0;
        int k = 0;
        for (int j = 12; j >= 0; --j) {
            if ((1 << j & codedLine) != 0) {
                ++end;
            } else if (start != end) {
                gr.drawLine(col + PlasticWidget.waveStartPoint.x, start + PlasticWidget.waveStartPoint.y, col + PlasticWidget.waveStartPoint.x, end - 1 + PlasticWidget.waveStartPoint.y);
                start = end = k + 1;
            } else {
                ++start;
                ++end;
            }
            ++k;
        }
        if (start != end) {
            gr.drawLine(col + PlasticWidget.waveStartPoint.x, start + PlasticWidget.waveStartPoint.y, col + PlasticWidget.waveStartPoint.x, end - 1 + PlasticWidget.waveStartPoint.y);
        }
    }

    protected void updateStatus(boolean b) {
        if (this.isConnected != b) {
            this.isConnected = b;
            this.updatePopupStatus();
            this.repaint();
        }
    }

    protected void updateStatus(int state) {
        if (this.state != state) {
            this.state = state;
            this.updatePopupStatus();
            this.repaint();
        }
    }

    private void updatePopupStatus() {
        if (this.popup == null) {
            return;
        }
        AppMessagingInterface mgr = this.aladin.getMessagingMgr();
        int nbCatalog = 0;
        int nbImg = 0;
        Plan[] plan = this.aladin.calque.getPlans();
        for (int i = 0; i < plan.length; ++i) {
            Plan pc = plan[i];
            if (!pc.selected) continue;
            if (pc.isSimpleCatalog() && pc.flagOk) {
                ++nbCatalog;
            }
            if (pc.type == 1 && pc.flagOk) {
                ++nbImg;
            }
            if (pc.type != 15 || !pc.flagOk) continue;
            ++nbImg;
        }
        ArrayList<String> imgApps = mgr.getAppsSupporting(AppMessagingInterface.ABSTRACT_MSG_LOAD_FITS);
        ArrayList<String> tabApps = mgr.getAppsSupporting(AppMessagingInterface.ABSTRACT_MSG_LOAD_VOT_FROM_URL);
        this.registerItem.setEnabled(!this.isConnected);
        this.unregisterItem.setEnabled(this.isConnected);
        this.broadcastItem.setEnabled(!(!this.isConnected || nbCatalog <= 0 && nbImg <= 0 || imgApps.size() <= 0 && tabApps.size() <= 0));
        if (Aladin.BETA) {
            boolean plaskitRunning = this.aladin.getMessagingMgr().internalHubRunning();
            this.startInternalHubItem.setEnabled(!plaskitRunning);
            this.stopInternalHubItem.setEnabled(plaskitRunning);
        }
    }

    protected void animateWidgetSend() {
        this.animationThread = new Thread("AladinPlasticWidget"){

            @Override
            public void run() {
                int nbWaves = waveColBoundaries.length;
                for (int i = 0; i < 2; ++i) {
                    for (int j = 1; j < nbWaves && this == PlasticWidget.this.animationThread; ++j) {
                        PlasticWidget.this.nbWavesToShow = j;
                        PlasticWidget.this.repaint();
                        try {
                            Thread.currentThread();
                            Thread.sleep(sleepTime);
                            continue;
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    }
                }
                PlasticWidget.this.nbWavesToShow = 0;
                PlasticWidget.this.repaint();
            }
        };
        this.animationThread.start();
    }

    protected void animateWidgetReceive(final boolean updateStatus, final boolean newStatus) {
        this.animationThread = new Thread("AladinPlasticWidget"){

            @Override
            public void run() {
                for (int i = 0; i < 4 && this == PlasticWidget.this.animationThread; ++i) {
                    PlasticWidget.this.nbWavesToShow = i % 2 == 0 ? waveColBoundaries.length - 1 : 0;
                    PlasticWidget.this.repaint();
                    try {
                        Thread.currentThread();
                        Thread.sleep(sleepTime);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (updateStatus) {
                    PlasticWidget.this.updateStatus(newStatus);
                }
            }
        };
        this.animationThread.start();
    }

    protected void animateWidgetReceive() {
        this.animateWidgetReceive(false, true);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyChar() == 'd') {
            boolean pTrace = !this.aladin.appMessagingMgr.getPlasticTrace();
            this.aladin.appMessagingMgr.setPlasticTrace(pTrace);
            String protocolName = this.aladin.appMessagingMgr.getProtocolName();
            this.aladin.command.println(pTrace ? "Activating " + protocolName + " trace" : "Desactivating " + protocolName + " trace");
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (!(ae.getSource() instanceof JMenuItem)) {
            return;
        }
        String o = ((JMenuItem)ae.getSource()).getText();
        if (REGISTER.equals(o)) {
            this.aladin.getMessagingMgr().register(false, true);
        } else if (UNREGISTER.equals(o)) {
            if (this.aladin.getMessagingMgr().unregister()) {
                this.aladin.dontReconnectAutomatically = true;
            }
        } else if (BROADCAST.equals(o)) {
            this.aladin.broadcastSelectedPlanes(null);
        } else if (PREFS.equals(o)) {
            this.showPrefs();
        } else if (STARTINTERNALHUB.equals(o)) {
            this.aladin.getMessagingMgr().startInternalHub();
        } else if (STOPINTERNALHUB.equals(o)) {
            this.aladin.getMessagingMgr().stopInternalHub(false);
        }
    }

    static {
        WAVE_OFF_COLOR = new Color(111, 12, 187);
        WAVE_ON_COLOR = Color.red;
        TOWER_LINES = new int[]{64, 224, 64, 224, 64, 224, 160, 224, 496, 160, 496, 496, 336, 1016, 1016, 680, 1820, 1300, 2044, 1820, 3598, 3598, 7175};
        WAVE_LINES = new int[]{160, 64, 272, 224, 520, 272, 224, 1028, 792, 224, 6147, 1548, 496};
        waveColBoundaries = new int[]{0, 2, 4, 7, 10, 13};
        waveStartPoint = new Point(10, 3);
        RH = new int[][]{{0, 3, 4}, {3, 12, 12}, {4, 8, 11}, {5, 9, 11}, {6, 10, 11}, {12, 13, 15}, {17, 2, 3}, {17, 8, 12}, {18, 0, 14}, {19, 0, 14}};
        RV = new int[][]{{3, 1, 4}, {4, 3, 8}, {4, 12, 17}, {5, 1, 1}, {5, 4, 17}, {6, 2, 2}, {6, 5, 17}, {7, 3, 3}, {7, 6, 11}, {7, 15, 17}, {8, 7, 11}, {8, 16, 16}, {9, 8, 11}, {10, 9, 12}, {11, 10, 12}, {11, 7, 7}, {12, 8, 8}, {12, 11, 12}, {13, 9, 9}, {14, 10, 10}, {15, 11, 11}};
        RB = new int[][]{{1, 4, 4}, {2, 4, 5}, {3, 5, 6}, {4, 6, 7}, {5, 7, 8}, {6, 8, 9}, {7, 9, 10}, {8, 10, 11}, {9, 11, 12}, {10, 12, 13}, {11, 13, 14}};
        sleepTime = 500L;
    }
}

