/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.AppMessagingInterface;
import cds.aladin.Coord;
import cds.aladin.FrameServer;
import cds.aladin.Obj;
import cds.aladin.Plan;
import cds.aladin.PlanCatalog;
import cds.aladin.PlanImage;
import cds.aladin.PlasticWidget;
import cds.aladin.SAMPUtil;
import cds.aladin.Save;
import cds.aladin.Source;
import cds.aladin.VOResource;
import cds.tools.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.rmi.ConnectException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.ladypleaser.rmilite.Client;
import org.votech.plastic.PlasticHubListener;
import org.votech.plastic.PlasticListener;
import uk.ac.starlink.plastic.MinimalHub;
import uk.ac.starlink.plastic.ServerSet;

public class PlasticManager
implements PlasticListener,
AppMessagingInterface {
    protected static final URI MSG_ECHO = URI.create("ivo://votech.org/test/echo");
    protected static final URI MSG_APP_REGISTERED = URI.create("ivo://votech.org/hub/event/ApplicationRegistered");
    protected static final URI MSG_APP_UNREGISTERED = URI.create("ivo://votech.org/hub/event/ApplicationUnregistered");
    protected static final URI MSG_GETNAME = URI.create("ivo://votech.org/info/getName");
    protected static final URI MSG_GETIVORN = URI.create("ivo://votech.org/info/getIVORN");
    protected static final URI MSG_GETVERSION = URI.create("ivo://votech.org/info/getVersion");
    protected static final URI MSG_HUBSTOPPING = URI.create("ivo://votech.org/hub/event/HubStopping");
    protected static final URI MSG_EXCEPTION = URI.create("ivo://votech.org/hub/Exception");
    protected static final URI MSG_LOAD_VOT = URI.create("ivo://votech.org/votable/load");
    protected static final URI MSG_LOAD_VOT_FROM_URL = URI.create("ivo://votech.org/votable/loadFromURL");
    protected static final URI MSG_SELECT_OBJECTS = URI.create("ivo://votech.org/votable/showObjects");
    protected static final URI MSG_HIGHLIGHT_OBJECT = URI.create("ivo://votech.org/votable/highlightObject");
    protected static final URI MSG_GET_ICON_URL = URI.create("ivo://votech.org/info/getIconURL");
    protected static final URI MSG_LOAD_FITS = URI.create("ivo://votech.org/fits/image/loadFromURL");
    protected static final URI MSG_POINT_AT_COORDS = URI.create("ivo://votech.org/sky/pointAtCoords");
    protected static final URI MSG_GET_DESC = URI.create("ivo://votech.org/info/getDescription");
    protected static final URI MSG_LOAD_FITS_LINE_FROM_URL = URI.create("ivo://votech.org/fits/line/loadFromURL");
    protected static final URI MSG_LOAD_SPECTRUM_FROM_URL = URI.create("ivo://votech.org/spectrum/loadFromURL");
    protected static final URI MSG_SEND_ALADIN_SCRIPT_CMD = URI.create("ivo://votech.org/aladin/sendScript");
    protected static final URI MSG_LOAD_VORESOURCE = URI.create("ivo://votech.org/voresource/load");
    protected static final URI MSG_LOAD_VORESOURCE_LIST = URI.create("ivo://votech.org/voresource/loadList");
    protected static final URI MSG_LOAD_CHARAC_FROM_URL = URI.create("ivo://votech.org/charac/loadFromURL");
    protected static final URI[] SUPPORTED_MESSAGES = new URI[]{MSG_ECHO, MSG_GETNAME, MSG_GETIVORN, MSG_GETVERSION, MSG_HUBSTOPPING, MSG_EXCEPTION, MSG_LOAD_VOT, MSG_LOAD_VOT_FROM_URL, MSG_SELECT_OBJECTS, MSG_GET_ICON_URL, MSG_LOAD_FITS, MSG_APP_REGISTERED, MSG_APP_UNREGISTERED, MSG_POINT_AT_COORDS, MSG_GET_DESC, MSG_HIGHLIGHT_OBJECT, MSG_SEND_ALADIN_SCRIPT_CMD, MSG_LOAD_VORESOURCE, MSG_LOAD_VORESOURCE_LIST};
    protected static final String SUPPORTED_VERSION = "0.4";
    protected static final String ALADIN_NAME = "Aladin";
    protected static final String ALADIN_IVORN = "ivo://CDS/Aladin";
    protected static final String PLASTIC_CONF_FILE = ".plastic";
    private int curState = 0;
    protected static final String ALADIN_DESC = "ALADIN is an interactive software sky atlas developed by the CDS, allowing one to visualize digitized imagesof any part of the sky, to superimpose entries from astronomical catalogs,and to interactively access related data and information.";
    static String LAUNCH_INTERNAL_HUB;
    static String CANT_CONNECT;
    static String CANT_LAUNCH_HUB;
    static String HUB_STOP;
    static String EXCEPTION;
    static String CONFIRM_STOP_HUB;
    private Aladin a;
    protected static boolean callToPlastic;
    private PlasticHubListener plasticHubListener;
    private boolean isRegistered = false;
    private URI aladinID;
    private PlasticWidget widget;
    private static MinimalHub internalHub;
    private Hashtable appNamesToURI;
    private Vector appNames;
    private static final Object VOID;
    private static final Object TRUE;
    private static final Object FALSE;
    Integer oidx;
    String oid;
    ResourceChooser resourceChooser;
    private Plan lastPlaneWithSelectedSrc;
    private boolean plasticTrace = false;

    protected PlasticManager(Aladin a) {
        this.a = a;
        callToPlastic = true;
        this.createChaine();
    }

    private void createChaine() {
        String name = this.getProtocolName();
        LAUNCH_INTERNAL_HUB = Aladin.chaine.getString("PMLAUNCHHUB").replaceAll("SAMP", name);
        CANT_CONNECT = Aladin.chaine.getString("PMCANTCONNECT").replaceAll("SAMP", name);
        CANT_LAUNCH_HUB = Aladin.chaine.getString("PMCANTLAUNCHHUB").replaceAll("SAMP", name);
        HUB_STOP = Aladin.chaine.getString("PMHUBWILLSTOP").replaceAll("SAMP", name);
        EXCEPTION = Aladin.chaine.getString("PMEXCEPTION").replaceAll("SAMP", name);
        CONFIRM_STOP_HUB = Aladin.chaine.getString("PMCONFIRMSTOPHUB").replaceAll("SAMP", name);
    }

    @Override
    public boolean register(boolean silent, boolean launchHubIfNeeded) {
        this.trace("Try to register Aladin with the plastic hub");
        if (this.isRegistered()) {
            this.trace("Aladin was already registered !");
            return true;
        }
        if (!this.getHubListener(silent, launchHubIfNeeded)) {
            this.trace("Could not register to the Plastic hub");
            return false;
        }
        boolean pbOccured = false;
        try {
            this.aladinID = this.plasticHubListener.registerRMI(ALADIN_NAME, Arrays.asList(SUPPORTED_MESSAGES), this);
        }
        catch (Exception e) {
            pbOccured = true;
        }
        if (pbOccured) {
            this.isRegistered = false;
        } else {
            this.isRegistered = true;
            Aladin.trace(3, "Successful registration with the plastic hub with application ID " + this.aladinID);
        }
        if (this.widget != null) {
            this.widget.updateStatus(this.isRegistered());
        }
        this.updateState();
        return true;
    }

    private boolean isSupporting(URI message) {
        for (int i = 0; i < SUPPORTED_MESSAGES.length; ++i) {
            if (!SUPPORTED_MESSAGES[i].equals(message)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean unregister() {
        return this.unregister(false);
    }

    @Override
    public boolean unregister(boolean force) {
        return this.unregister(force, true);
    }

    @Override
    public boolean unregister(boolean force, boolean destroyInternalHub) {
        block6: {
            this.trace("Try to unregister Aladin from the plastic hub");
            if (!this.isRegistered()) {
                this.trace("Aladin is not registered with the hub, no need to unregister !");
                return true;
            }
            if (!this.getHubListener(false)) {
                this.trace("Could not unregister from the Plastic hub");
                return false;
            }
            try {
                this.plasticHubListener.unregister(this.aladinID);
            }
            catch (Exception e) {
                this.trace("Error while trying to unregister : " + e.getMessage());
                if (force) break block6;
                return false;
            }
        }
        this.isRegistered = false;
        this.plasticHubListener = null;
        this.aladinID = null;
        if (destroyInternalHub) {
            this.stopInternalHub(force);
        }
        if (this.widget != null) {
            this.widget.animateWidgetReceive(true, false);
        }
        this.updateState();
        Aladin.trace(3, "Successful unregistration from the plastic hub");
        return true;
    }

    @Override
    public boolean isRegistered() {
        return this.isRegistered;
    }

    @Override
    public synchronized boolean startInternalHub() {
        Aladin.trace(1, "Starting an internal PlasKit hub");
        try {
            ServerSet servers = new ServerSet(new File(System.getProperty("user.home"), PLASTIC_CONF_FILE));
            internalHub = new MinimalHub(servers);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        this.updateState();
        return true;
    }

    @Override
    public synchronized void stopInternalHub(boolean dontAsk) {
        if (internalHub == null) {
            return;
        }
        List registeredApps = internalHub.getRegisteredIds();
        if (!(dontAsk || registeredApps.size() == 0 || registeredApps.size() == 1 && registeredApps.get(0).equals(internalHub.getHubId()) || Aladin.confirmation(this.widget, CONFIRM_STOP_HUB))) {
            return;
        }
        Aladin.trace(1, "Stopping internal PlasKit hub");
        internalHub.stop();
        internalHub = null;
        this.updateState();
    }

    private boolean getHubListener(boolean silent) {
        return this.getHubListener(silent, false);
    }

    private boolean getHubListener(boolean silent, boolean launchHubIfNeeded) {
        int rmiPort;
        if (this.plasticHubListener != null) {
            return true;
        }
        this.trace("Looking for an existing .plastic file");
        File confFile = PlasticManager.getLockFile();
        if (!confFile.exists()) {
            this.trace("Can't find .plastic file, can't registrate with a PLASTIC hub");
            if (launchHubIfNeeded) {
                boolean startHub = false;
                if (!silent) {
                    startHub = Aladin.confirmation(this.a, LAUNCH_INTERNAL_HUB);
                    if (!startHub) {
                        return false;
                    }
                } else {
                    startHub = true;
                }
                if (startHub) {
                    if (!this.startInternalHub() && !silent) {
                        Aladin.warning(CANT_LAUNCH_HUB);
                    } else {
                        Util.pause(1000);
                        return this.getHubListener(true);
                    }
                }
            }
            return false;
        }
        this.trace("Reading the .plastic conf file to retrieve the RMI port number");
        Properties prop = new Properties();
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(confFile);
            prop.load(fin);
            fin.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            if (fin != null) {
                try {
                    fin.close();
                }
                catch (IOException ioe2) {
                    // empty catch block
                }
            }
            return false;
        }
        String rmiPortStr = prop.getProperty("plastic.rmi.port");
        if (rmiPortStr == null) {
            this.trace("Can not find property 'plastic.rmi.port' !");
            if (!silent) {
                Aladin.warning(CANT_CONNECT);
            }
            return false;
        }
        try {
            rmiPort = Integer.valueOf(rmiPortStr);
        }
        catch (NumberFormatException nfe) {
            this.trace("Can not convert the property 'plastic.rmi.port' to integer !");
            if (!silent) {
                Aladin.warning(CANT_CONNECT);
            }
            return false;
        }
        try {
            Client client = new Client("localhost", rmiPort);
            client.exportInterface(PlasticListener.class);
            this.trace("Get the PlasticHubListener object through RMI");
            this.plasticHubListener = (PlasticHubListener)client.lookup(PlasticHubListener.class);
        }
        catch (ConnectException ce) {
            Aladin.trace(3, "Unable to connect to the hub, deleting the .plastic file");
            try {
                if (confFile.delete()) {
                    this.updateState();
                    return this.getHubListener(silent, launchHubIfNeeded);
                }
                if (!silent) {
                    Aladin.warning(CANT_CONNECT);
                }
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.trace("Unable to create the PlasticHubListener object");
            if (!silent) {
                Aladin.warning(CANT_CONNECT);
            }
            return false;
        }
        return true;
    }

    @Override
    public Object getAppWithName(String s) {
        return this.appNamesToURI.get(s);
    }

    private String getNameForApp(URI uri) {
        this.getAppsSupporting(MSG_GETNAME);
        Enumeration e = this.appNamesToURI.keys();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            if (!uri.equals(this.appNamesToURI.get(o))) continue;
            return (String)o;
        }
        return "Unknown";
    }

    @Override
    public void sendMessageLoadImage(String url, String name, List recipients) {
        ArrayList<String> argList = new ArrayList<String>();
        argList.add(url);
        argList.add(url);
        argList.add(name);
        this.sendAsyncMessage(MSG_LOAD_FITS, argList, recipients);
    }

    @Override
    public void sendMessageLoadSpectrum(String url, String spectrumId, String spectrumName, Map metadata, List recipients) {
        ArrayList<Object> argList = new ArrayList<Object>();
        argList.add(url);
        argList.add(spectrumId);
        argList.add(metadata);
        this.sendAsyncMessage(MSG_LOAD_SPECTRUM_FROM_URL, argList, recipients == null ? null : recipients);
    }

    @Override
    public void sendMessageLoadCharac(String url, String name, List recipients) {
        ArrayList<String> argList = new ArrayList<String>();
        argList.add(url);
        argList.add(name);
        this.sendAsyncMessage(MSG_LOAD_CHARAC_FROM_URL, argList, recipients);
    }

    private URI getMessage(AppMessagingInterface.AbstractMessage abstractMsg) {
        if (abstractMsg.equals(ABSTRACT_MSG_LOAD_FITS)) {
            return MSG_LOAD_FITS;
        }
        if (abstractMsg.equals(ABSTRACT_MSG_LOAD_VOT_FROM_URL)) {
            return MSG_LOAD_VOT_FROM_URL;
        }
        if (abstractMsg.equals(ABSTRACT_MSG_LOAD_SPECTRUM_FROM_URL)) {
            return MSG_LOAD_SPECTRUM_FROM_URL;
        }
        if (abstractMsg.equals(ABSTRACT_MSG_LOAD_CHARAC_FROM_URL)) {
            return MSG_LOAD_CHARAC_FROM_URL;
        }
        return null;
    }

    @Override
    public ArrayList<String> getAppsSupportingTables() {
        return this.getAppsSupporting(ABSTRACT_MSG_LOAD_VOT_FROM_URL);
    }

    @Override
    public synchronized ArrayList<String> getAppsSupporting(AppMessagingInterface.AbstractMessage abstractMsg) {
        URI implMsg = this.getMessage(abstractMsg);
        return this.getAppsSupporting(implMsg);
    }

    private synchronized ArrayList<String> getAppsSupporting(URI message) {
        if (message == null) {
            return null;
        }
        if (!this.isRegistered() || message == null) {
            return null;
        }
        Object[] listApps = this.plasticHubListener.getMessageRegisteredIds(message).toArray();
        ArrayList<String> apps = new ArrayList<String>();
        int nbApps = this.isSupporting(message) && listApps.length > 0 ? listApps.length - 1 : listApps.length;
        if (nbApps == 0) {
            return new ArrayList<String>();
        }
        if (this.appNamesToURI == null) {
            this.appNamesToURI = new Hashtable();
        }
        if (this.appNames == null) {
            this.appNames = new Vector();
        }
        boolean j = false;
        for (int i = 0; i < listApps.length; ++i) {
            URI uri = (URI)listApps[i];
            if (uri.equals(this.aladinID)) continue;
            String name = null;
            Enumeration e = this.appNamesToURI.keys();
            while (name == null && e.hasMoreElements()) {
                String tmp = (String)e.nextElement();
                if (!this.appNamesToURI.get(tmp).equals(uri)) continue;
                name = tmp;
            }
            if (name == null) {
                name = this.plasticHubListener.getName(uri);
                int k = 1;
                String nameRoot = new String(name);
                while (this.appNames.contains(name)) {
                    name = nameRoot + "-" + k++;
                }
                this.appNames.addElement(name);
                this.appNamesToURI.put(name, uri);
            }
            apps.add(name);
        }
        Collections.sort(apps);
        return apps;
    }

    protected static File getLockFile() {
        File homeDir = new File(System.getProperty("user.home"));
        return new File(homeDir, PLASTIC_CONF_FILE);
    }

    private Object processMessage(URI sender, URI message, List argsList) {
        this.trace("Plastic message : sender is : " + sender);
        this.trace("Plastic message : message is : " + message);
        Object[] args = argsList.toArray();
        for (int i = 0; i < args.length; ++i) {
            this.trace("argument " + i + " is: " + args[i]);
        }
        int nbArgs = args.length;
        if (!this.supportMessage(message)) {
            this.trace("Aladin is not supporting message " + message);
            return VOID;
        }
        if (!this.mustProcessMessage(sender, message)) {
            this.trace("According to plastic preferences, the message " + message + " coming from app " + sender + " should not be processed");
            return VOID;
        }
        if (message.equals(MSG_ECHO)) {
            return args[0];
        }
        if (message.equals(MSG_GETNAME)) {
            return ALADIN_NAME;
        }
        if (message.equals(MSG_GETIVORN)) {
            return ALADIN_IVORN;
        }
        if (message.equals(MSG_GET_ICON_URL)) {
            return "http://aladin.u-strasbg.fr/aladin_large.gif";
        }
        if (message.equals(MSG_GET_DESC)) {
            return ALADIN_DESC;
        }
        if (message.equals(MSG_GETVERSION)) {
            return SUPPORTED_VERSION;
        }
        if (message.equals(MSG_APP_REGISTERED)) {
            this.updateState();
            return VOID;
        }
        if (message.equals(MSG_APP_UNREGISTERED)) {
            this.updateState();
            return VOID;
        }
        if (message.equals(MSG_HUBSTOPPING)) {
            this.unregister(true);
            this.isRegistered = false;
            return VOID;
        }
        if (message.equals(MSG_EXCEPTION)) {
            Aladin.warning(EXCEPTION + ":\nID: " + (nbArgs > 0 ? args[0].toString() : "") + "\nMessage: " + (nbArgs > 1 ? args[1].toString() : ""), 1);
            return VOID;
        }
        if (message.equals(MSG_LOAD_VOT)) {
            if (nbArgs < 1) {
                return FALSE;
            }
            String votable = args[0].toString();
            String id = nbArgs >= 2 ? args[1].toString() : "PLASTIC table";
            int idx = this.loadVOT(votable, id, sender);
            Aladin.trace(3, "Receiving table " + id);
            this.a.log("PLASTIC", "receiving table");
            return idx >= 0 ? TRUE : FALSE;
        }
        if (message.equals(MSG_LOAD_VOT_FROM_URL)) {
            if (nbArgs < 1) {
                return FALSE;
            }
            String url = args[0].toString();
            String id = nbArgs >= 2 ? args[1].toString() : url;
            int idx = this.loadVOTFromURL(url, id, sender);
            Aladin.trace(3, "Receiving table " + url);
            this.a.log("PLASTIC", "receiving table");
            return idx >= 0 ? TRUE : FALSE;
        }
        if (message.equals(MSG_LOAD_FITS)) {
            if (nbArgs < 1) {
                return FALSE;
            }
            String url = args[0].toString();
            String id = nbArgs >= 2 ? args[1].toString() : url;
            int idx = this.loadFitsImageFromURL(url, id, sender);
            Aladin.trace(3, "Receiving image " + url);
            this.a.log("PLASTIC", "receiving image");
            return idx >= 0 ? TRUE : FALSE;
        }
        if (message.equals(MSG_SELECT_OBJECTS)) {
            String[] oidStr = new String[args.length];
            for (int i = 0; i < oidStr.length; ++i) {
                oidStr[i] = args[i].toString();
            }
            this.selectObjects(oidStr, args);
            return VOID;
        }
        if (message.equals(MSG_HIGHLIGHT_OBJECT)) {
            this.highlightObject(args[0].toString(), (Integer)args[1]);
            return TRUE;
        }
        if (message.equals(MSG_POINT_AT_COORDS)) {
            double dec;
            double ra;
            if (nbArgs < 2) {
                return FALSE;
            }
            try {
                ra = (Double)args[0];
                dec = (Double)args[1];
            }
            catch (Exception e) {
                e.printStackTrace();
                return FALSE;
            }
            this.a.execCommand(Coord.getSexa(ra, dec));
            return TRUE;
        }
        if (message.equals(MSG_SEND_ALADIN_SCRIPT_CMD)) {
            if (nbArgs < 1) {
                return FALSE;
            }
            String scriptCmd = args[0].toString();
            this.a.execCommand(scriptCmd);
            return TRUE;
        }
        if (message.equals(MSG_LOAD_VORESOURCE)) {
            if (nbArgs < 1) {
                return FALSE;
            }
            ArrayList<Object> l = new ArrayList<Object>();
            l.add(args[0]);
            return this.loadVOResources(new Object[]{l}, sender) ? TRUE : FALSE;
        }
        if (message.equals(MSG_LOAD_VORESOURCE_LIST)) {
            if (nbArgs < 1) {
                return FALSE;
            }
            return this.loadVOResources(args, sender) ? TRUE : FALSE;
        }
        Aladin.trace(3, "The message " + message + " has not been processed (unknown message) !");
        System.out.println("***" + message + "***" + " not processed");
        return VOID;
    }

    private synchronized void selectObjects(String[] oid, Object[] argArray) {
        this.selectSources(argArray);
    }

    private void selectSources(Object[] args) {
        if (args == null || args[0] == null) {
            this.trace("selectSources : argument is null, can't do anything !");
            return;
        }
        String planeID = args[0].toString();
        Plan p = this.findPlaneByPlasticID(planeID);
        if (p == null) {
            this.trace("Could not find plane with plastic ID " + planeID);
            return;
        }
        if (args[1] == null) {
            this.trace("selectSources : second parameter is null, can't do anything !");
            return;
        }
        if (!(args[1] instanceof List)) {
            this.trace("selectSources : second parameter is not of type List, can't do anything !");
            return;
        }
        Object[] array = ((List)args[1]).toArray();
        int[] idxArray = new int[array.length];
        for (int i = 0; i < array.length; ++i) {
            idxArray[i] = array[i] instanceof Integer ? ((Integer)array[i]).intValue() : ((Long)array[i]).intValue();
        }
        this.a.view.selectSourcesByRowNumber((PlanCatalog)p, idxArray);
    }

    private synchronized void highlightObject(String id, Integer idx) {
        this.oid = id;
        this.oidx = idx;
        Plan p = this.findPlaneByPlasticID(id);
        if (p == null) {
            this.trace("Could not find plane with plastic ID " + id);
            return;
        }
        this.a.view.showSource((Source)p.pcat.getObj(idx));
    }

    private int loadVOTFromURL(String votURL, String id, URI sender) {
        InputStream is;
        URL url;
        try {
            url = new URL(votURL);
        }
        catch (MalformedURLException e) {
            this.trace("The provided URL string is malformed, can not load VOTable file !");
            return -1;
        }
        try {
            is = url.openStream();
        }
        catch (IOException e) {
            this.trace("IOException occured when getting stream from VOTable URL, loading is aborted");
            return -1;
        }
        int idx = this.a.calque.newPlan(is, "PLASTIC", sender.toString());
        if (idx >= 0) {
            this.a.calque.plan[idx].addPlasticID(id);
        }
        return idx;
    }

    @Override
    public String getProtocolName() {
        return "PLASTIC";
    }

    private int loadFitsImageFromURL(String fitsURL, String id, URI sender) {
        try {
            URL url = new URL(fitsURL);
        }
        catch (MalformedURLException e) {
            this.trace("The provided URL string is malformed, can not load FITS file !");
            return -1;
        }
        int idx = this.a.calque.newPlan(fitsURL, "PLASTIC", sender.toString());
        if (idx >= 0) {
            this.a.calque.plan[idx].addPlasticID(id);
        }
        return idx;
    }

    private int loadVOT(String votable, String id, URI sender) {
        int idx = this.a.calque.newPlan(new ByteArrayInputStream(votable.getBytes()), "PLASTIC", sender.toString());
        if (idx >= 0) {
            this.a.calque.plan[idx].addPlasticID(id);
        }
        return idx;
    }

    @Override
    public boolean ping() {
        if (this.plasticHubListener == null) {
            return false;
        }
        try {
            this.plasticHubListener.getHubId();
        }
        catch (Exception e) {
            this.unregister(true);
            this.isRegistered = false;
            return false;
        }
        return true;
    }

    private boolean supportMessage(URI message) {
        return true;
    }

    private boolean mustProcessMessage(URI sender, URI message) {
        return true;
    }

    @Override
    public boolean broadcastTable(final Plan pc, final String[] recipients) {
        File tmpFile;
        Aladin.trace(3, "Broadcasting table " + pc.getLabel() + " to " + (recipients == null ? "everyone" : recipients.length + " applications"));
        if (this.widget != null) {
            this.widget.animateWidgetSend();
        }
        if ((tmpFile = this.a.createTempFile("plastic" + SAMPUtil.sanitizeFilename(pc.getLabel()), ".xml")) == null) {
            this.trace("Couldn't create temporary file, can't broadcast table !");
            return false;
        }
        new Thread("AladinPlasticSendTable"){

            @Override
            public void run() {
                if (((PlasticManager)PlasticManager.this).a.save == null) {
                    ((PlasticManager)PlasticManager.this).a.save = new Save(PlasticManager.this.a);
                }
                ((PlasticManager)PlasticManager.this).a.save.saveCatVOTable(tmpFile, pc, false);
                URL url = SAMPUtil.getURLForFile(tmpFile);
                String urlStr = url.toString();
                String id = pc.getPlasticID();
                if (id == null) {
                    id = urlStr;
                    pc.addPlasticID(id);
                }
                ArrayList<String> paramList = new ArrayList<String>();
                paramList.add(urlStr);
                paramList.add(id);
                PlasticManager.this.trace("Broadcast table with URL: " + urlStr);
                ArrayList<URI> recipientsList = null;
                if (recipients != null) {
                    recipientsList = new ArrayList<URI>();
                    for (int i = 0; i < recipients.length; ++i) {
                        URI uriApp = (URI)PlasticManager.this.appNamesToURI.get(recipients[i]);
                        if (uriApp != null) {
                            recipientsList.add(uriApp);
                            PlasticManager.this.trace("Adding " + uriApp + " to list of recipients");
                            continue;
                        }
                        PlasticManager.this.trace("Couldn't find URI of application " + recipients[i]);
                    }
                }
                PlasticManager.this.sendAsyncMessage(MSG_LOAD_VOT_FROM_URL, paramList, recipientsList);
                PlasticManager.this.a.log("PLASTIC", "broadcast table");
            }
        }.start();
        return true;
    }

    @Override
    public boolean broadcastImage(final Plan pi, final String[] recipients) {
        File tmpFile;
        Aladin.trace(3, "Broadcasting image " + pi.getLabel() + " to " + (recipients == null ? "everyone" : recipients.length + " applications"));
        if (pi == null || !(pi instanceof PlanImage)) {
            return false;
        }
        if (this.widget != null) {
            this.widget.animateWidgetSend();
        }
        if ((tmpFile = this.a.createTempFile("plastic" + SAMPUtil.sanitizeFilename(pi.getLabel()), ".fits")) == null) {
            this.trace("Couldn't create temporary file, can't broadcast image !");
            return false;
        }
        new Thread("AladinPlasticSendImage"){

            @Override
            public void run() {
                if (((PlasticManager)PlasticManager.this).a.save == null) {
                    ((PlasticManager)PlasticManager.this).a.save = new Save(PlasticManager.this.a);
                }
                ((PlasticManager)PlasticManager.this).a.save.saveImageFITS(tmpFile, (PlanImage)pi);
                URL url = SAMPUtil.getURLForFile(tmpFile);
                String urlStr = url.toString();
                String id = pi.getPlasticID();
                if (id == null) {
                    id = urlStr;
                    pi.addPlasticID(id);
                }
                ArrayList<String> paramList = new ArrayList<String>();
                paramList.add(urlStr);
                paramList.add(id);
                ArrayList<URI> recipientsList = null;
                if (recipients != null) {
                    recipientsList = new ArrayList<URI>();
                    for (int i = 0; i < recipients.length; ++i) {
                        URI uriApp = (URI)PlasticManager.this.appNamesToURI.get(recipients[i]);
                        if (uriApp != null) {
                            recipientsList.add(uriApp);
                            PlasticManager.this.trace("Adding " + uriApp + " to list of recipients");
                            continue;
                        }
                        PlasticManager.this.trace("Couldn't find URI of application " + recipients[i]);
                    }
                }
                PlasticManager.this.sendAsyncMessage(MSG_LOAD_FITS, paramList, recipientsList);
                PlasticManager.this.a.log("PLASTIC", "broadcast image");
            }
        }.start();
        return true;
    }

    private boolean loadVOResources(Object[] args, URI sender) {
        if (this.resourceChooser == null) {
            this.resourceChooser = new ResourceChooser();
        }
        if (args[0] == null) {
            this.trace("loadVOResources : first parameter is null, can't do anything !");
            return false;
        }
        if (!(args[0] instanceof List)) {
            this.trace("loadVOResources : first parameter is not of type List, can't do anything !");
        }
        String[] uris = ((List)args[0]).toArray(new String[((List)args[0]).size()]);
        this.resourceChooser.updateFrame(uris, sender);
        return true;
    }

    @Override
    public void sendSelectObjectsMsg() {
        if (!this.a.plasticPrefs.getBooleanValue("PlasticSelect")) {
            return;
        }
        if (!this.isRegistered()) {
            return;
        }
        new Thread("AladinPlasticSendSelect"){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void run() {
                Plan p;
                Source[] sources;
                block10: {
                    sources = ((PlasticManager)PlasticManager.this).a.view.getSelectedSources();
                    if (sources == null) {
                        return;
                    }
                    ArrayList apps = PlasticManager.this.getAppsSupporting(MSG_SELECT_OBJECTS);
                    if (apps == null || apps.size() == 0) {
                        PlasticManager.this.trace("None of the connected applications supports the 'select objects' message");
                        return;
                    }
                    PlasticManager.this.trace("Sending message " + MSG_SELECT_OBJECTS);
                    if (Aladin.levelTrace >= 3) {
                        for (int i = 0; i < sources.length && i < 3; ++i) {
                            Aladin.trace(3, "select object : " + sources[i]);
                        }
                    }
                    if ((p = PlasticManager.this.findPlaneForSources(sources)) == null) {
                        if (sources.length == 0 && PlasticManager.this.lastPlaneWithSelectedSrc != null) {
                            PlasticManager.this.trace("0 object selected, will send a 'deselection' message");
                            p = PlasticManager.this.lastPlaneWithSelectedSrc;
                            PlasticManager.this.lastPlaneWithSelectedSrc = null;
                            break block10;
                        } else {
                            PlasticManager.this.lastPlaneWithSelectedSrc = p;
                            return;
                        }
                    }
                    PlasticManager.this.lastPlaneWithSelectedSrc = p;
                }
                if (p.getPlasticID() == null) {
                    return;
                }
                Vector v = PlasticManager.this.getSequenceNumber(p, sources);
                Integer[] idx = new Integer[v.size()];
                Enumeration e = v.elements();
                int k = 0;
                while (true) {
                    if (!e.hasMoreElements()) {
                        ArrayList<Object> paramList = new ArrayList<Object>();
                        paramList.add(p.getPlasticID());
                        paramList.add(Arrays.asList(idx));
                        PlasticManager.this.sendAsyncMessage(MSG_SELECT_OBJECTS, paramList, null);
                        return;
                    }
                    idx[k] = (Integer)e.nextElement();
                    ++k;
                }
            }
        }.start();
    }

    private Plan findPlaneForSources(Source[] sources) {
        return sources == null || sources.length == 0 ? null : sources[0].plan;
    }

    @Override
    public void pointAtCoords(double ra, double dec) {
    }

    private Plan findPlaneByPlasticID(String plasticID) {
        Plan p = null;
        Plan[] plans = this.a.calque.plan;
        for (int i = 0; i < plans.length; ++i) {
            if (plans[i] == null || !plans[i].isSimpleCatalog() || !plans[i].hasPlasticID(plasticID)) continue;
            p = plans[i];
        }
        return p;
    }

    private Vector getSequenceNumber(Plan p, Source[] sources) {
        Vector<Integer> v = new Vector<Integer>();
        Iterator<Obj> it = p.iterator();
        int i = 0;
        while (it.hasNext()) {
            Obj o = it.next();
            if (o != null) {
                for (int j = 0; j < sources.length; ++j) {
                    Source sTmp = (Source)o;
                    if (!sTmp.equals(sources[j])) continue;
                    v.addElement(new Integer(i));
                    break;
                }
            }
            ++i;
        }
        return v;
    }

    @Override
    public boolean internalHubRunning() {
        return internalHub != null;
    }

    @Override
    public void updateState() {
        new Thread("AladinPlasticUpdate"){

            @Override
            public void run() {
                block9: {
                    try {
                        if (PlasticManager.this.isRegistered()) {
                            if (PlasticManager.this.getAppsConnected().length > 0) {
                                PlasticManager.this.curState = 3;
                            } else {
                                PlasticManager.this.curState = 2;
                            }
                        } else if (PlasticManager.getLockFile().exists()) {
                            PlasticManager.this.curState = 1;
                        } else {
                            PlasticManager.this.curState = 0;
                        }
                    }
                    catch (Exception e) {
                        if (Aladin.levelTrace < 3) break block9;
                        e.printStackTrace();
                    }
                }
                if (PlasticManager.this.widget != null) {
                    PlasticManager.this.widget.updateStatus(PlasticManager.this.curState);
                }
            }
        }.start();
    }

    private String[] getAppsConnected() {
        Vector<String> v = new Vector<String>();
        try {
            Iterator it = this.plasticHubListener.getRegisteredIds().iterator();
            String hubId = this.plasticHubListener.getHubId().toString();
            while (it.hasNext()) {
                String curId = it.next().toString();
                if (curId.equals(this.aladinID.toString()) || curId.equals(hubId)) continue;
                v.addElement(curId);
            }
        }
        catch (Exception e) {
            return new String[0];
        }
        Object[] ids = new String[v.size()];
        v.copyInto(ids);
        v = null;
        return ids;
    }

    @Override
    public void sendHighlightObjectsMsg(Source source) {
        if (!this.a.plasticPrefs.getBooleanValue("PlasticHighlight")) {
            return;
        }
        if (source == null) {
            return;
        }
        if (!this.isRegistered()) {
            return;
        }
        Source[] sources = new Source[]{source};
        Plan p = this.findPlaneForSources(sources);
        if (p == null) {
            this.trace("Could not find plane, can't send PLASTIC message");
            return;
        }
        Vector v = this.getSequenceNumber(p, sources);
        if (v.size() == 0) {
            this.trace("Could not find sequence number for source " + source);
            return;
        }
        Integer idx = (Integer)v.elementAt(0);
        if (this.oidx != null && this.oid != null && this.oid.equals(p.getPlasticID()) && this.oidx.equals(idx)) {
            return;
        }
        this.oidx = idx;
        this.oid = p.getPlasticID();
        ArrayList<Object> paramList = new ArrayList<Object>();
        paramList.add(p.getPlasticID());
        paramList.add(idx);
        this.sendAsyncMessage(MSG_HIGHLIGHT_OBJECT, paramList, null);
    }

    private Object sendMessage(URI sender, URI message, List args, List recipients) {
        if (!this.isRegistered) {
            return null;
        }
        if (recipients == null) {
            return this.plasticHubListener.request(sender, message, args);
        }
        return this.plasticHubListener.requestToSubset(sender, message, args, recipients);
    }

    private Object sendMessage(URI message, List args, List recipients) {
        return this.sendMessage(this.aladinID, message, args, recipients);
    }

    private void sendAsyncMessage(URI sender, URI message, List args, List recipients) {
        if (!this.isRegistered) {
            return;
        }
        if (recipients == null) {
            this.plasticHubListener.requestAsynch(sender, message, args);
        } else {
            this.plasticHubListener.requestToSubsetAsynch(sender, message, args, recipients);
        }
    }

    private void sendAsyncMessage(URI message, List args, List recipients) {
        this.sendAsyncMessage(this.aladinID, message, args, recipients);
    }

    @Override
    public void setPlasticWidget(PlasticWidget widget) {
        this.widget = widget;
    }

    @Override
    public PlasticWidget getPlasticWidget() {
        return this.widget;
    }

    @Override
    public Object perform(URI sender, URI message, List args) {
        if (!Aladin.PLASTIC_SUPPORT) {
            return null;
        }
        if (this.widget != null) {
            this.widget.animateWidgetReceive();
        }
        return this.processMessage(sender, message, args);
    }

    @Override
    public void trace(String s) {
        if (!this.plasticTrace) {
            return;
        }
        System.out.println("** PLASTIC : " + s);
    }

    @Override
    public boolean getPlasticTrace() {
        return this.plasticTrace;
    }

    @Override
    public void setPlasticTrace(boolean plasticTrace) {
        this.plasticTrace = plasticTrace;
    }

    static {
        callToPlastic = false;
        VOID = "";
        TRUE = Boolean.TRUE;
        FALSE = Boolean.FALSE;
    }

    class ResourceChooser
    extends JFrame
    implements ActionListener {
        JList list;
        DefaultListModel model;
        private boolean firstShow;
        String[] uris;
        VOResource[] resources;

        ResourceChooser() {
            super("Choose resources to keep");
            this.firstShow = true;
            Util.setCloseShortcut(this, false);
            this.getContentPane().setLayout(new BorderLayout());
        }

        void updateFrame(final String[] uris, URI sender) {
            this.uris = uris;
            this.getContentPane().removeAll();
            ((JPanel)this.getContentPane()).setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            JPanel pTop = new JPanel();
            JLabel label = new JLabel("<html><b>" + PlasticManager.this.getNameForApp(sender) + "</b> has sent some registry resources.<br>Select resources you want to keep:<br></html>");
            pTop.add(label);
            this.getContentPane().add((Component)pTop, "North");
            JPanel pCenter = new JPanel();
            DefaultListSelectionModel selectionModel = new DefaultListSelectionModel();
            this.list = new JList();
            this.list.setSelectionModel(selectionModel);
            JScrollPane scrollPane = new JScrollPane(this.list);
            this.model = new DefaultListModel();
            for (int i = 0; i < uris.length; ++i) {
                this.model.addElement(uris[i]);
            }
            this.list.setModel(this.model);
            pCenter.add(scrollPane);
            this.list.setPreferredSize(new Dimension(550, 200));
            scrollPane.setPreferredSize(new Dimension(550, 200));
            this.getContentPane().add((Component)pCenter, "Center");
            JPanel pBottom = new JPanel(new FlowLayout());
            JButton okBtn = new JButton("OK");
            okBtn.addActionListener(this);
            okBtn.setFont(Aladin.BOLD);
            pBottom.add(okBtn);
            JButton closeBtn = new JButton("Close");
            closeBtn.addActionListener(this);
            pBottom.add(closeBtn);
            this.getContentPane().add((Component)pBottom, "South");
            this.pack();
            if (this.firstShow) {
                this.firstShow = false;
                this.setSize(new Dimension(600, 300));
                this.setLocation(200, 200);
            }
            this.setVisible(true);
            this.toFront();
            new Thread("PlasticManager:resolveIVORN"){

                @Override
                public void run() {
                    ResourceChooser.this.resolveIVORN(uris);
                }
            }.start();
        }

        private void resolveIVORN(String[] uris) {
            this.list.getSelectionModel().clearSelection();
            this.resources = new VOResource[uris.length];
            for (int i = 0; i < uris.length; ++i) {
                VOResource ivorn;
                this.resources[i] = ivorn = FrameServer.getIvorn(uris[i]);
                if (ivorn == null) continue;
                this.model.setElementAt(uris[i] + " - " + (ivorn == null ? "" : ivorn.desc), i);
                if (ivorn == null || ivorn.type == null || !ivorn.type.equals("siap") && !ivorn.type.equals("ssap") && !ivorn.type.equals("cs")) continue;
                this.list.getSelectionModel().addSelectionInterval(i, i);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }
}

