/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.Couleur;
import cds.aladin.Legende;
import cds.aladin.Obj;
import cds.aladin.Pcat;
import cds.aladin.Plan;
import cds.aladin.PlanCatalog;
import cds.aladin.PlanImage;
import cds.aladin.Projection;
import cds.aladin.Repere;
import cds.aladin.Source;
import cds.aladin.Tok;
import cds.tools.Util;
import cds.tools.VOApp;
import java.util.Enumeration;
import java.util.Iterator;

public class PlanTool
extends PlanCatalog {
    protected Legende legPhot = null;
    protected Legende legTag = null;
    protected Legende legPhotMan = null;
    protected boolean movable = true;

    protected PlanTool(Aladin aladin, String label) {
        this.setLogMode(true);
        this.aladin = aladin;
        this.type = 9;
        this.c = Couleur.getNextDefault(aladin.calque);
        if (label == null) {
            label = "Drawing";
        }
        this.setLabel(label);
        this.pcat = new Pcat(this, this.c, aladin.calque, aladin.status, aladin);
        this.flagOk = true;
        this.askActive = true;
        aladin.calque.selectPlan(this);
        Plan pref = aladin.calque.getPlanRef();
        if (pref == null || !Projection.isOk(pref.projd)) {
            this.projd = new Projection();
            this.hasXYorig = true;
        } else {
            this.hasXYorig = false;
        }
    }

    protected PlanTool(Aladin aladin) {
        this.setLogMode(true);
        this.aladin = aladin;
        this.type = 9;
        this.c = Couleur.getNextDefault(aladin.calque);
        this.pcat = new Pcat(this, this.c, aladin.calque, aladin.status, aladin);
        this.flagOk = true;
        this.askActive = true;
    }

    public void updatePhotMan(Obj o) {
        if (this.legPhotMan == null) {
            this.createPhotManuelLegende();
        }
        String[] val = new String[]{o.id, o.raj + "", o.dej + "", o.getRadius() + "", "", "", "", "", "", "", ""};
        StringBuffer rep = new StringBuffer();
        for (String s : val) {
            if (rep.length() > 0) {
                rep.append('\t');
            }
            rep.append(s);
        }
        o.id = rep.toString();
        if (o instanceof Source) {
            ((Source)o).leg = this.legPhotMan;
        }
        this.pcat.setObjetFast(o);
        this.aladin.view.newView(1);
    }

    private void createPhotManuelLegende() {
        this.setSourceRemovable(true);
        this.legPhotMan = Legende.adjustDefaultLegende(this.legPhotMan, 3, new String[]{"ID", "RA (ICRS)", "DE (ICRS)", "Radius", "Count", "Sum", "Mean", "Sigma", "Area", "Median"});
        this.legPhotMan = Legende.adjustDefaultLegende(this.legPhotMan, 6, new String[]{"char", "char", "char", "double", "integer", "double", "double", "double", "double", "double"});
        this.legPhotMan = Legende.adjustDefaultLegende(this.legPhotMan, 5, new String[]{"char", "\"h:m:s\"", "\"h:m:s\"", "arcmin", "pixel", "", "", "", "arcmin^2", ""});
        this.legPhotMan = Legende.adjustDefaultLegende(this.legPhotMan, 9, new String[]{"15", "13", "13", "10", "10", "10", "10", "10", "10"});
        this.legPhotMan = Legende.adjustDefaultLegende(this.legPhotMan, 11, new String[]{"", "2", "3", "2", "2", "2", "2", "2", "2"});
        this.legPhotMan = Legende.adjustDefaultLegende(this.legPhotMan, 4, new String[]{"Identifier", "Right ascension", "Declination", "Radius", "Pixel count", "Sum of pixel values", "Mean of pixel values", "Sigma of pixel list", "Area", "Median of pixel list"});
        this.legPhotMan = Legende.adjustDefaultLegende(this.legPhotMan, 7, new String[]{"meta.id;meta.main", "pos.eq.ra;meta.main", "pos.eq.dec;meta.main", "", "", "", "", "", "", ""});
    }

    private void createTagLegende() {
        this.setSourceRemovable(true);
        this.legTag = Legende.adjustDefaultLegende(this.legTag, 3, new String[]{"ID", "RA (ICRS)", "DE (ICRS)", "X", "Y"});
        this.legTag = Legende.adjustDefaultLegende(this.legTag, 6, new String[]{"char", "char", "char", "double", "double"});
        this.legTag = Legende.adjustDefaultLegende(this.legTag, 5, new String[]{"char", "\"h:m:s\"", "\"h:m:s\"", "", ""});
        this.legTag = Legende.adjustDefaultLegende(this.legTag, 9, new String[]{"15", "13", "13", "8", "8"});
        this.legTag = Legende.adjustDefaultLegende(this.legTag, 11, new String[]{"", "2", "3", "2", "2"});
        this.legTag = Legende.adjustDefaultLegende(this.legTag, 4, new String[]{"Identifier", "Right ascension", "Declination", "Current image X axis (FITS convention)", "Current image Y axis (Fits Convention)"});
        this.legTag = Legende.adjustDefaultLegende(this.legTag, 7, new String[]{"meta.id;meta.main", "pos.eq.ra;meta.main", "pos.eq.dec;meta.main", "", ""});
    }

    private void createPhotLegende() {
        this.setSourceRemovable(true);
        this.legPhot = Legende.adjustDefaultLegende(this.legPhot, 3, new String[]{"ID", "RA (ICRS)", "DE (ICRS)", "X", "Y", "FWHM_X", "FWHM_Y", "Angle", "Peak", "Background"});
        this.legPhot = Legende.adjustDefaultLegende(this.legPhot, 6, new String[]{"char", "char", "char", "double", "double", "double", "double", "double", "double", "double"});
        this.legPhot = Legende.adjustDefaultLegende(this.legPhot, 5, new String[]{"char", "\"h:m:s\"", "\"h:m:s\"", "", "", "", "", "deg", "", ""});
        this.legPhot = Legende.adjustDefaultLegende(this.legPhot, 9, new String[]{"15", "13", "13", "8", "8", "10", "10", "5", "10", "10"});
        this.legPhot = Legende.adjustDefaultLegende(this.legPhot, 11, new String[]{"", "2", "3", "2", "2", "2", "2", "0", "3", "3"});
        this.legPhot = Legende.adjustDefaultLegende(this.legPhot, 4, new String[]{"Identifier", "Right ascension", "Declination", "X image coordinate", "Y image coordinate", "X Full Width at Half Maximum", "Y Full Width at Half Maximum", "Angle", "Source peak", "image background"});
        this.legPhot = Legende.adjustDefaultLegende(this.legPhot, 7, new String[]{"meta.id;meta.main", "pos.eq.ra;meta.main", "pos.eq.dec;meta.main", "pos.cartesian.x;obs.field", "pos.cartesian.y;obs.field", "", "", "pos.posAng;obs.field", "", "instr.background;obs.field"});
        this.addFilter("#Object elongation\nfilter obj_elong { draw ellipse(${FWHM_X}/2,${FWHM_Y}/2,270-${Angle}) }");
        this.setFilter("obj_elong");
    }

    @Override
    protected boolean Free() {
        if (this.aladin.view.zoomview.flagCut || this.aladin.view.zoomview.flagHist) {
            Iterator<Obj> it = this.iterator();
            while (it.hasNext()) {
                Obj o = it.next();
                if (!o.isSelected()) continue;
                o.remove();
            }
        }
        return super.Free();
    }

    protected boolean withSource() {
        return this.legPhot != null;
    }

    public Source addTag(PlanImage planBase, double ra, double dec) {
        if (this.legTag == null) {
            this.createTagLegende();
        }
        String id = "Tag " + this.pcat.getNextID();
        Coord c = new Coord(ra, dec);
        planBase.projd.getXY(c);
        String[] val = new String[]{id, c.getRA(), c.getDE(), Util.myRound("" + (c.x + 0.5), 4), Util.myRound("" + ((double)planBase.naxis2 - c.y + 0.5))};
        Source o1 = this.addTag(id, ra, dec, val);
        o1.setShape(6);
        o1.setTag(true);
        this.aladin.view.newView(1);
        return o1;
    }

    private Source addTag(String id, double ra, double dec, String[] value) {
        StringBuffer s = new StringBuffer("<&_A>");
        for (int i = 0; i < value.length; ++i) {
            s.append("\t" + value[i]);
        }
        Source o = new Source(this, ra, dec, id, s.toString());
        o.leg = this.legTag;
        this.pcat.setObjetFast(o);
        return o;
    }

    public Source addPhot(PlanImage planBase, double ra, double dec, double[] iqe) {
        if (this.legPhot == null) {
            this.createPhotLegende();
        }
        String id = this.pcat.getNextID() + "/" + planBase.label;
        Coord c = new Coord(ra, dec);
        String[] val = new String[]{id, c.getRA(), c.getDE() + "", iqe[0] + "", iqe[2] + "", iqe[1] + "", iqe[3] + "", iqe[4] + "", iqe[5] + "", iqe[6] + ""};
        Source o1 = this.addSource(id, ra, dec, val);
        o1.setShape(6);
        this.aladin.view.newView(1);
        return o1;
    }

    private Source addSource(String id, double ra, double dec, String[] value) {
        StringBuffer s = new StringBuffer("<&_A>");
        for (int i = 0; i < value.length; ++i) {
            if (value[i].startsWith("http://") || value[i].startsWith("https://")) {
                s.append("\t<&Http " + value[i] + ">");
                continue;
            }
            s.append("\t" + value[i]);
        }
        Source o = new Source(this, ra, dec, id, s.toString());
        o.leg = this.legPhot;
        this.pcat.setObjetFast(o);
        return o;
    }

    @Override
    protected String getInfo() {
        if (this.type == 0) {
            return super.getInfo();
        }
        return this.label + super.addDebugInfo();
    }

    @Override
    protected void setPropertie(String prop, String specif, String value) throws Exception {
        if (prop.equalsIgnoreCase("movable")) {
            this.setMovable(value);
        } else {
            super.setPropertie(prop, specif, value);
        }
    }

    @Override
    protected boolean isMovable() {
        return this.movable;
    }

    protected void setMovable(String v) throws Exception {
        if (v.equalsIgnoreCase("On")) {
            this.movable = true;
        } else if (v.equalsIgnoreCase("Off")) {
            this.movable = false;
        } else {
            throw new Exception("Syntax error => movable=on|off");
        }
    }

    protected void setIdAgain() {
        if (this.pcat == null) {
            return;
        }
        Iterator<Obj> it = this.iterator();
        while (it.hasNext()) {
            Obj o = it.next();
            if (!(o instanceof Repere)) continue;
            ((Repere)o).setId();
        }
    }

    protected void sendMesureObserver(Obj o, boolean cont) {
        if (this.aladin.VOObsMes == null || this.aladin.VOObsMes.size() == 0) {
            return;
        }
        int objIndex = this.pcat.getIndex(o);
        String s = "set " + Tok.quote(this.label + "/" + objIndex) + " measure=" + o.id + (cont ? " ..." : "");
        Aladin.trace(4, "sendMesureObserver(): [" + s + "]");
        Enumeration e = this.aladin.VOObsMes.elements();
        while (e.hasMoreElements()) {
            try {
                ((VOApp)e.nextElement()).execCommand(s);
            }
            catch (Exception e1) {
                if (Aladin.levelTrace < 3) continue;
                e1.printStackTrace();
            }
        }
    }
}

