/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.Couleur;
import cds.aladin.Localisation;
import cds.aladin.MyInputStream;
import cds.aladin.Obj;
import cds.aladin.Plan;
import cds.aladin.PlanBGCat;
import cds.aladin.ViewSimple;
import cds.moc.Healpix;
import cds.moc.HealpixMoc;
import cds.moc.MocCell;
import cds.tools.Util;
import cds.tools.pixtools.CDSHealpix;
import cds.tools.pixtools.Hpix;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Iterator;

public class PlanMoc
extends PlanBGCat {
    public static final int DRAW_BORDER = 1;
    public static final int DRAW_FILLIN = 4;
    protected HealpixMoc moc = null;
    private int wireFrame = 5;
    private Hpix[][] arrayHpix = null;
    static int MAXGAPORDER = 3;
    private int gapOrder = 0;
    private boolean isLoading = false;
    private int lastOrderDrawn = -1;

    public PlanMoc(Aladin a) {
        super(a);
    }

    protected PlanMoc(Aladin aladin, HealpixMoc moc, String label, Coord c, double radius) {
        this(aladin, null, moc, label, c, radius);
    }

    protected PlanMoc(Aladin aladin, MyInputStream in, String label, Coord c, double radius) {
        this(aladin, in, null, label, c, radius);
    }

    protected PlanMoc(Aladin aladin, MyInputStream in, HealpixMoc moc, String label, Coord c, double radius) {
        super(aladin);
        this.arrayHpix = new Hpix[30][];
        this.dis = in;
        this.moc = moc;
        this.useCache = false;
        this.frameOrigin = 0;
        if (moc != null) {
            String f = moc.getCoordSys();
            this.frameOrigin = f.equals("E") ? 2 : (f.equals("G") ? 3 : 0);
        }
        this.type = 19;
        this.c = Couleur.getNextDefault(aladin.calque);
        this.setOpacityLevel(1.0f);
        if (label == null) {
            label = "MOC";
        }
        this.setLabel(label);
        this.co = c;
        this.coRadius = radius;
        Aladin.trace(3, "AllSky creation: " + Plan.Tp[this.type] + (c != null ? " around " + c : ""));
        this.suite();
    }

    @Override
    protected void copy(Plan p1) {
        super.copy(p1);
        PlanMoc pm = (PlanMoc)p1;
        pm.frameOrigin = this.frameOrigin;
        pm.moc = (HealpixMoc)this.moc.clone();
        pm.wireFrame = this.wireFrame;
        pm.gapOrder = this.gapOrder;
        pm.arrayHpix = new Hpix[30][];
    }

    public HealpixMoc toReferenceFrame(String coordSys) throws Exception {
        HealpixMoc moc1 = PlanMoc.convertTo(this.moc, coordSys);
        if (this.moc != moc1) {
            Aladin.trace(2, "Moc reference frame conversion: " + this.moc.getCoordSys() + " => " + moc1.getCoordSys());
        }
        return moc1;
    }

    public static HealpixMoc convertTo(HealpixMoc moc, String coordSys) throws Exception {
        int frameSrc;
        if (coordSys.equals(moc.getCoordSys())) {
            return moc;
        }
        char a = moc.getCoordSys().charAt(0);
        char b = coordSys.charAt(0);
        int n = a == 'G' ? 3 : (frameSrc = a == 'E' ? 2 : 0);
        int frameDst = b == 'G' ? 3 : (b == 'E' ? 2 : 0);
        Healpix hpx = new Healpix();
        int order = moc.getMaxOrder();
        HealpixMoc moc1 = new HealpixMoc(coordSys, moc.getMinLimitOrder(), moc.getMocOrder());
        moc1.setCheckConsistencyFlag(false);
        long onpix1 = -1L;
        Iterator<Long> it = moc.pixelIterator();
        while (it.hasNext()) {
            long npix = it.next();
            for (int i = 0; i < 4; ++i) {
                double[] coo = hpx.pix2ang(order + 1, npix * 4L + (long)i);
                Coord c = new Coord(coo[0], coo[1]);
                c = Localisation.frameToFrame(c, frameSrc, frameDst);
                long npix1 = hpx.ang2pix(order + 1, c.al, c.del);
                if (npix1 == onpix1) continue;
                onpix1 = npix1;
                moc1.add(order, npix1 / 4L);
            }
        }
        moc1.setCheckConsistencyFlag(true);
        return moc1;
    }

    protected HealpixMoc getMoc() {
        return this.moc;
    }

    @Override
    protected void suiteSpecific() {
        this.isOldPlan = false;
    }

    @Override
    protected boolean isSync() {
        return this.isReady();
    }

    @Override
    protected void reallocObjetCache() {
    }

    public void setWireFrame(int wireFrame) {
        this.wireFrame = wireFrame;
    }

    public void switchWireFrame(int mask) {
        this.wireFrame &= ~mask;
    }

    public int getWireFrame() {
        return this.wireFrame;
    }

    public boolean isDrawingBorder() {
        return (this.wireFrame & 1) != 0;
    }

    public boolean isDrawingFillIn() {
        return (this.wireFrame & 4) != 0;
    }

    public void setDrawingBorder(boolean flag) {
        this.wireFrame = flag ? (this.wireFrame |= 1) : (this.wireFrame &= 0xFFFFFFFE);
    }

    public void setDrawingFillIn(boolean flag) {
        this.wireFrame = flag ? (this.wireFrame |= 4) : (this.wireFrame &= 0xFFFFFFFB);
    }

    @Override
    protected boolean hasSources() {
        return false;
    }

    @Override
    protected int getCounts() {
        return 0;
    }

    @Override
    protected boolean waitForPlan() {
        block15: {
            if (this.dis != null) {
                super.waitForPlan();
                try {
                    String c;
                    if (this.moc == null && this.dis != null) {
                        this.moc = new HealpixMoc();
                        if ((this.dis.getType() & 1L) != 0L) {
                            this.moc.readFits(this.dis);
                        } else {
                            this.moc.readASCII(this.dis);
                        }
                    }
                    int n = this.frameOrigin = (c = this.moc.getCoordSys()) == null || c.charAt(0) == 'G' ? 3 : 0;
                    if (this.moc.getSize() == 0) {
                        this.error = "Empty MOC";
                    }
                }
                catch (Exception e) {
                    if (Aladin.levelTrace >= 3) {
                        e.printStackTrace();
                    }
                    return false;
                }
            }
            if ((this.co == null || this.flagNoTarget) && this.moc.getSize() > 0 && this.frameOrigin == 0) {
                try {
                    MocCell cell = this.moc.iterator().next();
                    double[] res = CDSHealpix.pix2ang_nest(CDSHealpix.pow2(cell.getOrder()), cell.getNpix());
                    double[] radec = CDSHealpix.polarToRadec(new double[]{res[0], res[1]});
                    this.co = new Coord(radec[0], radec[1]);
                }
                catch (Exception e) {
                    if (Aladin.levelTrace < 3) break block15;
                    e.printStackTrace();
                }
            }
        }
        if (this.moc != null && this.moc.getMinLimitOrder() < 3) {
            try {
                this.moc.setMinLimitOrder(3);
            }
            catch (Exception e) {
                if (Aladin.levelTrace >= 3) {
                    e.printStackTrace();
                }
                return false;
            }
        }
        return true;
    }

    @Override
    protected Iterator<Obj> iterator() {
        return null;
    }

    @Override
    protected void resetProj(int n) {
    }

    @Override
    protected boolean isDrawn() {
        return true;
    }

    private HealpixMoc getViewMoc(ViewSimple v, int order) throws Exception {
        Coord center = this.getCooCentre(v);
        long[] pix = this.getPixList(v, center, order);
        HealpixMoc m = new HealpixMoc();
        m.setCoordSys(this.moc.getCoordSys());
        for (int i = 0; i < pix.length; ++i) {
            m.add(order, pix[i]);
        }
        m.sort();
        return m;
    }

    @Override
    protected int getGapOrder() {
        return this.gapOrder;
    }

    @Override
    protected void setGapOrder(int gapOrder) {
        if (Math.abs(gapOrder) > MAXGAPORDER) {
            return;
        }
        this.gapOrder = gapOrder;
    }

    private Hpix[] getHpixListProg(int order) {
        int mo = this.moc.getMaxOrder();
        if (mo < 3) {
            mo = 3;
        }
        if ((order += 5) < 7) {
            order = 7;
        }
        if ((order += this.gapOrder) < 5) {
            order = 5;
        }
        if (order > mo) {
            order = mo;
        }
        if (this.arrayHpix[order] == null) {
            this.arrayHpix[order] = new Hpix[0];
            final int myOrder = order;
            final int myMo = mo;
            new Thread("PlanMoc building order=" + order){

                @Override
                public void run() {
                    Aladin.trace(4, "PlanMoc.getHpixListProg(" + myOrder + ") running...");
                    HealpixMoc mocLow = myOrder == myMo ? PlanMoc.this.moc : (HealpixMoc)PlanMoc.this.moc.clone();
                    try {
                        mocLow.setMocOrder(myOrder);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    Hpix[] hpixLow = new Hpix[PlanMoc.this.moc.getSize()];
                    int n = 0;
                    for (MocCell h : mocLow) {
                        hpixLow[n++] = new Hpix(h.order, h.npix, PlanMoc.this.frameOrigin);
                    }
                    ((PlanMoc)PlanMoc.this).arrayHpix[myOrder] = hpixLow;
                    Aladin.trace(4, "PlanMoc.getHpixListProg(" + myOrder + ") done !");
                    PlanMoc.this.askForRepaint();
                }
            }.start();
        }
        if (this.arrayHpix[order].length == 0) {
            int i;
            this.isLoading = true;
            for (i = order; i >= 5 && (this.arrayHpix[i] == null || this.arrayHpix[i].length == 0); --i) {
            }
            if (i >= 5) {
                order = i;
            }
        } else {
            this.isLoading = false;
        }
        this.lastOrderDrawn = order;
        return this.arrayHpix[order];
    }

    @Override
    protected boolean isLoading() {
        return this.isLoading;
    }

    @Override
    protected boolean hasMoreDetails() {
        return this.moc != null && this.lastOrderDrawn < this.moc.getMaxOrder();
    }

    @Override
    protected double getCompletude() {
        return -1.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void draw(Graphics g, ViewSimple v) {
        block9: {
            long t1 = Util.getTime();
            g.setColor(this.c);
            int max = Math.min(this.maxOrder(v), this.maxOrder) + 1;
            try {
                Hpix p;
                HealpixMoc m = v.isAllSky() ? null : this.getViewMoc(v, max);
                int order = 0;
                long t = 0L;
                Hpix[] hpixList = this.getHpixListProg(max + (v.isAllSky() ? 0 : 1));
                for (int i = 0; i < hpixList.length && (p = hpixList[i]) != null; ++i) {
                    boolean small;
                    order = p.getOrder();
                    if (m != null && !m.isIntersecting(order, p.getNpix()) || p.isOutView(v)) continue;
                    boolean bl = small = p.getDiag2(v) < 25.0;
                    if (this.isDrawingFillIn() && !small) {
                        if (g instanceof Graphics2D) {
                            Graphics2D g2d = (Graphics2D)g;
                            Composite saveComposite = g2d.getComposite();
                            try {
                                g2d.setComposite(Util.getImageComposite(this.getOpacityLevel() / 5.0f));
                                p.fill(g, v);
                            }
                            finally {
                                g2d.setComposite(saveComposite);
                            }
                        } else {
                            p.fill(g, v);
                        }
                    }
                    if (!this.isDrawingBorder()) continue;
                    p.draw(g, v, this.isDrawingBorder());
                }
                t = Util.getTime();
                this.statTimeDisplay = t - t1;
            }
            catch (Exception e) {
                if (Aladin.levelTrace < 3) break block9;
                e.printStackTrace();
            }
        }
    }
}

