/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Calib;
import cds.aladin.Coord;
import cds.aladin.Couleur;
import cds.aladin.FrameHeaderFits;
import cds.aladin.HealpixAllsky;
import cds.aladin.HealpixAllskyPol;
import cds.aladin.HealpixKey;
import cds.aladin.HealpixKeyPol;
import cds.aladin.Localisation;
import cds.aladin.MyInputStream;
import cds.aladin.MyProperties;
import cds.aladin.Plan;
import cds.aladin.PlanHealpix;
import cds.aladin.PlanImage;
import cds.aladin.PlanImageRGB;
import cds.aladin.PlanMoc;
import cds.aladin.PointD;
import cds.aladin.Projection;
import cds.aladin.RectangleD;
import cds.aladin.Repere;
import cds.aladin.TreeNodeAllsky;
import cds.aladin.ViewMemoItem;
import cds.aladin.ViewSimple;
import cds.astro.Coo;
import cds.fits.HeaderFits;
import cds.moc.HealpixMoc;
import cds.moc.MocCell;
import cds.tools.Util;
import cds.tools.pixtools.CDSHealpix;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;

public class PlanBG
extends PlanImage {
    static final boolean NOALLSKY = false;
    static final boolean TEST = true;
    static final int DRAWPIXEL = 0;
    static final int DRAWPOLARISATION = 1;
    private float segmentLenFactor = 1.0f;
    private int segmentThickness = 1;
    private float segmentDensityFactor = 1.0f;
    private Color oc = null;
    protected int drawMode = 0;
    static final String CACHE = "Background";
    static long MAXCACHE = 0x400000L;
    protected static final int LIVETIME = 3000;
    protected MyProperties prop = null;
    protected String gluTag = null;
    protected String id = null;
    protected String survey;
    protected String version = "";
    protected String url;
    protected int minOrder = 3;
    protected int maxOrder = 14;
    protected Hashtable<String, HealpixKey> pixList;
    protected HealpixLoader loader;
    protected boolean hasDrawnSomething = false;
    protected boolean allWaitingKeysDrawn = false;
    protected boolean useCache = true;
    protected boolean cube = false;
    protected boolean color = false;
    protected boolean colorPNG = false;
    protected boolean colorUnknown = false;
    public boolean fitsGzipped = false;
    public boolean truePixels = false;
    public boolean inFits = false;
    public boolean inJPEG = false;
    public boolean inPNG = false;
    private boolean hasMoc = false;
    private boolean hasHpxFinder = false;
    protected int frameOrigin = 0;
    protected int frameDrawing;
    protected boolean local;
    protected boolean loadMocNow;
    protected String pixelRange;
    protected String pixelCut;
    protected boolean flagNoTarget;
    private int tileOrder;
    protected int[] RGBCONTROL;
    protected int[] RGBControl;
    static volatile long cacheSize = -1L;
    private static Object cacheLock = new Object();
    private int polaScaleFactor;
    protected long memSize;
    private boolean testMoc;
    private boolean testHpxFinder;
    protected HealpixMoc moc;
    private static final int MAXCHECKSITE = 3;
    private int nbCheckSite;
    private boolean flagClearBuf;
    protected boolean flagRecut;
    protected double flagRecutRadius;
    protected Coord flagRecutCoo;
    private String cacheName;
    private String dirCache;
    private boolean flagCache;
    protected int nbReady;
    private static Thread scanCache = null;
    private static long NBFILE = 0L;
    protected int nbFlush;
    private long lastGc;
    private long lastMemP;
    private long lastMemI;
    private static int MEMREQUIREDFORGC = 0x2800000;
    private boolean memCpt;
    private boolean firstSubtil;
    protected static String CURRENTMODE = "";
    protected static boolean DEBUGMODE = false;
    protected double[] RES;
    private int allSkyOrder;
    public static final int DIRSIZE = 10000;
    protected int[] xy2hpx;
    protected int[] hpx2xy;
    private long lastTouch;
    protected long lastIz;
    protected int lastMaxOrder;
    private int oLosangeOrder;
    private boolean hasMoreDetails;
    private long[] children;
    protected long[] pixDebugIn;
    protected final int ALLSKYORDER = 3;
    boolean first1;
    private int lastHistID;
    private double[] histRed;
    private double[] histGreen;
    private double[] histBlue;
    protected byte[] red;
    protected byte[] green;
    protected byte[] blue;
    private Timer timer;
    boolean readyAfterDraw;
    boolean readyDone;
    protected int priority;
    protected static int nDraw1 = 0;
    protected static int nOut1 = 0;
    static final int DRAWFASTMS = 150;
    private boolean computeDrawFast;
    private boolean lastMustDrawFast;
    private static final int MAXSTAT = 5;
    private int nStat;
    private long[] statTimeDisplayArray;
    private boolean first;
    private boolean fading;
    static final int M = 2;
    private long timerLastDrawBG;
    private boolean oLoading;
    private static final int MAXTIMETOBELOADFROMNET = 1000;
    protected long cumulTimeLoadNet;
    protected long cumulTimeLoadCache;
    protected long cumulTimeWriteCache;
    protected long cumulTimeDraw;
    protected long cumulTimeStream;
    protected long cumulTimeJPEG;
    protected long cumulTimePixel;
    protected int nbLoadNet;
    protected int nbLoadCache;
    protected int nbWriteCache;
    protected int nbImgDraw;
    protected long nByteReadNet;
    protected long nByteReadCache;
    protected long nByteWriteCache;
    protected int nbImgCreated;
    protected int nbImgInBuf;
    protected int nbCreated;
    protected int nbAborted;
    protected int nbFree;

    protected void setDrawMode(int mode) {
        this.drawMode = mode;
        if (this.drawMode == 1) {
            if ((double)this.opacityLevel < 0.1) {
                this.setOpacityLevel(1.0f);
            }
            if (this.oc == null) {
                this.oc = this.c = Couleur.getNextDefault(this.aladin.calque);
            } else {
                this.c = this.oc;
            }
        } else {
            this.c = Color.black;
        }
        this.type = mode == 1 ? 17 : 16;
    }

    protected PlanBG(Aladin aladin) {
        super(aladin);
        this.frameDrawing = this.aladin.configuration.getFrameDrawing();
        this.loadMocNow = false;
        this.pixelRange = null;
        this.pixelCut = null;
        this.flagNoTarget = false;
        this.tileOrder = -1;
        this.RGBCONTROL = new int[]{0, 128, 255, 0, 128, 255, 0, 128, 255};
        this.polaScaleFactor = 40;
        this.memSize = 0L;
        this.testMoc = false;
        this.testHpxFinder = false;
        this.nbCheckSite = 0;
        this.flagClearBuf = false;
        this.flagRecut = true;
        this.flagRecutRadius = 0.0;
        this.flagRecutCoo = null;
        this.cacheName = null;
        this.dirCache = null;
        this.flagCache = false;
        this.nbReady = 0;
        this.nbFlush = 0;
        this.lastGc = 0L;
        this.lastMemP = 0L;
        this.lastMemI = 0L;
        this.memCpt = true;
        this.firstSubtil = true;
        this.RES = null;
        this.allSkyOrder = -1;
        this.xy2hpx = null;
        this.hpx2xy = null;
        this.lastTouch = 0L;
        this.lastIz = -1L;
        this.lastMaxOrder = 3;
        this.oLosangeOrder = -1;
        this.hasMoreDetails = true;
        this.children = null;
        this.pixDebugIn = new long[0];
        this.ALLSKYORDER = 3;
        this.first1 = false;
        this.lastHistID = -1;
        this.histRed = new double[256];
        this.histGreen = new double[256];
        this.histBlue = new double[256];
        this.timer = null;
        this.readyAfterDraw = false;
        this.readyDone = false;
        this.priority = 0;
        this.computeDrawFast = true;
        this.lastMustDrawFast = true;
        this.nStat = 0;
        this.statTimeDisplayArray = new long[5];
        this.first = true;
        this.fading = false;
        this.timerLastDrawBG = 0L;
        this.oLoading = false;
        this.cumulTimeLoadNet = 0L;
        this.cumulTimeLoadCache = 0L;
        this.cumulTimeWriteCache = 0L;
        this.cumulTimeDraw = 0L;
        this.cumulTimeStream = 0L;
        this.cumulTimeJPEG = 0L;
        this.cumulTimePixel = 0L;
        this.nbLoadNet = 0;
        this.nbLoadCache = 0;
        this.nbWriteCache = 0;
        this.nbImgDraw = 0;
        this.nByteReadNet = 0L;
        this.nByteReadCache = 0L;
        this.nByteWriteCache = 0L;
        this.nbImgCreated = 0;
        this.nbImgInBuf = 0;
        this.nbCreated = 0;
        this.nbAborted = 0;
        this.nbFree = 0;
        this.initCache();
    }

    protected PlanBG(Aladin aladin, TreeNodeAllsky gluSky, String label, Coord c, double radius, String startingTaskId) {
        super(aladin);
        this.frameDrawing = this.aladin.configuration.getFrameDrawing();
        this.loadMocNow = false;
        this.pixelRange = null;
        this.pixelCut = null;
        this.flagNoTarget = false;
        this.tileOrder = -1;
        this.RGBCONTROL = new int[]{0, 128, 255, 0, 128, 255, 0, 128, 255};
        this.polaScaleFactor = 40;
        this.memSize = 0L;
        this.testMoc = false;
        this.testHpxFinder = false;
        this.nbCheckSite = 0;
        this.flagClearBuf = false;
        this.flagRecut = true;
        this.flagRecutRadius = 0.0;
        this.flagRecutCoo = null;
        this.cacheName = null;
        this.dirCache = null;
        this.flagCache = false;
        this.nbReady = 0;
        this.nbFlush = 0;
        this.lastGc = 0L;
        this.lastMemP = 0L;
        this.lastMemI = 0L;
        this.memCpt = true;
        this.firstSubtil = true;
        this.RES = null;
        this.allSkyOrder = -1;
        this.xy2hpx = null;
        this.hpx2xy = null;
        this.lastTouch = 0L;
        this.lastIz = -1L;
        this.lastMaxOrder = 3;
        this.oLosangeOrder = -1;
        this.hasMoreDetails = true;
        this.children = null;
        this.pixDebugIn = new long[0];
        this.ALLSKYORDER = 3;
        this.first1 = false;
        this.lastHistID = -1;
        this.histRed = new double[256];
        this.histGreen = new double[256];
        this.histBlue = new double[256];
        this.timer = null;
        this.readyAfterDraw = false;
        this.readyDone = false;
        this.priority = 0;
        this.computeDrawFast = true;
        this.lastMustDrawFast = true;
        this.nStat = 0;
        this.statTimeDisplayArray = new long[5];
        this.first = true;
        this.fading = false;
        this.timerLastDrawBG = 0L;
        this.oLoading = false;
        this.cumulTimeLoadNet = 0L;
        this.cumulTimeLoadCache = 0L;
        this.cumulTimeWriteCache = 0L;
        this.cumulTimeDraw = 0L;
        this.cumulTimeStream = 0L;
        this.cumulTimeJPEG = 0L;
        this.cumulTimePixel = 0L;
        this.nbLoadNet = 0;
        this.nbLoadCache = 0;
        this.nbWriteCache = 0;
        this.nbImgDraw = 0;
        this.nByteReadNet = 0L;
        this.nByteReadCache = 0L;
        this.nByteWriteCache = 0L;
        this.nbImgCreated = 0;
        this.nbImgInBuf = 0;
        this.nbCreated = 0;
        this.nbAborted = 0;
        this.nbFree = 0;
        this.startingTaskId = startingTaskId;
        this.initCache();
        this.gluTag = gluSky.getID();
        this.id = gluSky.internalId;
        this.url = gluSky.getUrl();
        this.survey = gluSky.label;
        this.version = gluSky.version;
        this.minOrder = gluSky.minOrder;
        this.maxOrder = gluSky.maxOrder;
        this.useCache = gluSky.useCache();
        this.local = gluSky.local;
        this.loadMocNow = gluSky.loadMocNow();
        this.frameOrigin = gluSky.frame;
        this.description = gluSky.description;
        this.verboseDescr = gluSky.verboseDescr;
        this.ack = gluSky.ack;
        this.copyright = gluSky.copyright;
        this.copyrightUrl = gluSky.copyrightUrl;
        this.co = c;
        this.coRadius = radius;
        if (label != null && label.trim().length() > 0) {
            this.setLabel(label);
        }
        this.setSpecificParams(gluSky);
        Aladin.trace(3, "AllSky creation: " + gluSky.toString1() + (c != null ? " around " + c : ""));
        this.suite();
    }

    private void resetCache() {
        String dirname = this.getCacheDir() + Util.FS + this.getCacheName();
        File f = new File(dirname);
        for (int i = 1; i < 10 && !f.renameTo(new File(this.getCacheDir() + Util.FS + this.getCacheName() + "." + i + ".old")); ++i) {
        }
        new File(this.getCacheDir() + Util.FS + this.getCacheName()).mkdir();
        Aladin.trace(3, "HEALPix local cache for " + this.getCacheName() + " is out of date => renamed => will be removed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties loadPropertieFile() {
        if (this.prop != null) {
            return this.prop;
        }
        String dateRef = null;
        boolean local = !this.url.startsWith("http:") && !this.url.startsWith("https:") && !this.url.startsWith("ftp:");
        try {
            InputStream in = null;
            if (local) {
                in = new FileInputStream(new File(this.url + Util.FS + "properties"));
            } else {
                File f;
                block24: {
                    this.checkSite(false);
                    String cacheFile = this.getCacheDir() + Util.FS + this.getCacheName() + Util.FS + "properties";
                    f = new File(cacheFile);
                    String urlFile = this.url + "/" + "properties";
                    HttpURLConnection conn = (HttpURLConnection)new URL(urlFile).openConnection();
                    if (this.useCache && f.exists()) {
                        conn.setIfModifiedSince(f.lastModified());
                        this.prop = new MyProperties();
                        FileInputStream in1 = new FileInputStream(f);
                        this.prop.load(in1);
                        ((InputStream)in1).close();
                        dateRef = this.prop.getProperty("hips_release_date");
                        if (dateRef == null) {
                            dateRef = this.prop.getProperty("processingDate", "");
                        }
                    }
                    MyInputStream dis = null;
                    try {
                        in = conn.getInputStream();
                        int code = conn.getResponseCode();
                        if (code == 304) {
                            throw new Exception();
                        }
                        if (!this.useCache) break block24;
                        dis = new MyInputStream(in);
                        byte[] buf = dis.readFully();
                        dis.close();
                        this.prop = new MyProperties();
                        ByteArrayInputStream in1 = new ByteArrayInputStream(buf);
                        this.prop.load(in1);
                        ((InputStream)in1).close();
                        String dateRef1 = this.prop.getProperty("hips_release_date");
                        if (dateRef1 == null) {
                            dateRef1 = this.prop.getProperty("processingDate", "");
                        }
                        if (dateRef1.equals(dateRef)) {
                            throw new Exception();
                        }
                        RandomAccessFile fcache = null;
                        try {
                            this.resetCache();
                            f = new File(cacheFile);
                            fcache = new RandomAccessFile(f, "rw");
                            fcache.write(buf);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        finally {
                            if (fcache != null) {
                                fcache.close();
                            }
                        }
                    }
                    catch (Exception e) {
                        Aladin.trace(3, "HEALPix local cache for " + this.survey + " is ok [" + cacheFile + "]");
                    }
                    finally {
                        if (dis != null) {
                            dis.close();
                        }
                    }
                }
                if (f.exists()) {
                    in = new FileInputStream(f);
                }
            }
            if (in == null) {
                throw new Exception();
            }
            this.prop = new MyProperties();
            this.prop.load(in);
            ((InputStream)in).close();
        }
        catch (Exception e) {
            this.prop = null;
        }
        return this.prop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean scanMetadata() {
        MyInputStream in = null;
        try {
            in = Util.openAnyStream(this.url + Util.FS + "metadata.txt");
            byte[] res = in.readFully();
            HeaderFits h = new HeaderFits();
            h.readFreeHeader(new String(res));
            this.headerFits = new FrameHeaderFits(h);
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                in.close();
            }
            catch (Exception e) {}
        }
        return true;
    }

    protected boolean scanProperties() {
        try {
            String s;
            Properties prop = this.loadPropertieFile();
            if (prop == null) {
                throw new Exception();
            }
            Aladin.trace(4, "PlanBG.setSpecificParams() found a \"properties\" file");
            int frame = -1;
            String strFrame = prop.getProperty("hips_frame", "X");
            if (strFrame.equals("equatorial")) {
                frame = 0;
            } else if (strFrame.equals("galactic")) {
                frame = 3;
            } else if (strFrame.equals("ecliptic")) {
                frame = 2;
            } else if (strFrame.equals("X")) {
                strFrame = prop.getProperty("coordsys", "X");
                char c1 = strFrame.charAt(0);
                if (c1 == 'C' || c1 == 'Q') {
                    frame = 0;
                } else if (c1 == 'E') {
                    frame = 2;
                } else if (c1 == 'G') {
                    frame = 3;
                }
            }
            if (frame != -1 && frame != this.frameOrigin) {
                Aladin.trace(1, "Coordinate frame found in properties file (" + Localisation.getFrameName(frame) + ") differs from the remote information (" + Localisation.getFrameName(this.frameOrigin) + ") => assume " + Localisation.getFrameName(frame));
                this.frameOrigin = frame;
            }
            if ((s = prop.getProperty("obs_title")) == null) {
                s = prop.getProperty("description");
            }
            if (s != null) {
                this.description = s;
            }
            if ((s = prop.getProperty("obs_description")) == null) {
                s = prop.getProperty("verboseDescription");
            }
            if (s != null) {
                this.verboseDescr = s;
            }
            if ((s = prop.getProperty("obs_ack")) == null) {
                s = prop.getProperty("acknowledgement");
            }
            if (s != null) {
                this.ack = s;
            }
            if ((s = prop.getProperty("obs_copyright")) == null) {
                s = prop.getProperty("copyright");
            }
            if (s != null) {
                this.copyright = s;
            }
            if ((s = prop.getProperty("obs_copyright_url")) == null) {
                s = prop.getProperty("copyrightUrl");
            }
            if (s != null) {
                this.copyrightUrl = s;
            }
            if ((s = prop.getProperty("hips_data_range")) == null) {
                s = prop.getProperty("pixelRange");
            }
            if (s != null) {
                this.pixelRange = s;
            }
            if ((s = prop.getProperty("hips_pixel_cut")) == null) {
                s = prop.getProperty("pixelCut");
            }
            if (s != null) {
                this.pixelCut = s;
            }
            if ((s = prop.getProperty("publisher_did")) == null) {
                s = prop.getProperty("id");
            }
            this.id = s;
            s = prop.getProperty("hips_tile_width");
            if (s != null) {
                try {
                    int w = Integer.parseInt(s);
                    this.tileOrder = (int)CDSHealpix.log2(w);
                }
                catch (Exception e) {}
            } else {
                s = prop.getProperty("tileOrder");
                if (s != null) {
                    try {
                        this.tileOrder = Integer.parseInt(s);
                    }
                    catch (Exception e) {}
                }
            }
        }
        catch (Exception e) {
            Aladin.trace(3, "No properties file found ...");
            return false;
        }
        return true;
    }

    protected void setSpecificParams(TreeNodeAllsky gluSky) {
        this.type = 16;
        this.video = this.aladin.configuration.getCMVideo();
        this.inFits = gluSky.isFits();
        this.inJPEG = gluSky.isJPEG();
        this.inPNG = gluSky.isPNG();
        this.truePixels = gluSky.isTruePixels();
        this.color = gluSky.isColored();
        this.cube = gluSky.isCube();
        this.scanProperties();
        this.scanMetadata();
        gluSky.reset();
    }

    protected int getTileMode() {
        if (this.isTruePixels()) {
            return 1;
        }
        if (this.inPNG) {
            return 4;
        }
        return 0;
    }

    public PlanBG(Aladin aladin, String path, String label, Coord c, double radius, String startingTaskId) {
        super(aladin);
        this.frameDrawing = this.aladin.configuration.getFrameDrawing();
        this.loadMocNow = false;
        this.pixelRange = null;
        this.pixelCut = null;
        this.flagNoTarget = false;
        this.tileOrder = -1;
        this.RGBCONTROL = new int[]{0, 128, 255, 0, 128, 255, 0, 128, 255};
        this.polaScaleFactor = 40;
        this.memSize = 0L;
        this.testMoc = false;
        this.testHpxFinder = false;
        this.nbCheckSite = 0;
        this.flagClearBuf = false;
        this.flagRecut = true;
        this.flagRecutRadius = 0.0;
        this.flagRecutCoo = null;
        this.cacheName = null;
        this.dirCache = null;
        this.flagCache = false;
        this.nbReady = 0;
        this.nbFlush = 0;
        this.lastGc = 0L;
        this.lastMemP = 0L;
        this.lastMemI = 0L;
        this.memCpt = true;
        this.firstSubtil = true;
        this.RES = null;
        this.allSkyOrder = -1;
        this.xy2hpx = null;
        this.hpx2xy = null;
        this.lastTouch = 0L;
        this.lastIz = -1L;
        this.lastMaxOrder = 3;
        this.oLosangeOrder = -1;
        this.hasMoreDetails = true;
        this.children = null;
        this.pixDebugIn = new long[0];
        this.ALLSKYORDER = 3;
        this.first1 = false;
        this.lastHistID = -1;
        this.histRed = new double[256];
        this.histGreen = new double[256];
        this.histBlue = new double[256];
        this.timer = null;
        this.readyAfterDraw = false;
        this.readyDone = false;
        this.priority = 0;
        this.computeDrawFast = true;
        this.lastMustDrawFast = true;
        this.nStat = 0;
        this.statTimeDisplayArray = new long[5];
        this.first = true;
        this.fading = false;
        this.timerLastDrawBG = 0L;
        this.oLoading = false;
        this.cumulTimeLoadNet = 0L;
        this.cumulTimeLoadCache = 0L;
        this.cumulTimeWriteCache = 0L;
        this.cumulTimeDraw = 0L;
        this.cumulTimeStream = 0L;
        this.cumulTimeJPEG = 0L;
        this.cumulTimePixel = 0L;
        this.nbLoadNet = 0;
        this.nbLoadCache = 0;
        this.nbWriteCache = 0;
        this.nbImgDraw = 0;
        this.nByteReadNet = 0L;
        this.nByteReadCache = 0L;
        this.nByteWriteCache = 0L;
        this.nbImgCreated = 0;
        this.nbImgInBuf = 0;
        this.nbCreated = 0;
        this.nbAborted = 0;
        this.nbFree = 0;
        this.startingTaskId = startingTaskId;
        this.initCache();
        Aladin.trace(2, "Creating allSky directory plane [" + path + "]");
        this.type = 16;
        this.video = aladin.configuration.getCMVideo();
        File f = new File(path);
        this.url = f.getAbsolutePath();
        this.survey = f.getName();
        this.maxOrder = 3;
        this.useCache = false;
        this.label = label;
        this.paramByTreeNode(new TreeNodeAllsky(aladin, this.url), c, radius);
        this.scanProperties();
        this.scanMetadata();
        Aladin.trace(3, "AllSky local... frame=" + Localisation.getFrameName(this.frameOrigin) + " " + this + (c != null ? " around " + c : ""));
        this.suite();
    }

    protected PlanBG(Aladin aladin, URL u, String label, Coord c, double radius, String startingTaskId) {
        super(aladin);
        this.frameDrawing = this.aladin.configuration.getFrameDrawing();
        this.loadMocNow = false;
        this.pixelRange = null;
        this.pixelCut = null;
        this.flagNoTarget = false;
        this.tileOrder = -1;
        this.RGBCONTROL = new int[]{0, 128, 255, 0, 128, 255, 0, 128, 255};
        this.polaScaleFactor = 40;
        this.memSize = 0L;
        this.testMoc = false;
        this.testHpxFinder = false;
        this.nbCheckSite = 0;
        this.flagClearBuf = false;
        this.flagRecut = true;
        this.flagRecutRadius = 0.0;
        this.flagRecutCoo = null;
        this.cacheName = null;
        this.dirCache = null;
        this.flagCache = false;
        this.nbReady = 0;
        this.nbFlush = 0;
        this.lastGc = 0L;
        this.lastMemP = 0L;
        this.lastMemI = 0L;
        this.memCpt = true;
        this.firstSubtil = true;
        this.RES = null;
        this.allSkyOrder = -1;
        this.xy2hpx = null;
        this.hpx2xy = null;
        this.lastTouch = 0L;
        this.lastIz = -1L;
        this.lastMaxOrder = 3;
        this.oLosangeOrder = -1;
        this.hasMoreDetails = true;
        this.children = null;
        this.pixDebugIn = new long[0];
        this.ALLSKYORDER = 3;
        this.first1 = false;
        this.lastHistID = -1;
        this.histRed = new double[256];
        this.histGreen = new double[256];
        this.histBlue = new double[256];
        this.timer = null;
        this.readyAfterDraw = false;
        this.readyDone = false;
        this.priority = 0;
        this.computeDrawFast = true;
        this.lastMustDrawFast = true;
        this.nStat = 0;
        this.statTimeDisplayArray = new long[5];
        this.first = true;
        this.fading = false;
        this.timerLastDrawBG = 0L;
        this.oLoading = false;
        this.cumulTimeLoadNet = 0L;
        this.cumulTimeLoadCache = 0L;
        this.cumulTimeWriteCache = 0L;
        this.cumulTimeDraw = 0L;
        this.cumulTimeStream = 0L;
        this.cumulTimeJPEG = 0L;
        this.cumulTimePixel = 0L;
        this.nbLoadNet = 0;
        this.nbLoadCache = 0;
        this.nbWriteCache = 0;
        this.nbImgDraw = 0;
        this.nByteReadNet = 0L;
        this.nByteReadCache = 0L;
        this.nByteWriteCache = 0L;
        this.nbImgCreated = 0;
        this.nbImgInBuf = 0;
        this.nbCreated = 0;
        this.nbAborted = 0;
        this.nbFree = 0;
        this.startingTaskId = startingTaskId;
        this.initCache();
        Aladin.trace(2, "Creating allSky http plane [" + u + "]");
        this.type = 16;
        this.video = aladin.configuration.getCMVideo();
        this.url = u.toString();
        this.maxOrder = 3;
        this.useCache = true;
        this.local = false;
        this.co = c;
        this.coRadius = radius;
        this.paramByTreeNode(new TreeNodeAllsky(aladin, this.url), c, radius);
        int n = this.url.length();
        if (this.url.endsWith("/")) {
            --n;
        }
        this.survey = this.label != null && this.label.length() > 0 ? this.label : this.url.substring(this.url.lastIndexOf(47, n - 1) + 1, n);
        this.scanProperties();
        this.scanMetadata();
        Aladin.trace(3, "AllSky http... " + this + (c != null ? " around " + c : ""));
        this.suite();
    }

    protected void paramByTreeNode(TreeNodeAllsky gSky, Coord c, double radius) {
        if (this.label != null && this.label.trim().length() > 0) {
            this.setLabel(this.label);
        } else {
            this.setLabel(gSky.label);
        }
        this.maxOrder = gSky.getMaxOrder();
        this.inFits = gSky.isFits();
        this.inJPEG = gSky.isJPEG();
        this.inPNG = gSky.isPNG();
        this.truePixels = gSky.isTruePixels();
        this.color = gSky.isColored();
        this.cube = gSky.isCube();
        this.frameOrigin = gSky.getFrame();
        this.tileOrder = gSky.getLosangeOrder();
        this.local = gSky.isLocal();
        this.loadMocNow = gSky.loadMocNow();
        this.version = gSky.getVersion();
        this.useCache = !this.local && gSky.useCache();
        this.co = c != null ? c : gSky.getTarget();
        this.coRadius = c != null ? radius : gSky.getRadius();
    }

    @Override
    protected String getPixelInfoFromGrey(int greyLevel, int mode) {
        if (this.truePixels) {
            return super.getPixelInfoFromGrey(greyLevel, mode);
        }
        return "";
    }

    protected boolean hasMoc() {
        if (this.hasMoc || this.testMoc) {
            return this.hasMoc;
        }
        String s = this.getProperty("moc_access_url");
        if (s != null) {
            this.testMoc = true;
            this.hasMoc = true;
        } else {
            String moc = this.url + "/" + "Moc.fits";
            this.hasMoc = this.local ? new File(moc).exists() : Util.isUrlResponding(moc);
            this.testMoc = true;
        }
        return this.hasMoc;
    }

    protected String getProperty(String key) {
        return this.prop == null ? null : this.prop.getProperty(key);
    }

    protected boolean hasHpxFinder() {
        if (this.hasHpxFinder || this.testHpxFinder) {
            return this.hasHpxFinder;
        }
        String s = this.getProperty("hips_progenitor_url");
        if (s != null) {
            this.testHpxFinder = true;
            this.hasHpxFinder = true;
        } else {
            String f = this.url + "/" + "HpxFinder" + "/" + "metadata.xml";
            this.hasHpxFinder = this.local ? new File(f).exists() : Util.isUrlResponding(f);
            this.testHpxFinder = true;
        }
        return this.hasHpxFinder;
    }

    protected void loadMoc() {
        if (this.moc == null) {
            try {
                this.loadInternalMoc();
            }
            catch (Exception e) {
                if (Aladin.levelTrace >= 3) {
                    e.printStackTrace();
                }
                return;
            }
        }
        this.aladin.calque.newPlanMOC(this.moc, this.label + " MOC");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadInternalMoc() throws Exception {
        String fcache = this.getCacheDir() + "/" + this.getCacheName() + "/" + "Moc.fits";
        if (!this.local && this.useCache && new File(fcache).exists()) {
            FileInputStream in = null;
            try {
                in = new FileInputStream(fcache);
                this.moc = new HealpixMoc(in);
                this.moc.setMinLimitOrder(3);
                this.removeHealpixOutsideMoc();
            }
            finally {
                if (in != null) {
                    ((InputStream)in).close();
                }
            }
            Aladin.trace(3, "Loading " + this.survey + " MOC from cache");
            return;
        }
        String f = this.getProperty("moc_access_url");
        if (f == null) {
            f = this.getUrl() + "/" + "Moc.fits";
        }
        MyInputStream mis = null;
        try {
            mis = Util.openAnyStream(f);
            this.moc = new HealpixMoc(mis);
            this.moc.setMinLimitOrder(3);
            this.removeHealpixOutsideMoc();
        }
        finally {
            if (mis != null) {
                mis.close();
            }
        }
        Aladin.trace(3, "Loading " + this.survey + " MOC from net");
        if (!this.local && this.useCache) {
            this.moc.write(fcache);
            Aladin.trace(3, "Saving " + this.survey + " MOC in cache");
        }
    }

    private void removeHealpixOutsideMoc() {
        block5: {
            if (this.moc == null) {
                return;
            }
            Enumeration<String> e = this.pixList.keys();
            while (e.hasMoreElements()) {
                String k = e.nextElement();
                HealpixKey h = this.pixList.get(k);
                if (h == null || h.npix == -1L || this.moc.isIntersecting(h.order, h.npix)) continue;
                h.abort();
                this.pixList.remove(k);
            }
            if ((this.co == null || this.flagNoTarget) && this.moc.getSize() > 0 && this.frameOrigin == 0) {
                try {
                    MocCell cell = this.moc.iterator().next();
                    double[] res = CDSHealpix.pix2ang_nest(CDSHealpix.pow2(cell.getOrder()), cell.getNpix());
                    double[] radec = CDSHealpix.polarToRadec(new double[]{res[0], res[1]});
                    this.co = new Coord(radec[0], radec[1]);
                }
                catch (Exception e1) {
                    if (Aladin.levelTrace < 3) break block5;
                    e1.printStackTrace();
                }
            }
        }
    }

    protected void loadProgen() {
        String progen = this.getProperty("hips_progenitor_url");
        if (progen == null) {
            progen = this.url + "/" + "HpxFinder";
        }
        this.aladin.execAsyncCommand("'Details " + this.label + "'=load " + progen);
    }

    protected int getFrameDrawing() {
        return this.frameDrawing;
    }

    protected void setFrameDrawing(int frame) {
        this.frameDrawing = frame;
        if (this.projd.frame != this.getCurrentFrameDrawing()) {
            this.projd.frame = this.getCurrentFrameDrawing();
            this.syncProjLocal();
            this.aladin.view.repaintAll();
        }
    }

    @Override
    protected void syncProjLocal() {
        Coord c;
        int j;
        for (j = 0; j < this.aladin.view.modeView; ++j) {
            ViewSimple v = this.aladin.view.viewSimple[j];
            if (v.pref != this) continue;
            c = v.projLocal.getProjCenter();
            v.projLocal.frame = this.projd.frame;
            if (this.projd.frame != 0) {
                c = Localisation.frameToFrame(c, 0, this.projd.frame);
            }
            v.projLocal.modify(this.projd.label, this.projd.modeCalib, c.al, c.del, this.projd.rm, this.projd.rm, this.projd.cx, this.projd.cy, this.projd.r, this.projd.r, this.projd.rot, this.projd.sym, this.projd.t, this.projd.system);
            v.newView(1);
        }
        for (j = this.aladin.view.viewMemo.size() - 1; j >= 0; --j) {
            ViewMemoItem memo = this.aladin.view.viewMemo.memo[j];
            if (memo == null || memo.pref != this) continue;
            c = memo.projLocal.getProjCenter();
            memo.projLocal.frame = this.projd.frame;
            if (this.projd.frame != 0) {
                c = Localisation.frameToFrame(c, 0, this.projd.frame);
            }
            memo.projLocal.modify(this.projd.label, this.projd.modeCalib, c.al, c.del, this.projd.rm, this.projd.rm, this.projd.cx, this.projd.cy, this.projd.r, this.projd.r, this.projd.rot, this.projd.sym, this.projd.t, this.projd.system);
        }
    }

    protected int getCurrentFrameDrawing() {
        if (this.frameDrawing == 0) {
            return this.aladin.localisation.getFrame();
        }
        return Util.indexInArrayOf(Localisation.FRAME[this.frameDrawing], Localisation.REPERE);
    }

    public int getFrameOrigin() {
        return this.frameOrigin;
    }

    protected static boolean isPlanHpxFinder(String path) {
        File f = new File(path);
        return f.getName().equals("HpxFinder") && f.isDirectory();
    }

    protected static boolean isPlanBG(String path) {
        if (PlanBG.isPlanHpxFinder(path)) {
            return true;
        }
        String s = path + Util.FS + "Norder3";
        File f = new File(s);
        return f.isDirectory();
    }

    protected void suite() {
        if (this.label == null || this.label.trim().length() == 0) {
            this.setLabel(this.survey);
        }
        int defaultProjType = this.aladin.configuration.getProjAllsky();
        if (this.co == null) {
            this.flagNoTarget = true;
            this.co = new Coord(0.0, 0.0);
            this.co = Localisation.frameToFrame(this.co, this.aladin.localisation.getFrame(), 0);
            this.coRadius = 220.0;
        }
        if (this.coRadius <= 0.0) {
            this.coRadius = 220.0;
        }
        this.objet = this.co + "";
        Plan base = this.aladin.calque.getPlanBase();
        if (base instanceof PlanBG) {
            defaultProjType = base.projd.t;
        }
        Projection p = new Projection("allsky", 2, this.co.al, this.co.del, 240.0, 240.0, 250.0, 250.0, 500.0, 500.0, 0.0, false, defaultProjType, Calib.FK5);
        p.frame = this.getCurrentFrameDrawing();
        if (Aladin.OUTREACH) {
            p.frame = 3;
        }
        this.setNewProjD(p);
        this.typeCM = this.aladin.configuration.getCMMap();
        this.transfertFct = this.aladin.configuration.getCMFct();
        this.video = this.aladin.configuration.getCMVideo();
        this.setDefaultZoom(this.co, this.coRadius);
        this.suiteSpecific();
        this.suite1();
    }

    protected void suite1() {
        this.threading();
        this.log();
    }

    protected void suiteSpecific() {
        this.pixelMin = 0.0;
        this.dataMin = 0.0;
        this.pixelMax = 255.0;
        this.dataMax = 255.0;
        this.selected = true;
        this.active = true;
        this.isOldPlan = false;
        this.pixList = new Hashtable(1000);
        if (this.error == null) {
            this.loader = new HealpixLoader();
        }
        this.RGBControl = new int[this.RGBCONTROL.length];
        for (int i = 0; i < this.RGBCONTROL.length; ++i) {
            this.RGBControl[i] = this.RGBCONTROL[i];
        }
        this.aladin.endMsg();
        this.creatDefaultCM();
        this.resetStats();
    }

    protected void setDefaultZoom(Coord c, double radius) {
        this.initZoom = -1.0;
        if (radius > 0.0 && c != null) {
            double projPixelRes = this.projd.rm / 60.0 / this.projd.r;
            double width = this.aladin.view.getCurrentView().getWidth();
            double taille = width * projPixelRes;
            double z = taille / radius;
            this.initZoom = this.aladin.calque.zoom.getNearestZoomFct(z);
        }
        if (this.initZoom == -1.0) {
            this.initZoom = c == null ? 1.0 / (double)(Aladin.OUTREACH ? 64 : 32) : 16.0;
        }
        Aladin.trace(4, "PlanBG.setDefaultZoom(" + c + "," + Coord.getUnit(radius) + ") => zoom = " + this.initZoom);
    }

    protected void log() {
        this.aladin.log(Plan.Tp[this.type], this.label);
    }

    protected void initCache() {
        if (cacheSize == -1L) {
            cacheSize = this.aladin.configuration.getHpxCacheSize();
            Aladin.trace(3, "Cache Size => " + cacheSize);
        }
        if (Aladin.MAXMEM < 50L) {
            Aladin.warning("Full sky Aladin mode requires atleast 64MB of RAM\nWe strongly suggest to adjust the JAVA memory parameter and relaunch Aladin.\nSee the corresponding Aladin FAQ entry available via the Help menu");
        }
    }

    public boolean checkSite(boolean withTrace) {
        if (this.nbCheckSite >= 3) {
            return false;
        }
        if (this.gluTag == null || this.gluTag.startsWith("__")) {
            return false;
        }
        this.aladin.glu.checkIndirection(this.gluTag, "/properties");
        String url1 = "" + this.aladin.glu.getURL(this.gluTag, "", false, true, 1);
        if (url1.equals(this.url)) {
            return false;
        }
        ++this.nbCheckSite;
        if (withTrace) {
            this.aladin.command.console("!!! Dynamic Web server site switching => " + url1);
            Aladin.trace(2, "Plan " + this.label + " Dynamic Web server site switching: from " + this.url + " to " + url1);
        }
        this.url = url1;
        return true;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    protected void planReady(boolean ready) {
        super.planReady(ready);
        this.setPourcent(0.0);
        this.flagOk = ready;
        this.aladin.synchroPlan.stop(this.startingTaskId);
        if (this.co != null) {
            this.aladin.view.setRepere(this.co);
        }
        if (!(this instanceof PlanMoc)) {
            if (this.loadMocNow) {
                new Thread(){

                    @Override
                    public void run() {
                        PlanBG.this.loadMoc();
                    }
                }.start();
            } else if (this.hasMoc()) {
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            PlanBG.this.loadInternalMoc();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }.start();
            }
        }
    }

    @Override
    protected boolean waitForPlan() {
        return this.error == null;
    }

    @Override
    protected void setCM(Object cm) {
        this.cm = (ColorModel)cm;
        this.changeImgID();
    }

    @Override
    protected boolean Free() {
        String stat = this.getShortStats();
        if (stat != null) {
            this.aladin.log("HealpixStats", stat);
        }
        Aladin.trace(4, "PlanBG.Free() stat => " + (stat == null ? "null" : stat));
        this.xy2hpx = null;
        this.hpx2xy = null;
        this.frameOrigin = 0;
        this.FreePixList();
        this.prop = null;
        return super.Free();
    }

    protected void FreePixList() {
        try {
            if (this.pixList != null) {
                Enumeration<HealpixKey> e = this.pixList.elements();
                while (e.hasMoreElements()) {
                    HealpixKey healpix = e.nextElement();
                    if (healpix == null) continue;
                    if (this.useCache && healpix.shouldBeCached()) {
                        healpix.write();
                    }
                    healpix.free();
                }
                this.pixList.clear();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void setPropertie(String prop, String specif, String value) throws Exception {
        if (prop.equalsIgnoreCase("Projection")) {
            Projection p = this.projd;
            this.modifyProj(null, 3, p.alphai, p.deltai, p.rm1, p.cx, p.cy, p.r1, p.rot, p.sym, Projection.getProjType(value), p.system);
            this.aladin.view.newView(1);
            this.aladin.calque.repaintAll();
        } else {
            super.setPropertie(prop, specif, value);
        }
    }

    protected int getPolaScaleFactor() {
        return this.polaScaleFactor;
    }

    protected void setPolaScaleFactor(int polaScaleFactor) {
        this.polaScaleFactor = polaScaleFactor;
    }

    protected void clearBuf() {
        Enumeration<HealpixKey> e = this.pixList.elements();
        while (e.hasMoreElements()) {
            HealpixKey healpix = e.nextElement();
            if (healpix == null) continue;
            healpix.clearBuf();
        }
        this.gc();
    }

    @Override
    protected boolean pixelsOriginIntoCache() {
        if (this.flagClearBuf) {
            return true;
        }
        this.clearBuf();
        this.changeImgID();
        this.flagClearBuf = true;
        return true;
    }

    @Override
    protected boolean hasOriginalPixels() {
        return this.isTruePixels();
    }

    @Override
    protected boolean recut(double min, double max, boolean autocut) {
        this.FreePixList();
        this.changeImgID();
        double tmpRangeMin = this.dataMin;
        double tmpRangeMax = this.dataMax;
        this.findMinMax(this.pixelsOrigin, this.bitpix, this.width, this.height, min, max, autocut, 0, 0, 0, 0);
        if (tmpRangeMin != tmpRangeMax) {
            this.dataMin = tmpRangeMin;
            this.dataMax = tmpRangeMax;
        }
        int size = this.pixelsOrigin.length / (Math.abs(this.bitpix) / 8);
        if (this.pixels == null || this.pixels.length != size) {
            this.pixels = new byte[size];
        }
        this.to8bits(this.pixels, 0, this.pixelsOrigin, size, this.bitpix, this.pixelMin, this.pixelMax, false);
        this.resetHist();
        return true;
    }

    protected void setMem() {
    }

    @Override
    protected boolean setActivated(boolean flag) {
        if (flag && this.aladin.calque.hasHpxGrid()) {
            System.out.println(this.getStats());
        }
        return super.setActivated(flag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getCacheName() {
        if (this.cacheName != null) {
            return this.cacheName;
        }
        try {
            MyProperties prop = new MyProperties();
            String urlFile = this.url + "/" + "properties";
            MyInputStream in = null;
            try {
                in = Util.openAnyStream(urlFile);
                prop.load(in);
            }
            finally {
                if (in != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (Exception e) {}
                }
            }
            String s = prop.getProperty("publisher_did");
            if (s == null) {
                s = prop.getProperty("label");
            }
            if (s.startsWith("ivo://")) {
                s = s.substring(6);
            }
            s = s.replace("/", "_");
            this.cacheName = s = s.replace("\\", "_");
        }
        catch (Exception e) {
            this.cacheName = this.survey + this.version;
        }
        Aladin.trace(4, "getCacheName(): Cache name = [" + this.cacheName + "]");
        return this.cacheName;
    }

    protected String getCacheDir() {
        if (this.flagCache) {
            return this.dirCache;
        }
        this.flagCache = true;
        if (!this.aladin.createCache()) {
            return null;
        }
        String dir = System.getProperty("user.home") + Util.FS + Aladin.CACHE + Util.FS + "Cache";
        File f = new File(dir);
        if (!f.isDirectory() && !f.mkdir()) {
            return null;
        }
        f = new File(dir = dir + Util.FS + CACHE);
        if (!f.isDirectory() && !f.mkdir()) {
            return null;
        }
        this.dirCache = dir;
        return dir;
    }

    protected static String getCacheDirStatic() {
        return System.getProperty("user.home") + Util.FS + Aladin.CACHE + Util.FS + "Cache" + Util.FS + CACHE;
    }

    protected static void setMaxCacheSize(long maxCacheSize) {
        if (maxCacheSize < 524288L) {
            maxCacheSize = 524288L;
        }
        MAXCACHE = maxCacheSize;
        Aladin.trace(4, "PlanBG.setMaxCacheSize() => " + MAXCACHE / 1024L + "MB");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static long getCacheSize() {
        Object object = cacheLock;
        synchronized (object) {
            return cacheSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addInCache(long size) {
        Object object = cacheLock;
        synchronized (object) {
            cacheSize += size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setCacheSize(long size) {
        Object object = cacheLock;
        synchronized (object) {
            cacheSize = size;
        }
    }

    static synchronized void scanCache() {
        if (cacheSize != -1L && cacheSize < MAXCACHE) {
            return;
        }
        if (scanCache != null) {
            return;
        }
        scanCache = new Thread("Scan cache"){

            @Override
            public void run() {
                3.currentThread().setPriority(1);
                long size = 0L;
                long t = System.currentTimeMillis();
                String dir = PlanBG.getCacheDirStatic();
                if (dir == null) {
                    size = 0L;
                    PlanBG.setCacheSize(0L);
                    return;
                }
                Aladin.trace(3, "Scanning allsky cache...");
                File[] fold = new File(dir).listFiles();
                for (int i = 0; i < fold.length; ++i) {
                    if (!fold[i].isDirectory() || !fold[i].getName().endsWith(".old")) continue;
                    Aladin.trace(4, "PlanBG.scanCache(): removing folder " + fold[i].getName() + "...");
                    Util.deleteDir(fold[i]);
                }
                Vector<File> listCache = new Vector<File>(2000);
                size = PlanBG.getCacheSize(new File(dir), listCache);
                size += PlanBG.getCacheSizePlanHealpix(new File(PlanHealpix.getCacheDirPath()), listCache);
                Collections.sort(listCache, new Comparator(){

                    public int compare(Object o1, Object o2) {
                        long t2;
                        long t1 = ((File)o1).lastModified();
                        return t1 == (t2 = ((File)o2).lastModified()) ? 0 : (t1 > t2 ? 1 : -1);
                    }
                });
                Enumeration<File> e = listCache.elements();
                while (e.hasMoreElements() && size > 3L * MAXCACHE / 4L) {
                    File f = e.nextElement();
                    if (size <= 3L * MAXCACHE / 4L) continue;
                    Aladin.trace(4, "PlanBG.scanCache(): removing " + f + " (" + f.lastModified() + ")");
                    if (f.isFile()) {
                        size -= f.length() / 1024L;
                        f.delete();
                        continue;
                    }
                    if (!f.isDirectory()) continue;
                    long dirSize = Util.dirSize(f) / 1024L;
                    size -= dirSize;
                    Util.deleteDir(f);
                }
                Aladin.trace(3, " => Cache size=" + size / 1024L + "MB maxCache=" + MAXCACHE / 1024L + "MB scan in " + (System.currentTimeMillis() - t) + "ms");
                PlanBG.setCacheSize(size);
                scanCache = null;
            }
        };
        scanCache.start();
    }

    static void clearCache() {
        String dir = PlanBG.getCacheDirStatic();
        if (dir != null) {
            Util.deleteDir(new File(dir));
        }
        if ((dir = PlanHealpix.getCacheDirPath()) != null) {
            Util.deleteDir(new File(dir));
        }
        PlanBG.setCacheSize(0L);
    }

    public static long getCacheSize(File dir, Vector<File> listCache) {
        long size = 0L;
        File[] f = dir.listFiles();
        for (int i = 0; f != null && i < f.length; ++i) {
            if (++NBFILE % 100L == 0L) {
                Util.pause(50);
            }
            if (f[i].isDirectory()) {
                long n = PlanBG.getCacheSize(f[i], listCache);
                if (n == 0L) {
                    f[i].delete();
                    continue;
                }
                size += n;
                continue;
            }
            size += f[i].length() / 1024L;
            if (listCache == null) continue;
            listCache.addElement(f[i]);
        }
        return size;
    }

    private static long getCacheSizePlanHealpix(File dir, Vector<File> listCache) {
        File[] f = dir.listFiles();
        long size = 0L;
        for (int i = 0; f != null && i < f.length; ++i) {
            if (!f[i].isDirectory()) continue;
            size += Util.dirSize(f[i]);
            listCache.addElement(f[i]);
            Util.pause(100);
        }
        return size / 1024L;
    }

    protected String key(HealpixKey h) {
        return this.key(h.order, h.npix, h.z);
    }

    protected String key(int order, long npix) {
        return order + "/" + npix;
    }

    protected String key(int order, long npix, int z) {
        return order + "/" + npix + (z <= 0 ? "" : "_" + z);
    }

    public HealpixKey askForHealpix(int order, long npix) {
        this.readyAfterDraw = false;
        HealpixKey pixAsk = this.drawMode == 1 ? new HealpixKeyPol(this, order, npix) : new HealpixKey(this, order, npix);
        this.pixList.put(this.key(order, npix), pixAsk);
        return pixAsk;
    }

    protected void gc() {
        if (System.currentTimeMillis() - this.lastGc < 1000L) {
            return;
        }
        if (this.aladin.enoughMemory()) {
            if (this.memCpt) {
                this.lastMemP = Runtime.getRuntime().freeMemory();
            } else {
                this.lastMemI = Runtime.getRuntime().freeMemory();
            }
            if (Math.abs(this.lastMemP - this.lastMemI) < (long)MEMREQUIREDFORGC) {
                return;
            }
        }
        new Thread("gc"){

            @Override
            public void run() {
                PlanBG.this.memCpt = !PlanBG.this.memCpt;
                PlanBG.this.nbFlush = 0;
                System.runFinalization();
                System.gc();
                PlanBG.this.lastGc = System.currentTimeMillis();
                PlanBG.this.aladin.setMemory();
            }
        }.start();
    }

    protected void purge(HealpixKey healpix) {
        this.nbFlush += healpix.free();
        if (this.nbFlush > 20) {
            this.gc();
        }
        this.pixList.remove(this.key(healpix));
    }

    protected void tryWakeUp() {
        this.loader.wakeUp();
    }

    protected HealpixKey getHealpixLowLevel(int order, long npix, int z, int mode) {
        HealpixKey h = this.pixList.get(this.key(order, npix, z));
        if (h == null) {
            h = new HealpixKey(this, order, npix, z, mode);
            this.pixList.put(this.key(order, npix, z), h);
        }
        if (h.getStatus() != 6) {
            return null;
        }
        return h;
    }

    protected HealpixKey getHealpix(int order, long npix, boolean flagLoad) {
        return this.getHealpix(order, npix, (int)this.getZ(), flagLoad);
    }

    protected HealpixKey getHealpix(int order, long npix, int z, boolean flagLoad) {
        HealpixKey healpix = this.pixList.get(this.key(order, npix, z));
        if (healpix != null) {
            return healpix;
        }
        if (healpix == null && (healpix = this.getHealpixFromAllSky(order, npix)) != null) {
            return healpix;
        }
        if (flagLoad) {
            return this.askForHealpix(order, npix);
        }
        return null;
    }

    protected HealpixKey getHealpixFromAllSky(int order, long npix) {
        if (order != 3) {
            return null;
        }
        HealpixKey allsky = this.pixList.get(this.key(3, -1L));
        if (allsky == null || allsky.getStatus() != 6) {
            return null;
        }
        int orderLosange = this.getTileOrder();
        if (orderLosange > 0 && orderLosange <= this.getAllSkyOrder(allsky)) {
            HealpixKey[] list = allsky.getPixList();
            if (list == null) {
                return null;
            }
            HealpixKey healpix = list[(int)npix];
            if (healpix != null) {
                if (this.firstSubtil) {
                    Aladin.trace(4, "PlanBG.getHealpix " + this.label + " will use Allsky for order 3 diamonds!");
                    this.firstSubtil = false;
                }
                return healpix;
            }
        }
        return null;
    }

    static long[] getNpixList(int order, Coord center, double radius) throws Exception {
        return CDSHealpix.query_disc(CDSHealpix.pow2(order), center.al, center.del, Math.toRadians(radius));
    }

    protected Coord getCooCentre(ViewSimple v) {
        Coord center = v.getCooCentre();
        if (center == null) {
            return null;
        }
        center = Localisation.frameToFrame(center, 0, this.frameOrigin);
        return center;
    }

    protected long[] getPixListView(ViewSimple v, int order) {
        return this.getPixList(v, null, order);
    }

    protected long[] getPixList(ViewSimple v, Coord center, int order) {
        long nside = CDSHealpix.pow2(order);
        double r1 = CDSHealpix.pixRes(nside) / 3600.0;
        double r2 = Math.max(v.getTailleRA(), v.getTailleDE());
        double radius = Math.max(r1, r2);
        try {
            if (center == null) {
                center = this.getCooCentre(v);
            }
            return this.filterByMoc(PlanBG.getNpixList(order, center, radius), order);
        }
        catch (Exception e) {
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            return new long[0];
        }
    }

    private long[] filterByMoc(long[] pix, int order) {
        if (this.moc == null) {
            return pix;
        }
        int j = 0;
        for (int i = 0; i < pix.length; ++i) {
            if (!this.moc.isIntersecting(order, pix[i])) continue;
            if (j < i) {
                pix[j] = pix[i];
            }
            ++j;
        }
        if (j == pix.length) {
            return pix;
        }
        long[] p = new long[j];
        System.arraycopy(pix, 0, p, 0, j);
        return p;
    }

    protected int getTileOrder() {
        if (this.tileOrder == -1) {
            return 9;
        }
        return this.tileOrder;
    }

    protected void setTileOrder(int tileOrder) {
        if (this.tileOrder != -1 || tileOrder <= 0) {
            return;
        }
        this.tileOrder = tileOrder;
    }

    protected int getAllSkyOrder(HealpixKey allsky) {
        HealpixKey[] healpix;
        if (this.allSkyOrder == -1 && allsky != null && (healpix = allsky.getPixList()) != null) {
            this.allSkyOrder = healpix[0].getLosangeOrder();
        }
        return this.allSkyOrder;
    }

    @Override
    protected boolean pixelsOriginFromDisk() {
        return this.flagOk && !this.color && this.isTruePixels();
    }

    protected int getOrder() {
        return Math.max(3, Math.min(this.maxOrder(), this.maxOrder));
    }

    protected int maxOrder() {
        ViewSimple v = this.aladin.view.getCurrentView();
        return this.maxOrder(v);
    }

    public String getSurveyDir() {
        if (this.local) {
            return this.url;
        }
        return this.getCacheDir() + Util.FS + this.getCacheName();
    }

    protected String getPixelInfo(double x, double y, int mode) {
        if (!this.pixelsOriginFromDisk() || mode != 1) {
            return "";
        }
        double pixel = this.getPixelInDouble(x, y);
        if (Double.isNaN(pixel)) {
            return "";
        }
        return this.Y(pixel);
    }

    @Override
    public int getPixel8(int x, int y) {
        double pix = this.getPixelInDouble(x, y);
        return (int)((pix - this.pixelMin) * 256.0 / (this.pixelMax - this.pixelMin));
    }

    @Override
    protected double getPixelOriginInDouble(int x, int y) {
        return this.getPixelInDouble(x, y);
    }

    @Override
    protected double getPixelInDouble(int x, int y) {
        return this.getPixelInDouble((double)x, (double)y);
    }

    protected double getPixelInDouble(double x, double y) {
        if (!this.pixelsOriginFromDisk()) {
            return Double.NaN;
        }
        int bitpix = this.getBitpix();
        int mynpix = Math.abs(bitpix) / 8;
        byte[] onePixelOrigin = new byte[mynpix];
        if (!this.getOnePixelFromCache(onePixelOrigin, x, y)) {
            return Double.NaN;
        }
        return this.getPixVal(onePixelOrigin, bitpix, 0) * this.bScale + this.bZero;
    }

    protected boolean getOnePixelFromCache(byte[] pixels, double x, double y) {
        return this.getOnePixelFromCache(this.projd, pixels, x, y);
    }

    protected boolean getOnePixelFromCache(Projection projd, byte[] pixels, double x, double y) {
        double val = this.getOnePixelFromCache(projd, x, y);
        if (Double.isNaN(val)) {
            return false;
        }
        PlanBG.setPixVal(pixels, this.getBitpix(), 0, val);
        return true;
    }

    protected double getOnePixelFromCache(Projection projd, double x, double y) {
        return this.getOnePixelFromCache(projd, x, y, -1, 2);
    }

    protected double getOnePixelFromCache(Projection projd, double x, double y, int order, int mode) {
        return this.getOnePixelFromCache(projd, x, y, order, (int)this.getZ(), mode);
    }

    protected double getOnePixelFromCache(Projection projd, double x, double y, int order, int z, int mode) {
        double pixel;
        block4: {
            pixel = Double.NaN;
            if (order <= 0) {
                order = this.getOrder();
            }
            int nSideFile = (int)CDSHealpix.pow2(order);
            try {
                Coord coo = new Coord();
                coo.x = x;
                coo.y = y;
                projd.getCoord(coo);
                coo = Localisation.frameToFrame(coo, 0, this.frameOrigin);
                if (Double.isNaN(coo.al) || Double.isNaN(coo.del)) {
                    return Double.NaN;
                }
                double[] polar = CDSHealpix.radecToPolar(new double[]{coo.al, coo.del});
                long npixFile = CDSHealpix.ang2pix_nest(nSideFile, polar[0], polar[1]);
                pixel = this.getHealpixPixel(order, npixFile, polar[0], polar[1], z, mode);
            }
            catch (Exception e) {
                if (Aladin.levelTrace < 3) break block4;
                e.printStackTrace();
            }
        }
        return pixel;
    }

    protected double getHealpixPixel(int orderFile, long npixFile, double theta, double phi, int z, int mode) {
        HealpixKey h;
        HealpixKey healpixKey = mode == 3 ? this.pixList.get(this.key(orderFile, npixFile, z)) : (h = this.getHealpixLowLevel(orderFile, npixFile, z, mode == 0 ? 2 : 3));
        if (h == null || h.getStatus() != 6) {
            return Double.NaN;
        }
        long nside = (long)h.width * CDSHealpix.pow2(h.order);
        try {
            long healpixIdxPixel = CDSHealpix.ang2pix_nest(nside, theta, phi);
            return h.getPixelValue(healpixIdxPixel, mode);
        }
        catch (Exception e) {
            return Double.NaN;
        }
    }

    protected double getHealpixPixel(int orderFile, long npixFile, long healpixIdxPixel, int mode) {
        HealpixKey h = this.getHealpixLowLevel(orderFile, npixFile, (int)this.getZ(), mode == 0 ? 2 : 3);
        if (h == null) {
            return Double.NaN;
        }
        return h.getPixelValue(healpixIdxPixel, mode);
    }

    protected double getHealpixClosestPixel(double ra, double dec, int order) {
        double pixel;
        block4: {
            pixel = Double.NaN;
            int nSideFile = (int)CDSHealpix.pow2(order);
            try {
                double[] polar = CDSHealpix.radecToPolar(new double[]{ra, dec});
                long npixFile = CDSHealpix.ang2pix_nest(nSideFile, polar[0], polar[1]);
                HealpixKey h = this.getHealpixLowLevel(order, npixFile, (int)this.getZ(), 2);
                if (h == null) {
                    return Double.NaN;
                }
                long nside = (long)h.width * CDSHealpix.pow2(h.order);
                long npixPixel = CDSHealpix.ang2pix_nest(nside, polar[0], polar[1]);
                HealpixKey h1 = this.getHealpixLowLevel(order, npixFile, (int)this.getZ(), 2);
                if (h1 == null) {
                    return Double.NaN;
                }
                pixel = h1.getPixelValue(npixPixel, 0);
            }
            catch (Exception e) {
                if (Aladin.levelTrace < 3) break block4;
                e.printStackTrace();
            }
        }
        return pixel;
    }

    protected double getHealpixLinearPixel(double ra, double dec, double ra1, double dec1, int order) {
        double pixel;
        block9: {
            pixel = Double.NaN;
            int nSideFile = (int)CDSHealpix.pow2(order);
            try {
                int m;
                double[] polar = CDSHealpix.radecToPolar(new double[]{ra, dec});
                double[] polar1 = CDSHealpix.radecToPolar(new double[]{ra1, dec1});
                long npixFile = CDSHealpix.ang2pix_nest(nSideFile, polar[0], polar[1]);
                HealpixKey h = this.getHealpixLowLevel(order, npixFile, (int)this.getZ(), 2);
                if (h == null) {
                    return Double.NaN;
                }
                long nside = (long)h.width * CDSHealpix.pow2(h.order);
                long npixPixel = CDSHealpix.ang2pix_nest(nside, polar[0], polar[1]);
                long[] voisins = CDSHealpix.neighbours(nside, npixPixel);
                for (int i = m = 4; i >= 1; --i) {
                    voisins[i] = voisins[i - 1];
                }
                voisins[0] = npixPixel;
                double totalPixel = 0.0;
                double totalCoef = 0.0;
                for (int i = 0; i < m; ++i) {
                    HealpixKey h1 = h;
                    long nlpix = voisins[i];
                    long startIdx = h.npix * (long)h.width * (long)h.width;
                    long pixOffset = nlpix - startIdx;
                    if (pixOffset < 0L || pixOffset >= (long)(h.width * h.width)) {
                        long npixFile1 = nlpix / (long)(h.width * h.width);
                        HealpixKey htmp = this.getHealpixLowLevel(order, npixFile1, (int)this.getZ(), 2);
                        if (htmp == null) continue;
                        h1 = htmp;
                    }
                    try {
                        double pix = h1.getPixelValue(nlpix, 0);
                        if (Double.isNaN(pix)) continue;
                        double[] polar2 = CDSHealpix.pix2ang_nest(nside, nlpix);
                        double coef = Coo.distance(polar1[0], polar1[1], polar2[0], polar2[1]);
                        if (coef == 0.0) {
                            return pix;
                        }
                        double c = 1.0 / coef;
                        totalPixel += pix * c;
                        totalCoef += c;
                        continue;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                pixel = totalPixel / totalCoef;
            }
            catch (Exception e) {
                if (Aladin.levelTrace < 3) break block9;
                e.printStackTrace();
            }
        }
        return pixel;
    }

    public static String getFilePath(String survey, int order, long npix) {
        return survey + Util.FS + "Norder" + order + Util.FS + "Dir" + npix / 10000L * 10000L + Util.FS + "Npix" + npix;
    }

    private static void fillUp(int[] npix, int nsize, int[] pos) {
        int i;
        int size = nsize * nsize;
        int[][] fils = new int[4][size / 4];
        int[] nb = new int[4];
        for (i = 0; i < size; ++i) {
            int dg = i % nsize < nsize / 2 ? 0 : 1;
            int bh = i < size / 2 ? 1 : 0;
            int quad = dg << 1 | bh;
            int j = pos == null ? i : pos[i];
            npix[j] = npix[j] << 2 | quad;
            int n = quad;
            int n2 = nb[n];
            nb[n] = n2 + 1;
            fils[quad][n2] = j;
        }
        if (size > 4) {
            for (i = 0; i < 4; ++i) {
                PlanBG.fillUp(npix, nsize / 2, fils[i]);
            }
        }
    }

    protected void createHealpixOrder(int order) throws Exception {
        if (order == 0) {
            this.hpx2xy = new int[]{0};
            this.xy2hpx = this.hpx2xy;
            return;
        }
        int nsize = (int)CDSHealpix.pow2(order);
        if (CDSHealpix.log2(nsize) != (long)order) {
            throw new Exception("Only HEALPix order power of 2 are supported");
        }
        this.xy2hpx = new int[nsize * nsize];
        this.hpx2xy = new int[nsize * nsize];
        PlanBG.fillUp(this.xy2hpx, nsize, null);
        for (int i = 0; i < this.xy2hpx.length; ++i) {
            this.hpx2xy[this.xy2hpx[i]] = i;
        }
    }

    public final int xy2hpx(int hpxOffset) {
        return this.xy2hpx[hpxOffset];
    }

    public final int hpx2xy(int xyOffset) {
        return this.hpx2xy[xyOffset];
    }

    protected void touchCache() {
        long t = System.currentTimeMillis();
        if (t - this.lastTouch < 60000L) {
            return;
        }
        this.lastTouch = t;
        String pathName = this.getCacheDir() + Util.FS + this.getCacheName();
        new File(pathName).setLastModified(t);
        Date d = new Date();
        d.setTime(this.lastTouch);
        Aladin.trace(4, "PlanBG.touchCache() : Date:" + d + " => " + pathName);
    }

    protected int maxOrder(ViewSimple v) {
        long iz = v.getIZ();
        if (this.lastIz == iz) {
            return this.lastMaxOrder;
        }
        this.lastIz = iz;
        int myOrder = this.getTileOrder();
        if (this.RES == null || this.oLosangeOrder != myOrder) {
            this.oLosangeOrder = myOrder;
            if (this.RES == null) {
                this.RES = new double[20];
            }
            this.lastMaxOrder = 0;
            while (this.lastMaxOrder < 20) {
                long nside = CDSHealpix.pow2(this.lastMaxOrder + myOrder + 1);
                this.RES[this.lastMaxOrder] = CDSHealpix.pixRes(nside) / 3600.0;
                ++this.lastMaxOrder;
            }
        }
        double pixSize = v.getPixelSize();
        this.lastMaxOrder = 1;
        while (this.lastMaxOrder < this.RES.length && this.RES[this.lastMaxOrder] > pixSize) {
            ++this.lastMaxOrder;
        }
        this.lastMaxOrder = this.adjustMaxOrder(this.lastMaxOrder, pixSize);
        return this.lastMaxOrder;
    }

    protected int adjustMaxOrder(int lastMaxOrder, double pixSize) {
        if (lastMaxOrder <= 2 && pixSize < 0.06) {
            lastMaxOrder = 3;
        }
        return lastMaxOrder;
    }

    protected String getFormat() {
        if (this.color) {
            if (this.inFits) {
                return "FITS RGB color";
            }
            return (this.colorPNG || this.inPNG ? "PNG" : "JPEG") + " color";
        }
        if (this.truePixels) {
            return "FITS true pixels (BITPIX=" + this.bitpix + ")";
        }
        return (this.colorPNG || this.inPNG ? "PNG" : "JPEG") + " 8 bits pixels";
    }

    protected void switchFormat() {
        this.truePixels = !this.truePixels;
        this.forceReload();
        if (this.aladin.frameCM != null) {
            this.aladin.frameCM.majCM(true);
        }
    }

    public void forceReload() {
        this.FreePixList();
        this.changeImgID();
        this.flagRecut = true;
        this.flagRecutCoo = new Coord(this.aladin.view.repere.raj, this.aladin.view.repere.dej);
        this.flagRecutRadius = this.aladin.view.getCurrentView().getTaille() / 2.0;
        this.resetHist();
    }

    protected String getMaxResolution() {
        return Coord.getUnit(this.getPixelResolution());
    }

    public int getMaxFileOrder() {
        return this.maxOrder;
    }

    public int getMaxHealpixOrder() {
        return this.maxOrder + this.getTileOrder();
    }

    public double getPixelResolution() {
        long nside = CDSHealpix.pow2(this.getMaxHealpixOrder());
        return CDSHealpix.pixRes(nside) / 3600.0;
    }

    protected boolean isFullyDrawn() {
        return this.isDrawn() && this.allWaitingKeysDrawn;
    }

    protected boolean isDrawn() {
        return this.readyDone;
    }

    protected boolean isLoading() {
        return !this.loader.isReadyForDrawing();
    }

    protected boolean hasMoreDetails() {
        return this.hasMoreDetails;
    }

    protected String getInfoDetails() {
        return this.getOrder() + "/" + this.maxOrder;
    }

    protected void setHasMoreDetails(boolean flag) {
        this.hasMoreDetails = flag;
    }

    @Override
    protected boolean isSync() {
        if (this.error != null) {
            Aladin.trace(4, "PlanBG.isSync()=true:" + this.label + " => in error (error!=null)");
            return true;
        }
        if (!this.flagOk) {
            Aladin.trace(4, "PlanBG.isSync()=false: " + this.label + " => not ready (!flagOk)");
            return false;
        }
        if (!this.active) {
            Aladin.trace(4, "PlanBG.isSync()=true: " + this.label + "=> not active (!active)");
            return true;
        }
        if (this.getOpacityLevel() == 0.0f && !this.ref) {
            Aladin.trace(4, "PlanBG.isSync()=true: " + this.label + "=> transparent (!ref && opacity=" + this.getOpacityLevel() + ")");
            return true;
        }
        if (this.flagProcessing) {
            Aladin.trace(4, "PlanBG.isSync()=false: " + this.label + "=> is processing (flagProcessing)");
            return false;
        }
        if (this.isLoading()) {
            Aladin.trace(4, "PlanBG.isSync()=false: " + this.label + "=> is loading (isLoading())");
            return false;
        }
        return true;
    }

    @Override
    public boolean isCube() {
        return this.cube;
    }

    public boolean isColored() {
        return this.color;
    }

    public boolean isTruePixels() {
        return this.truePixels;
    }

    public boolean isLocalAllSky() {
        return this.local;
    }

    private boolean childrenReady(HealpixKey healpix, ViewSimple v) {
        int order = healpix.order + 1;
        this.children = healpix.getChildren(this.children);
        for (int i = 0; i < 4; ++i) {
            if (this.isOutMoc(order, this.children[i])) continue;
            HealpixKey fils = this.getHealpix(order, this.children[i], healpix.z, false);
            if (fils == null) {
                fils = new HealpixKey(this, order, this.children[i], 0);
            }
            if (fils.isOutView(v) || fils.getStatus() == 6) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void modifyProj(String label, int modeCalib, double alphai, double deltai, double rm, double cx, double cy, double r, double rot, boolean sym, int t, int system) {
        super.modifyProj(label, modeCalib, alphai, deltai, rm, cx, cy, r, rot, sym, t, system);
    }

    protected int isDebugIn(long pix) {
        if (!DEBUGMODE) {
            return 0;
        }
        int n = 0;
        if (this.pixDebugIn.length == 0) {
            return 0;
        }
        for (int i = 0; i < this.pixDebugIn.length; ++i) {
            if (pix != this.pixDebugIn[i]) continue;
            ++n;
        }
        return n;
    }

    protected void loadAllSkyNow() {
        HealpixKey allsky = this.pixList.get(this.key(3, -1L));
        if (allsky == null) {
            allsky = new HealpixAllsky(this, 3);
            this.pixList.put(this.key(allsky), allsky);
            try {
                allsky.loadNow();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected boolean drawAllSky(Graphics g, ViewSimple v) {
        boolean hasDrawnSomething;
        block20: {
            block19: {
                block21: {
                    boolean partial;
                    int status;
                    hasDrawnSomething = false;
                    int z = (int)this.getZ(v);
                    HealpixKey allsky = this.pixList.get(this.key(3, -1L, z));
                    if (allsky == null) {
                        allsky = this.drawMode == 1 ? new HealpixAllskyPol(this, 3) : new HealpixAllsky(this, 3, z);
                        this.pixList.put(this.key(allsky), allsky);
                        if (this.local) {
                            allsky.loadFromNet();
                        } else {
                            if (!this.useCache || !allsky.isCached()) {
                                this.tryWakeUp();
                                if (v.pref == this) {
                                    this.drawBackground(g, v);
                                }
                                return true;
                            }
                            allsky.loadFromCache();
                        }
                    }
                    if ((status = allsky.getStatus()) == 7) {
                        return false;
                    }
                    if (status != 6) break block19;
                    allsky.resetTimer();
                    this.statNbItems = 0L;
                    double taille = Math.min(v.getTailleRA(), v.getTailleDE());
                    boolean bl = partial = taille < 40.0 && !v.isAllSky();
                    if (partial) {
                        long[] pixList = this.getPixList(v, null, 3);
                        for (int i = 0; i < pixList.length; ++i) {
                            HealpixKey healpix = allsky.getPixList()[(int)pixList[i]];
                            if (healpix == null || this.isOutMoc(healpix.order, healpix.npix) || healpix.isOutView(v)) continue;
                            if (this.drawMode == 0) {
                                healpix.draw(g, v);
                            } else if (this.drawMode == 1) {
                                ((HealpixKeyPol)healpix).drawPolarisation(g, v);
                            }
                            ++this.statNbItems;
                            hasDrawnSomething = true;
                        }
                    } else {
                        HealpixKey[] allSkyPixList = allsky.getPixList();
                        for (int i = 0; i < allSkyPixList.length; ++i) {
                            HealpixKey healpix = allSkyPixList[i];
                            if (healpix == null || this.isOutMoc(healpix.order, healpix.npix) || healpix.isOutView(v)) continue;
                            if (this.drawMode == 0) {
                                healpix.draw(g, v);
                            } else if (this.drawMode == 1) {
                                ((HealpixKeyPol)healpix).drawPolarisation(g, v);
                            }
                            ++this.statNbItems;
                            hasDrawnSomething = true;
                        }
                    }
                    if (!Aladin.macPlateform) break block20;
                    if (Aladin.ISJVM15) break block21;
                    if (!Aladin.ISJVM16) break block20;
                }
                g.setColor(Color.red);
                g.drawString("Warning: Java1.5 & 1.6 under Mac is bugged.", 5, 30);
                g.drawString("Please update your java.", 5, 45);
                break block20;
            }
            if (this.drawMode == 0) {
                g.setColor(Color.red);
                g.drawString("Whole sky in progress...", 5, 30);
            }
        }
        return hasDrawnSomething;
    }

    protected void getCurrentBufPixels(PlanImage pi, RectangleD rcrop, double zoom, double resMult, boolean fullRes) {
        int order;
        int w = (int)Math.round(rcrop.width * zoom);
        int h = (int)Math.round(rcrop.height * zoom);
        int bitpix = this.getBitpix() == -64 ? -64 : -32;
        int npix = Math.abs(bitpix) / 8;
        byte[] pixelsOrigin = new byte[w * h * npix];
        byte[] onePixelOrigin = new byte[npix];
        double blank = Double.NaN;
        boolean flagClosest = false;
        boolean testClosest = false;
        int a = order = fullRes ? this.maxOrder : (int)((double)this.getOrder() * resMult);
        if (order < 3) {
            order = 3;
        } else if (order > this.maxOrder) {
            order = this.maxOrder;
        }
        int offset = 0;
        double fct = 100.0 / (double)h;
        Coord coo = new Coord();
        Coord coo1 = new Coord();
        block0: for (int y = h - 1; y >= 0; --y) {
            pi.pourcent += fct;
            for (int x = 0; x < w; ++x) {
                double val;
                double x1 = rcrop.x + ((double)x + 0.5) / zoom;
                double y1 = rcrop.y + (double)y / zoom;
                coo.x = x1;
                coo.y = y1;
                pi.projd.getCoord(coo);
                coo = Localisation.frameToFrame(coo, 0, this.frameOrigin);
                double x2 = rcrop.x + (double)(x + 1) / zoom;
                double y2 = rcrop.y + (double)y / zoom;
                coo1.x = x2;
                coo1.y = y2;
                pi.projd.getCoord(coo1);
                coo1 = Localisation.frameToFrame(coo1, 0, this.frameOrigin);
                if (!testClosest) {
                    double resSrc;
                    testClosest = true;
                    double resDest = Coo.distance(coo.al, coo.del, coo1.al, coo1.del) * 2.0;
                    if (resDest < (resSrc = this.getPixelResolution()) / 2.0) {
                        flagClosest = true;
                    }
                }
                if (Double.isNaN(val = Double.isNaN(coo.al) || Double.isNaN(coo.del) ? Double.NaN : (flagClosest ? this.getHealpixClosestPixel(coo1.al, coo1.del, order) : this.getHealpixLinearPixel(coo.al, coo.del, coo1.al, coo1.del, order)))) {
                    PlanBG.setPixVal(onePixelOrigin, bitpix, 0, blank);
                    if (!pi.isBlank) {
                        pi.isBlank = true;
                        pi.blank = blank;
                        if (bitpix > 0 && pi.headerFits != null) {
                            pi.headerFits.setKeyValue("BLANK", blank + "");
                        }
                    }
                } else {
                    val = val * this.bScale + this.bZero;
                    PlanBG.setPixVal(onePixelOrigin, bitpix, 0, val);
                }
                System.arraycopy(onePixelOrigin, 0, pixelsOrigin, offset, npix);
                if ((offset += npix) > pixelsOrigin.length) continue block0;
            }
        }
        pi.bitpix = bitpix;
        pi.pixelsOrigin = pixelsOrigin;
        pi.dataMin = this.dataMin * this.bScale + this.bZero;
        pi.dataMax = this.dataMax * this.bScale + this.bZero;
        pi.pixelMin = this.pixelMin * this.bScale + this.bZero;
        pi.pixelMax = this.pixelMax * this.bScale + this.bZero;
        pi.bScale = 1.0;
        pi.bZero = 0.0;
        pi.pixels = this.getPix8Bits(null, pi.pixelsOrigin, pi.bitpix, pi.width, pi.height, pi.pixelMin, pi.pixelMax, false, 0, 0, 0);
        PlanImage.invImageLine(pi.width, pi.height, pi.pixels);
        pi.colorBackground = Color.white;
    }

    protected byte[] getBufPixels8(ViewSimple v) {
        return this.getPixels8Area(v, new RectangleD(0.0, 0.0, v.rv.width, v.rv.height), true);
    }

    protected byte[] getPixels8Area(ViewSimple v, RectangleD rcrop, boolean now) {
        int[] rgb = this.getPixelsRGBArea(v, rcrop, now);
        if (rgb == null) {
            return null;
        }
        int taille = rgb.length;
        byte[] pixels = new byte[taille];
        for (int i = 0; i < taille; ++i) {
            if ((rgb[i] >>> 24 & 0xFF) == 0) {
                pixels[i] = 0;
                continue;
            }
            int pix = rgb[i] & 0xFF;
            if (pix < 255) {
                ++pix;
            }
            pixels[i] = (byte)(pix & 0xFF);
        }
        rgb = null;
        return pixels;
    }

    protected int[] getPixelsRGBArea(ViewSimple v, RectangleD rcrop, boolean now) {
        int y;
        if (v == null) {
            return null;
        }
        BufferedImage imgBuf = new BufferedImage(v.rv.width, v.rv.height, 2);
        Graphics g = imgBuf.getGraphics();
        this.drawLosanges(g, v, now);
        g.finalize();
        g = null;
        int width = (int)Math.ceil(rcrop.width);
        int height = (int)Math.ceil(rcrop.height);
        int taille = width * height;
        int[] rgb = new int[taille];
        int x = (int)Math.floor(rcrop.x);
        if (x < 0) {
            x = 0;
        }
        if ((y = (int)Math.floor(rcrop.y)) < 0) {
            y = 0;
        }
        imgBuf.getRGB(x, y, width, height, rgb, 0, width);
        imgBuf.flush();
        imgBuf = null;
        return rgb;
    }

    @Override
    protected Image getImage(ViewSimple v, boolean now) {
        if (now) {
            BufferedImage img = new BufferedImage(v.rv.width, v.rv.height, 3);
            Graphics g = img.getGraphics();
            v.drawBackground(g);
            this.drawLosanges(g, v, now);
            this.adjustCM(img);
            g.dispose();
            return img;
        }
        if (v.imageBG != null && v.ovizBG == v.iz && v.oImgIDBG == this.imgID && v.rv.width == v.owidthBG && v.rv.height == v.oheightBG) {
            return v.imageBG;
        }
        if (v.imageBG == null || v.rv.width != v.owidthBG || v.rv.height != v.oheightBG) {
            if (v.imageBG != null) {
                v.imageBG.flush();
            }
            if (v.g2BG != null) {
                v.g2BG.dispose();
            }
            v.imageBG = new BufferedImage(v.rv.width, v.rv.height, 3);
            v.g2BG = v.imageBG.getGraphics();
        } else {
            ((Graphics2D)v.g2BG).setComposite(AlphaComposite.Clear);
            v.g2BG.fillRect(0, 0, v.rv.width, v.rv.height);
            ((Graphics2D)v.g2BG).setComposite(AlphaComposite.Src);
        }
        v.oImgIDBG = this.imgID;
        v.owidthBG = v.rv.width;
        v.oheightBG = v.rv.height;
        v.ovizBG = v.iz;
        this.flagClearBuf = false;
        if (!this.isTransparent()) {
            this.drawBackground(v.g2BG, v);
        }
        this.drawLosanges(v.g2BG, v, now);
        this.adjustCM(v.imageBG);
        v.w = v.imageBG.getWidth();
        v.h = v.imageBG.getHeight();
        return v.imageBG;
    }

    private void adjustCM(BufferedImage img) {
        boolean flagInitRGB;
        if (!this.isColored()) {
            return;
        }
        int width = img.getWidth();
        int height = img.getHeight();
        boolean modif = this.RGBControl[0] != 0 || this.RGBControl[1] != 128 || this.RGBControl[2] != 255 || this.RGBControl[3] != 0 || this.RGBControl[4] != 128 || this.RGBControl[5] != 255 || this.RGBControl[6] != 0 || this.RGBControl[7] != 128 || this.RGBControl[8] != 255 || this.video != 0;
        int size = width * height;
        boolean bl = flagInitRGB = this.lastHistID != this.imgID;
        if (flagInitRGB) {
            this.lastHistID = this.imgID;
            if (this.red == null || size != this.red.length) {
                this.red = new byte[size];
                this.green = new byte[size];
                this.blue = new byte[size];
            }
        }
        if (!flagInitRGB && !modif) {
            return;
        }
        int[] pixelsRGB = ((DataBufferInt)img.getRaster().getDataBuffer()).getData();
        for (int pos = 0; pos < pixelsRGB.length; ++pos) {
            int rgb = pixelsRGB[pos];
            int a = (rgb & 0xFF000000) >> 24;
            int r = (rgb & 0xFF0000) >> 16;
            int g = (rgb & 0xFF00) >> 8;
            int b = rgb & 0xFF;
            if (flagInitRGB) {
                this.red[pos] = (byte)(0xFF & r);
                this.green[pos] = (byte)(0xFF & g);
                this.blue[pos] = (byte)(0xFF & b);
            }
            if (!modif) continue;
            r = PlanImageRGB.filter(this.RGBControl[0], this.RGBControl[1], this.RGBControl[2], r & 0xFF);
            g = PlanImageRGB.filter(this.RGBControl[3], this.RGBControl[4], this.RGBControl[5], g & 0xFF);
            b = PlanImageRGB.filter(this.RGBControl[6], this.RGBControl[7], this.RGBControl[8], b & 0xFF);
            if (this.video == 1) {
                r ^= 0xFFFFFFFF;
                g ^= 0xFFFFFFFF;
                b ^= 0xFFFFFFFF;
            }
            pixelsRGB[pos] = (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
        }
        if (modif) {
            img.setRGB(0, 0, width, height, pixelsRGB, 0, width);
        }
        if (flagInitRGB) {
            this.resetHist();
            if (this.aladin.frameCM != null) {
                this.aladin.frameCM.repaint();
            }
        }
    }

    protected void filterRGB(int[] triangle, int color) {
        this.changeImgID();
        this.RGBControl[color * 3] = triangle[0];
        this.RGBControl[color * 3 + 1] = triangle[1];
        this.RGBControl[color * 3 + 2] = triangle[2];
    }

    @Override
    protected double[] getHistArray(int rgb) {
        return rgb == 0 ? this.histRed : (rgb == 1 ? this.histGreen : this.histBlue);
    }

    @Override
    protected byte[] getPixelHist(int rgb) {
        return rgb == -1 ? super.getPixelHist(rgb) : (rgb == 0 ? this.red : (rgb == 1 ? this.green : this.blue));
    }

    protected synchronized void redrawAsap() {
        if (this.timer != null) {
            return;
        }
        System.out.println("starting fading process");
        this.timer = new Timer();
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                System.out.println("redrawAsap now");
                PlanBG.this.changeImgID();
                PlanBG.this.aladin.view.repaintAll();
            }
        };
        this.timer.scheduleAtFixedRate(timerTask, 5L, 5L);
    }

    protected synchronized void stopRedraw() {
        if (this.timer == null) {
            return;
        }
        System.out.println("stopping fading process");
        this.timer.cancel();
        this.timer = null;
    }

    @Override
    protected void draw(Graphics g, ViewSimple v, int dx, int dy, float op) {
        this.draw(g, v, dx, dy, -1.0f, false);
    }

    protected void draw(Graphics g, ViewSimple v, int dx, int dy, float op, boolean now) {
        if (v == null) {
            return;
        }
        if (op == -1.0f) {
            op = this.getOpacityLevel();
        }
        if ((double)op <= 0.1) {
            return;
        }
        this.resetFading();
        if (g instanceof Graphics2D) {
            Composite saveComposite;
            Graphics2D g2d;
            block16: {
                g2d = (Graphics2D)g;
                saveComposite = g2d.getComposite();
                try {
                    if ((double)op < 0.9) {
                        Composite myComposite = Util.getImageComposite(op);
                        g2d.setComposite(myComposite);
                    }
                    if (this.drawMode == 0) {
                        g2d.drawImage(this.getImage(v, now), dx, dy, this.aladin);
                    } else if (this.drawMode == 1) {
                        this.drawPolarisation(g2d, v);
                    }
                }
                catch (Exception e) {
                    if (Aladin.levelTrace < 3) break block16;
                    e.printStackTrace();
                }
            }
            g2d.setComposite(saveComposite);
        } else if (this.drawMode == 0) {
            g.drawImage(this.getImage(v, now), dx, dy, this.aladin);
        } else if (this.drawMode == 1) {
            this.drawPolarisation(g, v);
        }
        this.setHasMoreDetails(this.maxOrder(v) < this.maxOrder);
        if (this.fading) {
            this.redrawAsap();
        } else {
            this.stopRedraw();
        }
        this.readyDone = this.readyAfterDraw;
    }

    protected void drawHealpixMouse(Graphics g, ViewSimple v) {
        try {
            Coord coo = new Coord(this.aladin.localisation.getLastCoord().al, this.aladin.localisation.getLastCoord().del);
            coo = Localisation.frameToFrame(coo, 0, this.frameOrigin);
            int norder = this.aladin.getOrder();
            if (norder < 0) {
                return;
            }
            double[] polar = CDSHealpix.radecToPolar(new double[]{coo.al, coo.del});
            long nside = CDSHealpix.pow2(norder);
            long npix = CDSHealpix.ang2pix_nest(nside, polar[0], polar[1]);
            HealpixKey hk = new HealpixKey(this, norder, npix, 0);
            hk.drawCtrl(g, v);
            if (DEBUGMODE) {
                double[][] corners = CDSHealpix.corners(nside, npix);
                for (int i = 0; i < 4; ++i) {
                    coo = new Coord(corners[i][0], corners[i][1]);
                    coo = Localisation.frameToFrame(coo, this.frameOrigin, 0);
                    Repere r = new Repere((Plan)this, coo);
                    r.setType(6);
                    r.setWithLabel(true);
                    r.id = "" + i;
                    r.projection(v);
                    r.draw(g, v, 0, 0);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void resetPriority() {
        Enumeration<HealpixKey> e = this.pixList.elements();
        while (e.hasMoreElements()) {
            HealpixKey healpix = e.nextElement();
            if (healpix.npix == -1L || healpix.priority >= 1000) continue;
            healpix.priority += 1000;
        }
        this.priority = 0;
    }

    protected void drawPolarisation(Graphics g, ViewSimple v) {
        long[] pix = null;
        int max = Math.min(this.maxOrder(v), this.maxOrder);
        int nb = 0;
        if (v.getTaille() > 20.0 && (this.hasDrawnSomething = this.drawAllSky(g, v))) {
            return;
        }
        this.setMem();
        this.resetPriority();
        int order = Math.max(3, max);
        pix = this.getPixListView(v, order);
        for (int i = 0; i < pix.length; ++i) {
            HealpixKey healpix;
            if (new HealpixKey(this, order, pix[i], 0).isOutView(v) || (healpix = this.getHealpix(order, pix[i], true)) == null) continue;
            healpix.priority = 250 - this.priority++;
            int status = healpix.getStatus();
            if (status == 7) continue;
            if (status == 8) {
                healpix.setStatus(1, true);
            }
            healpix.resetTimer();
            if (status != 6) continue;
            nb += ((HealpixKeyPol)healpix).drawPolarisation(g, v);
        }
        this.hasDrawnSomething = nb > 0;
        this.tryWakeUp();
    }

    protected boolean mustDrawFast() {
        if (!this.computeDrawFast) {
            return this.lastMustDrawFast;
        }
        boolean rep = this.aladin.view.mustDrawFast();
        boolean bl = !rep ? false : (this.lastMustDrawFast = this.statTimeDisplay > 150L);
        if (this.lastMustDrawFast) {
            this.computeDrawFast = false;
        }
        return this.lastMustDrawFast;
    }

    protected void resetDrawFastDetection() {
        this.computeDrawFast = true;
    }

    protected void drawHealpixGrid(Graphics g, ViewSimple v) {
        int i;
        long[] pix;
        int order = Math.max(3, Math.min(this.maxOrder(v), this.maxOrder));
        if (v.isAllSky()) {
            pix = new long[12 * (int)CDSHealpix.pow2(order) * (int)CDSHealpix.pow2(order)];
            for (i = 0; i < pix.length; ++i) {
                pix[i] = i;
            }
        } else {
            pix = this.getPixList(v, this.getCooCentre(v), order);
        }
        for (i = 0; i < pix.length; ++i) {
            HealpixKey healpix = new HealpixKey(this, order, pix[i], 0);
            if (this.isOutMoc(order, pix[i]) || healpix.isOutView(v)) continue;
            try {
                healpix.drawLosangeBorder(g, v);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void drawLosangesNow(Graphics g, ViewSimple v) {
        int i;
        long[] pix;
        int order = Math.max(3, Math.min(this.maxOrder(v), this.maxOrder));
        boolean lowResolution = v.isAllSky() && order == 3;
        HealpixKey allsky = this.pixList.get(this.key(3, -1L));
        if (lowResolution && allsky == null) {
            allsky = new HealpixAllsky(this, 3);
            try {
                allsky.loadNow();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (v.isAllSky()) {
            pix = new long[12 * (int)CDSHealpix.pow2(order) * (int)CDSHealpix.pow2(order)];
            for (i = 0; i < pix.length; ++i) {
                pix[i] = i;
            }
        } else {
            pix = this.getPixList(v, this.getCooCentre(v), order);
        }
        for (i = 0; i < pix.length; ++i) {
            HealpixKey healpix;
            if (this.isOutMoc(order, pix[i]) || new HealpixKey(this, order, pix[i], 0).isOutView(v)) continue;
            if (lowResolution && allsky != null) {
                healpix = allsky.getPixList()[i];
            } else {
                healpix = this.getHealpix(order, pix[i], true);
                try {
                    healpix.loadNow();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
            }
            if (healpix.status != 6) continue;
            healpix.resetTimer();
            healpix.draw(g, v);
        }
    }

    protected synchronized void drawLosanges(Graphics g, ViewSimple v, boolean now) {
        if (now) {
            this.drawLosangesNow(g, v);
        } else {
            this.drawLosangesAsync(g, v);
        }
    }

    protected boolean isOutMoc(int order, long npix) {
        if (this.moc == null) {
            return false;
        }
        boolean res = !this.moc.isIntersecting(order, npix);
        return res;
    }

    protected void drawLosangesAsync(Graphics g, ViewSimple v) {
        this.allWaitingKeysDrawn = false;
        boolean first = true;
        long t1 = Util.getTime(0);
        int nb = 0;
        long[] pix = null;
        int z = (int)this.getZ(v);
        int min = Math.max(3, this.minOrder);
        int max = Math.min(this.maxOrder(v), this.maxOrder);
        boolean allKeyReady = false;
        boolean oneKeyReady = false;
        boolean allskyDrawn = false;
        StringBuilder debug = new StringBuilder(" order=" + max);
        HealpixKey allsky = this.pixList.get(this.key(3, -1L, z));
        if (z > 0) {
            debug.append(" z=" + z);
        }
        if (min < 3) {
            if (this.drawAllSky(g, v)) {
                ++nb;
                debug.append(" allsky1");
            }
            allskyDrawn = true;
        } else {
            int cmin;
            boolean fast = this.mustDrawFast();
            if (fast) {
                min = max;
            }
            double theta = 0.0;
            double phi = 0.0;
            Coord center = this.getCooCentre(v);
            if (center != null) {
                theta = 1.5707963267948966 - Math.toRadians(center.del);
                phi = Math.toRadians(center.al);
            }
            allKeyReady = true;
            if (max < 3) {
                allKeyReady = false;
            } else {
                pix = this.getPixList(v, center, max);
                for (int i = 0; i < pix.length; ++i) {
                    HealpixKey healpix = this.getHealpix(max, pix[i], z, false);
                    if (healpix == null) {
                        if (this.isOutMoc(max, pix[i]) || new HealpixKey(this, max, pix[i], 0).isOutView(v)) {
                            pix[i] = -1L;
                            continue;
                        }
                        allKeyReady = false;
                        break;
                    }
                    if (this.isOutMoc(max, pix[i]) || healpix.isOutView(v)) {
                        pix[i] = -1L;
                        continue;
                    }
                    if (healpix.status != 6 && healpix.status != 7) {
                        allKeyReady = false;
                        break;
                    }
                    healpix.resetTimer();
                    oneKeyReady = true;
                }
            }
            if (nb == 0 && max <= 3 && (!allKeyReady || !oneKeyReady && allsky != null)) {
                if (this.drawAllSky(g, v)) {
                    ++nb;
                    debug.append(" allsky2");
                }
                allskyDrawn = true;
            }
            this.resetPriority();
            HealpixKey healpix = null;
            int n = min < max && allKeyReady ? max : (cmin = min < max - 4 ? max - 4 : min);
            if (max >= 3) {
                for (int order = cmin; (order <= max || !oneKeyReady && order <= max + 3 && order <= this.maxOrder) && (pix = this.getPixList(v, center, order)).length != 0; ++order) {
                    block33: {
                        nDraw1 += pix.length;
                        try {
                            if (center == null) break block33;
                            long firstPix = CDSHealpix.ang2pix_nest(CDSHealpix.pow2(order), theta, phi);
                            for (int i = 0; i < pix.length; ++i) {
                                if (pix[i] != firstPix) continue;
                                long a = pix[0];
                                pix[0] = pix[i];
                                pix[i] = a;
                                break;
                            }
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    boolean debugOrder = false;
                    for (int i = 0; i < pix.length; ++i) {
                        int n2;
                        HealpixKey testIn;
                        if (pix[i] == -1L) continue;
                        healpix = this.getHealpix(order, pix[i], z, false);
                        HealpixKey healpixKey = testIn = healpix != null ? healpix : new HealpixKey(this, order, pix[i], 0);
                        if (!allKeyReady && (this.isOutMoc(order, pix[i]) || testIn.isOutView(v))) {
                            ++nOut1;
                            pix[i] = -1L;
                            continue;
                        }
                        if (healpix == null && order <= max) {
                            healpix = this.getHealpix(order, pix[i], z, true);
                        }
                        if (healpix == null) {
                            HealpixKey h = this.getHealpixPreviousFrame(order, pix[i]);
                            if (h == null) continue;
                            nb += h.draw(g, v);
                            continue;
                        }
                        if (order < max) {
                            n2 = 500 - this.priority++;
                        } else {
                            int n3 = this.priority;
                            n2 = n3;
                            this.priority = n3 + 1;
                        }
                        healpix.priority = n2;
                        int status = healpix.status;
                        if (status == 7) continue;
                        if (status == 8) {
                            healpix.setStatus(1, true);
                        }
                        healpix.resetTimer();
                        if (status != 6) {
                            HealpixKey h = this.getHealpixPreviousFrame(order, pix[i]);
                            if (h == null) continue;
                            nb += h.draw(g, v);
                            continue;
                        }
                        if (order < max && this.childrenReady(healpix, v)) {
                            healpix.filsFree();
                            continue;
                        }
                        nb += healpix.draw(g, v);
                        this.setHealpixPreviousFrame(order, pix[i]);
                        if (first && !this.isColored()) {
                            first = false;
                            this.pixels = healpix.pixels;
                            this.pixelsOrigin = healpix.pixelsOrigin;
                            this.resetHist();
                        }
                        if (debugOrder) continue;
                        debug.append(" " + order);
                        debugOrder = true;
                    }
                }
            }
            boolean bl = this.allWaitingKeysDrawn = allKeyReady || max <= 3 && this.hasDrawnSomething;
        }
        if (this.isPause() && nb == 0 && !allskyDrawn && allsky != null && allsky.getStatus() == 6 && this.drawAllSky(g, v)) {
            ++nb;
            debug.append(" allsky3");
        }
        this.hasDrawnSomething = nb > 0;
        this.tryWakeUp();
        long t2 = Util.getTime(0);
        long l = (t2 - t1) / 1000000L;
        this.statTimeDisplayArray[this.nStat++] = l;
        long statTime = l;
        if (this.nStat == this.statTimeDisplayArray.length) {
            this.nStat = 0;
        }
        long totalStatTime = 0L;
        int nbStat = 0;
        for (int i = 0; i < this.statTimeDisplayArray.length; ++i) {
            if (this.statTimeDisplayArray[i] == 0L) continue;
            totalStatTime += this.statTimeDisplayArray[i];
            ++nbStat;
        }
        this.statTimeDisplay = nbStat > 0 ? totalStatTime / (long)nbStat : -1L;
        this.statNbItems = nb;
    }

    protected HealpixKey getHealpixPreviousFrame(int order, long npix) {
        return null;
    }

    protected void setHealpixPreviousFrame(int order, long npix) {
    }

    protected double getFps() {
        return this.statTimeDisplay > 0L ? 1000.0 / (double)this.statTimeDisplay : -1.0;
    }

    protected void resetFading() {
        this.fading = false;
    }

    protected void updateFading(boolean flag) {
        this.fading |= flag;
    }

    protected void askForRepaint() {
        this.changeImgID();
        if (this.first) {
            this.first = false;
            this.aladin.view.setRepere(this);
        }
        this.aladin.view.repaintAll();
    }

    protected void drawForeground(Graphics gv, ViewSimple v) {
        v = v.getProjSyncView();
        if (this.aladin.calque.hasHpxGrid() || this.isOverlay()) {
            if (this.aladin.calque.hasHpxGrid()) {
                this.drawHealpixGrid(gv, v);
            }
            return;
        }
        Graphics2D g = (Graphics2D)gv;
        int x = 0;
        int y = 0;
        int rayon = 0;
        int grandAxe = 0;
        double angle = 0.0;
        if (v.getTaille() < 15.0) {
            return;
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(Color.white);
        Stroke st = g.getStroke();
        int epaisseur = 50;
        g.setStroke(new BasicStroke(epaisseur));
        Projection projd = v.getProj().copy();
        projd.frame = 0;
        rayon = 0;
        int m = epaisseur / 2;
        int chouilla = (int)(((double)v.getWidth() / 800.0 - 1.0) * 6.0);
        if (chouilla < 0) {
            chouilla = 0;
        }
        if (projd.t == 1 || projd.t == 3 || projd.t == 5) {
            Coord c = projd.c.getProjCenter();
            projd.getXYNative(c);
            PointD center = v.getViewCoordDble(c.x, c.y);
            double signe = c.del < 0.0 ? 1.0 : -1.0;
            c.del = c.del + signe * (double)(projd.t == 1 ? 89 : 179);
            projd.getXYNative(c);
            PointD haut = v.getViewCoordDble(c.x, c.y);
            double deltaY = haut.y - center.y;
            double deltaX = haut.x - center.x;
            rayon = (int)Math.abs(Math.sqrt(deltaX * deltaX + deltaY * deltaY)) - chouilla;
            x = (int)(center.x - (double)rayon);
            y = (int)(center.y - (double)rayon);
            g.drawOval(x - m, y - m, (rayon + m) * 2, (rayon + m) * 2);
        } else if (projd.t == 4 || projd.t == 11) {
            Projection p = projd.copy();
            angle = -p.c.getProjRot();
            p.setProjRot(0.0);
            p.frame = 0;
            p.setProjCenter(0.0, 0.1);
            Coord c = p.c.getProjCenter();
            p.getXYNative(c);
            PointD center = v.getViewCoordDble(c.x, c.y);
            double signe = c.del < 0.0 ? 1.0 : -1.0;
            double del = c.del;
            c.del += signe * 89.0;
            p.getXYNative(c);
            PointD haut = v.getViewCoordDble(c.x, c.y);
            c.del = del;
            c.al += 179.0;
            p.getXYNative(c);
            PointD droit = v.getViewCoordDble(c.x, c.y);
            rayon = (int)Math.abs(haut.y - center.y) - chouilla;
            grandAxe = (int)Math.abs(droit.x - center.x) - chouilla;
            x = (int)(center.x - (double)grandAxe);
            y = (int)(center.y - (double)rayon);
            if (angle == 0.0) {
                g.drawOval(x - m, y - m, (grandAxe + m) * 2, (rayon + m) * 2);
            } else {
                Util.drawEllipse(g, x + grandAxe, y + rayon, grandAxe + m, rayon + m, angle);
            }
        }
        g.setStroke(st);
        if (this.pixMode != 0 && this.pixMode != 1 && this.video == 1) {
            m = 0;
            g.setStroke(new BasicStroke(2.0f));
            g.setColor(new Color(210, 220, 255));
            if (projd.t == 1 || projd.t == 3 || projd.t == 5) {
                g.drawOval(x - m, y - m, (rayon + m) * 2, (rayon + m) * 2);
            } else if (projd.t == 4 || projd.t == 11) {
                if (angle == 0.0) {
                    g.drawOval(x - m, y - m, (grandAxe + m) * 2, (rayon + m) * 2);
                } else {
                    Util.drawEllipse(g, x + grandAxe, y + rayon, grandAxe + m, rayon + m, angle);
                }
            }
            g.setStroke(st);
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    protected void drawBackground(Graphics g, ViewSimple v) {
        if (this.aladin.calque.hasHpxGrid() || this.isOverlay()) {
            return;
        }
        Projection projd = v.getProjSyncView().getProj().copy();
        projd.frame = 0;
        int x = 0;
        int y = 0;
        int rayon = 0;
        int grandAxe = 0;
        double angle = 0.0;
        Color bckCol = this.color ? Color.black : (this.cm == null ? Color.white : new Color(this.cm.getRed(0), this.cm.getGreen(0), this.cm.getBlue(0)));
        g.setColor(bckCol);
        rayon = 0;
        if (projd.t == 2 || projd.t == 12) {
            g.fillRect(0, 0, v.getWidth(), v.getHeight());
        } else if (projd.t == 1 || projd.t == 3 || projd.t == 5) {
            Coord c = projd.c.getProjCenter();
            projd.getXYNative(c);
            PointD center = v.getViewCoordDble(c.x, c.y);
            double signe = c.del < 0.0 ? 1.0 : -1.0;
            c.del = c.del + signe * (double)(projd.t == 1 ? 89 : 179);
            projd.getXYNative(c);
            PointD haut = v.getViewCoordDble(c.x, c.y);
            double deltaY = haut.y - center.y;
            double deltaX = haut.x - center.x;
            rayon = (int)Math.abs(Math.sqrt(deltaX * deltaX + deltaY * deltaY));
            x = (int)(center.x - (double)rayon);
            y = (int)(center.y - (double)rayon);
            if (this.isTransparent()) {
                Graphics2D g2d = (Graphics2D)g;
                Paint paint = g2d.getPaint();
                GradientPaint gradient = new GradientPaint(x, y, new Color(0, 0, 70), x + rayon * 2, y + rayon * 2, new Color(180, 190, 200));
                g2d.setPaint(gradient);
                g.fillOval(x, y, rayon * 2, rayon * 2);
                g2d.setPaint(paint);
            } else {
                g.fillOval(x, y, rayon * 2, rayon * 2);
            }
        } else if (projd.t == 4 || projd.t == 11) {
            Projection p = projd.copy();
            angle = -p.c.getProjRot();
            p.setProjRot(0.0);
            p.frame = 0;
            p.setProjCenter(0.0, 0.1);
            Coord c = p.c.getProjCenter();
            p.getXYNative(c);
            PointD center = v.getViewCoordDble(c.x, c.y);
            double signe = c.del < 0.0 ? 1.0 : -1.0;
            double del = c.del;
            c.del += signe * 89.0;
            p.getXYNative(c);
            PointD haut = v.getViewCoordDble(c.x, c.y);
            c.del = del;
            c.al += 179.0;
            p.getXYNative(c);
            PointD droit = v.getViewCoordDble(c.x, c.y);
            rayon = (int)Math.abs(haut.y - center.y);
            grandAxe = (int)Math.abs(droit.x - center.x);
            x = (int)(center.x - (double)grandAxe);
            y = (int)(center.y - (double)rayon);
            if (this.isTransparent()) {
                Graphics2D g2d = (Graphics2D)g;
                Paint paint = g2d.getPaint();
                GradientPaint gradient = new GradientPaint(x + rayon / 4, y + rayon / 4, new Color(0, 0, 70), x + grandAxe * 2 - rayon / 4, y + rayon * 2 - rayon / 4, new Color(180, 190, 200));
                g2d.setPaint(gradient);
                if (angle == 0.0) {
                    g.fillOval(x, y, grandAxe * 2, rayon * 2);
                } else {
                    Util.fillEllipse(g, x + grandAxe, y + rayon, grandAxe, rayon, angle);
                }
                g2d.setPaint(paint);
            } else if (angle == 0.0) {
                g.fillOval(x, y, grandAxe * 2, rayon * 2);
            } else {
                Util.fillEllipse(g, x + grandAxe, y + rayon, grandAxe, rayon, angle);
            }
        } else {
            g.fillRect(0, 0, v.rv.width, v.rv.height);
        }
    }

    protected float getSegmentLenFactor() {
        return this.segmentLenFactor;
    }

    protected void setSegmentLenFactor(float segmentLenFactor) {
        this.segmentLenFactor = segmentLenFactor;
    }

    protected int getSegmentThickness() {
        return this.segmentThickness;
    }

    protected void setSegmentThickness(int segmentThickness) {
        this.segmentThickness = segmentThickness;
    }

    protected float getSegmentDensityFactor() {
        return this.segmentDensityFactor;
    }

    protected void setSegmentDensityFactor(float segmentDensityFactor) {
        this.segmentDensityFactor = segmentDensityFactor;
    }

    private void shouldRefresh() {
        long t = System.currentTimeMillis();
        if (t - this.timerLastDrawBG < 500L) {
            return;
        }
        this.timerLastDrawBG = t;
        this.changeImgID();
        this.aladin.view.repaintAll();
    }

    protected boolean detectServerError(int[] nb) {
        if (this.moc == null) {
            this.removeHealpixOutsideMoc();
        }
        return nb[6] == 0 && nb[7] > 5;
    }

    public void testnet() throws Exception {
        try {
            if (this.moc == null) {
                this.loadInternalMoc();
            }
        }
        catch (Exception e1) {
            // empty catch block
        }
        long time = 0L;
        long size = 0L;
        int minOrder = 3;
        long timeMax = 10000L;
        long sizeMax = 0x1E00000L;
        long start = System.currentTimeMillis();
        System.out.println("Testnet HiPS " + this.label + " maxOrder=" + this.maxOrder + " from " + this.url + " :");
        int n = 0;
        int memo = Aladin.levelTrace;
        Aladin.levelTrace = 0;
        while (true) {
            try {
                while (System.currentTimeMillis() - start <= timeMax && size <= sizeMax) {
                    long npix;
                    int order = minOrder + (int)(Math.random() * (double)(this.maxOrder - minOrder));
                    long[] list = null;
                    if (this.moc != null) {
                        int i;
                        int length = 0;
                        for (i = 0; i < this.maxOrder && length == 0; ++i) {
                            if (++order > this.maxOrder) {
                                order = minOrder;
                            }
                            list = this.moc.getPixLevel(order);
                            length = list.length;
                        }
                        if (i == this.maxOrder) {
                            return;
                        }
                        i = (int)(Math.random() * (double)length);
                        if (i >= length) {
                            i = list.length - 1;
                        }
                        npix = list[i];
                        int o = order + (int)(Math.random() * (double)(this.maxOrder - order));
                        for (i = order; i < o; ++i) {
                            int j = (int)(Math.random() * 4.0);
                            npix = npix * 4L + (long)j;
                        }
                        order = o;
                    } else {
                        long nbPix = 12L * CDSHealpix.pow2(order) * CDSHealpix.pow2(order);
                        npix = (long)(Math.random() * (double)nbPix);
                        if (npix >= nbPix) {
                            npix = nbPix - 1L;
                        }
                    }
                    System.out.print(".Loading " + order + "/" + npix + "... ");
                    HealpixKey hk = new HealpixKey(this, order, npix, 4);
                    long t = hk.timeNet;
                    long s = hk.sizeStream;
                    if (s == 0L) {
                        System.out.println(" error => " + this.url + "/" + hk.getFileNet());
                    } else {
                        System.out.println(Util.getUnitDisk(s) + " in " + Util.getTemps(t));
                    }
                    time += t;
                    size += s;
                    ++n;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
        Aladin.levelTrace = memo;
        System.out.println("=> Downloaded " + n + " tiles in " + HealpixKey.EXT[this.getTileMode()] + " : " + Util.getUnitDisk(size) + " in " + Util.getTemps(time));
        long rate = (long)((double)size / ((double)time / 1000.0));
        String res = "=> Stream rate " + Util.getUnitDisk(rate) + "/s";
        System.out.println(res);
        this.aladin.console.printInfo(this.label + " net perf " + res);
    }

    public void center(Coord coord) {
        this.aladin.view.setRepere(coord);
        this.aladin.view.showSource();
        this.aladin.view.zoomview.repaint();
        this.aladin.calque.repaintAll();
    }

    protected void resetStats() {
        this.cumulTimeDraw = 0L;
        this.cumulTimeWriteCache = 0L;
        this.cumulTimeLoadCache = 0L;
        this.cumulTimeLoadNet = 0L;
        this.cumulTimePixel = 0L;
        this.cumulTimeJPEG = 0L;
        this.cumulTimeStream = 0L;
        this.nbWriteCache = 0;
        this.nbLoadCache = 0;
        this.nbLoadNet = 0;
        this.nByteWriteCache = 0L;
        this.nByteReadCache = 0L;
        this.nByteReadNet = 0L;
        this.nbImgDraw = 0;
        this.nbAborted = 0;
        this.nbFree = 0;
        this.nbCreated = 0;
        this.nbImgInBuf = 0;
        this.nbImgCreated = 0;
    }

    @Override
    protected String getStats() {
        return "HealpixKey stats: " + this.label + ":\n" + ".Created: " + this.nbCreated + "   Abort: " + this.nbAborted + "   Free: " + this.nbFree + "\n" + ".Net   : " + this.nbLoadNet + " => " + Util.round((double)this.nByteReadNet / 1048576.0, 2) + "Mb in ~" + Util.round(this.avgLoadNet(), 0) + "ms" + " " + this.streamJpegPixel() + "\n" + ".CacheR: " + this.nbLoadCache + " => " + Util.round((double)this.nByteReadCache / 1048576.0, 2) + "Mb in ~" + Util.round(this.avgLoadCache(), 0) + "ms\n" + ".CacheW: " + this.nbWriteCache + " => " + Util.round((double)this.nByteWriteCache / 1048576.0, 2) + "Mb in ~" + Util.round(this.avgWriteCache(), 0) + "ms\n" + ".Img created: " + this.nbImgCreated + "    reused:" + this.nbImgInBuf + "    drawn " + this.nbImgDraw + " in ~" + Util.round(this.avgDraw(), 0) + "ms\n";
    }

    private String getHost() {
        int i = this.url.indexOf("//");
        if (i == -1) {
            return "?";
        }
        int j = this.url.indexOf("/", i + 2);
        if (j < 0) {
            j = this.url.length();
        }
        return this.url.substring(i + 2, j);
    }

    protected String getShortStats() {
        if (this.nbLoadNet == 0 && this.nbLoadCache == 0) {
            return null;
        }
        boolean flagLocal = this.isLocalAllSky();
        return this.label + (flagLocal ? " Local:" : " Net[" + this.getHost() + "]:") + this.nbLoadNet + "/" + Util.round((double)this.nByteReadNet / 1048576.0, 2) + "Mb/" + Util.round(this.avgLoadNet(), 0) + "ms" + " CacheR:" + this.nbLoadCache + "/" + Util.round((double)this.nByteReadCache / 1048576.0, 2) + "Mb/" + Util.round(this.avgLoadCache(), 0) + "ms" + " CacheW:" + this.nbWriteCache + "/" + Util.round((double)this.nByteWriteCache / 1048576.0, 2) + "Mb/" + Util.round(this.avgWriteCache(), 0) + "ms";
    }

    protected String streamJpegPixel() {
        if (this.nbLoadNet == 0) {
            return "";
        }
        return "(stream=" + Util.round(this.cumulTimeStream / (long)this.nbLoadNet, 1) + "/jpeg=" + Util.round(this.cumulTimeJPEG / (long)this.nbLoadNet, 1) + "/getpix=" + Util.round(this.cumulTimePixel / (long)this.nbLoadNet, 1) + ")";
    }

    protected String getNetSpeed() {
        long r = this.rateLoadNet();
        int er = this.nbTileError();
        if (er == 0 && r == 0L) {
            return null;
        }
        StringBuilder s = new StringBuilder();
        if (r != 0L) {
            s.append(Util.getUnitDisk(r) + "/s");
        }
        if (er > 0) {
            if (s.length() > 0) {
                s.append(" - ");
            }
            s.append("tile errors: " + er + "/" + this.pixList.size() + " (" + Util.myRound(100.0 * (double)er / (double)this.pixList.size()) + "%)");
        }
        return s.toString();
    }

    protected int nbTileError() {
        if (this.moc == null) {
            return 0;
        }
        this.removeHealpixOutsideMoc();
        Enumeration<HealpixKey> e = this.pixList.elements();
        int n = 0;
        while (e.hasMoreElements()) {
            HealpixKey h = e.nextElement();
            if (h.getStatus() != 7) continue;
            ++n;
            Aladin.trace(4, "Error on " + h);
        }
        return n;
    }

    protected long rateLoadNet() {
        if (this.cumulTimeLoadNet == 0L) {
            return 0L;
        }
        long r = this.nByteReadNet / this.cumulTimeLoadNet * 1000L;
        return r;
    }

    protected double avgDraw() {
        if (this.nbImgDraw == 0) {
            return 0.0;
        }
        return (double)this.cumulTimeDraw / (double)this.nbImgDraw / 1000000.0;
    }

    protected double avgLoadNet() {
        if (this.nbLoadNet == 0) {
            return 0.0;
        }
        return (double)this.cumulTimeLoadNet / (double)this.nbLoadNet;
    }

    protected double avgLoadCache() {
        if (this.nbLoadCache == 0) {
            return 0.0;
        }
        return (double)this.cumulTimeLoadCache / (double)this.nbLoadCache;
    }

    protected double avgWriteCache() {
        if (this.nbWriteCache == 0) {
            return 0.0;
        }
        return (double)this.cumulTimeWriteCache / (double)this.nbWriteCache;
    }

    class Loader
    implements Runnable {
        boolean encore;
        Thread thread;
        int type;
        String label;
        private boolean pause = false;

        Loader(int type) {
            this.type = type;
            this.label = type == 0 ? "LoaderCache" : "LoaderNet";
        }

        void start() {
            this.encore = true;
            if (this.thread != null) {
                this.thread.interrupt();
            }
            this.thread = new Thread((Runnable)this, this.label);
            Util.decreasePriority(Thread.currentThread(), this.thread);
            this.thread.start();
        }

        void wakeUp() {
            if (this.thread == null) {
                this.start();
            } else if (this.pause) {
                this.thread.interrupt();
            }
        }

        synchronized void setPause(boolean flag) {
            this.pause = flag;
        }

        void stop() {
            this.encore = false;
            if (this.thread != null) {
                this.thread.interrupt();
            }
        }

        @Override
        public void run() {
            while (this.encore) {
                try {
                    boolean flagLoad;
                    block17: {
                        flagLoad = false;
                        if (!PlanBG.this.aladin.view.mustDrawFast()) {
                            try {
                                ArrayList<HealpixKey> list = new ArrayList<HealpixKey>();
                                MyEnum e = new MyEnum(PlanBG.this.pixList);
                                while (e.hasMoreElements()) {
                                    HealpixKey healpix = (HealpixKey)e.nextElement();
                                    int status = healpix.getStatus();
                                    if (this.type == 0 && status == 2) {
                                        healpix.loadFromCache();
                                        if (!healpix.allSky) {
                                            PlanBG.this.setTileOrder(healpix.getLosangeOrder());
                                        }
                                        flagLoad = true;
                                        continue;
                                    }
                                    if (this.type != 1 || status != 3) continue;
                                    list.add(healpix);
                                }
                                long t = System.currentTimeMillis();
                                if (list.size() > 0) {
                                    Collections.sort(list);
                                    for (HealpixKey h : list) {
                                        if (h.getStatus() != 3) continue;
                                        if (this.type == 0) {
                                            h.loadFromCache();
                                        } else {
                                            h.loadFromNet();
                                        }
                                        if (!h.allSky) {
                                            PlanBG.this.setTileOrder(h.getLosangeOrder());
                                        }
                                        if (System.currentTimeMillis() - t <= 1000L) continue;
                                        break;
                                    }
                                    flagLoad = true;
                                }
                            }
                            catch (Exception e) {
                                if (Aladin.levelTrace < 3) break block17;
                                e.printStackTrace();
                            }
                        }
                    }
                    if (flagLoad) {
                        PlanBG.this.loader.wakeUp();
                        continue;
                    }
                    try {
                        this.setPause(true);
                        Thread.currentThread();
                        Thread.sleep(10000L);
                    }
                    catch (Exception e) {
                    }
                }
                catch (Throwable t) {
                    if (Aladin.levelTrace < 3) continue;
                    t.printStackTrace();
                }
            }
            this.thread = null;
        }
    }

    class MyEnum
    implements Enumeration<HealpixKey> {
        HealpixKey[] tab;
        int size;
        int pos;

        MyEnum(Hashtable<String, HealpixKey> pixList) {
            int i;
            this.tab = new HealpixKey[pixList.size()];
            Enumeration<HealpixKey> e = pixList.elements();
            for (i = 0; e.hasMoreElements() && i < this.tab.length; ++i) {
                this.tab[i] = e.nextElement();
            }
            this.size = i;
            Arrays.sort(this.tab, 0, this.size);
            this.pos = 0;
        }

        @Override
        public boolean hasMoreElements() {
            return this.pos < this.size;
        }

        @Override
        public HealpixKey nextElement() {
            return this.tab[this.pos++];
        }
    }

    class HealpixLoader
    implements Runnable {
        static final int DELAI = 1000;
        private boolean loading = false;
        private boolean purging = false;
        private Thread thread = null;
        private Loader cacheLoader;
        private Loader netLoader;
        private volatile boolean sleep;
        private boolean isSleeping = false;
        private Object lockSleep = new Object();

        HealpixLoader() {
            this.cacheLoader = new Loader(0);
            this.netLoader = new Loader(1);
            this.wakeUp();
        }

        protected boolean isReadyForDrawing() {
            return PlanBG.this.readyAfterDraw;
        }

        protected boolean isLoading() {
            return this.loading;
        }

        protected boolean isPurging() {
            return this.purging;
        }

        protected void wakeUp() {
            if (this.thread != null) {
                this.loading = true;
                this.noSleep();
                if (this.isSleeping()) {
                    this.thread.interrupt();
                }
            } else {
                this.thread = new Thread((Runnable)this, "HealpixLoader");
                Util.decreasePriority(Thread.currentThread(), this.thread);
                this.thread.start();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void noSleep() {
            Object object = this.lockSleep;
            synchronized (object) {
                this.sleep = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isSleeping() {
            Object object = this.lockSleep;
            synchronized (object) {
                return this.isSleeping;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setSleep(boolean flag) {
            Object object = this.lockSleep;
            synchronized (object) {
                this.isSleeping = flag;
            }
        }

        private boolean shouldRun() {
            return this.isLoading() || this.isPurging();
        }

        @Override
        public void run() {
            Util.pause(100);
            if (PlanBG.this.useCache) {
                this.cacheLoader.start();
            }
            this.netLoader.start();
            do {
                this.sleep = true;
                try {
                    try {
                        this.launchJob();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (PlanBG.this.useCache) {
                        PlanBG.scanCache();
                    }
                    if (!this.sleep) continue;
                    this.setSleep(true);
                    try {
                        Thread.currentThread();
                        Thread.sleep(1000L);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    this.setSleep(false);
                }
                catch (Throwable e1) {
                    e1.printStackTrace();
                }
            } while (this.shouldRun());
            if (PlanBG.this.useCache) {
                this.cacheLoader.stop();
            }
            this.netLoader.stop();
            this.thread = null;
            PlanBG.this.nbFlush = 0;
            PlanBG.this.aladin.gc();
        }

        private void launchJob() throws Exception {
            boolean stillOnePurge = false;
            boolean perhapsOneDeath = false;
            int[] nb = new int[HealpixKey.NBSTATUS];
            boolean flagVerbose = PlanBG.this.aladin.calque.hasHpxGrid();
            boolean first = true;
            int n = 0;
            try {
                ArrayList<HealpixKey> list = new ArrayList<HealpixKey>();
                Enumeration<HealpixKey> e = PlanBG.this.pixList.elements();
                while (e.hasMoreElements()) {
                    list.add(e.nextElement());
                }
                Collections.sort(list);
                for (HealpixKey healpix : list) {
                    int live;
                    int status = healpix.getStatus();
                    if (flagVerbose && status != 7) {
                        System.out.println((first ? "\n" : "") + healpix);
                        first = false;
                    }
                    if ((live = healpix.getLive()) == -1) {
                        PlanBG.this.purge(healpix);
                    } else {
                        if (live == -2) {
                            perhapsOneDeath = true;
                        } else if (status == 6) {
                            healpix.purgeFils();
                        }
                        stillOnePurge = true;
                    }
                    switch (status) {
                        case 1: {
                            if (!healpix.allSky && healpix.priority >= 1000) {
                                healpix.setOld();
                                break;
                            }
                            if (PlanBG.this.useCache && healpix.isCached()) {
                                status = 2;
                                healpix.setStatus(2);
                                break;
                            }
                            status = 3;
                            healpix.setStatus(3);
                            break;
                        }
                        case 6: {
                            if (!PlanBG.this.useCache) break;
                            healpix.write();
                        }
                    }
                    int n2 = status;
                    nb[n2] = nb[n2] + 1;
                    if (healpix.priority < 250 && status != 6 && status != 7) {
                        ++n;
                        continue;
                    }
                    if (healpix.npix != -1L || status == 6 || status == 7) continue;
                    n += 10;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
            this.loading = nb[1] > 0 || nb[2] > 0 || nb[3] > 0 || nb[4] > 0 || nb[5] > 0;
            boolean bl = this.purging = stillOnePurge || nb[9] > 0;
            PlanBG.this.pourcent = n == 0 ? -2.0 : (n >= 10 ? 1.0 : (double)(10 - n) * 10.0);
            PlanBG.this.readyAfterDraw = n == 0;
            PlanBG.this.nbReady = nb[6];
            if (PlanBG.this.detectServerError(nb)) {
                PlanBG.this.error = "Server not available";
            }
            HealpixKey healpixMin = null;
            HealpixKey healpixNet = null;
            int min = Integer.MAX_VALUE;
            Enumeration<HealpixKey> e = PlanBG.this.pixList.elements();
            while (e.hasMoreElements()) {
                HealpixKey healpix = e.nextElement();
                int status = healpix.getStatus();
                if (status != 3 && status != 5) continue;
                if (status == 5) {
                    healpixNet = healpix;
                }
                if (healpix.priority >= min) continue;
                min = healpix.priority;
                healpixMin = healpix;
            }
            if (healpixNet != null && healpixNet != healpixMin) {
                healpixNet.abort();
            }
            if (nb[2] > 0) {
                this.cacheLoader.wakeUp();
            }
            if (nb[3] > 0) {
                this.netLoader.wakeUp();
            }
            if (PlanBG.this.oLoading != this.loading) {
                PlanBG.this.oLoading = this.loading;
                PlanBG.this.aladin.calque.select.repaint();
            }
            if (perhapsOneDeath) {
                PlanBG.this.shouldRefresh();
            }
        }
    }
}

