/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.FrameMacro;
import cds.aladin.MacroModel;
import cds.aladin.Obj;
import cds.aladin.Plan;
import cds.aladin.Source;
import cds.tools.Util;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.filechooser.FileFilter;

public class MacroController
implements ActionListener,
MouseMotionListener,
MouseListener {
    private MacroModel macroModel;
    private FrameMacro frameMacro;
    private Aladin a;
    private Thread execThread;
    private boolean stopThread = false;
    private JFileChooser fChooser;

    public MacroController(FrameMacro frameMacro, Aladin a) {
        this.frameMacro = frameMacro;
        this.a = a;
        this.macroModel = new MacroModel(a);
    }

    private String getScriptFromReader(BufferedReader reader) throws IOException {
        String line;
        String script = "";
        while ((line = reader.readLine()) != null) {
            script = script + line + "\n";
        }
        reader.close();
        return script;
    }

    private void loadParams(BufferedReader reader) throws IOException {
        String line;
        while ((line = reader.readLine()) != null) {
            Vector<Object> list = new Vector<Object>();
            if (line.trim().startsWith("#") || line.trim().length() == 0) continue;
            StringTokenizer st = new StringTokenizer(line, "\t,|");
            while (st.hasMoreTokens()) {
                list.add(st.nextElement());
            }
            Object[] values = new String[list.size()];
            list.copyInto(values);
            this.macroModel.getParamTableModel().addRecord((String[])values);
        }
        reader.close();
        this.macroModel.getParamTableModel().initTable();
    }

    private void importParams() {
        Plan p1;
        MacroModel.ParamTableModel ptm = this.macroModel.getParamTableModel();
        Vector<Plan> p = this.a.calque.getSelectedPlanes();
        if (p != null && p.size() > 0) {
            Vector<Plan> pa = new Vector<Plan>();
            for (int i = 0; i < p.size(); ++i) {
                Plan p2 = (Plan)p.get(i);
                if (!p2.isReady() || !p2.isSimpleCatalog()) continue;
                pa.add(p2);
            }
            p = pa;
        }
        if ((p == null || p.size() == 0) && (p1 = this.a.calque.getFirstCatalog()) != null) {
            p = new Vector<Plan>();
            p.add(p1);
        }
        if (p.size() == 0) {
            Aladin.warning(this.frameMacro, Aladin.chaine.getString("NEEDCAT"));
        }
        ptm.reset();
        int n = 0;
        Enumeration e = p.elements();
        while (e.hasMoreElements()) {
            Plan p12 = (Plan)e.nextElement();
            if (!p12.isReady() || !p12.isCatalog()) continue;
            Iterator<Obj> it = p12.iterator();
            while (it.hasNext()) {
                Obj o = it.next();
                if (!(o instanceof Source)) continue;
                Source s = (Source)o;
                ptm.addRecord(new String[]{++n + "", s.id, this.a.localisation.J2000ToString(s.raj, s.dej), s.plan.label});
            }
        }
        ptm.initTable();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String command = ae.getActionCommand();
        if (command.equals(FrameMacro.LOAD_SCRIPT)) {
            File file;
            JFileChooser fChooser = this.getJFileChooser(FrameMacro.LOAD_SCRIPT);
            int retval = fChooser.showDialog(this.frameMacro, command);
            if (retval == 0 && (file = fChooser.getSelectedFile()) != null) {
                String script = "";
                try {
                    script = this.getScriptFromReader(new BufferedReader(new FileReader(file)));
                }
                catch (IOException e) {
                    Aladin.warning(this.frameMacro, Aladin.chaine.getString("FTIOERR") + " : " + e, 1);
                    return;
                }
                this.frameMacro.setScript(script);
            }
        } else if (command.equals(FrameMacro.SAVE_SCRIPT)) {
            File file;
            JFileChooser fChooser = this.getJFileChooser(FrameMacro.SAVE_SCRIPT);
            int retval = fChooser.showDialog(this.frameMacro, command);
            if (retval == 0 && (file = fChooser.getSelectedFile()) != null) {
                try {
                    DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
                    String script = this.frameMacro.getScriptText();
                    if (!script.startsWith("#AJS")) {
                        out.writeBytes("#AJS" + Util.CR);
                    }
                    out.writeBytes(script.replaceAll("\\n", Util.CR));
                    out.close();
                }
                catch (IOException e) {
                    Aladin.warning(this.frameMacro, Aladin.chaine.getString("FTIOERR") + " : " + e);
                }
            }
        } else if (command.equals(FrameMacro.LOAD_PARAMS)) {
            File file;
            JFileChooser fChooser = this.getJFileChooser(FrameMacro.LOAD_PARAMS);
            int retval = fChooser.showDialog(this.frameMacro, command);
            if (retval == 0 && (file = fChooser.getSelectedFile()) != null) {
                this.macroModel.getParamTableModel().reset();
                try {
                    BufferedReader reader = new BufferedReader(new FileReader(file));
                    this.loadParams(reader);
                }
                catch (IOException e) {
                    Aladin.warning(this.frameMacro, Aladin.chaine.getString("FTIOERR") + " : " + e, 1);
                    return;
                }
            }
        } else if (command.equals(FrameMacro.IMPORT_PARAMS)) {
            this.importParams();
        } else if (command.equals(FrameMacro.SAVE_PARAMS)) {
            File file;
            JFileChooser fChooser = this.getJFileChooser(FrameMacro.SAVE_PARAMS);
            int retval = fChooser.showDialog(this.frameMacro, command);
            if (retval == 0 && (file = fChooser.getSelectedFile()) != null) {
                try {
                    DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
                    MacroModel.ParamRecord[] records = this.macroModel.getParamTableModel().getRecords();
                    for (int i = 0; i < records.length; ++i) {
                        String s = ((Object)records[i]).toString();
                        if (s.trim().length() <= 0) continue;
                        out.writeBytes(((Object)records[i]).toString());
                        if (i >= records.length - 1) continue;
                        out.writeBytes(Util.CR);
                    }
                    out.close();
                }
                catch (IOException e) {
                    Aladin.warning(this.frameMacro, Aladin.chaine.getString("FTIOERR") + " : " + e);
                }
            }
        } else if (command.equals(FrameMacro.SEEHELP)) {
            this.frameMacro.showHelp();
        } else if (command.equals(FrameMacro.LOADEX)) {
            this.frameMacro.setScript(Aladin.chaine.getString("FMSCRIPTEX"));
            this.macroModel.getParamTableModel().reset();
            try {
                this.loadParams(new BufferedReader(new InputStreamReader(new ByteArrayInputStream(Aladin.chaine.getString("FMPARAMSEX").getBytes()))));
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                Aladin.warning("Can't load example parameters !");
            }
        } else if (command.equals(FrameMacro.ADD_COL)) {
            this.macroModel.getParamTableModel().addEmptyCol();
        } else if (command.equals(FrameMacro.CLEAR_PARAMS)) {
            this.macroModel.getParamTableModel().reset();
            this.macroModel.getParamTableModel().initTable();
            this.macroModel.getParamTableModel().addEmptyCol();
        } else if (command.equals(FrameMacro.EXEC_CURRENT)) {
            this.execCurrentParams();
        } else if (command.equals(FrameMacro.EXEC_NEXT)) {
            this.execNextParams();
        } else if (command.equals(FrameMacro.EXEC_ALL)) {
            this.execAllParams(0);
        } else if (command.equals(FrameMacro.EXEC_ALL_FROM_CURRENT)) {
            int row = this.frameMacro.getParamTable().getSelectedRow();
            this.execAllParams(row);
        } else if (command.equals(FrameMacro.STOP)) {
            this.stopCurrentExec();
        } else if (command.equals(FrameMacro.DELETE)) {
            this.deleteSelectedRow();
        } else if (command.equals(FrameMacro.CLOSE)) {
            this.frameMacro.setVisible(false);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        JTextPane tp = (JTextPane)e.getSource();
        int idx = tp.viewToModel(e.getPoint());
        this.frameMacro.testIfColorLink(idx);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.frameMacro.testIfColorLink(-1);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getSource() instanceof JTable && this.frameMacro.getParamTable().getSelectedRow() >= 0 && e.isPopupTrigger() && this.frameMacro.getParamTable().getRowCount() > 1) {
            this.frameMacro.getPopup().show(e.getComponent(), e.getX(), e.getY());
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        String word = this.frameMacro.getCmdWordUnderMouse();
        if (word == null) {
            return;
        }
        this.a.command.execHelpCmd(word);
    }

    private void stopCurrentExec() {
        if (this.execThread != null && this.execThread.isAlive()) {
            this.a.command.killSync();
            this.stopThread = true;
            this.frameMacro.setEnabledStopBtn(false);
        }
    }

    private void deleteSelectedRow() {
        int idx = this.frameMacro.getParamTable().getSelectedRow();
        if (idx < 0) {
            return;
        }
        this.macroModel.getParamTableModel().deleteRecord(idx);
    }

    private synchronized void execCurrentParams() {
        if (this.execThread != null && this.execThread.isAlive()) {
            Aladin.warning(this.frameMacro, "Previous execution not finished yet !", 1);
            return;
        }
        this.execThread = new Thread("AladinMacroExeParam"){

            @Override
            public void run() {
                MacroController.this.frameMacro.setEnabledStopBtn(true);
                MacroController.this.stopThread = false;
                MacroController.this.frameMacro.hilightScriptLine(0);
                ((MacroController)MacroController.this).a.command.execHelpCmd("off");
                String[] commands = MacroController.this.getScriptCommands();
                Map map = MacroController.this.getParamMapForRow(MacroController.this.frameMacro.getParamTable().getSelectedRow());
                if (map == null) {
                    return;
                }
                MacroController.this.execScript(commands, new Map[]{map}, null);
                MacroController.this.frameMacro.hilightScriptLine(-1);
                MacroController.this.frameMacro.setEnabledStopBtn(false);
            }
        };
        this.execThread.start();
        this.a.log("macroController", "execCurrent");
    }

    private synchronized void execNextParams() {
        int row = this.frameMacro.getParamTable().getSelectedRow() + 1;
        if (row >= this.macroModel.getParamTableModel().getRowCount()) {
            Aladin.warning(this.frameMacro, "No next params row to execute, stop execution !", 1);
            return;
        }
        this.frameMacro.getParamTable().setRowSelectionInterval(row, row);
        this.execCurrentParams();
    }

    private synchronized void execAllParams(final int row) {
        if (this.execThread != null && this.execThread.isAlive()) {
            Aladin.warning(this.frameMacro, "Previous execution not finished yet !", 1);
            return;
        }
        if (row == -1) {
            Aladin.warning(this.frameMacro, "No parameter row selected, stop execution !", 1);
            return;
        }
        this.frameMacro.getParamTable().setRowSelectionInterval(row, row);
        this.execThread = new Thread("AladinMacroExe"){

            @Override
            public void run() {
                MacroController.this.frameMacro.setEnabledStopBtn(true);
                MacroController.this.stopThread = false;
                MacroController.this.frameMacro.hilightScriptLine(0);
                ((MacroController)MacroController.this).a.command.execHelpCmd("off");
                String[] commands = MacroController.this.getScriptCommands();
                Map[] maps = new Map[MacroController.this.macroModel.getParamTableModel().getRowCount() - row];
                for (int i = 0; i < maps.length; ++i) {
                    maps[i] = MacroController.this.getParamMapForRow(i + row);
                }
                int[] idx = new int[maps.length];
                for (int i = 0; i < idx.length; ++i) {
                    idx[i] = i + row;
                }
                MacroController.this.execScript(commands, maps, idx);
                MacroController.this.frameMacro.hilightScriptLine(-1);
                MacroController.this.frameMacro.setEnabledStopBtn(false);
            }
        };
        this.execThread.start();
        this.a.log("macroController", "execAll");
    }

    private void execScript(String[] commands, Map[] paramMaps, int[] idx) {
        for (int i = 0; i < paramMaps.length; ++i) {
            if (idx != null && idx[i] < this.macroModel.getParamTableModel().getRowCount()) {
                this.frameMacro.getParamTable().setRowSelectionInterval(idx[i], idx[i]);
            }
            if (paramMaps[i] == null) continue;
            for (int j = 0; j < commands.length; ++j) {
                if (this.stopThread) {
                    this.stopThread = false;
                    this.frameMacro.hilightScriptLine(-1);
                    Aladin.warning(this.frameMacro, "Execution interrupted !", 1);
                    return;
                }
                this.frameMacro.hilightScriptLine(j);
                this.macroModel.executeScript(commands[j], paramMaps[i]);
            }
        }
    }

    private Map getParamMapForRow(int row) {
        HashMap<String, String> map = new HashMap<String, String>();
        int nbCol = this.macroModel.getParamTableModel().getColumnCount();
        if (row == -1) {
            Aladin.warning(this.frameMacro, "No parameter row selected, stop execution !", 1);
            return null;
        }
        boolean returnNull = true;
        for (int i = 0; i < nbCol; ++i) {
            String curCol = this.macroModel.getParamTableModel().getColumnName(i);
            String curVal = (String)this.macroModel.getParamTableModel().getValueAt(row, i);
            if (returnNull && curVal != null && curVal.trim().length() > 0) {
                returnNull = false;
            }
            map.put(curCol, curVal);
        }
        return returnNull ? null : map;
    }

    private String[] getScriptCommands() {
        String s = this.frameMacro.getScriptText();
        String sep = "\n";
        StringTokenizer st = new StringTokenizer(s, sep, true);
        Vector<String> v = new Vector<String>();
        String ocmd = sep;
        while (st.hasMoreTokens()) {
            String cmd = st.nextToken();
            if (sep.equals(cmd)) {
                if (!sep.equals(ocmd)) {
                    ocmd = cmd;
                    continue;
                }
                ocmd = cmd;
                cmd = "";
            } else {
                ocmd = cmd;
            }
            v.addElement(cmd);
        }
        Object[] commands = new String[v.size()];
        v.copyInto(commands);
        v = null;
        return commands;
    }

    private JFileChooser getJFileChooser(String label) {
        if (this.fChooser == null) {
            this.fChooser = new JFileChooser(this.a.getDefaultDirectory());
        }
        if (label.equals(FrameMacro.LOAD_SCRIPT)) {
            this.fChooser.setDialogType(0);
            this.fChooser.setFileSelectionMode(0);
            this.fChooser.resetChoosableFileFilters();
            this.fChooser.addChoosableFileFilter(new FileNameExtensionFilter(new String[]{"ajs", "txt"}, "Aladin script files (*.ajs, *.txt)"));
            this.fChooser.setFileFilter(this.fChooser.getAcceptAllFileFilter());
        } else if (label.equals(FrameMacro.LOAD_PARAMS)) {
            this.fChooser.setDialogType(0);
            this.fChooser.setFileSelectionMode(0);
            this.fChooser.resetChoosableFileFilters();
            this.fChooser.addChoosableFileFilter(new FileNameExtensionFilter(new String[]{"txt", "tsv", "csv"}, "CSV Files (*.txt, *.tsv, *.csv)"));
            this.fChooser.setFileFilter(this.fChooser.getAcceptAllFileFilter());
        } else if (label.equals(FrameMacro.SAVE_SCRIPT) || label.equals(FrameMacro.LOAD_SCRIPT)) {
            this.fChooser.setDialogType(1);
            this.fChooser.resetChoosableFileFilters();
        }
        return this.fChooser;
    }

    protected MacroModel getMacroModel() {
        return this.macroModel;
    }

    protected void setMacroModel(MacroModel macroModel) {
        this.macroModel = macroModel;
    }

    class FileNameExtensionFilter
    extends FileFilter {
        String[] extensions;
        String desc;

        FileNameExtensionFilter(String[] extensions, String desc) {
            this.extensions = extensions;
            this.desc = desc;
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String ext = this.getExtension(f);
            return Util.indexInArrayOf(ext, this.extensions) >= 0;
        }

        @Override
        public String getDescription() {
            return this.desc;
        }

        public String getExtension(File f) {
            if (f == null) {
                return null;
            }
            String ext = null;
            String s = f.getName();
            int i = s.lastIndexOf(46);
            if (i > 0 && i < s.length() - 1) {
                ext = s.substring(i + 1).toLowerCase();
            }
            return ext;
        }
    }
}

