/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.AppMessagingInterface;
import cds.aladin.Chaine;
import cds.aladin.FilterProperties;
import cds.aladin.Legende;
import cds.aladin.MyScrollbar;
import cds.aladin.Obj;
import cds.aladin.PlanBG;
import cds.aladin.PlanField;
import cds.aladin.Search;
import cds.aladin.Source;
import cds.aladin.Tool;
import cds.aladin.Widget;
import cds.aladin.WidgetControl;
import cds.aladin.Words;
import cds.tools.Util;
import cds.xml.Field;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Formatter;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.Timer;

public final class MCanvas
extends JComponent
implements MouseListener,
MouseMotionListener,
AdjustmentListener,
KeyListener,
ActionListener,
MouseWheelListener,
Widget {
    private int NBLIGNE = 5;
    static Font FONT = Aladin.COURIER;
    static final int HF = Aladin.SIZE;
    static final int HL;
    static final int MH;
    static final int MB = 1;
    static final Color BG;
    private static Color COLORBORD;
    static final int[] tX;
    static final int[] tY;
    Aladin aladin;
    MyScrollbar scrollV;
    MyScrollbar scrollH;
    int W = 500;
    int H;
    Image img;
    int wblanc;
    int firstsee;
    int lastsee;
    int currentsee = -1;
    int nbligne;
    Source oo;
    Vector mouseLigne;
    Vector showLigne;
    Words wButton;
    Obj oButton;
    int yrep = -1;
    int absX = 0;
    int oy = -1;
    int ox = -1;
    boolean flagDrag = false;
    boolean firstUpdate = true;
    int currentselect = -2;
    protected int triTag = 0;
    protected Legende oleg = null;
    protected Vector ligneHead = null;
    protected Source objSelect = null;
    protected Source objShow = null;
    private boolean flagDrawHead = false;
    private int onBordField = -1;
    private int onBordX;
    int indiceCourant = -1;
    int sortField = -1;
    Source sCourante = null;
    private static String TIPHEAD;
    private static String TIPGLU;
    private static String TIPARCH;
    private static String TIPFOV;
    private static String TIPTAG;
    JPopupMenu popMenu;
    JPopupMenu popMenuTag;
    JMenuItem menuTriA;
    JMenuItem menuTriD;
    JMenuItem menuCopyVal;
    JMenuItem menuCopyCoord;
    JMenuItem menuCopyMeasurement;
    JMenuItem menuCopyAll;
    JMenuItem menuCopyAllAscii;
    JMenuItem menuTag1;
    JMenuItem menuUntag1;
    JMenuItem menuHelpTag;
    JMenuItem menuCreateMulti;
    JMenuItem menuCreateUniq;
    JMenuItem menuUnselect;
    JMenuItem menuAddColumn;
    JMenuItem menuGoto;
    JMenuItem menuDel;
    JMenuItem menuTableInfo;
    private String urlSamp;
    private JPopupMenu popMenuSAMP = null;
    private JMenu menuBroadcastSpectrum;
    private String MALLAPPS;
    private String MBROADCASTSPECTRUM;
    static Color C1;
    public static Color C2;
    protected static Color C3;
    static Color C4;
    static Color C5;
    static Color C6;
    static Color C7;
    private Image pin = null;
    int memFirstsee = 0;
    private int flagDragX = -1;
    private int flagDragY = -1;
    Timer timer = null;
    Source oTimer = null;
    int onField = -1;
    private Words ow = null;
    private int omax = -1;
    private boolean showScrollH = true;
    private int onl = -1;
    private WidgetControl voc = null;

    protected MCanvas(Aladin aladin, MyScrollbar scrollV, MyScrollbar scrollH) {
        this.aladin = aladin;
        this.scrollV = scrollV;
        this.scrollH = scrollH;
        this.wblanc = this.getToolkit().getFontMetrics(FONT).stringWidth("M");
        if (Aladin.OUTREACH) {
            this.NBLIGNE = 3;
        }
        TIPHEAD = Aladin.chaine.getString("TIPHEAD");
        TIPGLU = Aladin.chaine.getString("TIPGLU");
        TIPARCH = Aladin.chaine.getString("TIPARCH");
        TIPFOV = Aladin.chaine.getString("TIPFOV");
        TIPTAG = Aladin.chaine.getString("TIPTAG");
        this.createPopupMenu();
        this.createPinPopupMenu();
        this.setOpaque(true);
        this.setDoubleBuffered(false);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
        this.addMouseWheelListener(this);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(2, HL * this.NBLIGNE + MH + 1);
    }

    private void createPopupMenu() {
        JMenuItem j;
        Chaine c = Aladin.chaine;
        this.popMenu = new JPopupMenu();
        this.popMenu.setLightWeightPopupEnabled(false);
        this.menuUnselect = j = new JMenuItem(c.getString("MFUNSELECT"));
        this.popMenu.add(j);
        j.addActionListener(this);
        this.menuDel = j = new JMenuItem(c.getString("MFDEL"));
        this.popMenu.add(j);
        j.addActionListener(this);
        this.menuGoto = j = new JMenuItem(c.getString("MFGOTOIMG"));
        this.popMenu.add(j);
        j.addActionListener(this);
        this.menuTriA = j = new JMenuItem(c.getString("MFASCSORT"));
        this.popMenu.add(j);
        j.addActionListener(this);
        this.menuTriD = j = new JMenuItem(c.getString("MFADESCSORT"));
        this.popMenu.add(j);
        j.addActionListener(this);
        this.popMenu.addSeparator();
        JMenu m = new JMenu(c.getString("MFCOPYGEN"));
        this.popMenu.add(m);
        this.menuCopyVal = j = new JMenuItem(c.getString("MFCOPYVAL"));
        m.add(j);
        j.addActionListener(this);
        this.menuCopyCoord = j = new JMenuItem(c.getString("MFCOPYCOORD"));
        m.add(j);
        j.addActionListener(this);
        this.menuCopyMeasurement = j = new JMenuItem(c.getString("MFCOPYMEASUREMENT"));
        m.add(j);
        j.addActionListener(this);
        this.menuCopyAllAscii = j = new JMenuItem(c.getString("MFCOPYASCII"));
        m.add(j);
        j.addActionListener(this);
        this.menuCopyAll = j = new JMenuItem(c.getString("MFCOPY"));
        m.add(j);
        j.addActionListener(this);
        this.popMenu.addSeparator();
        m = new JMenu(c.getString("MFCREATE"));
        this.popMenu.add(m);
        this.menuCreateMulti = j = new JMenuItem(c.getString("VWCPLANEUNIQ"));
        m.add(j);
        j.addActionListener(this);
        this.menuCreateUniq = j = new JMenuItem(c.getString("VWCPLANEMULTI"));
        m.add(j);
        j.addActionListener(this);
        this.menuAddColumn = j = new JMenuItem(this.aladin.ADDCOL);
        this.popMenu.add(j);
        j.addActionListener(this);
        this.menuTableInfo = j = new JMenuItem(this.aladin.TABLEINFO);
        this.popMenu.add(j);
        j.addActionListener(this);
        this.add(this.popMenu);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src instanceof Timer) {
            this.endTimerHist();
            return;
        }
        if (src == this.menuTriA || src == this.menuTriD) {
            this.aladin.mesure.tri(src == this.menuTriA);
        } else if (src == this.menuTag1) {
            this.aladin.mesure.tag();
        } else if (src == this.menuUntag1) {
            this.aladin.mesure.untag();
        } else if (src == this.menuHelpTag) {
            Aladin.info(Aladin.chaine.getString("MTAGINFO"));
        } else if (src == this.menuCreateMulti) {
            this.aladin.cloneObj(false);
        } else if (src == this.menuCreateUniq) {
            this.aladin.cloneObj(true);
        } else if (src == this.menuGoto) {
            this.aladin.view.gotoThere(this.objSelect);
            this.aladin.view.zoomOnSource(this.objSelect);
        } else if (src == this.menuCopyAll) {
            this.aladin.copyToClipBoard(this.aladin.mesure.getText());
        } else if (src == this.menuCopyAllAscii) {
            this.aladin.copyToClipBoard(this.aladin.mesure.getText(true));
        } else if (src == this.menuCopyCoord) {
            this.aladin.copyToClipBoard(this.aladin.mesure.getCurObjCoord());
        } else if (src == this.menuCopyVal) {
            this.aladin.copyToClipBoard(this.aladin.mesure.getCurObjVal());
        } else if (src == this.menuCopyMeasurement) {
            this.aladin.copyToClipBoard(this.aladin.mesure.getCurObjMeasurement());
        } else if (src == this.menuUnselect) {
            this.deselect(this.objSelect);
        } else if (src == this.menuDel) {
            this.delete(this.objSelect);
        } else if (src == this.menuTableInfo) {
            this.aladin.tableInfo(this.objSelect.plan);
        } else if (src == this.menuAddColumn) {
            this.aladin.addCol(this.objSelect.plan);
        } else if (src instanceof JMenuItem && ((JMenuItem)src).getActionCommand().equals(this.MBROADCASTSPECTRUM)) {
            String o = ((JMenuItem)src).getText();
            if (this.urlSamp == null) {
                return;
            }
            this.sendBySAMP(this.urlSamp, o);
            this.urlSamp = null;
        }
        if (this.aladin.view.zoomview.flagSED) {
            this.aladin.view.zoomview.repaint();
        }
    }

    protected void sendBySAMP(String url, String plasticApp) {
        AppMessagingInterface mMgr = this.aladin.getMessagingMgr();
        if (!Aladin.PLASTIC_SUPPORT || !mMgr.isRegistered()) {
            return;
        }
        ArrayList<Object> recipientsList = null;
        if (plasticApp != null) {
            recipientsList = new ArrayList<Object>();
            recipientsList.add(mMgr.getAppWithName(plasticApp));
        }
        Aladin.trace(4, "MCanvas.sendBySAMP spectrum [" + url + "] to " + (plasticApp == null ? "all" : plasticApp));
        try {
            mMgr.getPlasticWidget().animateWidgetSend();
            mMgr.sendMessageLoadSpectrum(url, url, "Spectrum", new Hashtable(), recipientsList);
            this.aladin.glu.log(mMgr.getProtocolName(), "sending data or spectrum URL");
        }
        catch (Exception e) {
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            Aladin.warning("SAMP error: " + e.getMessage());
        }
    }

    protected void toSamp(String url, int x, int y) {
        this.urlSamp = url;
        this.showSAMPPopMenu(x, y);
    }

    private int getTagFlag() {
        int n = 0;
        for (int i = 0; i < this.aladin.mesure.nbSrc; ++i) {
            Source s = this.aladin.mesure.src[i];
            if (!s.isTagged()) continue;
            ++n;
        }
        return n == 0 ? 0 : (n == this.aladin.mesure.nbSrc ? 2 : 1);
    }

    private void popPinShow(int x, int y) {
        int tagMode = this.getTagFlag();
        this.menuTag1.setEnabled(tagMode < 2);
        this.menuUntag1.setEnabled(tagMode > 0);
        this.popMenuTag.show(this, x, y);
    }

    private void popupShow(int x, int y) {
        boolean tag = this.getTagFlag() == 1;
        boolean flag = this.objSelect != null;
        this.menuUnselect.setEnabled(flag);
        this.menuDel.setEnabled(this.objSelect != null && this.objSelect.plan.isSourceRemovable());
        this.menuCopyCoord.setEnabled(flag);
        this.menuGoto.setEnabled(flag);
        this.menuCopyMeasurement.setEnabled(flag);
        this.popMenu.show(this, x, y);
    }

    private void createSAMPPopupMenu() {
        this.popMenuSAMP = new JPopupMenu("SAMP");
        String appMsgProtocolName = this.aladin.getMessagingMgr().getProtocolName();
        this.MBROADCASTSPECTRUM = Aladin.chaine.getString("SLMBDCASTSPECTRUM");
        if (Aladin.PLASTIC_SUPPORT) {
            this.menuBroadcastSpectrum = new JMenu(this.MBROADCASTSPECTRUM);
            this.popMenuSAMP.add(this.menuBroadcastSpectrum);
        }
    }

    private void showSAMPPopMenu(int x, int y) {
        if (this.popMenuSAMP == null) {
            this.createSAMPPopupMenu();
        }
        if (Aladin.PLASTIC_SUPPORT) {
            AppMessagingInterface mMgr = this.aladin.getMessagingMgr();
            ArrayList<String> spectrumApps = mMgr.getAppsSupporting(AppMessagingInterface.ABSTRACT_MSG_LOAD_SPECTRUM_FROM_URL);
            this.menuBroadcastSpectrum.setEnabled(spectrumApps.size() > 0);
            this.menuBroadcastSpectrum.removeAll();
            if (spectrumApps != null && spectrumApps.size() > 0) {
                for (String appName : spectrumApps) {
                    JMenuItem item = new JMenuItem(appName);
                    this.menuBroadcastSpectrum.add(item);
                    item.setActionCommand(this.MBROADCASTSPECTRUM);
                    item.addActionListener(this);
                }
            }
        }
        this.popMenuSAMP.show(this, x - 15, y);
    }

    protected void initX() {
        this.absX = 0;
    }

    private void drawBordG(Graphics g, int x, int y, int width) {
        g.setColor(COLORBORD);
        g.drawLine(x + width + 2, y, x + width + 2, y + HF + 2);
    }

    private void drawSort(Graphics g, int x, int y, int sort, Color background) {
        int w = 8;
        Color c = background == Color.white ? Color.lightGray : Color.white;
        g.setColor(background);
        g.fillRect(x - 2, y - HF + 1, w + 5, HF);
        y -= w / 2 + 1;
        g.setColor(Color.black);
        if (sort == 2) {
            g.drawLine(x + w / 2, y + w / 2, x, y - w / 2);
            g.drawLine(x, y - w / 2, x + w, y - w / 2);
            g.setColor(c);
            g.drawLine(x + w / 2, y + w / 2, x + w, y - w / 2);
        } else if (sort == 1) {
            g.drawLine(x + w / 2, y - w / 2, x, y + w / 2);
            g.setColor(c);
            g.drawLine(x + w / 2, y - w / 2, x + w, y + w / 2);
            g.drawLine(x, y + w / 2, x + w, y + w / 2);
        }
    }

    private int drawButton(Graphics g, int x, int y, int h, int width, String s, Words w) {
        y = y - HF + 1;
        if (x + width >= 1) {
            int l = width - 3;
            g.setColor(w.samp ? Color.yellow : Aladin.BKGD);
            g.fillRect(x, y, l, h);
            g.setColor(w.pushed ? Color.black : Color.white);
            g.drawLine(x, y, x + l, y);
            g.drawLine(x, y, x, y + h);
            g.setColor(w.pushed ? Color.white : Color.black);
            g.drawLine(x + l, y + h, x + l, y);
            g.drawLine(x + l, y + h, x, y + h);
            if (w.pushed) {
                g.setColor(Color.red);
            } else if (w.haspushed) {
                g.setColor(Color.white);
            } else {
                g.setColor(Color.black);
            }
            g.drawString(s, x + 3, y + h - 1);
        }
        return width;
    }

    protected int drawWords(Graphics g, Words w, boolean flagClear) {
        return this.drawWords(g, w, flagClear, w.y <= HF ? Aladin.BKGD : BG);
    }

    private int drawWords(Graphics g, Words w, boolean flagClear, Color background) {
        int width;
        int j;
        int y = w.y + HF;
        int x = w.x;
        String text = w.text;
        if (w.precision >= 0 && (j = text.indexOf(32)) < 0) {
            try {
                double v = Double.parseDouble(w.text);
                text = new Formatter(Locale.ENGLISH).format("%." + w.precision + "f", v).toString();
                int i = text.lastIndexOf(46);
                if (i > 0) {
                    int k;
                    int n = text.length();
                    for (k = n - 1; k > i && text.charAt(k) == '0'; --k) {
                    }
                    if (k != n - 1) {
                        if (text.charAt(k) == '.') {
                            --k;
                        }
                        StringBuilder trail = new StringBuilder(16);
                        for (j = k; j < n - 1; ++j) {
                            trail.append(' ');
                        }
                        text = text.substring(0, k + 1) + trail.toString();
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        boolean flagCut = false;
        FontMetrics fm = g.getFontMetrics();
        int widthw = fm.stringWidth(text) + (w.sort != 0 ? 12 : 0);
        if (w.onMouse) {
            if (widthw < w.width * this.wblanc) {
                width = w.width * this.wblanc;
            } else {
                width = widthw;
                if (w.archive || w.footprint) {
                    width += 3;
                }
            }
        } else {
            width = w.width * this.wblanc;
            boolean bl = flagCut = widthw > w.width * this.wblanc;
        }
        if (flagClear || w.onMouse || w.show) {
            g.setColor(w.onMouse ? C6 : (w.show ? C5 : background));
            g.fillRect(x - 4, y - HF, width + 7, HL - 1);
            if (w.onMouse && !w.archive && !w.footprint) {
                int M = 2;
                g.setColor(C7);
                g.fillRect(x - 4 + M, y - HF + M - 1, width + 7 - 2 * M, HL - 1 - 2 * M + 2);
            }
        }
        if (x + width < 1 || x > this.W) {
            return width;
        }
        if (w.glu && !w.archive && !w.footprint) {
            if (w.pushed) {
                g.setColor(Color.red);
            } else if (w.haspushed) {
                g.setColor(C2);
            } else {
                g.setColor(Color.blue);
            }
        } else {
            g.setColor(w.computed ? C4 : Color.black);
        }
        if (flagCut) {
            int c = (widthw - (width - (w.archive ? 6 : 0))) / this.wblanc + 2;
            int offset = text.length() - c;
            if (offset > 0) {
                text = text.substring(0, offset);
            }
        }
        int xtext = x;
        if (!flagCut) {
            if (w.align == 1) {
                xtext = x + width - widthw;
            } else if (w.align == 2) {
                xtext = x + width / 2 - widthw / 2;
            }
        }
        if (w.archive || w.footprint) {
            this.drawButton(g, xtext, y, HF, width, text, w);
        } else {
            g.drawString(text, xtext, y);
        }
        if (flagCut) {
            Font f = g.getFont();
            int xp = g.getFontMetrics().stringWidth(text) + xtext;
            g.setFont(Aladin.PLAIN);
            g.drawString("...", xp, y);
            g.setFont(f);
        }
        if (w.sort != 0) {
            Color c = w.onMouse ? Color.white : background;
            this.drawSort(g, x + width - 10, y, w.sort, c);
        }
        if (w.glu) {
            g.drawLine(xtext, y + 1, xtext + fm.stringWidth(text), y + 1);
        }
        if (w.pin && !this.aladin.isFullScreen()) {
            if (this.pin == null) {
                this.pin = this.aladin.getImagette("Pin.png");
            }
            g.drawImage(this.pin, x - 16, y - HF - 1, this.aladin);
        }
        this.drawBordG(g, x, y - HF, width);
        return w.width * this.wblanc;
    }

    protected int drawLigne(Graphics g, int y, Vector ligne, boolean flagClear) {
        return this.drawLigne(g, 0, y, ligne, flagClear, this.W);
    }

    protected int drawLigne(Graphics g, int X, int y, Vector ligne, boolean flagClear, int W) {
        int x = X + this.absX;
        Enumeration e = ligne.elements();
        Source o = (Source)e.nextElement();
        if (flagClear && W != -1) {
            g.setColor(BG);
            g.fillRect(X + 1, y - HF, X + W, HF + 3);
        }
        Words rep = null;
        boolean flagFirst = true;
        boolean show = false;
        int i = 0;
        while (e.hasMoreElements()) {
            int width;
            Words w = (Words)e.nextElement();
            if (w.show) {
                show = true;
            }
            if (i == 0) {
                if (flagFirst) {
                    rep = w;
                }
                width = tX[2];
            } else {
                w.setPosition(x, y - HF, 0, 0);
                width = this.drawWords(g, w, flagClear);
            }
            w.setPosition(x, y - HF, width, HF);
            x += width + this.wblanc;
            flagFirst = false;
            ++i;
        }
        if (W != -1) {
            if (rep != null && y > HF) {
                Util.drawCheckbox(g, X + 3, y - 11, o.plan.c, null, null, o.isTagged());
            }
            if (x < X + W) {
                g.setColor(show ? C5 : BG);
                g.fillRect(x - 4, y - HF, X + W - (x - 4), HF + 2);
            }
            g.setColor(COLORBORD);
            g.drawLine(X + 1, y + 2, X + 1 + W, y + 2);
        }
        return x - this.absX;
    }

    private void quickDrawHead(Graphics g, Source o) {
        if (o != null && o.leg == this.oleg) {
            return;
        }
        this.drawHead(g, o);
    }

    private void clearHead(Graphics g, int X, int W) {
        this.oleg = null;
        if (W <= 0) {
            return;
        }
        g.setColor(BG);
        g.fillRect(X + 1, 1, W, HF + 3);
    }

    protected void drawHead(Graphics g, Source o) {
        this.drawHead(g, 0, 0, o, this.W);
    }

    protected void drawHead(Graphics g, int X, int y, Source o, int W) {
        Vector head;
        if (o == null && this.oleg == null || o != null && this.oleg == o.leg) {
            head = this.ligneHead;
        } else {
            head = o == null ? null : this.aladin.mesure.getHeadLine(o);
            this.oleg = o == null ? null : o.leg;
            this.ligneHead = head;
        }
        if (head == null && W != -1) {
            this.clearHead(g, X, W);
            return;
        }
        int x = X + this.absX;
        y += HF + 1;
        Enumeration e = head.elements();
        o = (Source)e.nextElement();
        int i = 0;
        while (e.hasMoreElements()) {
            int width;
            Words w = (Words)e.nextElement();
            if (i == 0) {
                width = tX[2];
                if (W != -1) {
                    g.setColor(Aladin.BKGD);
                    g.fillRect(x + 1, y - HF, width + 2, HF + 2);
                }
            } else {
                w.setPosition(x, y - HF, 0, 0);
                width = this.drawWords(g, w, true, Aladin.BKGD);
            }
            w.setPosition(x, y - HF, width, HF);
            x += width + this.wblanc;
            ++i;
        }
        if (W != -1) {
            if (x < X + W) {
                g.setColor(Aladin.BKGD);
                g.fillRect(x - 4, y - HF, W - (x - 4), HF + 2);
            }
            g.setColor(o.plan.c);
            g.drawLine(X + 1, y + 2, X + 1 + W, y + 2);
        }
    }

    @Override
    public void mouseReleased(MouseEvent ev) {
        if (this.aladin.inHelp) {
            this.aladin.setHelp(false);
            return;
        }
        if (this.flagDrag) {
            return;
        }
        int x = ev.getX();
        int y = ev.getY();
        this.requestFocusInWindow();
        if ((ev.getModifiers() & 4) != 0) {
            this.popupShow(x, y);
            return;
        }
        if (FilterProperties.clickInMesure(this.sCourante, this.indiceCourant)) {
            return;
        }
        if (this.wButton != null) {
            this.wButton.pushed = false;
            this.wButton.haspushed = true;
            this.wButton.callArchive(this.aladin, this.oButton);
            this.wButton = null;
            this.oButton = null;
            this.repaint();
        }
        this.flagDragX = -1;
        this.flagDragY = -1;
    }

    private void tri(Source o, int nField) {
        boolean ascending;
        if (nField == -1) {
            o.leg.clearSort();
            this.triTag = 1;
            ascending = true;
        } else {
            this.triTag = 0;
            ascending = o.leg.switchSort(nField);
        }
        this.ligneHead = this.aladin.mesure.getHeadLine(o);
        this.aladin.mesure.tri(o, nField, ascending);
    }

    protected void tri(Source o, int nField, boolean ascending) {
        o.leg.setSort(nField, ascending ? 1 : 2);
        this.ligneHead = this.aladin.mesure.getHeadLine(o);
        this.aladin.mesure.tri(o, nField, ascending);
    }

    private void createPinPopupMenu() {
        JMenuItem j;
        Chaine c = Aladin.chaine;
        this.popMenuTag = new JPopupMenu();
        this.popMenuTag.setLightWeightPopupEnabled(false);
        this.menuTag1 = j = new JMenuItem(c.getString("MFTAG"));
        this.popMenuTag.add(j);
        j.addActionListener(this);
        this.menuUntag1 = j = new JMenuItem(c.getString("MFUNTAG"));
        this.popMenuTag.add(j);
        j.addActionListener(this);
        this.menuHelpTag = j = new JMenuItem("Help...");
        this.popMenuTag.add(j);
        j.addActionListener(this);
    }

    @Override
    public void mousePressed(MouseEvent ev) {
        if (this.aladin.inHelp) {
            return;
        }
        int x = ev.getX();
        int y = ev.getY();
        boolean flagPopup = false;
        if ((ev.getModifiers() & 4) != 0) {
            this.sortField = this.indiceCourant;
            flagPopup = true;
        }
        if (!flagPopup && y < MH && this.ligneHead != null) {
            if (this.onBordField != -1) {
                this.onBordX = x;
                return;
            }
            if (this.indiceCourant == -1) {
                this.popPinShow(ev.getX(), ev.getY());
                return;
            }
            this.timer.stop();
            Source o = (Source)this.ligneHead.elementAt(0);
            this.aladin.calque.zoom.zoomView.setHist(o, this.indiceCourant);
            this.tri(o, this.indiceCourant);
            return;
        }
        this.aladin.calque.zoom.zoomView.stopHist();
        if (this.currentsee < 0 || this.aladin.mesure.getNbSrc() <= this.currentsee) {
            return;
        }
        this.ox = x;
        this.oy = y;
        this.memFirstsee = this.firstsee;
        Vector ligne = this.aladin.mesure.getWordLine(this.currentsee);
        Enumeration e = ligne.elements();
        Source o = (Source)e.nextElement();
        if (!flagPopup && ev.isShiftDown()) {
            this.deselect(o);
            return;
        }
        if (!flagPopup && this.aladin.frameNewCalib != null && this.aladin.frameNewCalib.isShowing()) {
            this.aladin.frameNewCalib.mouse(0.0, 0.0, null, o);
        }
        if (!flagPopup) {
            boolean rep = ev.getClickCount() == 2 || this.aladin.calque.getPlanBase() instanceof PlanBG ? this.aladin.view.setRepere(o) : this.aladin.view.syncSimple(o);
            this.aladin.search.setColorAndStatus(rep ? 1 : -1);
            this.aladin.mesure.search.setColorAndStatus(rep ? 1 : -1);
            this.aladin.localisation.seeCoord(o, 1);
            if (this.aladin.frameCooTool != null) {
                this.aladin.frameCooTool.setSource(o);
            }
            this.aladin.sendObserver();
            if (x < 15) {
                o.setTag(!o.isTagged());
                this.triTag = 0;
                this.repaint();
                return;
            }
            while (e.hasMoreElements()) {
                Words w = (Words)e.nextElement();
                if (!w.inside(x, y) || !w.glu && !w.footprint) continue;
                if (w.archive) {
                    this.wButton = w;
                    this.oButton = o;
                    w.pushed = true;
                    Graphics g = this.getGraphics();
                    g.setFont(FONT);
                    this.drawWords(g, w, true);
                    return;
                }
                if (w.footprint) {
                    PlanField pf = o.getFootprint().getFootprint();
                    if (pf != null) {
                        pf.setActivated(true);
                        pf.flagOk = true;
                    }
                    o.switchFootprint();
                    return;
                }
                this.aladin.glu.newWindow(ev.isControlDown());
                w.callGlu(this.aladin.glu, this);
                Graphics g = this.getGraphics();
                g.setFont(FONT);
                this.drawWords(g, w, true);
                return;
            }
        }
        if (this.objSelect == null || flagPopup) {
            this.objSelect = o;
            this.setShow(ligne, true);
        } else {
            this.objSelect = null;
        }
        this.flagDragX = x;
        this.flagDragY = y;
        this.flagDrag = false;
        this.currentselect = this.currentselect == this.currentsee ? -2 : this.currentsee;
        this.repaint();
    }

    void deselect(Source o) {
        if (o == null) {
            return;
        }
        if (this.aladin.view.deSelect(o)) {
            this.mouseLigne = null;
            this.repaint();
        }
    }

    void delete(Source o) {
        if (o == null || !o.plan.isSourceRemovable()) {
            return;
        }
        if (this.aladin.view.deSelect(o)) {
            this.mouseLigne = null;
        }
        this.aladin.calque.delObjet(o);
        this.aladin.calque.repaintAll();
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        int mode = e.getWheelRotation();
        int n = this.scrollV.getValue();
        if (n + mode >= this.scrollV.getMaximum()) {
            return;
        }
        if (n + mode < 0) {
            return;
        }
        this.scrollV.setValue(n + mode);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int scroll;
        int offset;
        if (this.aladin.inHelp) {
            return;
        }
        int x = e.getX();
        int y = e.getY();
        if (this.onBordField != -1) {
            Field f = this.oleg.field[this.onBordField];
            int offset2 = (this.onBordX - x) / this.wblanc;
            if (offset2 == 0) {
                return;
            }
            int colSize = f.columnSize;
            if ((colSize -= offset2) < 3) {
                return;
            }
            f.columnSize = colSize;
            this.onBordX = x;
            this.reloadHead();
            this.repaint();
            return;
        }
        if (this.flagDragX != -1 && (offset = this.flagDragX - x) != 0) {
            scroll = this.scrollH.getValue();
            this.scrollH.setValue(scroll + offset);
            this.flagDragX = x;
            this.flagDrag = true;
        }
        if (this.flagDragY != -1 && (offset = (this.flagDragY - y) / HL) != 0) {
            scroll = this.scrollV.getValue();
            this.scrollV.setValue(scroll + offset);
            this.flagDragY = y;
            this.flagDrag = true;
        }
        if (this.flagDrag) {
            this.paintComponent(this.getGraphics());
        }
    }

    private void clearMouseLigne(Graphics g) {
        this.clearLigne1(g, this.mouseLigne, false);
        this.mouseLigne = null;
    }

    private void clearShowLigne(Graphics g) {
        this.clearLigne1(g, this.showLigne, true);
        this.showLigne = null;
    }

    private void clearLigne1(Graphics g, Vector ligne, boolean flagShow) {
        if (ligne == null) {
            return;
        }
        Enumeration e1 = ligne.elements();
        Source o = (Source)e1.nextElement();
        Words rep = null;
        int y = ((Words)ligne.elementAt((int)1)).y;
        g.setColor(y <= HF ? Aladin.BKGD : BG);
        g.fillRect(0, y, this.W, HF + 2);
        Words w = null;
        int size = 0;
        while (e1.hasMoreElements()) {
            w = (Words)e1.nextElement();
            w.onMouse = false;
            if (flagShow) {
                w.show = false;
            }
            if (w.repere) {
                rep = w;
                continue;
            }
            size = this.drawWords(g, w, true);
        }
        int x = w.x + size + 3;
        if (x < this.W) {
            g.setColor(w.show ? C5 : (w.y < HF ? Aladin.BKGD : BG));
            g.fillRect(x, y, this.W - x, HF + 2);
        }
        if (rep != null && y > HF) {
            Util.drawCheckbox(g, 3, y + 1, o.plan.c, null, null, o.isTagged());
        }
    }

    private int initShow(Graphics g, int y, Vector ligne) {
        this.setShow(ligne, true);
        this.showLigne = ligne;
        return this.drawLigne(g, y, ligne, true);
    }

    private void setShow(Vector ligne, boolean flag) {
        if (ligne == null) {
            return;
        }
        Enumeration e1 = ligne.elements();
        e1.nextElement();
        while (e1.hasMoreElements()) {
            Words w = (Words)e1.nextElement();
            w.show = flag;
        }
    }

    protected void reloadHead() {
        if (this.ligneHead == null) {
            return;
        }
        Source o = (Source)this.ligneHead.elementAt(0);
        this.ligneHead = this.aladin.mesure.getHeadLine(o);
    }

    protected void unselect() {
        this.objSelect = null;
    }

    private String getDescription(Source o, int i) {
        StringBuffer res = new StringBuffer();
        if (o.leg != null && o.leg.field != null && i >= 0 && i < o.leg.field.length) {
            Field f = o.leg.field[i];
            res.append((o.leg.name != null ? o.leg.name + " - " : "") + f.name);
            if (f.unit != null && f.unit.length() > 0 || f.description != null) {
                res.append(" - ");
            }
            if (f.unit != null && f.unit.length() > 0) {
                res.append("[" + f.unit + "] ");
            }
            if (f.description != null) {
                res.append(f.description);
            }
        }
        return res.toString();
    }

    private void startTimerHist(Source o, int nField) {
        if (this.oTimer == o && this.onField == nField) {
            return;
        }
        this.oTimer = o;
        this.onField = nField;
        if (this.timer == null) {
            this.timer = new Timer(500, this);
            this.timer.setRepeats(false);
            this.timer.start();
        } else {
            this.timer.restart();
        }
    }

    private void endTimerHist() {
        if (this.oTimer == null || this.onField == -1) {
            return;
        }
        if (this.oTimer.leg.isSED()) {
            this.aladin.view.zoomview.setSED(this.oTimer);
        } else {
            this.aladin.calque.zoom.zoomView.setHist(this.oTimer, this.onField);
        }
        this.oTimer = null;
    }

    private int getRealIndice(Source s, int indice) {
        if (s.leg == null) {
            return indice - 1;
        }
        for (int i = 0; i < indice; ++i) {
            if (s.leg.isVisible(i)) continue;
            ++indice;
        }
        return indice - 1;
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
        Source oshow;
        if (this.aladin.inHelp) {
            return;
        }
        if (this.popMenu.isVisible()) {
            return;
        }
        int x = evt.getX();
        int y = evt.getY();
        Graphics g = this.getGraphics();
        if (g == null) {
            return;
        }
        g.setFont(FONT);
        String s = null;
        Words w = null;
        String tip = "";
        if (y <= MH) {
            if (this.ligneHead == null) {
                return;
            }
            Util.toolTip(this, TIPHEAD);
            this.onBordField = -1;
            Source o = (Source)this.ligneHead.elementAt(0);
            Enumeration e = this.ligneHead.elements();
            e.nextElement();
            int i = 0;
            while (e.hasMoreElements()) {
                w = (Words)e.nextElement();
                int indice = this.getRealIndice(o, i);
                if (w.onBord(x, y)) {
                    this.onBordField = indice;
                }
                if (x < 15 || w.inside(x, y)) {
                    if (this.ow == w) break;
                    this.indiceCourant = indice;
                    this.sCourante = o;
                    this.startTimerHist(this.sCourante, indice);
                    if (this.objSelect == null && this.showLigne != null) {
                        this.clearShowLigne(g);
                    }
                    if (this.mouseLigne != null) {
                        this.clearMouseLigne(g);
                    }
                    w.onMouse = true;
                    this.drawHead(g, o);
                    this.drawWords(g, w, true);
                    this.flagDrawHead = true;
                    this.mouseLigne = this.ligneHead;
                    this.ow = w;
                    Util.drawEdge(g, this.W, this.H);
                    s = this.getDescription(o, indice);
                    this.aladin.mesure.setStatus(s);
                    break;
                }
                ++i;
            }
            if (this.onBordField != -1) {
                this.setCursor(Cursor.getPredefinedCursor(10));
            } else {
                Aladin.makeCursor(this, 0);
            }
            return;
        }
        Aladin.makeCursor(this, 0);
        this.currentsee = this.firstsee + (y - MH) / HL;
        if (this.currentsee >= this.aladin.mesure.getNbSrc()) {
            this.indiceCourant = -1;
            if (this.oo != null) {
                this.aladin.view.hideSource();
                this.oo = null;
            }
            if (this.objSelect == null && this.showLigne != null) {
                this.clearShowLigne(g);
            }
            if (this.mouseLigne != null) {
                this.clearMouseLigne(g);
            }
            this.ow = null;
            Util.drawEdge(g, this.W, this.H);
            this.aladin.urlStatus.setText("");
            this.aladin.mesure.setStatus("");
            Util.toolTip(this, tip);
            return;
        }
        Vector ligne = this.aladin.mesure.getWordLine(this.currentsee);
        Source o = (Source)ligne.elementAt(0);
        Source source = oshow = this.objSelect != null ? this.objSelect : o;
        if (this.oo != oshow) {
            this.aladin.view.showSource(oshow);
            this.oo = oshow;
        }
        this.aladin.localisation.seeCoord(oshow);
        this.showSEDPoint(oshow);
        if (this.flagDrawHead) {
            this.drawHead(g, oshow);
        } else {
            this.quickDrawHead(g, oshow);
        }
        this.flagDrawHead = false;
        Enumeration e = ligne.elements();
        o = (Source)e.nextElement();
        boolean trouve = false;
        int i = 0;
        while (e.hasMoreElements() && x > 15) {
            w = (Words)e.nextElement();
            int indice = this.getRealIndice(o, i);
            if (w.inside(x, y)) {
                trouve = true;
                if (w == this.ow) {
                    return;
                }
                this.indiceCourant = indice;
                this.sCourante = o;
                this.startTimerHist(this.sCourante, indice);
                if (this.objSelect == null && this.showLigne != null) {
                    this.clearShowLigne(g);
                }
                if (this.mouseLigne != null) {
                    this.clearMouseLigne(g);
                }
                if (this.objSelect == null) {
                    this.initShow(g, w.y + HF, ligne);
                }
                if (w.x > 15) {
                    if (!w.repere) {
                        w.onMouse = true;
                    }
                    this.drawWords(g, w, true);
                }
                if (w.repere) {
                    s = w.text;
                } else if (w.glu) {
                    tip = TIPGLU;
                } else if (w.archive) {
                    tip = TIPARCH;
                } else if (w.footprint) {
                    tip = TIPFOV;
                }
                s = this.getDescription(o, indice);
                if (s == null) {
                    s = "";
                }
                try {
                    if (w.glu) {
                        w.urlStatus(this.aladin.urlStatus);
                    } else {
                        String ucd = o.leg.getUCD(indice);
                        if (ucd.length() > 0) {
                            this.aladin.urlStatus.setText("UCD: " + ucd);
                        } else {
                            this.aladin.urlStatus.setText("");
                        }
                    }
                }
                catch (Exception ecurs) {
                    // empty catch block
                }
                Util.drawEdge(g, this.W, this.H);
                this.aladin.mesure.setStatus(s);
                this.mouseLigne = ligne;
                this.ow = w;
                break;
            }
            ++i;
        }
        if (x < 15) {
            tip = TIPTAG;
        }
        if (!trouve) {
            if (this.objSelect == null && this.showLigne != null) {
                this.clearShowLigne(g);
            }
            if (this.mouseLigne != null) {
                this.clearMouseLigne(g);
            }
            Util.drawEdge(g, this.W, this.H);
            this.ow = null;
            this.indiceCourant = -1;
        }
        Util.toolTip(this, tip);
    }

    protected void showSEDPoint(Source s) {
        if (s.leg.isSED() && this.aladin.view.zoomview.flagSED) {
            this.aladin.view.zoomview.setSED(s);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.ow = null;
        if (this.aladin.inHelp) {
            this.aladin.help.setText(this.Help());
            return;
        }
        if (this.aladin.mesure.getNbSrc() > 0) {
            this.aladin.toolBox.mouseEnter(null, 0, 0);
        }
        Aladin.makeCursor(this, 2);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.aladin.inHelp) {
            return;
        }
        if (this.timer != null) {
            this.timer.stop();
        }
        this.aladin.urlStatus.setText(Aladin.COPYRIGHT);
        this.currentsee = -1;
        Aladin.makeCursor(this, 0);
        if (this.oo != null) {
            this.aladin.view.hideSource();
            this.oo = null;
        }
        if (this.ow != null) {
            this.ow.onMouse = false;
        }
        this.repaint();
    }

    protected boolean show(Source o, int mode) {
        boolean retour = false;
        if (mode == 1 && this.objSelect != null) {
            return false;
        }
        if (mode == 3) {
            if (this.objSelect != null) {
                this.unselect();
            } else {
                this.objSelect = o;
            }
        } else {
            this.unselect();
            if (mode == 2) {
                this.objSelect = o;
            }
        }
        if (o == null) {
            this.currentsee = -1;
        } else {
            int ntext = this.aladin.mesure.getNbSrc();
            for (int n = 0; n < ntext; ++n) {
                Vector ligne = this.aladin.mesure.getWordLine(n);
                if ((Source)ligne.elementAt(0) != o) continue;
                if (n < this.firstsee || n > this.lastsee) {
                    if (n < this.firstsee) {
                        this.scrollV.setValue(n);
                    } else {
                        this.scrollV.setValue(n - this.nbligne + 1);
                    }
                    this.aladin.mesure.validate();
                }
                this.currentsee = n;
                this.objShow = o;
                retour = true;
                break;
            }
        }
        if (retour) {
            this.showSEDPoint(o);
        }
        this.repaint();
        return retour;
    }

    private void adjustScrollH(int max) {
        if (max == this.omax) {
            return;
        }
        this.omax = max;
        this.scrollH.setMaximum(max);
        boolean ok = max < this.W && this.showScrollH;
        if (ok) {
            this.aladin.mesure.remove(this.scrollH);
            this.showScrollH = false;
        } else {
            ok = max >= this.W && !this.showScrollH;
            if (ok) {
                this.aladin.mesure.add((Component)this.scrollH, "South");
                this.showScrollH = true;
                this.scrollH.setVisibleAmount(this.W);
                this.scrollH.setBlockIncrement(this.W - 10 * this.wblanc);
                --this.nbligne;
            }
        }
        if (!ok) {
            return;
        }
        int deltaY = this.scrollH.getSize().height;
        if (this.showScrollH) {
            deltaY = -deltaY;
        }
        this.scrollV.setSize(this.scrollV.getSize().width, this.scrollV.getSize().height + deltaY);
        this.aladin.mesure.validate();
    }

    protected void adjustScrollV(int nl) {
        this.scrollV.setVisibleAmount(nl);
        this.scrollV.setBlockIncrement(nl - 1);
        this.onl = nl;
    }

    @Override
    public void repaint() {
        this.aladin.adjustNbSel();
        super.repaint();
    }

    @Override
    public void paintComponent(Graphics gr) {
        int m;
        Vector word;
        if (this.firstUpdate) {
            this.firstUpdate = false;
            this.scrollV.setValue(0);
        }
        this.mouseLigne = null;
        this.showLigne = null;
        this.ow = null;
        if (this.img == null || this.img.getWidth(this) != this.getWidth() || this.img.getHeight(this) != this.getHeight()) {
            this.W = this.getWidth();
            this.H = this.getHeight();
            this.img = this.aladin.createImage(this.W, this.H);
        }
        Graphics g = this.img.getGraphics();
        this.aladin.setAliasing(g);
        this.nbligne = (this.H - (MH + 1)) / HL;
        int y = MH + HF + 1;
        int ts = this.aladin.mesure.getNbSrc();
        int max = 0;
        this.absX = -this.scrollH.getValue();
        this.lastsee = this.firstsee = this.scrollV.getValue();
        if (this.firstsee < 0) {
            this.firstsee = 0;
            this.lastsee = 0;
        }
        g.setFont(FONT);
        this.aladin.mesure.memoWordLineClear();
        Source oleg = this.objShow != null ? this.objShow : this.objSelect;
        int j = 0;
        while (this.lastsee < ts && j < this.nbligne) {
            word = this.aladin.mesure.getWordLine(this.lastsee);
            if (word != null) {
                if (oleg == null) {
                    oleg = (Source)word.elementAt(0);
                }
                m = this.drawLigne(g, y, word, true);
                this.aladin.mesure.memoWordLine(word, this.lastsee);
                if (m > max) {
                    max = m;
                }
            }
            ++this.lastsee;
            ++j;
            y += HL;
        }
        --this.lastsee;
        this.objShow = null;
        if (j > 0) {
            this.drawHead(g, oleg);
        } else {
            this.ligneHead = null;
            this.clearHead(g, 0, this.W);
        }
        if (this.showScrollH && max < this.W && this.lastsee + 1 < ts && (m = this.drawLigne(g, -30, word = this.aladin.mesure.getWordLine(this.lastsee + 1), true)) > max) {
            max = this.W;
        }
        this.adjustScrollH(max);
        this.adjustScrollV((this.H - (MH + 1)) / HL - (this.showScrollH ? 1 : 0));
        int ry = this.H - (y -= HF) - 1;
        if (ry > 0) {
            g.setColor(BG);
            g.fillRect(1, y, this.W - 1, ry);
        }
        Util.drawEdge(g, this.W, this.H);
        gr.drawImage(this.img, 0, 0, this);
        if (this.aladin.view.zoomview.flagSED) {
            this.aladin.view.zoomview.repaint();
        }
    }

    protected String Help() {
        return Aladin.chaine.getString("MCanvas.HELP");
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (this.aladin.inHelp) {
            this.aladin.helpOff();
            return;
        }
        Search sr = this.aladin.mesure.flagSplit ? this.aladin.mesure.search : this.aladin.search;
        int c = e.getKeyCode();
        if (c == 38 || c == 37) {
            sr.execute("-");
        } else if (c == 40 || c == 39) {
            sr.execute("+");
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int c = e.getKeyCode();
        if (c == 127 || c == 8) {
            this.aladin.view.delSelObjet();
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        this.repaint();
    }

    @Override
    public WidgetControl getWidgetControl() {
        return this.voc;
    }

    @Override
    public void createWidgetControl(int x, int y, int width, int height, float opacity, JComponent parent) {
        this.voc = new WidgetControl(this, x, y, width, height, opacity, parent);
        this.voc.setResizable(true);
    }

    @Override
    public void paintCollapsed(Graphics g) {
        Tool.drawVOTable(g, 4, 7);
    }

    static {
        MH = HL = HF + 3;
        BG = Aladin.LBLUE;
        COLORBORD = new Color(153, 153, 153);
        tX = new int[]{5, 5, 14};
        tY = new int[]{HL / 2 + 1 - 5, HL / 2 + 1 + 5, HL / 2 + 1};
        C1 = new Color(199, 207, 255);
        C2 = new Color(85, 26, 139);
        C3 = new Color(104, 230, 255);
        C4 = new Color(221, 91, 53);
        C5 = new Color(195, 195, 255);
        C6 = new Color(140, 140, 255);
        C7 = new Color(255, 255, 225);
    }
}

