/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.MetaDataTree;
import cds.aladin.XMatchElem;
import cds.aladin.XMatchEllipseElem;
import cds.aladin.XMatchResult;
import java.util.Vector;

public final class LocalXMatch {
    static LocalXMatch localXMatch;

    public static XMatchResult[] xID(String[] array1, String[] array2) {
        int i;
        if (localXMatch == null) {
            localXMatch = new LocalXMatch();
        }
        Vector<XMatchResult> resultVec = new Vector<XMatchResult>();
        int len1 = array1.length;
        int len2 = array2.length;
        Object[] pos1 = new XIDElem[len1];
        Object[] pos2 = new XIDElem[len2];
        for (i = 0; i < len1; ++i) {
            LocalXMatch localXMatch = LocalXMatch.localXMatch;
            localXMatch.getClass();
            pos1[i] = localXMatch.new XIDElem(array1[i].toLowerCase(), i);
        }
        for (i = 0; i < len2; ++i) {
            LocalXMatch localXMatch = LocalXMatch.localXMatch;
            localXMatch.getClass();
            pos2[i] = localXMatch.new XIDElem(array2[i].toLowerCase(), i);
        }
        MetaDataTree.sort(pos1, null, true);
        MetaDataTree.sort(pos2, null, true);
        int k = 0;
        for (int j = 0; j < len1; ++j) {
            while (k < len2 && ((XIDElem)pos1[j]).str.compareTo(((XIDElem)pos2[k]).str) > 0) {
                ++k;
            }
            while (k < len2 && ((XIDElem)pos1[j]).str.compareTo(((XIDElem)pos2[k]).str) == 0) {
                resultVec.addElement(new XMatchResult(((XIDElem)pos1[j]).idx, ((XIDElem)pos2[k]).idx, 0.0));
                ++k;
            }
        }
        Object[] resultArr = new XMatchResult[resultVec.size()];
        resultVec.copyInto(resultArr);
        resultVec = null;
        return resultArr;
    }

    public static XMatchResult[] xMatch(double[][] array1, double[][] array2, boolean[] flag1, boolean[] flag2, double[] seuil, int fmtOut) {
        Vector<XMatchResult> resultVec = new Vector<XMatchResult>();
        int len1 = array1.length;
        int len2 = array2.length;
        XMatchElem[] pos1 = new XMatchElem[len1];
        XMatchElem[] pos2 = new XMatchElem[len2];
        LocalXMatch.fillElem(pos1, array1);
        LocalXMatch.sortPos(pos1);
        LocalXMatch.fillElem(pos2, array2);
        LocalXMatch.sortPos(pos2);
        int k_inf = 0;
        int k_sup = 0;
        for (int j = 0; j < len1; ++j) {
            XMatchResult result;
            if (flag1[j]) continue;
            while (pos2[k_inf].dec < pos1[j].dec - seuil[1] / 3600.0 && k_inf < len2 - 1) {
                ++k_inf;
            }
            while (pos2[k_sup].dec <= pos1[j].dec + seuil[1] / 3600.0 && k_sup < len2 - 1) {
                ++k_sup;
            }
            int kBest = -1;
            double dstBest = seuil[1] + 1.0;
            for (int k = k_inf; k <= k_sup; ++k) {
                double dst;
                if (flag2[k] || !((dst = 3600.0 * LocalXMatch.sphDst(pos1[j].ra, pos1[j].dec, pos2[k].ra, pos2[k].dec)) <= seuil[1]) || !(dst >= seuil[0])) continue;
                if ((fmtOut & 2) > 0) {
                    result = new XMatchResult(pos1[j].idx, pos2[k].idx, dst);
                    resultVec.addElement(result);
                }
                if (!(dst < dstBest)) continue;
                kBest = k;
                dstBest = dst;
            }
            if (kBest >= 0 && (fmtOut & 1) > 0 && (fmtOut & 2) == 0) {
                result = new XMatchResult(pos1[j].idx, pos2[kBest].idx, dstBest);
                resultVec.addElement(result);
            }
            if (kBest >= 0 || (fmtOut & 4) <= 0) continue;
            result = new XMatchResult(pos1[j].idx, kBest, -1.0);
            resultVec.addElement(result);
        }
        Object[] resultArr = new XMatchResult[resultVec.size()];
        resultVec.copyInto(resultArr);
        resultVec = null;
        return resultArr;
    }

    public static XMatchResult[] xMatchEllipse(double[][] array1, double[][] array2, double[] maj1, double[] min1, double[] pa1, double[] maj2, double[] min2, double[] pa2, boolean[] flag1, boolean[] flag2, double[] seuil, int fmtOut) {
        Vector<XMatchResult> resultVec = new Vector<XMatchResult>();
        int len1 = array1.length;
        int len2 = array2.length;
        XMatchElem[] pos1 = new XMatchEllipseElem[len1];
        XMatchElem[] pos2 = new XMatchEllipseElem[len2];
        LocalXMatch.fillElem((XMatchEllipseElem[])pos1, array1, maj1, min1, pa1);
        LocalXMatch.sortPos(pos1);
        LocalXMatch.fillElem((XMatchEllipseElem[])pos2, array2, maj2, min2, pa2);
        LocalXMatch.sortPos(pos2);
        int nb = 0;
        int kInf = 0;
        int kSup = 0;
        int fkInf = 0;
        int fkSup = 0;
        XMatchResult result = null;
        double sig = seuil[1] / 3600.0;
        double span = sig * Math.sqrt(Math.pow(LocalXMatch.getMaxEllipse(maj1), 2.0) + Math.pow(LocalXMatch.getMaxEllipse(maj2), 2.0));
        for (int j = 0; j < len1; ++j) {
            if (flag1[j]) continue;
            while (((XMatchEllipseElem)pos2[fkInf]).dec < ((XMatchEllipseElem)pos1[j]).dec - span && fkInf < len2 - 1) {
                ++fkInf;
            }
            while (((XMatchEllipseElem)pos2[fkSup]).dec <= ((XMatchEllipseElem)pos1[j]).dec + span && fkSup < len2 - 1) {
                ++fkSup;
            }
            for (kInf = fkInf; ((XMatchEllipseElem)pos1[j]).dec - ((XMatchEllipseElem)pos2[kInf]).dec > sig * Math.sqrt(((XMatchEllipseElem)pos1[j]).maj * ((XMatchEllipseElem)pos1[j]).maj + ((XMatchEllipseElem)pos2[kInf]).maj * ((XMatchEllipseElem)pos2[kInf]).maj) && kInf < fkSup; ++kInf) {
            }
            for (kSup = fkSup; ((XMatchEllipseElem)pos2[kSup]).dec - ((XMatchEllipseElem)pos1[j]).dec > sig * Math.sqrt(((XMatchEllipseElem)pos1[j]).maj * ((XMatchEllipseElem)pos1[j]).maj + ((XMatchEllipseElem)pos2[kSup]).maj * ((XMatchEllipseElem)pos2[kSup]).maj) && kSup > fkInf; --kSup) {
            }
            int kBest = -1;
            double dstBest = seuil[1] + 1.0;
            for (int k = kInf; k <= kSup; ++k) {
                double dst;
                if (flag2[k] || LocalXMatch.sphDst(((XMatchEllipseElem)pos1[j]).ra, ((XMatchEllipseElem)pos1[j]).dec, ((XMatchEllipseElem)pos2[k]).ra, ((XMatchEllipseElem)pos2[k]).dec) > span || !((dst = LocalXMatch.nSigmaEllipse((XMatchEllipseElem)pos1[j], (XMatchEllipseElem)pos2[k])) <= seuil[1]) || !(dst >= seuil[0])) continue;
                if ((fmtOut & 2) > 0) {
                    result = new XMatchResult(((XMatchEllipseElem)pos1[j]).idx, ((XMatchEllipseElem)pos2[k]).idx, dst);
                    resultVec.addElement(result);
                    ++nb;
                }
                if (!(dst < dstBest)) continue;
                kBest = k;
                dstBest = dst;
            }
            if (kBest >= 0 && (fmtOut & 1) > 0 && (fmtOut & 2) == 0) {
                result = new XMatchResult(((XMatchEllipseElem)pos1[j]).idx, ((XMatchEllipseElem)pos2[kBest]).idx, dstBest);
                resultVec.addElement(result);
                ++nb;
            }
            if (kBest >= 0 || (fmtOut & 4) <= 0) continue;
            result = new XMatchResult(((XMatchEllipseElem)pos1[j]).idx, kBest, -1.0);
            resultVec.addElement(result);
            ++nb;
        }
        Object[] resultArr = new XMatchResult[resultVec.size()];
        resultVec.copyInto(resultArr);
        resultVec = null;
        return resultArr;
    }

    private static double nSigmaEllipse(XMatchEllipseElem tab1, XMatchEllipseElem tab2) {
        double dra = tab2.ra - tab1.ra;
        double ddec = Math.abs(tab2.dec - tab1.dec);
        double dcos = Math.cos(LocalXMatch.deg2rad(tab2.dec));
        double siang = dcos * Math.sin(LocalXMatch.deg2rad(dra));
        double coang = Math.sin(LocalXMatch.deg2rad(tab2.dec)) * Math.cos(LocalXMatch.deg2rad(tab1.dec)) - dcos * Math.sin(LocalXMatch.deg2rad(tab1.dec)) * Math.cos(LocalXMatch.deg2rad(dra));
        double theta = 57.29577951308232 * Math.atan2(siang, coang);
        coang = Math.cos(LocalXMatch.deg2rad(theta + tab1.pa)) / tab1.maj;
        siang = Math.sin(LocalXMatch.deg2rad(theta + tab1.pa)) / tab1.min;
        double sig1 = 1.0 / (coang * coang + siang * siang);
        coang = Math.cos(LocalXMatch.deg2rad(theta + tab2.pa)) / tab2.maj;
        siang = Math.sin(LocalXMatch.deg2rad(theta + tab2.pa)) / tab2.min;
        double sig2 = 1.0 / (coang * coang + siang * siang);
        double dst = LocalXMatch.sphDst(tab1.ra, tab1.dec, tab2.ra, tab2.dec);
        double sig = 3600.0 * dst / Math.sqrt(sig1 + sig2);
        return sig;
    }

    private static double getMaxEllipse(double[] tableau) {
        double max = 0.0;
        for (int i = 0; i < tableau.length; ++i) {
            if (!(tableau[i] > max)) continue;
            max = tableau[i];
        }
        return max;
    }

    private static void fillElem(XMatchElem[] pos, double[][] array) {
        for (int i = 0; i < array.length; ++i) {
            pos[i] = new XMatchElem(array[i][0], array[i][1], i);
        }
    }

    private static void fillElem(XMatchEllipseElem[] pos, double[][] array, double[] maj, double[] min, double[] pa) {
        for (int i = 0; i < array.length; ++i) {
            pos[i] = new XMatchEllipseElem(array[i][0], array[i][1], i, maj[i], min[i], pa[i]);
        }
    }

    private static double sphDst(double ra1, double dec1, double ra2, double dec2) {
        double ra1Rad = LocalXMatch.deg2rad(ra1);
        double dec1Rad = LocalXMatch.deg2rad(dec1);
        double ra2Rad = LocalXMatch.deg2rad(ra2);
        double dec2Rad = LocalXMatch.deg2rad(dec2);
        double d = Math.pow(Math.sin((dec1Rad - dec2Rad) / 2.0), 2.0);
        return LocalXMatch.rad2deg(2.0 * Math.asin(Math.sqrt(d += Math.pow(Math.sin((ra1Rad - ra2Rad) / 2.0), 2.0) * Math.cos(dec1Rad) * Math.cos(dec2Rad))));
    }

    private static double deg2rad(double angle) {
        return angle * Math.PI / 180.0;
    }

    private static double rad2deg(double angle) {
        return angle * 180.0 / Math.PI;
    }

    private static void sortPos(XMatchElem[] rec) {
        int j;
        int n = rec.length;
        double[] dec = new double[n];
        for (int j2 = 0; j2 < n; ++j2) {
            dec[j2] = rec[j2].dec;
        }
        int[] iwksp = new int[n];
        XMatchElem[] wksp = new XMatchElem[n];
        LocalXMatch.dindexx(dec, iwksp);
        for (j = 0; j < n; ++j) {
            wksp[j] = rec[j];
        }
        for (j = 0; j < n; ++j) {
            rec[j] = wksp[iwksp[j]];
            rec[j].idx = iwksp[j];
        }
    }

    private static void dindexx(double[] arr, int[] indx) {
        int j;
        int n = arr.length;
        int ir = n - 1;
        int l = 0;
        int jstack = 0;
        int NSTACK = 50;
        int M = 7;
        int[] istack = new int[NSTACK];
        for (j = 0; j < n; ++j) {
            indx[j] = j;
        }
        while (true) {
            int i;
            double a;
            int indxt;
            if (ir - l < M) {
                for (j = l + 1; j <= ir; ++j) {
                    indxt = indx[j];
                    a = arr[indxt];
                    for (i = j - 1; i >= l && !(arr[indx[i]] <= a); --i) {
                        indx[i + 1] = indx[i];
                    }
                    indx[i + 1] = indxt;
                }
                if (jstack == 0) break;
                ir = istack[jstack--];
                l = istack[jstack--];
                continue;
            }
            int k = l + ir >> 1;
            LocalXMatch.swap(indx, k, l + 1);
            if (arr[indx[l]] > arr[indx[ir]]) {
                LocalXMatch.swap(indx, l, ir);
            }
            if (arr[indx[l + 1]] > arr[indx[ir]]) {
                LocalXMatch.swap(indx, l + 1, ir);
            }
            if (arr[indx[l]] > arr[indx[l + 1]]) {
                LocalXMatch.swap(indx, l, l + 1);
            }
            i = l + 1;
            j = ir;
            indxt = indx[l + 1];
            a = arr[indxt];
            while (true) {
                if (arr[indx[++i]] < a) {
                    continue;
                }
                while (arr[indx[--j]] > a) {
                }
                if (j < i) break;
                LocalXMatch.swap(indx, i, j);
            }
            indx[l + 1] = indx[j];
            indx[j] = indxt;
            if ((jstack += 2) > NSTACK) {
                System.out.println("NSTACK too small in indexx");
            }
            if (ir - i + 1 >= j - l) {
                istack[jstack] = ir;
                istack[jstack - 1] = i;
                ir = j - 1;
                continue;
            }
            istack[jstack] = j - 1;
            istack[jstack - 1] = l;
            l = i;
        }
    }

    private static void swap(int[] arr, int idx1, int idx2) {
        int tmp = arr[idx1];
        arr[idx1] = arr[idx2];
        arr[idx2] = tmp;
    }

    class XIDElem {
        String str;
        int idx;

        XIDElem(String str, int idx) {
            this.str = str;
            this.idx = idx;
        }

        public String toString() {
            return this.str;
        }
    }
}

