/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Plan;
import cds.tools.Util;
import cds.xml.Field;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public final class Legende
extends AbstractTableModel {
    String name;
    Field[] field;
    Vector<String> group = null;
    boolean[] computed;
    private int firstLink = -2;
    private boolean sorted = false;
    private static final String[] HEAD = new String[]{"", "Visible", "Coo", "Name", "Description", "Unit", "Datatype", "UCD", "Utype", "Width", "Arraysize", "Precision"};
    private static final int[] WHEAD = new int[]{30, 50, 30, 100, 190, 50, 70, 110, -1, 40, 40, 40};
    private static final int N = 0;
    private static final int VISIBLE = 1;
    private static final int COO = 2;
    public static final int NAME = 3;
    public static final int DESCRIPTION = 4;
    public static final int UNIT = 5;
    public static final int DATATYPE = 6;
    public static final int UCD = 7;
    public static final int UTYPE = 8;
    public static final int WIDTH = 9;
    public static final int ARRAYSIZE = 10;
    public static final int PRECISION = 11;
    private JTable table;
    private Aladin aladin;
    public Plan plan = null;

    protected Legende() {
        this.field = new Field[0];
    }

    protected Legende(Vector<Field> vField) {
        this.field = new Field[vField.size()];
        this.computed = new boolean[vField.size()];
        Enumeration<Field> e = vField.elements();
        int i = 0;
        while (e.hasMoreElements()) {
            this.field[i] = e.nextElement();
            this.computed[i] = false;
            ++i;
        }
    }

    protected Legende(ArrayList<Legende> leg) {
        int i;
        ArrayList<Field> f = new ArrayList<Field>(100);
        for (i = 0; i < leg.size(); ++i) {
            Legende lg = leg.get(i);
            for (int j = 0; j < lg.field.length; ++j) {
                int k;
                for (k = 0; k < f.size() && !((Field)f.get(k)).equals(lg.field[j]); ++k) {
                }
                if (k != f.size()) continue;
                f.add(new Field(lg.field[j]));
            }
        }
        this.field = new Field[f.size()];
        this.computed = new boolean[this.field.length];
        this.name = "[Concatenated]";
        for (i = 0; i < this.field.length; ++i) {
            this.field[i] = (Field)f.get(i);
        }
    }

    protected Legende(Legende l) {
        this.field = new Field[l.field.length];
        for (int i = 0; i < l.field.length; ++i) {
            this.field[i] = l.field[i];
        }
        this.name = l.name;
        this.group = l.group;
        if (l.computed != null) {
            this.computed = new boolean[l.computed.length];
            System.arraycopy(l.computed, 0, this.computed, 0, l.computed.length);
        } else {
            this.computed = null;
        }
    }

    public static Legende adjustDefaultLegende(Legende leg, int type, String[] val) {
        if (leg == null || leg.field.length != val.length) {
            leg = new Legende();
            leg.field = new Field[val.length];
            leg.computed = new boolean[val.length];
        }
        block10: for (int i = 0; i < val.length; ++i) {
            if (val[i] == null) continue;
            if (leg.field[i] == null) {
                leg.field[i] = new Field("Col_" + i);
                leg.computed[i] = false;
            }
            Field f = leg.field[i];
            switch (type) {
                case 3: {
                    f.name = val[i].length() == 0 ? "" : val[i];
                    continue block10;
                }
                case 4: {
                    f.description = val[i].length() == 0 ? "" : val[i];
                    continue block10;
                }
                case 6: {
                    f.datatype = val[i].length() == 0 ? "" : Field.typeVOTable2Fits(val[i]);
                    continue block10;
                }
                case 5: {
                    f.unit = val[i].length() == 0 ? "" : val[i];
                    continue block10;
                }
                case 7: {
                    f.ucd = val[i].length() == 0 ? "" : val[i];
                    continue block10;
                }
                case 9: {
                    f.width = val[i].length() == 0 ? "" : val[i];
                    f.computeColumnSize();
                    continue block10;
                }
                case 10: {
                    f.arraysize = val[i].length() == 0 ? "" : val[i];
                    f.computeColumnSize();
                    continue block10;
                }
                case 11: {
                    f.precision = val[i].length() == 0 ? "" : val[i];
                }
            }
        }
        return leg;
    }

    public void setGroup(Vector<String> group) {
        this.group = group;
    }

    public boolean hasGroup() {
        return this.group != null;
    }

    public String getGroup() {
        if (this.group == null) {
            return "";
        }
        Enumeration<String> e = this.group.elements();
        StringBuffer s = new StringBuffer();
        while (e.hasMoreElements()) {
            s.append(e.nextElement());
        }
        return s.toString();
    }

    protected int find(Field f) {
        for (int i = 0; i < this.field.length; ++i) {
            if (!this.field[i].equals(f)) continue;
            return i;
        }
        return -1;
    }

    protected int find(String name) {
        for (int i = 0; i < this.field.length; ++i) {
            if (!name.equals(this.field[i].name)) continue;
            return i;
        }
        return -1;
    }

    protected int getRa() {
        for (int i = 0; i < this.field.length; ++i) {
            if (!this.field[i].isRa()) continue;
            return i;
        }
        return -1;
    }

    protected int getDe() {
        for (int i = 0; i < this.field.length; ++i) {
            if (!this.field[i].isDe()) continue;
            return i;
        }
        return -1;
    }

    protected int getPmRa() {
        for (int i = 0; i < this.field.length; ++i) {
            if (!this.field[i].isPmRa()) continue;
            return i;
        }
        return -1;
    }

    protected int getPmDe() {
        for (int i = 0; i < this.field.length; ++i) {
            if (!this.field[i].isPmDe()) continue;
            return i;
        }
        return -1;
    }

    protected int getX() {
        for (int i = 0; i < this.field.length; ++i) {
            if (!this.field[i].isX()) continue;
            return i;
        }
        return -1;
    }

    protected int getY() {
        for (int i = 0; i < this.field.length; ++i) {
            if (!this.field[i].isY()) continue;
            return i;
        }
        return -1;
    }

    protected boolean isVisible(int index) {
        try {
            return this.field[index].visible;
        }
        catch (Exception exception) {
            return true;
        }
    }

    protected void addField(Field f) {
        int n = this.field.length;
        Field[] nField = new Field[n + 1];
        System.arraycopy(this.field, 0, nField, 0, n);
        nField[n] = f;
        this.field = nField;
    }

    protected int setField(int index, String name, String datatype, String unit, String ucd, int width) {
        int res = 0;
        int n = this.field.length;
        if (index >= n) {
            int i;
            res = index - n;
            Field[] nField = new Field[index + 1];
            boolean[] nComputed = new boolean[index + 1];
            System.arraycopy(this.field, 0, nField, 0, n);
            if (this.computed != null) {
                System.arraycopy(this.computed, 0, nComputed, 0, n);
            } else {
                for (i = 0; i < n; ++i) {
                    nComputed[i] = false;
                }
            }
            for (i = n; i < index + 1; ++i) {
                nField[i] = new Field("Col_" + (i + 1));
                nComputed[i] = true;
            }
            this.computed = nComputed;
            this.field = nField;
        }
        Field f = this.field[index];
        if (name != null) {
            f.name = name;
        }
        if (datatype != null) {
            f.datatype = Field.typeFits2VOTable(datatype);
        }
        if (unit != null) {
            f.unit = unit;
        }
        if (ucd != null) {
            f.ucd = ucd;
        }
        if (width >= 0) {
            f.width = width == 0 ? null : width + "";
        }
        f.computeColumnSize();
        this.computed[index] = true;
        return res;
    }

    protected int getRealFieldNumber(int nField) {
        if (nField == -1) {
            return nField;
        }
        int nVisible = 0;
        int nInvisible = 0;
        if (nField == 0) {
            int i = 0;
            while (!this.field[i].visible) {
                ++nInvisible;
                ++i;
            }
        } else {
            int i = 0;
            while (nVisible < nField) {
                if (!this.field[i].visible) {
                    ++nInvisible;
                } else {
                    ++nVisible;
                }
                ++i;
            }
        }
        return nField + nInvisible;
    }

    protected boolean switchSort(int nField) {
        int sort = this.field[nField].sort;
        this.clearSort();
        this.field[nField].sort = sort == 1 ? 2 : 1;
        this.sorted = true;
        return this.field[nField].sort == 1;
    }

    protected void setSort(int nField, int sort) {
        this.clearSort();
        if (nField >= 0) {
            this.field[nField].sort = sort;
        }
        this.sorted = sort != 0;
    }

    protected void clearSort() {
        for (int i = 0; i < this.field.length; ++i) {
            this.field[i].sort = 0;
        }
        this.sorted = false;
    }

    protected boolean isSED() {
        for (Field f : this.field) {
            if (f.sed == 0) continue;
            return true;
        }
        return false;
    }

    protected boolean isSorted() {
        return this.sorted;
    }

    public int getSize() {
        return this.field.length;
    }

    protected int matchColIndex(String name) {
        for (int i = 0; i < this.field.length; ++i) {
            if (this.field[i].name == null || !Util.matchMask(name, this.field[i].name)) continue;
            return i;
        }
        return -1;
    }

    protected int matchIgnoreCaseColIndex(String name) {
        for (int i = 0; i < this.field.length; ++i) {
            if (this.field[i].name == null || !Util.matchMaskIgnoreCase(name, this.field[i].name)) continue;
            return i;
        }
        return -1;
    }

    protected boolean isNullValue(String text, int i) {
        if (i >= this.field.length) {
            return false;
        }
        Field f = this.field[i];
        return f.nullValue != null && f.nullValue.equals(text.trim());
    }

    protected String getUCD(int i) {
        if (i >= this.field.length) {
            return null;
        }
        Field f = this.field[i];
        return f.ucd != null ? f.ucd : "";
    }

    protected int getPrecision(int i) {
        if (i >= this.field.length) {
            return -1;
        }
        Field f = this.field[i];
        try {
            return Integer.parseInt(f.precision);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    protected int getWidth(int i) {
        if (i >= this.field.length) {
            return -1;
        }
        Field f = this.field[i];
        if (f.refText != null && f.refText.indexOf("${") < 0) {
            return f.refText.length() + 1;
        }
        return f.columnSize;
    }

    protected int getWidth() {
        int width = 0;
        for (int i = 0; i < this.field.length; ++i) {
            if (!this.field[i].visible) continue;
            width += this.getWidth(i);
        }
        return width;
    }

    protected int getRefTextLength(int i) {
        if (i >= this.field.length) {
            return -1;
        }
        if (this.field[i].refText == null) {
            return 0;
        }
        return this.field[i].refText.length() + 1;
    }

    protected String getName(int i) {
        return i >= this.field.length ? null : this.field[i].name;
    }

    protected String getHref(int i) {
        return i >= this.field.length ? null : this.field[i].href;
    }

    protected String getGref(int i) {
        return i >= this.field.length ? null : this.field[i].gref;
    }

    protected String getRefText(int i) {
        return i >= this.field.length ? null : this.field[i].refText;
    }

    protected String getRefValue(int i) {
        return i >= this.field.length ? null : this.field[i].refValue;
    }

    protected String getDataType(int i) {
        return i >= this.field.length ? null : this.field[i].datatype;
    }

    protected boolean hasInfo(int i) {
        return i >= this.field.length ? false : i < this.field.length;
    }

    protected boolean isNumField(int i) {
        return i < 0 ? false : (i >= this.field.length ? true : this.field[i].isNumDataType());
    }

    protected int getFirstLink() {
        if (this.firstLink != -2) {
            return this.firstLink;
        }
        for (int i = 0; i < this.field.length; ++i) {
            if (this.getHref(i) == null && this.getGref(i) == null) continue;
            this.firstLink = i;
            return this.firstLink;
        }
        this.firstLink = -1;
        return this.firstLink;
    }

    protected JPanel getTablePanel(Aladin aladin, Plan plan) {
        this.aladin = aladin;
        this.plan = plan;
        JPanel p = new JPanel(new BorderLayout());
        JScrollPane sc = new JScrollPane(this.createTable());
        p.add((Component)sc, "Center");
        return p;
    }

    protected JComboBox createCombo() {
        JComboBox<String> combo = new JComboBox<String>();
        combo.setMaximumRowCount(15);
        for (int i = 0; i < this.field.length; ++i) {
            combo.addItem(this.field[i].name);
        }
        return combo;
    }

    protected JTable getTable() {
        if (this.table == null) {
            this.createTable();
        }
        return this.table;
    }

    private JTable createTable() {
        this.table = new JTable(this);
        this.table.setSelectionMode(0);
        MyRenderer mr = new MyRenderer();
        MyComboBoxEditor mc = new MyComboBoxEditor();
        int width = 0;
        for (int i = 0; i < HEAD.length; ++i) {
            TableColumn tc = this.table.getColumnModel().getColumn(i);
            if (WHEAD[i] != -1) {
                tc.setMinWidth(WHEAD[i]);
            }
            if (i == 2) {
                tc.setCellEditor(mc);
            }
            if (i != 1) {
                tc.setCellRenderer(mr);
            }
            width += WHEAD[i];
        }
        int height = Math.min(this.getRowCount(), 15) * 16;
        this.table.setPreferredScrollableViewportSize(new Dimension(width + 50, height));
        return this.table;
    }

    @Override
    public String getColumnName(int col) {
        return HEAD[col];
    }

    @Override
    public int getColumnCount() {
        return HEAD.length;
    }

    @Override
    public int getRowCount() {
        return this.field.length;
    }

    @Override
    public Class<?> getColumnClass(int col) {
        if (col == 1) {
            return new Boolean(true).getClass();
        }
        return super.getColumnClass(col);
    }

    @Override
    public Object getValueAt(int row, int col) {
        switch (col) {
            case 0: {
                return row + 1 + "";
            }
            case 2: {
                return this.field[row].getCooSignature();
            }
            case 1: {
                return new Boolean(this.field[row].visible);
            }
            case 3: {
                return this.field[row].name;
            }
            case 5: {
                return this.field[row].unit;
            }
            case 4: {
                return this.field[row].description;
            }
            case 7: {
                return this.field[row].ucd;
            }
            case 8: {
                return this.field[row].utype;
            }
            case 6: {
                return Field.typeFits2VOTable(this.field[row].datatype);
            }
            case 9: {
                return this.field[row].width;
            }
            case 10: {
                return this.field[row].arraysize;
            }
            case 11: {
                return this.field[row].precision;
            }
        }
        return "";
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col > 0;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        switch (col) {
            case 3: {
                this.field[row].name = (String)value;
                break;
            }
            case 2: {
                String s = (String)value;
                if (s.equals(this.field[row].getCooSignature())) break;
                int coo = Util.indexInArrayOf(s, Field.COOSIGN);
                this.modifyRaDecXYField(row, coo);
                break;
            }
            case 1: {
                this.field[row].visible = (Boolean)value;
                break;
            }
            case 5: {
                this.field[row].unit = (String)value;
                break;
            }
            case 4: {
                this.field[row].description = (String)value;
                break;
            }
            case 7: {
                this.field[row].ucd = (String)value;
                break;
            }
            case 8: {
                this.field[row].utype = (String)value;
                break;
            }
            case 6: {
                this.field[row].datatype = Field.typeVOTable2Fits((String)value);
                break;
            }
            case 9: {
                this.field[row].width = (String)value;
                this.field[row].computeColumnSize();
                break;
            }
            case 10: {
                this.field[row].arraysize = (String)value;
                this.field[row].computeColumnSize();
                break;
            }
            case 11: {
                this.field[row].precision = (String)value;
            }
        }
        this.aladin.mesure.redisplay();
    }

    public void modifyRaDecXYField(int index, int coo) {
        if (this.plan == null || this.plan.pcat == null) {
            return;
        }
        this.plan.hasPM = -1;
        if (coo == 1 || coo == 2 || coo == 3 || coo == 4) {
            int nra = -1;
            int ndec = -1;
            int npmra = -1;
            int npmde = -1;
            if (coo == 1) {
                nra = index;
            } else if (coo == 2) {
                ndec = index;
            } else if (coo == 3) {
                npmra = index;
            } else if (coo == 4) {
                npmde = index;
            }
            for (int i = 0; i < this.field.length; ++i) {
                Field f = this.field[i];
                if (f.coo == 1) {
                    if (coo == 1) {
                        f.coo = 0;
                    }
                    if (nra == -1) {
                        nra = i;
                    }
                }
                if (f.coo == 2) {
                    if (coo == 2) {
                        f.coo = 0;
                    }
                    if (ndec == -1) {
                        ndec = i;
                    }
                }
                if (f.coo == 3) {
                    if (coo == 3) {
                        f.coo = 0;
                    }
                    if (npmra == -1) {
                        npmra = i;
                    }
                }
                if (f.coo == 4) {
                    if (coo == 4) {
                        f.coo = 0;
                    }
                    if (npmde == -1) {
                        npmde = i;
                    }
                }
                if (f.coo != 5 && f.coo != 6) continue;
                f.coo = 0;
            }
            this.field[index].coo = coo;
            if (nra >= 0 && ndec >= 0 && coo != 0) {
                this.plan.modifyRaDecField(this, nra, ndec, npmra, npmde);
            }
        } else {
            int nx = -1;
            int ny = -1;
            if (coo == 5) {
                nx = index;
            } else if (coo == 6) {
                ny = index;
            }
            for (int i = 0; i < this.field.length; ++i) {
                Field f = this.field[i];
                if (f.coo == 5) {
                    if (coo == 5) {
                        f.coo = 0;
                    }
                    if (nx == -1) {
                        nx = i;
                    }
                }
                if (f.coo == 6) {
                    if (coo == 6) {
                        f.coo = 0;
                    }
                    if (ny == -1) {
                        ny = i;
                    }
                }
                if (f.coo != 1 && f.coo != 2 && f.coo != 3 && f.coo != 4) continue;
                f.coo = 0;
            }
            this.field[index].coo = coo;
            if (nx >= 0 && ny >= 0 && coo != 0) {
                this.plan.modifyXYField(this, nx, ny);
            }
        }
        this.fireTableDataChanged();
    }

    public String toString() {
        return this.field[0].name + " " + this.field[0].ucd + " ...";
    }

    class MyRenderer
    extends DefaultTableCellRenderer {
        MyRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            Component cell = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            if (!(cell instanceof JLabel)) {
                return cell;
            }
            JLabel j = (JLabel)cell;
            if (col == 0) {
                j.setFont(j.getFont().deriveFont(2));
            } else if (col == 3) {
                j.setFont(j.getFont().deriveFont(1));
            } else {
                j.setFont(j.getFont().deriveFont(0));
            }
            if (col == 0 || col == 6 || col == 1 || col == 10) {
                j.setHorizontalAlignment(0);
            } else {
                j.setHorizontalAlignment(2);
            }
            return cell;
        }
    }

    class MyComboBoxEditor
    extends DefaultCellEditor {
        public MyComboBoxEditor() {
            super(new JComboBox<String>(Field.COOSIGN));
        }
    }
}

