/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.Kernel;
import cds.aladin.Server;
import cds.aladin.Tok;
import cds.tools.Util;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class KernelList {
    private Aladin aladin;
    private Vector<Kernel> list;
    private static int NK = 0;
    static final double FCTSIGMA = 2.0 * Math.sqrt(2.0 * Math.log(2.0));
    private static final double[][] CONTRAST = new double[][]{{0.0, -1.0, 0.0}, {-1.0, 5.0, -1.0}, {0.0, -1.0, 0.0}};
    private static final double[][] FLOU = new double[][]{{0.1111111111111111, 0.1111111111111111, 0.1111111111111111}, {0.1111111111111111, 0.1111111111111111, 0.1111111111111111}, {0.1111111111111111, 0.1111111111111111, 0.1111111111111111}};
    private static final double[][] BORD = new double[][]{{0.0, 1.0, 0.0}, {1.0, -4.0, 1.0}, {0.0, 1.0, 0.0}};
    private static final double[][] PYRAMIDAL = new double[][]{{1.0, 2.0, 1.0}, {2.0, 4.0, 2.0}, {1.0, 2.0, 1.0}};
    private static final double[][] GAUSS1_5 = new double[][]{{0.109853, 0.3007, 0.109853}, {0.3007, 0.823102, 0.3007}, {0.109853, 0.3007, 0.109853}};
    private static final double[][] GAUSS2 = new double[][]{{0.260856, 0.483068, 0.260856}, {0.483068, 0.894573, 0.483068}, {0.260856, 0.483068, 0.260856}};
    private static final double[][] GAUSS2_5 = new double[][]{{0.034673, 0.119131, 0.179633, 0.119131, 0.034673}, {0.119131, 0.409323, 0.6172, 0.409323, 0.119131}, {0.179633, 0.6172, 0.930649, 0.6172, 0.179633}, {0.119131, 0.409323, 0.6172, 0.409323, 0.119131}, {0.034673, 0.119131, 0.179633, 0.119131, 0.034673}};
    private static final double[][] GAUSS3 = new double[][]{{0.092163, 0.221178, 0.296069, 0.221178, 0.092163}, {0.221178, 0.530797, 0.710525, 0.530797, 0.221178}, {0.296069, 0.710525, 0.951108, 0.710525, 0.296069}, {0.221178, 0.530797, 0.710525, 0.530797, 0.221178}, {0.092163, 0.221178, 0.296069, 0.221178, 0.092163}};
    private static final double[][] GAUSS4 = new double[][]{{0.047454, 0.109799, 0.181612, 0.214776, 0.181612, 0.109799, 0.047454}, {0.109799, 0.254053, 0.420215, 0.49695, 0.420215, 0.254053, 0.109799}, {0.181612, 0.420215, 0.695055, 0.821978, 0.695055, 0.420215, 0.181612}, {0.214776, 0.49695, 0.821978, 0.972079, 0.821978, 0.49695, 0.214776}, {0.181612, 0.420215, 0.695055, 0.821978, 0.695055, 0.420215, 0.181612}, {0.109799, 0.254053, 0.420215, 0.49695, 0.420215, 0.254053, 0.109799}, {0.047454, 0.109799, 0.181612, 0.214776, 0.181612, 0.109799, 0.047454}};
    private static final double[][] GAUSS5 = new double[][]{{0.030531, 0.065238, 0.112208, 0.155356, 0.173152, 0.155356, 0.112208, 0.065238, 0.030531}, {0.065238, 0.139399, 0.239763, 0.331961, 0.369987, 0.331961, 0.239763, 0.139399, 0.065238}, {0.112208, 0.239763, 0.412386, 0.570963, 0.636368, 0.570963, 0.412386, 0.239763, 0.112208}, {0.155356, 0.331961, 0.570963, 0.79052, 0.881075, 0.79052, 0.570963, 0.331961, 0.155356}, {0.173152, 0.369987, 0.636368, 0.881075, 0.982004, 0.881075, 0.636368, 0.369987, 0.173152}, {0.155356, 0.331961, 0.570963, 0.79052, 0.881075, 0.79052, 0.570963, 0.331961, 0.155356}, {0.112208, 0.239763, 0.412386, 0.570963, 0.636368, 0.570963, 0.412386, 0.239763, 0.112208}, {0.065238, 0.139399, 0.239763, 0.331961, 0.369987, 0.331961, 0.239763, 0.139399, 0.065238}, {0.030531, 0.065238, 0.112208, 0.155356, 0.173152, 0.155356, 0.112208, 0.065238, 0.030531}};
    private static final double[][] MEX1_5 = new double[][]{{-1.09E-4, -0.002374, -0.006302, -0.002374, -1.09E-4}, {-0.002374, -0.032222, -0.025569, -0.032222, -0.002374}, {-0.006302, -0.025569, 0.276021, -0.025569, -0.006302}, {-0.002374, -0.032222, -0.025569, -0.032222, -0.002374}, {-1.09E-4, -0.002374, -0.006302, -0.002374, -1.09E-4}};
    private static final double[][] MEX2 = new double[][]{{-6.0E-6, -1.32E-4, -8.49E-4, -0.001569, -8.49E-4, -1.32E-4, -6.0E-6}, {-1.32E-4, -0.002989, -0.017229, -0.028788, -0.017229, -0.002989, -1.32E-4}, {-8.49E-4, -0.017229, -0.042689, 0.023455, -0.042689, -0.017229, -8.49E-4}, {-0.001569, -0.028788, 0.023455, 0.356183, 0.023455, -0.028788, -0.001569}, {-8.49E-4, -0.017229, -0.042689, 0.023455, -0.042689, -0.017229, -8.49E-4}, {-1.32E-4, -0.002989, -0.017229, -0.028788, -0.017229, -0.002989, -1.32E-4}, {-6.0E-6, -1.32E-4, -8.49E-4, -0.001569, -8.49E-4, -1.32E-4, -6.0E-6}};
    private static final double[][] MEX2_5 = new double[][]{{-2.84E-4, -0.002194, -0.007273, -0.010722, -0.007273, -0.002194, -2.84E-4}, {-0.002194, -0.01564, -0.041259, -0.050277, -0.041259, -0.01564, -0.002194}, {-0.007273, -0.041259, -0.016356, 0.095837, -0.016356, -0.041259, -0.007273}, {-0.010722, -0.050277, 0.095837, 0.402756, 0.095837, -0.050277, -0.010722}, {-0.007273, -0.041259, -0.016356, 0.095837, -0.016356, -0.041259, -0.007273}, {-0.002194, -0.01564, -0.041259, -0.050277, -0.041259, -0.01564, -0.002194}, {-2.84E-4, -0.002194, -0.007273, -0.010722, -0.007273, -0.002194, -2.84E-4}};
    private static final double[][] MEX3 = new double[][]{{-4.1E-5, -3.16E-4, -0.001357, -0.003226, -0.004294, -0.003226, -0.001357, -3.16E-4, -4.1E-5}, {-3.16E-4, -0.002428, -0.010013, -0.022204, -0.028374, -0.022204, -0.010013, -0.002428, -3.16E-4}, {-0.001357, -0.010013, -0.03545, -0.054426, -0.050313, -0.054426, -0.03545, -0.010013, -0.001357}, {-0.003226, -0.022204, -0.054426, 0.033057, 0.164532, 0.033057, -0.054426, -0.022204, -0.003226}, {-0.004294, -0.028374, -0.050313, 0.164532, 0.42986, 0.164532, -0.050313, -0.028374, -0.004294}, {-0.003226, -0.022204, -0.054426, 0.033057, 0.164532, 0.033057, -0.054426, -0.022204, -0.003226}, {-0.001357, -0.010013, -0.03545, -0.054426, -0.050313, -0.054426, -0.03545, -0.010013, -0.001357}, {-3.16E-4, -0.002428, -0.010013, -0.022204, -0.028374, -0.022204, -0.010013, -0.002428, -3.16E-4}, {-4.1E-5, -3.16E-4, -0.001357, -0.003226, -0.004294, -0.003226, -0.001357, -3.16E-4, -4.1E-5}};
    private static final double[][] MEX4 = new double[][]{{-0.00225, -0.007092, -0.01564, -0.024467, -0.028187, -0.024467, -0.01564, -0.007092, -0.00225}, {-0.007092, -0.021141, -0.041403, -0.054742, -0.057388, -0.054742, -0.041403, -0.021141, -0.007092}, {-0.01564, -0.041403, -0.057494, -0.024939, 0.008058, -0.024939, -0.057494, -0.041403, -0.01564}, {-0.024467, -0.054742, -0.024939, 0.145167, 0.27147, 0.145167, -0.024939, -0.054742, -0.024467}, {-0.028187, -0.057388, 0.008058, 0.27147, 0.459236, 0.27147, 0.008058, -0.057388, -0.028187}, {-0.024467, -0.054742, -0.024939, 0.145167, 0.27147, 0.145167, -0.024939, -0.054742, -0.024467}, {-0.01564, -0.041403, -0.057494, -0.024939, 0.008058, -0.024939, -0.057494, -0.041403, -0.01564}, {-0.007092, -0.021141, -0.041403, -0.054742, -0.057388, -0.054742, -0.041403, -0.021141, -0.007092}, {-0.00225, -0.007092, -0.01564, -0.024467, -0.028187, -0.024467, -0.01564, -0.007092, -0.00225}};
    private static final double[][] MEX5 = new double[][]{{-0.002172, -0.005657, -0.011702, -0.019279, -0.025644, -0.028106, -0.025644, -0.019279, -0.011702, -0.005657, -0.002172}, {-0.005657, -0.014328, -0.028098, -0.04268, -0.052065, -0.054833, -0.052065, -0.04268, -0.028098, -0.014328, -0.005657}, {-0.011702, -0.028098, -0.049016, -0.059439, -0.051288, -0.043047, -0.051288, -0.059439, -0.049016, -0.028098, -0.011702}, {-0.019279, -0.04268, -0.059439, -0.030431, 0.047481, 0.093729, 0.047481, -0.030431, -0.059439, -0.04268, -0.019279}, {-0.025644, -0.052065, -0.051288, 0.047481, 0.235153, 0.339248, 0.235153, 0.047481, -0.051288, -0.052065, -0.025644}, {-0.028106, -0.054833, -0.043047, 0.093729, 0.339248, 0.473518, 0.339248, 0.093729, -0.043047, -0.054833, -0.028106}, {-0.025644, -0.052065, -0.051288, 0.047481, 0.235153, 0.339248, 0.235153, 0.047481, -0.051288, -0.052065, -0.025644}, {-0.019279, -0.04268, -0.059439, -0.030431, 0.047481, 0.093729, 0.047481, -0.030431, -0.059439, -0.04268, -0.019279}, {-0.011702, -0.028098, -0.049016, -0.059439, -0.051288, -0.043047, -0.051288, -0.059439, -0.049016, -0.028098, -0.011702}, {-0.005657, -0.014328, -0.028098, -0.04268, -0.052065, -0.054833, -0.052065, -0.04268, -0.028098, -0.014328, -0.005657}, {-0.002172, -0.005657, -0.011702, -0.019279, -0.025644, -0.028106, -0.025644, -0.019279, -0.011702, -0.005657, -0.002172}};
    private static final double[][] TOPHAT1_5 = new double[][]{{0.0, 0.18, 0.0}, {0.18, 1.0, 0.18}, {0.0, 0.18, 0.0}};
    private static final double[][] TOPHAT2 = new double[][]{{0.08, 0.46, 0.08}, {0.46, 1.0, 0.46}, {0.08, 0.46, 0.08}};
    private static final double[][] TOPHAT2_5 = new double[][]{{0.26, 0.7, 0.26}, {0.7, 1.0, 0.7}, {0.26, 0.7, 0.26}};
    private static final double[][] TOPHAT3 = new double[][]{{0.56, 0.98, 0.56}, {0.98, 1.0, 0.98}, {0.56, 0.98, 0.56}};
    private static final double[][] TOPHAT4 = new double[][]{{0.0, 0.22, 0.48, 0.22, 0.0}, {0.22, 0.99, 1.0, 0.99, 0.22}, {0.48, 1.0, 1.0, 1.0, 0.48}, {0.22, 0.99, 1.0, 0.99, 0.22}, {0.0, 0.22, 0.48, 0.22, 0.0}};
    private static final double[][] TOPHAT5 = new double[][]{{0.15, 0.77, 1.0, 0.77, 0.15}, {0.77, 1.0, 1.0, 1.0, 0.77}, {1.0, 1.0, 1.0, 1.0, 1.0}, {0.77, 1.0, 1.0, 1.0, 0.77}, {0.15, 0.77, 1.0, 0.77, 0.15}};

    private static String createConvName() {
        return "Kernel" + ++NK;
    }

    public KernelList(Aladin aladin) {
        this.aladin = aladin;
        this.list = new Vector();
        this.addDefaultKernels();
    }

    public int findKernel(String name) {
        Enumeration<Kernel> e = this.list.elements();
        int i = 0;
        while (e.hasMoreElements()) {
            Kernel k = e.nextElement();
            if (k.name.equalsIgnoreCase(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int addKernel(String kdef, double pixelRes) throws Exception {
        String name;
        Kernel k = null;
        int offset = kdef.indexOf(61);
        int j = kdef.indexOf(40);
        if (offset > 0 && (j == -1 || j > offset)) {
            name = kdef.substring(0, offset);
            kdef = kdef.substring(offset + 1);
        } else {
            name = KernelList.createConvName();
        }
        offset = kdef.indexOf(40);
        if (offset >= 0) {
            double[] param = KernelList.parseGaussCmd(kdef);
            if (param == null) {
                throw new Exception("usage: gauss( {fwhm|sigma}=angle [,radius=x] )");
            }
            k = KernelList.createGaussienMatrix(param[0], param[1], pixelRes, (int)param[2]);
        } else {
            k = new Kernel();
            k.matrix = KernelList.parseKernel(kdef);
        }
        k.name = name;
        int i = this.findKernel(name);
        if (i < 0) {
            this.list.addElement(k);
            i = this.list.size() - 1;
        } else {
            this.list.setElementAt(k, i);
        }
        if (this.aladin.frameConvolution != null) {
            this.aladin.frameConvolution.reloadComboKernel(name);
        }
        return i;
    }

    protected double[][] getKernel(int i) {
        return this.list.elementAt((int)i).matrix;
    }

    public String getKernelList() {
        StringBuffer s = new StringBuffer();
        Enumeration<Kernel> e = this.list.elements();
        while (e.hasMoreElements()) {
            s.append(e.nextElement().name + "\n");
        }
        return s.toString();
    }

    public Vector<String> getKernelListAsVector() {
        Vector<String> v = new Vector<String>();
        Enumeration<Kernel> e = this.list.elements();
        while (e.hasMoreElements()) {
            v.addElement(e.nextElement().name);
        }
        return v;
    }

    public String getKernelDef(String mask) {
        StringBuffer s = new StringBuffer();
        Enumeration<Kernel> e = this.list.elements();
        while (e.hasMoreElements()) {
            Kernel k = e.nextElement();
            if (mask != null && !Util.matchMask(mask, k.name)) continue;
            s.append(k);
        }
        return s.toString();
    }

    public static double[] parseGaussCmd(String s) {
        double[] res = new double[3];
        try {
            int i = s.indexOf(40);
            if (!s.substring(0, i).trim().endsWith("gauss")) {
                return null;
            }
            int j = s.lastIndexOf(41);
            StringTokenizer t = new StringTokenizer(s.substring(i + 1, j), ",");
            while (t.hasMoreTokens()) {
                String s1 = t.nextToken();
                i = s1.indexOf(61);
                String cmd = i < 0 ? "fwhm" : s1.substring(0, i).trim();
                String value = s1.substring(i + 1).trim();
                if (cmd.equalsIgnoreCase("fwhm")) {
                    res[0] = Server.getAngle(value, 1) / 60.0;
                    continue;
                }
                if (cmd.equalsIgnoreCase("sigma")) {
                    res[1] = Server.getAngle(value, 1) / 60.0;
                    continue;
                }
                if (cmd.equalsIgnoreCase("radius")) {
                    res[2] = Integer.parseInt(value);
                    continue;
                }
                return null;
            }
        }
        catch (Exception e) {
            return null;
        }
        return res;
    }

    private static double[][] parseKernel(String k) throws Exception {
        int i = 0;
        int j = 0;
        Tok tok = new Tok(k);
        int size = (int)Math.sqrt(tok.countTokens());
        double[][] kernel = null;
        while (tok.hasMoreTokens()) {
            double x = Double.parseDouble(tok.nextToken());
            if (kernel == null) {
                kernel = new double[size][size];
            }
            kernel[i][j++] = x;
            if (j != size) continue;
            j = 0;
            ++i;
        }
        return kernel;
    }

    public Kernel getKernel(String s, double pixRes) throws Exception {
        int i = this.findKernel(s);
        if (i < 0) {
            i = this.addKernel(s, pixRes);
        }
        return this.list.elementAt(i);
    }

    public static Kernel createGaussienMatrix(double fwhm, double sigma, double pixelRes, int radius) throws Exception {
        double[] p = KernelList.computeGaussParam(fwhm, sigma, pixelRes, radius);
        fwhm = p[0];
        sigma = p[1];
        radius = (int)p[2];
        if (radius > 500) {
            throw new Exception("Too large kernel [radius=" + radius + "]");
        }
        String s = "fwhm=" + Coord.getUnit(fwhm) + " sigma=" + Coord.getUnit(sigma) + " pixel=" + Coord.getUnit(pixelRes) + " radius=" + radius;
        Kernel k = new Kernel();
        k.matrix = KernelList.createGaussienMatrix(radius, sigma / pixelRes);
        k.gaussian = KernelList.createFastGaussienMatrix(radius, sigma / pixelRes);
        return k;
    }

    public static double[] computeGaussParam(double fwhm, double sigma, double pixelRes, int radius) {
        if (sigma == 0.0 && fwhm == 0.0) {
            sigma = 0.5;
        } else if (fwhm != 0.0) {
            sigma = fwhm / FCTSIGMA;
        } else {
            fwhm = FCTSIGMA * sigma;
        }
        double r = 3.0 * fwhm;
        double npix = r / pixelRes;
        if (radius == 0) {
            radius = (int)Math.ceil(npix) / 2;
        }
        if (radius < 1) {
            radius = 1;
        }
        return new double[]{fwhm, sigma, radius};
    }

    public static double[][] createGaussienMatrix(int rayon, double sigma) {
        int y;
        int largeur = 2 * rayon + 1;
        double[][] matrix = new double[largeur][largeur];
        double factor = 0.0;
        for (y = 0; y < largeur; ++y) {
            double ky = y - rayon;
            for (int x = 0; x < largeur; ++x) {
                double e;
                double kx = x - rayon;
                matrix[x][y] = e = Math.exp(-(kx * kx + ky * ky) / (2.0 * sigma * sigma));
                factor += e;
            }
        }
        for (y = 0; y < largeur; ++y) {
            for (int x = 0; x < largeur; ++x) {
                double[] dArray = matrix[x];
                int n = y;
                dArray[n] = dArray[n] / factor;
            }
        }
        return matrix;
    }

    public static double[] createFastGaussienMatrix(int rayon, double sigma) {
        int col;
        int largeur = 2 * rayon + 1;
        double[] gaussian = new double[largeur];
        double factor = 0.0;
        for (col = 0; col < largeur; ++col) {
            double e;
            double ky = col - rayon;
            int x = rayon;
            double kx = x - rayon;
            gaussian[col] = e = Math.exp(-(kx * kx + ky * ky) / (2.0 * sigma * sigma));
            factor += e;
        }
        col = 0;
        while (col < largeur) {
            int n = col++;
            gaussian[n] = gaussian[n] / factor;
        }
        return gaussian;
    }

    public void addDefaultKernels() {
        Kernel k = new Kernel("Gauss-1.5pix", GAUSS1_5);
        this.list.add(k);
        k.normalize();
        k = new Kernel("Gauss-2pix", GAUSS2);
        this.list.add(k);
        k.normalize();
        k = new Kernel("Gauss-2.5pix", GAUSS2_5);
        this.list.add(k);
        k.normalize();
        k = new Kernel("Gauss-3pix", GAUSS3);
        this.list.add(k);
        k.normalize();
        k = new Kernel("Gauss-4pix", GAUSS4);
        this.list.add(k);
        k.normalize();
        k = new Kernel("Gauss-5pix", GAUSS5);
        this.list.add(k);
        k.normalize();
        k = new Kernel("Mex-1.5pix", MEX1_5);
        this.list.add(k);
        k.normalize();
        k = new Kernel("Mex-2pix", MEX2);
        this.list.add(k);
        k.normalize();
        k = new Kernel("Mex-2.5pix", MEX2_5);
        this.list.add(k);
        k.normalize();
        k = new Kernel("Mex-3pix", MEX3);
        this.list.add(k);
        k.normalize();
        k = new Kernel("Mex-4pix", MEX4);
        this.list.add(k);
        k.normalize();
        k = new Kernel("Mex-5pix", MEX5);
        this.list.add(k);
        k.normalize();
        k = new Kernel("Tophat-1.5pix", TOPHAT1_5);
        this.list.add(k);
        k.normalize();
        k = new Kernel("Tophat-2pix", TOPHAT2);
        this.list.add(k);
        k.normalize();
        k = new Kernel("Tophat-2.5pix", TOPHAT2_5);
        this.list.add(k);
        k.normalize();
        k = new Kernel("Tophat-3pix", TOPHAT3);
        this.list.add(k);
        k.normalize();
        k = new Kernel("Tophat-4pix", TOPHAT4);
        this.list.add(k);
        k.normalize();
        k = new Kernel("Tophat-5pix", TOPHAT5);
        this.list.add(k);
        k.normalize();
        k = new Kernel("Blur-", CONTRAST);
        this.list.add(k);
        k.normalize();
        k = new Kernel("Blur+", FLOU);
        this.list.add(k);
        k.normalize();
        k = new Kernel("Pyramidal", PYRAMIDAL);
        this.list.add(k);
        k.normalize();
        k = new Kernel("Edge", BORD);
        this.list.add(k);
        k.normalize();
    }
}

