/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Source;
import cds.tools.Util;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.HashMap;
import java.util.StringTokenizer;

class Hist
implements Runnable {
    int MARGE = 8;
    int NBHIST = 10;
    int GAP = 3;
    static final int WCROIX = 5;
    Aladin aladin;
    String titre;
    Source o;
    int nField;
    HistItem[] hist;
    HistItem onMouse = null;
    int nb;
    int nbCategorie;
    boolean flagHistPartial;
    int width;
    int height;
    String texte = null;
    static final int MAX = 200000;
    private double[] pixelList;
    private int nPix;
    protected boolean flagHistPixel;
    private volatile Thread thread = null;
    private HistItem oOnMouse = null;

    Hist(Aladin aladin, int width, int height) {
        this.aladin = aladin;
        this.width = width;
        this.height = height;
    }

    protected void setText(String s) {
        this.texte = s;
    }

    protected String getCopier() {
        return this.texte;
    }

    protected void startHistPixel() {
        if (this.pixelList == null) {
            this.pixelList = new double[200000];
        }
        this.nPix = 0;
        this.flagHistPixel = true;
        this.texte = null;
    }

    protected boolean isOverFlow() {
        return this.nPix == 200000;
    }

    protected boolean addPixel(double pix) {
        if (this.nPix == 200000) {
            return false;
        }
        this.pixelList[this.nPix++] = pix;
        return true;
    }

    protected void createHistPixel(String titre) {
        this.titre = titre;
        this.setHist(this.pixelList);
    }

    protected boolean init(Source o, int nField) {
        if (this.thread != null) {
            return false;
        }
        this.flagHistPixel = false;
        this.texte = null;
        this.o = o;
        this.nField = nField;
        if (nField == -1) {
            this.hist = null;
            return false;
        }
        this.titre = o.leg.field[nField].name;
        return this.init();
    }

    protected boolean init() {
        if (this.flagHistPixel) {
            this.setHist(this.pixelList);
            return true;
        }
        if (this.aladin.mesure.getNbSrc() > 10000) {
            this.thread = new Thread((Runnable)this, "Histo");
            this.thread.start();
            return false;
        }
        return this.initThread();
    }

    @Override
    public void run() {
        if (this.initThread()) {
            this.aladin.calque.zoom.zoomView.flagHist = true;
            this.aladin.calque.repaintAll();
        }
        this.thread = null;
    }

    protected boolean initThread() {
        if (this.o.leg.isNumField(this.nField)) {
            double[] xHist = this.aladin.mesure.getFieldNumericValues(this.o, this.nField);
            this.nb = xHist.length;
            this.setHist(xHist);
        } else {
            String[] sHist = this.aladin.mesure.getFieldStringValues(this.o, this.nField);
            this.nb = sHist.length;
            this.setHist(sHist);
        }
        return this.hist != null;
    }

    boolean mouseWheelMoved(MouseWheelEvent e) {
        int n = e.getWheelRotation();
        if (n == 0) {
            return false;
        }
        n = this.NBHIST + (this.NBHIST > 2 ? 2 * n : n);
        this.setNbHist(n);
        return true;
    }

    void setNbHist(int n) {
        this.NBHIST = n;
        if (this.NBHIST < 4) {
            this.NBHIST = 4;
        }
        if (this.NBHIST > 30) {
            this.NBHIST = 30;
        }
        this.GAP = this.NBHIST > 25 ? 0 : (this.NBHIST > 15 ? 2 : 3);
        this.init();
    }

    boolean mouseDragged(MouseEvent e) {
        int y = e.getY();
        int n = (int)((double)y / (((double)(this.height - 5) - 15.0) / 30.0));
        this.setNbHist(n);
        return true;
    }

    protected void setHist(double[] x) {
        int i;
        int length = this.flagHistPixel ? this.nPix : x.length;
        double min = Double.MAX_VALUE;
        double max = -min;
        for (int i2 = 0; i2 < length; ++i2) {
            double c = x[i2];
            if (Double.isNaN(c)) continue;
            if (c < min) {
                min = c;
            }
            if (!(c > max)) continue;
            max = c;
        }
        if (min == Double.MAX_VALUE || max == -1.7976931348623157E308 || min == max || length <= 1) {
            this.hist = null;
            return;
        }
        this.hist = new HistItem[this.NBHIST];
        this.flagHistPartial = false;
        this.nbCategorie = -1;
        double range = max - min;
        double sizeBean = range / (double)this.hist.length;
        for (i = 0; i < this.hist.length; ++i) {
            this.hist[i] = new HistItem();
            this.hist[i].min = i == 0 ? min : this.hist[i - 1].max;
            this.hist[i].max = this.hist[i].min + sizeBean;
        }
        for (i = 0; i < length; ++i) {
            if (Double.isNaN(x[i])) continue;
            int index = (int)((x[i] - min) / sizeBean);
            if (index > this.hist.length - 1) {
                index = this.hist.length - 1;
                this.hist[index].max = x[i] + 1.0E-11;
            }
            ++this.hist[index].nb;
        }
        int maxNb = Integer.MIN_VALUE;
        for (int i3 = 0; i3 < this.hist.length; ++i3) {
            if (this.hist[i3].nb <= maxNb) continue;
            maxNb = this.hist[i3].nb;
        }
        int hautMax = this.height - 30;
        double coef = (double)hautMax / (double)maxNb;
        for (int i4 = 0; i4 < this.hist.length; ++i4) {
            this.hist[i4].haut = (int)((double)this.hist[i4].nb * coef);
            this.hist[i4].prop = (double)this.hist[i4].nb / (double)length * 100.0;
        }
    }

    protected void setHist(String[] x) {
        class Int {
            int val = 1;

            Int() {
            }

            void incr() {
                ++this.val;
            }

            void clear() {
                this.val = -1;
            }
        }
        HashMap<String, Int> map = new HashMap<String, Int>(300);
        for (int i = 0; i < x.length; ++i) {
            String key = x[i];
            if (key.length() == 0) continue;
            Int n = (Int)map.get(key);
            if (n != null) {
                n.incr();
                continue;
            }
            map.put(key, new Int());
        }
        this.nbCategorie = map.keySet().size();
        int nb = this.nbCategorie;
        if (nb <= 1) {
            this.hist = null;
            return;
        }
        boolean bl = this.flagHistPartial = nb > this.NBHIST;
        if (this.flagHistPartial) {
            nb = this.NBHIST;
        }
        if (this.hist == null || this.hist.length != nb) {
            this.hist = new HistItem[nb];
        }
        for (int i = 0; i < this.hist.length; ++i) {
            this.hist[i] = new HistItem();
            String maxKey = null;
            int max = -1;
            for (String key : map.keySet()) {
                Int n = (Int)map.get(key);
                if (n.val <= max) continue;
                max = n.val;
                maxKey = key;
            }
            if (i == 0 && max == 1) {
                this.hist = null;
                return;
            }
            if (max == -1) continue;
            Int n = (Int)map.get(maxKey);
            this.hist[i].nb = n.val;
            this.hist[i].categorie = maxKey;
            n.clear();
        }
        int maxNb = Integer.MIN_VALUE;
        for (int i = 0; i < this.hist.length; ++i) {
            if (this.hist[i].nb <= maxNb) continue;
            maxNb = this.hist[i].nb;
        }
        int hautMax = this.height - 30;
        double coef = (double)hautMax / (double)maxNb;
        for (int i = 0; i < this.hist.length; ++i) {
            this.hist[i].haut = (int)((double)this.hist[i].nb * coef);
            this.hist[i].prop = (double)this.hist[i].nb / (double)x.length * 100.0;
        }
    }

    protected void selectHighlightSource() {
        int i;
        if (this.onMouse == null || this.flagHistPixel) {
            return;
        }
        Source[] nsrc = new Source[this.onMouse.nb];
        int j = 0;
        for (i = 0; i < this.aladin.mesure.nbSrc; ++i) {
            if (!this.aladin.mesure.src[i].isHighlighted()) continue;
            nsrc[j++] = this.aladin.mesure.src[i];
        }
        this.aladin.view.deSelect();
        for (i = 0; i < nsrc.length; ++i) {
            nsrc[i].setSelected(true);
        }
        this.aladin.mesure.adjustScroll();
        this.aladin.appMessagingMgr.sendSelectObjectsMsg();
        this.init();
    }

    protected void resetHighlightSource() {
        if (this.flagHistPixel) {
            return;
        }
        for (int i = 0; i < this.aladin.mesure.nbSrc; ++i) {
            this.aladin.mesure.src[i].setHighlight(false);
        }
    }

    protected void setHighlightSource() {
        if (this.flagHistPixel) {
            return;
        }
        this.resetHighlightSource();
        if (this.onMouse != null) {
            for (int i = 0; i < this.aladin.mesure.nbSrc; ++i) {
                if (this.aladin.mesure.src[i].leg != this.o.leg) continue;
                String s = this.aladin.mesure.src[i].getValue(this.nField);
                if (this.onMouse.categorie != null && this.onMouse.categorie.equals(s)) {
                    this.aladin.mesure.src[i].setHighlight(true);
                    continue;
                }
                try {
                    double x = Double.parseDouble(s);
                    if (!(x >= this.onMouse.min) || !(x < this.onMouse.max)) continue;
                    this.aladin.mesure.src[i].setHighlight(true);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    boolean setOnMouse(int x, int y) {
        if (this.hist == null) {
            return false;
        }
        HistItem oOnMouse = this.onMouse;
        for (int i = 0; i < this.hist.length; ++i) {
            if (!this.hist[i].in(x, y)) continue;
            this.onMouse = this.hist[i];
            return this.onMouse != oOnMouse;
        }
        boolean rep = this.onMouse != null;
        this.onMouse = null;
        return rep;
    }

    protected boolean inCroix(int x, int y) {
        return x >= this.width - 5 - 2 && y <= 7;
    }

    boolean isNumeric() {
        return this.hist != null && this.hist.length > 0 && this.hist[0].categorie == null;
    }

    protected void draw(Graphics g) {
        this.draw(g, 0, 0);
    }

    protected void draw(Graphics g, int dx, int dy) {
        int pos;
        String s;
        g.clearRect(1 + dx, 1 + dy, this.width - 2, this.height - 2);
        if (this.hist == null) {
            return;
        }
        int gap = this.GAP;
        double larg = (double)(this.width - this.MARGE - gap * (this.hist.length + 1)) / (double)this.hist.length;
        double x = gap + this.MARGE;
        int y = this.height - 12;
        g.setFont(Aladin.SSBOLD);
        FontMetrics fm = g.getFontMetrics();
        if (!this.isOverFlow()) {
            for (int i = 0; i < this.hist.length; ++i) {
                g.setColor(Color.black);
                if (this.hist[i].categorie == null) {
                    if (i == 0) {
                        g.drawString(Util.myRound(this.hist[i].min), 2 + dx, this.height - 2 + dy);
                    } else if (i == this.hist.length - 1) {
                        s = Util.myRound(this.hist[i].max);
                        g.drawString(s, this.width - fm.stringWidth(s) + dx, this.height - 2 + dy);
                    }
                } else {
                    s = this.hist[i].categorie;
                    while (fm.stringWidth(s) > this.hist[i].larg) {
                        s = s.substring(0, s.length() - 1);
                    }
                    if (s != this.hist[i].categorie) {
                        s = s + "..";
                    }
                    g.drawString(s, this.hist[i].x + this.hist[i].larg / 2 - fm.stringWidth(s) / 2 + dx, this.height - 2 + dy);
                }
                if (this.flagHistPartial && i == this.hist.length - 1) {
                    for (int j = 0; j < 3; ++j) {
                        g.setColor(Color.black);
                        Util.fillCircle5(g, (int)(x + (double)gap + (double)(j * 6)) + dx, y - 15 + dy);
                    }
                    continue;
                }
                g.setColor(this.hist[i] == this.onMouse ? Aladin.GREEN : Color.cyan);
                g.fillRect((int)x + dx, y - this.hist[i].haut + dy, (int)larg, this.hist[i].haut);
                g.setColor(Color.black);
                g.drawRect((int)x + dx, y - this.hist[i].haut + dy, (int)larg, this.hist[i].haut);
                this.hist[i].x = (int)x;
                this.hist[i].y = y - this.hist[i].haut;
                this.hist[i].larg = (int)larg;
                x += larg + (double)gap;
            }
        }
        boolean bl = this.aladin.view.flagHighlight = this.onMouse != null && !this.flagHistPixel;
        if (this.onMouse != this.oOnMouse) {
            this.setHighlightSource();
            this.aladin.view.repaint();
        }
        this.oOnMouse = this.onMouse;
        g.setFont(Aladin.BOLD);
        g.setColor(Color.blue);
        fm = g.getFontMetrics();
        if (this.onMouse != null) {
            g.setColor(Color.red);
            s = this.onMouse.nb + "";
            g.drawString(s, 5, 14);
            pos = 8 + fm.stringWidth(s);
            g.setColor(Color.blue);
            s = Util.myRound(this.onMouse.prop + "", 1) + "%";
            int pos2 = this.width - fm.stringWidth(s) - 12;
            g.drawString(s, pos2, 14);
            s = this.onMouse.categorie == null ? Util.myRound(this.onMouse.min) + "," + Util.myRound(this.onMouse.max) : this.onMouse.categorie;
            x = (this.width - 5) / 2 - fm.stringWidth(s) / 2;
            if (x < (double)pos && (x = (double)((pos + pos2) / 2 - fm.stringWidth(s) / 2)) < (double)pos) {
                x = pos;
            }
            g.drawString(s, (int)x, 14);
        } else {
            s = this.titre;
            if (this.nbCategorie > 0) {
                s = s + " (" + this.nbCategorie + " item" + (this.nbCategorie > 1 ? "s)" : ")");
            }
            if (s != null) {
                g.drawString(s, 5, 14);
            }
        }
        g.setColor(Color.black);
        g.drawLine(gap - 2 + this.MARGE, y, this.width - 2 * gap + 2, y);
        if (!this.isOverFlow() && this.hist.length >= 4) {
            pos = (int)((double)this.hist.length * ((double)(this.height - 5) - 15.0) / 30.0);
            int xc = this.MARGE / 2 + 1;
            g.setColor(Color.gray);
            g.drawLine(xc - 1, 21, xc - 1, this.height - 15);
            g.setColor(Color.black);
            g.fillPolygon(new Polygon(new int[]{xc - 3, xc + 2, xc - 3}, new int[]{pos - 3, pos, pos + 3}, 3));
        }
        if (!this.flagHistPixel) {
            int w = 5;
            g.setColor(Aladin.BKGD);
            g.fillRect(this.width - w - 4, 1, w + 4, w + 4);
            g.setColor(Color.red);
            g.drawLine(this.width - w - 3, 2, this.width - 3, w + 2);
            g.drawLine(this.width - w - 3, 3, this.width - 3, w + 3);
            g.drawLine(this.width - w - 3, w + 2, this.width - 3, 2);
            g.drawLine(this.width - w - 3, w + 3, this.width - 3, 3);
        }
        if (this.texte != null) {
            g.setFont(Aladin.SBOLD);
            fm = g.getFontMetrics();
            g.setColor(Color.red);
            StringTokenizer st = new StringTokenizer(this.texte, "/");
            y = 17;
            int h = fm.getHeight();
            int h1 = fm.getAscent();
            g.setColor(Color.black);
            while (st.hasMoreTokens()) {
                s = st.nextToken().trim();
                int len = fm.stringWidth(s);
                int x1 = this.width - len - 5;
                Util.drawCartouche(g, x1, y, len, h, 0.8f, null, Color.white);
                g.drawString(s, x1, y + h1);
                y += h;
            }
        }
    }

    class HistItem {
        int nb = 0;
        double prop;
        double min;
        double max;
        String categorie;
        int larg;
        int haut;
        int x;
        int y;

        HistItem() {
        }

        boolean in(int xc, int yc) {
            return xc >= this.x && xc <= this.x + this.larg;
        }

        boolean contains(double value) {
            return this.min <= value && value < this.max;
        }
    }
}

