/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.tools.Util;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.swing.JComponent;

public final class Help
extends JComponent
implements MouseMotionListener,
MouseListener {
    String text;
    Font font = FI;
    FontMetrics fm = null;
    int ws = 520;
    int hs = 520;
    boolean flagFold = true;
    Aladin aladin;
    static final Font FI = Aladin.LPLAIN;
    static final Font FG;
    static final Font FTITRE;
    static int dy;
    String DEFAUT;
    String VIEW;
    Stack stack = new Stack();
    private boolean center = false;
    private static final int MAXLINK = 200;
    private String[] link = new String[200];
    private Rectangle[] xyLink = new Rectangle[200];
    private int nbLink = 0;
    private int ostyle = 0;
    private int owidth = -1;
    private int oheight = -1;

    protected Help(Aladin aladin) {
        this.aladin = aladin;
        this.setBackground(Color.white);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
    }

    protected String H() {
        if (this.VIEW == null) {
            this.VIEW = Aladin.chaine.getString("View.HELP");
        }
        return this.VIEW;
    }

    protected void setText(String text) {
        this.flagFold = true;
        if (text != null && text.length() > 1) {
            if (text.charAt(0) == '-') {
                this.font = Aladin.PLAIN;
                text = text.substring(1);
            } else if (text.charAt(0) == '|') {
                this.flagFold = false;
                this.font = Aladin.COURIER;
                text = text.substring(1);
            }
        } else {
            this.font = FI;
        }
        this.fm = null;
        this.text = text;
        this.repaint();
    }

    protected void setHyperText(String link, String text) {
        this.resetLink();
        if (link != null) {
            this.stack(link);
        }
        this.setText(text);
    }

    private void goBack() {
        this.stack.pop();
        this.aladin.command.execHelpCmd((String)this.stack.pop());
    }

    private void stack(String link) {
        this.stack.push(link);
    }

    protected void resetStack() {
        while (!this.stack.empty()) {
            this.stack.pop();
        }
    }

    private int hasStack() {
        return this.stack.size() - 1;
    }

    protected void setDefault() {
        if (this.DEFAUT == null) {
            this.DEFAUT = Aladin.chaine.getString("Help.HELP");
        }
        this.setText(this.DEFAUT);
    }

    protected void setCenter(boolean center) {
        this.center = center;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.getLink(e.getX(), e.getY()) != null) {
            Aladin.makeCursor(this, 2);
        } else {
            Aladin.makeCursor(this, 0);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.aladin.status.setText("");
        if (this.aladin.inHelp) {
            this.setText(this.H());
            this.repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        String wordLink;
        if (this.aladin.msgOn) {
            this.aladin.endMsg();
        }
        if ((wordLink = this.getLink(e.getX(), e.getY())) != null) {
            if (wordLink.equals("Home")) {
                this.resetStack();
                wordLink = "";
            }
            if (wordLink.equals("Back")) {
                this.goBack();
            } else {
                this.aladin.command.execHelpCmd(wordLink);
            }
        } else {
            this.aladin.helpOff();
        }
    }

    int getTextHeight(Graphics g, String s, int x, int y) {
        return this.drawString1(g, s, x, y, false);
    }

    int drawString(Graphics g, String s, int x, int y) {
        return this.drawString1(g, s, x, y, true);
    }

    private int drawString1(Graphics g, String s, int x, int y, boolean draw) {
        boolean ligneVide;
        Aladin imo;
        boolean flag_center = false;
        Container container = imo = this.aladin.isFullScreen() ? this.aladin.fullScreen.viewSimple : this.aladin;
        if (this.fm == null) {
            return y;
        }
        dy = this.fm.getHeight();
        boolean bl = ligneVide = s.trim().length() == 0;
        if (s.charAt(0) == '%' || (flag_center = s.indexOf("*%") == 0)) {
            String imgFile = s.substring(flag_center ? 2 : 1);
            Image i = this.aladin.getImagette(imgFile);
            if (i == null) {
                return y;
            }
            if (flag_center) {
                x = this.ws / 2 - i.getWidth(imo) / 2;
            }
            if (draw) {
                g.drawImage(i, x, y, imo);
            }
            return y += i.getHeight(imo) + dy;
        }
        if (s.charAt(0) == '!') {
            g.setFont(FTITRE);
            x = this.ws / 2 - this.fm.stringWidth(s) / 2;
            y += dy / 2;
            if (draw) {
                g.drawString(s.substring(1), x, y);
            }
            y = (int)((double)y + 1.5 * (double)dy);
            g.setFont(this.font);
            return y;
        }
        if (s.charAt(0) == '*' || this.center) {
            if (s.charAt(0) == '*') {
                s = s.substring(1);
            }
            x = this.ws / 2 - this.fm.stringWidth(s) / 2;
            if (draw) {
                g.drawString(s, x, y);
            }
            return y += dy;
        }
        boolean flagLink = false;
        StringTokenizer st = new StringTokenizer(s, " \t,|(.", true);
        while (st.hasMoreTokens()) {
            int w;
            String mot = st.nextToken();
            int style = 0;
            int n = mot.length();
            if (n > 1 && mot.charAt(0) == '@') {
                flagLink = true;
                mot = mot.substring(1);
                --n;
            } else {
                flagLink = false;
            }
            if (n > 2 && mot.charAt(0) == '#' && mot.charAt(n - 1) == '#') {
                style = 2;
                mot = mot.substring(1, n - 1);
                n -= 2;
            }
            if (n > 2 && mot.charAt(0) == '_' && mot.charAt(n - 1) == '_') {
                style |= 1;
                mot = mot.substring(1, n - 1);
                n -= 2;
            }
            if (mot.length() >= 2 && mot.startsWith("\\@")) {
                mot = mot.substring(1);
            }
            if (x + (w = this.fm.stringWidth(mot)) > this.ws) {
                x = 10;
                y += dy;
                if (mot.equals(" ")) continue;
            }
            if (!draw) continue;
            x = this.drawWord(g, mot, x, y, flagLink, style);
        }
        return y + (ligneVide ? dy - 8 : dy);
    }

    private void resetLink() {
        this.nbLink = 0;
    }

    private boolean addLink(String word, int x, int y, int w, int h) {
        if (this.nbLink == 200) {
            return false;
        }
        this.link[this.nbLink] = word;
        this.xyLink[this.nbLink++] = new Rectangle(x, y, w, h);
        return true;
    }

    private String getLink(int x, int y) {
        for (int i = 0; i < this.nbLink; ++i) {
            if (!this.xyLink[i].contains(x, y)) continue;
            return this.link[i];
        }
        return null;
    }

    private int drawWord(Graphics g, String word, int x, int y, boolean flagLink, int style) {
        Color c = null;
        if (style != this.ostyle) {
            this.ostyle = style;
            g.setFont(g.getFont().deriveFont(style));
            this.fm = g.getFontMetrics();
        }
        int w = this.fm.stringWidth(word);
        if (flagLink) {
            flagLink = this.addLink(word, x, y + 2 - dy, w, dy);
        }
        if (flagLink) {
            c = g.getColor();
            g.setColor(Color.blue);
            g.drawLine(x, y + 2, x + w, y + 2);
        }
        g.drawString(word, x, y);
        if (c != null) {
            g.setColor(c);
        }
        return x + w;
    }

    @Override
    public void paintComponent(Graphics g) {
        String s;
        boolean flagBanner;
        block17: {
            super.paintComponent(g);
            g.setFont(this.font);
            this.aladin.setAliasing(g);
            if (this.fm == null) {
                this.fm = g.getFontMetrics();
            }
            if (this.text == null) {
                return;
            }
            this.ws = this.getSize().width;
            this.hs = this.getSize().height;
            if (this.owidth != this.ws || this.oheight != this.hs) {
                this.resetLink();
                this.owidth = this.ws;
                this.oheight = this.hs;
            }
            g.setColor(Color.white);
            g.fillRect(2, 2, this.ws - 3, this.hs - 3);
            Util.drawEdge(g, this.ws, this.hs);
            boolean bl = flagBanner = Aladin.OUTREACH && this.center;
            if (flagBanner) {
                try {
                    g.drawImage(this.aladin.getImagette("Background.jpg"), 0, 0, this.ws, this.hs, this);
                }
                catch (Exception e) {
                    if (Aladin.levelTrace < 3) break block17;
                    e.printStackTrace();
                }
            }
        }
        StringTokenizer st = new StringTokenizer(this.text, "\n");
        int x = 10;
        int y = 0;
        if (this.center) {
            while (st.hasMoreElements()) {
                s = (String)st.nextElement();
                if (s.startsWith("BETA:")) {
                    if (!Aladin.BETA) continue;
                    s = s.substring("BETA:".length());
                }
                if (s.startsWith("PROTO:")) {
                    if (!Aladin.PROTO) continue;
                    s = s.substring("PROTO:".length());
                }
                y = this.getTextHeight(g, s, x - 2, y - 2);
            }
            y = this.getHeight() / 2 - y / 2;
            if (y < 15) {
                y = 15;
            }
        } else {
            y = 15;
        }
        st = new StringTokenizer(this.text, "\n");
        x = 10;
        g.setColor(flagBanner ? Color.white : Aladin.BLUEHELP);
        while (st.hasMoreElements()) {
            s = (String)st.nextElement();
            if (s.startsWith("BETA:")) {
                if (!Aladin.BETA) continue;
                s = s.substring("BETA:".length());
            }
            if (s.startsWith("PROTO:")) {
                if (!Aladin.PROTO) continue;
                s = s.substring("PROTO:".length());
            }
            y = this.drawString(g, s, x - 2, y - 2);
        }
        if (this.hasStack() > 0) {
            this.drawWord(g, "Back", this.ws - 40, 15, true, 0);
        }
        if (this.hasStack() > 1) {
            this.drawWord(g, "Home", this.ws - 80, 15, true, 0);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    static {
        FTITRE = FG = Aladin.LBOLD;
        dy = -1;
    }
}

