/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.HealpixKey;
import cds.aladin.Legende;
import cds.aladin.MyInputStream;
import cds.aladin.Pcat;
import cds.aladin.PlanBG;
import cds.aladin.PlanBGCat;
import cds.aladin.Source;
import cds.aladin.ViewSimple;
import cds.tools.Util;
import java.awt.Graphics;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class HealpixKeyCat
extends HealpixKey {
    Pcat pcat = null;
    int mem = 0;
    boolean last;
    int nLoaded;
    int nTotal;
    private static final char[] LAST = new char[]{'#', 'l', 'a', 's', 't', ' ', 'l', 'e', 'v', 'e', 'l'};
    private static final char[] NLOADED = new char[]{'#', ' ', 'n', 'L', 'o', 'a', 'd', 'e', 'd', ':', ' '};
    private static final char[] COMPLETENESS = new char[]{'#', ' ', 'C', 'o', 'm', 'p', 'l', 'e', 't', 'e', 'n', 'e', 's', 's', ' ', '='};

    protected HealpixKeyCat(PlanBG planBG) {
        super(planBG);
    }

    protected HealpixKeyCat(PlanBG planBG, int order, long npix) {
        super(planBG, order, npix, 1);
        this.last = false;
        this.nTotal = 0;
    }

    @Override
    protected void updateCacheIfRequired(int time) throws Exception {
    }

    @Override
    protected long loadCache(String filename) throws Exception {
        this.loadTSV(filename);
        this.stream = null;
        return 0L;
    }

    @Override
    protected long loadNet(String filename) throws Exception {
        this.loadTSV(filename);
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTSV(String filename) throws Exception {
        this.pcat = new Pcat(this.planBG);
        this.stream = this.loadStream(filename);
        this.mem = this.stream.length;
        MyInputStream in = null;
        try {
            block9: {
                try {
                    this.testLast(this.stream);
                    this.testNLoaded(this.stream);
                    this.testCompleteness(this.stream);
                }
                catch (Exception e) {
                    if (Aladin.levelTrace < 3) break block9;
                    e.printStackTrace();
                }
            }
            Aladin cfr_ignored_0 = this.planBG.aladin;
            int trace = Aladin.levelTrace;
            Aladin cfr_ignored_1 = this.planBG.aladin;
            Aladin.levelTrace = 0;
            Legende leg = this.planBG.getFirstLegende();
            if (leg != null) {
                this.pcat.setGenericLegende(leg);
            }
            in = new MyInputStream(this.getInputStreamFromStream());
            in.setFileName(filename);
            this.pcat.tableParsing(in, null);
            Aladin cfr_ignored_2 = this.planBG.aladin;
            Aladin.levelTrace = trace;
            if (!this.planBG.useCache) {
                this.stream = null;
            }
            if (leg == null) {
                ((PlanBGCat)this.planBG).setLegende(((Source)this.pcat.iterator().next()).leg);
            }
            this.recomputePosition(leg, this.pcat);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    protected InputStream getInputStreamFromStream() throws Exception {
        return new ByteArrayInputStream(this.stream);
    }

    public void recomputePosition(Legende leg, Pcat pcat) {
        if (this.planBG.epoch == null || this.planBG.getEpoch().toString("J").equals("J2000")) {
            return;
        }
        int npmra = leg.getPmRa();
        int npmde = leg.getPmDe();
        if (npmra <= 0 || npmde <= 0) {
            return;
        }
        int nra = leg.getRa();
        int nde = leg.getDe();
        this.planBG.recomputePosition(pcat.iterator(), leg, nra, nde, npmra, npmde);
    }

    private void testLast(byte[] stream) {
        if (stream.length < LAST.length) {
            return;
        }
        for (int i = 0; i < LAST.length; ++i) {
            if (LAST[i] == stream[i]) continue;
            return;
        }
        this.last = true;
    }

    private void testNLoaded(byte[] stream) {
        int fin;
        if (stream.length < NLOADED.length) {
            return;
        }
        for (int i = 0; i < NLOADED.length; ++i) {
            if (NLOADED[i] == stream[i]) continue;
            return;
        }
        int deb = NLOADED.length;
        int slash = 0;
        for (fin = NLOADED.length; fin < stream.length && stream[fin] != 10 && stream[fin] != 13 && stream[fin] != 32; ++fin) {
            if (stream[fin] != 47) continue;
            slash = fin;
        }
        if (slash == 0) {
            return;
        }
        if (fin == stream.length) {
            return;
        }
        try {
            this.nLoaded = Integer.parseInt(new String(stream, deb, slash - deb));
            this.nTotal = Integer.parseInt(new String(stream, slash + 1, fin - (slash + 1)));
            this.last = this.nLoaded == this.nTotal;
        }
        catch (Exception e) {
            this.nLoaded = 1;
            this.nTotal = 2;
            this.last = false;
        }
    }

    private void testCompleteness(byte[] stream) {
        int fin;
        if (stream.length < COMPLETENESS.length) {
            return;
        }
        for (int i = 0; i < COMPLETENESS.length; ++i) {
            if (COMPLETENESS[i] == stream[i]) continue;
            return;
        }
        int deb = COMPLETENESS.length;
        int slash = 0;
        for (fin = COMPLETENESS.length; fin < stream.length && stream[fin] != 10 && stream[fin] != 13; ++fin) {
            if (stream[fin] != 47) continue;
            slash = fin;
        }
        if (slash == 0) {
            return;
        }
        if (fin == stream.length) {
            return;
        }
        try {
            this.nLoaded = Integer.parseInt(new String(stream, deb, slash - deb).trim());
            this.nTotal = Integer.parseInt(new String(stream, slash + 1, fin - (slash + 1)).trim());
            this.last = this.nLoaded == this.nTotal;
        }
        catch (Exception e) {
            this.nLoaded = 1;
            this.nTotal = 2;
            this.last = false;
        }
    }

    protected boolean isLast() {
        return this.last;
    }

    protected boolean isReallyLast(ViewSimple v) {
        return this.last;
    }

    @Override
    protected int writeCache() throws Exception {
        int n = this.writeStream();
        this.stream = null;
        return n;
    }

    @Override
    protected int free() {
        return this.free(true);
    }

    protected int free(boolean force) {
        if (this.allSky) {
            return 0;
        }
        int status = this.getStatus();
        if (status == 4 || status == 5) {
            this.abort();
        } else if (status == 6 && this.planBG.useCache) {
            this.write();
        }
        if (this.pcat != null) {
            if (!force && this.pcat.hasSelectedOrTaggedObj()) {
                return 0;
            }
            this.pcat.free();
            this.mem = 0;
        }
        ++this.planBG.nbFree;
        this.setStatus(0);
        return 1;
    }

    @Override
    protected void clearBuf() {
    }

    @Override
    protected int getMem() {
        return this.mem;
    }

    @Override
    protected int draw(Graphics g, ViewSimple v) {
        return this.draw1(g, v, false);
    }

    protected int drawOnlySelected(Graphics g, ViewSimple v) {
        return this.draw1(g, v, true);
    }

    private int draw1(Graphics g, ViewSimple v, boolean onlySelected) {
        if (this.pcat == null || !this.pcat.hasObj()) {
            return 0;
        }
        int nb = this.pcat.draw(g, null, v, true, onlySelected, 0, 0);
        this.resetTimer();
        return nb;
    }

    private int getCounts() {
        if (this.getStatus() == 6 && this.pcat != null) {
            return this.pcat.getCount();
        }
        return 0;
    }

    @Override
    public String toString() {
        int status = this.getStatus();
        String code = status == 5 || status == 4 ? "**" : (status == 3 || status == 2 ? " x" : " .");
        return code + "[" + Util.align(this.priority + "", 5) + "] " + Util.align(this.getStringNumber(), 8) + Util.align(this.getCounts() + "s", 8) + Util.align(this.getLongFullMem(), 8) + Util.align(this.getStatusString(), 16) + (this.timer == -1L ? -1L : this.getCurrentLiveTime() / 1000L) + "s => " + VIE[-this.getLive()] + (this.getStatus() == 6 ? (this.fromNet ? " Net" : " Cache") + ":" + this.timeStream + "ms" : "") + (this.isLast() ? " last" : "") + (this.nTotal != 0 ? " " + this.nLoaded + "/" + this.nTotal : "");
    }
}

